/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "GetMetadataEvent.h"
#include <string>
#include "Om.h"
#include "OSCSender.h"
#include "OmObject.h"

using std::string;
namespace Om {


GetMetadataEvent::GetMetadataEvent(Request request, const string& node_path, const string& key)
: SlowEvent(request),
  m_path(node_path),
  m_key(key),
  m_value(""),
  m_object(NULL)
{
}


void
GetMetadataEvent::prepare()
{
	m_object = om->path_parser()->find_object(m_path);
	if (m_object == NULL) {
		SlowEvent::prepare();
		return;
	}

	m_value = m_object->get_metadata(m_key);
	
	SlowEvent::prepare();
}


void
GetMetadataEvent::execute(uint sample_offset)
{
	// Do nothing
	
	SlowEvent::execute(sample_offset);
}


void
GetMetadataEvent::post_process()
{
	if (m_value == "") {
		string msg = "Unable to find object ";
		msg += m_path;
		m_request.respond_error(msg);
	} else {
		m_request.respond_ok();
		//om->osc_sender()->send_response(*m_value);
	}
}


} // namespace Om

