/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef INPUTNODE_H
#define INPUTNODE_H

#include <string>
#include "InternalNode.h"
#include "InputPort.h"

using std::string;

namespace Om {


/** A node to represent input ports on a patch
 *
 * A patch doesn't actually contain any ports, it's port accessor methods
 * directly return ports in this node.  This is why a port on this module
 * is really two port objects - one from the internal perspective (ie
 * a port on this node in a patch), and one from the external perspective (ie
 * a port on the patch itself, being a node as well in some other patch).
 *
 * \ingroup engine
 */
class InputNode : public InternalNode
{
public:
	virtual ~InputNode() {}
	
	void run(size_t nframes) { InternalNode::run(nframes); assert(m_ports.at(0)->buffer(0) == m_external_port->buffer(0)); }

	InputPort* external_port() const { return m_external_port; }

protected:	
	InputNode(const string& path, uint poly, Patch* parent, samplerate srate, size_t buffer_size)
	: InternalNode(path, poly, parent, srate, buffer_size)
	{}

	ListNode<InputNode*>* m_listnode;
	InputPort*  m_external_port;
	// m_ports is used for internal port
};


} // namespace Om

#endif // INPUTNODE_H
