/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "Maid.h"
#include "MaidObject.h"

#include <iostream>

namespace Om {


uint MaidObject::m_count = 0; // ew


Maid::Maid(uint size)
: m_quit_flag(false),
  m_objects(size)
{
	//pthread_mutex_init(&m_cleanup_mutex, NULL);
	//pthread_cond_init(&m_cleanup_cond, NULL);
}


Maid::~Maid()
{
	stop();
}



/** Start the cleanup thread.
 */
void
Maid::start()
{
	pthread_create(&m_cleanup_thread, NULL, &Maid::cleanup_loop, this);
}


/** Destroy the cleanup thread.
 */
void
Maid::stop()
{
	m_quit_flag = true;
	/*pthread_mutex_lock(&m_cleanup_mutex);
	pthread_cond_signal(&m_cleanup_cond);
	pthread_mutex_unlock(&m_cleanup_mutex);
	*/
}


/** Push an event to be deleted.
 *
 * Realtime safe, to be called from Jack thread.
 */
void
Maid::push(MaidObject* obj)
{
	if (obj != NULL)
		m_objects.push(obj);
}	


/** Signal a cleanup.
 *
 * Realtime safe - doesn't do the deletion itself, signals the cleanup thread. 
 */
void
Maid::cleanup()
{
	/*if ( ! pthread_mutex_trylock(&m_cleanup_mutex)) {
		pthread_cond_signal(&m_cleanup_cond);
		pthread_mutex_unlock(&m_cleanup_mutex);
	}*/
}



// Private //


void*
Maid::cleanup_loop(void* m)
{
	return ((Maid*)m)->m_cleanup_loop();
}


void*
Maid::m_cleanup_loop()
{
	MaidObject* obj = NULL;
	
	while ( ! m_quit_flag) {
		//pthread_mutex_lock(&m_cleanup_mutex);
		nanosleep(&maid_rate, NULL);
		//pthread_cond_wait(&m_cleanup_cond, &m_cleanup_mutex);
		
		while ((obj = m_objects.front()) != NULL) {
			m_objects.pop();
			delete obj;
		}
		//pthread_mutex_unlock(&m_cleanup_mutex);
	}

	pthread_exit(NULL);
	return NULL;
}


} // namespace Om

