/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MIDIINNODE_H
#define MIDIINNODE_H

#include <string>
#include "InternalNode.h"

using std::string;

namespace Om {

class Patch;


/** (Almost pure) virtual base class for all MIDI input nodes.
 *
 * This is where the AlsaDriver hooks in to a patch to 'deliver' MIDI events.
 *
 * \ingroup engine
 */
class MidiInNode : public InternalNode
{
public:
	MidiInNode(const string& path, uint poly, Patch* parent, samplerate srate, size_t buffer_size);

	virtual void run(size_t nframes) = 0;

	virtual void activate();

	void add_to_patch(Patch* p);
	void remove_from_patch(Patch* p);

	virtual void note_on(int note_num, int velocity, int start_sample) {}
	virtual void note_off(int note_num, int start_sample) {}
	virtual void control(int control_num, int val, int start_sample) {}

private:
	ListNode<MidiInNode*>* m_listnode;
};


} // namespace Om

#endif // MIDIINNODE_H
