/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "PostProcessor.h"
#include "Om.h"
#include <cassert>

namespace Om {

bool PostProcessor::m_process_thread_exit_flag = false;


PostProcessor::PostProcessor(size_t queue_size)
: m_events(queue_size) // FIXME: figure out size
{
	//pthread_mutex_init(&m_process_mutex, NULL);
	//pthread_cond_init(&m_process_cond, NULL);
}


PostProcessor::~PostProcessor()
{
	stop();
}


/** Start the process thread.
 */
void
PostProcessor::start() 
{
	std::cerr << "[PostProcessor] Starting." << std::endl;

	pthread_create(&m_process_thread, NULL, process_events, this);
}


/** Stop the process thread.
 */
void
PostProcessor::stop()
{
	std::cerr << "[PostProcessor] Stopping." << std::endl;
	
	m_process_thread_exit_flag = true;
}


/** Push an event on to the process queue, realtime-safe, not thread-safe.
 */
void
PostProcessor::push(Event* const ev)
{
	m_events.push(ev);
}


/** Post-process all pending events - realtime-safe, thread-safe.
 *
 * Will not process if mutex cannot be locked.
 */
void
PostProcessor::process()
{
	/*if ( ! pthread_mutex_trylock(&m_process_mutex)) {
		pthread_cond_signal(&m_process_cond);
		pthread_mutex_unlock(&m_process_mutex);
	}*/
}


void*
PostProcessor::process_events(void* osc_processer)
{
	PostProcessor* me = (PostProcessor*)osc_processer;
	return me->m_process_events();
}


/** OSC message processing thread.
 */
void*
PostProcessor::m_process_events()
{
	Event* ev = NULL;
	
	while ( ! m_process_thread_exit_flag) {
		//pthread_mutex_lock(&m_process_mutex);
		nanosleep(&post_processor_rate, NULL);
		//pthread_cond_wait(&m_process_cond, &m_process_mutex);
		
		while (!m_events.empty()) {
			ev = m_events.pop();
			ev->post_process();
			delete ev;
		}
		//pthread_mutex_unlock(&m_process_mutex);
	}
	
	pthread_exit(NULL);
	return NULL;
}

} // namespace Om
