/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SLOWEVENTQUEUE_H
#define SLOWEVENTQUEUE_H

#include <cstdlib>
#include "types.h"

namespace Om {

class SlowEvent;


// FIXME: awful code duplication here, this can probably be implemented by
// wrapping, or possibly extending a Queue

// FIXME: the API of this is very different from Queue, returning NULL
// and whatnot.  not that it really matters, this is pretty Om specific


/** Queue of audio events.
 *
 * Implemented as a deque (ringbuffer) in an mlock'ed array.  Pushing and
 * popping are threadsafe, as long as a single thread pushes and a single
 * thread pops (ie one thread can NOT both push and pop)
 */
class SlowEventQueue
{
public:
	SlowEventQueue(uint size);
	~SlowEventQueue();

	void             push(SlowEvent* const ev);
	SlowEvent* const pop_before(const samplecount time);
	//SlowEvent* const peek();

	void signal_blocking_event_finished();

	void start();
	void stop();

private:
	SlowEvent* peek_any();

	uint        m_back;          // back of entire queue
	uint        m_prepared_back; // back of prepared section
	uint        m_front;
	uint        m_end_of_queue;
	const uint  m_size;
	SlowEvent** m_events;
	
	bool            m_prepare_thread_exit_flag;
	pthread_t       m_prepare_thread;
	pthread_mutex_t m_prepare_mutex;
	pthread_cond_t  m_prepare_cond;
	pthread_mutex_t m_blocking_mutex;
	pthread_cond_t  m_blocking_cond;
	bool            m_blocking;

	static void* prepare_loop(void* q) { return ((SlowEventQueue*)q)->m_prepare_loop(); }
	void* m_prepare_loop();
};


} // namespace Om

#endif // SLOWEVENTQUEUE_H
