/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "PatchModel.h"
#include "NodeModel.h"
#include "ConnectionModel.h"
#include <cassert>

namespace LibOmClient {


NodeModel*
PatchModel::get_node(const string& node_name)
{
	NodeModelMap::iterator i = m_nodes.find(node_name);

	return ((i != m_nodes.end()) ? (*i).second : NULL);
}


void
PatchModel::remove_node(const string& name)
{
	NodeModelMap::iterator i = m_nodes.find(name);
	if (i != m_nodes.end()) {
		delete i->second;
		m_nodes.erase(i);
		return;
	}/* else if (get_subpatch(name) != NULL) {
		remove_subpatch(name);
		return;
	}*/
	
	std::cerr << "[PatchModel::remove_node] Failed to find node!" << std::endl;
}


ConnectionModel*
PatchModel::get_connection(const string& src_port_path, const string& dst_port_path)
{
	for (list<ConnectionModel*>::iterator i = m_connections.begin(); i != m_connections.end(); ++i)
		if ((*i)->src_port_path() == src_port_path && (*i)->dst_port_path() == dst_port_path)
			return (*i);
	return NULL;
}


void
PatchModel::add_connection(ConnectionModel* cm)
{
	ConnectionModel* existing = get_connection(cm->src_port_path(), cm->dst_port_path());

	if (existing == NULL)
		m_connections.push_back(cm);
}


void
PatchModel::remove_connection(const string& src_port_path, const string& dst_port_path)
{
	ConnectionModel* cm = NULL;
	for (list<ConnectionModel*>::iterator i = m_connections.begin(); i != m_connections.end(); ++i) {
		cm = (*i);
		if (cm->src_port_path() == src_port_path && cm->dst_port_path() == dst_port_path) {
			delete cm;
			m_connections.erase(i);
			assert(get_connection(src_port_path, dst_port_path) == NULL); // no duplicates
			return;
		}
	}
	std::cerr << "[PatchModel::remove_connection] WARNING: Failed to find connection!" << std::endl;
	return;
}


} // namespace LibOmClient
