/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DEMOLITIONMODEL_H
#define DEMOLITIONMODEL_H


#include <vector>
using std::vector;
#include "PatchModel.h"

using namespace LibOmClient;

class DemolitionModel {
public:
	~DemolitionModel();

	PatchModel* random_patch();
	NodeModel*  random_node();
	PortModel*  random_port();
	
	void add_patch(PatchModel* pm) { m_patches.push_back(pm); }
	void remove_patch(const string& path);
	void add_node(NodeModel* nm);
	void remove_node(const string& path);
	void add_port(PortModel* pm);
	void remove_port(const string& path);
	void add_connection(ConnectionModel* cm);
	void remove_connection(const string& src_port_path, const string& dst_port_path);
	void add_plugin(PluginInfo* pi) { m_plugins.push_back(pi); }

private:
	vector<PluginInfo*> m_plugins;
	vector<PatchModel*> m_patches;
};


#endif // DEMOLITIONMODEL_H
