/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "NewPatchWindow.h"
#include <string>
#include "OmGtk.h"
#include "Controller.h"
#include "PatchModel.h"

namespace OmGtk {
using std::string;


NewPatchWindow::NewPatchWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& glade_xml)
: Gtk::Window(cobject)
{
	glade_xml->get_widget("new_patch_name_entry", m_name_entry);
	glade_xml->get_widget("new_patch_poly_spinbutton", m_poly_spinbutton);
	glade_xml->get_widget("new_patch_cancel_button", m_cancel_button);
	glade_xml->get_widget("new_patch_ok_button", m_ok_button);

	m_cancel_button->signal_clicked().connect(sigc::mem_fun(this, &NewPatchWindow::cancel_clicked));
	m_ok_button->signal_clicked().connect(sigc::mem_fun(this, &NewPatchWindow::ok_clicked));

}


void
NewPatchWindow::cancel_clicked()
{
	m_name_entry->set_text("");
	hide();
}


/** Create a new (toplevel) patch.
 */
void
NewPatchWindow::ok_clicked()
{
	string path = "/";
	path.append(m_name_entry->get_text());
	
	int poly = m_poly_spinbutton->get_value_as_int();
	
	controller->create_patch(new PatchModel(path, poly));
	m_name_entry->set_text("");
	hide();
}


} // namespace OmGtk
