/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OMGTKAPP_H
#define OMGTKAPP_H

#include <string>
#include <map>
#include <list>
#include <libgnomecanvasmm.h>
#include <libglademm/xml.h>
#include "PluginInfo.h"
using std::string; using std::map; using std::list;

namespace LibOmClient { class PatchModel; }
using namespace LibOmClient;

namespace Om { class PluginInfo; }
using Om::PluginInfo;


namespace OmGtk {
	
class PatchWindow;
class NewPatchWindow;
class LoadPatchWindow;


class PatchSelectorModelColumns : public Gtk::TreeModel::ColumnRecord
{
public:
	PatchSelectorModelColumns()
		{ add(path_col); add(patch_window_col); }
	
	Gtk::TreeModelColumn<Glib::ustring> path_col;
	Gtk::TreeModelColumn<PatchWindow*>  patch_window_col;
};



/** Master om_gtk class, virtually the entire app is contained within.
 *
 * \ingroup OmGtk
 */
class OmGtkApp
{
public:
	OmGtkApp();
	~OmGtkApp();

	void status_message(const string& msg);
	void error_message(const string& msg);

	void engine_enabled(bool e);

	inline PatchWindow* patch_window(const string& path) const
	{
		map<string, PatchWindow*>::const_iterator i = m_patch_windows.find(path);
		return (i == m_patch_windows.end()) ? NULL : (*i).second;
	}
	
	PatchWindow* add_patch_window(PatchModel* pm, bool show=false);
	void         destroy_patch_window(const string& path);
	
	void show_engine_error_dialog() { m_engine_error_dialog->show(); }

	const list<const PluginInfo*>& plugins() const { return m_plugin_infos; }
	
	Gtk::Window* window()  { return m_main_window; }
	
	Glib::RefPtr<Gnome::Glade::Xml> new_glade_reference(const string& toplevel_widget);
	
	void new_plugin(const PluginInfo* pi);
	
protected:
	void event_open_patch();
	void event_new_patch();
	void event_quit();
	void event_quit_and_kill();
	void event_process_toggled();
	void event_patch_selected();
	void event_show_about();
	bool idle_callback();

	Glib::ustring m_glade_filename;

	map<string, PatchWindow*> m_patch_windows;
	
	list<const PluginInfo*> m_plugin_infos;

	Gtk::Window*         m_main_window;
	NewPatchWindow*      m_new_patch_window;
	LoadPatchWindow*     m_load_patch_window;
	Gtk::Window*         m_about_window;
	Gtk::MenuItem*       m_menu_file_open_patch;
	Gtk::MenuItem*       m_menu_file_new_patch;
	Gtk::MenuItem*       m_menu_file_quit;
	Gtk::MenuItem*       m_menu_file_quit_and_kill;
	Gtk::CheckButton*    m_process_checkbutton;
	Gtk::MenuItem*       m_menu_help_about;
	Gtk::Button*         m_about_close_button;
	Gtk::TextView*       m_messages_textview;
	Gtk::ComboBox*       m_patch_selector;
	Gtk::Dialog*         m_engine_error_dialog;
	Gtk::Button*         m_engine_error_close_button;
	
	PatchSelectorModelColumns    m_patch_selector_columns;
	Glib::RefPtr<Gtk::ListStore> m_patch_selector_list_store;
};

} // namespace OmGtk

#endif // OMGTKAPP_H
