/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OMGTKSTATEMANAGER_H
#define OMGTKSTATEMANAGER_H

#include <string>
#include <list>
namespace LibOmClient { class PortModel; }
using LibOmClient::PortModel;

using std::string; using std::list;

namespace OmGtk {
	

/** State manager for the entire om_gtk app.
 *
 * Stores settings like color preferences, window locations, etc. 
 * (ie any user-defined preferences to be stoed in the rc file).
 *
 * \ingroup OmGtk
 */
class OmGtkStateManager
{
public:
	OmGtkStateManager();
	~OmGtkStateManager();

	//void load(std::string& filename);
	//void save(std::string& filename);

	//iCoord get_window_location();
	//void  set_window_location(iCoord loc);

	//iCoord get_window_size();
	//void  set_window_size(iCoord loc);

	const int get_port_color(const PortModel* pi);

private:
	//iCoord m_window_location;
	//iCoord m_window_size;

	int m_audio_port_color;
	int m_control_port_color;
};


} // namespace OmGtk

#endif // OMGTKSTATEMANAGER_H
	
