/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OMMODULE_H
#define OMMODULE_H

#include <string>
#include <iostream>
#include <libgnomecanvasmm.h>
#include "canvas/Module.h"
#include "MetadataModel.h"
#include "OmPort.h"
#include "OmGtk.h"
#include "Controller.h"
#include "PatchController.h"
#include "NodeModel.h"
#include "OmPatchBayArea.h"
using std::string; using std::list;
using std::cerr; using std::cout; using std::endl;

namespace LibOmClient { class PortModel; }
using namespace LibOmClient;

namespace OmGtk {
	
class NodeControlWindow;


/** A module in a patch.
 *
 * This base class is extended for various types of modules - SubpatchModule,
 * PluginModule, etc.
 *
 * \ingroup OmGtk
 */
class OmModule : public Module
{
public:
	virtual ~OmModule() { }
	
	virtual void add_port(PortModel* pi, bool resize=true) = 0;
	
	virtual OmPort* port(const string& port_name) {
		return (OmPort*)Module::port(port_name);
	}

	virtual void store_location()
	{
		/*m_patch_controller->model()->get_node(m_title)->x(property_x());
		m_patch_controller->model()->get_node(m_title)->y(property_y());*/
		m_node_model->x(property_x());
		m_node_model->y(property_y());

		char temp_buf[16];
		snprintf(temp_buf, 16, "%f", m_node_model->x());
		controller->set_metadata(m_node_model->path(), "module-x", temp_buf);
		snprintf(temp_buf, 16, "%f", m_node_model->y());
		controller->set_metadata(m_node_model->path(), "module-y", temp_buf);
	}
	
	void move_to(double x, double y)
	{
		Module::move_to(x, y);
		m_node_model->x(x);
		m_node_model->y(y);
		//store_location();
	}
	
	virtual void control_change(const ControlModel* const cm) {}
	virtual void metadata_update(const MetadataModel* const mm) {}
	virtual void port_metadata_update(const MetadataModel* const mm) {}

	virtual void show_dialog() = 0;
	void show_menu(GdkEvent* event) { m_menu.popup(event->button.button, event->button.time); }

	NodeModel* node_model() { return m_node_model; }

	virtual void menu_remove() = 0;
	virtual void menu_disconnect_all() { controller->disconnect_all(m_node_model->path()); }

protected:
	OmModule(OmPatchBayArea* patch_bay, NodeModel* node_model, PatchController* patch_controller)
	: Module(patch_bay, node_model->name(), node_model->x(), node_model->y()),
	  m_patch_controller(patch_controller),
	  m_node_model(node_model)
	{
		Gtk::Menu::MenuList& items = m_menu.items();
		items.push_back(Gtk::Menu_Helpers::MenuElem("Disconnect All",
			sigc::mem_fun(this, &OmModule::menu_disconnect_all)));
		items.push_back(Gtk::Menu_Helpers::MenuElem("Remove",
			sigc::mem_fun(this, &OmModule::menu_remove)));
		items.push_back(Gtk::Menu_Helpers::MenuElem("Show control window",
			sigc::mem_fun(this, &OmModule::show_dialog)));
		
		if (node_model->polyphonic() && node_model->parent()->poly() > 1) {
			m_module_box.property_width_units() = 2.0;
			m_module_box.property_outline_color_rgba() = 0x99AABBFF;
		}
	}

	Gtk::Menu        m_menu;
	PatchController* m_patch_controller;
	NodeModel*       m_node_model;
};


} // namespace OmGtk

#endif // OMMODULE_H
