/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OMPORT_H
#define OMPORT_H

#include <string>
#include <list>
#include <libgnomecanvasmm.h>
#include "canvas/Port.h"
#include "OmGtk.h"
#include "PortModel.h"
#include "OmGtkStateManager.h"

namespace LibOmClient { class PortModel; }
using namespace LibOmClient;
using namespace PatchBay;
using std::string; using std::list;

namespace OmGtk {
	
class PatchBayArea;
class PatchController;
class PatchWindow;


/** A Port on an OmModule.
 *
 * \ingroup OmGtk
 */
class OmPort : public PatchBay::Port
{
public:
	OmPort(PatchBay::Module* module, PatchController* patch_controller, PortModel* pm)
	: Port(module, pm->name(), pm->is_input(), state_manager->get_port_color(pm)),
	  m_port_info(pm),
	  m_patch_controller(patch_controller)
	{
	}

	virtual ~OmPort() {}

	PortModel*       port_info()        const { return m_port_info; }
	PatchController* patch_controller() const { return m_patch_controller; }
	
private:
	PortModel*       m_port_info;
	PatchController* m_patch_controller;
};


} // namespace OmGtk

#endif // OMPORT_H
