/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef PATCHCONTROLLER_H
#define PATCHCONTROLLER_H

#include <string>
#include "PatchModel.h"

namespace LibOmClient {
class PatchModel;
class NodeModel;
class PortModel;
class MetadataModel;
class ControlModel;
}

using std::string;
using namespace LibOmClient;

namespace OmGtk {
	
class PatchWindow;
class Controller;
class OmPatchBayArea;


/** Controller for a patch.
 *
 * This provides the methods for other parts of OmGtk (ie incoming OSC
 * messages, or GUI widgets) to control a patch bay window/widget.
 *
 * \ingroup OmGtk
 */
class PatchController
{
public:
	PatchController(PatchModel* patch_model, Controller* controller);
	
	void new_node(NodeModel* const nm);
	void node_removal(const string& name);
	void new_subpatch(PatchWindow* const pw);
	void new_port(PortModel* const pm);
	void remove_port(const string& path);
	void connection(ConnectionModel* const cm);
	void disconnection(const string& port1_path, const string& port2_path);
	void metadata_update(MetadataModel* const mm);
	void control_change(ControlModel* const cm);

	void get_new_module_location(int& x, int& y);

	const OmPatchBayArea* patch_bay()                 { return m_patch_bay; }
	void                  patch_bay(OmPatchBayArea* pb) { m_patch_bay = pb; }
	PatchModel*           model()                     { return m_patch_model; }
	const string          patch_name() const          { return m_patch_model->name(); }
	const string&         patch_path() const          { return m_patch_model->path(); }

private:
	OmPatchBayArea* m_patch_bay;
	PatchModel*     m_patch_model;
	Controller*     m_controller;
};


} // namespace OmGtk

#endif // PATCHCONTROLLER_H
