/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef PLUGINMODULE_H
#define PLUGINMODULE_H

#include <string>
#include <libgnomecanvasmm.h>
#include "OmModule.h"
using std::string; using std::list;

namespace LibOmClient {
class NodeModel;
class PortModel;
}
using namespace LibOmClient;

namespace OmGtk {
	
class OmPatchBayArea;
class NodeControlWindow;
class PatchController;

/** A module to represent a (LADSPA etc) plugin
 *
 * \ingroup OmGtk
 */
class PluginModule : public OmModule
{
public:
	PluginModule(OmPatchBayArea* patch_bay, NodeModel* nm, PatchController* patch_controller);

	virtual ~PluginModule();
	
	void add_port(PortModel* pm, bool resize=true);
	
	void control_change(const ControlModel* const cm);
	virtual void metadata_update(const MetadataModel* const mm);
	virtual void port_metadata_update(const MetadataModel* const mm);
	
	void         show_dialog();
	virtual void menu_remove();
	void         menu_learn();

protected:
	NodeControlWindow* m_dialog;
};


} // namespace OmGtk

#endif // PLUGINMODULE_H
