/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef MODULE_H
#define MODULE_H

#include <string>
#include <map>
#include <libgnomecanvasmm.h>
#include "Port.h"

using std::string; using std::multimap;

namespace PatchBay {
	
class PatchBayArea;


/** A module on the canvas.
 *
 * \ingroup Canvas
 */
class Module : public Gnome::Canvas::Group
{
public:
	Module(PatchBayArea* patch_bay, const string& name, double x=0, double y=0);
	virtual ~Module();
	
	bool module_event(GdkEvent* event);
	
	void width(double w);
	void height(double h);
	
	virtual void move_to(double x, double y);

	PatchBayArea*   patch_bay() const { return m_patch_bay; }
	const string&   name() const      { return m_name; }
	int             num_ports() const { return m_ports.size(); }
	PortList&       ports()           { return m_ports; }
		
	Port* port(const string& port_name);

	virtual void add_port(const string& port_name, bool is_input, int color, bool resize = true);
	virtual void remove_port(const string& port_name, bool resize = true);

	void zoom(float z);

	virtual void load_location()         {}
	virtual void store_location()        {}
	virtual void show_dialog()           {}
	virtual void show_menu(GdkEvent* ev) {}

	void resize();

protected:
	void add_port(Port* port, bool resize=true);

	double m_width;
	double m_height;
	string m_name;

	PatchBayArea* m_patch_bay;
	PortList      m_ports;

	Gnome::Canvas::Rect m_module_box;
	Gnome::Canvas::Text m_canvas_title;
};


typedef multimap<string,Module*> ModuleMap;


} // namespace PatchBay

#endif // MODULE_H
