/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "DSSIProgramEvent.h"
#include <cstdio>
#include "Om.h"
#include "Node.h"
#include "OSCSender.h"
#include "PluginInfo.h"

namespace Om {


DSSIProgramEvent::DSSIProgramEvent(Request request, const string& node_path, int bank, int program)
: SlowEvent(request),
  m_node_path(node_path),
  m_bank(bank),
  m_program(program),
  m_node(NULL)
{
}


void
DSSIProgramEvent::prepare()
{
	Node* node = om->path_parser()->find_node(m_node_path);

	if (node->plugin_info().type() != PluginInfo::DSSI)
		m_node = NULL;
	else
		m_node = (DSSIPlugin*)node;
}

	
void
DSSIProgramEvent::execute(uint sample_offset)
{
	if (m_node != NULL)
		m_node->program(m_bank, m_program);
}


void
DSSIProgramEvent::post_process()
{
	if (m_node == NULL) {
		std::cerr << "Unable to find DSSI node " << m_node_path << std::endl;
	} else {
		// sends program as metadata in the form bank/program
		char* temp_buf = new char[16];
		snprintf(temp_buf, 16, "%d/%d", m_bank, m_program);
		om->osc_sender()->send_metadata_update(m_node_path, "dssi-program", temp_buf);
	}
}


} // namespace Om

