/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MAID_H
#define MAID_H


#include <pthread.h>
#include <time.h>
#include "Queue.h"

namespace Om {

static const timespec maid_rate = { 1, 0 }; // 1 second

class MaidObject;


/** Holds a queue of objects that it deletes freely in it's own non-RT thread.
 *
 * This is how realtime parts of the code can schedule the deletion of
 * objects - push() is a realtime safe method.
 *
 * \ingroup engine
 */
class Maid
{
public:
	Maid(uint size);
	~Maid();

	void start();
	void stop();

	void push(MaidObject* obj);
	void cleanup();
	
private:
	static void* cleanup_loop(void* m);
	void*        m_cleanup_loop();
	
	bool               m_quit_flag;
	Queue<MaidObject*> m_objects;
	
	pthread_t       m_cleanup_thread;
	//pthread_mutex_t m_cleanup_mutex;
	//pthread_cond_t  m_cleanup_cond;
};


} // namespace Om

#endif // MAID_H

