/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MAIDOBJECT_H
#define MAIDOBJECT_H

namespace Om {

	
/** An object that can be passed to the maid for deletion.
 *
 * \ingroup engine
 */
class MaidObject
{
public:
	MaidObject()          { ++m_count; }
	virtual ~MaidObject() { --m_count; }

	static unsigned object_count() { return m_count; }

private:
	MaidObject(const MaidObject& copy) { throw; } // disallow copies

	/** Count of existing MaidObjects.  Used to check for leaks. */
	static unsigned m_count;
};


} // namespace Om

#endif // MAIDOBJECT_H
