/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MIDILEARNEVENT_H
#define MIDILEARNEVENT_H

#include <string>
#include <alsa/asoundlib.h>
#include "SlowEvent.h"
#include "types.h"

using std::string;

namespace Om {
	
class Port;
class MidiControlNode;
class Patch;


/** An event to "learn" the binding for a MidiControlNode.
 *
 * Note that this event follows a different path than other events - it is
 * handed to the AlsaDriver for processing, rather than pushed in to an
 * event queue.
 *
 * \ingroup engine
 */
class MidiLearnEvent : public SlowEvent
{
public:
	MidiLearnEvent(Request request, const string& node_path);
	
	void prepare();
	void execute(uint sample_offset);
	void post_process();

	// Special methods for this event only (not from SlowEvent)
	void set_control(const snd_seq_ev_ctrl_t& ctrl);
	Patch* patch()   { return m_patch; }

private:
	string           m_node_path;
	Patch*           m_patch;
	MidiControlNode* m_node;
	sample           m_value;
};


} // namespace Om

#endif // MIDILEARNEVENT_H
