/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef POSTPROCESSOR_H
#define POSTPROCESSOR_H

#include <pthread.h>
#include <ctime>
#include "types.h"
#include "Event.h"
#include "Queue.h"

using std::string;

namespace Om {


const timespec post_processor_rate = { 0, 500000000 }; // half second


/** Performs any post-execute() actions for events, then deletes them.
 *
 * \ingroup engine
 */
class PostProcessor
{
public:
	PostProcessor(size_t queue_size);
	~PostProcessor();

	void start();
	void stop();

	void push(Event* const ev);
	void process();

private:

	Queue<Event*> m_events;

	static void* process_events(void* me);
	void*        m_process_events();

	pthread_t       m_process_thread;
	//pthread_mutex_t m_process_mutex;
	//pthread_cond_t  m_process_cond;
	static bool     m_process_thread_exit_flag;
	
};


} // namespace Om

#endif // POSTPROCESSOR_H
