/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef REQUEST_H
#define REQUEST_H

#include <string>
#include <lo/lo.h>

using std::string;

namespace Om {

#define NOBODY NULL
#define NIL_REQUEST Request(NOBODY, 0)


/** Represents an OSC request from some client.
 *
 * These are created by the OSCReceiver and sent along with Events so the
 * Event can send responses back to the client on success/fail.
 */
class Request
{
public:
	Request(lo_address source, int id)
	: m_source(source),
	  m_id(id)
	{
	}
	
	void respond_ok();
	void respond_error(const string& msg);
	
	lo_address source() { return m_source; }
	int        id()     { return m_id; }

private:
	lo_address m_source;
	int        m_id;
};


} // namespace Om

#endif // REQUEST_H

