/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "SetControlEvent.h"
#include "Om.h"
#include "Port.h"
#include "OSCSender.h"
#include "PluginInfo.h"
#include "Node.h"
#include "InputNode.h"
#include "OutputNode.h"
#include "InputPort.h"
#include "OutputPort.h"

namespace Om {



/** Voice-specific control setting
 */
SetControlEvent::SetControlEvent(Request request, uint voice_num, const string& port_path, sample val)
: Event(request),
  m_voice_num(voice_num),
  m_port_path(port_path),
  m_val(val),
  m_port(NULL)
{
}


SetControlEvent::SetControlEvent(Request request, const string& port_path, sample val)
: Event(request),
  m_voice_num(-1),
  m_port_path(port_path),
  m_val(val),
  m_port(NULL)
{
}


void
SetControlEvent::execute(uint sample_offset)
{
	if (m_port == NULL)
		m_port = om->path_parser()->find_port(m_port_path);

	if (m_port != NULL) {
		if (m_voice_num == -1) 
			m_port->set_value(sample_offset, m_val);
		else
			m_port->set_value(m_voice_num, sample_offset, m_val); // FIXME: check range
	}
}


void
SetControlEvent::post_process()
{
	if (m_port != NULL) {
		m_request.respond_ok();
		om->osc_sender()->send_control_change(m_port_path, m_val, m_request);
		PluginInfo pi = m_port->node()->plugin_info();
		if (pi.type() == PluginInfo::Internal) {
			Port* parent_port = NULL;
			if (pi.plug_label() == "control_input" || pi.plug_label() == "audio_input")
				parent_port = ((InputNode*)m_port->node())->external_port();
			else if (pi.plug_label() == "control_output" || pi.plug_label() == "audio_output")
				parent_port = ((OutputNode*)m_port->node())->external_port();
			if (parent_port != NULL)
				om->osc_sender()->send_control_change(parent_port->path(), m_val, m_request);
		}	
	} else {
		string msg = "Unable to find port ";
		msg.append(m_port_path);
		m_request.respond_error(msg);
	}
}


} // namespace Om

