/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SETCONTROLEVENT_H
#define SETCONTROLEVENT_H

#include "Event.h"
#include "types.h"

namespace Om {

class Port;


/** An event to change the value of a port.
 *
 * \ingroup engine
 */
class SetControlEvent : public Event
{
public:
	SetControlEvent(Request request, const string& port_path, sample val);
	SetControlEvent(Request request, uint voice_num, const string& port_path, sample val);

	void execute(uint sample_offset);
	void post_process();

private:
	int    m_voice_num;
	string m_port_path;
	float  m_val;
	Port*  m_port;
};


} // namespace Om

#endif // SETCONTROLEVENT_H
