SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


DELIMITER $$
CREATE PROCEDURE `closest_members_optimized`(IN `units` VARCHAR(5), IN `lat` DECIMAL(10,7), IN `lon` DECIMAL(10,7), IN `max_distance` SMALLINT, IN `gender` TINYINT UNSIGNED, IN `look_for` TINYINT UNSIGNED, IN `age_beginning` TINYINT UNSIGNED, IN `age_end` TINYINT UNSIGNED, IN `last_connection` MEDIUMINT UNSIGNED, IN `rows_limit` MEDIUMINT, IN `rows_offset` MEDIUMINT)
BEGIN
   DECLARE ONE_DEGREE_CONSTANT TINYINT;
   DECLARE EARTH_RADIUS_CONSTANT SMALLINT;
   DECLARE lon1, lon2, lat1, lat2 float;  

  IF units = 'miles' THEN
     SET ONE_DEGREE_CONSTANT   = 69;
     SET EARTH_RADIUS_CONSTANT = 3959;
   ELSE 
     SET ONE_DEGREE_CONSTANT   = 111;
     SET EARTH_RADIUS_CONSTANT = 6371;
   END IF;  

  SET lon1 = lon-max_distance/abs(cos(radians(lat))*ONE_DEGREE_CONSTANT);
   SET lon2 = lon+max_distance/abs(cos(radians(lat))*ONE_DEGREE_CONSTANT);
   SET lat1 = lat-(max_distance/ONE_DEGREE_CONSTANT);
   SET lat2 = lat+(max_distance/ONE_DEGREE_CONSTANT);

  SELECT members.id, members.picture, members.pseudonym, members.birthdate, continents.name as contient_name, countries.name as country_name, cities.name as city_name, members.description, members.non_smoker, members.religion,
          ROUND((EARTH_RADIUS_CONSTANT * acos( cos( radians(lat) ) 
               * cos( radians(cities.latitude) ) 
               * cos( radians(cities.longitude) - radians(lon)) + sin(radians(lat)) 
               * sin( radians(cities.latitude)))
          ), 3) AS distance
   FROM members
   INNER JOIN continents ON members.continent = continents.id
   INNER JOIN countries ON members.country = countries.id
   INNER JOIN cities ON members.city = cities.id
   WHERE members.gender = gender
   AND members.look_for = look_for
   AND members.birthdate BETWEEN DATE_SUB(CURDATE(), INTERVAL age_end YEAR) AND DATE_SUB(CURDATE(), INTERVAL age_beginning YEAR)
   AND members.last_connection > DATE_SUB(NOW(), INTERVAL last_connection MINUTE)
   AND cities.longitude between lon1 and lon2 
   AND cities.latitude between lat1 and lat2
   ORDER BY distance ASC
   LIMIT rows_limit OFFSET rows_offset;
 END$$

CREATE PROCEDURE `number_of_closest_members_optimized`(IN `units` VARCHAR(5), IN `lat` DECIMAL(10,7), IN `lon` DECIMAL(10,7), IN `max_distance` SMALLINT, IN `gender` TINYINT UNSIGNED, IN `look_for` TINYINT UNSIGNED, IN `age_beginning` TINYINT UNSIGNED, IN `age_end` TINYINT UNSIGNED, IN `last_connection` MEDIUMINT UNSIGNED)
BEGIN
   DECLARE ONE_DEGREE_CONSTANT TINYINT;
   DECLARE EARTH_RADIUS_CONSTANT SMALLINT;
   DECLARE lon1, lon2, lat1, lat2 float;  

  IF units = 'miles' THEN
     SET ONE_DEGREE_CONSTANT   = 69;
     SET EARTH_RADIUS_CONSTANT = 3959;
   ELSE 
     SET ONE_DEGREE_CONSTANT   = 111;
     SET EARTH_RADIUS_CONSTANT = 6371;
   END IF;  

  SET lon1 = lon-max_distance/abs(cos(radians(lat))*ONE_DEGREE_CONSTANT);
   SET lon2 = lon+max_distance/abs(cos(radians(lat))*ONE_DEGREE_CONSTANT);
   SET lat1 = lat-(max_distance/ONE_DEGREE_CONSTANT);
   SET lat2 = lat+(max_distance/ONE_DEGREE_CONSTANT);

  SELECT COUNT(members.id) as number_of_members
   FROM members
   INNER JOIN continents ON members.continent = continents.id
   INNER JOIN countries ON members.country = countries.id
   INNER JOIN cities ON members.city = cities.id
   WHERE members.gender = gender
   AND members.look_for = look_for
   AND members.birthdate BETWEEN DATE_SUB(CURDATE(), INTERVAL age_end YEAR) AND DATE_SUB(CURDATE(), INTERVAL age_beginning YEAR)
   AND members.last_connection > DATE_SUB(NOW(), INTERVAL last_connection MINUTE)
   AND cities.longitude between lon1 and lon2 
   AND cities.latitude between lat1 and lat2;
 END$$

DELIMITER ;

CREATE TABLE IF NOT EXISTS `cities` (
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `asciiname` varchar(255) DEFAULT NULL,
  `alternatenames` varchar(10000) DEFAULT NULL,
  `latitude` decimal(10,7) DEFAULT NULL,
  `longitude` decimal(10,7) DEFAULT NULL,
  `country_code` char(2) DEFAULT NULL,
  `modification_date` date DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT '0'
) DEFAULT CHARSET=utf8;

INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(25, 'Zorkot', 'Zorkot', 'Vulusvali-Zorkot,Woludwali Zorkot,Woludwālī Zōṟkōt,Woluswali Zorkot,Woluswali Zurkowt,Woluswalī Zūrkowt,Woluswālī Zōṟkōt,Wuleswali Zor Kot,Wulêswālī Zōr Kōṯ,Zarkot,Zor Kot,Zorkot,Zowr Kowt,Zowṟ Kowṯ,Zur Kowt,Zurkot,Zōr Kōṯ,Zūr Kowṯ,Zūrkōt,زور کوټ', 33.5414900, 69.7344600, 'AF', '2013-04-03', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(26, 'Wulêswālī Bihsūd', 'Wuleswali Bihsud', 'Behsud,Behsūd,Markaz-e Bihsud,Markaz-e Bihsūd,Olusvali Behsowd,Olusvālī Behsowd,Oluswali Behsud,Oluswālī Behsūḏ,Ulusvali-Bikhsud,Wuleswali Bihsud,Wuluswali Bihsud,Wuluswālī Bihsūd,Wulêswālī Bihsūd,mrkz bhswd,wlswaly bhswd,مرکز بهسود,ولسوالی بهسود', 34.3436000, 67.9056700, 'AF', '2012-08-04', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(27, 'Kuhsān', 'Kuhsan', 'Kohistan,Kohsan,Kohsān,Koshan,Kuhestan,Kuhsan,Kuhsān,Kōhistān,Kūhestān,khsan,kwhstan,Кошан,کهسان,کوهستان', 34.6538900, 61.1977800, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(28, 'Lāsh', 'Lash', 'Kohestan,Kohestān,Laorlash,Laorlush,Las,Lash,Las̄,Laurlas,Laurlash,Lawlas,Lawlash,Lawlāsh,Lawlās̄,Lowlash,Lowlāsh,Lowr Lash,Lowr Lāsh,Lāorlash,Lāorlush,Lāsh,lash,lwlash,لاش,لولاش', 35.3782000, 64.7745700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(29, 'Tukzār', 'Tukzar', 'Kala Sangcharak,Kala Sangchārak,Qal`eh Sangcharek,Qala Sangcharak,Qal‘eh Sangchārek,Sangcarak,Sangcharak,Sangcārak,Takzar,Tokzar,Tokzār,Tuksar,Tukzar,Tukzār,Tākzār,Tūkzār,tkzar,twkzar,Токзар,توکزار,تکزار', 35.9483100, 66.4213200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(30, 'Mīray', 'Miray', 'Miray,Miri,Miṟay,Mīray,Mīrī,Salgar,Shalgar,S̄algaṟ,myry,ميری', 33.3246200, 68.4406800, 'AF', '2013-03-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(31, 'Āq Kupruk', 'Aq Kupruk', 'Ak Kuprak,Ak Kupruk,Aq Kubruk,Aq Kupruk,Keshendah,Keshende,Keshendeh,Keshindeh,Keshīndeh,aq kbrk,aq kprk,Āq Kubruk,Āq Kupruk,آق کبرک,آق کپرک', 36.0835200, 66.8402900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(32, 'Zurmat', 'Zurmat', 'Bazar-e Zurmat,Bāzār-e Zurmat,Zarmal,Zormat,Zurmat,Zuṟmat,bazar zrmt,zrmt,بازار زرمت,زرمت', 33.4377800, 69.0277400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(33, 'Zaybāk', 'Zaybak', 'Zaybak,Zaybāk,Zebak,Zeybak,Zeybāk,Zibak,Zēbāk,Zībāk,zybak,زیباک', 36.5294700, 71.3441000, 'AF', '2013-12-09', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(34, 'Zīārat-e Shāh Maqşūd', 'Ziarat-e Shah Maqsud', 'Sah Agha,Shab Maqsud,Shah Agha,Shah Maksud,Shah Maqsud,Shakhaga,Shāb Maqsūd,Shāh Maqsūd,Shāh Āghā,Ziarat Shah Maqsud,Ziarat-Shakh-Maksud,Ziarat-e Shah Maqsud,Ziārat Shāh Maqsūd,Zyarate Sah Maqsud,Zyārate Šāh Maqsūd,Zīārat-e Shāh Maqşūd,shah agha,zyart shah mqswd,Šah Āghā,زيارتٔ شاه مقصود,زیارت شاه مقصود,شاه آغا', 31.9848000, 65.4736000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(35, 'Zindah Jān', 'Zindah Jan', 'Fusanj,Fushanj,Fus̄anj,Fūshanj,Zendajan,Zendeh Jan,Zendeh Jān,Zenḏajān,Zindah Jan,Zindah Jān,Zindajan,Zindajān,zndh jan,زنده جان', 34.3426400, 61.7467500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(36, 'Zarghūn Shahr', 'Zarghun Shahr', 'Katawaz,Katāwāz,Khayr Kot,Khayr Kut,Khayr Kūṯ,Khayṟ Kot,Zaraghun Sahr,Zaraghūn S̄ahr,Zarghun Sahr,Zarghun Shahr,Zarghūn Shahr,Zargun Shahr,Zargunsahr,Zaṟghun Sahr,Zaṟgūns̄ahr,zrghwn shhr,زرغون شهر', 32.8473400, 68.4457300, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(37, 'Zaṟah Sharan', 'Zarah Sharan', 'Sharan,Sharnah,Sherana,Sheranna,Zara Saran,Zara Šaran,Zara-Sharan,Zarah Sharan,Zareh Sharan,Zaṟah Sharan,زړه شرن', 33.1464100, 68.7921300, 'AF', '2014-02-06', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(38, 'Zaranj', 'Zaranj', 'Sarandsch,ZAJ,Zaranas,Zarandj,Zarandz,Zarandzas,Zarandzh,Zarandż,Zarandžas,Zarang,Zarani,Zaranj,Zaranĝ,Zerenc,Zhazang,Zərənc,zaranja,zha lan ji,zrnj,Зарандж,Зарани,Заранҷ,زرنج,ज़रंज,扎兰季', 30.9596200, 61.8603700, 'AF', '2013-10-06', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(39, 'Zamtō Kêlay', 'Zamto Kelay', 'Zamto,Zamto Kalay,Zamto Kelay,Zamtukalay,Zamtō,Zamtō Kêlay,zmtw,zmtw kly,زمتو,زمتو کلی', 32.3726000, 66.1770800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(40, 'Yangī Qal‘ah', 'Yangi Qal`ah', 'Yangi Kala,Yangi Qal`ah,Yangi Qal`eh,Yangi Qala,Yangī Qal‘ah,Yangī Qal‘eh,Yengi Qal`eh,Yengī Qal‘eh,ینگی قلعه', 37.4657200, 69.6113100, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(41, 'Yaḩyá Khēl', 'Yahya Khel', 'Ya Khel,Yahya Khel,Yahya Kheyl,Yahyakhel,Yakh''yakheyl'',Yakh’yakheyl’,Yaḩyá Khēl,Yaḩyā Kheyl,Yaḩyākhēl,Yehyakhel,Yeḩyākhēl,یحیى خېل', 32.9374200, 68.6462200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(42, 'Wāshēr', 'Washer', 'Vashir,Vāshīr,Waser,Washar,Washayr,Washer,Washār,Wāshayr,Wāshēr,Wāsēṟ,washyr,واشیر', 32.2512200, 63.8555300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(43, 'Tōrmay', 'Tormay', 'Qal''ah-ye Tormay,Qal’ah-ye Tōrmay,Tormay,Turmay,Tōrmay,Tōṟmay,Tūrmay,twrmy,تورمی,قلعه تورمی', 33.6884700, 68.4020500, 'AF', '2013-01-09', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(44, 'Tūlak', 'Tulak', 'Tulak,Tūlak,twlk,تولک', 33.9750900, 63.7286800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(45, 'Tītān', 'Titan', 'Deh Titan,Deh Titān,Saghar,Sāghar,Titan,Tītān,saghr,tytan,تیتان,ساغر', 33.6903200, 63.8636100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(46, 'Tīr Pul', 'Tir Pul', 'Tir Pol,Tir Pul,Tirpul,Tīr Pol,Tīr Pul,tyr pl,تیر پل', 34.5943100, 61.2689500, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(47, 'Taywarah', 'Taywarah', 'Qal`eh-i-Ghor,Qal‘eh-i-Ghor,Taiwara,Taiwāra,Taywarah,Teyvareh,tywrh,تيوره', 33.5211800, 64.4211600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(48, 'Bāzār-e Tashkān', 'Bazar-e Tashkan', 'Bazar-e Tagan,Bazar-e Tashgan,Bazar-e Tashkan,Bazar-i-Teskan,Bāzār-e Tagān,Bāzār-e Tashgān,Bāzār-e Tashkān,Bāzāṟ-i-Tēs̄kān,Tashkan,Tashkān,Taskan,Tas̄kān,Teshkan,Teshkān,bazar tshkan,tshkan,بازار تشکان,تشکان', 36.8816800, 70.2767400, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(49, 'Tarinkot', 'Tarinkot', 'TII,Tareen,Tarin Kowt,Tarinkot,Tarīn Kowt,Tirin,Tirinkot,tryn kwt,ترين كوت', 32.6299800, 65.8780600, 'AF', '2013-08-02', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(50, 'Taloqan', 'Taloqan', 'Khanabad,TQN,Taikhan,Taleqan,Talikan,Talikhan,Taliqan,Talkan,Talokan,Taloqan,Talugan,Talukan,Talukanas,Taluqan,Tologan,Tâloqân,Tāleqān,Tāloqān,Tāluqān,Tālīqān,ta lu kan,talokam,talokuvan,taloqana,talqan,Таликан,Талукан,تالقان,तालोक़ान,तालोकां,தலோகுவான்,თალიკანი,塔卢坎', 36.7360500, 69.5345100, 'AF', '2013-05-11', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(51, 'Tagāw-Bāy', 'Tagaw-Bay', 'Bai,Bay,Bāy,Tagaw-Bay,Tagaw-bay,Tagaw-bāy,Tagow Bay,Tagow Bāy,Tagāw-Bāy,tgaw bay,تگاو بای', 35.6994100, 66.0616400, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(52, 'Tagāb', 'Tagab', 'Pagab,Tagab,Tagao,Tagāb,tgab,تگاب', 34.8550100, 69.6491700, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(53, 'Markaz-e Ḩukūmat-e Sulţān-e Bakwāh', 'Markaz-e Hukumat-e Sultan-e Bakwah', 'Bakva,Bakvā,Bakwah,Bakwāh,Markaz-e Hokumat-e Soltan-e Bakva,Markaz-e Hukumat-e Sultan-e Bakwa,Markaz-e Hukumat-e Sultan-e Bakwah,Markaz-e Ḩokūmat-e Solţān-e Bakvā,Markaz-e Ḩukūmat-e Sulţān-e Bakwā,Markaz-e Ḩukūmat-e Sulţān-e Bakwāh,Markaze Hokumate Sultane Bakwa,Markazi-Khukumati-Sultani-Bakva,Maṟkaze Ḩokūmate Sulṯāne Bakwā,Soltan Bakvah,Soltan-e Bakva,Solţān Bakvāh,Solţān-e Bakvā,Sultan Bakhwa,Sultan Bakwa,Sultan-e Bakwah,Sultane Bakwa,Sultān Bakhwa,Sultān Bakwa,Sulţān-e Bakwāh,Sulţāne Bakwā,mrkz hkwmt sltan bkwa,mrkz hkwmt sltan bkwah,sltan bkwah,سلطان بکواه,مرکز حکومت سلطان بکوا,مرکز حکومت سلطان بکواه', 32.2413900, 62.9493600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(54, 'Spīn Bōldak', 'Spin Boldak', 'Spin Baldak,Spin Boldak,Spin Buldak,Spīn Baldak,Spīn Bōldak,Spīn Būldak,spyn bwldk,سپین بولدک', 31.0057500, 66.4000100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(55, 'Spērah', 'Sperah', 'Spera,Sperah,Speyrah,Spērah,Spēṟa,spyrh,سپيره,سپېره', 33.2020400, 69.5152000, 'AF', '2014-04-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(56, 'Sōzmah Qal‘ah', 'Sozmah Qal`ah', 'Saozma Kala,Saozma Qala,Sowzmeh Qal`eh,Sowzmeh Qal‘eh,Sozmah Qal`ah,Sāozma Kala,Sōzmah Qal‘ah,سوزمه قلعه', 36.0991600, 66.2082300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(57, 'Siyāhgird', 'Siyahgird', 'Siah Gerd,Siah Gird,Siakhgird,Siyahgird,Siyāhgird,Siāh Gird,Syahgerd,Syāhgerd,Sīāh Gerd,syah grd,سیاه گرد', 35.0055300, 68.8557800, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(58, 'Sheywah', 'Sheywah', 'Kuz Konar,Kūz Konar,Sewa,Sheva,Shewa,Shewah,Sheywah,Shiveh,Shēwah,Shīveh,S̲h̲ēwah,shywh,Šēwa,شيوه,ښېوه', 34.5716900, 70.5885900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(59, 'Shīnḏanḏ', 'Shindand', 'Asfazar,Asfazār,OAH,Sabzavar,Sabzavār,Sabzawar,Sabzevar,Sabzevār,Shindand,Shīndand,Shīnḏanḏ,Sindand,shyndnd,Šīndand,Шинданд,شيندند,شیندند,شینډنډ', 33.3029400, 62.1474000, 'AF', '2017-02-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(60, 'Shaykh Amīr Kêlay', 'Shaykh Amir Kelay', 'Sekhamir Kalay,Shaykh Amir,Shaykh Amir Kelay,Shaykh Amīr,Shaykh Amīr Kêlay,Shekh Amir Kelay,Sheykh Amir Kalay,Sheykh Amīr Kalay,Sheykhamirkalay,Shēkh Amīr Kêlay,shykh amyr,shykh amyr kly,Šēkhāmir Kalay,شیخ امیر,شیخ امیر کلی,قريۀ شيخ امير', 33.2874400, 69.9128300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(61, 'Qāshqāl', 'Qashqal', 'Kakshal,Kashkal'',Kashkal’,Qaqshal,Qaryah-ye Qashqal,Qaryah-ye Qāshqāl,Qashqal,Qasqal,Qāqshāl,Qāshqāl,Qāšqal,Senwari,Shenvari,Shenvārī,Shenwari,Shenwārī,Shinvari,Shinwari,Shinwārī,Sinwar,S̄inwāṟ,qashqal,qryh qashqal,shnwary,Šenwāri,شنواری,قاشقال,قريه قاشقال', 35.0397500, 69.0068500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(62, 'Shibirghān', 'Shibirghan', 'Markaz-e Wilayat-e Shibirghan,Markaz-e Wilāyat-e Shibirghan,Seberghan,Sebeṟghān,Shahr-e Sheberghan,Shahr-e Sheberghān,Shayurgan,Shebergan,Sheberghan,Sheberghān,Sheberkhan,Shefrogan,Shibarghan,Shibarghān,Shibergan,Shibirghan,Shibirghān,mrkz wlayt shbrghan,shbrghan,shbrghn,Шеберган,شبرغان,شبرغن,مرکز ولايت شبرغان', 36.6675700, 65.7529000, 'AF', '2013-06-04', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(63, 'Shwāk', 'Shwak', 'Shavak,Shavāk,Shvak,Shwak,Shwāk,Swak,S̲h̲wāk,shwak,Šwāk,شواک,ښواک', 33.4238600, 69.3768400, 'AF', '2012-06-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(64, 'Shahr-e Şafā', 'Shahr-e Safa', 'Sahre Safa,Schachri Ssafa,Shahr-e Safa,Shahr-e Şafā,Shahr-i-Safa,Shahr-i-Sāfa,Shakhri-Safa,shhr sfa,Šahre Şafā,شهر صفا', 31.8034700, 66.3237600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(65, 'Shahrān', 'Shahran', 'Sahran,Sahṟān,Shaharan,Shaharān,Shahran,Shahrān,shhran,شهران', 36.9798400, 70.7392800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(66, 'Shahrak', 'Shahrak', 'Bati Dara,Kala Shaharak,Kala Shahrak,Kala Shahārak,Markaz-e Shahrak,Qal`eh Shaharak,Qal`eh-ye Bati Darrah,Qala Bati Dara,Qala Batī Dara,Qala Shaharak,Qala Shahārak,Qala Sharak,Qal‘eh Shahārak,Qal‘eh-ye Bati Darrah,Sahrak,Shahrag,Shahrak,Shakhrak,Sharak,Shāhrag,Shāhrak,Wala Shahrak,shhrk,Šahrak,شهرک', 34.1073700, 64.3052000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(67, '‘Alāqahdārī Shāh Jōy', '`Alaqahdari Shah Joy', 'Alakadari-Shakhdzhoy,Alaqadari Sahjoy,Alāqadārī Šāhjoy,Sahjoy,Sha Joi,Shah Joy,Shah Juy,Shahjui,Shajuy,Shāh Jōy,Shāh Jūy,Shāhjui,Shājūy,S̄āhjōy,`Alaqahdari Shah Joy,shah jwy,شاه جوی,علاقه داری شاه جوی,‘Alāqahdārī Shāh Jōy', 32.5215400, 67.4131500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(68, 'Wulêswālī Sayyid Karam', 'Wuleswali Sayyid Karam', 'Sayd Karam,Sayed Karam,Sayḏ Kaṟam,Seyyed Karam,Vulusvali Saidkaram,Woluswali Saydkaram,Woluswali Seyyed Karam,Woluswāli Sayḏkaṟam,Woluswālī Seyyed Karam,Wuleswali Sayyid Karam,Wulêswālī Sayyid Karam,wlswaly syd krm,wlwswly syd krm,ولسوالی سید کرم,ولوسولی سيد كرم', 33.6905600, 69.3688100, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(69, 'Markaz-e Sayyidābād', 'Markaz-e Sayyidabad', 'Markaz-e Sayyidabad,Markaz-e Sayyidābād,Markaz-e Seyydabad,Markaz-e Seyydābād,Markaz-e Seyyedabad,Markaz-e Seyyedābād,Markaze Saydabad,Markazi-Saidabad,Maṟkaze Sayḏābāḏ,Saydabad,Sayyidabad,Sayyidābād,Sayḏābāḏ,Seyyedabad,Seyyedābād,mrkz syd abad,syd abad,سيد آباد,مرکز سيد آباد', 34.0003700, 68.7134600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(70, 'Şayād', 'Sayad', 'Saiad,Saiyid,Sayad,Seyyed,syad,Şayād,صیاد', 36.1352900, 65.8297000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(71, 'Sidqābād', 'Sidqabad', 'Makhmudraki,Qal''eh-i-Wazir,Qal`a Wazir,Qal`ah-ye Wazir,Qal‘a Wazīṟ,Qal‘ah-ye Wazīr,Qal’eh-i-Wazīr,Sedgabad,Sedgābād,Sedqabad,Seḏqābāḏ,Sidqabad,Sidqābād,sdg abad,sdq abad,سدق آباد,سدگ آباد,قلعۀ وزیر', 35.0229800, 69.3511200, 'AF', '2013-08-02', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(72, 'Sāyagaz', 'Sayagaz', 'Sagaz,Sayagaz,Sāgaz,Sāyagaz,sagz,saygz,ساگز,سایگز', 32.5652100, 67.0332400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(73, 'Sar-e Tayghān', 'Sar-e Tayghan', 'Sar Teghan,Sar-e Tayghan,Sar-e Tayghān,Saṟ Tēghān,sr tyghan,سر تیغان', 33.5099800, 65.6763200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(74, 'Sarōbī', 'Sarobi', 'Markaz-e Sorubi,Markaz-e Sorūbī,Sarobi,Sarowbi,Sarowbī,Sarubi,Sarōbī,Sorubay,Sorubi,Sorūbay,Sorūbī,Surawbi,Surobay,Surubay,Surūbay,Sūrāwbī,Sūṟōbay,srwby,سروبی', 34.5896200, 69.7600500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(75, 'Sar Kāṉī', 'Sar Kani', 'Sar Kani,Sar Kāṉī,Sarkani,Sarkanu,Sarkānī,Sarkānū,Serkani,Seṟkāṉi,Sirkhani,Sirkhānī,srkany,سركانی,سرکاڼی', 34.7902300, 71.1096200, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(76, 'Sarfirāz Kalā', 'Sarfiraz Kala', 'Qal''ah-ye Sar Firaz,Qal’ah-ye Sar Firāz,Sarferaz Kala,Sarferāz Kalā,Sarfiraz Kala,Sarfirazkala,Sarfirāz Kalā,srfraz kla,سرفراز کلا,قلعه سر فراز', 32.9833300, 67.9651700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(77, 'Sar-e Pul', 'Sar-e Pul', 'Sar-e Pol,Sar-e Pul,Sar-i-Pul,Sari-Pul'',sr pl,Сари-Пуль,سر پل', 36.2154400, 65.9324900, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(78, 'Sar Chakān', 'Sar Chakan', 'Sar Cakan,Sar Chakan,Sar Chakān,Saṟ Cakān,sr chkan,سر چکان', 35.7017700, 65.2305500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(79, 'Sangīn', 'Sangin', 'Sandzhin,Sangin,Sangīn,Sarban Qal`eh,Sārbān Qal‘eh,sngyn,Санджин,سنگین', 32.0727500, 64.8359000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(80, 'Sang-e Māshah', 'Sang-e Mashah', 'Sang-e Mashah,Sang-e Masheh,Sang-e Māshah,Sang-e Māsheh,Sang-i-Macha,Sang-i-Masha,Sang-i-Māsha,Sange Masa,Sange Māša,sng mashh,سنگ ماشه', 33.1396000, 67.4404600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(81, 'Sang-e Chārak', 'Sang-e Charak', 'Sang-e Charak,Sang-e Chārak', 35.8497200, 66.4369400, 'AF', '2016-03-09', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(82, 'Sang Atesh', 'Sang Atesh', 'Sang Ates Mamaka,Sang Atesh Mamakah,Sang Atish Mamakah,Sang Ātesh Māmākah,Sang Ātes̄ Māmāka,Sang Ātish Māmākah,sng atsh mamakh,سنگ آتش ماماکه', 35.2480000, 63.0044000, 'AF', '2010-08-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(83, 'Sangar Sarāy', 'Sangar Saray', 'Sang-i-Sarai,Sang-i-Sarāi,Sangar,Sangar Sarai,Sangar Saray,Sangar Sarāy,Sangar Sarāī,Sangarsaray,sngr sray,سنگر سرای', 34.4074400, 70.6393700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(84, 'Aībak', 'Aibak', 'Aibak,Aybak,Aībak,Eybak,Haibak,Samagan,Samangan,Samangān,aybk,smngan,Āybak,Саманган,آیبک,ایبک,سمنگان', 36.2646800, 68.0155100, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(85, 'Rū-ye Sang', 'Ru-ye Sang', 'Roysang,Ru-ye Sang,Ruisang,Ruy Sang,Rū-ye Sang,Rūisang,Rūy Sang,rwy sng,روی سنگ,Ṟōysang', 35.3199900, 67.6338700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(86, 'Rūdbār', 'Rudbar', '', 30.1500000, 62.6000000, 'AF', '2006-01-17', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(87, 'Rustāq', 'Rustaq', 'Rostaq,Rostāq,Rustak,Rustaq,Rustāq,rstaq,رستاق,Ṟustāq', 37.1260400, 69.8304500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(88, 'Rabāţ-e Sangī-ye Pā’īn', 'Rabat-e Sangi-ye Pa''in', 'Rabat-e Sangi,Rabat-e Sangi-ye Pa''in,Rabat-i-Sangi-Pa''in,Rabati-Sangiyi-Pain,Rabāţ-e Sangī,Rabāţ-e Sangī-ye Pā’īn,Rabāṯ-i-Sangi-Pā’īn,Robat-e Sangi-ye Pa''in,Robāţ-e Sangī-ye Pā’īn,rbat sngy,rbat sngy payyn,رباط سنگی,رباط سنگی پائین', 34.7995100, 62.1391700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(89, 'Rāmak', 'Ramak', 'Rahmak,Ramak,Rāmak,ramk,رامک', 33.5223400, 68.6264000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(90, 'Qurghān', 'Qurghan', 'Bazar-e Qurghan,Bāzār-e Qurghān,Kurghan,Kurghān,Qorghan,Qorghān,Qurghan,Qurghān,Quṟghān,bazar qrghan,qrghan,بازار قرغان,قرغان', 36.9193900, 65.0649000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(91, 'Quchanghī', 'Quchanghi', 'Kuchangi,Qocanghi,Qocangli,Qochanghi,Qochanghī,Qochangi,Qochangī,Qočanghi,Quchanghi,Quchanghī,Qōchanghī,qchnghy,qwchnghy,قوچنغی,قچنغی', 34.0618300, 66.2780100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(92, 'Sangalak-i-Kaisar', 'Sangalak-i-Kaisar', 'Qaisar,Qaysar,Qaysāṟ,Qaīşār,Qeysar,Qeyşār,Sangalak-i-Kaisar,qysar,قیصار', 35.6874700, 64.2931800, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(93, 'Qarqīn', 'Qarqin', 'Karkin,Karkin Bazar,Kkhanika,Qarkin,Qarqin,Qarqīn,Quarkin,qrqyn,Кханика,قرقین', 37.4185300, 66.0435800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(94, 'Qarghah’ī', 'Qarghah''i', 'Deh Mazang,Dekhmazang,Kargay,Karghai,Qargha''i,Qarghah,Qarghah''i,Qarghah’ī,Qaṟghah’ī,Qaṟgha’i,dh mzng,qrghh yy,ده مزنگ,قرغه ئی', 34.5540200, 70.2429200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(95, 'Qarchī Gak', 'Qarchi Gak', 'Qarchi Gak,Qarchī Gak,qrchy gk,قرچی گک', 37.0399900, 66.7889100, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(96, 'Qarāwul', 'Qarawul', 'Hazrat Imam,Hazrat Imam Saiyid,Hazrat Imām,Karaul,Qaravol,Qarawul,Qarāvol,Qarāwul,Qaṟāwul,qrawl,قراول', 37.2195900, 68.7802000, 'AF', '2013-09-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(97, 'Qarah Bāgh', 'Qarah Bagh', 'Karabagh,Karabāgh,Kharabagh,Qara Baqh,Qarabagh,Qarabāgh,Qarah Bagh,Qarah Bāgh,Qareh Bagh,Qareh Bāgh,Qaṟa Bāqh,qrh bagh,قره باغ', 34.9402300, 61.7758900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(98, 'Qarah Bāgh', 'Qarah Bagh', 'Karabag,Qarabagh,Qarah Bagh,Qarah Bāgh,Qarehbagh,Qarehbāgh,Qaṟabāgh,qrh bagh,قره باغ', 33.1980100, 68.1079800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(99, 'Qala i Naw', 'Qala i Naw', 'Kala Nao,Kalai-Naw,Kalayi-Nau,LQN,Qal''eh Now,Qal`a-i-Naw,Qal`ah-ye Now,Qal`eh Nau,Qal`eh-ye Now,Qala Nau,Qala Naw,Qala i Naw,Qala-e-Nau,Qala-i-Nau,Qalaenaw,Qal‘a-i-Naw,Qal‘ah-ye Now,Qal‘eh Nau,Qal‘eh-ye Now,Qal’eh Now,Qula-i-nau,Shehr Qaleh,Shehr Qeleh,qlʿە nw,قلعۀ نو', 34.9873500, 63.1289100, 'AF', '2013-10-26', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(100, 'Qal‘ah-ye Kūf', 'Qal`ah-ye Kuf', 'Kala Kuf,Qal''a-i-Kuf,Qal`ah-ye Kuf,Qal`eh-ye Kuf,Qala-i-Kof,Qala-i-Kot,Qal‘ah-ye Kūf,Qal‘eh-ye Kūf,Qal’a-i-Kūf,قلعۀ کوف', 38.0411900, 70.4729800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(101, 'Qal‘ah-ye Kuhnah', 'Qal`ah-ye Kuhnah', 'Qal`a-i- Kuhna,Qal`ah-ye Kuhnah,Qal`eh-ye Kohneh,Qal‘a-i- Kuhna,Qal‘ah-ye Kuhnah,Qal‘eh-ye Kohneh,قلعۀ کهنه', 32.6159100, 63.6668100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(102, 'Qal‘ah-ye Shahr', 'Qal`ah-ye Shahr', 'Faoghan,Fāoghān,Kala Shahar,Kala Shāhar,Qal`a-i-Sahr,Qal`ah-ye Shahr,Qal`eh Shahar,Qal`eh Shahr,Qala Sahr,Qala Shahar,Qala Shāhār,Qala S̄ahṟ,Qal‘a-i-S̄ahṟ,Qal‘ah-ye Shahr,Qal‘eh Shahr,Qal‘eh Shāhār,قلعۀ شهر', 35.5472900, 65.5676000, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(103, 'Qalāt', 'Qalat', 'Kalat,Kalat-i-Ghilzai,Kalāt-i-Ghilzai,Qalat,Qalāt,qlat,قلات', 32.1057500, 66.9083300, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(104, 'Qal‘ah-ye Shāhī', 'Qal`ah-ye Shahi', 'Kalashakhi,Qal`a Sahi,Qal`ah-ye Shahi,Qal`eh-ye Shahi,Qalla-ISahi,Qalła-IŠāhi,Qal‘a S̄āhi,Qal‘a Šāhi,Qal‘ah-ye Shāhī,Qal‘eh-ye Shāhī,قلعۀ شاهی', 34.6492100, 70.5914000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(105, 'Qādis', 'Qadis', 'Kadis,Qaddis,Qades,Qadis,Qādes,Qādis,Qāḏis,qads,قادس', 34.8085000, 63.4300300, 'AF', '2010-08-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(106, 'Pārūn', 'Parun', 'Parun,Poruns,Prasun,Prasungul,Prasûn,Puruns,Pārūn,parwn,prns,پارون,پرنس', 35.4206400, 70.9226100, 'AF', '2014-01-08', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(107, 'Pul-e Khumrī', 'Pul-e Khumri', 'Pol-e Khomri,Pol-e Khomrī,Pul-e Khumri,Pul-e Khumrī,Pul-i-Khomri,Pul-i-Khumri,Pule Khumri,Pule Khumṟi,Puli-Khumri,pl khmry,Пули-Хумри,پل خمری', 35.9445800, 68.7151200, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(108, 'Pul-e ‘Alam', 'Pul-e `Alam', 'Pol-e `Alam,Pol-e ‘Alam,Pul-e `Alam,Pul-e ‘Alam,Pul-i-Alam,Pule Alam,پل علم', 33.9952900, 69.0227400, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(109, 'Pasnay', 'Pasnay', 'Kohistanat,Kōhistānāt,Pasnay,kwhstanat,psny,پسنی,کوهستانات', 35.7666400, 65.7648600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(110, 'Pāshmūl', 'Pashmul', 'Pashmol,Pashmul,Pasmul,Pašmūl,Pāshmūl,pashmwl,pshmwl,پاشمول,پشمول', 31.5572000, 65.4343000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(111, 'Pasāband', 'Pasaband', 'Pasaband,Pasāband,psabnd,پسابند', 33.6895600, 64.8531000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(112, 'Panjāb', 'Panjab', 'Pandzhab,Pandzhau,Panjab,Panjao,Panjaw,Panjāb,pnjab,Панджаб,پنجاب', 34.3879500, 67.0232700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(113, 'Paghmān', 'Paghman', 'Paghman,Paghman Palace,Paghmān,Pagman,pghman,Пагман,پغمان', 34.5878700, 68.9509100, 'AF', '2012-08-04', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(114, 'Ōmnah', 'Omnah', 'Omna,Omnah,Owmneh,awmnh,Ōmna,Ōmnah,اومنه', 32.9002900, 68.7962700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(115, 'Qaryeh-ye Owbeh', 'Qaryeh-ye Owbeh', 'Caharmahale Obe,Cahāṟmahale Ōbē,Chahar Mahall-e Obeh,Chahār Maḩall-e Obeh,Obe,Obeh,Owbey,Owbi,Owbī,Qaryeh-ye Owbeh,awbh,Ōbêh,Ōbē,اوبه', 34.3697200, 63.1763900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(116, 'Uruzgān', 'Uruzgan', 'Orozgan,Orozgān,Oruzgan,Orūzgān,Qala-i-Hazar Qadam,Qala-i-Hazār Qadam,URZ,Uruzgan,Uruzgān,arwzgan,arzgan,ارزگان,اروزگان', 32.9277500, 66.6325300, 'AF', '2017-02-15', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(117, 'Urgūn', 'Urgun', 'Orgun,Orgūn,Urgun,Urgūn,argwn,ارگون', 32.9411100, 69.1800000, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(118, 'Nūsay', 'Nusay', 'Kusai,Nesay Darwaz,Nesay Ḏaṟwāz,Nusai,Nusay,Nūsay,Qaryah-ye Nusay,nwsy,qryh nsy,قريه نسی,نوسی', 38.4435000, 70.8041300, 'AF', '2013-09-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(119, 'Nūrgal', 'Nurgal', 'Nur Gol,Nurgal,Nurgal'',Nurgal’,Nurgul,Nuṟgal,Nūr Gol,Nūrgal,Nūrgul,nwr gl,نور گل', 34.6134100, 70.7649800, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(120, 'Now Zād', 'Now Zad', 'Naozad,Nau-Zad,Nauzad,Nauzād,Naw Zad,Naw Zāḏ,Now Zad,Now Zād,Nozad,Nāozād,nw zad,نو زاد', 32.4031500, 64.4695900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(121, 'Nīlī', 'Nili', 'Nili,Nīlī,Qaryah-e Nili,Qaryah-e Nīlī,nyly,نیلی', 33.7217800, 66.1302300, 'AF', '2014-01-15', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(122, 'Nayak', 'Nayak', 'Naiak,Naik,Nayak,Neyak,Nāik,Nāyak,nayk,nyk,نايک,نيک', 34.7341400, 66.9529200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(123, 'Nāyak', 'Nayak', 'Nayak,Nāyak,nayk,نایک', 32.5723000, 66.7740300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(124, 'Now Dahānak', 'Now Dahanak', 'Navadanak,Naw Danak,Nawdanak,Nawdānak,Now Dahanak,Now Dahānak,Now Danak,Now Dānak,Nāw Dānak,nw dank,nw dhank,نو دانک,نو دهانک', 35.6239800, 70.0051100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(125, 'Ōkak', 'Okak', 'Navar,Navor,Nawur,Nāvar,Nāvor,Nāwuṟ,Okak,Owkak,awkk,Ōkak,Окак,اوکک', 33.8979300, 67.9565200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(126, 'Nāṟay', 'Naray', 'Narai,Naray,Naray Kelay,Nari,Nāray,Nāraī,Nāṟay,Nāṟay Kelay,nry,ناړی,نری', 35.2199500, 71.5228400, 'AF', '2014-01-08', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(127, 'Narang', 'Narang', 'Narang,Naṟang,nrng,نرنگ', 34.7600900, 71.0473800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(128, 'Nīkêh', 'Nikeh', 'Naka,Nakah,Nekah,Nikeh,Nīkêh,nkh,nykh,نيکه,نکه', 33.1893400, 69.2717900, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(129, 'Nahrīn', 'Nahrin', 'Nahrin,Nahrīn,Nakhrin,Narain,Narin,Narīn,nhryn,Нахрин,نهرین', 36.0649000, 69.1334300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(130, 'Ḩukūmat-e Nād ‘Alī', 'Hukumat-e Nad `Ali', 'Hokumat-e Nad `Ali,Hokumat-e Nad-e `Ali,Hokumati Nad-e `Ali,Hukumat-e Nad `Ali,Khukumati-Nadi-Ali,Nad `Ali,Nad-e `Ali,Nad-i-Ali,Nad`ali,Nade Ali,Nād ‘Alī,Nād-e ‘Alī,Nād-i-Alī,Nāde Ali,Nād‘alī,حكومت ناد علی,حكومتٔ نادٔ علی,حکومتی ناد علی,ناد علی,Ḩokūmat-e Nād ‘Alī,Ḩokūmat-e Nād-e ‘Alī,Ḩokūmatī Nād-e ‘Ali,Ḩokūmatī Nād-e ‘Alī,Ḩukūmat-e Nād ‘Alī', 31.6428600, 64.2398200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(131, 'Mūsá Qal‘ah', 'Musa Qal`ah', 'De Musa Qal`eh,De Mūsá Qal‘eh,Musa Kala,Musa Qal`a,Musa Qal`ah,Musa Qal`eh,Musa Qala,Musa Qaleh,Musakala,Mūsa Qal‘a,Mūsá Qal‘ah,Mūsá Qal‘eh,Mūsā Qal‘ah,Takhta Pul,موسى قلعه', 32.4456500, 64.7448600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(132, 'Bala Murghab', 'Bala Murghab', 'Bala Murghab,Bālā Murghāb,Bālā Muṟghāb,Morghab,Morghāb,bala mrghab,بالا مرغاب', 35.5840800, 63.3288600, 'AF', '2010-08-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(133, 'Muqêr', 'Muqer', 'Moqor,Moqur,Moquṟ,Mukar,Mukur,Muqer,Muqur,Muqêr,Qala-i-Sarkari,Qala-i-Sarkāri,mqr,مقر', 32.8200900, 67.7693400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(134, 'Muḩammad Āghah Wuluswālī', 'Muhammad Aghah Wuluswali', 'Deh-e Muhammad Aghah,Deh-e Muḩammad Āghah,Mohammad Agha,Mohammad Aghah,Moḩammad Āghah,Moḩammad Āghā,Muhammad Agha,Muhammad Aghah Wuluswali,Muhammad Āgha,Muḩammad Āghah Wuluswālī,mhmd aghh wlswaly,محمد آغه ولسوالی', 34.2142200, 69.1002600, 'AF', '2012-11-07', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(135, 'Mīzān ‘Alāqahdārī', 'Mizan `Alaqahdari', 'Mizan,Mizan `Alaqadari,Mizan `Alaqahdari,Mizan-Alakadari,Mizani,Mizān ‘Alāqadārī,Mizān ‘Alāqahdārī,Mīzān,Mīzān ‘Alāqahdārī,Mīzānī,`Alaqadari,myzan,ميزان,ميزان علاقه داری,‘Alāqadārī', 32.1763500, 66.5127100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(136, 'Mīr Bachah Kōṯ', 'Mir Bachah Kot', 'Mir Bachah Kot,Mir Bachcheh Kowt,Mir Bachcheh Kut,Mir Bachchen Kut,Mir Bacheh Kowt,Mir Bacheh Kut,Mir Dacha Kote,Mirbaca Kot,Mirbachakot,Mīr Bachah Kōṯ,Mīr Bachcheh Kowt,Mīr Bachcheh Kūt,Mīr Bachchen Kūt,Mīr Bacheh Kowt,Mīr Bacheh Kūt,Mīrbača Kot,Sara-ye Khvajeh,Sara-ye Khwajah,Sarai Khwaja,Saray Khvajah,Saray-Khwaja,Saraykhodzha,Sarā-ye Khvājeh,Sarā-ye Khwājah,Sarāi Khwāja,Sarāy Khvājah,Saṟāy-Khwāja,myr bchh kwt,sray khwajh,سرای خواجه,مير بچه كوت,میر بچه کوټ', 34.7499900, 69.1189900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(137, 'Mīrān', 'Miran', 'Miran,Mīrān,myran,ميران', 34.2203700, 68.3125900, 'AF', '2012-10-06', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(138, 'Mīrābād', 'Mirabad', 'Mirabad,Mirabad-e Mohammad Akbar,Mīrābād,Mīrābād-e Moḩammad Akbar,myr abad,میر آباد', 30.4362400, 61.8383000, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(139, 'Maymana', 'Maymana', 'Daerah Maymana,MMZ,Maimana,Maimanah,Maimāna,Majmana,Maymana,Maymanah,Maïmana,Maīmanah,Meimana,Mejmene,Meymaneh,Meymene,Mimana,Quan Maymana,Quận Maymana,mai ma na,meyamana,mymnh,Меймене,ضلع میمنہ,ميمنه ولسوالۍ,میمنه,میمنہ,मेयमना,迈马纳', 35.9213900, 64.7836100, 'AF', '2013-09-21', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(140, 'Maīdān Khūlah', 'Maidan Khulah', 'Maidan Khulah,Maydan Kholeh,Maydankhula,Mayḏān Kholeh,Maīdān Khūlah,Meydan Kholeh,Meydan Khvolah,Meydān Kholeh,Meydān Khvolah,mydan khwlh,میدان خوله', 33.6491600, 69.7812000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(141, 'Mingajik', 'Mingajik', 'Mengajik,Mengajīk,Mengeh Jek,Mingajek,Mingajik,Mungajik,mngjk,منگجک', 37.0279000, 66.1281700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(142, 'Mehtar Lām', 'Mehtar Lam', 'Laghman,Mehtar Lam,Mehtar Lām,Mekhtarlam,Metarlam,Mir Talam Saheb Ziarat,Mitarlam,Miterlam,Mīr Talām Şāḩeb Zīārat,Nawar Lam,Nāwar Lam,mhtr lam,Митарлам,مهتر لام', 34.6713900, 70.2094400, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(143, 'Mazār-e Sharīf', 'Mazar-e Sharif', 'MZR,Masar-e Scharif,Mazar-e Sarif,Mazar-e Sharif,Mazar-e Šarif,Mazar-e-Sharif,Mazar-i Szarif,Mazar-i-Sharif,Mazare Srif,Mazari Sharif,Mazari-Sharif,Mazār-e Sharīf,Mazār-e Šarīf,Mazār-i-Sharīf,Mazāre S̄rīf,majaleu-isyalipeu,mazarisharifu,mzar shryf,Мазари-Шариф,مزار شريف,مزار شریف,マザーリシャリーフ,마자르이샤리프', 36.7090400, 67.1108700, 'AF', '2017-02-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(144, 'Māymay', 'Maymay', 'Mah Mayk,Mahmai,Mahmey,Maymay,Maymey,Māh Mayk,Māymay,Māymey,Māymāy,maymy,مایمی', 38.4085600, 71.0383900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(145, 'Mutā Khān', 'Muta Khan', 'Mata Khan,Matā Khān,Metakhan,Metākhān,Motakhan,Motākhān,Muta Khan,Mutakhan,Mutā Khān,mta khan,متا خان', 33.2400100, 68.8663000, 'AF', '2014-02-06', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(146, 'Mashhad', 'Mashhad', 'Mashad,Mashhad,mshhd,مشهد', 36.8166500, 70.1021100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(147, 'Mardīān', 'Mardian', 'Mardian,Mardyan,Mardīān,Maṟḏyān,Mordian,Mordīān,Murdian,Murdīān,mrdyan,مردیان', 36.9925200, 66.2965400, 'AF', '2013-11-07', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(148, 'Mandōl', 'Mandol', 'Mandol,Mandul,Mandōl,Mandūl,Manḏōl,Mundol,Mundol'',Mundol’,Mundul,Mundūl,Munḏōl,mndwl,مندول,منډول', 35.2840300, 70.1701700, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(149, 'Māmā Khēl', 'Mama Khel', 'Hashem Kheyl,Hasim Khel,Hāsim Khel,Mama Khel,Mamakheyl,Mamakheyl'',Mamakheyl’,Māmā Khēl,Māmākheyl,Sheyrzad,Sheyrzād,mama khyl,ماما خيل,ماما خېل', 34.2449400, 69.9968000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(150, 'Lashkar Gāh', 'Lashkar Gah', 'BST,Bist,Bost,Bust,Lashkar Gah,Lashkar Gāh,Lashkargah Bust,Lashkargakh,Laskargah,Las̲h̲kargāh Busṯ,Laškargāh,Nawab City,lshkr gah,Лашкаргах,لشكر گاه,لښکرگاه بسټ', 31.5938200, 64.3716100, 'AF', '2013-10-31', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(151, 'Lāsh-e Juwayn', 'Lash-e Juwayn', 'Jawain,Joveyn,Juwain,Juwayn,Juwāin,Lase Jowayn,Lash,Lash Jovayn,Lash-e Joveyn,Lash-e Joway,Lash-e Juwayn,Laso-joayn,Lāsh,Lāsh Jovayn,Lāsh-e Joveyn,Lāsh-e Joway,Lāsh-e Juwayn,Lās̄e Jowayn,Lās̄o-joayn,jwyn,lash jwy,lashi chwyn,جوين,لاش جوی,لاشِ چوين', 31.7138200, 61.6227200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(152, 'Larkird', 'Larkird', 'Lar Gerd,Largird,Largirid,Larkerd,Larkird,lrkrd,Лар Герд,لرکرد', 35.4893600, 66.6640900, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(153, 'La‘l', 'La`l', 'La`l,La`l va Sar Jangal,La`l wa Sar Jangal,La`losarjangal,Lal'',Lal’,La‘l,La‘l va Sar Jangal,La‘l wa Sar Jangal,La‘losaṟjangal,Qaryeh-ye La`l,Qaryeh-ye La‘l,لعل,لعل و سر جنگل', 34.5014100, 66.2799700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(154, 'Kushk', 'Kushk', 'Kushk,Kusk,Kus̄k,Kūshk,kshk,Кушк,کشک', 33.2956500, 61.9522100, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(155, 'Kōṯowāl', 'Kotowal', 'Kotaval'',Kotaval’,Kotawal,Kotowal,Kowtawal,Kowtawāl,Kōtawāl,Kōṯowāl,kwtwal,کوتوال,کوټوال', 34.1031900, 70.4607300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(156, 'Kushk-e Kuhnah', 'Kushk-e Kuhnah', 'Koshk,Koshk-e Kohneh,Kushk,Kushk-e Kuhnah,Kusk,Kusk-i-Kohna,Kuske Kuhna,Kus̄k-i-Kohna,Kus̄ke Kuhna,kshk khnh,کشک کهنه', 34.8711000, 62.5476200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(157, 'Kuran wa Munjan', 'Kuran wa Munjan', '''Alaqehdari-ye Koran va Monjan,KUR,Kerana va Manjah,Kiran wa Munjan,Kirān wa Munjān,Koran va Monjan,Koranomunjan,Korān va Monjān,Koṟānomunjān,Kuran wa Munjan,ʿlaqh dary kran w mnjan,علاقه داری کران و منجان,‘Alāqehdārī-ye Korān va Monjān', 36.0286600, 70.7725800, 'AF', '2017-02-25', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(158, 'Kunduz', 'Kunduz', 'Kondoz,Konduz,Kondôz,Kondūz,Kundus,Kunduz,Kunduz khot,Kunduzas,Kundúz,Kundūz,Kundūzas,Qonduz,Qondūz,Qunduz,Qundūz,Qunḏūz,Shahr-e Qondoz,UND,kantacu,kndwz,kndz,kuduza,kun dou shi,kundo~uzu,kunduja,kundujeu,kundus,kunduza,qndwz,qndz,Кундуз,Кундуз хот,قندز,قندوز,كندز,کندوز,कुंदुज़,কুন্দুজ,ਕੁੰਦੂਜ਼,கண்டசு,കുന്ദൂസ്,ყუნდუზი,クンドゥーズ,昆都士,쿤두즈', 36.7289500, 68.8570000, 'AF', '2014-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(159, 'Khōshī', 'Khoshi', 'Khoshi,Khosi,Khoši,Khushi,Khvoshi,Khvoshī,Khōshī,Kushi,khwshy,خوشی', 33.9991600, 69.2158200, 'AF', '2013-03-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(160, 'Khōshāmand', 'Khoshamand', 'Khosamand,Khoshamand,Khos̄āmanḏ,Khus Amad,Khusamand,Khush Amad,Khushamand,Khus̄ Āmad,Khus̄āmand,Khvosh Amad,Khvosh Mand,Khvosh Āmad,Khvoshamand,Khvoshāmand,Khōshāmand,Khūsh Āmad,khwsh amd,khwshamnd,خوش آمد,خوشامند', 32.6856700, 68.2380100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(161, 'Khwājah Ghār', 'Khwajah Ghar', 'Khodzhagar,Khoja-i-Gar,Khvajeh Ghar,Khvājeh Ghar,Khwaja Gar,Khwaja Ghar,Khwaja-i-Gar,Khwaja-i-Ghar,Khwajah Ghar,Khwāja-i-Gar,Khwāja-i-Ghar,Khwājah Ghār,khwajh ghar,خواجه غار', 37.0658800, 69.4212600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(162, 'Khwājah Dū Kōh', 'Khwajah Du Koh', 'Khodja-Bunak,Khodzha-Dokukh,Khvajeh Do Kuh,Khvājeh Do Kūh,Khwaja Do Koh,Khwaja Du Koh,Khwajah Do Koh,Khwajah Du Koh,Khwajah-ye Do Ku,Khwajah-ye Do Kū,Khwāja Do Koh,Khwājah Dō Kōh,Khwājah Dū Kōh,Khwājā Du Koh,khwajh dw kwh,خواجه دو کوه', 36.8288100, 65.6243200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(163, 'Deh Khwāhān', 'Deh Khwahan', 'Deh Khahan,Deh Khwahan,Deh Khwāhān,Deh Khāhān,KWH,Khvahan,Khvāhān,Khwahan,Khwāhān,Qala Khwahan,dh khahan,dh khwahan,khwahan,خواهان,ده خاهان,ده خواهان,Ḏeh Khāhān', 37.8896500, 70.2187500, 'AF', '2017-02-15', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(164, 'Khulbisāt', 'Khulbisat', 'Khalbesat,Kholbesat,Kholbesāt,Kholbisat,Khul''besat,Khulbesat,Khulbesāt,Khulbisat,Khulbisāt,Khul’besat,Khālbêsāt,Khōlbisāt,khlbsat,khwlbsat,خلبسات,خولبسات', 33.4948000, 70.0060500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(165, 'Khūgyāṉī', 'Khugyani', 'Khug''yani,Khugyani,Khug’yani,Khukyani,Khūgyānī,Khūgyāṉi,Khūgyāṉī,Khūkyānī,khwgyany,خوگیانی,خوگیاڼی', 31.5626700, 66.5814000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(166, 'Khōst', 'Khost', 'KHT,Khost,Khowst,Khōst,Matun,Matūn,khwst,mtwn,Хост,خوست,متون', 33.3395100, 69.9204100, 'AF', '2017-02-17', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(167, 'Khulm', 'Khulm', 'Bazar-e Khulm,Bāzār-e Khulm,Kholm,Khulm,Tashkurgan,Tashkurghan,Tashqorghan,Tashqurghan,Tāshkurghān,Tāshqorghān,Tāshqurghān,bazar khlm,khlm,tashqrghan,Ташкурган,بازار خلم,تاشقرغان,خلم', 36.6973600, 67.6982600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(168, 'Khudāydād Khēl', 'Khudaydad Khel', 'Khodaydad Khel,Khodaydad Kheyl,Khodaydadkhel,Khodāydād Kheyl,Khodāydād Khēl,Khoḏāyḏāḏkhēl,Khuda Dad Khel,Khudaydad Khel,Khudā Dād Khēl,Khudāydād Khēl,خدا داد خېل,خدایداد خېل', 35.1783500, 67.6875800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(169, 'Khinjān', 'Khinjan', 'Khenjan,Khenjān,Khindzhan,Khinjan,Khinjān,khnjan,خنجان', 35.5890800, 68.9009300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(170, 'Khinj', 'Khinj', 'Khenj,Khindzh,Khinj,khnj,Хиндж,خنج', 35.4289800, 69.7348200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(171, 'Khāsh', 'Khash', 'Khas,Khash,Khāsh,Khās̄,khash,خاش', 31.5291900, 62.7905500, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(172, 'Khān Neshīn', 'Khan Neshin', 'Khan Nashim,Khan Nashin,Khan Neshin,Khan Nishin,Khaneshin,Khannesin,Khān Nashīn,Khān Neshīn,Khān Nishīn,Khāneshīn,Khānnešīn,khan nshyn,خان نشین', 30.5488000, 63.7888000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(173, 'Khānaqāh', 'Khanaqah', 'Khanaka,Khanaqa,Khanaqah,Khanega,Khanehqah,Khaneqa,Khānaqā,Khānaqāh,Khānegā,Khānehqāh,Khāneqā,khanhqah,khanqah,Ханака,خانقاه,خانهقاه', 36.6258700, 69.5369500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(174, 'Chahār Bāgh', 'Chahar Bagh', 'Chahar Bagh,Chahār Bāgh,Char Bagh,Chār Bāgh,Khan Chahar Bagh,Khan''-charbag'',Khan-Chekhar-Bar,Khan-e Chahar Bagh,Khan-e Char Bagh,Khancarbagh,Khan’-charbag’,Khān Chahār Bāgh,Khān-e Chahār Bāgh,Khān-e Chār Bāgh,Khāncārbāgh,Qani Chahar Bagh,Qanī Chahār Bāgh,chhar bagh,چهار باغ', 37.0010800, 65.2239200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(175, 'Khandūd', 'Khandud', 'Khandud,Khandut,Khandūd,Khanḏūḏ,khndwd,خندود', 36.9512700, 72.3180000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(176, 'Khānaqāh', 'Khanaqah', 'Khanaka,Khananqa,Khanaqa,Khanaqah,Khaneqah,Khānaka,Khānanqā,Khānaqā,Khānaqāh,Khāneqāh,khanqah,khanqh,خانقاه,خانقه', 36.8627900, 66.1665600, 'AF', '2013-10-04', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(177, 'Khanabad', 'Khanabad', 'Khanabad,Khānābād,khan abad,Ханабад,خان آباد', 36.6825000, 69.1155600, 'AF', '2009-03-03', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(178, 'Khamyāb', 'Khamyab', 'Kham Ab,Kham-e Ab,Kham-e Āb,Kham-i-Ab,Kham-i-Āb,Khamyab,Khamyāb,Khām Āb,kham ab,khmyab,خام آب,خمياب', 37.5275000, 65.7583300, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(179, 'Khākirān', 'Khakiran', 'Khakeran,Khakiran,Khākerān,Khākirān,khakran,خاکران', 32.8385000, 67.0737700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(180, 'Kaz̲h̲ah', 'Kazhah', 'Kaga,Kagd,Kaza,Kazhah,Kaz̲h̲ah,Kaža,Khazha,Khowgiani,Khowgīānī,Nawe Kaza,Nawē Kaža,kzhh,كژه,کږه', 34.2408800, 70.1827400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(181, 'Kishk-e Nakhūd', 'Kishk-e Nakhud', 'Kashk-e Nokhowd,Keshk-e Nakhud,Keshk-e Nakhūd,Keskenakhud,Keškenakhud,Kishk-e Nakhud,Kishk-e Nakhūd,Kishkinakhud,Kishkinakhūd,Kuchki-Nalud,Kushk-e Nakhud,Kushk-e Nakhūd,Kuske Nakhud,Kus̄ke Nakhuḏ,kshk nkhwd,کشک نخود', 31.6251900, 65.0551100, 'AF', '2012-02-01', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(182, 'Karukh', 'Karukh', 'Karokh,Karrukh,Karukh,Kaṟukh,krkh,کرخ', 34.4810800, 62.5863000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(183, 'Kanḏay', 'Kanday', 'Kanday,Kanḏay,kndy,كندی,کنډی', 34.9536000, 70.7789700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(184, 'Kandahār', 'Kandahar', 'Candahar,Gorad Kandagar,KDH,Kandagar,Kandahar,Kandaharo,Kandahār,Kandehar,Kandhar,Qandahar,Qandahār,Qanḏahāṟ,kan da ha,kandaharu,kndhar,qndhar,qndhʼr,Горад Кандагар,Кандагар,קנדהאר,قندهار,كندهار,カンダハール,坎大哈', 31.6133200, 65.7101300, 'AF', '2014-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(185, 'Kalān Deh', 'Kalan Deh', 'Kalan Deh,Kalan-Dekh,Kalān Deh,dh klan,klan dh,دهٔ كلان,کلان ده', 33.8367600, 68.4023300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(186, 'Kalakān', 'Kalakan', 'Bazar-e Kalakan,Bāzār-e Kalakān,Kala Chan,Kala Khan,Kala Khān,Kalakan,Kalakān,Qal`eh-ye Khan,Qala Khan,Qala Khān,Qal‘eh-ye Khān,bazar klkan,klkan,بازار کلکان,کلکان', 34.7837100, 69.1500100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(187, 'Kalafgān', 'Kalafgan', 'Kalafgan,Kalafgān,Kalefgan,Kalefgān,Kalifgan,Kalifgān,klfgan,کلفگان', 36.7722600, 69.9448900, 'AF', '2013-11-07', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(188, 'Kajrān', 'Kajran', 'Kadzhiran,Kajiran,Kajran,Kajrān,Kajīrān,kjran,Каджиран,کجران', 33.2035700, 65.4731100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(189, 'Kai', 'Kai', 'Ka''i,Kahi,Kahī,Kai,Ka’i,Kāhī,Kā’ī,kayy,khy,کائی,کهی', 34.1281900, 70.7182800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(190, 'Kabul', 'Kabul', 'Cabool,Caboul,Cabul,Cabul - kabl,Cabul - کابل,Cabura,Cabúl,Caubul,Gorad Kabul,KBL,Kabil,Kaboel,Kabol,Kaboul,Kabul,Kabula,Kabulas,Kabuli,Kabulo,Kabura,Kabúl,Kabûl,Kampoul,Kobul,Kubha,Kábul,Kâbil,Kābol,ka bu er,kabl,kabul,kabula,kabuli,kaburu,kabwl,kapul,ke bu er,khabul,Καμπούλ,Горад Кабул,Кабул,Кобул,Քաբուլ,קאבול,كابل,كابۇل,کابل,کابول,काबुल,কাবুল,ਕਾਬੁਲ,କାବୁଲ,காபூல்,ಕಾಬುಲ್,കാബൂൾ,කාබුල්,คาบูล,ཁ་པལ།,ཁ་པུལ།,ქაბული,ካቡል,ទីក្រុងកាបូល,カブール,カーブル,喀布尔,喀布爾,카불', 34.5281300, 69.1723300, 'AF', '2014-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(191, 'Jurm', 'Jurm', 'Jarm,Jorm,Jurm,Jurn,Shahr-e Jorm,jrm,جرم', 36.8647700, 70.8342100, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(192, 'Jawand', 'Jawand', 'Javand,Jawand,Jowand,jwnd,جوند', 35.0636100, 64.1491700, 'AF', '2011-11-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(193, 'Jānī Khēl', 'Jani Khel', 'Dzhanikheyl'',Dzhanikheyl’,Jani Khel,Jani Kheyl,Janikhel,Jānikhēl,Jānī Kheyl,Jānī Khēl,جانی خېل', 32.7631500, 68.3972200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(194, 'Jalrēz', 'Jalrez', 'Dzhalez,Jalez,Jaliz,Jalrayz,Jalreyz,Jalrez,Jalriz,Jalrēz,Jalrīz,Jalēz,Jalīz,jlryz,جلريز,جلرېز', 34.4708000, 68.6543800, 'AF', '2012-08-04', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(195, 'Jalālābād', 'Jalalabad', 'Djelalabad,Dschalalabad,Dzalalabad,Dzhelalabad,Dżalalabad,JAA,Jalakot,Jalal-Kut,Jalalabad,Jalalkoat,Jalalkot,Jalālkot,Jalālābād,Jelalabad,Tarun City,jalalabada,jlal abad,Джелалабад,جلال آباد,جلال‌آباد,জালালাবাদ', 34.4264700, 70.4515300, 'AF', '2017-02-15', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(196, 'Jabal os Saraj', 'Jabal os Saraj', 'Djabal-ul-Seradj,Dzhabal''-Ussaradzh,Dzhabal’-Ussaradzh,Jabal Saraj,Jabal os Saraj,Jabal os Sarāj,Jabal us Siraj,Jabal us Sirāj,Jabal-us-Sirai,Jabalussaraj,Jabalussaṟāj,Jabl-us-Seraj,Jabl-us-Siraj,Jabul Saraj,Jibal-as-Seraj,Parwan,jbl alsraj,جبل السراج', 35.1183300, 69.2377800, 'AF', '2010-03-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(197, 'Ḩukūmat-e Shīnkaī', 'Hukumat-e Shinkai', 'Hokumat-e Shinkay,Hokumate Sinkay,Hokūmate Šinkay,Hukumat-e Shinkai,Hukumat-e Shinkay,Khukumati-Shinkay,Shinkai,Shīnkaī,hkwmt shynky,shynky,حکومت شینکی,شینکی,Ḩokūmat-e Shinkay,Ḩukūmat-e Shīnkay,Ḩukūmat-e Shīnkaī', 31.9830300, 67.3355800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(198, 'Herāt', 'Herat', 'Gerat,Gorad Gerat,HEA,Herat,Herāt,Hérat,Kherat,Shahr-e Herat,Shahr-e Herāt,he la te,herato,hrat,Герат,Горад Герат,Херат,هراة,هرات,ヘラート,赫拉特', 34.3481700, 62.1996700, 'AF', '2013-05-18', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(199, 'Ḩājī Khēl', 'Haji Khel', 'Haji Khel,Hajikhel,Hajjikheyl,Khadzhikheyl'',Khadzhikheyl’,hajy khyl,حاجی خيل,حاجی خېل,Ḩājikhēl,Ḩājjīkheyl,Ḩājī Khēl', 35.1092200, 69.4334100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(200, 'Ḩāfiz̧ Moghul', 'Hafiz Moghul', 'Hafez Moghol,Hafez Mughul,Hafiz Moghul,Hāfeẕ Mughul,hafz mghl,حافظ مغل,Ḩāfez̧ Moghol,Ḩāfiz̧ Moghul', 37.0564300, 70.4006100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(201, 'Khafizan', 'Khafizan', 'Hafezan,Hafizan,Khafizan,hafzan,حافظان,Ḩāfez̧ān,Ḩāfiz̧ān', 34.2866500, 70.3724700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(202, 'Guz̄arah', 'Guzarah', 'Gozara,Gozareh,Goz̄areh,Goz̄aṟa,Guzarah,Guz̄arah,gdhrh,گذره', 34.2122300, 62.2123500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(203, 'Gōshtah', 'Goshtah', 'Goshta,Goshtah,Goshteh,Gosta,Gowshtah,Gošta,Gōshtah,gwshth,گوشته', 34.3582200, 70.7626400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(204, 'Gōmal Kêlay', 'Gomal Kelay', 'Gomal,Gomal Kalay,Gomal Katay,Gomal Kelay,Gowmal,Gumal,Gumal''kalay,Gumal’kalay,Gōmal Kalay,Gōmal Katay,Gōmal Kêlay,Qashlah `Askari Gowmol,Qashlah ‘Askarī Gowmol,Zor Domandi,gwml kly,گومل کلی', 32.5098900, 68.8559800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(205, '‘Alāqahdārī Gēlān', '`Alaqahdari Gelan', 'Alakadari-Gelan,Gelan,Gilan,Gēlān,Gīlān,Janda,Jaṉda,`Alaqadari Gelan,`Alaqahdari Gelan,`Alaqahdari Jandah,علاقه داری جڼډه,علاقه داری گېلان,گېلان,‘Alāqahdārī Gēlān,‘Alāqahdārī Jaṉḏah,‘Alāqaḏāṟī Gēlān', 32.7269200, 67.6369600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(206, 'Ghōriyān', 'Ghoriyan', 'Ghorian,Ghoriyan,Ghoriān,Ghoryan,Ghurian,Ghuriyan,Ghuryan,Ghōriyān,Ghōṟyān,Ghūriyān,Ghūryān,Ghūrīān,Gorian,ghwryan,غوریان', 34.3448000, 61.4932100, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(207, 'Ghormach', 'Ghormach', 'Garmak,Ghormac,Ghormach,Ghormāch,Ghowrmach,Ghowrmāch,Ghōrmāc,Ghōrmāch,ghwrmach,ghwrmch,غورماچ,غورمچ', 35.7306200, 63.7826400, 'AF', '2011-12-21', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(208, 'Ghurayd Gharamē', 'Ghurayd Gharame', 'Garm,Gharmai,Gharmi,Gharmī,Ghoraydgharame,Ghowrayd Gharami,Ghowrayd Gharamī,Ghoṟayḏghaṟamē,Ghurayd Gharame,Ghurayd Gharamē,Ghurmay,ghrmy,غرمی,غرید غرمې', 36.5222000, 70.7906300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(209, 'Ghazni', 'Ghazni', 'GZI,Gazni,Ghazni,Ghaznī,Shahr-e Ghazni,Shahr-e Ghaznī,gazni,gazuni,ghznt,ghzny,ghznyn,Газни,غزنة,غزنی,غزنین,ガズニー', 33.5539100, 68.4209600, 'AF', '2013-05-09', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(210, 'Gereshk', 'Gereshk', 'Gereshk,Geresk,Gerešk,Girishk,Nahr-e Saraj,Nahr-e Sarāj,grshk,Герешк,گرشک', 31.8208900, 64.5700500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(211, 'Gardez', 'Gardez', 'GRG,Gardeyz,Gardez,Gardiz,Gardêz,Gardēz,Gardīz,Gaṟḏēz,grdyz,Гардез,گرديز', 33.5974400, 69.2259200, 'AF', '2016-11-04', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(212, 'Fayzabad', 'Fayzabad', 'FBD,Faizabad,Faizābād,Fajzabad,Faydz Abad,Fayzabad,Fayḏẕ Ābāḏ,Fazelabad,Faīẕābād,Feyzabad,Feyẕābād,fyd abad,Файзабад,فیض آباد', 37.1166400, 70.5800200, 'AF', '2013-09-21', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(213, 'Faīẕābād', 'Faizabad', 'Faizabad,Faizābād,Faydzabad,Fayḏẕābāḏ,Fazilabad,Faīẕābād,Feyzabad,Feyẕābād,Fāzilābād,fyd abad,فیض آباد', 36.8209100, 66.4592100, 'AF', '2013-11-07', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(214, 'Fayẕābād', 'Fayzabad', 'Faizabad,Faizābād,Faydz Abad,Fayzabad,Fayḏz Ābād,Fayẕābād,Feyzabad,Feyẕābād,qyd abad,قيض آباد', 36.2911100, 64.8622200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(215, 'Qal‘ah-ye Fārsī', 'Qal`ah-ye Farsi', 'Farsi,Farsī,Kalafarsi,Qal`a Farsi,Qal`a-i-Farsi,Qal`ah-ye Farsi,Qal`eh Farsi,Qal`eh-ye Farsi,Qal‘a Fāṟsi,Qal‘a-i-Fāṟsi,Qal‘ah-ye Farsī,Qal‘ah-ye Fārsī,Qal‘eh Fāṟsi,Qal‘eh-ye Farsī,قلعۀ فارسی,قلعۀ فرسی', 33.7852900, 63.2473500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(216, 'Farkhār', 'Farkhar', 'Farkhar,Farkhār,frkhar,فرخار', 36.5728800, 69.8578300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(217, 'Farah', 'Farah', 'FAH,Farah,Farahas,Farakh,Farâh,Farāh,Ferah,fa la,faraha,frah,pala,para,Фарах,فراه,فراہ,फ़राह,பாரா,法拉,파라', 32.3745100, 62.1163800, 'AF', '2013-09-21', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(218, 'Istālif', 'Istalif', 'Estalef,Estālef,Istalef,Istalif,Istilif,Istālef,Istālif,Takht-e Istalif,Takht-e Istālif,astalf,tkht astalf,استالف,تخت استالف', 34.8326800, 69.0775600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(219, 'Kafir Qala', 'Kafir Qala', 'Eslam Qal`eh,Eslamqal`a,Eslamqal‘a,Eslām Qal‘eh,Islam Kala,Islam Killa,Islam Qal`ah,Islam Qala,Islām Kala,Islām Qala,Islām Qal‘ah,Kafar Qal`eh,Kafir Kala,Kafir Qala,Kāfar Qal‘eh', 34.6666700, 61.0666700, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(220, 'Injīl', 'Injil', 'Enjeel,Enjil,Enjīl,Injil,Injīl,anjyl,انجيل', 34.3015700, 62.2465000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(221, 'Imām Şāḩib', 'Imam Sahib', 'Emam Saheb,Emām Şāḩeb,Hazrat,Imam Saheb,Imam Sahib,Imamsakhib,Imām Sāẖeb,Imām Şāḩib,Khwaja,Khwaja Imam Saiyid,Khwaja Iman Saiyid,Khwāja Imām Saiyid,Khwāja Imān Saiyid,amam sahb,امام صاحب', 37.1889700, 68.9364400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(222, 'Dōshī', 'Doshi', 'Doshi,Dosi,Dowshi,Dowshī,Doši,Dōshī,dwshy,دوشی', 35.6091800, 68.6847300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(223, 'Dowlatyār', 'Dowlatyar', 'Daolat Yar,Daulat Yar,Daulat Yār,Dawlatyar,Dawtatyar,Dowlat Yar,Dowlat Yār,Dowlatyar,Dowlatyār,Dāolat Yar,Taht-e Dowlatyar,Taḩt-e Dowlatyār,dwlt yar,dwltyar,دولت یار,دولتیار,Ḏawlatyāṟ,Ḏawtatyāṟ', 34.5513200, 65.7930200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(224, 'Dowlat Shāh', 'Dowlat Shah', 'Daulat Shah,Daulat Shāh,Daulatshakh,Dawlat Shah,Dawlat Shāh,Dawlatsah,Dawlatšāh,Dowlat Shah,Dowlat Shāh,dwlt shah,دولت شاه', 34.9504000, 70.0710200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(225, 'Dowlatābād', 'Dowlatabad', 'Daulatabad,Daulatābād,Davletabad,Dawlatabad,Dawlatābād,Dowlatabad,Dowlatābād,dwlt abad,Даулатабад,دولت آباد', 36.9882100, 66.8206900, 'AF', '2013-10-04', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(226, 'Dowlatābād', 'Dowlatabad', 'Danlatabad,Danlatābād,Daolatabad,Daulatabad,Daulatābād,Dawlatabad,Dowlatabad,Dowlatābād,Shirin Tagao,Shīrīn Tagāo,dwlt abad,دولت آباد,Ḏawlatābād', 36.4325900, 64.9207100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(227, 'Dū Qal‘ah', 'Du Qal`ah', 'Do Qal`eh,Do Qal‘eh,Doqal`a,Du Qal`ah,Dū Qal‘ah,Kala-i-Kah,Kala-i-Kāh,Qal`ah-ye Kah,Qal`eh Kah,Qal`eh-ye Ka,Qala-i-Kah,Qala-i-Kāh,Qal‘ah-ye Kāh,Qal‘eh Kāh,Qal‘eh-ye Kā,دو قلعه,قلعه کاه,Ḏoqal‘a', 32.1423700, 61.4469000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(228, 'Dūāb', 'Duab', 'Do Ab,Do Āb,Doab-i-Shahpasand,Dow Ab-e Shah Pasand,Dow Āb-e Shāh Pasand,Doāb-i-Shāhpasand,Duab,Dūāb,Tatar,Tātār,Tātāṟ,dwab,tatar,تاتار,دواب', 35.5627700, 67.8219100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(229, 'Dê Nārkhēl Kêlay', 'De Narkhel Kelay', 'De Narkhel Kalay,De Narkhel Kelay,De Narkheyl Kalay,De Nārkheyl Kalay,Dinarkhil,Dê Nārkhēl Kêlay,Dīnārkhīl,Narkheyl''kalay,Narkheyl’kalay,d nar khyl kly,dynarkhyl,د نار خيل كلی,د نارخېل کلی,دينارخيل,Ḏe Nāṟkhēl Kalay', 32.4320500, 65.6348400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(230, 'Dehī', 'Dehi', 'Dehi,Dehī,dhy,دهی', 35.9580600, 67.2799800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(231, 'Deh-e Şalāḩ', 'Deh-e Salah', 'Deh Salah,Deh Saleh,Deh Sāleh,Deh Şalāḩ,Deh-e Salah,Deh-e Şalāḩ,dh slah,ده صلاح', 35.6903100, 69.3151100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(232, 'Deh-e Now', 'Deh-e Now', 'Dakhi-Nau,Deh-e Now,Dehe Naw,dh nw,ده نو,دهٔ نو,Ḏehe Naw', 34.7476700, 69.0478400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(233, 'Dehdādī', 'Dehdadi', 'Chahar Sarakah-ye Dehdadi,Chahār Sarakah-ye Dehdādī,Dehdadi,Dehdādī,Dekhdadi,chhar srkh dhdady,dhdady,Дехдади,دهدادی,چهار سرکه دهدادی', 36.6631900, 66.9933900, 'AF', '2013-11-07', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(234, 'Dwah Manḏay', 'Dwah Manday', 'Davamandi,Davamandī,Domandao,Domandi,Dowmandi,Dowmandī,Du Mandah,Dvamanday,Dwah Manday,Dwah Manḏay,Dwamanday,Dū Mandah,dw mndh,dwh mndy,dwh mnډy,dwmndy,دو منده,دومندی,دوه مندی,دوه منډی,Ḏwamanday', 33.2815900, 69.5853100, 'AF', '2014-04-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(235, 'Dasht-e Qal‘ah', 'Dasht-e Qal`ah', 'Dasht Qala,Dasht-e Qal`ah,Dasht-e Qal`eh,Dasht-e Qal‘ah,Dasht-e Qal‘eh,Dashti-Kala,Dast-i-Qal''a,Daste Qal`a,Shahr-e Dasht-e Qal`eh,Shahr-e Dasht-e Qal‘eh,دشت قلعه,Ḏas̄t-i-Qal’a,Ḏas̄te Qal‘a', 37.1539000, 69.4435000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(236, 'Dasht-e Qal‘ah', 'Dasht-e Qal`ah', 'Dasht-e Qal`ah,Dasht-e Qal`eh,Dasht-e Qal‘ah,Dasht-e Qal‘eh,Daste Qal`a,دشت قلعه,Ḏas̄te Qal‘a', 33.0297800, 63.8395000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(237, 'Dasht-e Archī', 'Dasht-e Archi', '', 37.1333300, 69.1666700, 'AF', '2006-01-27', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(238, 'Darzāb', 'Darzab', 'Darzab,Darzāb,Darẕāb,Durzab,Durzāb,drz ab,درز آب', 35.9774400, 65.3782800, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(239, 'Markaz-e Ḩukūmat-e Darwēshān', 'Markaz-e Hukumat-e Darweshan', 'Darvishan,Darvīshān,Darwesan,Markaz-e Hukumat-e Darwayshan,Markaz-e Hukumat-e Darweshan,Markaz-e Hukumati Darwayshan,Markaz-e Ḩukūmat-e Darwayshān,Markaz-e Ḩukūmat-e Darwēshān,Markaz-e Ḩukūmatī Darwayshān,Markaze Hokumati Darwesan,Maṟkaze Hokūmatī Darwēsān,mrkz hkwmty drwyshan,mrkzi hkwmti drwyshan,مرکز حکومتی درویشان,مرکزِ حکومتِ درويشان,Ḏaṟwes̄ān', 31.1323100, 64.1934000, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(240, 'Darqad', 'Darqad', 'Darkat,Darqad,Qeshlaq-e Darqad,Qeshlāq-e Darqad,drqd,درقد', 37.3841400, 69.4529400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(241, 'Darāyim', 'Darayim', 'Daraim,Darayim,Darāyim,draym,درايم', 36.8666700, 70.3833300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(242, 'Dāngām', 'Dangam', 'Dangam,Dāngām,dangam,دانگام,ډانگام,Ḏāngām', 34.9924900, 71.4193500, 'AF', '2014-01-08', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(243, 'Ḏanḏar', 'Dandar', 'Dandar,Qaryah-ye Dandar,Qaryah-ye Danḏar,dndar,دندار,قريه دنډر,ډنډر,Ḏanḏar', 34.7909500, 69.4750400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(244, 'Ḩukūmatī Dahanah-ye Ghōrī', 'Hukumati Dahanah-ye Ghori', 'Dahana,Dahana Ghori,Dahana-i-Ghori,Dahanae Ghori,Dahaneh-ye Ghowri,Dahaneh-ye Ghowṟī,Dahna,Dahāna,Dananeh-ye Ghowri,Dananeh-ye Ghowrī,Hokumati Dahana-i-Ghori Dahana,Hokūmatī Ḏahana-i-Ghōṟi Dahana,Hukumati Dahanah-ye Ghori,hkwmty dhnh ghwry,حکومتی دهنه غوری,Ḏahana-i-Ghōṟi,Ḏahanae Ghōṟi,Ḩukūmatī Dahanah-ye Ghōrī', 35.9061700, 68.4886900, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(245, 'Tsowkêy', 'Tsowkey', 'Cawkae,Cawkay,Chaukai,Chauki,Chowkay,Chowkey,Chowki,Chowkī,Tsowkey,Tsowkêy,chwky,Čawkae,څوکۍ,چوكی', 34.6924600, 70.9268800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(246, 'Chīras', 'Chiras', 'Chiras,Chīras,Ciras,Cīras', 35.4167400, 65.9823400, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(247, 'Chisht-e Sharīf', 'Chisht-e Sharif', 'Ceste Sarif,Ces̄te S̄aṟīf,Chesht-e Sharif,Chesht-e Sharīf,Chest-e Sharif,Chisht-e Sharif,Chisht-e Sharīf,Chusht-e Sharif,Chusht-e Sharīf,Khvajeh Chesht,Khvājeh Chesht,Khwaja Chist,Qaryeh-ye Chest-e Sharif,Qaryeh-ye Chest-e Sharīf,chsht shryf,چشت شریف', 34.3473100, 63.7396600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(248, 'Chinār', 'Chinar', 'Cenar,Chenar,Chenār,Chinar,Chinār,Chīnār,chnar,chynar,Čenār,چنار,چینار', 32.0158300, 65.1072100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(249, 'Chimtāl', 'Chimtal', 'Ahan Qal`eh,Cemtal,Cemtāl,Chemtal,Chemtāl,Chimtal,Chimtal'',Chimtāl,chmtal,chmtl,Āhan Qal‘eh,Чимталь,چمتال,چمتل', 36.6781800, 66.8032500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(250, 'Charkh', 'Charkh', 'Carkh,Charkh,chrkh,Čarkh,چرخ', 33.7971200, 68.9374900, 'AF', '2013-03-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(251, 'Charikar', 'Charikar', 'Caharikar,Carikar,Carikaras,Chaharikar,Chahārīkār,Chairkar,Charekar,Charikar,Chāirkār,Chārīkār,Czarikar,Cāṟikāṟ,Tscharikar,carikar,carikara,charikari,charykar,qia li ka er,Çarikar,Ĉarikar,Čahārikār,Čarikaras,Чарикар,چاريكار,چاریکار,चारीकार,চরিকর,சாரிகார்,ჩარიქარი,恰里卡尔', 35.0136100, 69.1713900, 'AF', '2010-01-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(252, 'Dowr-e Rabāţ', 'Dowr-e Rabat', 'Cardara,Chahar Darreh,Chahār Darreh,Char Darah,Char Darreh,Chār Darah,Chār Darreh,Cāṟḏaṟa,Davri-Rabat,Dawr-i-Rabat,Dawṟ-i-Ṟabāṯ,Dowr-e Rabat,Dowr-e Rabāţ,Ribat,Ribāt,char drh,dwr rbat,Даври-Рабат,دور رباط,دورٔ رباط,چار دره', 36.6913200, 68.7909300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(253, 'Tsapêraī', 'Tsaperai', 'Capare,Capaṟē,Chapare,Chapray,Chhapri,Tsapare,Tsaparē,Tsaperai,Tsapêraī,څپری,څپرې', 33.8300300, 69.9192000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(254, 'Tsamkanī', 'Tsamkani', 'Camkani,Chakmani,Chamkani,Chamkanī,Dzamkani,Dzamkanī,Pir Sarai,Pir Serai,Pīr Sarāi,Qal`eh-ye Chamkani,Qal‘eh-ye Chamkanī,Sakmanni Parao,Tsamkani,Tsamkanī,chmkny,Čamkani,څمکنی,چمکنی', 33.8029800, 69.8167100, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(255, 'Chakaray', 'Chakaray', 'Cakaray,Chakarai,Chakaray,Chakari,Chakarī,Chakaṟaī,Charkari,Dasht-e Chakaray,chkry,dsht chkry,Čakaray,دشت چکری,چکری', 34.3409900, 69.4377000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(256, 'Chākarān', 'Chakaran', 'Cakaran,Chakaran,Chākarān,Cākaṟān,Khakaran,Khākarān,chakran,چاکران', 36.9111200, 71.0688000, 'AF', '2013-11-07', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(257, 'Chahār Qal‘ah', 'Chahar Qal`ah', 'Caharqal`a,Chahar Qal`ah,Chahar Qal`eh,Chahār Qal‘ah,Chahār Qal‘eh,Chakharkala,Čahārqal‘a,چهار قلعه', 33.5526700, 68.2982800, 'AF', '2013-03-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(258, 'Chahār Burj', 'Chahar Burj', 'Car Burj,Chahar Borj,Chahar Burj,Chahar Burjak,Chahār Borj,Chahār Burj,Chahār Burjak,Char Burj,Charburdzh,Chār Burj,chhar brj,Čār Burj,چهار برج', 34.2447500, 62.1916500, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(259, 'Chāh Āb', 'Chah Ab', 'Cah Ab,Cah-i-Ab,Chah Ab,Chah-e Ab,Chah-i-Ab,Chayab,Chāh Āb,Chāh-e Āb,Chāh-i-Āb,Cāh Āb,Cāh-i-Āb,chah ab,چاه آب', 37.3977300, 69.8146400, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(260, 'Fayrōz Kōh', 'Fayroz Koh', 'CCN,Caghcaran,Caghcaṟān,Cakhcaran,Cakhcaṟān,Chaghcharan,Chaghcharān,Chakcharan,Chakhcharan,Chekcheran,Fayroz Koh,Fayrōz Kōh,chghchran,fyrwz kwh,فيروز کوه,چغچران', 34.5195200, 65.2509300, 'AF', '2017-02-17', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(261, 'Bulōlah', 'Bulolah', 'Bolola,Bolowleh,Boluleh,Bolōla,Bolūleh,Bulola,Bulolah,Bulōlah,blwlh,بلوله', 34.8770600, 68.0879000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(262, 'Bal Chirāgh', 'Bal Chiragh', 'Bal Chiragh,Bal Chirāgh,Belceragh,Belcheragh,Belcherāgh,Belchirag,Belchiragh,Belchirāg,Belchirāgh,Bilchiragh,Bilchirāgh,Bēlceṟāgh,Bēlchirāgh,bl chragh,بل چراغ,بېل چراغ', 35.8402600, 65.2309000, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(263, 'Bāzār-e Tālah', 'Bazar-e Talah', 'Bazar-e Talah,Bazar-e Taleh,Bazare Tala,Bāzār-e Tālah,Bāzār-e Tāleh,Bāzāṟe Tāla,Tala,Tala Barfaq,bazar talh,بازار تاله', 35.3920500, 68.2231700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(264, 'Bāsawul', 'Basawul', 'Basavul'',Basavul’,Basawul,Basowl,Bāsawul,Bāsowl,Mohmand Darrah,baswl,باسول', 34.2474900, 70.8721800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(265, 'Būrkah', 'Burkah', 'Barkah,Borkeh,Burka,Burkah,Buṟka,Būrkah,bwrkh,بورکه', 36.2224200, 69.1503700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(266, 'Barg-e Matāl', 'Barg-e Matal', 'Barg-e Matal,Barg-e Matāl,Barg-e Maṯāl,Barge Matal,Bargi-Matal'',Bargi-Matal’,Baṟge Matāl,Bragamata,Bragamatal,Lutdeh,brg mtal,برگ متال', 35.6728300, 71.3433900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(267, 'Baraki Barak', 'Baraki Barak', 'Barah Ki Barak,Barah Kī Barak,Baraki Barak,Baraki Burak,Barakibarak,Barakī Barak,Barqi Barq,OAA,brh ky brk,brky brk,بره کی برک,برکی برک', 33.9674400, 68.9492000, 'AF', '2017-01-14', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(268, 'Banū', 'Banu', 'Andarab,Andarāb,Banow,Banu,Banū,bnw,بنو', 35.6334800, 69.2601900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(269, 'Bāmyān', 'Bamyan', 'BIN,Bamian,Bamiyan,Bamyan,Bāmyān,Bāmīān,Kala Sarkari,Qal`a Sarkarit,Qala Sarkari,Qala Sarkāri,Qal‘a Sarkārit,bamyan,باميان', 34.8215600, 67.8273400, 'AF', '2017-02-15', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(270, 'Balkh', 'Balkh', 'Bactra,Bactresh,Bakhtar,Balch,Balchas,Balh,Balhika,Balho,Balj,Balkh,Balx,Balĥo,Bamik,Bazirabad,Belh,Belx,Bkahdi,Bākhtar,Daerah Balkh,Quan Balkh,Quận Balkh,Vazirabad,ba er he,balheu,barufu,blk,blkh,Μπαλχ,Балх,Вазирабад,Բալխ,בלך,بلخ,বাল্‌খ,ബൽഖ്,バルフ,巴尔赫,발흐', 36.7563500, 66.8972000, 'AF', '2014-11-21', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(271, 'Bahārak', 'Baharak', 'Bagorak,Baharak,Baharestan,Baharistan,Bahārak,Bahārestān,Bahāristān,Bakharak,Barak,Becharek,Bekharek,bhark,بهارک', 37.0025400, 70.9066400, 'AF', '2013-11-07', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(272, 'Bagrāmī', 'Bagrami', 'Bagrame,Bagrami,Bagrāmē,Bagrāmī,Bigrami,Bigrāmī,Qaryeh-ye Bagrami,Qaryeh-ye Bagrāmī,bgramy,بگرامی', 34.4937600, 69.2742700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(273, 'Baghlān', 'Baghlan', 'Baghlan,Baghlan - bghlan,Baghlan - بغلان,Baghlan-e Jadid,Baghlin,Baghlān,Baghlān-e Jadīd,Baglan,Bagolaggo,Sana `Ati,Sana`ati,bghlan,bghlan jdyd,Şanā ‘Ati,Şanā‘atī,Баглан,بغلان,بغلان جديد,صناعتی', 36.1306800, 68.7082900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(274, 'Ḩukūmatī Azrah', 'Hukumati Azrah', 'Azra,Azrah,Azraw,Azreh,Azrow,Azru,Azrū,Azṟa,Azṟaw,Hazrah,Hazro,Hokumati Azraw,Hokumati Azrow,Hukumati Azrah,Khukumati-Azrau,azrh,azrw,hkwmty azrh,Āzreh,ازره,ازرو,حکومتی ازره,Ḩokūmatī Azṟaw,Ḩokūmatī Āzrow,Ḩukūmatī Azrah', 34.1735500, 69.6457300, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(275, 'Ārt Khwājah', 'Art Khwajah', 'Art Khvajeh (1),Art Khwajah,At Khvajeh,At Khwaja,art khwajh,Ārt Khwājah,Āt Khvājeh,Āt Khwāja,Āṟt Khvājeh (1),آرت خواجه', 37.0857100, 69.4795800, 'AF', '2012-01-16', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(276, '‘Alāqahdārī Aṯghar', '`Alaqahdari Atghar', 'Alakadari-Atgar,Arghar,Ataghar,Atghar,Aţghar,Aṯaghaṟ,`Alaqadari Atghar,`Alaqahdari Atghar,`Alaqehdari-ye Atghar,atghr,اتغر,اطغر,علاقهدارئ اټغر,‘Alāqahdārī Aṯghar,‘Alāqaḏāri Aṯghar,‘Alāqehḏārī-ye Aţghar', 31.7350600, 67.3574000, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(277, 'Āsmār', 'Asmar', 'Asma,Asmar,Asmār,asmar,Āsmā,Āsmār,آسمار,اسمار', 35.0333300, 71.3580900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(278, 'Ashkāsham', 'Ashkasham', '', 36.6833300, 71.5333300, 'AF', '2006-01-27', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(279, 'Asadābād', 'Asadabad', 'Asadabad,Asadābād,Assad-Abad,Caghasaray,Chagha Serai,Chagha-Sari,Chaghah Saray,Chaghah Sarāy,Chaghasarai,Chaghasaray,Chaghasarāy,Chagsarai,Chegheh Saray,Chegheh Sarāy,Chigha Sarai,Chigha Sarāi,Chigha Serai,Chigkhasaray,asd abad,chghh sray,Čaghasarāy,Асадабад,اسد آباد,چغه سرای', 34.8731100, 71.1469700, 'AF', '2012-02-24', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(280, 'Āqchah', 'Aqchah', 'Ag Chah,Akcha,Akcheh,Aqca,Aqcha,Aqchah,Aqcheh,aqchh,Āg Chāh,Ākchā,Āqca,Āqchah,Āqcheh,آقچه', 36.9050000, 66.1834100, 'AF', '2013-10-04', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(281, 'Andkhōy', 'Andkhoy', 'Andkhoi,Andkhoy,Andkhui,Andkhvoy,Andkhōy,Andkhōī,Andkhūi,Ankhoi,andkhwy,اندخوی', 36.9529300, 65.1237600, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(282, '’Unābah', '''Unabah', '''Unabah,Anava,Anawa,Anawah,anawh,Ānāwa,Ānāwah,آناوه,عنابه,’Unābah', 35.2325100, 69.3771900, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(283, 'Anār Darah', 'Anar Darah', 'Anar Dara,Anar Darah,Anar Darrah,Anar Darreh,Anardara,Anardarra,Anār Darah,Anār Darrah,Anār Darreh,Anārdarra,Saykh Abad,Shaykh Abad,Shaykh Ābād,S̄aykh Ābāḏ,anar drh,shykh abad,Анар Дара,انار دره,شیخ آباد', 32.7587000, 61.6539700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(284, 'Amānzī', 'Amanzi', 'Amanzai,Amanzey,Amanzi,Amin Za''i,Amin Za’ī,Amānzaī,Amānzey,Amānzi,Amānzī,amanzy,amn zyy,امانزی,امن زئی', 30.2114400, 66.0476500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(285, '‘Alāqahdārī-ye Almār', '`Alaqahdari-ye Almar', 'Alaqadari-i-Almar,Almar,Almar Bazar,Almar Bāzār,Almār,Alāqaḏāṟi-i-Almāṟ,`Alaqahdari-ye Almar,almar,المار,علاقه داری المار,‘Alāqahdārī-ye Almār', 35.8461600, 64.5307400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(286, '‘Alī Shēr ‘Alāqahdārī', '`Ali Sher `Alaqahdari', 'Aliser ''Alaqadari,Alishahr,Alisheralakadari,Ališēr ’Alāqadāri,Alīshahr,`Ali Sher,`Ali Sher `Alaqahdari,`Ali Shir `Alaqehdari,علی شير علاقهداری,علی شېر,علی شېر علاقه داری,‘Alī Shēr,‘Alī Shēr ‘Alāqahdārī,‘Alī Shīr ‘Alāqehdārī', 33.4362000, 70.0671100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(287, 'Wuluswālī ‘Alīngār', 'Wuluswali `Alingar', 'Oluswali Alingar,Oluswāli Alīngāṟ,Ulusvali-Alingar,Wuluswali `Alingar,Wuluswālī ‘Alīngār,`Alingar,ولسوالی علینگار,‘Alīngār', 34.8352900, 70.3593000, 'AF', '2014-01-08', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(288, '‘Alī Khēl', '`Ali Khel', 'Alikheyl'',Alikheyl’,`Ali Khel,`Ali Kheyl,`Alikhel,علی خېل,‘Alikhēl,‘Alī Kheyl,‘Alī Khēl', 33.9425300, 69.7190800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(289, '‘Alāqahdārī Yōsuf Khēl', '`Alaqahdari Yosuf Khel', 'Alakadari-Yusufkheyl'',Alakadari-Yusufkheyl’,Yosuf Khel,Yōsuf Khēl,`Aaqadari Yosufkhel,`Alaqadari Yosufkhel,`Alaqahdari Yosuf Khel,`Alaqehdari Yusofkheyl,`Alaqehdari-ye Yusof Kheyl,علاقه داری یوسف خېل,‘Alāqahdārī Yōsuf Khēl,‘Alāqaḏāṟī Yōsufkhēl,‘Alāqehdārī Yūsofkheyl,‘Alāqehdārī-ye Yūsof Kheyl,‘Aāqaḏāṟī Yōsufkhēl', 33.0519500, 68.6500000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(290, '‘Alāqahdārī Dīshū', '`Alaqahdari Dishu', 'Dishu,Dīshū,`Alaqadari Dehe Su,`Alaqahdari Deh-e Shu,`Alaqahdari Dishu,`Alaqehdari Deh-e Shu,علاقهداری ده شو,علاقهداری ديشو,‘Alāqahdārī Deh-e Shū,‘Alāqahdārī Dīshū,‘Alāqaḏāṟī Dehe S̄u,‘Alāqehdārī Deh-e Shū', 30.4320600, 63.2980200, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(291, 'Alah Sāy', 'Alah Say', 'Alah Say,Alah Sāy,Alasay,Alasāy,alh say,اله سای,شيلۀ اله', 34.8965000, 69.7204900, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(292, 'Pachīr wa Āgām', 'Pachir wa Agam', 'Agam,Agām,Pachier Agam,Pachir Agam,Pachir Aw Agam,Pachir wa Agam,Pachiro Agam,Pachiro Agām,Pachīer Agam,Pachīr Aw Āgām,Pachīr wa Āgām,Pachīr Āgām,Pachīrō Agām,Paciro Agam,Pačīro Agām,agam,pchyr w agam,pchyrw agam,اگام,پچير و آگام,پچیرو اگام', 34.2001100, 70.2780600, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(293, 'Afaki', 'Afaki', 'Afaki,Afaqi,afaqy,Āfāqī,Афаки,آفاقی', 36.6617200, 69.3509500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(294, 'Adraskan', 'Adraskan', 'Adraskan,Adraskand,Adreskan,Adriskan,Aḏṟeskan,Gala,Gala Adraskan,Kala Adraskan,Kala Adrāskan,Qal`eh Adraskand,Qala Adraskan,Qala Adrāskān,Qal‘eh Adraskand,adrskn,ادرسکن', 33.6457300, 62.2695900, 'AF', '2012-05-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(295, 'Āb-e Kamarī', 'Ab-e Kamari', 'Ab-e Kamari,Ab-i-Kamari,ab kmry,Āb-e Kamarī,Āb-i-Kamaṟi,آب کمری', 35.0879600, 63.0678000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(296, 'Khadīr', 'Khadir', 'Khadir,Khadīr,khdyr,خدیر', 33.9223200, 65.9339800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(297, 'Ghulām ‘Alī', 'Ghulam `Ali', 'Gholam `Ali,Gholām ‘Alī,Ghulam `Ali,Ghulām ‘Alī,Gulyamali,Qaryah-ye Shahr-e Now Ghulam ''Ali,Qaryah-ye Shahr-e Now Ghulām ’Alī,Vulusvaliyi-Bagram,Woluswali-i-Bagram,Woluswali-ye Bagram,Woluswālī-i-Bagṟām,Woluswālī-ye Bagrām,wlswaly bgram,غلام علی,قريه شهر نو غلام علی,ولسوالی بگرام', 34.9507600, 69.2287000, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(298, 'Qarah Bāgh Bāzār', 'Qarah Bagh Bazar', 'Bazar-e Qarah Bagh,Bāzār-e Qarah Bāgh,Karabagbazar,Qarabagh Bazar,Qarah Bagh Bazar,Qarah Bāgh Bāzār,Qareh Bagh Bazar,Qareh Bāgh Bāzār,Qaṟabāgh Bāzāṟ,bazar qrh bagh,qrh bagh bazar,بازار قره باغ,قره باغ بازار', 34.8529000, 69.1706200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(299, 'Zargarān', 'Zargaran', 'Zargaran,Zargarān,zrgran,زرگران', 34.7876400, 69.0587800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(300, 'Surkh Bilandī', 'Surkh Bilandi', 'Sorkh Bilandi,Sorkh Bilandī,Sorkh Bolandi,Sorkh Bolandī,Surkh Bilandi,Surkh Bilandī,Surkh-Belandi,Surkhbilandi,Suṟkh-Belanḏi,srkh blndy,سرخ بلندی', 34.6847400, 69.0286300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(301, 'Pul-e Sangī', 'Pul-e Sangi', 'Pol-e Sangi,Pol-e Sangī,Pul-e Sangi,Pul-e Sangī,Pule Sangi,Puli-Sangi,Qaryah-ye Sangi,Qaryah-ye Sangī,pl sngy,qryh sngy,قریه سنگی,پل سنگی,پلٔ سنگی', 34.5997200, 69.2599300, 'AF', '2014-02-10', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(302, 'Langar', 'Langar', 'Langar,Qaryah-ye Langar,lngr,qryh lngr,قريه لنگر,لنگر', 35.9947400, 68.0508100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(303, 'Bāgh-e Maīdān', 'Bagh-e Maidan', 'Bagh-e Maidan,Bagh-e Meydan,Bagh-e Meydān,Baghe Maydan,Bagi-Maydan,Bāgh-e Maīdān,Bāghe Mayḏān,bagh mydan,bgh mydan,باغ میدان,بغ ميدان', 35.2215600, 69.2139700, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(304, 'Ibrāhīm Khān', 'Ibrahim Khan', 'Ebrahimkhan,Ebrāhīmkhān,Ibrahim Khan,Ibrakhimkhan,Ibrāhīm Khān,Qaryah-ye Ibrahim Khel,Qaryah-ye Ibrāhīm Khēl,abrahym khan,ابراهيم خان,ابراهیم خان,قريه ابراهيم خېل', 35.0535200, 69.2565400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(305, 'Qaranghū Tōghaī', 'Qaranghu Toghai', 'Karankutugay,Qaranghu Toghai,Qaranghū Tōghaī,Qaryah-ye Qaran Toghai,Qaryah-ye Qaran Tōghaī,qrnghw twghy,qryh qrn twghy,قرنغو توغی,قريه قرن توغی', 37.2152800, 67.6397200, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(306, 'Bāzārak', 'Bazarak', 'Bazarak,Bāzārak,bazark,Базарак,بازارك,بازارک', 35.3129200, 69.5151900, 'AF', '2013-08-02', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(307, 'Shērwānī-ye Bālā', 'Sherwani-ye Bala', 'Serwani Bala,Shayrwan-e Bala,Shayrwani,Shayrwani-ye Bala,Shayrwān-e Bālā,Shayrwānī,Shayrwānī-ye Bālā,Shervani-Bala,Sherwani-ye Bala,Shirvani Bala,Shērwānī-ye Bālā,Shīrvānī Bālā,shyrwan bala,shyrwany,shyrwany bala,Šērwāni Bālā,Шервани-Бала,شيروانی,شيروانی بالا,شیروان بالا', 35.0146800, 69.5993400, 'AF', '2013-05-09', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(308, 'Kirāmān', 'Kiraman', 'Keraman,Kerāmān,Kiraman,Kirāmān,kraman,Кираман,کرامان', 35.2973000, 69.6812500, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(309, '‘Alāqahdārī Saṟōbī', '`Alaqahdari Sarobi', 'Alakadari-Sarobi,Sarobi,Saṟōbī,`Alaqadari Sarobi,`Alaqadari-ye Sarubi,`Alaqahdari Sarobi,`Alaqahdari-ye Sarobi,علاقه داری سړوبی,‘Alāqadārī-ye Saṟūbī,‘Alāqahdārī Saṟōbī,‘Alāqahdārī-ye Saṟōbī,‘Alāqaḏārī Saṟōbi', 32.7933100, 69.0866000, 'AF', '2012-05-06', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(310, 'Zerok-Alakadari', 'Zerok-Alakadari', 'Zerok Alagadari,Zerok Alaqadari,Zerok `Alaqahdari,Zerok-Alakadari,Zeruk `Alaqahdari,Ziruk,Ziruk `Alaqahdari,Ziruk `Alaqehdari,Zērōk Alāgaḏāṟī,Zērōk Alāqaḏāṟi,Zērūk ‘Alāqahdārī,Zēṟōk ‘Alāqahdārī,Zīṟūk,Zīṟūk ‘Alāqahdārī,Zīṟūk ‘Alāqehdārī,زیړوک,زیړوک علاقه داری', 33.1580600, 69.3127800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(311, 'Kushkak', 'Kushkak', 'Kushkak,Kuskak,Kuškak,Kūshkak,kshkk,کشکک', 32.2899100, 61.5219400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(312, 'Khayr Kōṯ', 'Khayr Kot', 'Khayr Kot,Khayr Kōṯ,Khayrkot,Kheyr Kut,Kheyr Kūt,khyr kwt,خیر کوت,خیر کوټ', 32.8535500, 68.4497100, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(313, 'Chowṉêy', 'Chowney', 'Cawnay,Chawnay,Chowney,Chowṉêy,Čawnay,چوڼۍ', 33.3827800, 66.2723300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(314, 'Wuṯahpūr', 'Wutahpur', 'Votapur,Watahpur,Waṯahpūr,Wotapur,Wotapūr,Wutahpur,Wuṯahpūr,wtpwr,وتپور,وټه پور', 34.9191400, 71.0986300, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(315, 'Karbori', 'Karbori', 'Karbori,Karburi,Karbōṟī,Karbūri,Kaṟbōri,كربوړی', 34.9659700, 71.2746000, 'AF', '2014-01-15', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(316, 'Sulţānpūr-e ‘Ulyā', 'Sultanpur-e `Ulya', 'Soltanpur-e `Olya,Soltānpūr-e ‘Olyā,Sultan Pur,Sultanpur-e `Ulya,Sultanpure `Ulya,Sultanpuri-Ulia,Sulţān Pūr,Sulţānpūr-e ‘Ulyā,Sūltānpūṟe ‘Ulyā,sltan pwr,سلطان پور,سلطانپور علیا,سلطانپورٔ علیا', 34.4120400, 70.2963400, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(317, 'Babasakhib', 'Babasakhib', 'Baba Saheb,Baba Sahib,Babasakhib,Bābā Şāḩeb,Bābā Şāḩib,baba sahb,بابا صاحب', 31.6614400, 65.6609800, 'AF', '2012-02-28', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(318, 'Chandal Bā’ī', 'Chandal Ba''i', 'Candalba''i,Chandal Ba''i,Chandal Bā’ī,Chandalba''e,Chandalba''i,Chandalbā’e,Chandalbā’i,chndl bayy,Čandalbā’i,چندل بائی', 34.5846900, 68.9552400, 'AF', '2012-08-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(319, 'Dahan-e Jarf', 'Dahan-e Jarf', 'Dahan-e Jarf,Dakhani-Dzharf,dhn jrf,دهن جرف', 34.9289100, 68.4627300, 'AF', '2012-05-06', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(320, 'Maydanshakhr', 'Maydanshakhr', 'Maidan Shahr,Maidan Shar,Maydanshakhr,Maīdān Shahr,Maīdān S̲h̲ār,Meydan Shahr,Meydān Shahr,mydan shhr,ميدان شهر', 34.3956100, 68.8661800, 'AF', '2012-10-07', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(321, 'Dū Laīnah', 'Du Lainah', 'Dolayna,Dolaynah,Dorahi Ghor,Du Lainah,Dulaynah,Durahi Ghor,Durāhī Ghōr,Dū Laīnah,dlynh,drahy ghwr,dw lynh,دراهی غور,دلینه,دو لينه,Ḏolayna,Ḏoṟāhī Ghōṟ', 34.1559900, 64.7856600, 'AF', '2012-05-06', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(322, 'Qaram Qōl', 'Qaram Qol', 'Qaram Qol,Qaram Qōl,Qaramqol,Qaramqul,Qaramqūl,qrm qwl,قرم قول', 36.8300600, 65.0429900, 'AF', '2012-02-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(323, 'Pul-e Ḩişār', 'Pul-e Hisar', 'Pol-e Hesar,Pol-e Ḩeşār,Pul-e Hisar,Pul-e Ḩişār,Pule Hesar,Pule Hesāṟ,pl hsar,پل حصار', 35.6179400, 69.4713400, 'AF', '2012-02-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(324, 'Lab-Sar', 'Lab-Sar', '', 36.0263400, 66.8379900, 'AF', '2012-02-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(325, 'Ţāqchah Khānah', 'Taqchah Khanah', 'Taqca Khana,Taqchah Khanah,Taqcheh Khaneh,Tāqchah Khānah,Tāqcheh Khāneh,Tāqča Khāna,taqchh khanh,Ţāqchah Khānah,تاقچه خانه,طاقچه خانه', 36.6192200, 69.6280500, 'AF', '2012-02-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(326, 'March', 'March', 'Marc,March,Maṟc,Qaryah-ye Murch,mrch,qryh mrch,قريه مرچ,مرچ', 37.5284500, 70.4482000, 'AF', '2012-02-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(327, 'Zīrakī', 'Ziraki', 'Ziraki,Zīrakī,Zīṟakī,zyrky,زیرکی', 37.5923300, 70.5581400, 'AF', '2013-09-09', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(328, 'Aliabad', 'Aliabad', 'Aliabad,`Ali Abad,`Aliabad,Алиабад,علی آباد,‘Alī Ābād,‘Alīābād', 36.5211500, 68.8998500, 'AF', '2012-02-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1, 'El Tarter', 'El Tarter', 'Ehl Tarter,Эл Тартер', 42.5795200, 1.6536200, 'AD', '2012-11-03', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2, 'Sant Julià de Lòria', 'Sant Julia de Loria', 'San Julia,San Julià,Sant Julia de Loria,Sant Julià de Lòria,Sant-Zhulija-de-Lorija,sheng hu li ya-de luo li ya,Сант-Жулия-де-Лория,サン・ジュリア・デ・ロリア教区,圣胡利娅-德洛里亚,圣胡利娅－德洛里亚', 42.4637200, 1.4912900, 'AD', '2013-11-23', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3, 'Pas de la Casa', 'Pas de la Casa', 'Pas de la Kasa,Пас де ла Каса', 42.5427700, 1.7336100, 'AD', '2008-06-09', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(4, 'Ordino', 'Ordino', 'Ordino,ao er di nuo,orudino jiao qu,Ордино,オルディノ教区,奥尔迪诺', 42.5562300, 1.5331900, 'AD', '2009-12-11', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(5, 'les Escaldes', 'les Escaldes', 'Ehskal''des-Ehndzhordani,Escaldes,Escaldes-Engordany,Les Escaldes,esukarudesu=engorudani jiao qu,lai sai si ka er de-en ge er da,Эскальдес-Энджордани,エスカルデス＝エンゴルダニ教区,萊塞斯卡爾德-恩戈爾達,萊塞斯卡爾德－恩戈爾達', 42.5072900, 1.5341400, 'AD', '2008-10-15', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(6, 'la Massana', 'la Massana', 'La Macana,La Massana,La Maçana,La-Massana,la Massana,ma sa na,Ла-Массана,ラ・マサナ教区,马萨纳', 42.5449900, 1.5148300, 'AD', '2008-10-15', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(7, 'Encamp', 'Encamp', 'Ehnkam,Encamp,en kan pu,enkanpu jiao qu,Энкам,エンカンプ教区,恩坎普', 42.5347400, 1.5801400, 'AD', '2012-04-13', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(8, 'Canillo', 'Canillo', 'Canillo,Kanil''o,ka ni e,kaniryo jiao qu,Канильо,カニーリョ教区,卡尼略', 42.5676000, 1.5975600, 'AD', '2012-12-24', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(9, 'Arinsal', 'Arinsal', 'Arinsal,Arinsal'',Arinsalis,arynsal,Аринсал,Аринсаль,آرینسال', 42.5720500, 1.4845300, 'AD', '2010-01-29', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(10, 'Andorra la Vella', 'Andorra la Vella', 'ALV,Ando-la-Vyey,Andora,Andora la Vela,Andora la Velja,Andora lja Vehl''ja,Andoro Malnova,Andorra,Andorra Tuan,Andorra a Vella,Andorra la Biella,Andorra la Vella,Andorra la Vielha,Andorra-a-Velha,Andorra-la-Vel''ja,Andorra-la-Vielye,Andorre-la-Vieille,Andò-la-Vyèy,Andòrra la Vièlha,an dao er cheng,andolalabeya,andwra la fyla,Ανδόρρα,Андора ла Веля,Андора ла Веља,Андора ля Вэлья,Андорра-ла-Велья,אנדורה לה וולה,أندورا لا فيلا,አንዶራ ላ ቬላ,アンドラ・ラ・ヴェリャ,安道爾城,안도라라베야', 42.5077900, 1.5210900, 'AD', '2010-05-30', 6);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(11, 'Umm al Qaywayn', 'Umm al Qaywayn', 'Oumm al Qaiwain,Oumm al Qaïwaïn,Um al Kawain,Um al Quweim,Umm al Qaiwain,Umm al Qawain,Umm al Qaywayn,Umm al-Quwain,Umm-ehl''-Kajvajn,Yumul al Quwain,am alqywyn,Умм-эль-Кайвайн,أم القيوين', 25.5647300, 55.5551700, 'AE', '2014-10-07', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(12, 'Ras al-Khaimah', 'Ras al-Khaimah', 'Julfa,Khaimah,RKT,Ra''s al Khaymah,Ra''s al-Chaima,Ras al Khaimah,Ras al-Khaimah,Ras el Khaimah,Ras el Khaïmah,Ras el-Kheima,Ras-ehl''-Khajma,Ra’s al Khaymah,Ra’s al-Chaima,ras alkhymt,Рас-эль-Хайма,رأس الخيمة', 25.7895300, 55.9432000, 'AE', '2015-12-05', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(13, 'Muzayri‘', 'Muzayri`', 'Mezaira''a,Mezaira’a,Mizeir`ah,Mizeir‘ah,Mozayri`,Mozayri‘,Muzairi,Muzayri`,Muzayri‘,Музаири', 23.1435500, 53.7881000, 'AE', '2013-10-24', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(14, 'Khawr Fakkān', 'Khawr Fakkan', 'Fakkan,Fakkān,Khawr Fakkan,Khawr Fakkān,Khawr al Fakkan,Khawr al Fakkān,Khor Fakhan,Khor Fakkan,Khor Fakkān,Khor al Fakhan,Khor al Fakkan,Khor al Fākhān,Khor''fakkan,Khor-Fakkan,Khorfakan,Khorfakhan,Port Khor Fakkan,Хор-Факкан', 25.3313200, 56.3419900, 'AE', '2013-10-25', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(15, 'Dubai', 'Dubai', 'DXB,Dabei,Dibai,Dibay,Doubayi,Dubae,Dubai,Dubai emiraat,Dubaija,Dubaj,Dubajo,Dubajus,Dubay,Dubayy,Dubaï,Dubái,Dúbæ,Ehmirat Dubaj,Fort Dabei,Ntoumpai,dby,dbyy,di bai,dobai,du bai,duba''i,dubai,dubay,dubi,dwbyy,tupai,Ντουμπάι,Дубаи,Дубай,Эмірат Дубай,Դուբայի Էմիրություն,דובאי,דוביי,دبئی,دبى,دبي,دبی,دوبەی,دۇبائى,दुबई,দুবাই,துபை,దుబాయ్,ದುಬೈ,ദുബായ്,ดูไบ,დუბაი,ドバイ,杜拜,迪拜,두바이', 25.0657000, 55.1712800, 'AE', '2014-12-02', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(16, 'Dibba Al-Fujairah', 'Dibba Al-Fujairah', 'Al-Fujairah,BYB,Dibba Al-Fujairah,dba alfjyrt,دبا الفجيرة', 25.5924600, 56.2617600, 'AE', '2014-08-12', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(17, 'Dibba Al-Hisn', 'Dibba Al-Hisn', 'BYB,Daba,Daba al-Hisn,Dabā,Dabā al-Ḥiṣn,Diba,Diba al Hisn,Dibah,Dibba,Dibba Al''-Khisn,Dibba Al-Hisn,Dibbah,Dibā,Dībā al Ḩişn,Hisn Diba,Husn Dibba,Дибба Аль-Хисн,Ḩişn Dibā', 25.6195500, 56.2729100, 'AE', '2014-04-21', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(18, 'Sharjah', 'Sharjah', 'Al Sharjah,Ash ''Mariqah,Ash Shariqa,Ash Shariqah,Ash Shāriqa,Ash Shāriqah,Ash ’Mariqah,Ash-Shariqah emiraat,Ash-Shāriqah emiraat,Charjah,Ch·ardj·a,Gorad Shardzha,SHJ,Sardza,Sardzsa,Sarika,Sarja,Sarjo,Sarza,Schardscha,Shardza,Shardzha,Shardzha kuorat,Sharga,Sharijah,Shariqah,Sharja,Sharjah,Shārijah,Shāriqah,Shārja,Szardza,Szardża,Xarja,Xarjah,alsharqt,amart alsharqt,carja,charc ah,saraja,sarajaha,sarja,sharja,sharjh,sharuja,syaleuja,sʼrgh,xia er jia,Ŝarĵo,Şarika,Şarja,Šardža,Šardžá,Горад Шарджа,Шарджа,Шарджа куорат,Шарџа,Шарҗә,Շարժա,שארגה,إمارة الشارقة,الشارقة,شارجه,شارجہ,शारजा,शारजाह,ਸ਼ਾਰਜਾ,சார்ஜா,షార్జా,ಶಾರ್ಜ,ഷാർജ,ชาร์จาห์,შარჯა,シャールジャ,夏尔迦,샤르자', 25.3373700, 55.4120600, 'AE', '2013-03-05', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(19, 'Ar Ruways', 'Ar Ruways', 'Ar Ru''ays,Ar Ruways,Ar Ru’ays,Ar-Ruvais,Ruwais,Ар-Руваис', 24.1102800, 52.7305600, 'AE', '2012-11-03', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(20, 'Al Fujayrah', 'Al Fujayrah', 'Al Fujayrah,Al-Fudjayra,Al-Fujayrah'' emiraat,FJR,Fudschaira,Fudzhejra,Fujaira,Fujairah,Fujajro,Fujayrah,Fuĵajro,alfjyrt,fjyrt,fu ji la,fujaira,Фуджейра,الفجيرة,فجيرة,フジャイラ,富吉拉', 25.1164100, 56.3414100, 'AE', '2016-12-18', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(21, 'Al Ain', 'Al Ain', 'AAN,Ainas,Al Ain,Al Ajn,Al Ayn,Al `Ayn,Al Ɛayn,Al ‘Ayn,Al-Ain,Al-Ajn,Al-Ayin,Al-Ayn,Al-Aïn,Ehl''-Ajn,El Ain,El-Ajn,ai yin,al ain,al-ain,al-aini,alʿyn,ela ena,Ел Аин,Эль-Айн,Ալ-Ային,אל-עין,العين,العین,एल एन,அல் ஐன்,അൽ ഐൻ,ალ-აინი,アル・アイン,艾因,알아인', 24.1916700, 55.7605600, 'AE', '2013-03-17', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(22, 'Ajman', 'Ajman', 'Ajman,Al Ajman,QAJ,Ujman,ʿjman,عجمان', 25.4111100, 55.4350400, 'AE', '2013-03-24', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(23, 'Adh Dhayd', 'Adh Dhayd', 'Adh Dhaid,Adh Dhayd,Al Daid,Al-Dhayd,Dayd,Dhaid,Dhayd,Duhayd,Ihaid,aldhyd,الذيد,Ḑayd', 25.2881200, 55.8815700, 'AE', '2012-01-18', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(24, 'Abu Dhabi', 'Abu Dhabi', 'A-pu-that-pi,AEbu Saby,AUH,Aboe Dhabi,Abou Dabi,Abu Dabi,Abu Dabis,Abu Daby,Abu Daibi,Abu Dhabi,Abu Dhabi emiraat,Abu Zabi,Abu Zaby,Abu Zabye,Abu Zabyo,Abu Ḍabi,Abu Ḑabi,Abu-Dabi,Abu-Dabi khot,Abu-Dabio,Abu-Dzabi,Abú Dabí,Abú Daibí,Abú Zabí,Abû Daby,Abū Dabī,Abū Z̧aby,Abū Z̧abye,Abū Z̧abyo,Abū Z̧abī,Ampou Ntampi,Ebu Dabi,Ebu Dhabi,Gorad Abu-Dabi,a bu zha bi,abu dhabi,abu-dabi,abudabi,abudhabi,abw zby,abwzby,aputapi,xa bud abi,Â-pu-tha̍t-pí,Äbu Saby,Əbu-Dabi,Άμπου Ντάμπι,Αμπου Νταμπι,Αμπού Ντάμπι,Абу Даби,Абу-Даби,Абу-Даби хот,Абу-Дабі,Горад Абу-Дабі,Әбу-Даби,Աբու Դաբի,אבו דאבי,أبوظبي,ئەبووزەبی,ابو ظبى,ابوظبی,ابوظہبی,अबु धाबी,अबू धाबी,আবুধাবি,ਅਬੂ ਧਾਬੀ,ଆବୁଧାବି,அபுதாபி,ಅಬು ಧಾಬಿ,അബുദാബി,අබුඩාබි,อาบูดาบี,ཨ་པོའུ་དྷ་པེ།,အဘူဒါဘီမြို့,აბუ-დაბი,አቡ ዳቢ,アブダビ,阿布扎比,아부다비', 24.4666700, 54.3666700, 'AE', '2016-06-03', 234);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(329, 'Pas Pul', 'Pas Pul', 'Pas Pol,Pas Pul,ps pl,پس پل', 37.4735500, 70.6161700, 'AF', '2013-09-09', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(330, 'Qal‘ah-ye Na‘īm', 'Qal`ah-ye Na`im', 'Kalanaim,Qal`ah-ye Na`im,Qal`eh Na`im,Qal`eh-ye Na`im,Qal‘ah-ye Na‘īm,Qal‘eh Na‘īm,Qal‘eh-ye Na‘īm,قلعه نعيم', 34.3995100, 69.1670500, 'AF', '2013-06-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(331, 'Markaz-e Woluswalī-ye Āchīn', 'Markaz-e Woluswali-ye Achin', 'Achin,Achin-Ulusvali,Acin Oluswali,Markaz-e Woluswali-ye Achin,Markaz-e Woluswalī-ye Āchīn,achyn,Āchīn,Āčīn Oluswāli,آچين', 34.1258300, 70.7077800, 'AF', '2010-08-10', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(332, 'Manogay', 'Manogay', 'Manogay,Manugay,Mānūgay,Māṉōgay,manwgy,مانوگی,ماڼوگی', 34.9901500, 70.9130200, 'AF', '2012-02-29', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(333, 'Stêr Giyān', 'Ster Giyan', 'Gayan,Gayān,Ster Gian,Ster Giyan,Ster Gyan,Ster Gyān,Sterg''yan,Sterg’yan,Stêr Giyān,Stêr Gīān,gyan,str gyan,ستر گیان,گیان', 32.9770400, 69.3730800, 'AF', '2012-05-06', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(334, 'Sharan', 'Sharan', 'OAS,Sharan,Sharan Woluswali,Sharan Woluswālī,Sharan Wuleswali,Sharan Wulêswālī,Sharana,shrn,شرن', 33.1756800, 68.7304500, 'AF', '2017-02-17', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(335, 'Salām Khēl', 'Salam Khel', 'Salam Khel,Salām Khēl,slam khېl,سلام خېل', 33.6706700, 69.3298300, 'AF', '2013-06-05', 1);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(359, 'Xarrë', 'Xarre', 'Cara,Qare,Qarë,Xara,Xare,Xarja,Xarra,Xarre,Xarrë,Xarë', 39.7283300, 20.0544400, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(360, 'Sarandë', 'Sarande', 'Agioi,Agioi Saranta,Ayii Saranda,Hagios Saranta,Onchesmus,Porto Edda,Santa Quaranta,Santi Quaranta,Saranda,Sarande,Sarandë,Sarandė,Saranta,Zogaj,sa lan da,salandeo,saranda,sarandh,srndh,Άγιοι Σαράντα,Саранда,Սարանդա,סרנדה,سارانده,ساراندہ,サランダ,萨兰达,사란더', 39.8755600, 20.0052800, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(361, 'Mesopotam', 'Mesopotam', 'Mesapotami,Mesopotam,Mesopotam i Poshter,Mesopotam i Poshtër,Mesopotami,Mesopotamo,Mesopótamo', 39.9102800, 20.0922200, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(362, 'Markat', 'Markat', 'Markat,Markati', 39.7327800, 20.1952800, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(363, 'Livadhja', 'Livadhja', 'Hoxha,Hoxhaj,Hoxhe,Hoxhë,Livadh,Livadhe,Livadhja,Livadhjaja,Livadhjaje,Livadhjajë,Livadhje', 39.7891700, 20.1219400, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(364, 'Konispol', 'Konispol', 'Conispolis,Konispoje,Konispol,Konispol'',Konispoli,Konispolis,ke ni si bo er,Кониспол,Конисполь,Конісполь,Կոնիսպոլ,科尼斯波尔', 39.6588900, 20.1813900, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(365, 'Kakavijë', 'Kakavije', 'Cacavia,Kakavi,Kakavia,Kakavija,Kakavije,Kakavijë,Kakavja', 39.9077800, 20.3583300, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(366, 'Finiq', 'Finiq', 'Eniki,Fenichi,Finik,Finiq,Finiqi,Firiq', 39.9063900, 20.0583300, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(367, 'Dhivër', 'Dhiver', 'Dhiver,Dhivre,Dhivri,Dhivrë,Dhivër,Kallarati,Kulurat,Kulurica', 39.8361100, 20.1686100, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(368, 'Delvinë', 'Delvine', 'Del''vina,Delvina,Delvine,Delvino,Delvinon,Delvinë,Zelvinou,Дельвина', 39.9511100, 20.0977800, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(369, 'Aliko', 'Aliko', 'Alicu,Alikaj,Aliko,Alikoja,Alikoje,Alikojë,Alikon', 39.8586100, 20.0791700, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(370, 'Buçimas', 'Bucimas', 'Bucimas,Bucimasi,Buçimas,Buçimasi,Starova,Starove,Starovë', 40.8913900, 20.6813900, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(371, 'Zhepë', 'Zhepe', 'Xhepa,Xhepe,Xhepë,Zhepa,Zhepe,Zhepë', 40.6777800, 20.2869400, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(372, 'Zerqan', 'Zerqan', 'Arta,Zergjan,Zergjani,Zerqan,Zerqani,Zrkjan', 41.5022200, 20.3605600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(373, 'Zavalinë', 'Zavaline', 'Zavalin,Zavalina,Zavaline,Zavalinë', 40.9808300, 20.2808300, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(374, 'Zapod', 'Zapod', 'Zagoti,Zapod,Zapodi,Zapot,Zapoti', 42.0505600, 20.5525000, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(375, 'Zall-Reç', 'Zall-Rec', 'Rec,Reci,Reç,Reçi,Zali,Zall,Zall-Rec,Zall-Reci,Zall-Reç,Zall-Reçi,Zalli', 41.8761100, 20.3200000, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(376, 'Zall-Dardhë', 'Zall-Dardhe', 'Zali,Zall i Dardhes,Zall i Dardhës,Zall-Dardha,Zall-Dardhe,Zall-Dardhë,Zalli i Dardes,Zalli i Dardhes,Zalli i Dardhës', 41.8066700, 20.3361100, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(377, 'Xibër-Murrizë', 'Xiber-Murrize', 'Murrize,Murrizë,Xiber,Xiber-Muriza,Xiber-Murize,Xiber-Murr,Xiber-Murriz,Xiber-Murriza,Xiber-Murrize,Xiber-Murrizia,Xiberr-Murrize,Xibri,Xibër,Xibër-Murizë,Xibër-Murr,Xibër-Murriz,Xibër-Murriza,Xibër-Murrizia,Xibër-Murrizë,Xibërr-Murrizë,Ziber-Murize,Zibër-Murizë', 41.4547200, 20.0255600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(378, 'Vreshtas', 'Vreshtas', 'Vreshtas,Vreshtasi', 40.7969400, 20.7769400, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(379, 'Voskopojë', 'Voskopoje', 'Moscopole,Moskhopolis,Moskopole,Voskopoi,Voskopoj,Voskopoja,Voskopoje,Voskopojë', 40.6330600, 20.5888900, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(380, 'Voskop', 'Voskop', 'Voskop,Voskopi', 40.6119400, 20.6902800, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(381, 'Vithkuq', 'Vithkuq', 'Vithkuq,Vithkuqi', 40.5250000, 20.5825000, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(382, 'Vithkuq', 'Vithkuq', 'Bithyq,Bityq,Buthuq,Bythyci,Bythyq,Bythyçi,Vithkuq,Vithuq,Vithuqi,Zagor,Zagori,Zagorie', 40.2047200, 20.2594400, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(383, 'Vërtop', 'Vertop', 'Vertop,Vertopi,Vërtop', 40.6288900, 20.0538900, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(384, 'Vergo', 'Vergo', 'Vergo,Vergoja,Vergoje,Vergojë', 40.0066700, 20.0088900, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(385, 'Vendresha e Vogël', 'Vendresha e Vogel', 'Vendresha e Vogel,Vendresha e Vogël,Vendreshe e Vogel,Vëndreshë e Vogël', 40.5072200, 20.1347200, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(386, 'Velçan', 'Velcan', 'Velcan,Velcan Mokra,Velcan Mokrra,Velcan i Mokres,Velcan i Mokrres,Velcani,Velcani i Mokres,Velçan,Velçan i Mokrrës,Velçan i Mokrës,Velçani,Velçani i Mokrës', 40.9547200, 20.4622200, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(387, 'Ujmisht', 'Ujmisht', 'Mem,Ujmisht,Ujmishte,Ujmishte e Gurit,Ujmishti,Ujmishtë,Ujmishtë e Gurit,Ymishte-e Gurit,Ymishtë-e Gurit', 41.9083300, 20.3469400, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(388, 'Udënisht', 'Udenisht', 'Hodonishta,Hodonishti,Hodonista,Hodoništa,Hudenisht,Hudenishta,Hudenishti,Hudënishta,Udenisht,Udenishte,Udenishti,Udënisht,Udënishtë', 40.9633300, 20.6391700, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(389, 'Tunjë', 'Tunje', 'Tune,Tunia,Tunja,Tunje,Tunjë', 40.8341700, 20.1119400, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(390, 'Tregan', 'Tregan', 'Tregan,Tregani', 41.0247200, 20.0783300, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(391, 'Trebisht-Muçinë', 'Trebisht-Mucine', 'Trebisht-Mucina,Trebisht-Mucine,Trebisht-Muçina,Trebisht-Muçinë', 41.4111100, 20.5355600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(392, 'Trebinjë', 'Trebinje', 'Trebinja,Trebinje,Trebinjë', 40.9133300, 20.5530600, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(393, 'Topojan', 'Topojan', 'Tapaiani,Topaiani,Topajan,Topojan,Topojani,Topoyani', 40.3772200, 20.2133300, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(394, 'Tomin', 'Tomin', 'Tomin,Tomini,Tonun,Tumini', 41.6908300, 20.4216700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(395, 'Tepelenë', 'Tepelene', 'Tepelen,Tepelena,Tepelene,Tepeleni,Tepelenë,Tepelenė,tai pei lai na,tepelleneo,tplnh,Τεπελένι,Тепелена,Тепелєна,تپلنه,تپلنہ,台佩莱纳,테펠레너', 40.2958300, 20.0191700, 'AL', '2012-06-07', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(396, 'Surroj', 'Surroj', 'Serroj,Suroj,Surroj,Surroji', 41.9922200, 20.3441700, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(397, 'Sult', 'Sult', 'Sul,Suli,Sult,Sulta,Sulte,Sulti,Sultë', 40.8847200, 20.0994400, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(398, 'Sukë', 'Suke', 'Suka,Suke,Sukë', 40.3752800, 20.1547200, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(399, 'Suç', 'Suc', 'Suc,Suci,Suç,Suçi', 41.5769400, 20.0513900, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(400, 'Stravaj', 'Stravaj', 'Lira,Stovanit,Stravaj,Stravaje,Stravaji,Stravan,Stravani,Strevan', 41.0052800, 20.4230600, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(401, 'Steblevë', 'Stebleve', 'Slinza,Stebilova,Steblev,Stebleva,Stebleve,Steblevë,Stebljeva,Stebllova,Sterbleva,Stërbleva,Šlinza', 41.3372200, 20.4700000, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(402, 'Sllovë', 'Sllove', 'Slleva,Sllova,Sllove,Sllovë', 41.8011100, 20.4083300, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(403, 'Skore', 'Skore', 'Shkore,Shkorë,Shore,Shorë,Skore,Skorea,Skoreja', 40.1072200, 20.3663900, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(404, 'Skënderbegas', 'Skenderbegas', 'Shemberdhej i Poshtem,Shemberdhenj i Poshtem,Shemberthej i Poshtem,Shemerdhej i Poshtme,Shemerdhenj i Poshtem,Shemerdhenj i Poshtëm,Shenmerllag,Shëmberdhej i Poshtëm,Shëmberdhenj i Poshtëm,Shëmbërthej i Poshtëm,Shëmerdhej i Poshtme,Shënmerllag,Skenderbegas,Skenderbegasi,Skënderbegas,Skënderbegasi', 40.7761100, 20.2405600, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(405, 'Shushicë', 'Shushice', 'Scuscitsa,Shushica,Shushice,Shushicë', 41.0975000, 20.1483300, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(406, 'Shupenzë', 'Shupenze', 'Sciupentse,Shepenze,Shtepenz,Shtupenza,Shtëpenz,Shupenz,Shupenza,Shupenze,Shupenzë,Shëpenzë', 41.5300000, 20.4236100, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(407, 'Shtiqën', 'Shtiqen', 'Shticen,Shtiger,Shtigjen,Shtigër,Shtiqen,Shtiqeni,Shtiqën,Shtiqëni,Stidden,Štidđen', 42.0405600, 20.4341700, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(408, 'Shishtavec', 'Shishtavec', 'Scishnevitc,Scishnevitć,Shishtavec,Shishtaveci,Shishtevec,Sistevac,Šištevac', 41.9800000, 20.6058300, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(409, 'Shirgjan', 'Shirgjan', 'Shirgjan,Shirgjani', 41.0519400, 20.0533300, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(410, 'Shëngjin', 'Shengjin', 'Shen Gjini,Shengin,Shengjin,Shingjin,Shingjini,Shëngjin,Шенгин', 41.9261100, 20.1883300, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(411, 'Shënmëri', 'Shenmeri', 'Shemeri,Shemeria,Shemri,Shemria,Shemrija,Shenmeri,Shenmric,Shmria,Shëmri,Shëmria,Shëmrija,Shëmëri,Shënmëri', 42.1041700, 20.2383300, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(412, 'Selishtë', 'Selishte', 'Selishta,Selishta e Poshtme,Selishte,Selishtë', 41.6275000, 20.2791700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(413, 'Saraqinishtë', 'Saraqinishte', 'Sarachinista,Sarakinista,Saranishte,Saraqinisht,Saraqinishta,Saraqinishte,Saraqinishtë', 40.1052800, 20.2294400, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(414, 'Rukaj', 'Rukaj', 'Rukaj', 41.6836100, 20.0191700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(415, 'Rajcë', 'Rajce', 'Raica,Rajca,Rajce,Rajcë,Rrajca,Rrajce,Rrajcë,Sula', 41.0902800, 20.5763900, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(416, 'Roshnik', 'Roshnik', 'Fikaj,Roshnic,Roshnik,Roshniku,Rosniki,Rroshniku', 40.7327800, 20.0394400, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(417, 'Qukës-Skënderbe', 'Qukes-Skenderbe', 'Qukes-Skenderbe,Qukes-Skenderbej,Qukes-Skenderbeu,Qukës-Skënderbe,Qukës-Skënderbej,Qukës-Skënderbeu', 41.0838900, 20.4380600, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(418, 'Qestorat', 'Qestorat', 'Chiesarat,Khiesarat,Qesarat,Qestorat,Qestorati', 40.1175000, 20.1997200, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(419, 'Qafëmal', 'Qafemal', 'Chafamalit,Qaf Mal,Qaf Mali,Qafa e Malit,Qafamal,Qafe Mali,Qafe e Malit,Qafemal,Qafë Mali,Qafë e Malit,Qafëmal', 42.0933300, 20.0905600, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(420, 'Përrenjas-Fshat', 'Perrenjas-Fshat', 'Perrenjas-Fshat,Prrenjas-Fshat,Prrenjasi,Përrenjas-Fshat', 41.0666700, 20.5352800, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(421, 'Përrenjas', 'Perrenjas', 'Fshat Perrenjasi,Fshat Përrenjasi,Perren''jas,Perrenjas,Perrenjasi,Perrenjes,Prenjas,Prenjasi,Prenjesi,Prenjs,Prenjësi,Prrenjas,Prrenjasi,Përrenjas,Përrenjasi,Përrenjës,Перреньяс', 41.0730600, 20.5488900, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(422, 'Proptisht', 'Proptisht', 'Propishte,Propishtë,Proptisht,Proptishta,Proptishte,Proptishti,Proptishtë', 40.9861100, 20.5025000, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(423, 'Progër', 'Proger', 'Proger,Progeri,Progri,Progër,Progëri', 40.6941700, 20.9402800, 'AL', '2012-06-09', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(424, 'Potom', 'Potom', 'Podhom,Potom,Potomi', 40.4883300, 20.3733300, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(425, 'Poroçan', 'Porocan', 'Porocan,Porocani,Poroçan,Poroçani', 40.9419400, 20.2986100, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(426, 'Polis-Gostimë', 'Polis-Gostime', 'Polis,Polis i-Madh,Polis-Gostime,Polis-Gostimë,Polisi,Polisi Mazi,Xhamia e Siperme,Xhamia e Sipërme', 41.1333300, 20.2583300, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(427, 'Poliçan', 'Polican', 'Polican,Policani,Polichan,Poliçan,Poliçani,Поличан', 40.6122200, 20.0980600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(428, 'Pojan', 'Pojan', 'Poiani,Pojan,Pojani', 40.7258300, 20.8375000, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(429, 'Pogradec', 'Pogradec', 'Pogradec,Pogradeci,Pogradecis,Pogradets,bo ge la de ci,pogeuladecheu,poguradetsu,pwgradts,pwgrdz,Πόγραδετς,Поградец,פוגרדץ,پوگرادتس,ポグラデツ,波格拉德茨,포그라데츠', 40.9025000, 20.6525000, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(430, 'Pishaj', 'Pishaj', 'Pishaj', 40.8811100, 20.1827800, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(431, 'Pirg', 'Pirg', 'Pirg,Pirgu,Pirk', 40.7850000, 20.7061100, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(432, 'Gjinkar', 'Gjinkar', 'Gjinakar,Gjinkan-Petrani,Gjinkar,Gjinkar-Petran,Petran,Petrani,Petrani-Gjinkari,Petranit', 40.1994400, 20.4061100, 'AL', '2013-05-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(433, 'Petran', 'Petran', 'Pertran,Petran,Qender,Qendra,Qendër', 40.2094400, 20.4183300, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(434, 'Peshkopi', 'Peshkopi', 'Dibra,Dibre,Dibrë,Episkopi,Peshkepija,Peshkepije,Peshkopeja,Peshkopi,Peshkopia,Peshkopie,Peshkopija,Peshkopije,Peshkopië,Peshkopla,Peshkëpijë,Peskopia,Peskopija,Peškopija,Piscopeia,Pishcopeja,Pishkopeja,pei shen ke bi,peshukopi,pesyukopi,pshkwpy,pshkwpya,Επισκοπή,Пешкопеја,Пешкопи,Пешкопия,Пешкопія,Пишкопеја,Պեշկոպիա,پشکوپی,پشکوپیا,ペシュコピ,佩什科比,페슈코피', 41.6850000, 20.4288900, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(435, 'Përmet', 'Permet', 'Permet,Permeti,Permetis,Premet,Premete,Premeti,Premetē,Prëmet,Purmet,Përmet,Përmeti,brmt,pei er mei te,prmt,Πρεμετή,Пермет,Пермети,Пърмет,برمت,پرمت,佩爾梅特', 40.2336100, 20.3516700, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(436, 'Ostreni i Math', 'Ostreni i Math', 'Ostren,Ostren i Madh,Ostren i Math,Ostren i madhe,Ostren i madhë,Ostreni,Ostreni i Madh,Ostreni i Math,Ostrenimaze,Pljakoni i Mal', 41.4308300, 20.4555600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(437, 'Orosh', 'Orosh', 'Orosh,Oroshi', 41.8333300, 20.0833300, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(438, 'Orenjë', 'Orenje', 'Oreja,Orenja,Orenje,Orenjë,Orhenja,Orhenje,Orhenjë', 41.2847200, 20.2119400, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(439, 'Odrie', 'Odrie', 'Odria', 40.1333300, 20.1666700, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(440, 'Novoselë', 'Novosele', 'Navosele,Novasela,Novosela,Novosele,Novoselë,Piskal-Novosele,Piskal-Novoselë', 40.7613900, 20.6983300, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(441, 'Picar', 'Picar', 'Novace,Novacë,Picar,Picari', 40.1666700, 20.0483300, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(442, 'Mollas', 'Mollas', 'Maulas,Mollas,Mollasi,Motas', 40.9269400, 20.0036100, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(443, 'Mollas', 'Mollas', 'Mollas,Mollasi', 40.4255600, 20.6744400, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(444, 'Mollaj', 'Mollaj', 'Dooran,Dvoran,Dvorani,Mollaj,Tepexhik', 40.5602800, 20.7402800, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(445, 'Miras', 'Miras', 'Bozhigra,Bozhigrad,Bozhigradi,Bozhigrat,Bozigrad,Miras,Mirasi', 40.5091700, 20.9283300, 'AL', '2012-06-09', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(446, 'Melan', 'Melan', 'Melan,Melani', 41.6541700, 20.4652800, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(447, 'Martanesh', 'Martanesh', 'Kaptina,Martaneshi', 41.4000000, 20.2000000, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(448, 'Maqellarë', 'Maqellare', 'Magellara,Magellare,Magellarë,Makelare,Makelari,Maqellara,Maqellare,Maqellari,Maqellarë,Maqllara,Макеларе,Макелари', 41.5888900, 20.4830600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(449, 'Maliq', 'Maliq', 'Malik,Maliq,Maliqi,Малик', 40.7058300, 20.6997200, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(450, 'Macukull', 'Macukull', 'Macuklli,Macukuli,Macukull,Macukulli', 41.6886100, 20.1102800, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(451, 'Lunik', 'Lunik', 'Ljumnik,Lumnik,Lunik,Lunike,Luniku,Lunikë', 41.2891700, 20.3236100, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(452, 'Llugaj', 'Llugaj', 'Llugaj,Lugat', 42.3413900, 20.1086100, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(453, 'Lis', 'Lis', 'Lis,Lisa,Lise,Lisi,Lisë', 41.6275000, 20.0852800, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(454, 'Liqenas', 'Liqenas', 'Liqenas,Liqenasi,Postec,Pushteci,Pustec,Pusteci', 40.7866700, 20.9022200, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(455, 'Librazhd', 'Librazhd', 'Labrazhd,Libohov,Libohovo,Libokhovon,Libradzh,Librash,Librazdi,Librazdis,Librazhd,Librazhdi,Librazhet,Libraždi,Libraždis,li bu la shen de,lybrajd,lybrazhd,Либрадж,Либражд,Лібражд,ليبراجد,لیبراژد,利布拉什德', 41.1794400, 20.3150000, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(456, 'Libonik', 'Libonik', 'Libonik,Liboniku,Libovnik', 40.7044400, 20.7086100, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(457, 'Libohovë', 'Libohove', 'Libhova,Libohov,Libohova,Libohova Qender,Libohova Qendër,Libohove,Libohovo,Libohovë,Libokhova,Libokhovo,Libokhovon,li bo huo wa,Либохова,Либохово,Лібохова,利博霍瓦', 40.0311100, 20.2630600, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(458, 'Leskovik', 'Leskovik', 'Leskovik,Leskoviku,Leskoviqi,Liascovik,Liascovitsi,Liaskoviki,Ljakovici,Лесковик', 40.1513900, 20.5972200, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(459, 'Leshnjë', 'Leshnje', 'Leshnja,Leshnje,Leshnjë,Lesnia', 40.5369400, 20.3133300, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(460, 'Lenias', 'Lenias', 'Lenias,Leniasi,Lenie,Schinapremtja,Scinapremte,Shenapremte,Shenapremtja,Shenaprende,Shenepremte,Shenepremtja,Shenpremtja,Shinapremta,Shinapremte,Shinepremtja,Shënapremte,Shënapremtja,Shënepremtja,Shëneprëmte,Shënpremtja', 40.7666700, 20.3913900, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(461, 'Lekas', 'Lekas', 'Lekas,Lekasi', 40.6022200, 20.5125000, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(462, 'Lazarat', 'Lazarat', 'Lazarat,Lazarati,Liazarati,Linzarates', 40.0466700, 20.1475000, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(463, 'Labinot-Mal', 'Labinot-Mal', 'Labinot,Labinot e-siperm,Labinot e-sipërm,Labinot i Siperm,Labinot i Sipërm,Labinot-Mal,Labinoti i Siperm,Labinoti i Sipërm,Labinoti i siperme,Labinoti i sipermë,Labinoti-Mal,Labinotie i Siperme,Labinotie i Sipermë,Ljabinoti sipermi', 41.2008300, 20.1522200, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(464, 'Labinot-Fushë', 'Labinot-Fushe', 'Labinot,Labinot i Poshtem,Labinot i Poshtëm,Labinot-Fushe,Labinot-Fushë,Labinoti,Labinoti i Poshtem,Labinoti-Fushe,Labinoti-Fushë', 41.1405600, 20.1461100, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(465, 'Kushovë', 'Kushove', 'Kushova,Kushove,Kushovë,Shaltura', 40.7888900, 20.1888900, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(466, 'Kurbnesh', 'Kurbnesh', 'Kurbnesh,Kurbnesha,Kurbneshi,Курбнеш', 41.7797200, 20.0836100, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(467, 'Kukur', 'Kukur', 'Kuker,Kukeri,Kukur,Kukuri,Kukër,Kukëri', 40.8677800, 20.3636100, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(468, 'Kukës', 'Kukes', 'Cucus,Kukes,Kukesi,Kuks,Kuksi,Kukuch,Kukus,Kukës,Kukësi,Кукес,Кукъс', 42.0769400, 20.4219400, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(469, 'Kthella e Epërme', 'Kthella e Eperme', 'Kethella e Eper,Ktelle e eper,Ktellë e eper,Kthella Eper,Kthella Epër,Kthella e Eperme,Kthella e Epërme,Kthella e eper,Kthella e epër,Kthelle e Eper,Kthelle e Eperme,Kthelle e Siperme,Kthellë e Epër,Kthellë e Epërme,Kthellë e Sipërme', 41.8119400, 20.0588900, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(470, 'Krumë', 'Krume', 'Kruma,Krume,Krumë,Крума', 42.1969400, 20.4133300, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(471, 'Korçë', 'Korce', 'Corce,Corcë,Coritsa,Coritza,Coriza,Corizza,Corriza,Ghiortsa Corcia,Goerice,Gorica,Goritsa,Görice,Korca,Korce,Korcha,Korche,Korcza,Korica,Korice,Koritsa,Koritza,Korrca,Korrce,Korrça,Korrçë,Korytsa,Korça,Korçë,Korča,Korčė,Körice,ke er cha,koleucheo,korucha,kwrchh,qwrzh,Κορυτσά,Горица,Корча,Կորչա,קורצה,کورچه,کورچہ,コルチャ,科尔察,코르처', 40.6186100, 20.7808300, 'AL', '2012-11-26', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(472, 'Kolsh', 'Kolsh', 'Kalshi,Klosh,Koljsi,Koljši,Kolsh,Kolshi', 42.0780600, 20.3419400, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(473, 'Kodovjat', 'Kodovjat', 'Kodoviati,Kodovjat,Kodovjati,Lidaj', 40.8055600, 20.2511100, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(474, 'Klos', 'Klos', 'Dullinjasi,Klos,Klosi,Клос', 41.5069400, 20.0866700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(475, 'Klos', 'Klos', 'Klos,Klosi,Клос', 40.9461100, 20.0097200, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(476, 'Këlcyrë', 'Kelcyre', 'Kel''cira,Kelcyra,Kelcyre,Kelcyres,Kelcyrës,Kleisoura,Klisura,Këlcyra,Këlcyrë,Кельцира', 40.3130600, 20.1894400, 'AL', '2015-08-26', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(477, 'Kastriot', 'Kastriot', 'Kastriot,Kastriota,Kastrioti', 41.7294400, 20.3772200, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(478, 'Kardhiq', 'Kardhiq', 'Gardiki,Kardhiq,Kardhiqi', 40.1216700, 20.0275000, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(479, 'Kalis', 'Kalis', 'Kalis,Kalisi,Kallashi,Kalles,Kallës', 41.8388900, 20.3666700, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(480, 'Iballë', 'Iballe', 'Ibalja,Iballe,Iballja,Iballje,Iballjë,Iballë,Jballje', 42.1875000, 20.0025000, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(481, 'Hotolisht', 'Hotolisht', 'Baldreti,Hodolishti,Hotolisht,Hotolishta,Hotolishti,Kotolishta,Otolisht', 41.1566700, 20.3972200, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(482, 'Hoçisht', 'Hocisht', 'Hochishte,Hocisht,Hocishte,Hocishti,Hocishtit,Hoçisht,Hoçishti,Hoçishtë', 40.6083300, 20.9141700, 'AL', '2012-06-09', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(483, 'Gramsh', 'Gramsh', 'Gramish,Gramsci,Gramsh,Gramshi,Gramsis,Gramšis,ge la mu shen,gramsh,Грамш,Грамши,Грамші,گرامش,格拉姆什', 40.8697200, 20.1844400, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(484, 'Gostimë', 'Gostime', 'Gostim-Mal,Gostim-Mali,Gostima,Gostime,Gostime-Mal,Gostimë,Gostimë-Mal', 41.1455600, 20.2400000, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(485, 'Golaj', 'Golaj', 'Golai,Golaj,Goljai', 42.2475000, 20.3802800, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(486, 'Gjorica e Sipërme', 'Gjorica e Siperme', 'Gjorica,Gjorica e Eperme,Gjorica e Epërme,Gjorica e Siperme,Gjorica e Sipërme,Gjorice,Gjorice e Eper,Gjorice e Eperme,Gjorice e Siperme,Gjoricë,Gjoricë e Epër,Gjoricë e Epërme,Gjoricë e Sipërme,Gorice,Goricë', 41.5344400, 20.4500000, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(487, 'Gjirokastër', 'Gjirokaster', 'Agirocastro,Arghirocastru,Arghyrocastro,Argirocastro,Argirokastro,Argyrocastrum,Argyrokastro,Argyrokastron,Aryirokastro,Aryirokastron,Ergheni,Ergiri,GJirokastra,Ghinokastre,Girokasteris,Girokastra,Girokastro,Gjinokaster,Gjinokastra,Gjinokastre,Gjinokastrer,Gjinokastër,Gjirokaster,Gjirokastra,Gjirokastre,Gjirokastro,Gjirokastrë,Gjirokastër,arjyr,gyrwqstrh,ji nuo ka si te,jilokaseuteoleu,jirokasutora,jyrwkastr,Đirokastra,Αργυρόκαστρο,Ђирокастра,Ѓирокастро,Аргирокастро,Гирокастра,Гирокастро,Гірокастра,גירוקסטרה,ارجیر,جیروکاستر,გიროკასტრა,ジロカストラ,吉诺卡斯特,지로카스터르', 40.0758300, 20.1388900, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(488, 'Gjinar', 'Gjinar', 'Giniari,Gjinar,Gjinari', 41.0225000, 20.1888900, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(489, 'Gjinaj', 'Gjinaj', 'Dinai,Gjinai,Gjinaj,Ðinai', 42.1180600, 20.4358300, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(490, 'Gjergjan', 'Gjergjan', 'Gjergjan,Gjergjani,Gjergjenj', 41.0430600, 20.0297200, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(491, 'Gjegjan', 'Gjegjan', 'Gjegjan,Gjegjani,Zhezhan', 41.9377800, 20.0111100, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(492, 'Fushë-Muhurr', 'Fushe-Muhurr', 'Fush-Muhur,Fushe-Muhri,Fushe-Muhur,Fushe-Muhuri,Fushe-Muhurr,Fushe-Muhurri,Fushe-Mukheri,Fushe-Mukhuri,Fushë-Muhri,Fushë-Muhur,Fushë-Muhuri,Fushë-Muhurr,Fushë-Muhurri,Muherr,Muhur,Muhuri,Muhurr,Mukur', 41.6797200, 20.3313900, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(493, 'Fushë-Lurë', 'Fushe-Lure', 'Fush'' e Lures,Fusha Lures,Fusha Lurës,Fusha e Lures,Fusha e Lurës,Fushe-Lura,Fushe-Lure,Fushë-Lura,Fushë-Lurë,Fush’ e Lurës,Lure e eper,Lurë e epër', 41.8061100, 20.2319400, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(494, 'Fushë-Çidhnë', 'Fushe-Cidhne', 'Fush'' e Alijajt,Fusha Ali,Fusha Alijaj,Fushaj,Fushe Alija,Fushe-Alia,Fushe-Alie,Fushe-Cidhen,Fushe-Cidhna,Fushe-Cidhne,Fushë-Alia,Fushë-Alië,Fushë-Çidhna,Fushë-Çidhnë,Fushë-Çidhën,Fush’ e Alijajt', 41.7605600, 20.3411100, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(495, 'Fushë-Bulqizë', 'Fushe-Bulqize', 'Bulqize Fusha,Bulqizë Fusha,Fushaj,Fushe-Bulqiza,Fushe-Bulqize,Fushë-Bulqiza,Fushë-Bulqizë', 41.5219400, 20.2822200, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(496, 'Fushë-Arrëz', 'Fushe-Arrez', 'Arres,Arrës,Arsi,Arst,Fusha e Arezit,Fusha e Arrezit,Fusha e Arrëzit,Fusha e Arsit,Fusha e Arëzit,Fusha-Arres,Fusha-e-Arresit,Fushe Arrezi,Fushe e Arrezit,Fushe-Ares,Fushe-Aresi,Fushe-Arezi,Fushe-Arezit,Fushe-Arresi,Fushe-Arrez,Fushë e Arrëzit,Fushë-Arrësi,Fushë-Arrëz,Fushë-Arëzi,Fushë-Arëzit,Фуша-Аррес', 42.0622200, 20.0166700, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(497, 'Frashër', 'Frasher', 'Frasceri,Frasher,Frasheri,Frashër,Frashëri,Phrasare,Phrasarë', 40.3688900, 20.4244400, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(498, 'Fierzë', 'Fierze', 'Fiera,Fierza,Fierze,Fierzë,Firez,Firza,Firëz,Фиерза', 42.2605600, 20.0169400, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(499, 'Fajzë', 'Fajze', 'Fajza,Fajze,Fajzë', 42.1669400, 20.3508300, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(500, 'Ersekë', 'Erseke', 'Colonia,Ehrseka,Erseg Giatseg,Ersek,Erseka,Erseke,Ersekë,Ersekė,Kolonija,Kolonije,Kolonijë,Kolonja,Kolonje,Kolonjë,ai er sai ke,arska,Ερσέκα,Ерсека,Эрсека,ارسکا,愛爾塞克', 40.3377800, 20.6788900, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(501, 'Elbasan', 'Elbasan', 'Ehl''basan,Elbasan,Elbasani,Elbassan,Эльбасан', 41.1125000, 20.0822200, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(502, 'Drenovë', 'Drenove', 'Drenova,Drenove,Drenovo,Drenovë', 40.5833300, 20.7922200, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(503, 'Dishnicë', 'Dishnice', 'Deshnica,Dishnica,Dishnice,Dishnicë,Tishnica', 40.6513900, 20.8136100, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(504, 'Derviçian', 'Dervician', 'Dervican,Dervicani,Dervician,Derviciani,Dervisciani,Derviçan,Derviçani,Derviçian', 40.0325000, 20.1733300, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(505, 'Derjan', 'Derjan', 'Derjan,Derjani', 41.6736100, 20.0583300, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(506, 'Gjerbës', 'Gjerbes', 'David,Davidh,Davidhi,Devidhi,Gjerbes,Gjerbesi,Gjerbës,Gjerbësi', 40.6291700, 20.2511100, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(507, 'Çorovodë', 'Corovode', 'Cerevoda,Cerevode,Cerevodë,Chorovoda,Corovoda,Corovode,Gjavan,Zhaban,qiao luo wo da,Çorovoda,Çorovodë,Čorovodė,Чоровода,Չորովոդա,سوروودہ,乔罗沃达', 40.5041700, 20.2272200, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(508, 'Çlirim', 'Clirim', 'Clirim,Clirimi,Shenmertir,Shënmërtir,Çlirim,Çlirimi', 40.4175000, 20.5502800, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(509, 'Cerava', 'Cerava', 'Cerav,Cerava,Cerave,Cerrava,Cerrave,Çëravë,Çërrava,Çërravë', 40.8513900, 20.7250000, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(510, 'Çepan', 'Cepan', 'Cepan,Cepani,Çepan,Çepani', 40.4205600, 20.2605600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(511, 'Çarshovë', 'Carshove', 'Carcova,Carcove,Carshova,Carshove,Çarshova,Çarshovë,Çarçova,Çarçovë', 40.1180600, 20.5408300, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(512, 'Kokaj', 'Kokaj', 'Caj,Caja,Caje,Cajhen,Kokaj,Matraxhi i Cajes,Matraxhi i Çajes,Çaja,Çajhen,Çajë', 41.8783300, 20.5047200, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(513, 'Buz', 'Buz', 'Busi,Buz,Buz i Madh,Buz i Math,Buze,Buzi,Buzi i Madh,Buzi i Math,Buzë', 40.4450000, 20.0047200, 'AL', '2012-06-07', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(514, 'Bushtricë', 'Bushtrice', 'Bushtrice,Bushtricë,Bustrica', 41.8786100, 20.4219400, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(515, 'Burrel', 'Burrel', 'Burel,Burela,Burele,Bureli,Burelis,Burelë,Burrel,Burrel'',Burrele,Burreli,Burrelë,bu lei li,bulel,bureru,bwrly,Бурел,Буррели,Буррель,بورلی,ブレル,布雷利,부렐', 41.6102800, 20.0088900, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(516, 'Bulqizë', 'Bulqize', 'Bul''kiza,Bulchica,Bulcica,Bulciza,Bulkiza,Bulkize,Bulkizė,Bulqiza,Bulqize,Bulqizë,Bulquize,Bulćiza,Bulčica,bu er qi cha,bulakiza,Булкиза,Булчица,Булькиза,Булькіза,بولچیزہ,ਬੁਲਕੀਜ਼,布爾奇察', 41.4916700, 20.2219400, 'AL', '2013-03-15', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(517, 'Bujan', 'Bujan', 'Bajani,Bujan,Bujani,Bunjaj,Bunjan', 42.3263900, 20.0763900, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(518, 'Bradashesh', 'Bradashesh', 'Bradashesh,Bradasheshi,Bradosheshi', 41.1050000, 20.0225000, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(519, 'Blinisht', 'Blinisht', 'Blinisht,Blinishti', 41.8613900, 20.0000000, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(520, 'Blerim', 'Blerim', 'Blerim,Sakat,Sakat-Kullumbri,Sakati', 42.1605600, 20.1919400, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(521, 'Bilisht', 'Bilisht', 'Biclishta,Biglista,Biklishta,Biklista,Bilishha,Bilisht,Bilishta,Bilishte,Bilishti,Bilishtë,Bilista,Bilisthi,Bilistis,Bilišta,Bilištis,Billisht,Viglista,balshty,bi li shen te,bylysht,Βίγλιστα,Μπίγλιστα,Билишта,Билишти,Билища,بالشتی,بيليشت,بیلیشت,比利什特', 40.6275000, 20.9900000, 'AL', '2014-08-25', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(522, 'Bicaj', 'Bicaj', 'Bicaj,Bisagni,Bitsan', 41.9947200, 20.4125000, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(523, 'Dardhas', 'Dardhas', 'Beragozhd,Beragozhda,Beragozhde,Beragozhdi,Beragozhdë,Bragozhati,Bragozhde,Bragozhdë,Bëragozhda,Dardhas,Dardhasi', 40.8458300, 20.6572200, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(524, 'Barmash', 'Barmash', 'Barmash,Barmashi', 40.2777800, 20.6183300, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(525, 'Ballaban', 'Ballaban', 'Balaban,Ballaban,Ballabani', 40.4166700, 20.1344400, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(526, 'Arrën', 'Arren', 'Arn,Arni,Arren,Arreni,Arrn,Arrni,Arrën,Arrëni', 41.9130600, 20.2883300, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(527, 'Arras', 'Arras', 'Arras,Arrasi', 41.7358300, 20.3241700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(528, 'Fierzë', 'Fierze', 'Fierza,Fierze,Fierzë,Фиерза', 42.2647200, 20.0269400, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(529, 'Bytyç', 'Bytyc', 'Bitici,Bitiči', 42.3100000, 20.2027800, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(530, 'Librazhd-Qendër', 'Librazhd-Qender', 'Hala,Librazhd Qendre,Librazhd Qëndre,Librazhd-Qender,Librazhd-Qendër', 41.1969400, 20.3355600, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(531, 'Funarë', 'Funare', 'Funar,Funari', 41.1963900, 20.0597200, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(532, 'Moglicë', 'Moglice', 'Moglica,Moglice,Moglicë', 40.7180600, 20.4380600, 'AL', '2012-06-10', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(533, 'Bogovë', 'Bogove', 'Bogova,Bogove,Bogovë', 40.5711100, 20.1500000, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(534, 'Piskovë', 'Piskove', 'Piskova,Piskove,Piskovë', 40.2791700, 20.2725000, 'AL', '2012-06-06', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(535, 'Lukovë', 'Lukove', 'Lucova,Lukova,Lukove,Lukovo,Lukovë', 39.9922200, 19.9138900, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(536, 'Zharrëz', 'Zharrez', 'Shareza,Sharreza,Zarez,Zhareza,Zhareze,Zharres,Zharresa,Zharresi,Zharrez,Zharreza,Zharrës,Zharrësa,Zharrësi,Zharrëz,Zharrëza,Zharëzë,Žarez', 40.7091700, 19.6497200, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(537, 'Zejmen', 'Zejmen', 'Zejmani,Zejmen,Zejmeni,Zojmen,Zojmendi', 41.7077800, 19.6891700, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(538, 'Zall-Herr', 'Zall-Herr', 'Zall i Herrit,Zall-Herr,Zall-Herri,Zalle-Herraj,Zallherraj,Zalli i Herit,Zallë-Herraj', 41.3894400, 19.8275000, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(539, 'Zall-Bastar', 'Zall-Bastar', 'Zall-Bastar,Zall-Bastari', 41.4297200, 19.9302800, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(540, 'Xhafzotaj', 'Xhafzotaj', 'Dzevzotaj,Xhafe Zotaj,Xhaftozaj,Xhafzotaj,Xhafë Zotaj,Xhavzotaj,Xherezotaj,Xherëzotaj', 41.3444400, 19.5475000, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(541, 'Vukatanë', 'Vukatane', 'Vukatan,Vukatana,Vukatane,Vukatanë', 42.0280600, 19.5477800, 'AL', '2013-02-07', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(542, 'Vranisht', 'Vranisht', 'Vranisht,Vranishta,Vranishte,Vranishti,Vranishtë', 40.2097200, 19.6908300, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(543, 'Vorë', 'Vore', 'Vora,Vore,Vorra,Vorre,Vorrë,Vorë,Вора', 41.3908300, 19.6550000, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(544, 'Vlorë', 'Vlore', 'Au''lon,Au’lon,Avlon,Avlona,Avlonas,Avlonya,Vallona,Valona,Vl''ora,Vliore,Vliorė,Vljora,Vlona,Vlone,Vlonë,Vlora,Vlore,Vlorë,Vlyora,Vļora,Wlora,beulloleo,fa luo la,flwrh,vurora,wlo rex,wlwrh,Αυλώνας,Валона,Вльора,Влёра,Վլորա,ולורה,فلوره,ولوره,ولورہ,วโลเรอ,ヴロラ,发罗拉,블로러', 40.4666700, 19.4897200, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(545, 'Velipojë', 'Velipoje', 'Qerret,Velipoja,Velipoje,Velipojë,Velipolja', 41.8783300, 19.4055600, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(546, 'Velabisht', 'Velabisht', 'Velabisht,Velabishti', 40.7016700, 19.9322200, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(547, 'Vaqarr', 'Vaqarr', 'Vagari,Vaqar,Vaqari,Vaqarr,Vaqarri,Vasqarr', 41.2991700, 19.7441700, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(548, 'Ura Vajgurore', 'Ura Vajgurore', 'Ur''e Hasan Beut,Ura Asan Beut,Ura Vajgurore,Ura e Hasan Beut,Ura-Khasan-Beut,Ura-Vaygurore,Ure-Vajgurore,Urë-Vajgurore,Ur’e Hasan Beut,Yefira Hassan Beut', 40.7688900, 19.8777800, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(549, 'Ungrej', 'Ungrej', 'Ungrei,Ungrej,Ungreji', 41.8752800, 19.7947200, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(550, 'Ulëz', 'Ulez', 'Ulez,Uleza,Ulza,Ulze,Ulzë,Ulëz,Ulëza', 41.6827800, 19.8933300, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(551, 'Topojë', 'Topoje', 'Topoja,Topoje,Topojë', 40.7630600, 19.4327800, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(552, 'Tirana', 'Tirana', 'Gorad Tyrana,TIA,Terana,Theranda,Tiorana,Tiorána,Tiran,Tiran khot,Tiran-a,Tirana,Tiranae,Tirane,Tirano,Tiranë,Tirāna,Tyranna,Tírana,Tîrana,Tėrana,de la na,tilana,tirana,tyrana,tyrnh,Τίρανα,Горад Тырана,Тиран хот,Тиранæ,Тирана,Тиране,Տիրանա,טיראנא,טירנה,تىرانا,تيرانا,تیرانا,तिराना,তিরানা,ਤਿਰਾਨਾ,ଟିରାନା,டிரானா,ടിറാന,ติรานา,ཐིས་རན།,ტირანა,ቲራና,ティラナ,地拉那,티라나', 41.3275000, 19.8188900, 'AL', '2014-09-17', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(553, 'Thumanë', 'Thumane', 'Thumana,Thumane,Thumani,Thumanë,Tuman', 41.5475000, 19.6777800, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(554, 'Tërbuf', 'Terbuf', 'Terbuf,Terbufi,Tërbuf,Tërbufi', 41.0400000, 19.6141700, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(555, 'Synej', 'Synej', 'Sinej,Synej,Syneji', 41.1800000, 19.5425000, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(556, 'Sukth', 'Sukth', 'Sucsi,Sukf,Sukth,Sukth i Vjeter,Sukth i Vjetër,Sukthi', 41.3805600, 19.5377800, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(557, 'Strum', 'Strum', 'Ciflik-Struma,Strubi,Strum,Strume,Strumi,Strumë,Çiflik-Struma', 40.7511100, 19.7375000, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(558, 'Sinjë', 'Sinje', 'Signa,Sinja,Sinje,Sinjë', 40.6480600, 19.8680600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(559, 'Sinaballaj', 'Sinaballaj', 'Sinaballaj,Sinaballej,Sinabella,Sinanaj,Sinebala,Sineballa', 41.0688900, 19.6994400, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(560, 'Shkodër', 'Shkoder', 'Iskodra,Scutari,Shkoder,Shkodra,Shkodër,Skadar,Skodra,Szkodra,sqwdr,İşkodra,Škodra,Скадар,Шкодер,Шкодра,שקודר', 42.0682800, 19.5125800, 'AL', '2013-01-03', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(561, 'Shijak', 'Shijak', 'Bazar Sciak,San Giacomo,Shejak,Shejaku,Shijak,Shijaku,Shjak,Shyaku,Shëjaku,Sijak,Sijaku,Sjak,shyjakw,xi ya ke,Šijak,Šijaku,Šjak,Шияк,Шияку,Шијак,شیجاکو,希亞克', 41.3455600, 19.5672200, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(562, 'Shezë', 'Sheze', 'Seza,Sheza,Sheze,Sheze e Madhe,Shezë,Shezë e Madhe,Ujeza', 41.0241700, 19.8161100, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(563, 'Shënkoll', 'Shenkoll', 'Shenkoll,Shenkolle,Shenkolli,Shinkolli,Shënkoll,Shënkolli,Shënkollë,Snkoli', 41.6908300, 19.6533300, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(564, 'Shëngjin', 'Shengjin', 'Komuna e Shengjinit,Komuna e Shëngjinit,Saint Giovanni di Medua,San Giovanni di Medua,San Njin,Sen Dovani di Medua,Sengin,Sh''njini,Shen Ghen,Shengin,Shengjin,Shengjini,Shëngjin,Shëngjini,Sh’njini,Sveti Jovan,Sveti Jovan Medovski,sheng jin,Šen Ðovani di Medua,Šenđin,Свети Јован,Шенгин,Шенѓин,聖金', 41.8136100, 19.5938900, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(565, 'Shëngjergj', 'Shengjergj', 'Senderd,Shengjergi,Shengjergji,Shingjergj,Shingjergji,Shëngjergji,Šenđerđ', 41.1833300, 19.5333300, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(566, 'Shalës', 'Shales', 'Scials,Shales,Shalesi,Shalës,Shalësi', 40.9986100, 19.9477800, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(567, 'Nicaj-Shalë', 'Nicaj-Shale', 'Nicaj,Nicaj-Shalaj,Nicaj-Shale,Nicaj-Shalë,Shale,Shalë', 42.2994400, 19.8050000, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(568, 'Sevaster', 'Sevaster', 'Kudhes,Kudhës,Sevaster,Sevaster Cuds,Sevaster-Kudhes,Sevasteri,Stevaster,Stevaster Kudhes,Stevaster Kuls,Sëvastër-Kudhës', 40.3963900, 19.7297200, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(569, 'Selitë', 'Selite', 'Selit e Kece,Selit e Keće,Selita,Selite,Selite e Keqe,Selite-Delbinishtaj,Selitë,Selitë e Keqe', 41.6352800, 19.7550000, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(570, 'Valbonë', 'Valbone', 'Selimaj,Valbona,Valbone,Valbonë', 42.4513900, 19.8916700, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(571, 'Selenicë', 'Selenice', 'Selenic,Selenica,Selenice,Selenicë,Selenitsa,Selenitza,Seleniza,Selenizza,Селеница', 40.5305600, 19.6358300, 'AL', '2014-08-25', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(572, 'Ruzhdie', 'Ruzhdie', 'Piekaj,Rozhdia,Rushdie,Rushdije,Rushdijë,Ruzhdie,Ruzhdija,Ruzhdije,Ruzhdijë', 40.6708300, 19.6983300, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(573, 'Rubik', 'Rubik', 'Rrubig,Rrubigu,Rrumbiku,Rubig,Rubik,Rubiku,Рубик', 41.7744400, 19.7861100, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(574, 'Rrogozhinë', 'Rrogozhine', 'Rogozhina,Rogozhine,Rogozhinë,Rogozin,Rogozina,Rogozine,Rogožin,Rogožinė,Rrogozesa,Rrogozhina,Rrogozhine,Rrogozhinë,Rrogozësa,Rrogzhine,luo ge ri nei,Рогожина,羅戈日內', 41.0763900, 19.6652800, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(575, 'Rrëshen', 'Rreshen', 'Resenis,Reshen,Resheni,Rešenis,Rreshen,Rresheni,Rrshen,Rrsheni,Rrëshen,Rrësheni,Rshen,Rsheni,Rushen,Rëshen,Rëshëni,lei shen,ryshny,Решен,Ръшен,ریشنی,勒申', 41.7675000, 19.8755600, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(576, 'Rrashbull', 'Rrashbull', 'Rashbulle,Rezbul,Režbul,Rrashbull,Rrashbulle,Rrashbulli,Rrashbulli Arapaj,Rrashbullë', 41.3227800, 19.5102800, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(577, 'Rrasa e Sipërme', 'Rrasa e Siperme', 'Rasa e Siperme,Rasa e Sipërme,Rrasa e Siperme,Rrasa e Sipërme,Rrase e Siperme,Rrasë e Sipërme', 40.9677800, 19.8211100, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(578, 'Rrapë', 'Rrape', 'Rapje,Rrapa,Rrapaj,Rrape,Rrapja,Rrapë,Rrype,Rrypë', 42.0444400, 19.9705600, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(579, 'Roskovec', 'Roskovec', 'Roscovec,Roskovec,Roskoveci,Rroskoveci,Treg i Frasherit,Tregu-Frasherit,Росковец', 40.7375000, 19.7022200, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(580, 'Remas', 'Remas', 'Remas,Remas Pervas,Remasi,Rremas,Rremasi', 40.8863900, 19.5113900, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(581, 'Qerret', 'Qerret', 'Cereti-eper,Qereti i Eperme,Qereti i Epërmë,Qerret,Qerret i Eper,Qerret i Eperm,Qerret i Epër,Qerret i Epërm,Qerret i Madh,Qerret-ieperme,Qerreti,Qerreti i Eperme,Qerreti i Epërmë,Qerreti i Madh,Qerreti i-eper,Qerreti i-epër,Čereti-eper', 42.0530600, 19.8372200, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(582, 'Qelëz', 'Qelez', 'Lellza,Qelez,Qeleza,Qellza,Qellze,Qellzë,Qelza,Qelze,Qelzë,Qelëz,Qelëza', 42.0897200, 19.8950000, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(583, 'Pukë', 'Puke', 'Puca,Puka,Puka Katund,Puke,Pukë,Pukė,pu ke,pwkh,Пука,پوکه,پوکہ,普克', 42.0444400, 19.8997200, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(584, 'Progonat', 'Progonat', 'Progonat,Progonati', 40.2133300, 19.9447200, 'AL', '2012-06-07', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(585, 'Prezë', 'Preze', 'Preza,Preze,Prezë', 41.4272200, 19.6727800, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(586, 'Poshnje', 'Poshnje', 'Poshnja,Poshnje', 40.7802800, 19.8441700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(587, 'Portëz', 'Portez', 'Portez,Porteza,Porteze,Portëz,Portëza,Portëzë', 40.6991700, 19.5744400, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(588, 'Peza e Madhe', 'Peza e Madhe', 'Hodzaj,Hodžaj,Hoxhaj,Peza e Madhe,Peze,Peze e Madhe,Pezë,Pezë e Madhe', 41.2175000, 19.6961100, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(589, 'Petrelë', 'Petrele', 'Petrela,Petrele,Petrelë', 41.2530600, 19.8530600, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(590, 'Përparim', 'Perparim', 'Perparim,Perparimi,Përparim', 41.0500000, 19.7991700, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(591, 'Perondi', 'Perondi', 'Perhond,Perhondi,Perhondia,Perhondija,Perondi,Perondia,Perondija', 40.7788900, 19.9230600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(592, 'Peqin', 'Peqin', 'Pecin,Pekin,Pekini,Pekinis,Pekinj,Peqin,Peqini,Peqinj,Pequini,pchyn,pechin,pei jin,Пекин,Пеќин,پچین,ペチン,佩今,페친', 41.0461100, 19.7511100, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(593, 'Patos Fshat', 'Patos Fshat', 'Patos Fshat,Patosi Fshat', 40.6427800, 19.6508300, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(594, 'Patos', 'Patos', 'Pahtosa,Pahtosi,Patos,Patosi,Patosis,pa tu si,Патос,帕圖斯', 40.6833300, 19.6194400, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(595, 'Paskuqan', 'Paskuqan', 'Kuqan,Kuqon,Packuqan,Packuqani,Paskuqan,Paskuqani,Patza,Patza Kucane,Patza Kućane,Patza-Kuqane,Patza-Kuqani', 41.3538900, 19.8066700, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(596, 'Papër', 'Paper', 'Kulej-Paper,Kulej-Paperi,Kulej-Papër,Kulej-Papëri,Kull'' e Paprit,Kulla Paprit,Kull’ e Paprit,Paper,Paperi,Papri,Papër,Papëri', 41.0516700, 19.9608300, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(597, 'Pajovë', 'Pajove', 'Pajova,Pajove,Pajovë,Perpajsi', 41.0547200, 19.8375000, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(598, 'Otllak', 'Otllak', 'Otllak,Otllaku', 40.7438900, 19.9352800, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(599, 'Orikum', 'Orikum', 'Orik,Oriku,Orikum,Orikumi,Орикум', 40.3252800, 19.4713900, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(600, 'Novoselë', 'Novosele', 'Novosel,Novosela,Novosele,Novoselj,Novosella,Novoselë', 40.6250000, 19.4669400, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(601, 'Nikël', 'Nikel', 'Menga,Menikll,Meniklli,Monikelj,Monikle,Moniklë,Mënikll,Mëniklli,Nikel,Nikla,Niklla,Niklle,Nikllë,Nikël', 41.4441700, 19.7483300, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(602, 'Nicaj-Shosh', 'Nicaj-Shosh', 'Nicaj-Shosh,Nikaj', 42.2444400, 19.7580600, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(603, 'Ngraçan', 'Ngracan', 'Gracan,Graqani,Graçan,Ngracan,Ngracani,Ngraçan,Ngraçani', 40.6444400, 19.7925000, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(604, 'Ndroq', 'Ndroq', 'Ndrogi,Ndroki,Ndroq,Ndroqi,Ndroqi Pazari', 41.2638900, 19.6558300, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(605, 'Milot', 'Milot', 'Milet,Miljoti,Milot,Miloti,Милет', 41.6838900, 19.7155600, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(606, 'Memaliaj', 'Memaliaj', 'Mamaliaga,Mamaliaj,Memaliaj,Memalianji,Мемалиай', 40.3516700, 19.9802800, 'AL', '2012-06-07', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(607, 'Mbrostar-Urë', 'Mbrostar-Ure', 'Brostar,Brostar Ferko,Brostari-Ferkaj,Brustar Fioko,Mbrostar,Mbrostar Ferko,Mbrostar-Ure,Mbrostar-Urë,Mbrostari,Mbrotja e Siperme,Mbrotja e Sipërme', 40.7536100, 19.5794400, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(608, 'Manzë', 'Manze', 'Manes,Manesi,Manez,Maneza,Maneze,Mansmins,Mansmyns,Manxit,Manza,Manze,Manzë,Manës,Manësi,Manëz,Manëza,Manëzë', 41.4286100, 19.5930600, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(609, 'Mamurras', 'Mamurras', 'Mamuras,Mamurasi,Mamuraz,Mamurras,Mamurrasi,Murrizaj,Мамуррас', 41.5775000, 19.6922200, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(610, 'Maminas', 'Maminas', 'Maminas,Maminasi,Meminas,Meminasi,Meminosi,Veminasi', 41.3791700, 19.6075000, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(611, 'Luzi i Vogël', 'Luzi i Vogel', 'Ljuz i vogel,Luz i Vogel,Luz i Vogël,Luzi i Vogel,Luzi i Vogël', 41.1275000, 19.5738900, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(612, 'Lushnjë', 'Lushnje', 'Liusne,Liušnė,Ljushna Cod a Gomares,Ljushnja,Ljusnje,Ljušnje,Lousnia,Lushne,Lushnja,Lushnje,Lushnjë,Lusnje,Lušnje,lu shen nie,lusyunyeo,lwshnyh,rushunya,Лушње,Люшня,لوشنيه,لوشنیہ,ルシュニャ,卢什涅,루슈녀', 40.9419400, 19.7050000, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(613, 'Luftinjë', 'Luftinje', 'Luftinia,Luftinja,Luftinje,Luftinjë', 40.4427800, 19.9544400, 'AL', '2012-06-07', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(614, 'Libofshë', 'Libofshe', 'Libofsha,Libofshe,Libofshë,Libovfs,Libovfš,Libovshe,Libovshë,Resh Libovtsa,Tregishte', 40.8344400, 19.5522200, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(615, 'Lezhë', 'Lezhe', 'Alessio,Les,Lesh,Leshe,Leshi,Leze,Lezh,Lezha,Lezhe,Lezhë,Leş,Ležė,Lisi,Ljes,Ljesh,Lješ,Lyesh,lai shen,lejeo,lezha,lzhh,Љеш,Леж,Лежа,لژه,لژہ,ლეჟა,莱什,레저', 41.7836100, 19.6436100, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(616, 'Levan', 'Levan', 'Levan,Levan-Samaraj,Levan-Samari,Levani,Levani Samar,Levani Samares,Levani Samarit,Levani Samarës,Levani i Madh', 40.6761100, 19.4897200, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(617, 'Lekbibaj', 'Lekbibaj', 'Lekbibaj', 42.2947200, 19.9316700, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(618, 'Lekaj', 'Lekaj', 'Lekaj,Ljekaj', 41.1144400, 19.6097200, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(619, 'Laç', 'Lac', 'Lac,Lach,Lachi,Laci,Lak,Latsch,Laç,Laçi,Liacis,Liačis,Ljach,la qi,lasy,Лак,Лач,Лачі,Ляч,لاسی,拉奇', 41.6355600, 19.7130600, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(620, 'Kutë', 'Kute', 'Cuta,Kuta,Kute,Kutë', 40.4733300, 19.7663900, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(621, 'Kutalli', 'Kutalli', 'Kutaj,Kutali,Kutalli,Kutallia,Kutallija', 40.7838900, 19.7866700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(622, 'Kurjan', 'Kurjan', 'Kurian,Kuriani,Kurjan,Kurjani,Kurjanj', 40.7175000, 19.7455600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(623, 'Kuman', 'Kuman', 'Cumani,Kuman,Kumani', 40.7266700, 19.6866700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(624, 'Kuçovë', 'Kucove', 'Kuchova,Kucova,Kucove,Kuçova,Kuçovë,Petrolia,Qyteti Stalin,Stalin,Кучова', 40.8002800, 19.9166700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(625, 'Kuç', 'Kuc', 'Kuc,Kuci,Kuç,Kuçi', 42.0397200, 19.5252800, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(626, 'Kryevidh', 'Kryevidh', 'Krievil,Kruevith,Kryevidh,Kryevidhe,Kryevidhi,Kryevidhë', 41.1005600, 19.5275000, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(627, 'Krutja e Poshtme', 'Krutja e Poshtme', 'Kruati i Poshtem,Kruati i Poshtëm,Kruatje e Poshteme,Kruatje e Poshtme,Kruatje e Poshtëme,Krutja e Poshteme,Krutja e Poshtme,Krutja e Poshtëme,Krutje e Poshtme,Krutje e Posteme,Krutje e Postëme,Post Kruati', 40.8719400, 19.6808300, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(628, 'Krujë', 'Kruje', 'Akcehisar,Akçehisar,Croia,Cruja,Krna,Kroia,Kroja,Kroya,Kroïa,Krue,Krueja,Kruja,Kruje,Krujë,Круе', 41.5091700, 19.7927800, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(629, 'Krrabë', 'Krrabe', 'Kerraba,Kerrabe,Kraba e Vogel,Kraba e Vogël,Krraba,Krraba Vogel,Krraba e Vogel,Krraba e Vogël,Krrabe,Krrabe e Vog,Krrabë,Kërraba,Kërrabë', 41.2155600, 19.9713900, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(630, 'Krahës', 'Krahes', 'Krahes,Krahes Numer Nje,Krahesi,Krahesi Numer Nje,Krahës,Krahës Numër Një,Krahësi,Krahësi Numër Një', 40.4386100, 19.8444400, 'AL', '2012-06-07', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(631, 'Kozarë', 'Kozare', 'Kozara,Kozare,Kozarja,Kozarë', 40.8308300, 19.9005600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(632, 'Kotë', 'Kote', 'Kota,Kote,Kotta,Kotë', 40.3894400, 19.6022200, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(633, 'Koplik', 'Koplik', 'Koplik,Koplik Poster,Koplik Pošter,Koplik i Poshtem,Koplik i Poshtëm,Kopliku,Kopliku i Poshtem,Kopliku i Poshtëm,Kopliku-e Poshtem,Kopliku-e Poshtëm,ke pu li ku,kwplykw,Коплик,کوپلیکو,科普利庫', 42.2136100, 19.4363900, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(634, 'Kombësi', 'Kombesi', 'Kombesi,Kombesia,Kombesit,Kombësi,Kombësia,Komesi,Komesia,Komsi,Komësi,Komësia', 41.5816700, 19.9855600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(635, 'Kolonjë', 'Kolonje', 'Colonia,Koljonja,Kolonj,Kolonja,Kolonje,Kolonjë,Колёня', 40.8241700, 19.6038900, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(636, 'Kolç', 'Kolc', 'Kolc,Kolc-Logorec,Kolc-Logoreci,Kolci,Koljs,Kolsh,Kolç,Kolç-Logorec,Kolç-Logoreci,Kolçi,Logoreci', 41.7866700, 19.6761100, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(637, 'Kavajë', 'Kavaje', 'Cavaia,Cavaja,Kavaia,Kavaj,Kavaja,Kavaje,Kavajë,Kavajė,Kavalye,Kavaya,Kavaïa,Kawaja,ka wa ya,kabayeo,kawayh,Кавайе,Кавая,Каваја,کاوایه,کاوایہ,卡瓦亚,카바여', 41.1855600, 19.5569400, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(638, 'Katundi i Ri', 'Katundi i Ri', 'Katund i Ri,Katundi,Katundi i Ri', 41.4030600, 19.5180600, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(639, 'Kastrat', 'Kastrat', 'Kastrat,Kastrati,Vukpalaj,Vukpalaj-Kastrat', 42.3525000, 19.4891700, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(640, 'Kashar', 'Kashar', 'Kashar,Kashari', 41.3497200, 19.7102800, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(641, 'Karinë', 'Karine', 'Karina,Karina Kosenj,Karine,Karinë', 41.0630600, 19.7161100, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(642, 'Karbunara e Vogël', 'Karbunara e Vogel', 'Karbunara e Poshteme,Karbunara e Poshtme,Karbunara e Poshtëme,Karbunara e Vogel,Karbunara e Vogël,Karbunare e Poshteme,Karbunare e Poshtme,Karbunare e Vogel,Karbunarë e Poshtme,Karbunarë e Poshtëme,Karbunarë e Vogël', 40.9219400, 19.7177800, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(643, 'Kamëz', 'Kamez', 'Camza,Kambeza,Kambëza,Kamez,Kamza,Kamze,Kamzë,Kamzė,Kamëz,ka mu zha,kamza,Камза,کامزا,卡姆扎', 41.3816700, 19.7602800, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(644, 'Kallmeti i Madh', 'Kallmeti i Madh', 'Calmeti,Kallheti i Math,Kallmet,Kallmet i Madh,Kallmet i Math,Kallmeti,Kallmeti i Madh,Kallmeti i Math,Kalmet', 41.8488900, 19.6869400, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(645, 'Kallmet', 'Kallmet', 'Kaljmet,Kallmet,Kallmeti,Kalmeti', 41.4180600, 19.8213900, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(646, 'Kalenjë', 'Kalenje', 'Kahlenja,Kalenj,Kalenja,Kalenje,Kalenjë', 40.5900000, 19.7783300, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(647, 'Kajan', 'Kajan', 'Kajan,Kajani,Shkembi,Shkëmbi', 40.9141700, 19.8894400, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(648, 'Kaçinar', 'Kacinar', 'Kacinar,Kacinari,Kaçinar,Kisha e-Simonit', 41.8933300, 19.8986100, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(649, 'Ishëm', 'Ishem', 'Ishem,Ishm,Ishmi,Ishëm', 41.5452800, 19.6000000, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(650, 'Hysgjokaj', 'Hysgjokaj', 'Dzokaj,Džokaj,Hysaj,Hysgjokaj,Xhokaj', 40.9716700, 19.7897200, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(651, 'Hot', 'Hot', 'Hot,Hoti', 42.3619400, 19.4441700, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(652, 'Himarë', 'Himare', 'Chimara,Cimarre,Himara,Himare,Himarë,Imara,Kheimara,Khimara,Химара', 40.1016700, 19.7447200, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(653, 'Helmas', 'Helmas', 'Elmasi,Heljmas,Helmas,Helmasi,Helmes,Helmesi,Helmës,Helmësi', 41.1802800, 19.6069400, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(654, 'Hekal', 'Hekal', 'Hecali,Hekal,Hekali,Hekalj', 40.5619400, 19.7358300, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(655, 'Hasan', 'Hasan', 'Hasan,Hasanaj,Hasani', 41.4827800, 19.6997200, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(656, 'Hajmel', 'Hajmel', 'Ajmeli,Guragi,Hajmel,Hajmeli,Hajmelj', 41.9530600, 19.6377800, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(657, 'Gurra e Vogël', 'Gurra e Vogel', 'Gura Vogel,Gura Vogël,Gurr'' e Vogel,Gurra Vogel,Gurra e Vogel,Gurra e Vogël,Gurre e Vogel,Gurrë e Vogël,Gurr’ e Vogel', 41.5361100, 19.9908300, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(658, 'Guri i Zi', 'Guri i Zi', 'Gur i Zi,Guri i Zi', 42.0450000, 19.5747200, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(659, 'Gruemirë', 'Gruemire', 'Gruemira,Gruemire,Gruemirë', 42.1591700, 19.5188900, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(660, 'Greshicë', 'Greshice', 'Greshica,Greshice,Greshicë,Gresic,Grešic', 40.5519400, 19.7783300, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(661, 'Grekan', 'Grekan', 'Grekan,Grekani', 40.9294400, 19.9475000, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(662, 'Gradishtë', 'Gradishte', 'Gradisht,Gradishta,Gradishte,Gradishti,Gradishtë,Gradista,Gradiza,Gradišta,Qyteze,Qytezë', 40.8880600, 19.5858300, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(663, 'Gracen', 'Gracen', 'Gracen,Graceni,Grrecen,Grreceni', 41.1519400, 19.9636100, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(664, 'Grabjan', 'Grabjan', 'Grabian,Grabiani,Grabijan,Grabijani,Grabjan,Grabjani,Grobia,Grunasi', 40.9530600, 19.5808300, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(665, 'Gosë e Madhe', 'Gose e Madhe', 'Gosa e Madhe', 41.0905600, 19.6247200, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(666, 'Golem', 'Golem', 'Cela i Madh,Golem,Golem i Madh,Golem i Math,Golemi,Golemi i Madh,Çela i Madh', 40.9677800, 19.6852800, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(667, 'Gjoçaj', 'Gjocaj', 'Djocaj,Gjocaj,Gjocej,Gjoçaj,Ðjocaj', 41.0255600, 19.7238900, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(668, 'Gjepalaj', 'Gjepalaj', 'Depale,Gjepalaj,Gjepale,Gjepalie,Gjopalaj,Ðepale', 41.3330600, 19.5780600, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(669, 'Fushëkuqe', 'Fushekuqe', 'Fush-Kuqe,Fusha e Kuge,Fusha e Kuqe,Fushe-Kuqja,Fushekuqe,Fushekuqeja,Fushë-Kuqja,Fushëkuqe,Fushëkuqeja', 41.6502800, 19.6200000, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(670, 'Fushë-Krujë', 'Fushe-Kruje', 'Fus e Krujs,Fush'' e Krujes,Fush-Kruja,Fusha-Kruja,Fushe Kruja,Fushe e Krujes,Fushe-Kruje,Fushë Kruja,Fushë e Krujës,Fushë-Krujë,Fush’ e Krujës,Fuš e Krujs,Teke Fuscia Crujs,Фуша-Круя', 41.4783300, 19.7177800, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(671, 'Fratar', 'Fratar', 'Fratari', 40.5000000, 19.8166700, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(672, 'Frakulla e Madhe', 'Frakulla e Madhe', 'Frakula,Frakula e Pasajit,Frakula e Pašajit,Frakull e Madhe,Frakull'' e Pashajt,Frakulla e Madhe,Frakulla e Pashajit,Frakulle,Frakulle e Madhe,Frakulle e Pashajt,Frakullë,Frakullë e Madhe,Frakullë e Pashajt,Frakull’ e Pashajt,Frankulle Pashajt', 40.6558300, 19.5025000, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(673, 'Fier-Shegan', 'Fier-Shegan', 'Fier Shegeni,Fier-Shegan,Fier-Shegani,Fieri Shegani', 40.8672200, 19.7852800, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(674, 'Fier-Çifçi', 'Fier-Cifci', '', 40.7166700, 19.5666700, 'AL', '2007-05-30', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(675, 'Fier', 'Fier', 'Fearica,Fier,Fieri,Fieris,Fijer,Fjer,Fjeri,a pha''ira,fei xia er,fieru,fyr,pieleu,Фиер,Фиери,Фієрі,Фјер,فیر,अ फाइर,フィエル,非夏爾,피에르', 40.7238900, 19.5561100, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(676, 'Farka e Madhe', 'Farka e Madhe', 'Farka,Farka e Madhe,Farke,Farke e Madhe,Farkë,Farkë e Madhe', 41.3055600, 19.8669400, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(677, 'Durrës', 'Durres', 'Drac,Drach,Drač,Duraso,Durazo,Durazzo,Durazzu,Dures,Duresi,Duresis,Durrazo,Durres,Durresa,Durresi,Durrsi,Durrës,Durrësi,Durts,Durus,Durz,Durësi,Dyrrachio,Dyrrachium,Dyrrakhion,Dyrrhachium,Epidamnos,Gorad Durehs,dou la si,do~urasu,draj,dras,duleoseu,duresi,durres,dwrs,Δυρράχιο,Горад Дурэс,Драч,Дуррес,Дуръс,דורס,دراج,دراس,ดูร์เรส,დურესი,ドゥラス,都拉斯,두러스', 41.3230600, 19.4413900, 'AL', '2012-01-19', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(678, 'Drenovë', 'Drenove', 'Drenova,Drenove,Drenovë,Drnova', 40.6005600, 19.7008300, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(679, 'Divjakë', 'Divjake', 'Diviaka,Divjaca,Divjak,Divjaka,Divjake,Divjakë,Duvijaka,Pisha', 40.9966700, 19.5294400, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(680, 'Dërmënas', 'Dermenas', 'Dermena,Dermenas,Dermenasi,Dermënasi,Drmanas,Dërmënas', 40.7455600, 19.4938900, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(681, 'Vau i Dejës', 'Vau i Dejes', 'Danski Brod,Dejas,Vai Dejes,Vai Dejës,Vau Dejes,Vau Dejës,Vau i Dejes,Vau i Dejës,Vau-Deja,Vau-Dejas,Vau-Dejes,Vau-Dejs,Vau-Dejës,wayw djs,Вау-Деяс,Дањски Брод,وائو دجس', 42.0100000, 19.6247200, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(682, 'Dajt', 'Dajt', 'Dajt,Dajti,Njesia administrative Dajt,Njësia administrative Dajt', 41.3936100, 19.9158300, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(683, 'Dajç', 'Dajc', 'Dajc,Dajci,Dajç,Dajçi', 41.9916700, 19.4105600, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(684, 'Dajç', 'Dajc', 'Dajc,Dajci,Dajç', 41.9155600, 19.6044400, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(685, 'Cukalat', 'Cukalat', 'Cukakat,Cukala,Cukalat,Cukalati,Cukaljat,Cukelat,Cukelati', 40.7302800, 19.7905600, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(686, 'Cudhi Zall', 'Cudhi Zall', 'Cedhin,Cedhini,Cudhi Zall,Cudhija,Cudhin,Cudhini,Cudhuni,Cuvija,Çedhini', 41.5094400, 19.8458300, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(687, 'Cërrik', 'Cerrik', 'Cerik,Cerrik,Cerriku,Curik,Cërrik,Cërriku,Valasi,ce li ke,srykw,Церик,Церрик,Церрік,Църик,سریکو,策里克', 41.0316700, 19.9758300, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(688, 'Cakran', 'Cakran', 'Cakran,Cakrani,Cakrrani,Zakran', 40.6033300, 19.6261100, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(689, 'Bushat', 'Bushat', 'Busciala,Bushat,Bushati', 42.1194400, 19.8997200, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(690, 'Bubullimë', 'Bubullime', 'Bubullima,Bubullime,Bubullimë,Bubulmani,Buhullime,Buhullimë,Bumlulim', 40.8180600, 19.6408300, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(691, 'Bubq', 'Bubq', 'Bubc,Bubesi,Bubge,Bubgë,Bubq,Bubqe,Bubqi,Bubqë,Bubsi,Bubësi,Bubć', 41.4741700, 19.6516700, 'AL', '2012-06-01', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(692, 'Brataj', 'Brataj', 'Brataj,Bratraj', 40.2677800, 19.6691700, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(693, 'Bërzhitë', 'Berzhite', 'Berzhita,Berzhite,Bregishte,Bregjshte,Bërzhitë', 41.2452800, 19.9011100, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(694, 'Bërxull', 'Berxull', 'Berxull,Berxulla,Berxulle,Berxulli,Berzulla,Berzulle,Brzula,Bërxull,Bërxulli,Bërxullë,Bërzullë', 41.3800000, 19.6875000, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(695, 'Bërdica e Madhe', 'Berdica e Madhe', 'Berdica e Madhe,Berdice,Berdice e Madhe,Bërdica e Madhe,Bërdicë,Bërdicë e Madhe', 42.0152800, 19.4816700, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(696, 'Berat', 'Berat', 'Belgrad,Beligrad,Berat,Berati,Beration,Beratis,Berta,Bərat,Lezskigrad,Verati,Veration,belateu,berato,brat,byrat,pei la te,Μπεράτ,Белград,Берат,Բերատ,בראט,برات,بیرات,ბერატი,ベラト,培拉特,베라트', 40.7058300, 19.9522200, 'AL', '2012-06-03', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(697, 'Belsh', 'Belsh', 'Belesh,Beleshi,Beleshit,Belsh,Belshi,Belësh,Belëshi,Belëshit', 40.9750000, 19.8819400, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(698, 'Baz', 'Baz', 'Baz,Baza,Baze,Bazi,Bazja,Bazje,Bazjë,Bazë', 41.6319400, 19.9291700, 'AL', '2012-06-02', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(699, 'Banaj', 'Banaj', 'Banaj,Banani,Bananj,Beran', 40.8247200, 19.8391700, 'AL', '2013-05-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(700, 'Ballsh', 'Ballsh', 'Bal''shi,Baleri,Ballesh,Balleshi,Ballsh,Ballsha,Ballshi,Ballësh,Ballëshi,Bals,Balsh,Balshi,Balsis,Balš,Balšis,ba er shen,balshy,Балш,Балши,Бальши,بالشی,巴爾什', 40.5988900, 19.7347200, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(701, 'Ballagat', 'Ballagat', 'Balagati,Ballagat,Ballagati,Ballajgati', 40.9952800, 19.7652800, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(702, 'Baldushk', 'Baldushk', 'Baldushk,Baldushke,Baldushku,Baldushkë,Baldushuku,Balije,Balja,Balldushk,Balldushku,Bulldushku', 41.2138900, 19.7969400, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(703, 'Armen', 'Armen', 'Armen,Armeni', 40.5363900, 19.5961100, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(704, 'Aranitas', 'Aranitas', 'Aranitas,Aranitasi,Aranitesi,Aranitësi,Arositani', 40.5944400, 19.8066700, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(705, 'Allkaj', 'Allkaj', 'Alikaj,Allkaj,Hallkani,Rrethi', 40.8575000, 19.7552800, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(706, 'Golem', 'Golem', 'Golem,Golemasi,Mali Robit', 41.2458300, 19.5347200, 'AL', '2012-06-13', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(707, 'Balldreni i Ri', 'Balldreni i Ri', 'Balldran,Balldren i Ri,Balldreni,Balldreni i Ri', 41.8191700, 19.6402800, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(708, 'Grudë-Fushë', 'Grude-Fushe', 'Grude-Fusha,Grude-Fushe,Grudë-Fusha,Grudë-Fushë', 42.1622200, 19.4966700, 'AL', '2012-06-12', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(709, 'Fierzë', 'Fierze', 'Fierza,Fierze,Fierzë,Фиерза', 40.9205600, 19.8469400, 'AL', '2012-05-31', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(710, 'Dushk', 'Dushk', 'Dushk,Dushku', 40.7266700, 19.7572200, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(711, 'Selitë', 'Selite', 'Selita,Selite,Selitë', 40.5475000, 19.8480600, 'AL', '2012-06-05', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(712, 'Vllahinë', 'Vllahine', 'Vllahina,Vllahine,Vllahinë', 40.4569400, 19.6436100, 'AL', '2012-06-14', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(713, 'Bajram Curri', 'Bajram Curri', 'Bairam Curis,Bajram Curi,Bajram Curr,Bajram-Curri,ba yi la mu chu li cheng,bjram kwry,Байрам Цури,Байрам-Цурри,Бајрам Цури,Բայրամ Ցուրի,بجرام کوری,巴依拉姆楚里城', 42.3573400, 20.0767900, 'AL', '2012-06-11', 3);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(345, 'West End Village', 'West End Village', '', 18.1719100, -63.1494100, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(346, 'The Valley', 'The Valley', 'De Balei,El Valle,Gorad Vali,La-Valo,The Valley,Vali,Valis,Valley,Valli,bare,d wly,deobaelli,dy wyly,hwwʼly,ti velli,vali,wa li,Δε Βάλεϊ,Вали,Валли,Валлі,Горад Валі,הוואלי,د ولی,دی ویلی,தி வேல்லி,เดอะแวลลีย์,ვალი,バレー,瓦利,더밸리', 18.2170400, -63.0578300, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(347, 'The Quarter', 'The Quarter', 'The Quarter', 18.2079900, -63.0417800, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(348, 'Farrington', 'Farrington', 'The Farrington', 18.2150000, -63.0223800, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(349, 'Stoney Ground', 'Stoney Ground', 'Stoney Ground', 18.2202600, -63.0460700, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(350, 'South Hill Village', 'South Hill Village', '', 18.1920100, -63.0877900, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(351, 'Sandy Ground Village', 'Sandy Ground Village', 'Sandy Ground Village', 18.2011800, -63.0899800, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(352, 'North Side', 'North Side', 'North Side', 18.2291900, -63.0440100, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(353, 'North Hill Village', 'North Hill Village', '', 18.2054200, -63.0784700, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(354, 'Island Harbour', 'Island Harbour', '', 18.2560100, -63.0102000, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(355, 'George Hill', 'George Hill', 'George Hill', 18.1993900, -63.0665000, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(356, 'East End Village', 'East End Village', 'East End,East End Village', 18.2333300, -63.0000000, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(357, 'Blowing Point Village', 'Blowing Point Village', 'Blowing Point Village', 18.1764800, -63.0937500, 'AI', '2016-08-07', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(358, 'Sandy Hill', 'Sandy Hill', '', 18.2210400, -63.0132900, 'AI', '2016-07-31', 8);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(336, 'Saint John’s', 'Saint John''s', 'Saint John,Saint John''s,Saint John’s,Sent Dzonsas,Sent Džonsas,Sent Tzons,Sent-Dzhons,St Johns,St. John''s,St.John.s,seinteujonseu,sentojonzu,sheng yue han,sheng yue han shi,snt g''wns,Σεντ Τζονς,Сент-Джонс,סנט ג''ונס,ሴንት ጆንስ፥ አንቲጋ እና ባርቡዳ,セントジョンズ,圣约翰,圣约翰市,세인트존스', 17.1209600, -61.8432900, 'AG', '2017-05-24', 10);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(337, 'Potters Village', 'Potters Village', 'Potters,Potters Village,Potters village,Potters-Villadzh,Поттерс-Вилладж', 17.0833300, -61.8166700, 'AG', '2016-06-26', 10);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(338, 'Piggotts', 'Piggotts', 'Piggotts,Saint Mark''s,Saint Marks Village,Saint Mark’s', 17.1166700, -61.8000000, 'AG', '2013-08-02', 10);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(339, 'Parham', 'Parham', 'Parham,Parkhehm,Пархэм', 17.0968200, -61.7704600, 'AG', '2016-06-26', 10);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(340, 'Liberta', 'Liberta', 'Liberta,Liberta Village,Либерта', 17.0333300, -61.7833300, 'AG', '2016-06-26', 10);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(341, 'Falmouth', 'Falmouth', 'Falmouth', 17.0274100, -61.7813600, 'AG', '2013-08-02', 10);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(342, 'Codrington', 'Codrington', 'Codrington,Codrington Village,Kodrington,Kodringtonas,ke de ling dun,kodeulingteon,kodorinton,qwdryngtwn,Кодрингтон,קודרינגטון,کوڈرنگٹن، باربوڈا,コドリントン,科德灵顿,코드링턴', 17.6333300, -61.8333300, 'AG', '2014-08-18', 10);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(343, 'Bolands', 'Bolands', 'Boland Village,Bolands,Bolans', 17.0656500, -61.8746600, 'AG', '2016-06-26', 10);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(344, 'All Saints', 'All Saints', 'All Saints,All Saints Village', 17.0667100, -61.7930300, 'AG', '2016-06-26', 10);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(714, 'Zarrit’ap’', 'Zarrit''ap''', 'Azizbekov,Pashaghu,Pashalu,Zaritap,Zarrit''ap'',Zarrit’ap’,Զառիթափ', 39.6389200, 45.5111100, 'AM', '2016-07-04', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(715, 'Zangakatun', 'Zangakatun', 'Chanakhchi,Nizhniye Chanakhchi,Sovetashen,Zangakatun,Зангакатун,Զանգակատուն', 39.8223300, 45.0416900, 'AM', '2015-08-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(716, 'Goravan', 'Goravan', 'Goravan,Gorovan,Yenikend', 39.9083200, 44.7332800, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(717, 'Yeghegnavan', 'Yeghegnavan', 'Egegnavan,Ekhegnavan,Shidlu,Yeghegnavan,Ехегнаван,Եղեգնավան', 39.8389300, 44.6195100, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(718, 'Yeghegnadzor', 'Yeghegnadzor', 'Egegnajor,Eghegnazor,Ehegnadzor,Ekhegnadzor,Jechegnadzor,Jeghegnadsor,Jeghegnadzor,Jeghegnadzoras,Jekhegnadzor,Keshishkend,Keshishkent,Keşişkənd,Mikoyan,Yegegnadzor,Yeghegik,Yeghegnadzor,Yekhegnadzor,Yeğegnadzor,eghegnadzori,ye hai ge na zuo er,yegeganadajora,yghghnadzwr,yghgnadzwr,yghgndzwr,Єхегнадзор,Јехегнаџор,Ехегнадзор,Եղեգնաձոր,يغغنادزور,یغگنادزور,یغگندزور,ਯੇਗੇਗਨਾਦਜੋਰ,ეღეგნაძორი,葉海格納佐爾', 39.7638900, 45.3323900, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(719, 'Vostan', 'Vostan', 'Bedzhazlu,Ostan,Vostan,Востан,Ոստան', 39.9651500, 44.5593700, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(720, 'Vosketap’', 'Vosketap''', 'Shiraz,Shirazlu,Vosketap'',Vosketap’,Ոսկետափ', 39.8811400, 44.6491700, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(721, 'Vernashen', 'Vernashen', 'Bashkend,Vernashen,Вернашен', 39.7923600, 45.3638900, 'AM', '2012-01-17', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(722, 'Verishen', 'Verishen', 'Verisen,Verishen,Վերիշեն', 39.5354300, 46.3206300, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(723, 'Vedi', 'Vedi', 'Beyuk-Vedi,Biyuk-Vedi,Vedi,Веди,Վեդի', 39.9138800, 44.7251000, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(724, 'Vayk’', 'Vayk''', 'Azizbekov,Soylan,Vajk,Vayk'',Vayk’,Вайк,Վայք', 39.6889000, 45.4666800, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(725, 'Tegh', 'Tegh', 'Dyg,Lekh,Teg,Tegh,Tekh,Тех,Տեղ', 39.5582600, 46.4805400, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(726, 'Surenavan', 'Surenavan', 'Surenavan,Սուրենավան', 39.7944900, 44.7750800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(727, 'Sisavan', 'Sisavan', 'Sisavan,Yengidzha,Сисаван,Սիսավան', 39.9080200, 44.6672100, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(728, 'Shinuhayr', 'Shinuhayr', 'Shinuair,Shinuajr,Shinuayr,Shinuhayr,Sinuayr,Sinuhayr,Şinuayr,Шинуайр,Շինուհայր', 39.4367000, 46.3178700, 'AM', '2012-01-17', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(729, 'Shahumyan', 'Shahumyan', 'Sahumyan,Shahumian,Shahumyan,Shaumjan,Shaumyan,Yuva,Шаумян,Շահումյան', 39.9417100, 44.5723300, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(730, 'Shatin', 'Shatin', 'Gasankend,Hasankand,Hesan Kand,Satin,Shatik,Shatin,Шатин,Շատին', 39.8361200, 45.3029200, 'AM', '2016-07-04', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(731, 'Shaghat', 'Shaghat', 'Sagat,Shagat,Shaghat,Շաղատ', 39.5582900, 45.9166900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(732, 'Rrind', 'Rrind', 'Rind,Rrind,Ռինդ', 39.7611100, 45.1779200, 'AM', '2015-08-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(733, 'Noyakert', 'Noyakert', 'Khalisa,Nojakert,Noyakert,Ноякерт,Նոյակերտ', 39.8306900, 44.6694900, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(734, 'Mrgavan', 'Mrgavan', 'Gedaklu,Mgravan,Mrgavan,Мграван,Մրգավան', 39.9725100, 44.5356500, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(735, 'Meghri', 'Meghri', 'Meghri,Megri,Megris,Megry,Mergi,Meğri,Mogri,meghri,mei ge li,mghry,Мегри,Мегрі,Մեղրի,مغری,მეღრი,梅格里', 38.9029200, 46.2445800, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(736, 'Malishka', 'Malishka', 'Malishka,Maliska,Մալիշկա', 39.7473100, 45.4057000, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(737, 'Khndzoresk', 'Khndzoresk', 'Khndzoresk,Xnjoresk,Խնձորեսկ', 39.5056800, 46.4361000, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(738, 'Kapan', 'Kapan', 'Ghap''an,Ghapan,Ghap’an,Kafan,Kafin,Kapan,Kapanas,Katan,Madan,Qafan,Zangezur,ka pan,kapan,kapana,Капан,Կապան,کاپان,ਕਪਾਨ,კაპანი,カパン,卡潘,카판', 39.2075500, 46.4057600, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(739, 'Jermuk', 'Jermuk', 'Dzhermuk,Jermuk,Джермук,Ջերմուկ', 39.8416800, 45.6694900, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(740, 'Goris', 'Goris', 'Geryusy,Goris,Горис,Գորիս', 39.5111100, 46.3416800, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(741, 'Gladzor', 'Gladzor', 'Gladzor,Glajor,Ortakend,Гладзор,Գլաձոր', 39.7807000, 45.3472900, 'AM', '2016-07-04', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(742, 'Getap’', 'Getap''', 'Getap'',Getap’,Ghyotur,Koytur,Գետափ', 39.7639200, 45.3082900, 'AM', '2016-07-04', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(743, 'Dzorastan', 'Dzorastan', 'Akhtakhana,Dzorastan,Jorastan,Khlatag,Ձորաստան', 39.2705900, 46.3572000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(744, 'Dalar', 'Dalar', 'Dalar,Dalular,Далар,Դալար', 39.9765300, 44.5264900, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(745, 'Burastan', 'Burastan', 'Burastan,Karagamzalu,Tamamlu,Բուրաստան', 39.9915700, 44.4968100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(746, 'Akner', 'Akner', 'Akner,Brun,Ակներ,Բրուն', 39.5349100, 46.3073200, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(747, 'Brrnakot’', 'Brrnakot''', 'Brnakot,Brrnakot'',Brrnakot’,Բռնակոթ', 39.4974200, 45.9724100, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(748, 'Berk’anush', 'Berk''anush', 'Berk''anush,Berkanush,Berk’anush,Ogurbeklu,Բերքանուշ', 39.9779000, 44.5167200, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(749, 'Aygezard', 'Aygezard', 'Ajgezard,Anastasavan,Aygedzor,Aygezard,Dargalu,Айгезард,Այգեզարդ', 39.9543600, 44.6022900, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(750, 'Aygepat', 'Aygepat', 'Ajgepat,Aygepat,Dargalu Verkhniy,Masumlu,Verkhniy Dargalu,Айгепат,Այգեպատ', 39.9584500, 44.5998100, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(751, 'Aygavan', 'Aygavan', 'Ajgavan,Aygavan,Reganlu,Айгаван,Այգավան', 39.8732700, 44.6698400, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(752, 'Avshar', 'Avshar', 'Avsar,Avshar,Ավշար', 39.8555300, 44.6583200, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(753, 'Hats’avan', 'Hats''avan', 'Acavan,Atsavan,Hats''avan,Hats’avan,Sisian,Ацаван,Հացավան', 39.4640500, 45.9704700, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(754, 'Artashat', 'Artashat', 'Artachat,Artasat,Artasatas,Artasato,Artaschat,Artashat,Artasjat,Artaszat,Artaxat,Artaxata,Artaŝato,Artaşat,Artašat,Artašatas,Artașat,Kamarl,Kamarlu,Kamarlyu,Qəmərli,a er ta sha te,aratasata,artashat,artashat  armynya,Арташат,Արտաշատ,آرتاشات,آرتاشات، آرمینیا,أرتاشات,ਅਰਤਾਸ਼ਤ,არტაშატი,阿爾塔沙特', 39.9614400, 44.5444700, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(755, 'Yeghegis', 'Yeghegis', 'Alagyaz,Alayaz,Artabuynk,Egegis,Erdapin,Yeghegis,Yekhegis,Եղեգիս', 39.8723100, 45.3501000, 'AM', '2016-07-04', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(756, 'Armash', 'Armash', 'Armas,Armash,Արմաշ', 39.7667200, 44.8111000, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(757, 'Areni', 'Areni', 'Areni,Arpa,Арени,Արենի', 39.7166800, 45.1832900, 'AM', '2015-08-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(758, 'Ararat', 'Ararat', 'Ararat,Araratas,Ararato,Davalinskiy Tsemzavod,Davalu,alalateu,ararat,ararat  armnstan,ararata,ararato,ya la la,Арарат,Արարատ,אררט,آرارات، ارمنستان,أرارات,ਅਰਾਰਤ,არარატი,アララト,亞拉臘,아라라트', 39.8306900, 44.7056900, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(759, 'Angeghakot’', 'Angeghakot''', 'Angeghakot'',Angeghakot’,Angekhakot,Angelaut,Անգեղակոթ', 39.5695200, 45.9445200, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(760, 'Aghavnadzor', 'Aghavnadzor', 'Agavnadzor,Agavnajor,Aghavnadzor,Akhavnadzor,Aynadzor,Агавнадзор,Աղավնաձոր', 39.7860700, 45.2279000, 'AM', '2015-08-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(761, 'Agarakadzor', 'Agarakadzor', 'Agarakadzor,Agarakajor,Ayar,Агаракадзор,Ագարակաձոր', 39.7360800, 45.3555300, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(762, 'Agarak', 'Agarak', 'Agarak,Aqarak,Агарак,Ագարակ', 39.2068400, 46.5446000, 'AM', '2016-06-04', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(763, 'Aralez', 'Aralez', 'Aralek,Aralez,Արալեզ', 39.9000800, 44.6557000, 'AM', '2016-02-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(764, 'Horrom', 'Horrom', 'Horom,Horrom,Orom,Ором,Հոռոմ', 40.6597300, 43.8903200, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(765, 'Margara', 'Margara', 'Margara,Markara,Маргара,Маркара,Մարգարա', 40.0333200, 44.1804800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(766, 'Zovuni', 'Zovuni', 'Molla Kasum,Zovuni,Зовуни,Զովունի', 40.5111100, 44.4389000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(767, 'Zovaber', 'Zovaber', 'Yaydzhi,Zovaber,Зовабер,Զովաբեր', 40.5667100, 44.7902800, 'AM', '2016-09-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(768, 'Zorak', 'Zorak', 'Donguzyan,Zangilar,Zorak,Зорак,Զորակ', 40.0916800, 44.3944700, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(769, 'Zarr', 'Zarr', 'Zar,Zarr,Зар,Զառ', 40.2584800, 44.7332800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(770, 'Yerevan', 'Yerevan', 'Ayrivan,Djerevan,EVN,Eireavan,Eireaván,Ereban,Ereun,Erevan,Erevan osh,Erevana,Erevano,Erevanum,Erevàn,Ereván,Erevāna,Erewan,Erivan,Eriwan,Erywan,Erywań,Gierevan,Gorad Erehvan,Ierevan,Iereván,Iravan,Jerevan,Jerevanas,Jerevani,Jereván,Jerewan,Jerjewan,Revan,Yerevan,Yervandavan,Yerêvan,Yiriwan,Yèrèvan,Yérévan,ayrwan,ereban,erevani,iyerebhana,shhr ayrwan,ye li wen,yeleban,yeravana pranta,yere wan,yerevan,yerevana,yerevhana,yryfan,yrywan,Èrevan,Êrîvan,İrəvan,Γιερεβάν,Ερεβάν,Єреван,Јереван,Горад Ерэван,Ереван,Ереван ош,Երեվան,Երևան,יערעוואן,ירוואן,ایروان,شهر ایروان,يريفان,يېرېۋان,یریوان,یەریڤان,येरवान प्रान्त,येरेवान,येरेव्हान,ইয়েরেভান,யெரெவான்,เยเรวาน,ཡེ་རེ་ཝན།,ერევანი,ዬሬቫን,エレバン,葉里溫,예레반', 40.1811100, 44.5136100, 'AM', '2016-03-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(771, 'Yerazgavors', 'Yerazgavors', 'Aralykh,Erazgavors,Yerazgavors,Еразгаворс', 40.6950500, 43.7472200, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(772, 'Yeraskhahun', 'Yeraskhahun', 'Erasxahun,Kuru-Araz,Yeraskhahun,Yeraskhaun,Երասխահուն', 40.0723300, 44.2194800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(773, 'Yeranos', 'Yeranos', 'Eranos,Yeranos,Еранос,Երանոս', 40.2042800, 45.1920900, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(774, 'Yeghegnut', 'Yeghegnut', 'Egegnut,Ekheknut,Kamyshkut,Yegegnut,Yeghegnut,Yekhegnut,Yekheknut,Ехекнут,Եղեգնուտ', 40.9030200, 44.6315500, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(775, 'Yeghegnut', 'Yeghegnut', 'Badal,Egegnut,Ekhegnut,Molla Badal,Yeghegnut,Yekheknut,Ехегнут,Եղեգնուտ', 40.0889300, 44.1666900, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(776, 'Ejmiatsin', 'Ejmiatsin', 'Artemed,Avan Vardgesi,Echmiadzin,Echmiatsin,Ecmiadzin,Ejmiatsin,Etchmiadzin,Etjmiadzin,Etschmiadsin,Ečmiadzin,Iejmiatsin,Kaynepolis,Kayrak''aghak'',Kayrak’aghak’,Norak''aghak'',Norak’aghak’,Uch''k''ilisa,Uch’k’ilisa,Uckilise,Vagarsapat,Vagarshapat,Vagharsapat,Vagharshapat,Vagharšapat,Valeroktista,Vardgesavan,Wagharszapat,ehchmiadzin,vagharshapʼatʼi,wagharshapat,Üçkilise,Вагаршапат,Эчмиадзин,Վաղարշապատ,واغارشاپات,ვაღარშაპატი', 40.1655700, 44.2946200, 'AM', '2014-03-15', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(777, 'Yeghvard', 'Yeghvard', 'Eghvard,Egvard,Ehvard,Jeghward,Jegvard,Jegvardas,Jegward,Yeghvard,Yegvard,Yegvart,Yevgard,eghvardi,yghward,yghwrd,Єгвард,Егвард,Եղվարդ,يغوارد,یغوارد,یغورد,ეღვარდი', 40.3250700, 44.4860800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(778, 'Voskevaz', 'Voskevaz', 'Kiziltamur,Oskevaz,Voskevaz,Воскеваз,Ոսկեվազ', 40.2750800, 44.3001100, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(779, 'Voskevan', 'Voskevan', 'Koshkotan,Oskevan,Voskevan,Воскеван,Ոսկեվան', 41.1208100, 45.0638100, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(780, 'Voskehask', 'Voskehask', 'Molla Musa,Musakan,Oskehask,Voskeask,Voskehask,Воскеаск,Ոսկեհասկ', 40.7642600, 43.7747400, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(781, 'Verin Getashen', 'Verin Getashen', 'Nerkin Getashen,Verin Adyaman,Verin Getasen,Verin Getashen,Verkhniy Adyaman,Неркин Геташен,Վերին Գետաշեն', 40.1306800, 45.2529300, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(782, 'Verin Dvin', 'Verin Dvin', 'Aysori Dvin,Verin Dvin,Verkhniy Dvin,Верин Двин,Վերին Դվին', 40.0243400, 44.5903800, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(783, 'Verin Artashat', 'Verin Artashat', 'Ardashar,Artashat,Verin Artasat,Verin Artashat,Verkhniy Artashat,Верин Арташат,Վերին Արտաշատ', 39.9973100, 44.5889300, 'AM', '2016-02-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(784, 'Akht’ala', 'Akht''ala', 'Akht''ala,Akht’ala,Verin Akhtala,Verkhnyaya Akhtala,Ախթալա', 41.1683800, 44.7581100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(785, 'Varser', 'Varser', 'Chirchir,Varser,Варсер,Վարսեր', 40.5554800, 44.9083200, 'AM', '2016-09-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(786, 'Vardenis', 'Vardenis', 'Basargech''ar,Basargech’ar,Basarkeçər,Vardenis,Vardenisas,Wardenis,vardenisi,wa er dai ni si,wardnys,wrdnys,Варденис,Варденіс,Վարդենիս,ורדניס,واردنيس,واردنیس,ვარდენისი,瓦爾代尼斯', 40.1832900, 45.7305300, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(787, 'Vardenik', 'Vardenik', 'Gezeldara,Nerkin Gezaldara,Nizhnyaya Gezaldara,Vardenik,Варденик,Վարդենիկ', 40.1334800, 45.4431100, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(788, 'Vahan', 'Vahan', 'Ordzhonikidze,Vahan,Орджоникидзе,Վահան', 40.5754900, 45.3976900, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(789, 'Vaghashen', 'Vaghashen', 'Avdalagalu,Vagasen,Vagashen,Vaghashen,Vakhashen,Вахашен,Վաղաշեն', 40.1361100, 45.3306900, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(790, 'Vahagni', 'Vahagni', 'Shagali,Vaagni,Vahagni,Ваагни,Վահագնի', 40.9069800, 44.6087300, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(791, 'Ushi', 'Ushi', 'Owsi,Ushi,Ուշի', 40.3472900, 44.3751200, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(792, 'Urrut', 'Urrut', 'Owrut,Urrut,Urut,Урут,Ուռուտ', 41.0677800, 44.3962800, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(793, 'Tsovinar', 'Tsovinar', 'Covinar,Kolakran,Tsovinar,Цовинар,Ծովինար', 40.1595900, 45.4678600, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(794, 'Tsovazard', 'Tsovazard', 'Covazard,Gadzhi Mukhan,Mukhan,Tsovazard,covazard,Цовазард,ծովազարդ', 40.4751000, 45.0501100, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(795, 'Tsovak', 'Tsovak', 'Covak,Nerkin Zagalu,Nizhniy Zagalu,Tsovak,Цовак,Ծովակ', 40.1825400, 45.6328600, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(796, 'Tsovagyugh', 'Tsovagyugh', 'Chabukhly,Chibukhly,Chubukhly,Chubuli,Chubuliki,Covagjukh,Covagyug,Tsovagyugh,Tsovagyukh,Tzovagyugh,Цовагюх,Ծովագյուղ', 40.6334800, 44.9611200, 'AM', '2016-09-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(797, 'Tsaghkunk’', 'Tsaghkunk''', 'Tsaghkunk'',Tsaghkunk’,Tsakhkunk,Verin Aylanlu,Verkhnyaya Aylanlu,Ծաղկունք', 40.1804800, 44.2722800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(798, 'Tsaghkahovit', 'Tsaghkahovit', 'Cagkahovit,Cakhkaovit,Gadzhi-Khalil,Tsaghkahovit,Tsakhkaovit,Tzaghkahovit,Цахкаовит,Ծաղկահովիտ', 40.6342800, 44.2224100, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(799, 'Tsaghkaber', 'Tsaghkaber', 'Avdibek,Cagkaber,Cakhkaber,Tsaghkaber,Tsakhkaber,Tsakhkashen,Tzaghkaber,Цахкабер,Ծաղկաբեր', 40.7984900, 44.1014400, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(800, 'Tsaghkadzor', 'Tsaghkadzor', 'Cachkadzor,Cachkadzoras,Cagkadzor,Cagkajor,Cakhkadzor,Darachichag,Dərəçiçək,Tahkadzor,Tsachkadzor,Tsaghkadzor,Tsakhkadzor,Zaghkadsor,tsaghkadzwr,Țahkadzor,Цагкадзор,Цахкадзор,Ծաղկաձոր,تساغکادزور,წაღკაძორი', 40.5325900, 44.7202500, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(801, 'Tsovasar', 'Tsovasar', 'Covasar,T''azagyugh,Tazagyukh,Tsovasar,T’azagyugh,Ծովասար', 40.1382000, 45.1909600, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(802, 'Tashir', 'Tashir', 'Kaliniko,Kalinin,Kalinino,Tashir,Tasir,Vorontsovka,Ташир,Տաշիր', 41.1207200, 44.2846200, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(803, 'Tandzut', 'Tandzut', 'Armutlu,Tandzut,Tanjut,Тандзут,Տանձուտ', 40.0695200, 44.0778800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(804, 'T’alin', 'T''alin', 'T''alin,Talin,T’alin,Verin Talin,Verkhniy Talin,Талин,Թալին', 40.3917200, 43.8779300, 'AM', '2017-02-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(805, 'Step’anavan', 'Step''anavan', 'Dzhalalogly,Dzhelaloglu,Step''anavan,Stepahavan,Stepanavan,Stepanawan-Lori,Step’anavan,Степанаван,Ստեփանավան', 41.0099500, 44.3853100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(806, 'Spitak', 'Spitak', 'Amamlu,Amamth,Spitak,Спитак,Սպիտակ', 40.8322100, 44.2673100, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(807, 'Spandaryan', 'Spandaryan', 'Kulidzhan,Spandarjan,Spandaryan,Спандарян,Սպանդարյան', 40.6610500, 44.0155100, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(808, 'Alashkert', 'Alashkert', 'Alashkert,Alaskert,Kyarimarkh,Sovetakan,Советакан,Ալաշկերտ', 40.1071200, 44.0510800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(809, 'Solak', 'Solak', 'Solak,Солак,Սոլակ', 40.4625200, 44.7070900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(810, 'Sis', 'Sis', 'Sarvanlar,Sis,Uliya Sarvanlar,Сис,Սիս', 40.0582900, 44.3889200, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(811, 'Shnogh', 'Shnogh', 'Shnogh,Shnokh,Snog,Шнох,Շնող', 41.1469300, 44.8404300, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(812, 'Shirak', 'Shirak', 'Konakhkran,Kunakhkran,Shirak,Sirak,Ширак,Շիրակ', 40.8404200, 43.9158200, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(813, 'Shenavan', 'Shenavan', 'Blkher,Senavan,Shenavan,Шенаван,Շենավան', 40.4832800, 44.3834800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(814, 'Shenavan', 'Shenavan', 'Kyalagarkh,Senavan,Shenavan,Шенаван,Շենավան', 40.0554800, 43.9304800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(815, 'Sevan', 'Sevan', 'Sevan,Sevanas,Sewan,Ssewan,Yelenovka,sai fan,sevani,swan,Севан,Սևան,سوان,სევანი,塞凡', 40.5473000, 44.9417100, 'AM', '2016-09-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(816, 'Sarukhan', 'Sarukhan', 'Dalikardash,Sarukhan,Saruxan,Сарухан,Սարուխան', 40.2916900, 45.1306800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(817, 'Sarigyugh', 'Sarigyugh', 'Sariguh,Sarigyug,Sarigyugh,Sarigyukh,Sarıgüh,Srigekh,Srygekh,Սարիգյուղ', 41.0353100, 45.1448600, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(818, 'Saratak', 'Saratak', 'Imrkhan,Saratak,Саратак,Սարատակ', 40.6709000, 43.8723100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(819, 'Saramej', 'Saramej', 'Chotur,Saramech,Saramej,Сарамеч,Սարամեջ', 40.7748700, 44.2222000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(820, 'Sarahart’', 'Sarahart''', 'Gyullidzha,Saraart,Sarahart'',Sarahart’,Սարահարթ', 40.8704300, 44.2140700, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(821, 'Geghakert', 'Geghakert', 'Gegakert,Geghakert,Gekhakert,Samagar,Samaghar,Samakhar,Самахар,Գեղակերտ', 40.1851600, 44.2433100, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(822, 'Ptghni', 'Ptghni', 'Ptghni,Ptgni,Ptkhni,Ptykhni,Птхни,Պտղնի', 40.2556800, 44.5861200, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(823, 'Ptghunk’', 'Ptghunk''', 'Ptghunk'',Ptghunk’,Ptkhunk,Պտղունք', 40.1638800, 44.3638900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(824, 'P’shatavan', 'P''shatavan', 'Igdalu,P''shatavan,Pshatavan,P’shatavan,Пшатаван,Փշատավան', 40.0388800, 44.0667100, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(825, 'Prroshyan', 'Prroshyan', 'Proshian,Proshyan,Prosyan,Prroshyan,Պռոշյան', 40.2473100, 44.4194900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(826, 'P’ok’r Mant’ash', 'P''ok''r Mant''ash', 'Malyy Mantash,P''ok''r Mant''ash,Pokr Arkhvali,Pokr Mantash,P’ok’r Mant’ash,Покр Манташ,Փոքր Մանթաշ', 40.6402600, 44.0466600, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(827, 'Zoravan', 'Zoravan', 'Kargavank,Pokravan,Zoravan,Зораван,Զորավան', 40.3555300, 44.5222800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(828, 'Pemzashen', 'Pemzashen', 'Magmudzhuk,Mahmutcuk,Makhmudzhug,Pemzasen,Pemzashen,Пемзашен,Պեմզաշեն', 40.5861200, 43.9431100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(829, 'Parravak’ar', 'Parravak''ar', 'Paravakar,Paravaker,Parravak''ar,Parravak’ar,Паравакар,Պառավաքար', 40.9824800, 45.3669600, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(830, 'Oshakan', 'Oshakan', 'Ochakan,Osakan,Oschakan,Oshakan,Osjakan,Oszakan,Oŝakan,Oşakan,awshakan,Ошакан,Օշական,أوشاكان,اوشاکان,ოშაკანი', 40.2639200, 44.3167100, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(831, 'Sardarapat', 'Sardarapat', 'Hoktember,Oktember,Oktemberjan,Sardarapat,Октемберян,Սարդարապատ', 40.1320600, 44.0096900, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(832, 'Odzun', 'Odzun', 'Dzun,Odzun,Ojun,Usuklyar,Uzunlar,Одзун,Օձուն', 41.0532100, 44.6134100, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(833, 'Noyemberyan', 'Noyemberyan', 'Baran,Barana,Noemberjan,Noiemberian,Nojemberianas,Nojemberjan,Noyemberian,Noyemberyan,noemberiani,nwymbryan,Ноемберян,Նոյեմբերյան,نويمبريان,نویمبریان,ნოემბერიანი', 41.1724400, 44.9991700, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(834, 'Nor Gyugh', 'Nor Gyugh', 'Nor Gyug,Nor Gyugh,Nor Gyukh,Tazagyukh,Նոր Գյուղ', 40.2667200, 44.6583200, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(835, 'Nor Geghi', 'Nor Geghi', 'Bazmavan,Chatkran,Nor Geghi,Nor Gegi,Nor Gekhi,Нор Гехи,Նոր Գեղի', 40.3223300, 44.5833100, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(836, 'Norashen', 'Norashen', 'Bogdanovka,Norasen,Norashen,Норашен,Նորաշեն', 41.1888600, 44.3333600, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(837, 'Norashen', 'Norashen', 'Norasen,Norashen,Verin Kurdkend,Норашен,Նորաշեն', 40.0013000, 44.5929600, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(838, 'Nor Armavir', 'Nor Armavir', 'Nor Armavir,Նոր Արմավիր', 40.0861200, 43.9945100, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(839, 'Noramarg', 'Noramarg', 'Abilkend,Ablkend,Bulagli,Bulakhly,Imeni Kalinina,Kalinin,Noramarg,Poselok Imeni Kalinina,Posëlok Imeni Kalinina,Норамарг,Նորամարգ', 40.0222800, 44.4251100, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(840, 'Norakert', 'Norakert', 'Norakert,Նորակերտ', 40.1973300, 44.3501000, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(841, 'Noratus', 'Noratus', 'Noraduz,Noratus,Норадуз,Նորատուս', 40.3779300, 45.1804800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(842, 'Nerk’in Getashen', 'Nerk''in Getashen', 'Nerk''in Getashen,Nerkin Adyaman,Nerk’in Getashen,Nizhniy Adyaman,Ներքին Գետաշեն', 40.1417200, 45.2708700, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(843, 'Navur', 'Navur', 'Navur,Навур,Նավուր', 40.8669500, 45.3417900, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(844, 'Nalbandyan', 'Nalbandyan', 'Mets Shagriar,Nalbandjan,Nalbandyan,Shagriar,Shagriar Bol''shoy,Shagriar Bol’shoy,Налбандян,Նալբանդյան', 40.0639000, 43.9888900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(845, 'Basen', 'Basen', 'Basen,Mets Kyapanak,Musaeljan,Musayelyan,Мусаелян,Բասեն', 40.7576700, 43.9927400, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(846, 'Hovtamej', 'Hovtamej', 'Hovtamej,Mugan,Ovtamech,Հովտամեջ', 40.1832900, 44.2584800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(847, 'Mrgashen', 'Mrgashen', 'Mrgasen,Mrgashen,Մրգաշեն', 40.2860700, 44.5444900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(848, 'Mrgashat', 'Mrgashat', 'Gecherlau,Gechrlu,Mrgasat,Mrgashat,Мргашат,Մրգաշատ', 40.1306800, 44.0806900, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(849, 'Mrganush', 'Mrganush', 'Mrganush,Zograblu,Мргануш', 40.0285700, 44.5583100, 'AM', '2012-01-17', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(850, 'Mosesgegh', 'Mosesgegh', 'Mosesgeg,Mosesgegh,Mosesgekh,Mosesgex,Movses,Мосесгех,Մոսեսգեղ', 40.9053400, 45.4883800, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(851, 'Mets Parni', 'Mets Parni', 'Bekyand,Mec Parni,Mec-Parni,Mets Parni,Parni,Мец-Парни,Մեծ Պարնի', 40.8347200, 44.1110800, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(852, 'Mets Masrik', 'Mets Masrik', 'Bol''shaya Mazra,Bol’shaya Mazra,Mazra,Mec Masrik,Mec Mazra,Mets Masrik,Mets-Mazra,Мец Мазра,Մեծ Մասրիկ', 40.2194800, 45.7639100, 'AM', '2015-11-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(853, 'Mets Mant’ash', 'Mets Mant''ash', 'Bol''shoy Mantash,Bol’shoy Mantash,Mantash,Mec-Mantash,Mets Arikhvali,Mets Mant''ash,Mets Mant’ash,Metz Mantash,Мец-Манташ,Մեծ Մանթաշ', 40.6437600, 44.0565300, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(854, 'Metsavan', 'Metsavan', 'Mecavan,Metsavan,Shakhnazar,Мецаван,Մեծավան', 41.2015600, 44.2287700, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(855, 'Metsamor', 'Metsamor', 'Kamarlu,Mecamor,Metsamor,Мецамор,Մեծամոր', 40.0723300, 44.2916900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(856, 'Merdzavan', 'Merdzavan', 'Merdzavan,Merjavan,Mertsavan,Мердзаван,Մերձավան', 40.1814000, 44.4003300, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1025, 'Saurimo', 'Saurimo', 'Henrique de Carvalho,Saurimo,Saurimu,VHC,Vila Henrique de Carvalho,Сауримо', -9.6607800, 20.3915500, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1026, 'Lucapa', 'Lucapa', 'LBZ,Lucapa,Lukapa,Лукапа', -8.4191500, 20.7446600, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1027, 'Lumeje', 'Lumeje', 'Cameia,Lumege,Lumeje,Lumeji,Lumezhe,Лумеже', -11.5500000, 20.7833300, 'AO', '2015-08-30', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1028, 'Luau', 'Luau', 'Luao,Luau,Teixeira de Sousa,Teixera de Sousa,Texeira-de Susa,UAL,Vila Teixeira de Sousa,Vila Teixeira de Souza,Vila Teixera de Souza,Vila Texeira de Sousa,Луау', -10.7072700, 22.2246600, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1029, 'Léua', 'Leua', 'Leua,Léua,Sandando', -11.6500000, 20.4500000, 'AO', '2013-06-04', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1030, 'Cazaji', 'Cazaji', 'Cazage,Cazaje,Cazaji,Kazagi', -11.0671500, 20.7014800, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1031, 'Uíge', 'Uige', 'Carmona,UGO,Uige,Uije,Uizhe,Uíge,Vila Marchel Carmona,Уиже', -7.6087400, 15.0613100, 'AO', '2017-05-07', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1032, 'Soio', 'Soio', 'SZA,Saint Antonio do Zaire,San Antonio,Santo Antoni,Santo Antonio do Zaire,Santo António do Zaire,Santo-Antonio,Santo-António,Sao Antonio,Sazaire,Soio,Soju,Soyo,São Antônio,Сойу', -6.1349000, 12.3689400, 'AO', '2017-05-07', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1033, 'N''zeto', 'N''zeto', 'ARZ,Ambrisette,Ambrizete,Ambrizette,Nzeto,Нзето', -7.2311600, 12.8666000, 'AO', '2017-07-07', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1034, 'N’dalatando', 'N''dalatando', 'Dalatando,N''dalatando,NDF,Ndalatanda,N’dalatando,Salazar,Vila Salazar,Villa Salazar', -9.2978200, 14.9116200, 'AO', '2017-05-07', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1035, 'Mbanza Congo', 'Mbanza Congo', 'Mbanza Congo,Mbanza Kongo,San Salvador,Sao Salvador,Sao Salvador do Congo,São Salvador,São Salvador do Congo', -6.2670300, 14.2401000, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1036, 'Malanje', 'Malanje', 'MEG,Malandje,Malange,Malanje,Malanzhe,Маланже', -9.5401500, 16.3409600, 'AO', '2014-06-23', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1037, 'Luanda', 'Luanda', 'Gorad Luanda,LAD,Loanda,Louanda,Louanta,Luand,Luanda,Luandae,Luando,Lwanda,Lúanda,Saint Paul de Loanda,Sao Paolo de Loanda,Sao Paulo da Assuncao de Luanda,Sao Paulo de Loanda,Sao Paulo de Luanda,St Paul de Loanda,São Paolo de Loanda,São Paulo da Assunção de Luanda,São Paulo de Loanda,São Paulo de Luanda,lu''anda,luanda,luo an da,luvanta,luxanda,luyanda,lwanda,ruanda,Λουάντα,Горад Луанда,Луандæ,Луанда,Լուանդա,לואנדה,לואנדע,لوآندا,لواندا,لونڈا,लुआंडा,लुआण्डा,লুয়ান্ডা,ਲੁਆਂਦਾ,லுவாண்டா,ลูอันดา,ལའུན་ཌ།,ლუანდა,ሏንዳ,ルアンダ,罗安达,루안다', -8.8368200, 13.2343200, 'AO', '2014-10-08', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1038, 'Caxito', 'Caxito', 'Caxito,Kashito,Kaxito,Кашито', -8.5784800, 13.6642500, 'AO', '2011-10-28', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1039, 'Camabatela', 'Camabatela', 'Ambaca,Camabatela,Kamabatela,Камабатела', -8.1881200, 15.3749500, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1040, 'Cabinda', 'Cabinda', 'CAB,Cabinda,Kabinda,Кабинда', -5.5500000, 12.2000000, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1041, 'Uacu Cungo', 'Uacu Cungo', 'CEO,Santa Comba,Santa Comba Dao,Santa Comba Dão,Uacu Cungo,Vaku Kungu,Vila de Santa Comba Dao,Vila de Santa Comba Dão,Waco-Kungo,Waku-Kungo,Ваку Кунгу', -11.3566900, 15.1171900, 'AO', '2015-04-24', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1042, 'Sumbe', 'Sumbe', 'Angungescapolo,NDD,Ngunza,Nova Redonda,Nova Redondo,Novo Redondo,Sumbe,Sumbė,sun bei,sunbe,swmbh  angwla,Сумбе,سومبه، آنگولا,سومبے,スンベ,孫貝', -11.2060500, 13.8437100, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1043, 'Quibala', 'Quibala', 'Kibala,Quibala,Кибала', -10.7336600, 14.9799500, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1044, 'Ondjiva', 'Ondjiva', 'N''Giva,N''Jiva,N’Giva,N’Jiva,Ondjiva,Ondyiva,Ondzhiva,Ondziva,Ondživa,Ongiva,Onjiva,Pereira d''Eca,Pereira de Eca,Pereira d’Eca,VPE,Vila Pereira d''Eca,Vila Pereira de Eca,Vila Pereira de Eco,Vila Pereira de Eça,Vila Pereira d’Eça,andjywa,andzhywa  angwla,weng ji wa,Онджива,اندجیوا,اندژیوا، آنگولا,翁吉瓦', -17.0666700, 15.7333300, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1045, 'Namibe', 'Namibe', 'MSZ,Mocamedes,Mossamedes,Moçâmedes,Namibe,Namibė,na mi bei,namibe,namibeu,namybh  angwla,Намибе,Намібе,نامیبه، آنگولا,نامیبے,ナミベ,納米貝,나미브', -15.1961100, 12.1522200, 'AO', '2014-03-05', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1046, 'Menongue', 'Menongue', 'Menonge,Menongve,Menongė,SPP,Serpa Pinto,Vila Serpa Pinto,mei nong gai,menong-geu,menongue,mnngw  angwla,mnwngh,mynwngw,Менонгве,Менонге,מנונגה,مننگو، آنگولا,مینونگو,ሜኖንጉዌ,メノングエ,梅農蓋,메농그', -14.6585000, 17.6909900, 'AO', '2014-06-23', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1047, 'Luena', 'Luena', 'LUO,Luehna,Luena,Luene,Luso,Luzo,Vila Luso,Vila Luzo,Vila Luzu,Villa Luso,lu ai na,luena,lwna  angwla,Луена,Луэна,לואנה,لوئنا، موشیکو صوبہ,لونا، آنگولا,盧埃納,루에나', -11.7833300, 19.9166700, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1048, 'Lubango', 'Lubango', 'Lubangas,Lubango,SDD,Sa da Bandeira,Sá da Bandeira,lu ban ge,lubang-gu,lwbanghw,lwbngw  angwla,rubango,Лубанго,لوبانغو,لوبنگو، آنگولا,ルバンゴ,盧班戈,루방구', -14.9171700, 13.4925000, 'AO', '2014-06-23', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1049, 'Longonjo', 'Longonjo', 'Congonjo,Logonzhu,Longonjo,Логонжу', -12.9066700, 15.2533300, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1050, 'Lobito', 'Lobito', 'LLT,Lobitas,Lobito,Lobitu,Lubitu,lbytw  angwla,lobitu,luo bi tuo,robito,Лобито,Лобиту,Лобіту,لبیتو، آنگولا,ロビト,洛比托,로비투', -12.3644000, 13.5360100, 'AO', '2013-06-09', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1051, 'Cuito', 'Cuito', 'Bie,Bihe,Bihé,Bié,Cuito,Kuito,SVP,Silva Porto,Vila Salva Porto,Куито', -12.3833300, 16.9333300, 'AO', '2013-06-04', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1052, 'Huambo', 'Huambo', 'Huambas,Huambo,Huamdo,Khuambo,NOV,Nova Lisboa,Uambo,hu''ambo,hwambw  angwla,uambu,uanbo,wambu,wan bo,Вилояти Ҳвамбо,Уамбо,Хуамбо,הואמבו,هوامبو، آنگولا,ہوامبو,ਹੁਆਂਬੋ,วัมบู,ウアンボ,万博,우암부', -12.7761100, 15.7391700, 'AO', '2013-06-04', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1053, 'Chissamba', 'Chissamba', 'Chissamba', -12.1666700, 17.3333300, 'AO', '2014-04-06', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1054, 'Catumbela', 'Catumbela', 'Asseiceira,CBT,Catumbela,Catumbella,Katumbela,Катумбела', -12.4300200, 13.5467700, 'AO', '2013-11-08', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1055, 'Catabola', 'Catabola', 'Catabola,Katabola,Катабола', -12.1500000, 17.2833300, 'AO', '2013-06-04', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1056, 'Camacupa', 'Camacupa', 'Camacupa,General Machado,General Machado Villa,General Mathado,Kamakupa,Machado,Vila General Machado,Камакупа', -12.0166700, 17.4833300, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1057, 'Caluquembe', 'Caluquembe', 'Caluquembe,Caluquembo,Caluquemo,Kalukembe,Калукембе', -13.7833300, 14.6833300, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1058, 'Caconda', 'Caconda', 'Caconda,Kakonda,Каконда', -13.7333300, 15.0666700, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1059, 'Caála', 'Caala', 'Caala,Cahala,Caála,Kaala,Kaale,Robert Williams,Roberto Williams,Vila Robert Williams,Каале', -12.8525000, 15.5605600, 'AO', '2012-01-17', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1060, 'Benguela', 'Benguela', 'BUG,Bengela,Benguela,Benguella,Sao Felipe de Benguela,São Félipe de Benguela,ben ji la,Бенгела,本吉拉', -12.5762600, 13.4054700, 'AO', '2011-10-28', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1061, 'Chela', 'Chela', '', -12.3026100, 15.4335800, 'AO', '2014-08-15', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1062, 'Chinjenje', 'Chinjenje', '', -12.9324400, 14.9923800, 'AO', '2014-08-16', 7);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1063, 'McMurdo Station', 'McMurdo Station', 'Base McMurdo,Base antarctique McMurdo,Estacao McMurdo,Estacio McMurdo,Estació McMurdo,Estação McMurdo,Mak-Merdo,Makmerdo,McMurdo,McMurdo Statschoon,McMurdo basea,McMurdo-Station,McMurdo-stasjonen,Polarni stanice McMurdo,Polusa stacio McMurdo,Polární stanice McMurdo,Station McMurdo,Stazione McMurdo,maegmeodo giji,mai ke mo duo zhan,makumado ji de,thnt mq-mrdw,Мак-Мердо,Макмөрдо,תחנת מק-מרדו,قاعدة ماك موردو,マクマード基地,麥克默多站,맥머도 기지', -77.8460000, 166.6760000, 'AQ', '2012-07-11', 9);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1064, 'Zárate', 'Zarate', 'General J.F. Uriburu,General Jose F. Uriburu,General José F. Uriburu,General Uriburu,Sarate,Saratė,Zarate,Zárate,sa la te,srath,zaraty  bwyns ayrs,Зарате,زاراتي، بوينس آيرس,سراته,სარატე,萨拉特', -34.0981400, -59.0285800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1065, 'Yataity Calle', 'Yataity Calle', 'Yataity Calle,Yatayti Calle,Yataytí Calle', -29.0191300, -58.9084600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1066, 'Yapeyú', 'Yapeyu', 'San Martin,Yapeyu,Yapeyú', -29.4691400, -56.8184100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1067, 'Villa Paranacito', 'Villa Paranacito', 'Paranacito,Villa Paranacito', -33.7220700, -58.6579800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1068, 'Villa Ortúzar', 'Villa Ortuzar', 'Villa Ortuzar,Villa Ortúzar', -34.5797300, -58.4682900, 'AR', '2017-05-08', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1069, 'Villa Ocampo', 'Villa Ocampo', 'Ocampo,Villa Ocampo', -28.4875200, -59.3551500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1070, 'Villa María Grande', 'Villa Maria Grande', 'Maria Grande,María Grande,Villa Maria Grande,Villa María Grande', -31.6656500, -59.9018200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1071, 'Villa Mantero', 'Villa Mantero', 'Mantero,Villa Mantero', -32.3972700, -58.7459600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1072, 'Villa Lugano', 'Villa Lugano', 'Vilja Luganas,Villa Lugano,ビジャ・ルガーノ', -34.6790700, -58.4726300, 'AR', '2017-05-08', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1073, 'Villa Hernandarias', 'Villa Hernandarias', 'Hernandarias,Villa Hernandarias', -31.2310100, -59.9850000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1074, 'Villaguay', 'Villaguay', 'Villaguay', -31.8653000, -59.0268900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1075, 'Villa Gesell', 'Villa Gesell', 'VLG,Vil''ja-Khesel'',Вилья-Хесель', -37.2639400, -56.9730400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1076, 'Villa Escolar', 'Villa Escolar', 'Villa Escobar Navegacion Rio Bermejo,Villa Escobar Navegación Río Bermejo,Villa Escolar', -26.6220900, -58.6713400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1077, 'Villa Elisa', 'Villa Elisa', 'Villa Elisa', -32.1632000, -58.4008200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1078, 'Villa del Rosario', 'Villa del Rosario', 'Villa Rosario,Villa del Rosario', -30.7956700, -57.9125700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1079, 'Verónica', 'Veronica', 'Veronica,Verónica', -35.3879600, -57.3369100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1080, 'Veinticinco de Mayo', 'Veinticinco de Mayo', '25 de Mayo,Veinticinco de Mayo', -27.3767900, -54.7431200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1081, 'Urdinarrain', 'Urdinarrain', 'Urdinarrain', -32.6857300, -58.8932300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1082, 'Ubajay', 'Ubajay', 'Ubajay', -31.7935800, -58.3135000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1083, 'Tres Capones', 'Tres Capones', 'Tres Capones', -28.0064100, -55.6047100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1084, 'Tigre', 'Tigre', 'Las Conchas,Tigre,Тигре', -34.4260300, -58.5796200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1085, 'Tandil', 'Tandil', 'TDL,Tandil,Tandil'',Tandilis,tan di er,tandil,tandiru,tandyl,tndyl,Тандил,Тандиль,טנדיל,تانديل,تاندیل,ტანდილი,タンディル,坦迪爾,탄딜', -37.3216700, -59.1331600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1086, 'Tacuarendí', 'Tacuarendi', '', -28.4126500, -59.2600000, 'AR', '2016-03-20', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1087, 'Tabossi', 'Tabossi', 'Tabossi,Tobosy', -31.8013500, -59.9347700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1088, 'Suipacha', 'Suipacha', 'Suipacha', -34.7702000, -59.6878300, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1089, 'Sauce de Luna', 'Sauce de Luna', 'Sauce de Luna', -31.2379400, -59.2187200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1090, 'Sauce', 'Sauce', 'Sauce', -30.0867100, -58.7877700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1091, 'San Vicente', 'San Vicente', 'San Vicente', -35.0250000, -58.4227600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1092, 'San Vicente', 'San Vicente', '', -26.6166700, -54.1333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1093, 'Santo Tomé', 'Santo Tome', 'Santo Tome,Santo Tomé', -28.5493900, -56.0407700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1094, 'Santo Pipó', 'Santo Pipo', 'Colonia Santo Pipo,Colonia Santo Pipó,San Pipo,Santo Pipo,Santo Pipó', -27.1413200, -55.4086700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1095, 'Santa Rosa', 'Santa Rosa', 'Colonia Santa Rosa,Colonia Tabay,Santa Rosa,Santa-Rosa,Санта-Роса', -28.2631800, -58.1189100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1096, 'Santa María', 'Santa Maria', 'Colonia Santa Maria,Colonia Santa María,Hubbart,Santa Maria,Santa María', -27.9035700, -55.3854100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1097, 'Santa Lucía', 'Santa Lucia', 'Santa Lucia,Santa Lucía', -28.9874600, -59.1028700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1098, 'Santa Elena', 'Santa Elena', 'Santa Elena', -30.9476800, -59.7869600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1099, 'Santa Anita', 'Santa Anita', 'Aldea Santa Anita,Santa Anita', -32.1747600, -58.7862200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1100, 'Santa Ana', 'Santa Ana', 'Santa Ana', -30.9000400, -57.9316200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1101, 'Santa Ana', 'Santa Ana', 'Sant'' Ana,Santa Ana,Sant’ Ana', -27.3674000, -55.5809100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1102, 'San Salvador', 'San Salvador', 'San Salvador,sheng sa er wa duo,聖薩爾瓦多', -31.6248700, -58.5052400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1103, 'San Roque', 'San Roque', 'San Roque', -28.5745700, -58.7081700, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1104, 'San Pedro', 'San Pedro', 'San Pedro', -33.6791300, -59.6666300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1105, 'San Pedro', 'San Pedro', 'San Pedro', -26.6220700, -54.1084200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1106, 'San Miguel del Monte', 'San Miguel del Monte', 'San M. del Monte,San Miguel de Monte,San Miguel del Monte', -35.4396200, -58.8067500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1107, 'San Miguel', 'San Miguel', 'San Miguel', -27.9958500, -57.5896400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1108, 'San Luis del Palmar', 'San Luis del Palmar', 'San Luis del Palmar', -27.5079000, -58.5545400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1109, 'San Lorenzo', 'San Lorenzo', '', -28.1330600, -58.7673300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1110, 'San Justo', 'San Justo', 'San Justo', -34.6766000, -58.5605800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1111, 'San Justo', 'San Justo', 'San Justo,Villa San Justo', -32.4465400, -58.4356900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1112, 'San José de Feliciano', 'San Jose de Feliciano', 'San Jose de Feliciano,San José de Feliciano', -30.3845200, -58.7516700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1113, 'San José', 'San Jose', 'San Jose,San José', -27.7697900, -55.7826000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1114, 'San Javier', 'San Javier', 'San Javier', -30.5778100, -59.9317000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1115, 'San Javier', 'San Javier', 'San Javier', -27.8742700, -55.1350900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1116, 'San Isidro', 'San Isidro', 'San Isidro,san aysydrw,sheng yi xi de luo,Сан Исидро,سان إيسيدرو,سان ایسیدرو,圣伊西德罗', -34.4721000, -58.5270800, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1117, 'San Ignacio', 'San Ignacio', 'San Ignacio', -27.2558600, -55.5339000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1118, 'San Gustavo', 'San Gustavo', '', -30.6896100, -59.3984000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1119, 'San Francisco de Laishí', 'San Francisco de Laishi', 'La Mision,La Mision San Francisco de Laishi,La Misión,La Misión San Francisco de Laishi,Mision San Francisco de Laishi,Misión San Francisco de Laishi,San Francisco de Laishi,San Francisco de Laishí', -26.2426200, -58.6303900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1120, 'San Cosme', 'San Cosme', '', -27.3712300, -58.5121400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1121, 'San Clemente del Tuyú', 'San Clemente del Tuyu', 'Balneario San Clemente,Balneario San Clemente del Tuyu,Balneario San Clemente del Tuyú,San Clemente del Tuyu,San Clemente del Tuyú,San-Klemente-del''-Tuju,Сан-Клементе-дель-Тую', -36.3569400, -56.7235100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1122, 'San Cayetano', 'San Cayetano', 'San Cayetano', -38.3465300, -59.6095400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1123, 'San Carlos', 'San Carlos', '', -27.7458600, -55.8973100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1124, 'San Antonio de Areco', 'San Antonio de Areco', 'San A. de Areco,San Antonio de Areco', -34.2503000, -59.4716300, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1125, 'San Andrés de Giles', 'San Andres de Giles', 'San A. de Giles,San Andres de Giles,San Andrés de Giles', -34.4472100, -59.4445100, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1126, 'Saladillo', 'Saladillo', 'Saladillo', -35.6370800, -59.7778800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1127, 'Saladas', 'Saladas', 'Saladas', -28.2538400, -58.6259100, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1128, 'Ruiz de Montoya', 'Ruiz de Montoya', 'Ruiz de Montoya', -26.9833300, -55.0500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1129, 'Rosario del Tala', 'Rosario del Tala', 'Rosario Tala,Rosario de Tala,Rosario del Tala,Tala,luo sa li ao de er ta la,羅薩里奧德爾塔拉', -32.3028600, -59.1454500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1130, 'Roque Pérez', 'Roque Perez', 'R. Perez,R. Pérez,Roque Perez,Roque Pérez', -35.3979400, -59.3327100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1131, 'Riachuelo', 'Riachuelo', '', -27.5775400, -58.7394500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1132, 'Riacho Eh-Eh', 'Riacho Eh-Eh', 'Riacho Eh-Eh,Riacho He He', -25.3620900, -58.2775000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1133, 'Retiro', 'Retiro', 'Retiras,Retiro,lei di luo,retiro,Ретиро,Ретіро,レティーロ,雷蒂罗', -34.5833300, -58.3833300, 'AR', '2017-05-08', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1134, 'Resistencia', 'Resistencia', 'Ciudad de Resistencia,RES,Resistancia,Resistencia,Resistenseje,Resistensia,Resistensija,Resistensėjė,Resistentia,Resistência,lei xi si teng xi ya,lesiseutensia,re si s ten seiy,reshisutenshia,rsystnsyh,rysystyna,rysystynsya,rzystnsya,rzystnsya  chakw,Ресистенсия,Ресистенсија,Ресістенсія,Ռեսիստենսիա,רסיסטנסיה,رزیستنسیا,رزیستنسیا، چاکو,ريسيستينسيا,ریسیستینا,เรซิสเตนเซีย,რესისტენსია,レシステンシア,雷西斯滕西亚,레시스텐시아', -27.4605600, -58.9838900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1135, 'Reconquista', 'Reconquista', 'RCQ,Reconquista,Rekonkista,Реконкиста', -29.1500000, -59.6500000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1136, 'Rauch', 'Rauch', 'Rauch', -36.7745000, -59.0897300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1137, 'Ranchos', 'Ranchos', 'General Paz,Ranchos', -35.5161900, -58.3173300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1138, 'Quilmes', 'Quilmes', 'Kil''mes,Kilmes,Kilmesas,Quilmes,ji er mei si,kilmeseu,kirumesu,kwylms,kylms,qylms,Килмес,Кильмес,Кільмес,Կիլմես,קילמס,كويلمس,کیلمس,კილმესი,キルメス,基尔梅斯,킬메스', -34.7290400, -58.2637400, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1139, 'Puerto Yeruá', 'Puerto Yerua', 'Puerto Yerua,Puerto Yeruá,Punta Yerua', -31.5371300, -58.0152700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1140, 'Puerto Vilelas', 'Puerto Vilelas', 'Puerto Vilelas', -27.5141400, -58.9390600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1141, 'Puerto Tirol', 'Puerto Tirol', 'Puerto Tirol', -27.3721800, -59.0820600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1142, 'Puerto Rico', 'Puerto Rico', 'Libertador General San Martin,Libertador General San Martín,Puerto Libertador General San Martin,Puerto Libertador General San Martín,Puerto Rico,Puerto San Alberto', -26.7959800, -55.0240200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1143, 'Puerto Piray', 'Puerto Piray', 'Puerto Piray', -26.4677900, -54.7147600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1144, 'Puerto Libertad', 'Puerto Libertad', 'Puerto Libertad', -25.9164100, -54.6208900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1145, 'Puerto Leoni', 'Puerto Leoni', 'Leoni,Puerto Leoni', -26.9606900, -55.1657000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1146, 'Puerto Iguazú', 'Puerto Iguazu', 'Eva Peron,Eva Perón,IGR,Iguassu,Iguazu,Iguazú,Puehrto-Iguasu,Puerto Aguirre,Puerto Iguasu,Puerto Iguazu,Puerto Iguazú,Puerto Igvasu,Puerto-Iguasu,bwyrtw jwasyw,pueleutoigwasu,pwrtw ywasw,yi gua su gang,Пуерто-Іґуасу,Пуэрто-Игуасу,Պուերտո Իգուասու,פוארטו איגואסו,بويرتو جواسيو,پورتو یواسو,پوێرتۆ ئیگواسوو,プエルト・イグアス,伊瓜蘇港,푸에르토이과수', -25.5991200, -54.5735500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1147, 'Puerto Ibicuy', 'Puerto Ibicuy', 'Puerto Ibicuy,Punta Ibicuy', -33.7333300, -59.1833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1148, 'Puerto Esperanza', 'Puerto Esperanza', 'Esperanza,Puerto Esperanza', -26.0151700, -54.6730600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1149, 'Puerto Eldorado', 'Puerto Eldorado', 'Eldorado,Puerto Eldorado', -26.4084300, -54.6946300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1150, 'Puerto Bermejo', 'Puerto Bermejo', 'Bermejo,Puerto Bermejo', -26.9317300, -58.5053800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1151, 'Pueblo Libertador', 'Pueblo Libertador', 'Colonia Bahia de Astrada,Colonia Bahía de Astrada,Colonia Beron de Astrada,Colonia Berón de Astrada,Pueblo Libertador', -30.2208700, -59.3898100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1152, 'Pronunciamiento', 'Pronunciamiento', 'Pronunciamiento', -32.3461700, -58.4328700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1153, 'Presidencia Roca', 'Presidencia Roca', 'Presidencia Roca,Presidente Roca', -26.1409000, -59.5954100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1154, 'Presidencia de la Plaza', 'Presidencia de la Plaza', 'Presidencia de la Plaza,Presidente de la Plaza,Puerto de la Plaza', -27.0014700, -59.8424300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1155, 'Posadas', 'Posadas', 'PSS,Posadas,Posadasa,Posadasas,bo sa da si,bwsadas  mysywnys,pasadas  mysywns,posadaseu,posadasu,pwsadas,Посадас,Պոսադաս,פוסאדאס,بوساداس، ميسيونيس,پاساداس، میسیونس,پوساداس,პოსადასი,ポサーダス,波萨达斯,포사다스', -27.3670800, -55.8960800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1156, 'Pontevedra', 'Pontevedra', 'Pontevedra,bwntyfydra,peng te wei de la,بونتيفيدرا,پونته‌ودرا,蓬特韋德拉', -34.7478500, -58.7007200, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1157, 'Pirané', 'Pirane', 'Pirane,Pirané', -25.7323900, -59.1087900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1158, 'Pinamar', 'Pinamar', 'Balneario Pinamar,Pinamar,QPQ', -37.1079500, -56.8614000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1159, 'Pilar', 'Pilar', 'Pilar', -34.4586600, -58.9142000, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1160, 'Pila', 'Pila', 'Pila', -36.0005800, -58.1439100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1161, 'Piedras Blancas', 'Piedras Blancas', '', -31.1862300, -59.9595700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1162, 'Picada Gobernador López', 'Picada Gobernador Lopez', 'Gobernador Lopez,Gobernador López,Picada Gobernador Lopez,Picada Gobernador López,Picada Lopez,Picada López', -27.6706900, -55.2458500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1163, 'Perugorría', 'Perugorria', 'Perrugorria,Perrugorría,Perugorria,Perugorría,Perugurria', -29.3413200, -58.6105900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1164, 'Pedro R. Fernández', 'Pedro R. Fernandez', 'Manuel F. Mantilla,Morro Furo Mantilla,Pedro R. Fernandez,Pedro R. Fernández,San Diego', -28.7509700, -58.6558300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1165, 'Paso de los Libres', 'Paso de los Libres', 'AOL,Paso de los Libres', -29.7125100, -57.0877100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1166, 'Paso de la Patria', 'Paso de la Patria', '', -27.3167600, -58.5719700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1167, 'Panambí', 'Panambi', 'Panambi,Panambí,Puerto Panambi', -27.7236900, -54.9151500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1168, 'Pampa del Indio', 'Pampa del Indio', 'Pampa del Indio', -26.0646800, -59.9189800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1169, 'Pampa Almirón', 'Pampa Almiron', 'Pampa Almiron,Pampa Almirón', -26.7000000, -59.1333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1170, 'Palo Santo', 'Palo Santo', '', -25.5633200, -59.3378100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1171, 'Palmar Grande', 'Palmar Grande', '', -27.9419500, -57.9005700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1172, 'Olivos', 'Olivos', 'Olivos,QLV,ao li wo si,awlyfws  bwyns ayrs,awlywws,olivosi,Оливос,Олівос,اوليفوس، بوينس آيرس,اولیووس,ოლივოსი,奧利沃斯', -34.5074700, -58.4870300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1173, 'Oberá', 'Obera', 'Obera,Oberá,Yerbal Viejo,ao wei la,awbra,awbyra,Обера,אוברה,اوبرا,اوبيرا,奧韋拉', -27.4870600, -55.1199400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1174, 'Nueve de Julio', 'Nueve de Julio', '9 de Julio,Nueve de Julio', -28.8405100, -58.8265000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1175, 'Nuestra Señora del Rosario de Caa Catí', 'Nuestra Senora del Rosario de Caa Cati', 'Caa Cati,Caa Catí,General Paz,Nuestra Senora del Rosario de Caa Cati,Nuestra Señora del Rosario de Caa Catí', -27.7507200, -57.6207300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1176, 'Nogoyá', 'Nogoya', 'Nogoya,Nogoyá,nuo ge ya,諾戈亞', -32.3938700, -59.7895300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1177, 'Necochea', 'Necochea', 'NEC,Necochea,Nekoceja,Nekočėja,nei ke qie a,nkwchya,nykwtshya,نيكوتشيا,نکوچئا,ნეკოჩეა,內科切阿', -38.5545000, -58.7396100, 'AR', '2016-01-27', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1178, 'Navarro', 'Navarro', 'Navarro', -35.0055900, -59.2769900, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1179, 'Morón', 'Moron', '6 de Septiembre,Moron,Morón,Seis de Septiembre,mo long,molon,moron,moroni,mwrwn,mwrwn  bwyns ayrs,Морон,مورون,مورون، بوينس آيرس,მორონი,モロン,莫龙,모론', -34.6509000, -58.6195600, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1180, 'Monte Caseros', 'Monte Caseros', 'MCS,Monte Caseros,Monte Kaserosas,meng te ka sai luo si,蒙特卡塞羅斯', -30.2535900, -57.6362600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1181, 'Montecarlo', 'Montecarlo', 'Montecarlo,Puerto Montecarlo', -26.5662000, -54.7570000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1182, 'Mojón Grande', 'Mojon Grande', 'Mojon Grande,Mojón Grande', -27.7116500, -55.1563100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1183, 'Mocoretá', 'Mocoreta', '', -30.6189100, -57.9634400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1184, 'Miramar', 'Miramar', 'MJR,Miramar', -38.2716100, -57.8389000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1185, 'Merlo', 'Merlo', 'Merlo,mei luo,meleullo,meruro,mrlw,myrlw  bwyns ayrs,Мерло,Մերլո,مرلو,ميرلو، بوينس آيرس,メルロ,梅洛,메를로', -34.6662700, -58.7292700, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1186, 'Mercedes', 'Mercedes', 'Mercedes,Mercedo,Mersedes,Mersedesas,mei sai de si,mrsds  bwynws ayrs,Мерседес,مرسدس، بوئنوس آیرس,مرسيدس، مقاطعة بوينس آيرس,梅塞德斯', -34.6514500, -59.4306800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1187, 'Mercedes', 'Mercedes', 'MDX,Mercedes,Mersedes,Mersedesas,mei er sai de si,mrsds,Мерседес,مرسدس,梅爾塞德斯', -29.1841600, -58.0751900, 'AR', '2015-06-15', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1188, 'Mburucuyá', 'Mburucuya', 'Mburucuya,Mburucuyá', -28.0453200, -58.2283500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1189, 'Mártires', 'Martires', 'Martires,Mártires', -27.4333300, -55.3833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1190, 'Mariano I. Loza', 'Mariano I. Loza', 'Justino Solari,Mariano I. Loza,Solari', -29.3766700, -58.1943600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1191, 'Margarita Belén', 'Margarita Belen', 'M. Belen,M. Belén,Margarita BeTen,Margarita BeTén,Margarita Belen,Margarita Belén', -27.2616000, -58.9721900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1192, 'Mar del Tuyú', 'Mar del Tuyu', 'Mar del Tuyu,Mar del Tuyú', -36.5753100, -56.6888300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1193, 'Mar del Plata', 'Mar del Plata', 'Gorad Mar-dehl''-Plata,MDQ,Mar Del Plat,Mar de Plata,Mar del Plata,Mar ntel Plata,Mar-del''-Plata,Mar-del''-Platae,Mar-del-Plata,Mar-del-plata,ma de pu la ta,maleudelpeullata,mar del pla ta,mar dl plata,mara dela plata,maryh dyl blata,Μαρ ντελ Πλάτα,Горад Мар-дэль-Плата,Мар дел Плата,Мар-дель-Платæ,Мар-дель-Плата,Մար-դել-Պլատա,מאר דל פלאטה,مار دل پلاتا,ماريه ديل بلاتا,মার ডেল প্লাটা,มาร์เดลปลาตา,მარ-დელ-პლატა,マル・デル・プラタ,马德普拉塔,마르델플라타', -38.0022800, -57.5575400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1194, 'Marcos Paz', 'Marcos Paz', 'M. Paz,Marcos Paz,Markos-Pas,markws baz,Маркос-Пас,ماركوس باز', -34.7806300, -58.8379000, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1195, 'Malabrigo', 'Malabrigo', 'Colonia Ella,Malabrigo', -29.3463600, -59.9695700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1196, 'Makallé', 'Makalle', 'Makalle,Makallé', -27.2068700, -59.2869600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1197, 'Maipú', 'Maipu', 'Maipu,Maipú', -36.8627400, -57.8809400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1198, 'Magdalena', 'Magdalena', 'Magdalena', -35.0806500, -57.5130100, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1199, 'Maciá', 'Macia', 'Macia,Maciá', -32.1722000, -59.3994700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1200, 'Luján', 'Lujan', 'Lujan,Luján,Lukhan,Luxan,lu han,lukhani,lwkhan,Лухан,Լուխան,لوخان,لوخان، مقاطعة بوينس آيرس,ლუხანი,盧漢', -34.5702800, -59.1050000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1201, 'Lucas González', 'Lucas Gonzalez', 'L. Gonzalez,L. González,Lucas Gonzalez,Lucas González', -32.3843000, -59.5301300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1202, 'Los Helechos', 'Los Helechos', 'Los Helechos', -27.5576000, -55.0768300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1203, 'Los Conquistadores', 'Los Conquistadores', '', -30.5908000, -58.4677300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1204, 'Los Charrúas', 'Los Charruas', 'Los Charruas,Los Charrúas', -31.1754800, -58.1877400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1205, 'Loreto', 'Loreto', '', -27.7683400, -57.2753100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1206, 'Loreto', 'Loreto', 'Loreto', -27.3363500, -55.5222500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1207, 'Lomas de Zamora', 'Lomas de Zamora', 'L. de Zamora,Lomas de Zamora', -34.7608800, -58.4063200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1208, 'Lomas de Vallejos', 'Lomas de Vallejos', '', -27.7350100, -57.9185000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1209, 'Lobos', 'Lobos', 'Lobos,lwbws,لوبوس', -35.1828600, -59.0897500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1210, 'Lobería', 'Loberia', 'Loberia,Lobería', -38.1557400, -58.7913000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1211, 'Libertad', 'Libertad', 'Colonia Libertad,Libertad', -30.0430000, -57.8202000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1212, 'Leandro N. Alem', 'Leandro N. Alem', 'L.H. Alem Leandro,Leandro N. Alem', -27.6034100, -55.3249100, 'AR', '2016-01-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1213, 'La Verde', 'La Verde', 'La Verde', -27.1263400, -59.3735200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1214, 'Las Toscas', 'Las Toscas', 'Las Tocas,Las Toscas', -28.3529000, -59.2579500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1215, 'Las Garcitas', 'Las Garcitas', 'Colonia Las Garcitas,Las Garcitas', -26.5833300, -59.8000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1216, 'Las Flores', 'Las Flores', 'Las Flores', -36.0140300, -59.0998400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1217, 'Larroque', 'Larroque', 'Larrogue,Larroque,Villa Larroque', -33.0359500, -59.0012500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1218, 'La Plata', 'La Plata', 'Eva Peron,Eva Perón,Gorad La-Plata,LPG,La Plat,La Plata,La-Plata,La-Plata shaary,La-Platae,Laplata,Urbs Platensis,la plata,la pu la ta,lablata,lap lata,lapeullata,rapurata,Λα Πλάτα,Горад Ла-Плата,Ла Плата,Ла-Платæ,Ла-Плата,Ла-Плата шаары,לא פלאטא,לה פלאטה,لا پلاتا,لابلاتا,ला प्लाटा,ला प्लाता,লা প্লাতা,ลาปลาตา,ლა-პლატა,ラプラタ,拉普拉塔,라플라타', -34.9214500, -57.9545300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1219, 'La Paz', 'La Paz', 'La Paz', -30.7448500, -59.6456600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1220, 'Lapachito', 'Lapachito', 'Lapachito', -27.1599700, -59.3860500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1221, 'Lanús', 'Lanus', 'Lanus,Lanusas,Lanús,la nu si,lanuseu,lanusi,lanws,ranusu,Ланус,Լանուս,لانوس,ლანუსი,ラヌース,拉努斯,라누스', -34.7025200, -58.3955000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1222, 'La Leonesa', 'La Leonesa', 'La Leonesa', -27.0378600, -58.7034700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1223, 'Laguna Naick-Neck', 'Laguna Naick-Neck', 'Laguna Naick-Neck,Laguna Naineck', -25.2476900, -58.0938300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1224, 'Laguna Limpia', 'Laguna Limpia', 'Laguna Limpia', -26.4956500, -59.6808300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1225, 'La Escondida', 'La Escondida', 'Desvio La Escondida,La Escondida', -27.1072400, -59.4478400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1226, 'La Eduvigis', 'La Eduvigis', 'La Eduvigis', -26.8554500, -59.0684200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1227, 'La Cruz', 'La Cruz', 'La Cruz', -29.1744300, -56.6432600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1228, 'La Criolla', 'La Criolla', '', -31.2690400, -58.1055800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1229, 'Juan Pujol', 'Juan Pujol', '', -30.4187300, -57.8561200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1230, 'Jardín América', 'Jardin America', 'Chardin Amerika,jrdyn amyrka,جردین امیرکا', -27.0434600, -55.2269800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1231, 'Ituzaingó', 'Ituzaingo', 'Ituzaingo,Ituzaingó,aytwsayngw,yi tu sa yin ge,ایتوساینگو,იტუსაინგო,伊圖薩因戈', -34.6580300, -58.6631700, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1232, 'Ituzaingó', 'Ituzaingo', 'Ituzaingo,Ituzaingó', -27.5816200, -56.6823100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1233, 'Itatí', 'Itati', 'Itati,Itatí', -27.2704300, -58.2445800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1234, 'Itá Ibaté', 'Ita Ibate', 'Ita Ibate,Italbate,Ite-Ibata,Itá Ibaté,Ité-Ibata', -27.4257300, -57.3375800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1235, 'Ibarreta', 'Ibarreta', 'Ibarreta', -25.2143800, -59.8585100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1236, 'Hurlingham', 'Hurlingham', '28 de Septiembre,Hurlingham', -34.5916800, -58.6460800, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1237, 'Herrera', 'Herrera', 'Herrera,Villa San Miguel', -32.4351600, -58.6246200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1238, 'Herradura', 'Herradura', 'Colonia Herradura,Herradura', -26.4870500, -58.3119800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1239, 'Herlitzka', 'Herlitzka', '', -27.5651600, -58.2555700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1240, 'Hasenkamp', 'Hasenkamp', 'Hasenkamp', -31.5122600, -59.8354500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1241, 'Guaraní', 'Guarani', 'Guarani,Guaraní,Pueblo Guarani,Pueblo Guaraní', -27.5166700, -55.1666700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1242, 'Gualeguaychú', 'Gualeguaychu', 'GHU,Gualeguaicu,Gualeguaiču,Gualeguajchu,Gualeguaychu,Gualeguaychú,gua lai gua yi qiu,gualeguaichu,gwalgwaychw,jywlyjyashw  antry ryws,Гуалегуайчу,גואלגואיצו,جيوليجياشو، انتري ريوس,گوالگوایچو,გუალეგუაიჩუ,瓜萊瓜伊丘', -33.0093700, -58.5172200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1243, 'Gualeguay', 'Gualeguay', 'Gualeguajus,Gualeguay,gua lai gua yi,gwalgway,גואלגואי,گوالگوای,瓜萊瓜伊', -33.1415600, -59.3096600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1244, 'Goya', 'Goya', 'Goja,Gojja,Goya,OYA,Гойя', -29.1439500, -59.2651000, 'AR', '2015-06-24', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1245, 'Gobernador Roca', 'Gobernador Roca', 'Colonia Corpus,Gobernador Roca', -27.1863600, -55.4643300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1246, 'Gobernador Mansilla', 'Gobernador Mansilla', 'Gobernador Mansilla,Mansilla', -32.5445300, -59.3548000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1247, 'Gobernador Juan E. Martínez', 'Gobernador Juan E. Martinez', 'Gobernador J.F. Martinez,Gobernador J.F. Martínez,Gobernador Juan E. Martinez,Gobernador Juan E. Martínez,Gobernador Martinez,Gobernador Martínez,Golfo Martinez,Yatay', -28.9170500, -58.9329200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1248, 'Gobernador Ingeniero Valentín Virasoro', 'Gobernador Ingeniero Valentin Virasoro', 'Gobernador Ingeniero Valentin Virasoro,Gobernador Ingeniero Valentín Virasoro,Vuelta del Ombu,Vuelta del Ombú', -28.0500000, -56.0333300, 'AR', '2016-02-02', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1249, 'General Vedia', 'General Vedia', 'General Vedia,General Verde', -26.9338200, -58.6604000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1250, 'General San Martín', 'General San Martin', 'General San Martin,General San Martín,San Martin,San Martín', -34.5742400, -58.5349600, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1251, 'General Rodríguez', 'General Rodriguez', 'General Rodriguez,General Rodríguez', -34.6083800, -58.9525300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1252, 'General Lavalle', 'General Lavalle', 'Ajo,Ajó,General Lavalle,Lavalle', -36.4063300, -56.9432900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1253, 'General Las Heras', 'General Las Heras', 'General Las Heras', -34.9272600, -58.9462100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1254, 'General Juan Madariaga', 'General Juan Madariaga', 'General J. Madariaga,General Juan Madariaga,General Madariaga', -36.9972500, -57.1395100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1255, 'General José de San Martín', 'General Jose de San Martin', 'Cheneral Chose de San Martinas,Colonia Zapallar,El Zapallar,General Jose de San Martin,General José de San Martín,General San Martin,General San Martín,Zapallar,aljnral khwsyh dy san martyn,sheng ma ding jiang jun zhen,الجنرال خوسيه دي سان مارتين,聖馬丁將軍鎮', -26.5374300, -59.3415800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1256, 'General Guido', 'General Guido', 'General Guido,Guido', -36.6407400, -57.7917400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1257, 'General Galarza', 'General Galarza', 'Galarza,General Galarza', -32.7203400, -59.3961500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1258, 'General Conesa', 'General Conesa', 'General Conesa', -36.5201300, -57.3253700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1259, 'General Campos', 'General Campos', 'Campos,Colonia General Campos,General Campos', -31.5231100, -58.4049000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1260, 'General Belgrano', 'General Belgrano', 'General Belgrano', -35.7695200, -58.4934100, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1261, 'General Alvear', 'General Alvear', 'General Alvear', -27.4333300, -55.1666700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1262, 'Garupá', 'Garupa', 'Garupa,Garupá', -27.4817100, -55.8292100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1263, 'Garuhapé', 'Garuhape', 'Garuape,Garuapé,Garuhape,Garuhapé', -26.8176800, -54.9566500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1264, 'Garruchos', 'Garruchos', '', -28.1851400, -55.6394700, 'AR', '2011-04-19', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1265, 'Formosa', 'Formosa', 'Ciudad de Formosa,FMA,Formosa,Formoza,farmwsa,forumosa,fu mo sa,fwrmwza,poleumosa,pormosa,pwrmwsh,Формоза,Формоса,Ֆորմոսա,פורמוסה,فارموسا,فورموزا,فورموسا، ارجنٹائن,ფორმოსა,フォルモーサ,福莫萨,포르모사', -26.1775300, -58.1781400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1266, 'Fontana', 'Fontana', 'Fontana', -27.4181300, -59.0239200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1267, 'Florentino Ameghino', 'Florentino Ameghino', 'Florentino Ameghino', -27.5666700, -55.1333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1268, 'Florencio Varela', 'Florencio Varela', 'F. Varela,Florencio Varela', -34.8272200, -58.3955600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1269, 'Felipe Yofré', 'Felipe Yofre', 'Felipe Yofre,Felipe Yofré,Yofre,Yofré', -29.1022600, -58.3377200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1270, 'Federal', 'Federal', 'Federal,Villa Federal', -30.9546500, -58.7832600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1271, 'Federación', 'Federacion', 'Federacion,Federación', -31.0062100, -57.8996200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1272, 'José María Ezeiza', 'Jose Maria Ezeiza', 'Ezeiza,Jose Maria Ezeiza,José María Ezeiza,Ministro Pistarini,ai sai sa,asysa,ayzyza,Езеиза,إيزيزا,اسیسا,埃塞薩', -34.8478700, -58.5286900, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1273, 'Esquina', 'Esquina', 'Esquina', -30.0144400, -59.5271900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1274, 'Espinillo', 'Espinillo', '', -24.9813200, -58.5521000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1275, 'Ensenada', 'Ensenada', 'Ensenada', -34.8618600, -57.9112600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1276, 'Empedrado', 'Empedrado', 'Empedrado', -27.9512500, -58.8054200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1277, 'El Soberbio', 'El Soberbio', 'El Soberbio', -27.2984700, -54.1987700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1278, 'Eldorado', 'Eldorado', 'ELO,Eldorado', -26.4048400, -54.6247800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1279, 'El Colorado', 'El Colorado', 'El Colorado', -26.3080800, -59.3729100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1280, 'El Alcázar', 'El Alcazar', 'El Alcazar,El Alcázar', -26.7145900, -54.8152300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1281, 'Dos de Mayo', 'Dos de Mayo', '2 de Mayo,Dos de Mayo', -27.0227700, -54.6866900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1282, 'Dos Arroyos', 'Dos Arroyos', 'Dos Arroyos', -27.7078400, -55.2336400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1283, 'Domínguez', 'Dominguez', 'Colonia Clara,Dominguez,Domínguez,Villa Dominguez,Villa Domínguez', -31.9871000, -58.9619700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1284, 'Dolores', 'Dolores', 'Dolores', -36.3132100, -57.6791800, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1285, 'Curuzú Cuatiá', 'Curuzu Cuatia', 'Curuzu Cuatia,Curuzú Cuatiá,Kurusu Kuatia,Kurusu Kvatija,UZU,ku lu su kua di ya,kwrwsw kwatya,کوروسو کواتیا,庫魯蘇夸蒂亞', -29.7917100, -58.0546000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1286, 'Cruz de los Milagros', 'Cruz de los Milagros', '', -28.8364600, -59.0047600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1287, 'Coté-Lai', 'Cote-Lai', '', -27.5000000, -59.6000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1288, 'Corrientes', 'Corrientes', 'CNQ,Ciudad de Corrientes,Corrientes,Gorad Karyentehs,Korientes,Korijentes,Korjentesas,Korrientes,Taragui,ke lian te si,kolienteseu,korientesu,koriyentesa,kwrynts,kwryynts,qwryynts,Горад Карыентэс,Кориентес,Коријентес,Корриентес,Коррієнтес,קוריינטס,كورينتس,کوریئنتس,کورینتس,कोरियेन्टेस,კორიენტესი,コリエンテス,科连特斯,코리엔테스', -27.4806000, -58.8341000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1289, 'Coronel Vidal', 'Coronel Vidal', 'Coronel Vidal', -37.4460400, -57.7286500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1290, 'Conscripto Bernardi', 'Conscripto Bernardi', 'Conscripto Bernardi,Kilometro 101,Kilómetro 101', -31.0483700, -59.0843500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1291, 'Concordia', 'Concordia', 'COC,Concordia,Konkordia,Konkordija,kang ke di ya,kongkoleudia,konkorudia,kwnkwrdya,kwnkwrdya  antry ryws,qwnqwrdyh,Конкордия,Конкордија,Կոնկորդիա,קונקורדיה,كونكورديا، انتري ريوس,کونکوردیا,コンコルディア,康科迪亚,콩코르디아', -31.3929600, -58.0208900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1292, 'Concepción del Uruguay', 'Concepcion del Uruguay', 'Concepcion del Uruguay,Concepción del Uruguay,Konseps''jon-del''-Urugvaj,Konseps''on-del''-Urugvaj,Konsepsion del Urugvajus,knspsywn dl awrwgway,kwnsbsywn dyl awrwghway,wu la gui he pan kang sai pu xi weng,Консепсьйон-дель-Уругвай,Консепсьон-дель-Уругвай,קונספסיון דל אורוגוואי,كونسبسيون ديل أوروغواي,کنسپسیون دل اوروگوای,კონსეპსიონ-დელ-ურუგვაი,乌拉圭河畔康塞普西翁', -32.4824900, -58.2372200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1293, 'Concepción de la Sierra', 'Concepcion de la Sierra', 'Concepcion de la Sierra,Concepción de la Sierra', -27.9831100, -55.5203100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1294, 'Concepción', 'Concepcion', 'Concepcion,Concepción', -28.3917500, -57.8877700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1295, 'Comandante Fontana', 'Comandante Fontana', 'Comandante Fontana', -25.3345300, -59.6821200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1296, 'Colonia Wanda', 'Colonia Wanda', '', -25.9740800, -54.4280600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1297, 'Colonias Unidas', 'Colonias Unidas', 'Colonia Unidas,Colonias Unidas', -26.6982500, -59.6315400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1298, 'Colonia Elisa', 'Colonia Elisa', 'Colonia Elisa', -26.9304100, -59.5186100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1299, 'Colonia Elía', 'Colonia Elia', '', -32.6662500, -58.3214800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1300, 'Colonia Benítez', 'Colonia Benitez', 'Benitez,Benítez,Colonia Benitez,Colonia Benítez', -27.3309900, -58.9462200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1301, 'Colonia Aurora', 'Colonia Aurora', 'Colonia Aurora', -27.4742800, -54.5249800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1302, 'Colón', 'Colon', 'Colon,Colón', -32.2233700, -58.1434100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1303, 'Colegiales', 'Colegiales', 'Colegiales', -34.5736500, -58.4492400, 'AR', '2017-05-08', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1304, 'Clorinda', 'Clorinda', 'CLX,Clorinda,Klorinda,Клоринда', -25.2848100, -57.7185100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1305, 'Ciervo Petiso', 'Ciervo Petiso', 'Ciervo Petiso,Ciervo Petizo', -26.5804100, -59.6309400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1306, 'Chavarría', 'Chavarria', 'Chavarria,Chavarría', -28.9548900, -58.5727700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1307, 'Chascomús', 'Chascomus', 'Chascomus,Chascomús', -35.5729700, -58.0080900, 'AR', '2017-05-08', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1308, 'Charadai', 'Charadai', 'Charadai,Charaday', -27.6333300, -59.9000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1309, 'Chajarí', 'Chajari', 'Chajari,Chajarí', -30.7504800, -57.9796200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1310, 'Cerro Corá', 'Cerro Cora', 'Cerro Cora,Cerro Corá,Colonia Cerro Cora,Colonia Cerro Corá', -27.5131000, -55.6089600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1311, 'Cerro Azul', 'Cerro Azul', 'Cerro Azul', -27.6331000, -55.4962000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1312, 'Ceibas', 'Ceibas', 'Ceibas', -33.4333300, -58.7500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1313, 'Castelli', 'Castelli', 'Castelli', -36.0894900, -57.8039300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1314, 'Caseros', 'Caseros', 'Caseros,ka sai luo si,kasrws,kasyrws,كاسيروس,کاسروس,კასეროსი,卡塞羅斯', -34.6033300, -58.5640900, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1315, 'Caseros', 'Caseros', 'Caseros,Colonia Caseros', -32.4632500, -58.4787200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1316, 'Carmen de Areco', 'Carmen de Areco', 'C. de Areco,Carmen de Areco', -34.3774300, -59.8239500, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1317, 'Caraguatay', 'Caraguatay', 'Caraguatay,Puerto Caraguatay', -26.6058700, -54.7809300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1318, 'Capitán Solari', 'Capitan Solari', 'Capitan Solari,Capitán Solari', -26.8021500, -59.5608900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1319, 'Capitán Sarmiento', 'Capitan Sarmiento', 'Capitan Sarmiento,Capitán Sarmiento', -34.1723800, -59.7904800, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1320, 'Capioví', 'Capiovi', 'Capiovi,Capioví', -26.9299800, -55.0608400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1321, 'Capilla del Señor', 'Capilla del Senor', 'Capilla,Capilla del Senor,Capilla del Señor', -34.2920700, -59.1017900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1322, 'Cañuelas', 'Canuelas', 'Canuelas,Cañuelas', -35.0518400, -58.7606100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1323, 'Candelaria', 'Candelaria', 'Candelaria', -27.4595000, -55.7453600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1324, 'Campo Viera', 'Campo Viera', 'Campo Viera', -27.3833300, -55.0333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1325, 'Campo Ramón', 'Campo Ramon', 'Campo Ramon,Campo Ramón', -27.4610800, -55.0190100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1326, 'Campo Grande', 'Campo Grande', 'Campo Grande', -27.2077000, -54.9797700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1327, 'Campana', 'Campana', 'Campana,Kampana,Кампана', -34.1687400, -58.9591400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1328, 'Buenos Aires', 'Buenos Aires', 'BUE,Baires,Bonaero,Bonaeropolis,Bonaëropolis,Bos Aires,Bouenos Aires,Bouonezar,Bouonézâr,Buehnos Ajres,Buehnos-Ajres,Buehnos-Ajres osh,Buenos Aires,Buenos Airės,Buenos Ajres,Buenos Ayres,Buenos-Aires,Buenos-Ajres,Buenos-Ayres,Buenos-Aýres,Buenosairesa,Buénos Ayrés,Bwenoze,Bwènozè,Búenos Aíres,Ciudad Autonoma de Buenos Aires,Ciudad Autónoma de Buenos Aires,Ciudad de La Santisima Trinidad y Puerto de Santa Maria del Buen Ayre,Ciudad de La Santísima Trinidad y Puerto de Santa María del Buen Ayre,Gorad Buehnas-Ajrehs,Lungsod ng Buenos Aires,Santa Maria del Buen Ayre,Santa María del Buen Ayre,bawnosxires,bu yi nuo si ai li si,bu''enosa a''iresa,buenos-airesi,buenosaires,buenoseuaileseu,buenosuairesu,buraenosa a''iresa,buyenosa a''iresa,bwyns ayrs,bwynws ayrs,bwynws ayrys,byu''enosa erisa,byunas airis,byunas ayels,bywns ayrs,puvenas airis,Μπουένος ΄Aιρες,Μπουένος Άιρες,Буенос Аирес,Буенос Айрес,Буенос Аірес,Буенос Ајрес,Буенос-Аирес,Буенос-Айрес,Буэнос Айрес,Буэнос-Айрес,Буэнос-Айрес ош,Горад Буэнас-Айрэс,Բուենոս Այրես,בואנוס איירס,בוענאס איירעס,بوئنوس آیرس,بوينس آيرس,بوينوس ايريس,بۆینس ئایرس,بیونس آئرس,बुएनोस आइरेस,ब्युएनॉस एरीस,বুয়েনোস আইরেস,বুৱেনোস আইরেস,புவெனஸ் ஐரிஸ்,ಬ್ಯೂನಸ್ ಐರಿಸ್,ബ്യൂണസ് അയേഴ്സ്,บัวโนสไอเรส,པུ་ཨེ་ནོ་སི་ཨས་རི་སི།,ဗျူနိုအေးရိစ်မြို့,ბუენოს-აირესი,ብዌኖስ አይሬስ,ブエノスアイレス,布宜諾斯艾利斯,布宜诺斯艾利斯,부에노스아이레스', -34.6131500, -58.3772300, 'AR', '2017-05-28', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1329, 'Brandsen', 'Brandsen', 'Brandsen,Coronel Brandsen', -35.1684200, -58.2342700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1330, 'Bovril', 'Bovril', 'Bovril', -31.3431100, -59.4451200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1331, 'Bonpland', 'Bonpland', 'Bompland,Bonpland', -29.8170800, -57.4297400, 'AR', '2015-06-15', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1332, 'Bonpland', 'Bonpland', '', -27.4821800, -55.4775600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1333, 'Berón de Astrada', 'Beron de Astrada', '', -27.5506700, -57.5346000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1334, 'Bernardo de Irigoyen', 'Bernardo de Irigoyen', 'Barracon,Bernardo de Irigoyen', -26.2552000, -53.6458100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1335, 'Berisso', 'Berisso', 'Berisas,Beriso,Berisso,byrysw,Берисо,Беріссо,بيريسو', -34.8735000, -57.8830300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1336, 'Benito Juárez', 'Benito Juarez', 'Benito Juarez,Benito Juárez,Juarez,Juárez', -37.6718800, -59.8065300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1337, 'Bella Vista', 'Bella Vista', 'Bella Vista', -28.5091800, -59.0400900, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1338, 'Belén de Escobar', 'Belen de Escobar', 'Belen,Belen de Escobar,Belén,Belén de Escobar,Escobar', -34.3483300, -58.7926500, 'AR', '2016-05-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1339, 'Basail', 'Basail', 'Basail', -27.8666700, -59.3000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1340, 'Barranqueras', 'Barranqueras', 'Barranqueras,ba lan ke la si,barankywras,بارانكيوراس,巴蘭克拉斯', -27.4813200, -58.9392500, 'AR', '2015-06-24', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1341, 'Baradero', 'Baradero', 'Baradero', -33.8110500, -59.5080700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1342, 'Balcarce', 'Balcarce', 'Balcarce,ba er ka sai,balkarsh,balkarsy,بالكارسي,بالکارسه,巴爾卡塞', -37.8461600, -58.2552200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1343, 'Azul', 'Azul', 'Asulis,Azul,a su er,aswl,Азул,آسول,أزول، مقاطعة بوينس آيرس,阿蘇爾', -36.7769800, -59.8585400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1344, 'Azara', 'Azara', 'Azara', -28.0616000, -55.6779700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1345, 'Ayacucho', 'Ayacucho', 'Ayacucho', -37.1518500, -58.4869100, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1346, 'Avellaneda', 'Avellaneda', 'Avellaneda,Estacion Ewald,Estación Ewald', -29.1176100, -59.6583400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1347, 'Arroyo del Medio', 'Arroyo del Medio', 'Arroyo del Medio', -27.7000000, -55.4166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1348, 'Aristóbulo del Valle', 'Aristobulo del Valle', 'Aristobulo del Valle,Aristóbulo del Valle', -27.0962500, -54.8962600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1349, 'Apóstoles', 'Apostoles', 'Apostoles,Apóstoles', -27.9142100, -55.7535500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1350, 'Alvear', 'Alvear', 'Alvear', -29.0968300, -56.5504300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1351, 'Almafuerte', 'Almafuerte', 'Almafuerte', -27.5051800, -55.3949700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1352, 'Aldea San Antonio', 'Aldea San Antonio', 'Aldea San Antonio,San Antonio', -32.6237600, -58.7033300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1353, 'Alba Posse', 'Alba Posse', 'Alba Posse', -27.5697800, -54.6826200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1354, 'Guernica', 'Guernica', 'Guernica', -34.9172200, -58.3869400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1355, 'Villa Basilio Nievas', 'Villa Basilio Nievas', 'Villa Basilio Nievas,Zonda', -31.5500000, -68.7333300, 'AR', '2015-05-01', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1356, 'Zapala', 'Zapala', 'APZ,Sapala,Zapala,sa pa la,sapala,Сапала,Սապալա,ساپالا,薩帕拉', -38.8991600, -70.0544200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1357, 'Yuto', 'Yuto', '', -23.6434200, -64.4719400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1358, 'Yerba Buena', 'Yerba Buena', 'Yerba Buena', -26.8166700, -65.3166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1359, 'Yacimiento Río Turbio', 'Yacimiento Rio Turbio', 'Rio Turbio,Río Turbio,Yacimiento Rio Turbio,Yacimiento Río Turbio,Yacimientos de Rio Turbio,Yacimientos de Río Turbio', -51.5732100, -72.3508000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1360, 'Winifreda', 'Winifreda', 'Winifreda', -36.2264300, -64.2338800, 'AR', '2016-02-02', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1361, 'Wenceslao Escalante', 'Wenceslao Escalante', 'Escalante,Medanos de las Canas,Médanos de las Cañas,Wenceslao Escalante', -33.1730300, -62.7707800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1362, 'Vista Alegre', 'Vista Alegre', 'Colonia Vista Alegre,Vista Alegre', -38.7500000, -68.1833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1363, 'Vinchina', 'Vinchina', '', -28.7596400, -68.2069200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1364, 'Villa Valeria', 'Villa Valeria', '', -34.3409300, -64.9203000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1365, 'Villa Urquiza', 'Villa Urquiza', 'Villa Urquiza', -31.6473100, -60.3748000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1366, 'Villa Unión', 'Villa Union', 'Union,Unión,Villa Union,Villa Unión', -29.4134700, -62.7882200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1367, 'Villa Unión', 'Villa Union', 'Villa Union,Villa Unión', -29.3159500, -68.2265800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1368, 'Villa Tulumba', 'Villa Tulumba', 'Tulumba,Villa Tulumba', -30.3955200, -64.1224100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1369, 'Villa Trinidad', 'Villa Trinidad', '', -30.2132900, -61.8759700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1370, 'Villa Santa Rosa', 'Villa Santa Rosa', '', -31.7443400, -68.3141100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1371, 'Villa Rumipal', 'Villa Rumipal', 'Rumipal,Villa Rumipal', -32.1879000, -64.4802700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1372, 'Villa Regina', 'Villa Regina', 'Villa Regina', -39.1000000, -67.0666700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1373, 'Villa Reducción', 'Villa Reduccion', 'Reduccion,Reducción,Villa Reduccion,Villa Reducción', -33.2010500, -63.8623400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1374, 'Villa Paula de Sarmiento', 'Villa Paula de Sarmiento', 'Paula A. de Sarmiento,Villa Paula de Sarmiento', -31.4933000, -68.5383800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1375, 'Villa Ojo de Agua', 'Villa Ojo de Agua', 'Ojo de Agua,Villa Ojo de Agua', -29.5000300, -63.6937700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1376, 'Villa Nueva', 'Villa Nueva', 'Guaymallen,Guaymallén,Villa Nueva,Villa Nueva de Guaymallen,Villa Nueva de Guaymallén', -32.8972200, -68.7803800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1377, 'Villa Nueva', 'Villa Nueva', '', -32.4329300, -63.2476300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1378, 'Villa Media Agua', 'Villa Media Agua', 'Media Agua,Villa Media Agua', -31.9826700, -68.4239400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1379, 'Villa María', 'Villa Maria', 'Vilja Marija,Villa Maria,Villa María,fyla marya,ma li ya zhen,vilia-maria,wyya marya,wyzh mryh,ויזה מריה,فيلا ماريا,وییا ماریا,ვილია-მარია,瑪麗亞鎮', -32.4075100, -63.2401600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1380, 'Villa Las Rosas', 'Villa Las Rosas', 'Las Rosas,Villa Las Rosas,Villa de Las Rosas', -31.9502100, -65.0535400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1381, 'Villa La Angostura', 'Villa La Angostura', 'Vilja La Angostura,Villa La Angostura,Villa la Angostura,la an ge si tu la zhen,ויזה לה אנגוסטורה,拉安戈斯圖拉鎮', -40.7617300, -71.6463100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1382, 'Villa Krause', 'Villa Krause', 'Villa Krause,Villa Krausse', -31.5666700, -68.5333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1383, 'Villa Huidobro', 'Villa Huidobro', 'Canada Verde,Cañada Verde,Villa Huidobro', -34.8382600, -64.5868600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1384, 'Villa Giardino', 'Villa Giardino', 'Villa Giardino', -31.0333300, -64.4833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1385, 'Villa General Roca', 'Villa General Roca', 'General Roca,Villa General Roca', -32.6653500, -66.4505200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1386, 'Villa General Mitre', 'Villa General Mitre', 'General Mitre,Pinto,Villa General Mitre', -29.1431000, -62.6524800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1387, 'Villa General Belgrano', 'Villa General Belgrano', 'Villa General Belgrano', -31.9754200, -64.5559000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1388, 'Villa Dolores', 'Villa Dolores', 'Dolores,VDR,Villa Dolores,duo luo lei si zhen,fyla dwlwrys,فيلا دولوريس,多洛雷斯鎮', -31.9458500, -65.1895800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1389, 'Villa de Soto', 'Villa de Soto', 'Soto,Villa de Soto', -30.8552300, -64.9994700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1390, 'Villa de María', 'Villa de Maria', 'Rio Seco,Río Seco,Villa de Maria,Villa de María', -29.9019500, -63.7228900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1391, 'Villa del Totoral', 'Villa del Totoral', 'Totoral,Villa del Totoral', -30.8166700, -63.7166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1392, 'Villa del Salvador', 'Villa del Salvador', '', -31.4415500, -68.3974500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1393, 'Villa del Rosario', 'Villa del Rosario', 'Villa de Rosario,Villa del Rosario,luo sa li ao zhen,羅薩里奧鎮', -31.5566000, -63.5345200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1394, 'Villa del Dique', 'Villa del Dique', 'Villa Dique,Villa de Dique,Villa del Dique', -32.1766700, -64.4554300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1395, 'Villa Cura Brochero', 'Villa Cura Brochero', 'Transito,Transito de San Alberto,Tránsito de San Alberto,Villa Cura Brochero', -31.7057800, -65.0179600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1396, 'Villa Constitución', 'Villa Constitucion', 'Villa Constitucion,Villa Constitución,kong si di tu xi weng zhen,wyya kwnstytwsywn,وییا کونستیتوسیون,孔斯蒂圖西翁鎮', -33.2277800, -60.3297000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1397, 'Villa Concepción del Tío', 'Villa Concepcion del Tio', 'Concepcion,Concepción,Villa Concepcion,Villa Concepcion del Tio,Villa Concepción,Villa Concepción del Tío', -31.3225900, -62.8135400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1398, 'Chañar Ladeado', 'Chanar Ladeado', 'Chanar Ladeado,Chanar Ladeador,Chañar Ladeado,Chañar Ladeador,Villa Chanar Ladeado,Villa Chañar Ladeado', -33.3252400, -62.0383100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1399, 'Villa Castelli', 'Villa Castelli', 'Villa Castelli', -29.0029500, -68.2127700, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1400, 'Villa Carlos Paz', 'Villa Carlos Paz', 'Karlos-Paz,Vil''ja-Karlos-Pas,Vilja Karlos Pasas,Villa Carlos Paz,Vilya Karlos Pas,fyla karlws baz,ka luo si pa si zhen,wyya karlws pas,Вилья-Карлос-Пас,Карлос-Паз,Վիլյա Կառլոս Պաս,ויזה קרלוס פאס,فيلا كارلوس باز,وییا کارلوس پاس,ვილია-კარლოს-პასი,卡洛斯帕斯鎮', -31.4241400, -64.4977800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1401, 'Villa Cañás', 'Villa Canas', 'Villa Canas,Villa Cañás', -34.0056500, -61.6075700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1402, 'Villa Bustos', 'Villa Bustos', 'Sanagasta,Villa Bustos', -29.2848300, -67.0330800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1403, 'Villa Berthet', 'Villa Berthet', 'Villa Berthet', -27.2917400, -60.4126300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1404, 'Villa Atamisqui', 'Villa Atamisqui', 'Atamisqui,Villa Atamisqui', -28.4960900, -63.8160900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1405, 'Villa Ascasubi', 'Villa Ascasubi', 'Ascasubi,Villa Ascasubi', -32.1635100, -63.8915700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1406, 'Villa Ángela', 'Villa Angela', 'Vilja Anchela,Villa Angela,Villa Ángela,an ji la zhen,wyya ankhla,ויזה אנחלה,وییا آنخلا,安吉拉鎮', -27.5738300, -60.7152600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1407, 'Villa Allende', 'Villa Allende', 'Villa Allende', -31.2945800, -64.2953800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1408, 'Villa Aberastain', 'Villa Aberastain', 'Aberastain,Villa Aberastain', -31.6500000, -68.5833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1409, 'Viedma', 'Viedma', 'V''edma,V''edmae,VDM,Vedma,Viedma,Vjedma,beiyd ma,bie de ma,biedeuma,biedoma,fydma,viedma,wydma,wyydmh,Βιέδμα,Виедма,Вьедмæ,Вьедма,Вєдма,Վիեդմա,ויידמה,فيدما,ویدما,เบียดมา,ვიედმა,ビエドマ,別德馬,비에드마', -40.8134500, -62.9966800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1410, 'Vicuña Mackenna', 'Vicuna Mackenna', 'Mackenna,Vicuna Mackenna,Vicuña Mackenna', -33.9196500, -64.3921500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1411, 'Victorica', 'Victorica', 'Victorica', -36.2150500, -65.4358600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1412, 'Victoria', 'Victoria', 'Viktorija,wei duo li ya,Виктория,وکٹوریہ، انترے ریوس,維多利亞', -32.6184100, -60.1547800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1413, 'Viamonte', 'Viamonte', 'General Viamonte,Viamonte', -33.7464700, -63.0976400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1414, 'Viale', 'Viale', 'Viale', -31.8678200, -60.0072200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1415, 'Vera', 'Vera', 'Jobson,Vera', -29.4593000, -60.2126100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1416, 'Venado Tuerto', 'Venado Tuerto', 'Neuken,Venado Touerto,Venado Tuertas,Venado Tuerto,bei na duo tu ai tuo,fynadw tywrtw,wanadw twrtw,Βενάδο Τουέρτο,Неукен,ונדו טוארטו,فينادو تيورتو,وانادو تورتو,ვენადო-ტუერტო,貝納多圖埃托', -33.7455600, -61.9688500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1417, '28 de Noviembre', '28 de Noviembre', '28 de Noviembre,Veintiocho de Noviembre', -51.5839000, -72.2138200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1418, 'Veinticinco de Mayo', 'Veinticinco de Mayo', '25 de Mayo,Colonia Los Viejos,Colonia Veinticinco de Mayo,Veinticinco de Mayo', -37.7741000, -67.7163800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1419, 'Veinticinco de Mayo', 'Veinticinco de Mayo', '25 de Mayo,Veinticinco de Mayo', -35.4323000, -60.1727100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1420, 'Vedia', 'Vedia', 'Vedia', -34.4955800, -61.5413800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1421, 'Valle Hermoso', 'Valle Hermoso', 'Valle Hermoso', -31.1173200, -64.4808400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1422, 'Valle Grande', 'Valle Grande', '', -23.4773500, -64.9425000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1423, 'Valcheta', 'Valcheta', 'VCF,Valcheta', -40.7000000, -66.1500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1424, 'Ushuaia', 'Ushuaia', 'Gorad Ushuaja,Ousouaia,Owsuaya,USH,Ushuaia,Ushuaja,Ushuaïa,Usuaja,Usuaya,Usvaja,Uşuaya,Ušuaja,Ušvaja,awshwaya,awshwayya,awswaya,ushuaia,usuaia,usuviya,usuya''iya,wu si huai ya,xusaw ya,Ουσουάια,Горад Ушуая,Ушуая,Ушуаја,Ուշուայա,אושואיה,أوشوايا,اوسوایا,اوشوآئیا,উসুয়াইয়া,ಉಶುವಿಯಾ,อูซัวยา,უშუაია,ウシュアイア,乌斯怀亚,우수아이아', -54.8000000, -68.3000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(857, 'Meghrashen', 'Meghrashen', 'Kazanchi,Meghrashen,Megrasen,Megrashen,Меграшен,Մեղրաշեն', 40.6723000, 43.9583100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(858, 'Meghradzor', 'Meghradzor', 'Meghradzor,Megradzor,Megrajor,Taycharukh,Меградзор,Մեղրաձոր', 40.6061100, 44.6514700, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(859, 'Mayakovski', 'Mayakovski', 'Majakovskij,Mayakovski,Mayakovskiy,Shaab,Маяковский,Մայակովսկի', 40.2529300, 44.6389200, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(860, 'Masis', 'Masis', 'Hrazdan,Masis,Narimanlu,Razdan,Takhanshalu,Tokhanshalu,Ulukhanlu,Zangibasar,Масис,Մասիս', 40.0654200, 44.4161800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(861, 'Martuni', 'Martuni', 'Karanlug,Martuki,Martuni,Martuny,Nerkin Karanlukh,Nizhniy-Karanlug,Мартуни,Մարտունի', 40.1389200, 45.3054800, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(862, 'Marmarashen', 'Marmarashen', 'Marmarasen,Marmarashen,Marmorashen,Мармарашен,Մարմարաշեն', 40.0582900, 44.4722900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(863, 'Marmashen', 'Marmashen', 'Kanlidzha,Marmasen,Marmashen,Verin Kanlidzha,Мармашен,Մարմաշեն', 40.8348600, 43.7779000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(864, 'Margahovit', 'Margahovit', 'Bozigekh,Gamzachemanskaya,Gamzachiman,Hamgach''iman,Hamgach’iman,Margahovit,Margaovit,Маргаовит,Մարգահովիտ', 40.7338100, 44.6847400, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(865, 'Maralik', 'Maralik', 'Maralik,Molla Gekcha,Molla Gëkcha,Маралик,Մարալիկ', 40.5750700, 43.8723100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(866, 'Mayisyan', 'Mayisyan', 'Maisian,Maisjan,Maisyan,Mayisyan,Ortakilisa,Маисян,Մայիսյան', 40.8471500, 43.8393800, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(867, 'Madina', 'Madina', 'Madina,Мадина,Մադինա', 40.0763700, 45.2550700, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(868, 'Lukashin', 'Lukashin', 'Imeni Mikoyana,Lukashin,Лукашин', 40.1872600, 44.0039000, 'AM', '2013-08-05', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(869, 'Lorut', 'Lorut', 'Lorut,Лорут,Լորուտ', 40.9371700, 44.7714200, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(870, 'Lichk’', 'Lichk''', 'Gel,Gël,Lichk,Lichk'',Lichk’,Личк,Լիճք', 40.1593300, 45.2346700, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(871, 'Lerrnavan', 'Lerrnavan', 'Kachagan,Lernavan,Lerrnavan,Лернаван,Լեռնավան', 40.7882000, 44.1602400, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(872, 'Lerrnapat', 'Lerrnapat', 'Gadzhikara,Lernapat,Lerrnapat,Makarashen,Լեռնապատ', 40.8153800, 44.3934400, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(873, 'Lerrnants’k’', 'Lerrnants''k''', 'Lernantsk,Lerrnants''k'',Lerrnants’k’,Spitak,Спитак,Լեռնանցք', 40.7953200, 44.2743500, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(874, 'Lerrnanist', 'Lerrnanist', 'Lernanist,Lerrnanist,Verin Akhta,Verkhnyaya Akhta,Лернанист,Լեռնանիստ', 40.4667600, 44.7924900, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(875, 'Lerrnakert', 'Lerrnakert', 'Lernakert,Lerrnakert,Shirvan,Shirvandzhug,Լեռնակերտ', 40.5625000, 43.9389000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(876, 'Khoronk’', 'Khoronk''', 'Khoronk'',Khoronk’,Lenughi,Lenugi,Nerkin Aylanlu,Nizhniy Aylanlu,Խորոնք', 40.1361100, 44.2473100, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(877, 'Lchashen', 'Lchashen', 'Lcasen,Lchashen,Ordaklu,Лчашен,Լճաշեն', 40.5194700, 44.9304800, 'AM', '2016-09-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(878, 'Lchap’', 'Lchap''', 'Agzibir,Lchap,Lchap'',Lchap’,Lehap,Лчап,Լճափ', 40.4556900, 45.0750700, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(879, 'Lanjaghbyur', 'Lanjaghbyur', 'Kyuzadzhik,Landzhakhbjur,Landzhakhpyur,Lanjagbyur,Lanjaghbyur,Ланджахбюр,Լանջաղբյուր', 40.2694700, 45.1444700, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(880, 'Kotayk’', 'Kotayk''', 'Kotayk'',Kotayk’,Yelgovan,Կոտայք', 40.2778900, 44.6638800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(881, 'Kosh', 'Kosh', 'Kos,Kosh,Кош,Կոշ', 40.3001100, 44.1610700, 'AM', '2016-05-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(882, 'Vanadzor', 'Vanadzor', 'Böyük Qarakilsə,Gharak''ilisa,Gharak’ilisa,Gorad Vanadzor,Karakhs,Karakilis,Karaklis,Kirovakan,Kirowakan,Korovakan,Mets Karakilisa,Vanadzor,Vanadzoras,Vanajor,Wanadsor,Wanadzor,banajoleu,vanadzori,vu~anazoru,wa na zuo er,wanadzwr,Ванадзор,Горад Ванадзор,Кировакан,Վանաձոր,وانادزور,ვანაძორი,ヴァナゾル,瓦纳佐尔,바나조르', 40.8045600, 44.4939000, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(883, 'Hnaberd', 'Hnaberd', 'Hnaberd,Khnaberd,Kirkhdagirman,Kyrkhdagirman,Хнаберд,Հնաբերդ', 40.6372100, 44.1405800, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(884, 'Khasht’arrak', 'Khasht''arrak', 'Hastarak,Həştərək,Khasht''arrak,Khashtarak,Khasht’arrak,Хаштарак,Խաշթառակ', 40.9366800, 45.1821000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(885, 'Kasakh', 'Kasakh', 'Chamrlu,Chamyrlu,Kasakh,Касах', 40.5369700, 44.4104600, 'AM', '2012-01-17', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(886, 'Karchaghbyur', 'Karchaghbyur', 'Gedakbulag,Karcagbyur,Karchaghbyur,Karchaghpyur,Karchakhpjur,Karchakhpyur,Карчахпюр,Կարճաղբյուր', 40.1704800, 45.5778500, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(887, 'Karbi', 'Karbi', 'Karbi,Карби,Կարբի', 40.3306900, 44.3779300, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(888, 'Karanlukh', 'Karanlukh', 'Karanlukh,Verkhniy Karanlug', 40.1044400, 45.2897200, 'AM', '2012-01-17', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(889, 'Kaputan', 'Kaputan', 'Geykilisa,Gëykilisa,Kaputan,Капутан,Կապուտան', 40.3250700, 44.7000700, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(890, 'K’anak’erravan', 'K''anak''erravan', 'K''anak''erravan,Kanakeravan,Kenaker,Kenakeravan,K’anak’erravan,Murad Tapa,Քանաքեռավան', 40.2473900, 44.5351100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(891, 'Kamo', 'Kamo', 'Gadzhi Nazar,Kamo,Камо,Կամո', 40.8257200, 43.9507100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(892, 'Gavarr', 'Gavarr', 'Gavar,Gavarr,Kamo,Kyavar,Nor-Bajaset,Novo Bayazet,Гавар,Камо,Գավառ', 40.3539800, 45.1238600, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(893, 'Mayisyan', 'Mayisyan', 'Imeni Beriya,Imeni Zhdanova,Mayisyan,Zhdanov,Жданов,Մայիսյան', 40.1570100, 44.0919200, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(894, 'Shahumyan', 'Shahumyan', 'Imeni Shaumyana,Sahumyan,Shahumian,Shahumyan,Shahumyani Anvan Avazan,Shaumjan,Shaumyan,Шаумян,Շահումյան', 40.7748200, 44.5459600, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(895, 'Ijevan', 'Ijevan', 'Icevan,Iczewan,Idjevan,Idschewan,Idzevan,Idzevanas,Idzhevan,Idževan,Idževanas,Igevano,Ijevan,Istibulagh,Iĝevano,K''aravansaray,K''arvansara,Karavan Savan,Karavansarai,Karvansara,Karvansaray,K’aravansaray,K’arvansara,ayjwan,ijeban,ijevana,ijevani,ijevu~an,yi jie wan,İcevan,Іджеван,Иджеван,Иџеван,Իջեվան,Իջևան,ایجوان,ਇਜੇਵਾਨ,იჯევანი,イジェヴァン,伊杰万,이제반', 40.8787700, 45.1485100, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(896, 'Hrazdan', 'Hrazdan', 'Akhta,Akhtala,Akhti,Asagi Axta,Aşağı Axta,Hrasdan,Hrazdan,Hrazdanas,Khrazdan,Nerkin Akhta,Nizhne Akhti,Nizhniye Akhty,Nizhnyaya Akhta,Razdan,harajadana,he la zi dan,heulajeudan,hrazdan,razdani,Раздан,Храздан,Հրազդան,הרזדאן,هرازدان,ہرازدان,ਹਰਾਜਦਾਨ,რაზდანი,赫拉茲丹,흐라즈단', 40.4974800, 44.7662000, 'AM', '2011-03-28', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(897, 'Armavir', 'Armavir', 'Armavir,Armaviras,Armaviro,Armawir,Armawîr,Hoktemberyan,Oktember,Oktemberyan,Sardar-Abad,Sardarapat,Sərdarabad,a er ma wei er,aleumabileu,armaviri,armawyr,arumavu~iru,Армавир,Армавір,Октембер,Արմավիր,آرماویر,არმავირი,アルマヴィル,阿爾馬維爾,아르마비르', 40.1544600, 44.0381500, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(898, 'Hayanist', 'Hayanist', 'Dostlug,Hayanist,Հայանիստ', 40.1223100, 44.3779300, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(899, 'Haghartsin', 'Haghartsin', 'Dzharkhech,Dzharkhedzh,Hagarcin,Haghardzin,Haghartsin,Kujbyshev,Kuybishev,Kuybyshev,Куйбышев,Հաղարծին', 40.7761400, 44.9684700, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(900, 'Gyumri', 'Gyumri', 'Alek''pol,Alek''sandrapol,Alek''sandrobol,Aleksandropol'',Aleksandropol’,Alek’pol,Alek’sandrapol,Alek’sandrobol,Alexandropol'',Alexandropol’,Ghiumri,Gimri,Giumri,Gjoemri,Gjumri,Gorad Gjumry,Guemrue,Gumri,Gumru,Gumry,Gyumri,Gümrü,Kumayri,Kumri,Kyumayri,Kyumri,Kümri,LWN,Leninakan,ghywmry,giumri,gyumeuli,gyumuri,gywmry,jiu mu li,Горад Гюмры,Гюмри,Гјумри,Ґюмрі,Գյումրի,غيومري,گیومری,გიუმრი,ギュムリ,久姆里,규므리', 40.7942000, 43.8452800, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(901, 'Gyulagarak', 'Gyulagarak', 'Gjulagarak,Gyulabarrak,Gyulagarak,Gyulagorak,Гюлагарак,Գյուլագարակ', 40.9671500, 44.4714400, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(902, 'Ghukasavan', 'Ghukasavan', 'Ghukasavan,Gukasavan,Kalara,Гукасаван,Ղուկասավան', 40.1279300, 44.4166900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(903, 'Geghamasar', 'Geghamasar', 'Gegamasar,Geghamasar,Gukarrich,Shishkaja,Shishkaya,Sisqaya,Şişqaya,Шишкая,Գեղամասար', 40.3109100, 45.6792400, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(904, 'Gugark’', 'Gugark''', 'Gugark,Gugark'',Gugark’,Meghrut,Megrut,Yagublu,Гугарк,Գուգարք', 40.8046000, 44.5402500, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(905, 'Tsiatsan', 'Tsiatsan', 'Ciacan,Grampa,Tsiatsan,Циацан,Ծիածան', 40.1861000, 44.2694700, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(906, 'Goght’', 'Goght''', 'Goght'',Goght’,Gokht,Գողթ', 40.1347000, 44.7833200, 'AM', '2016-05-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(907, 'Gogaran', 'Gogaran', 'Geran,Gogaran,Gëran,Гогаран,Գոգարան', 40.8925500, 44.1991500, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(908, 'Getazat', 'Getazat', 'Agdzhakishlag,Getashen,Getazat,Гетазат,Գետազատ', 40.0384400, 44.5636900, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(909, 'Getashen', 'Getashen', 'Dzhafarabat,Getasen,Getashen,Kalagar,Геташен,Գետաշեն', 40.0444900, 43.9417100, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(910, 'Geghanist', 'Geghanist', 'Geganist,Geghanist,Gekhanist,Getapnia,Geygmbet,Gëygmbet,Геханист,Գեղանիստ', 40.1458700, 44.4304800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(911, 'Geghamavan', 'Geghamavan', 'Gegamavan,Geghamavan,Shagriz,Гегамаван,Գեղամավան', 40.5625000, 44.8889200, 'AM', '2016-09-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(912, 'Garrni', 'Garrni', 'Bash Gyarni,Garni,Garrni,Гарни,Գառնի', 40.1193100, 44.7344200, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(913, 'Gagarin', 'Gagarin', 'Gagarin,Гагарин,Գագարին', 40.5402600, 44.8696200, 'AM', '2016-09-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(914, 'Fantan', 'Fantan', 'Fantan,Fontan,Ֆանտան', 40.3944700, 44.6861000, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(915, 'Fioletovo', 'Fioletovo', 'Fioletovo,Nikitino,Фиолетово,Ֆիոլետովո', 40.7224100, 44.7176900, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(916, 'Dzoraghbyur', 'Dzoraghbyur', 'Dzhorakhpyur,Dzoraghbyur,Dzoraghp''yur,Dzoraghp’yur,Dzorakhbjur,Dzorakhpyur,Joragbyur,Tedshirabad,Tedzhirabad,Tedzhrabak,Дзорахбюр,Ձորաղբյուր', 40.2041200, 44.6415000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(917, 'Dzoragyugh', 'Dzoragyugh', 'Dvoragyukh,Dzoraget,Dzoragyugh,Dzoragyukh,Joragyug,Vali Agalu,Дзорагет,Ձորագյուղ', 40.1695700, 45.1833700, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(918, 'Dzit’hank’ov', 'Dzit''hank''ov', 'Bazirkhana,Dzit''hank''ov,Dzitankov,Dzitkhankov,Dzit’hank’ov,Дзитанков,Ձիթհանքով', 40.5084800, 43.8209200, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(919, 'Jrashen', 'Jrashen', 'Dzhrashen,Jrasen,Jrashen,Vardnav,Vordnav,Vortnav,Джрашен,Ջրաշեն', 40.7902800, 44.1866400, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(920, 'Jrashen', 'Jrashen', 'Dzhrashen,Jrasen,Jrashen,Nor Dzhrashen,Джрашен,Ջրաշեն', 40.0527500, 44.5125900, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(921, 'Jrahovit', 'Jrahovit', 'Dzhabachalu,Dzharovit,Dzhraovit,Jrahovit,Джаровит,Ջրահովիտ', 40.0473000, 44.4751000, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(922, 'Janfida', 'Janfida', 'Dzhanfida,Janfida,Джанфида,Ջանֆիդա', 40.0444900, 44.0278900, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(923, 'Dvin', 'Dvin', 'Dvin,Dvin Armyanskiy,Nerkin Dvin,Nizhniy Dvin,Двин,Դվին', 40.0198400, 44.5837600, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(924, 'Dsegh', 'Dsegh', 'Dseg,Dsegh,Dsekh,Tumanyan,Дсех,Դսեղ', 40.9617000, 44.6500300, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(925, 'Drakhtik', 'Drakhtik', 'Drakhtik,Draxtik,Tokhludzha,Тохлуджа,Դրախտիկ', 40.5649700, 45.2367000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(926, 'Doghs', 'Doghs', 'Doghs,Dogs,Dokhs,Դողս', 40.2222900, 44.2722800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(927, 'Dilijan', 'Dilijan', 'Delijan,Delishan,Delizhan,Dili,Dili P''ok''r,Dili P’ok’r,Dilican,Dilichan,Dilidjan,Dilidschan,Dilidzan,Dilidzhan,Dilidżan,Dilidžan,Diligano,Dilijan,Dilishan,Dilizanas,Dilizhan,Diliĝano,Diližanas,Hin,Tili,Tilichan,di li ran,dilijani,dylyjan,Дилиджан,Дилижан,Дилиџан,Діліжан,Դիլիջան,دیلیجان,დილიჯანი,迪利然', 40.7417000, 44.8501000, 'AM', '2016-09-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(928, 'Ddmashen', 'Ddmashen', 'Ddmasen,Ddmashen,Dodmashen,Totmashen,Ддмашен,Դդմաշեն', 40.5702800, 44.8229500, 'AM', '2016-09-08', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(929, 'Darpas', 'Darpas', 'Darbas,Darpas,Дарпас,Դարպաս', 40.8367400, 44.4249400, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(930, 'Dalarik', 'Dalarik', 'Dalarik,Mastara,Даларик,Դալարիկ', 40.2279000, 43.8779300, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(931, 'Chochkan', 'Chochkan', 'Chochkan,Cockan,Ճոճկան', 41.1811800, 44.8321700, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(932, 'Chambarak', 'Chambarak', 'Chambarak,Kraside,Krasnosel''sk,Krasnosel’sk,Krasnoye,Mikhaylovka,Чамбарак', 40.5965500, 45.3549800, 'AM', '2014-06-26', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(933, 'Bjni', 'Bjni', 'Bjni,Bzhni,Բջնի', 40.4583100, 44.6500800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(934, 'Byureghavan', 'Byureghavan', 'Bjuregavan,Byuregavan,Byureghavan,Бюрегаван,Բյուրեղավան', 40.3141700, 44.5933300, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(935, 'Byurakan', 'Byurakan', 'Biurakan,Bjurakan,Burakan,Byurakan,Бюракан,Բյուրական', 40.3389400, 44.2727500, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(936, 'Buzhakan', 'Buzhakan', 'Babakishi,Buzakan,Buzhakan,Бужакан,Բուժական', 40.4556900, 44.5194700, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(937, 'Berd', 'Berd', 'Berd,Berrdagyugh,Berrdgyugh,Bert,Ghalak''yand,Ghalak’yand,Shlorut,T''auzk''end,T''auzkala,T''avuzghala,T''ous,T''ous Gale,T''ovuz,T''uzukala,Taua Kale,Taya-Kala,Tovuz,Tovuzkala,Tovuzqala,T’auzkala,T’auzk’end,T’avuzghala,T’ous,T’ous Gale,T’ovuz,T’uzukala,Volorut,Берд,Товуз,Բերդ', 40.8813500, 45.3890100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(938, 'Bazum', 'Bazum', 'Bazum,Bzovdal,Базум,Բազում', 40.8676300, 44.4397800, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(939, 'Byuravan', 'Byuravan', 'Bambakavan,Bjuravan,Byuravan,Verin Kuylasar,Verkhniy Kuylasar,Бюраван,Բյուրավան', 40.0160400, 44.5188900, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(940, 'Bambakashat', 'Bambakashat', 'Bambakasat,Bambakashat,Molla Bayazet,Бамбакашат,Բամբակաշատ', 40.1082800, 44.0194700, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(941, 'Balahovit', 'Balahovit', 'Balahovit,Balakhovit,Balaovit,Mehub,Mekhub,Mgub,Балаовит,Балаховит,Բալահովիտ', 40.2515300, 44.6082800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(942, 'Bagratashen', 'Bagratashen', 'Bagratasen,Bagratashen,Debedashen,Debetashen,Lambalu,Баграташен,Բագրատաշեն', 41.2435800, 44.8173700, 'AM', '2013-11-29', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(943, 'Azatan', 'Azatan', 'Azatan,Karakhs,Karakilisa,Pokr Karakilisa,Азатан,Ազատան', 40.7195900, 43.8272700, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(944, 'Haykavan', 'Haykavan', 'Ajkavan,Aykavan,Badzhogli,Haykavan,Айкаван', 40.8031200, 43.7517300, 'AM', '2012-01-17', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(945, 'Aygestan', 'Aygestan', 'Ajgestan,Ayaslu,Aygestan,Айгестан,Այգեստան', 40.0029300, 44.5582900, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(946, 'Aygeshat', 'Aygeshat', 'Ajgeshat,Aygesat,Aygeshat,Gadzhikara,Айгешат,Այգեշատ', 40.2360800, 44.2888800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(947, 'Aygeshat', 'Aygeshat', 'Ajgeshat,Aygesat,Aygeshat,Kuzigidan,Айгешат,Այգեշատ', 40.0750700, 44.0611000, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(948, 'Aknalich', 'Aknalich', 'Aknalic,Aknalich,Aygerlich,Акналич,Ակնալիճ', 40.1472800, 44.1666900, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(949, 'Aygehovit', 'Aygehovit', 'Ajgeovit,Aygehovit,Aygeovit,Ayqeovit,Onut,Uzuntala,Айгеовит,Այգեհովիտ', 40.9795100, 45.2503300, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(950, 'Artimet', 'Artimet', 'Alibeklu,Artimet,Atarbekyan,Артимет,Արտիմետ', 40.1500800, 44.2667200, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(951, 'Astghadzor', 'Astghadzor', 'Alikrykh,Astgajor,Astghadzor,Astkhadzor,Астхадзор,Աստղաձոր', 40.1223100, 45.3555300, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(952, 'Ashtarak', 'Ashtarak', 'Achtarak,Aschtarak,Ashharak,Ashtarak,Ashtarakats'' Gyugh,Ashtarakats’ Gyugh,Astarak,Astarakas,Astarako,Asztarak,Aŝtarako,Aştarak,Aštarak,Aštarakas,Aștarak,a shen ta la ke,asataraka,ashtarak,ashutaraku,asyutalakeu,Əştərək,Аштарак,Ащарак,Աշտարակ,آشتاراك,آشتاراک,ਅਸ਼ਤਾਰਕ,აშტარაკი,アシュタラク,阿什塔拉克,아슈타라크', 40.2991000, 44.3620400, 'AM', '2016-10-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(953, 'Ashnak', 'Ashnak', 'Ashnak,Asnak,Ашнак,Աշնակ', 40.3306900, 43.9166900, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(954, 'Arzni', 'Arzni', 'Arzni,Арзни,Արզնի', 40.2973000, 44.5986900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(955, 'Arzakan', 'Arzakan', 'Arzakan,Arzakyand,Арзакан,Արզական', 40.4500700, 44.6082800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(956, 'Arteni', 'Arteni', 'Arteni,Bogutlu,Артени,Արտենի', 40.2973000, 43.7667200, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(957, 'Arshaluys', 'Arshaluys', 'Arsaluys,Arshalujs,Arshaluys,Kerpalu,Kërpalu,Аршалуйс,Արշալույս', 40.1694900, 44.2139300, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(958, 'Argel', 'Argel', 'Argel,Arkel,Lusakert,Аргел,Արգել', 40.3779300, 44.6001000, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(959, 'Argavand', 'Argavand', 'Argavand,Dzhafarapat,Аргаванд,Արգավանդ', 40.1528900, 44.4389000, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(960, 'Argavand', 'Argavand', 'Argavand,Uzunoba,Аргаванд,Արգավանդ', 40.0611000, 44.0944800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(961, 'Arevshat', 'Arevshat', 'Arevsat,Arevshat,Yekan,Yekanlar,Аревшат,Արևշատ', 40.6534500, 44.0441900, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(962, 'Arevshat', 'Arevshat', 'Arevsat,Arevshat,Arpavar,Lusakert,Nerkin Agbash,Nizhniy Agbash,Аревшат,Արևշատ', 40.0396300, 44.5417900, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(963, 'Arevik', 'Arevik', 'Arevik,Tapadolag,Tapadolak,Аревик,Արևիկ', 40.7417000, 43.9043000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(964, 'Arevik', 'Arevik', 'Agdzharkh,Arevik,Аревик,Արևիկ', 40.1001000, 44.0944800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(965, 'Arevashogh', 'Arevashogh', 'Arevashogh,Arevashokh,Arevasog,Chigdamal,Chikdamal,Аревашох,Արևաշող', 40.8603900, 44.2743800, 'AM', '2016-12-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(966, 'Arevashat', 'Arevashat', 'Arevasat,Arevashat,Arevashet,Varmaziar,Аревашат,Արևաշատ', 40.1444700, 44.3751200, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(967, 'Archis', 'Archis', 'Archis,Arcis,Արճիս', 41.1635100, 44.8763100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(968, 'Arbat’', 'Arbat''', 'Arbat'',Arbat’,Արբաթ', 40.1389200, 44.4028900, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(969, 'Arazap’', 'Arazap''', 'Arazap,Arazap'',Arazap’,Evdzhilar,Аразап,Արազափ', 40.0416900, 44.1472800, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(970, 'Arrap’i', 'Arrap''i', 'Arapi,Arrap''i,Arrap’i,Odzhakhkuli,Առափի', 40.7827600, 43.8058300, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(971, 'Aramus', 'Aramus', 'Aramus,Արամուս', 40.2509500, 44.6635100, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(972, 'Arak’s', 'Arak''s', 'Arak''s,Arak’s,Nerkin Karkhun,Nizhniy Karkhun,Արաքս', 40.0554800, 44.3029200, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(973, 'Aragats', 'Aragats', 'Aragac,Aragats,Kaznafar,Арагац,Արագած', 40.4888900, 44.3529000, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(974, 'Aparan', 'Aparan', 'Abaran,Abaran Verin,Aparan,Aparan Verin,Aparanas,Aparanbol,Aparanpol,Bash Abaran,Bash Aparan,Dash Abaron,K''asagh,K''asakh,K’asagh,K’asakh,P''araznavert,Pash Aparan,P’araznavert,a pa lan,abaran,aparan,Апаран,Ապարան,آپاران,أباران,აპარანი,阿帕蘭', 40.5932300, 44.3589000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(975, 'Apaga', 'Apaga', 'Apaga,Verin Turkmenlu,Апага,Ապագա', 40.0972900, 44.2529300, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(976, 'Anushavan', 'Anushavan', 'Anusavan,Anushavan,Parni,Pokr Parni,Анушаван,Անուշավան', 40.6500800, 43.9805300, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(977, 'Amasia', 'Amasia', 'Amasia,Amasija,Amasiya,Gukasyan,Амасия,Ամասիա', 40.9544200, 43.7872000, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(978, 'Alaverdi', 'Alaverdi', 'Alaverdi,Alaverdo,Alaverdy,Alawerdi,Alawerdy,Allahverdi,Allaverdy,Manes,a la wei er di,alaverdi,Алаверди,Алаверді,Ալավերդի,الله‌وردی,ალავერდი,阿拉韋爾迪', 41.0976600, 44.6731600, 'AM', '2011-01-29', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(979, 'Akunk’', 'Akunk''', 'Akunk'',Akunk’,Bashgyukh,Ակունք', 40.2667200, 44.6861000, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(980, 'Akunk’', 'Akunk''', 'Akunk'',Akunk’,Kirkhbulag,Ակունք', 40.1588600, 45.7256800, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(981, 'Akhuryan', 'Akhuryan', 'Akhurjan,Akhuryan,Axuryan,Duzk''end,Duzk''end Mets,Duzk''yand,Duzk’end,Duzk’end Mets,Duzk’yand,Ахурян,Ախուրյան', 40.7800300, 43.9002700, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(982, 'Aghavnatun', 'Aghavnatun', 'Agavnatun,Aghavnatun,Akhavnatukh,Akhavnatun,Агавнатун,Ахавнатун,Աղավնատուն', 40.2333000, 44.2529500, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(983, 'Aghavnadzor', 'Aghavnadzor', 'Agavnadzor,Aghavnadzor,Akhavnadzor,Babakishi,Агавнадзор', 40.5819500, 44.6958100, 'AM', '2012-01-17', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(984, 'Agarak', 'Agarak', 'Agarak,Ագարակ', 41.0107200, 44.4684500, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(985, 'Agarakavan', 'Agarakavan', 'Agarak,Agarakavan,Ագարակավան', 40.3306900, 44.0723300, 'AM', '2016-05-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(986, 'Abovyan', 'Abovyan', 'Abovian,Abovianas,Abovjan,Abovyan,Abowian,Abowjan,Abowyan,Elar,Ellər,a bo wei yang,aboviani,abwfyan  ararat,abwwyan,Абовян,Абовјан,Աբովյան,آبوویان,أبوفيان، أرارات,აბოვიანი,阿博維揚', 40.2736800, 44.6334800, 'AM', '2016-04-10', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(987, 'Abovyan', 'Abovyan', 'Abovjan,Abovyan,Agbash,Verin Agbash,Verkhniy Agbash,Абовян,Աբովյան', 40.0485100, 44.5474200, 'AM', '2016-11-22', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(988, 'Vardablur', 'Vardablur', 'Vardablur,Verdablur,Вардаблур', 40.9708300, 44.5088900, 'AM', '2012-01-19', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(989, 'Bardzrashen', 'Bardzrashen', 'Bardzrashen,Barjrasen,Bartsrashen,Բարձրաշեն', 40.0853300, 44.5795700, 'AM', '2016-11-23', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(990, 'Nshavan', 'Nshavan', 'Nsavan,Nshavan,Նշավան', 40.0278700, 44.5256500, 'AM', '2016-11-23', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(991, 'Norabats’', 'Norabats''', 'Norabats'',Norabats’,Norashen,Նորաբաց', 40.1055300, 44.4332900, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(992, 'Berdavan', 'Berdavan', 'Berdavan', 41.2050300, 44.9996700, 'AM', '2012-01-19', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(993, 'Shirakamut', 'Shirakamut', 'Shirakamut,Ширакамут', 40.8605600, 44.1527800, 'AM', '2012-01-19', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(994, 'Azatamut', 'Azatamut', 'Azanut,Azatamut,Азанут', 40.9820400, 45.1855100, 'AM', '2014-06-27', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(995, 'Getahovit', 'Getahovit', 'Getahovit,Getaovit', 40.8978400, 45.1397100, 'AM', '2013-09-09', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(996, 'Artsvaberd', 'Artsvaberd', 'Arcvaberd,Artsvaberd,Арцваберд', 40.8394700, 45.4703300, 'AM', '2013-09-09', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(997, 'Nor Yerznka', 'Nor Yerznka', 'Nor Erznka,Nor Yerznka,Նոր Երզնկա', 40.3001100, 44.3889200, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(998, 'Sasunik', 'Sasunik', 'Nor Sasunik,Sasunik,Սասունիկ', 40.2501200, 44.3444800, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(999, 'Kamaris', 'Kamaris', 'Kamaris', 40.2353900, 44.6945900, 'AM', '2012-01-19', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1000, 'Gandzak', 'Gandzak', 'Gandzak', 40.3147200, 45.1113900, 'AM', '2012-05-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1001, 'Myasnikyan', 'Myasnikyan', 'Mjasnikjan,Myasnikyan,Мясникян,Մյասնիկյան', 40.1804800, 43.9194900, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1002, 'Lenughi', 'Lenughi', 'Lenughi,Lenugi,Լենուղի', 40.1251200, 43.9639300, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1003, 'Metsamor', 'Metsamor', 'Mecamor,Metsamor,Мецамор,Մեծամոր', 40.1444700, 44.1167000, 'AM', '2016-08-03', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1004, 'Gay', 'Gay', 'Gay', 40.0844400, 44.3052800, 'AM', '2013-08-07', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1005, 'Baghramyan', 'Baghramyan', 'Baghramyan,Bagramyan,Բաղրամյան', 40.1945200, 44.3695100, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1006, 'Musalerr', 'Musalerr', 'Musaler,Musalerr,Մուսալեռ', 40.1557000, 44.3779300, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1007, 'Darakert', 'Darakert', 'Darakert,Դարակերտ', 40.1055300, 44.4138800, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1008, 'Dashtavan', 'Dashtavan', 'Dashtavan,Dastavan,Դաշտավան', 40.1001000, 44.3917200, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1009, 'Nizami', 'Nizami', 'Nizami,Նիզամի', 40.0916800, 44.4057000, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1010, 'Artsvanist', 'Artsvanist', 'Artsvanist', 40.1461700, 45.5171100, 'AM', '2015-09-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1011, 'Vardadzor', 'Vardadzor', 'Vardadzor', 40.1870100, 45.1921200, 'AM', '2012-05-06', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1012, 'Taronik', 'Taronik', 'Taronik', 40.1336700, 44.1995700, 'AM', '2012-01-20', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1013, 'Aknashen', 'Aknashen', 'Aknashen', 40.0955100, 44.2860400, 'AM', '2012-01-20', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1014, 'Haykashen', 'Haykashen', 'Aykashen,Haykasen,Haykashen,Հայկաշեն', 40.0723300, 44.3082900, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1015, 'Hovtashat', 'Hovtashat', 'Hovtasat,Hovtashat,Ovtashat,Հովտաշատ', 40.0972900, 44.3444800, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1016, 'Sayat’-Nova', 'Sayat''-Nova', 'Sayat''-Nova,Sayat’-Nova,Սայաթ-Նովա', 40.0750700, 44.4000800, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1017, 'Voskehat', 'Voskehat', 'Oskehat,Voskeat,Voskehat,Ոսկեհատ', 40.1417200, 44.3306900, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1018, 'Griboyedov', 'Griboyedov', 'Griboyedov', 40.1130700, 44.2716900, 'AM', '2012-01-20', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1019, 'Gmbet’', 'Gmbet''', 'Amberd,Gmbet'',Gmbet’,Ամբերդ', 40.2236900, 44.2540900, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1020, 'Aygek', 'Aygek', 'Aygek,Այգեկ', 40.1889000, 44.3861100, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1021, 'Hovtashen', 'Hovtashen', 'Hovtasen,Hovtashen,Ovtashen,Հովտաշեն', 40.0250800, 44.4500700, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1022, 'Dimitrov', 'Dimitrov', 'Dimitrov,Դիմիտրով', 40.0084800, 44.4917000, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1023, 'Mrgavet', 'Mrgavet', 'Mrgavet,Մրգավետ', 40.0278900, 44.4832800, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1024, 'Arevabuyr', 'Arevabuyr', 'Arevabuyr,Արևաբույր', 40.0360700, 44.4694800, 'AM', '2016-04-11', 12);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2034, 'Aūa', 'Aua', 'Aua,`Ava Point', -14.2761100, -170.6638900, 'AS', '2010-10-12', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2035, 'Vaitogi', 'Vaitogi', '', -14.3588900, -170.7347200, 'AS', '2010-10-12', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2036, 'Vailoatai', 'Vailoatai', 'Vailoa', -14.3611100, -170.7822200, 'AS', '2014-10-08', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2037, 'Taulaga', 'Taulaga', '', -11.0552800, -171.0883300, 'AS', '2012-02-19', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2038, 'Ta`ū', 'Ta`u', 'Opoun,Ta`u,Ta`ue Village,Ta`ü Village,Tau', -14.2336100, -169.5144400, 'AS', '2013-08-02', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2039, 'Tāfuna', 'Tafuna', 'Tafuna,Тафуна', -14.3358300, -170.7200000, 'AS', '2010-09-05', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2040, 'Faleniu', 'Faleniu', '', -14.3325000, -170.7444400, 'AS', '2010-10-12', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2041, 'Fagatogo', 'Fagatogo', 'Fagatogo,Fanga Tonga,Фагатого', -14.2825000, -170.6900000, 'AS', '2010-10-12', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2042, 'Faleāsao', 'Faleasao', 'Faleasao,Faleasau', -14.2222000, -169.5127800, 'AS', '2012-02-02', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2043, 'Leone', 'Leone', '', -14.3438900, -170.7850000, 'AS', '2010-10-12', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2044, 'Malaeimi', 'Malaeimi', '', -14.3227800, -170.7338900, 'AS', '2010-09-05', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2045, 'Mapusagafou', 'Mapusagafou', '', -14.3305600, -170.7527800, 'AS', '2010-10-12', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2046, 'Ofu', 'Ofu', 'OFU', -14.1752800, -169.6775000, 'AS', '2012-02-03', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2047, 'Pago Pago', 'Pago Pago', 'Gorad Paga-Paga,PPG,Pago Pago,Pago-Pago,PagoPago,Pagopago,Pagó Pagó,Panko Panko,Paqo Paqo,baghw baghw,pa guo pa guo,pa ko pa ko,pagopago,pagw pagw,pako pako,pango pango,Πάγκο Πάγκο,Горад Пага-Пага,Паго Паго,Паго-Паго,Пагопаго,Պագո Պագո,פאגו פאגו,باغو باغو,پاگو پاگو,पांगो पांगो,பாகோ பாகோ,ปาโกปาโก,პაგო-პაგო,パゴパゴ,帕果帕果,파고파고', -14.2780600, -170.7025000, 'AS', '2011-08-29', 5);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1425, 'Uriburu', 'Uriburu', 'Uriburu', -36.5068200, -63.8622500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1426, 'Unquillo', 'Unquillo', 'Unquillo', -31.2307300, -64.3161500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1427, 'Unión', 'Union', 'Union,Unión', -35.1528200, -65.9460200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1428, 'Ulapes', 'Ulapes', 'Ulapes', -31.5736200, -66.2365000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1429, 'Ucacha', 'Ucacha', '', -33.0320300, -63.5066600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1430, 'Tupungato', 'Tupungato', 'Tupungata,Tupungato,Villa Tupungato', -33.3714600, -69.1484500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1431, 'Tunuyán', 'Tunuyan', 'Tunuyan,Tunuyán', -33.5765300, -69.0153800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1432, 'Tumbaya', 'Tumbaya', 'Tumbaya', -23.8562600, -65.4574100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1433, 'Trevelin', 'Trevelin', 'Trevelin,Trevelina,Trevelinas,Trevelín', -43.0858000, -71.4638600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1434, 'Tres Lomas', 'Tres Lomas', 'Jose M. Blanco,Jose Maria Blanco,José M. Blanco,José María Blanco,Tres Lomas', -36.4572200, -62.8604700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1435, 'Tres Isletas', 'Tres Isletas', 'Tres Isletas', -26.3406700, -60.4320700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1436, 'Tres Arroyos', 'Tres Arroyos', 'OYO,Tres Arojosas,Tres Arroyos,te lei si a luo yue si,trs arwyws,trys arwyws,ترس آرویوس,تريس آرويوس,特雷斯阿羅約斯', -38.3739400, -60.2797800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1437, 'Tres Algarrobos', 'Tres Algarrobos', 'Tres Algarrobos', -35.1947100, -62.7739600, 'AR', '2016-11-29', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1438, 'Trenque Lauquen', 'Trenque Lauquen', 'T. Lauquen,Trenque Lauquen,te lun ke lao ken,trnkh laywkn,trynkyw laykywn,ترنکه لائوکن,ترينكيو لايكيون,特倫克勞肯', -35.9703500, -62.7343200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1439, 'Trenel', 'Trenel', 'Trenel', -35.6983700, -64.1321800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1440, 'Trelew', 'Trelew', 'REL,Trelew,Trelju,te lei li wu,teulelle-u,torereu,trlyw,trylyw,טרלאו,ترلئو,تريليو,ტრელევი,トレレウ,特雷利烏,트렐레우', -43.2489500, -65.3050500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1441, 'Trancas', 'Trancas', 'Trancas', -26.2157500, -65.2849200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1442, 'Totoras', 'Totoras', 'Santa Teresa,Totoras', -32.5844000, -61.1685200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1443, 'Tostado', 'Tostado', 'Tostado', -29.2320200, -61.7691700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1444, 'Tornquist', 'Tornquist', 'Tornquist,tuo en ji si te,托恩基斯特', -38.1012200, -62.2226700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1445, 'Toledo', 'Toledo', '', -31.5557400, -64.0094700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1446, 'Toay', 'Toay', 'Toay', -36.6733800, -64.3786000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1447, 'Tío Pujio', 'Tio Pujio', '', -32.2879000, -63.3559800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1448, 'Tintina', 'Tintina', 'Tintina', -27.0333300, -62.7166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1449, 'Tinogasta', 'Tinogasta', 'Tinogasta,di nuo jia si ta,Τινογάστα,蒂諾加斯塔', -28.0631900, -67.5648800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1450, 'Tilisarao', 'Tilisarao', 'Tilisarao', -32.7329200, -65.2910900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1451, 'Tilcara', 'Tilcara', 'Tilcara', -23.5775700, -65.3509000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1452, 'Ticino', 'Ticino', '', -32.6935000, -63.4360600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1453, 'Termas de Río Hondo', 'Termas de Rio Hondo', 'Banos,Baños,Las Termas,Las Termas de Rio Hondo,Las Termas de Río Hondo,RHD,Termas de Rio Hondo,Termas de Río Hondo,Termas del Rio Hondo,Termas del Río Hondo', -27.4936200, -64.8597200, 'AR', '2017-03-25', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1454, 'Telsen', 'Telsen', 'Telsen', -42.4355300, -66.9407800, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1455, 'Telén', 'Telen', 'Telen,Telén', -36.2642900, -65.5101800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1456, 'Tecka', 'Tecka', 'Tecka', -43.4948900, -70.8102000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1457, 'Tartagal', 'Tartagal', 'TTG,Tartagal,Tartagalis,ta ta jia er,tartagal,tartghal,trtgl,Ταρταγάλ,Тартагал,טרטגל,تارتاگال,تارتغال,塔塔加爾', -22.5163700, -63.8013100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1458, 'Tapalqué', 'Tapalque', 'Tapalque,Tapalquen,Tapalqué,Tapalquén', -36.3549300, -60.0264000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1459, 'Tancacha', 'Tancacha', '', -32.2430900, -63.9807000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1460, 'Tamberías', 'Tamberias', 'Tamberia,Tamberias,Tambería,Tamberías', -31.4664600, -69.4255000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1461, 'Tama', 'Tama', 'Rosario del Tama,Tama', -30.5079800, -66.5298000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1462, 'Tafí Viejo', 'Tafi Viejo', 'Tafi,Tafi Viejo,Tafí,Tafí Viejo', -26.7320100, -65.2592100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1463, 'Tafí del Valle', 'Tafi del Valle', 'Tafi,Tafi del Valle,Tafí,Tafí del Valle', -26.8527500, -65.7098300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1464, 'Taco Pozo', 'Taco Pozo', 'Taco Pozo', -25.6166700, -63.2833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1465, 'Susques', 'Susques', '', -23.3986400, -66.3670100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1466, 'Suncho Corral', 'Suncho Corral', 'Suncha Corral,Suncho Corral', -27.9335700, -63.4293800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1467, 'Sunchales', 'Sunchales', 'NCJ,Sunchales', -30.9440400, -61.5614800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1468, 'Sumampa', 'Sumampa', 'Sumampa', -29.3847000, -63.4690700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1469, 'Simoca', 'Simoca', 'Simoca', -27.2627200, -65.3564700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1470, 'Sierra Grande', 'Sierra Grande', 'SGV,Sierra Grande', -41.6060300, -65.3557400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1471, 'Sierra Colorada', 'Sierra Colorada', 'Sierra Colorada,Sierra Colorado', -40.5848700, -67.7567400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1472, 'Serrezuela', 'Serrezuela', '', -30.6376100, -65.3869200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1473, 'Serrano', 'Serrano', '', -34.4697100, -63.5384200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1474, 'Senillosa', 'Senillosa', '', -39.0141200, -68.4328100, 'AR', '2015-12-09', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1475, 'Selva', 'Selva', 'Selva', -29.7677600, -62.0477000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1476, 'Seguí', 'Segui', 'Segui,Seguí', -31.9564200, -60.1248800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1477, 'Sebastián Elcano', 'Sebastian Elcano', '', -30.1610500, -63.5936000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1478, 'Saujil', 'Saujil', 'Saujil', -28.1744200, -66.2117700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1479, 'Saturnino M. Laspiur', 'Saturnino M. Laspiur', 'Santa Maria Laspiur,Saturnino M. Laspiur,Saturnio M. Laspiuro', -31.7028700, -62.4820200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1480, 'Sastre', 'Sastre', 'Sastre', -31.7676200, -61.8288700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1481, 'Sarmiento', 'Sarmiento', 'Colonia Sarmiento,OLN,Sarmiento,Sarmjentas,sa er mi en tuo,薩爾米恩托', -45.5881500, -69.0699600, 'AR', '2017-02-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1482, 'Santo Tomé', 'Santo Tome', 'Santo Tome,Santo Tomé,Santo Tomė', -31.6627400, -60.7653000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1483, 'Santiago Temple', 'Santiago Temple', 'Sagrado Temple,Santiago Temple', -31.3873100, -63.4182100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1484, 'Santiago del Estero', 'Santiago del Estero', 'Ciudad de Santiago del Estero,Gorad Santjaga-dehl''-Ehstehra,Provincia de Santiago del Estero,Província de Santiago del Estero,SDE,Sanctus Iacobus ad Uligines,Sant''jago-del''-Ehstero,Sant''jago-del''-Estero,Santiago del Estero,Santijago del Estero,Santjago del Esteras,Santjago del Estero,saintiyago dela estro,san teiy ko del xe s te ro,san tyagw dyl astyrw,santiagodel-eseutelo,santyaghw dyl astyrw,santyagw dl astrw,sheng de ya ge-de er ai si te luo,Горад Сантяга-дэль-Эстэра,Сантијаго дел Естеро,Сантьяго-дель-Естеро,Сантьяго-дель-Эстеро,Сантяго дел Естеро,Սանտիագո դել Էստերո,סנטיאגו דל אסטרו,سان تیاگو دیل استیرو,سانتياغو ديل استيرو,سانتیاگو دل استرو,सैन्टियागो डेल एस्त्रो,ซานเตียโกเดลเอสเตโร,სანტიაგო-დელ-ესტერო,サンティアゴ・デル・エステロ,圣地亚哥-德尔埃斯特罗,산티아고델에스테로', -27.7951100, -64.2614900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1485, 'Santa Victoria', 'Santa Victoria', 'Santa Victoria', -22.2500000, -64.9666700, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1486, 'Santa Sylvina', 'Santa Sylvina', 'Santa Silvina,Santa Sylvina', -27.8326100, -61.1374700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1487, 'Santa Rosa de Tastil', 'Santa Rosa de Tastil', 'Santa Rosa de Tastil,Tastil', -24.4516600, -65.9745200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1488, 'Santa Rosa de Río Primero', 'Santa Rosa de Rio Primero', 'Santa Rosa,Santa Rosa de Rio 1,Santa Rosa de Rio Primero,Santa Rosa de Río 1,Santa Rosa de Río Primero,Villa Santa Rosa', -31.1523100, -63.4019100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1489, 'Santa Rosa del Conlara', 'Santa Rosa del Conlara', 'Santa Rosa,Santa Rosa del Conlara', -32.3428600, -65.2032300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1490, 'Santa Rosa de Calamuchita', 'Santa Rosa de Calamuchita', 'Santa Rosa,Santa Rosa de Calamuchita,Santa Rosa de Calamuchito', -32.0690500, -64.5363100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1491, 'Santa Rosa', 'Santa Rosa', 'Ciudad de Santa Rosa,RSA,Sancta Rosa,Santa Rosa,Santa Rosa de Toaj,Santa Rosa de Toay,Santa-Rosa,santa rwsa,santa rwsa  la pampa,santa rwza,santa rwza  la bamba,santalosa,santarosa,sheng luo sha,snth rwsh,Санта Роса,Санта Роса де Тоај,Санта-Роса,Սանտա Ռոսա,סנטה רוסה,سانتا روزا,سانتا روزا، لا بامبا,سانتا روسا,سانتا روسا، لا پامپا,სანტა-როსა,サンタローサ,聖羅莎,산타로사', -36.6166700, -64.2833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1492, 'Santa Rosa', 'Santa Rosa', 'Santa Rosa,Santa-Rosa,Villa Santa Rosa,Санта-Роса', -33.2540700, -68.1493700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1493, 'Santa María', 'Santa Maria', 'Santa Maria,Santa María', -26.6954700, -66.0473200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1494, 'Santa Magdalena', 'Santa Magdalena', 'Jovita,Santa Magdalena', -34.5177600, -63.9440900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1495, 'Santa Lucía', 'Santa Lucia', 'Santa Lucia,Santa Lucía', -31.5398700, -68.4950300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1496, 'Santa Isabel', 'Santa Isabel', 'Santa Isabel', -36.2272400, -66.9424000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1497, 'Santa Fe de la Vera Cruz', 'Santa Fe de la Vera Cruz', 'Ciudad de Santa Fe,SFN,Santa Fe,Santa Fė,Santa-Fe,Санта Фе,Санта-Фе', -31.6333300, -60.7000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1498, 'Santa Eufemia', 'Santa Eufemia', '', -33.1765900, -63.2828100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1499, 'Santa Clara', 'Santa Clara', 'Santa Clara', -24.3092100, -64.6625300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1500, 'Santa Catalina', 'Santa Catalina', 'Santa Catalina', -21.9446700, -66.0521900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1501, 'San Salvador de Jujuy', 'San Salvador de Jujuy', 'Gorad San-Sal''vador-deh-Zhuzhuj,JUJ,Jujuy,Khukhuj,San Sal''vador de Khukhuj,San Sal''vador de Zhuzhuj,San Salvador de Chuchujus,San Salvador de Jujuy,San Salvador de Khukhuj,San Salvador de Xuxuy,San-Sal''vador-de-Zhuzhuj,Sanctus Salvator Soteriae,san salwadwr dh khwkhwyy,san salwadwr dl khwkhwyy,san slfadwr dy khwkhwy,san-salvador-de-khukhui,sansalbadoleudehuhu-i,sheng sa er wa duo-de hu hu yi,sn slbdwr dh hwhwy,Горад Сан-Сальвадор-дэ-Жужуй,Сан Салвадор де Хухуй,Сан Салвадор де Хухуј,Сан Сальвадор де Жужуй,Сан Сальвадор де Хухуй,Сан-Сальвадор-де-Жужуй,Хухуй,Սան Սալվադոր դե Խուխույ,סן סלבדור דה חוחוי,سان سالوادور دل خوخوئی,سان سالوادور ده خوخوئی,سان سلفادور دي خوخوي,سان سلوادور دی جوجوئے,სან-სალვადორ-დე-ხუხუი,サン・サルバドール・デ・フフイ,圣萨尔瓦多-德胡胡伊,산살바도르데후후이', -24.1945700, -65.2971200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1502, 'San Ramón de la Nueva Orán', 'San Ramon de la Nueva Oran', 'ORA,Oran,Orán,San Ramon de la Nueva Oran,San Ramon de la Nueva Oranas,San Ramón de la Nueva Orán,San-Ramon-de-la-Nuehva-Oran,ao lan,san ramwn dh la nwywa awran,san-ramon-de-la-nueva-orani,sanlamondelanuebaolan,whran  salta,Сан Рамон де ла Нуева Оран,Сан-Рамон-де-ла-Нуэва-Оран,Սան Ռամոն դե լա Նուևա Օրան,סן רמון דה לה נואבה אוראן,سان رامون ده لا نوئوا اوران,وهران، سالتا,სან-რამონ-დე-ლა-ნუევა-ორანი,奧蘭,산라몬데라누에바오란', -23.1370500, -64.3242600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1503, 'San Rafael', 'San Rafael', 'AFA,San Rafael,San Rafaelis,San-Rafaehl'',San-Rafael'',san rafayl,san rafayyl  mndwza,san-rapaeli,sheng la fei er,Сан Рафаел,Сан-Рафаель,Сан-Рафаэль,סן רפאל,سان رافائل,سان رافائيل، مندوزا,სან-რაფაელი,聖拉斐爾', -34.6177200, -68.3300700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1504, 'San Pedro', 'San Pedro', 'San Pedro', -27.9538600, -65.1665100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1505, 'San Pedro', 'San Pedro', 'San Pedro', -24.2312700, -64.8661400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1506, 'Sañogasta', 'Sanogasta', 'Sanogasta,Sañogasta', -29.0952000, -67.1158600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1507, 'San Nicolás de los Arroyos', 'San Nicolas de los Arroyos', 'San Nicolas,San Nicolas de los Arroyos,San Nicolás,San Nicolás de los Arroyos,San Nikolas de los Arojos,San Nikolas de los Arojosas,san ni ko lasdelo sxar ro yos,san nykwlas dh lws arwys,san nykwlas dy lws arwyws,sheng ni gu la si,Сан Николас де лос Аройос,סן ניקולאס דה לוס ארוזוס,سان نيكولاس دي لوس آرويوس,سان نیکولاس ده لوس آرویس,ซานนีโกลาสเดโลสอาร์โรโยส,სან-ნიკოლას-დე-ლოს-აროიოსი,圣尼古拉斯', -33.3357800, -60.2252300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1508, 'San Miguel de Tucumán', 'San Miguel de Tucuman', 'Gorad San-Migel''-deh-Tukuman,San Migel De Tukuman,San Migel de Tukuman,San Miguel de Tucuman,San Miguel de Tucumán,San Minkel nte Toukouman,San-Migel''-de-Tukuman,Sanctus Michael Tucumanensis,TUC,Tucuman,Tucumán,Tukuman,Tukumanas,san mi kelde tu ku man,san myghyl dy twkwman,san mygwyyl dy twkwman,sanmigeldetukuman,santyagw dwtwkwman,sheng mi ge er-de tu ku man,Σαν Μιγκέλ ντε Τουκουμάν,Горад Сан-Мігель-дэ-Тукуман,Сан Мигел де Тукуман,Сан-Мигель-де-Тукуман,Сан-Мігель-де-Тукуман,Тукуман,Տուկուման,טוקומאן,سان ميغيل دي توكومان,سان میگوئیل دی توکومان,سانتیاگو دوتوکومان,ซานมีเกลเดตูกูมัน,სან-მიგელ-დე-ტუკუმანი,サン・ミゲル・デ・トゥクマン,圣米格尔-德图库曼,산미겔데투쿠만', -26.8241400, -65.2226000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1509, 'San Martín de los Andes', 'San Martin de los Andes', 'Andu San Martinas,Andų San Martinas,CPC,San Martin de Los Andes,San Martin de los Andes,San Martín de Los Andes,San Martín de los Andes,San-Martin-De-Los-Andes,sheng ma ding de luo si an di si,Сан-Мартин-Де-Лос-Андес,סן מרטין דה לוס אנדס,聖馬丁德洛斯安第斯', -40.1578900, -71.3533700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1510, 'San Martín', 'San Martin', 'General San Martin,General San Martín,San Martin,San Martín,san martyn,sheng ma ding,sn mrtyn,סן מרטין,سان مارتين,سان مارتین,聖馬丁', -33.0810300, -68.4681400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1511, 'San Martín', 'San Martin', 'San Martin,San Martín', -31.4295700, -68.5006500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1512, 'San Luis', 'San Luis', 'Ciudad de San Luis,LUQ,San Luis,San Luisas,San-Luis,Sanctus Ludovicus,san lwys,san lwyys,san-luisi,sanlu-iseu,sheng lu yi si,Сан Луис,Сан-Луис,Сан-Луїс,Սան Լուիս,סן לואיס,سان لوئیس,سان لوئیس، ارجنٹائن,سان لويس,სან-ლუისი,サン・ルイス,聖路易斯,산루이스', -33.2950100, -66.3356300, 'AR', '2016-09-05', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1513, 'San Lorenzo', 'San Lorenzo', 'San Lorenzo', -32.7434100, -60.7361300, 'AR', '2016-07-05', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1514, 'San Justo', 'San Justo', 'San Justo', -30.7891300, -60.5918900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1515, 'San Juan', 'San Juan', 'Ciudad de San Juan,Gorad San-Khuan,Lalawigan ng San Juan,San Chuanas,San Juan,San Juan de la Frontera,San Khuan,San Xuan,San-Khuan,Sanctus Ioannes a Cuio,UAQ,san jwan,san khwan  alarjntyn,san khwan  arzhantyn,san-khuani,sanfuan,sanhuan,sheng hu an,Горад Сан-Хуан,Сан Хуан,Сан-Хуан,Սան Խուան,סן חואן,سان جوآن,سان خوآن، آرژانتین,سان خوآن، ارجنٹائن,سان خوان، الأرجنتين,სან-ხუანი,サンフアン,圣胡安,산후안', -31.5375000, -68.5363900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1516, 'San José de la Dormida', 'San Jose de la Dormida', '', -30.3544000, -63.9487100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1517, 'San José de Jáchal', 'San Jose de Jachal', 'Jachal,Jáchal,San Chose de Chacalis,San Chose de Chačalis,San Jose de Jachal,San José de Jáchal,sheng he sai de ha cha er,聖何塞德哈查爾', -30.2405700, -68.7469300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1518, 'San José', 'San Jose', 'Piedra Blanca,San Jose,San Jose de Fray Mamerto Esquiu,San José,San José de Fray Mamerto Esquiú', -28.3833300, -65.7000000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1519, 'San Jorge', 'San Jorge', '', -31.8961800, -61.8598400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1520, 'San Isidro', 'San Isidro', 'San Isidro', -28.4626500, -65.7258500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1521, 'San Francisco del Monte de Oro', 'San Francisco del Monte de Oro', 'San Francisco,San Francisco del Monte de Oro', -32.5982500, -66.1253900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1522, 'San Francisco del Chañar', 'San Francisco del Chanar', 'San Francisco de Chanar,San Francisco de Chañar,San Francisco del Chanar,San Francisco del Chañar', -29.7899100, -63.9386100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1523, 'San Francisco', 'San Francisco', 'San Francisco,San Fransiskas,san fransyskw,san fransyskw  qrtbt,sheng fu lang xi si ke,sn prnsysqw,סן פרנסיסקו,سان فرانسيسكو، قرطبة,سان فرانسیسکو,聖弗朗西斯科', -31.4279700, -62.0826600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1524, 'San Fernando del Valle de Catamarca', 'San Fernando del Valle de Catamarca', 'CTC,Catamarca,Katamarka,San Fernando del Vale de Katamarka,San Fernando del Valle de Catamarca,San Fernando del Valye de Katamarka,San-Fernando-del''-Vaje-de-Katamarka,San-Fernando-del''-Val''e-de-Katamarka,San-Fernando-del''-Valle-de-Katamarkae,ka ta ma ka,qtmrqh,san frnandw dyl faly dy katamarka,san frnandw dyl wyla dy katamarka,san frnandwdl wlh dkatamarka,san-pernando-del-valie-de-kʼatʼamarkʼa,sanpeleunandodelbayedekatamaleuka,Катамарка,Сан Фернандо дел Вале де Катамарка,Сан-Фернандо-дель-Вайє-де-Катамарка,Сан-Фернандо-дель-Валле-де-Катамаркæ,Сан-Фернандо-дель-Валье-де-Катамарка,Սան Ֆերնանդո դել Վալյե դե Կատամարկա,קטמרקה,سان فرناندو دل والے دے کاتامارکا,سان فرناندو ديل فالي دي كاتاماركا,سان فرناندو دیل ویلا دی کاتامارکا,سان فرناندودل وله دکاتامارکا,სან-ფერნანდო-დელ-ვალიე-დე-კატამარკა,サン・フェルナンド・デル・バジェ・デ・カタマルカ,卡塔马卡,산페르난도델바예데카타마르카', -28.4695700, -65.7852400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1525, 'San Cristóbal', 'San Cristobal', 'San Cristobal,San Cristóbal', -30.3105300, -61.2372400, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1526, 'San Carlos de Bolívar', 'San Carlos de Bolivar', 'Bolivar,Bolívar,San Carlos de Bolivar,San Carlos de Bolívar', -36.2500000, -61.1000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1527, 'San Carlos Centro', 'San Carlos Centro', 'San Carlos Centro', -31.7286400, -61.0919200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1528, 'San Carlos', 'San Carlos', 'San Carlos,San Carlos Minas', -31.1776100, -65.1024500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1529, 'San Carlos', 'San Carlos', 'San Carlos', -25.8861800, -65.9294100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1530, 'San Blas de los Sauces', 'San Blas de los Sauces', 'San Blas,San Blas de los Sauces', -28.4105100, -67.0934100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1531, 'San Bernardo', 'San Bernardo', 'San Bernardo', -27.2878200, -60.7125200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1532, 'San Benito', 'San Benito', 'San Benito', -31.7837100, -60.4415600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1533, 'San Basilio', 'San Basilio', '', -33.4976300, -64.3149500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1534, 'San Antonio Oeste', 'San Antonio Oeste', 'OES,Puerto San Antonio Oeste,San Antonio Oeste,San Antonio Oestė,xi sheng an dong ni ao,西圣安东尼奥', -40.7319300, -64.9476900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1535, 'San Antonio de los Cobres', 'San Antonio de los Cobres', 'San Antonio de los Cobres,San Antonio de los Kobresas,sheng an dong ni ao de luo si ke bu lei si,סן אנטוניו דה לוס קוברס,聖安東尼奧德洛斯科布雷斯', -24.2180400, -66.3187700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1536, 'San Antonio de Litín', 'San Antonio de Litin', 'Capilla de San Antonio,San Antonio,San Antonio de Litin,San Antonio de Litín', -32.2137700, -62.6323700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1537, 'San Antonio', 'San Antonio', 'San Antonio', -28.0092700, -65.7121800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1538, 'San Antonio', 'San Antonio', 'San Antonio', -24.3675300, -65.3347100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1539, 'San Agustín de Valle Fértil', 'San Agustin de Valle Fertil', 'San Agustin,San Agustin de Valle Fertil,San Agustín,San Agustín de Valle Fértil,Villa San Agustin,Villa San Agustín', -30.6335300, -67.4682100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1540, 'San Agustín', 'San Agustin', 'San Agustin,San Agustín', -31.9768100, -64.3740000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1541, 'Samuhú', 'Samuhu', 'Samuhi,Samuhu,Samuhú', -27.5211600, -60.3916700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1542, 'Sampacho', 'Sampacho', '', -33.3839000, -64.7221100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1543, 'Salto', 'Salto', 'M. Ugarte,Marcelino Ugarte,Salto', -34.2929200, -60.2545500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1544, 'Salta', 'Salta', 'Ciudad de Salta,Gorad Sal''ta,SLA,Sal''ta,Salta,Salta llaqta,Saltaurbo,sa er ta,salta,saruta,slth,Σάλτα,Горад Сальта,Салта,Сальта,Սալտա,סלטה,سالتا,साल्टा,სალტა,サルタ,萨尔塔,살타', -24.7859000, -65.4116600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1545, 'Salsipuedes', 'Salsipuedes', '', -31.1372500, -64.2958900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1546, 'Salsacate', 'Salsacate', 'Salsacate', -31.3164900, -65.0852900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1547, 'Salliqueló', 'Salliquelo', 'Salliquelo,Salliqueló', -36.7521600, -62.9605300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1548, 'Saldán', 'Saldan', '', -31.3026200, -64.3070000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1549, 'Sacanta', 'Sacanta', '', -31.6630000, -63.0450500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1550, 'Rufino', 'Rufino', 'Rufino', -34.2682700, -62.7126200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1551, 'Rosario de Lerma', 'Rosario de Lerma', 'Rosario de Lerma', -24.9820600, -65.5789100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1552, 'Rosario de la Frontera', 'Rosario de la Frontera', 'Rosario de la Frontera', -25.7969300, -64.9709400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1553, 'Rosario', 'Rosario', 'ROS,Rasarya,Rosarijas,Rosario,Rosário,Rozariyo,Rozarîyo,Urbs Rosariensis,losalio,luo sa li ao,luo sha li ao,ro sa ri xo,rojhariyo,rosari''o,rosario,rwsaryw,rwsaryw  santa fh,Ροσάριο,Расарыа,Росарио,Росаріо,Ռոսարիո,רוסאריו,روساريو,روساریو، سانتا فه,روساریو، سانتا فے,रोझारियो,রোসারিও,โรซารีโอ,როსარიო,ロサリオ,罗萨里奥,羅沙里奧,로사리오', -32.9468200, -60.6393200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1554, 'Roldán', 'Roldan', 'Roldan,Roldán', -32.8984600, -60.9068100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1555, 'Rojas', 'Rojas', 'Rojas', -34.1952800, -60.7350000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1556, 'Rodeo', 'Rodeo', '', -30.2118600, -69.1366100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1557, 'Rivadavia', 'Rivadavia', 'Rivadavia', -33.1905100, -68.4608100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1558, 'Rivadavia', 'Rivadavia', 'Rivadavia', -31.5538900, -68.6525000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1559, 'Rivadavia', 'Rivadavia', 'Rivadavia', -24.1883200, -62.8902100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1560, 'Río Tercero', 'Rio Tercero', 'Rio Tercero,Río Tercero', -32.1730100, -64.1140500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1561, 'Río Segundo', 'Rio Segundo', '', -31.6526000, -63.9099000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1562, 'Río Pico', 'Rio Pico', 'Campo del Rio Pica,Campo del Río Pica,Estancia Campo del Pico,Rio Pica,Rio Pico,Río Pico', -44.1790500, -71.3684700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1563, 'Río Mayo', 'Rio Mayo', 'Paso Rio Mayo,Paso Rio de Mayo,Paso Río Mayo,ROY,Rio Majo,Rio Mayo,Rosa,Río Mayo,Рио Майо', -45.6857300, -70.2579700, 'AR', '2017-03-24', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1564, 'Río Grande', 'Rio Grande', 'RGA,Rio Grande,Rio Grande pa Eldlandet,Rio Grande på Eldlandet,Rio Grandė,Rio-Grande,Río Grande,li ao ge lan de,liogeulande,ryw ghrandy  tyyra dyl fwyghw,ryw grandh  tyra dl fwygw,Рио-Гранде,ריו גראנדה,ريو غراندي، تييرا ديل فويغو,ریو گرانده، تیرا دل فوئگو,リオ・グランデ,里奧格蘭德,리오그란데', -53.7876900, -67.7094600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1565, 'Río Gallegos', 'Rio Gallegos', 'Gallegos,Puerto Gallegos,Puerto Rio Gallegos,Puerto Río Gallegos,RGL,Rio Galegos,Rio Galjegosas,Rio Gallegos,Rio Galyegos,Rio-Gal''egos,Río Gallegos,li ao jia ye ge si,liogayegoseu,rio-galiegosi,ryw galygws,ryw galygws  santa krwz,ryw ghalyghws  santa krwz,ryw gzgws,rywgalgws,Рио Галегос,Рио-Гальегос,Ріо-Гальєгос,Ռիո Գալյեգոս,ריו גזגוס,ريو غاليغوس، سانتا كروز,ریو گالیگوس,ریو گالیگوس، سانتا کروز,ریوگالگوس,რიო-გალიეგოსი,リオ・ガジェゴス,里奥加耶戈斯,리오가예고스', -51.6226100, -69.2181300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1566, 'Río Cuarto', 'Rio Cuarto', 'Ciudad de Rio Cuarto,Ciudad de Río Cuarto,RCU,Rio Cuarto,Rio Kuartas,Rio Kuarto,Rio Kvarto,Rio-Kuarto,Rio-Kvarto,Río Cuarto,li ao kua er tuo,liokualeuto,ryw kwartw,ryw kwartw  qrtbt,Рио Кварто,Рио Куарто,Рио-Куарто,Ріо-Кварто,Ռիո Կուարտո,ריו קוארטו,ريو كوارتو، قرطبة,ریو کوارتو,რიო-კუარტო,リオ・クアルト,里奥夸尔托,리오쿠아르토', -33.1306700, -64.3499200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1567, 'Río Colorado', 'Rio Colorado', 'Pichi-Mauida,Rio Colorado,Río Colorado,li ao ke luo la duo,Пичи-Мауида,里奧科洛拉多', -38.9939700, -64.0929500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1568, 'Río Ceballos', 'Rio Ceballos', 'Rio Ceballos,Rio Zeballos,Río Ceballos,Río Zeballos', -31.1648600, -64.3224100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1569, 'Rinconada', 'Rinconada', 'Rinconada', -22.4408300, -66.1677900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1570, 'Recreo', 'Recreo', '', -31.4907600, -60.7329900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1571, 'Recreo', 'Recreo', 'Recreo,Rekreo,lei ke lei ao,lekeule-o,rekureo,Рекрео,Ռեկրեո,レクレオ,雷克雷奧,레크레오', -29.2818400, -65.0609600, 'AR', '2016-02-03', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1572, 'Realicó', 'Realico', 'Realico,Realicó', -35.0365800, -64.2447000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1573, 'Rawson', 'Rawson', 'Rausonopolis,Rawson,Roson,Rosona,Rosonas,Rouson,Ruosuons,lauson,luo sen,rauson,ravsoni,rawswn,rawswn  chwbwt,rwswn  tshwbwt,Росон,Роусон,Ռոսոն,ראוסון,راوسون,راوسون، چوبوت,روسون، تشوبوت,რავსონი,ラウソン,罗森,라우손', -43.3001600, -65.1022800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1574, 'Rancul', 'Rancul', 'Jardon,Jardón,Rancul', -35.0686200, -64.6810700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1575, 'Ramallo', 'Ramallo', 'Ramallo', -33.4848200, -60.0070700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1576, 'Rafaela', 'Rafaela', 'RAF,Rafaehla,Rafaela,la fei la,ra fa xela,rafayla,rafayyla,rapaela,Рафаэла,רפאלה,رافائلا,رافاييلا,ราฟาเอลา,რაფაელა,拉斐拉', -31.2503300, -61.4867000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1577, 'Rada Tilly', 'Rada Tilly', 'Rada Tili,Rada Tilli,Rada Tilly', -45.9333300, -67.5333300, 'AR', '2012-01-18', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1578, 'Quitilipi', 'Quitilipi', 'Quitilipi', -26.8691300, -60.2168300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1579, 'Quimilí', 'Quimili', 'Quimili,Quimilí', -27.6333300, -62.4166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1580, 'Quilino', 'Quilino', 'Quilino,Villa Quilino', -30.2139700, -64.5006300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1581, 'Quemú Quemú', 'Quemu Quemu', 'Quemu Quemu,Quemú Quemú', -36.0546300, -63.5642800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1582, 'Punta Alta', 'Punta Alta', 'Punta Alta,Punta-Al''ta,bwnta alta,peng ta a er ta,puntaalta,Пунта-Альта,بونتا ألتا,蓬塔阿尔塔,푼타알타', -38.8758800, -62.0735900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1583, 'Puerto Santa Cruz', 'Puerto Santa Cruz', 'Puerto Santa Cruz,Puerto Santa Krusas,RZA,Santa Cruz,sheng ke lu si gang,聖克魯斯港', -50.0191000, -68.5232100, 'AR', '2017-03-25', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1584, 'San Julián', 'San Julian', 'Puerto San Julian,Puerto San Julián,San Julian,San Julián,ULA', -49.3055400, -67.7274300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1585, 'Puerto Madryn', 'Puerto Madryn', 'Madryn,Madrynhyd,Madrynhȳð,PMY,Porth Madryn,Pouerto Madrin,Puehrto-Madrin,Puerto Madrinas,Puerto Madryn,Pureto Madrin,bwyrtw madryn,ma de lin gang,pwrtw madryn,Πουέρτο Μάδριν,Пуэрто-Мадрин,Պուրետո Մադրին,פוארטו מדרין,بويرتو مادرين,پورتو مادرین,馬德林港', -42.7692000, -65.0385100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1586, 'Puerto Deseado', 'Puerto Deseado', 'Deseado,PUD,Puerto Deseadas,Puerto Deseado,de sai a duo gang,פוארטו דסאדו,德塞阿多港', -47.7503400, -65.8938200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1587, 'Puerta de Corral Quemado', 'Puerta de Corral Quemado', 'Puerta,Puerta de Corral Quemado', -27.2300000, -66.9363500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1588, 'Puelches', 'Puelches', 'Curaco,Curacó,Puelches', -38.1456200, -65.9142600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1589, 'Puan', 'Puan', 'Puan', -37.5457600, -62.7672300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1590, 'Presidencia Roque Sáenz Peña', 'Presidencia Roque Saenz Pena', 'PRQ,Presidencia Roque Saenz Pena,Presidencia Roque Sáenz Peña,Presidensija Roke Saens Penja,Presidente Roque Saenz Pena,Presidente Roque Sáenz Peña,Roque Saenz Pena,Roque Sáenz Peña,SZQ,brysdns rwky saynz bynya,luo ke sa en si pei ni ya zong tong cheng,rwkh saynz pnya,פרסידנסיה רוקה סאנס פניה,بريسدنس روكي ساينز بينيا,روکه سائنز پنیا,პრესიდენსია-როკე-საენს-პენია,羅克薩恩斯培尼亞總統城', -26.7852200, -60.4387600, 'AR', '2016-10-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1591, 'Pozo Hondo', 'Pozo Hondo', 'Pozo Hondo', -27.1660700, -64.4900000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1592, 'Pozo del Tigre', 'Pozo del Tigre', 'Pozo del Tigre', -24.8968200, -60.3235900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1593, 'Pozo del Molle', 'Pozo del Molle', '', -32.0186000, -62.9198400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1594, 'Porteña', 'Portena', '', -31.0139100, -62.0665000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1595, 'Pomán', 'Poman', 'Peman,Poman,Pomán', -28.3945500, -66.2205200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1596, 'Pocito', 'Pocito', 'Pocito', -31.6833300, -68.5833300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1597, 'Plottier', 'Plottier', 'Plottier', -38.9666700, -68.2333300, 'AR', '2015-12-09', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1598, 'Plaza Huincul', 'Plaza Huincul', 'Plaza Huincul', -38.9259800, -69.2086300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1599, 'Piquillín', 'Piquillin', 'Piquilin,Piquillin,Piquillín', -31.3015800, -63.7578800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1600, 'Pilcaniyeu', 'Pilcaniyeu', 'Estancia Pilcaniyeu,Pilcaniyeu', -41.1188100, -70.7291400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1601, 'Pilar', 'Pilar', 'Pilar', -31.6789000, -63.8796400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1602, 'Pigüé', 'Piguee', 'Pigue,Pigüé', -37.6050900, -62.4033300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1603, 'Piedra del Águila', 'Piedra del Aguila', 'Piedra de Aguila,Piedra del Aguila,Piedra del Águila', -40.0481100, -70.0741000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1604, 'Picún Leufú', 'Picun Leufu', 'Picun Leufu,Picún Leufú', -39.5235100, -69.2796600, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1605, 'Pico Truncado', 'Pico Truncado', 'Pico Troncado,Pico Truncado,Piko Trunkadas,Piko Trunkado,pyqw trwnqdw,Пико Трункадо,Պիկո Տրունկադո,פיקו טרונקדו', -46.7949000, -67.9573100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1606, 'Perito Moreno', 'Perito Moreno', 'Lago Buenos Aires,PMQ,Perito Moreno,Rio Fenix,Río Fénix,Перито Морено', -46.5899500, -70.9297500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1607, 'Pergamino', 'Pergamino', 'Pergamino,Пергамино', -33.8899500, -60.5735700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1608, 'Pérez', 'Perez', 'Perez,Pérez', -32.9983500, -60.7679100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1609, 'Pellegrini', 'Pellegrini', 'Carlos Pellegrini,Pellegrini', -36.2658400, -63.1655000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1610, 'Pehuajó', 'Pehuajo', 'PEH,Pehuajo,Pehuajó,Peouacho,pei wa huo,phwakhw,Πεουαχό,پهواخو,佩瓦霍', -35.8107700, -61.8968000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1611, 'Patquía', 'Patquia', 'Patquia,Patquía', -30.0468100, -66.8823100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1612, 'Paso de Indios', 'Paso de Indios', 'Paso de Indios,Paso de los Indios', -43.8622500, -69.0460300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1613, 'Pasco', 'Pasco', '', -32.7473300, -63.3423200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1614, 'Pascanas', 'Pascanas', 'Pascanas', -33.1255000, -63.0408400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1615, 'Parera', 'Parera', 'Parera', -35.1460000, -64.5008900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1616, 'Paraná', 'Parana', 'Cittae de Parana,PRA,Parana,Paranà,Paraná,ba la na,barana  antry ryws,palana,parana,prnh,Çittæ de Paraná,Παρανά,Парана,Պարանա,פרנה,بارانا، انتري ريوس,پارانا,پارانا، انترے ریوس,პარანა,パラナ,巴拉那,파라나', -31.7319700, -60.5238000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1617, 'Pampa de los Guanacos', 'Pampa de los Guanacos', 'Kilometro 325,Kilómetro 325,Pampa de los Guanacos', -26.2333300, -61.8500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1618, 'Pampa del Infierno', 'Pampa del Infierno', 'Pampa del Infierno', -26.5051700, -61.1743600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1619, 'Palpalá', 'Palpala', 'Palpala,Palpalá', -24.2564700, -65.2116300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1620, 'Palma Sola', 'Palma Sola', 'Palma Sola,Palma Sota', -23.9633600, -64.2987200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1621, 'Oro Verde', 'Oro Verde', 'Oro Verde', -31.8250800, -60.5174900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1622, 'Ordóñez', 'Ordonez', 'General Ordonez,Ordonez,Ordóñez', -32.8405700, -62.8655200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1623, 'Oncativo', 'Oncativo', 'Oncativo', -31.9135300, -63.6820100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1624, 'Olta', 'Olta', 'Olta', -30.6311700, -66.2630000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1625, 'Oliva', 'Oliva', 'Oliva,Olivia', -32.0415800, -63.5697800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1626, 'Olavarría', 'Olavarria', 'OVR,Olavarija,Olavarria,Olavarrija,Olavarría,ao la wa li ya,awlafarya,awlawarya,olavaria,xo la bar ri xa,Олаварија,Олаваррия,أولافاريا,اولاواریا,โอลาบาร์รีอา,ოლავარია,奧拉瓦里亞', -36.8927200, -60.3225400, 'AR', '2017-02-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1627, 'Obispo Trejo', 'Obispo Trejo', 'Obispo Trejo,San Antonio', -30.7812800, -63.4134900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1628, 'Nueve de Julio', 'Nueve de Julio', '9 de Julio,Nev-de-Khulio,Nueve de Julio,Нев-де-Хулио', -35.4443700, -60.8831300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1629, 'Nueve de Julio', 'Nueve de Julio', '9 de Julio,Nueve de Julio', -31.6691400, -68.3902300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1630, 'Nueva Esperanza', 'Nueva Esperanza', 'Nueva Esperanza', -26.1990700, -64.2379200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1631, 'Ñorquinco', 'Norquinco', 'Norquinco,Ñorquinco', -41.8507200, -70.9017300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1632, 'Noetinger', 'Noetinger', '', -32.3659700, -62.3112600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1633, 'Neuquén', 'Neuquen', 'Ciuda de Neuquen,Ciudad de Neuquen,Ciudad de Neuquén,Ciudá de Neuquén,Gorad Neuken,NQN,Nequen,Neuken,Neukenas,Neuquen,Neuquén,Vila de Neuquen,Vila de Neuquén,n''yukvina,ne-uken,nei wu ken,neuken,nywkn,nywkwyn,Горад Неўкен,Неукен,Նեուկեն,נאוקן,نئوکن,نيوكوين,نیوکوئن,نیوکوین,न्यूक्वीन,ნეუკენი,ネウケン,内乌肯,네우켄', -38.9516100, -68.0591000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1634, 'Naschel', 'Naschel', '', -32.9165600, -65.3753500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1635, 'Napenay', 'Napenay', 'Napenay', -26.7333300, -60.6166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1636, 'Mutquín', 'Mutquin', 'Mudquin,Mutquin,Mutquín', -28.3210400, -66.1425300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1637, 'Morteros', 'Morteros', 'Morteros', -30.7116400, -61.9986200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1638, 'Morrison', 'Morrison', '', -32.5948000, -62.8345500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1639, 'Monteros', 'Monteros', 'Monteros', -27.1674100, -65.4983200, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1640, 'Monte Quemado Airport', 'Monte Quemado Airport', 'Aeropuerto de Monte Quemado,Monte Quemado', -25.8056500, -62.8301900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1641, 'Monte Maíz', 'Monte Maiz', 'Monte Maiz,Monte Maize,Monte Maíz', -33.2046200, -62.6008500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1642, 'Monte Hermoso', 'Monte Hermoso', 'Balneario Monte Hermoso', -38.9825000, -61.2947200, 'AR', '2016-01-31', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1643, 'Monte Cristo', 'Monte Cristo', '', -31.3431200, -63.9443700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1644, 'Monte Buey', 'Monte Buey', '', -32.9164200, -62.4566900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1645, 'Molinos', 'Molinos', 'Molinos', -25.4395000, -66.2912600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1646, 'Miramar', 'Miramar', 'Miramar', -30.9185900, -62.6781400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1647, 'Mina Clavero', 'Mina Clavero', 'Mina Clavero', -31.7210100, -65.0061900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1648, 'Milagro', 'Milagro', 'El Milagro,Milagro', -31.0032600, -66.0009800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1649, 'Miguel Riglos', 'Miguel Riglos', 'M. Riglos,Miguel Riglos', -36.8539800, -63.6884200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1650, 'Metán', 'Metan', 'Metan,Metán', -25.4990500, -64.9738800, 'AR', '2016-02-02', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1651, 'Merlo', 'Merlo', 'Merlas,Merlo,RLO,Villa de Merlo', -32.3428800, -65.0139600, 'AR', '2015-06-07', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1652, 'Mendoza', 'Mendoza', 'Capital megye,Ciuda de Mendoza,Ciudad de Mendoza,Ciudá de Mendoza,Gorad Mendosa,MDZ,Mendos,Mendosa,Mendosae,Mendoza,Mentosa,Vila de Mendoza,men do sa,men duo sa,mendosa,mendoza,mndwsh,mndwza,myndwza,Μεντόσα,Горад Мендоса,Мендоза,Мендосæ,Мендоса,Մենդոսա,מנדוסה,مندوزا,مندوسا، ارجنٹائن,میندوزا,मेन्दोज़ा,เมนโดซา,მენდოსა,メンドーサ,门多萨,멘도사', -32.8908400, -68.8271700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1653, 'Mendiolaza', 'Mendiolaza', '', -31.2673800, -64.3008700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1654, 'Melincué', 'Melincue', 'Melincue,Melincué,San Urbano,Urbano', -33.6584700, -61.4545900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1655, 'Médanos', 'Medanos', '', -38.8280300, -62.6935500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1656, 'Mattaldi', 'Mattaldi', 'Mataldi,Mattaldi', -34.4819400, -64.1725500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1657, 'Marull', 'Marull', 'Kilometro 267,Kilómetro 267,Marull', -30.9947100, -62.8257600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1658, 'Mariano Moreno', 'Mariano Moreno', 'Covunco,Covunco Centro,M. Moreno,Mariano Moreno', -38.7502900, -70.0236700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1659, 'Marcos Juárez', 'Marcos Juarez', 'Marcos Juarez,Marcos Juárez', -32.6978000, -62.1067200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1660, 'Maquinchao', 'Maquinchao', 'MQD,Maquinchao', -41.2500000, -68.7333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1661, 'Malvinas Argentinas', 'Malvinas Argentinas', 'Malvinas Argentinas', -31.3833300, -64.0666700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1662, 'Malargüe', 'Malarguee', 'LGS,Malargoue,Malargue,Malarguee,Malarguje,Malargujė,Malargüe,Villa Malargue,Villa Malargüe,ma la gui,Μαλάργουε,马拉圭', -35.4754500, -69.5842700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1663, 'Malanzán', 'Malanzan', 'Malanzan,Malanzán', -30.8039400, -66.6090800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1664, 'Malagueño', 'Malagueno', '', -31.4646700, -64.3584000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1665, 'Maipú', 'Maipu', 'Maipu,Maipú', -32.9796300, -68.7846100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1666, 'Mainque', 'Mainque', 'Mainque', -39.0666700, -67.3000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1667, 'Maimará', 'Maimara', 'Maimara,Maimará', -23.6239200, -65.4079700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1668, 'Machagai', 'Machagai', 'Machagai', -26.9261400, -60.0495500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1669, 'Macachín', 'Macachin', 'Macachin,Macachín', -37.1359800, -63.6665000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1670, 'San Isidro de Lules', 'San Isidro de Lules', 'Lules,San Isidro de Lules', -26.9277000, -65.3386900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1671, 'Luján de Cuyo', 'Lujan de Cuyo', 'Lujan,Lujan de Cuyo,Luján,Luján de Cuyo', -33.0354700, -68.8778200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1672, 'Luján', 'Lujan', 'Lujan,Luján', -32.3757000, -65.9296000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1673, 'Los Varela', 'Los Varela', 'Los Varela,Varela', -27.9548200, -65.8655000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1674, 'Los Telares', 'Los Telares', 'Los Telares', -28.9847900, -63.4488900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1675, 'Los Surgentes', 'Los Surgentes', '', -32.9845400, -62.0219100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1676, 'Los Menucos', 'Los Menucos', 'LMD,Los Menucos', -40.8440200, -68.0871800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1677, 'Los Juríes', 'Los Juries', 'Los Juries,Los Juríes', -28.4653900, -62.1086200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1678, 'Los Frentones', 'Los Frentones', 'Los Frentones,Los Frontones', -26.4077000, -61.4136700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1679, 'Los Cóndores', 'Los Condores', 'Condores,Cóndores,Los Condores,Los Cóndores', -32.3198300, -64.2775100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1680, 'Los Antiguos', 'Los Antiguos', 'Los Antiguos', -46.5497200, -71.6308600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1681, 'Los Altos', 'Los Altos', 'Altos,Los Altos', -28.0484500, -65.4994500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1682, 'Lonquimay', 'Lonquimay', 'Lonquimay,Pueblo Quintana', -36.4654600, -63.6242900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1683, 'Londres', 'Londres', 'Londres', -27.7143900, -67.1334900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1684, 'Loncopué', 'Loncopue', 'LCP,Loncopue,Loncopué', -38.0728400, -70.6160900, 'AR', '2017-03-25', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1685, 'Lincoln', 'Lincoln', 'Lincoln', -34.8664900, -61.5302000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1686, 'Limay Mahuida', 'Limay Mahuida', 'Limay Mahuida', -37.1595900, -66.6759500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1687, 'Libertador General San Martín', 'Libertador General San Martin', 'Libertador General San Martin,Libertador General San Martín,San Martin,San Martín', -32.4107400, -65.6758600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1688, 'Libertador General San Martín', 'Libertador General San Martin', 'General San Martin,Ledesma,Libertador General San Martin,Libertador General San Martín', -23.8064400, -64.7875700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1689, 'Leones', 'Leones', 'Leones,Peron,Perón', -32.6617400, -62.2967800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1690, 'Leleque', 'Leleque', 'Cholila,Leleque,Leteque', -42.4122500, -71.0679700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1691, 'La Viña', 'La Vina', 'La Vina,La Viña', -25.4664200, -65.5663000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1692, 'La Toma', 'La Toma', 'Cuatro de Junio,La Toma', -33.0525800, -65.6238500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1693, 'La Tigra', 'La Tigra', '', -27.1099600, -60.5871900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1694, 'Las Varillas', 'Las Varillas', '', -31.8720800, -62.7194600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1695, 'Las Varas', 'Las Varas', '', -31.8026000, -62.6165500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1696, 'Las Rosas', 'Las Rosas', 'Las Rosas', -32.4766100, -61.5804100, 'AR', '2016-06-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1697, 'Las Plumas', 'Las Plumas', 'Las Plumas', -43.7205800, -67.2831900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1698, 'Las Perdices', 'Las Perdices', '', -32.6979400, -63.7063400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1699, 'Las Parejas', 'Las Parejas', 'Las Parejas', -32.6847800, -61.5163700, 'AR', '2016-06-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1700, 'Las Ovejas', 'Las Ovejas', 'Las Ovejas', -36.9888100, -70.7499100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1701, 'Las Lomitas', 'Las Lomitas', 'LLS,Las Lomitas', -24.7095500, -60.5930300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1702, 'Las Lajitas', 'Las Lajitas', 'Las Lajitas', -24.6833300, -64.2500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1703, 'Las Lajas', 'Las Lajas', 'Las Lajas', -38.5232200, -70.3674500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1704, 'Las Junturas', 'Las Junturas', '', -31.8312500, -63.4501600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1705, 'Las Higueras', 'Las Higueras', '', -33.0923100, -64.2889900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1706, 'Las Heras', 'Las Heras', 'Colonia Las Heras,LHS,Las Heras', -46.5418600, -68.9359300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1707, 'Las Heras', 'Las Heras', 'Las Heras', -32.8527300, -68.8283700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1708, 'Las Coloradas', 'Las Coloradas', 'Las Coloradas,Las Koloradas,Las Koloradasas,Las-Koloradas,la si ke luo la da si,Лас-Колорадас,Լաս Կոլորադաս,拉斯科洛拉達斯', -39.5553400, -70.5949100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1709, 'Las Breñas', 'Las Brenas', 'Las Brenas,Las Breñas', -27.0896600, -61.0816100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1710, 'Las Acequias', 'Las Acequias', 'Las Acequias,Las Acequitas,Las Arequias', -33.2815500, -63.9761000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1711, 'La Rioja', 'La Rioja', 'A Rioxa,Ciudad de La Rioja,Gorad La-Ryjokha,IRJ,La Riocha,La Rioja,La Rioja llaqta,La Riokha,La Rioxa,La-Riokha,Larjoha,Rioja,Riokha,la li ao ha,la rywja,la rywkha,la rywkha  arzhantyn,la-riokha,lalioha,lh rywhh,Горад Ла-Рыёха,Ла Риоха,Ла-Риоха,Ла-Ріоха,Риоха,Լա Ռիոխա,לה ריוחה,لا ريوخا,لا ریؤجا,لا ریوجا، ارجنٹین,لا ریوخا، آرژانتین,ლა-რიოხა,ラ・リオハ,拉里奧哈,라리오하', -29.4110500, -66.8506700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1712, 'La Quiaca', 'La Quiaca', 'La Kiaka,La Quiaca,La-K''jaka,la ji ya ka,Ла-Кьяка,Լա Կիակա,לה קיאקה,拉基亞卡', -22.1023600, -65.5929900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1713, 'La Puerta de San José', 'La Puerta de San Jose', '', -27.5500000, -67.0166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1714, 'La Puerta', 'La Puerta', 'La Puerta', -28.1703600, -65.7901500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1715, 'Laprida', 'Laprida', 'Laprida', -37.5441500, -60.7996900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1716, 'La Poma', 'La Poma', 'La Poma,Poma', -24.7219600, -66.2010600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1717, 'La Playosa', 'La Playosa', '', -32.1000200, -63.0308800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1718, 'La Paz', 'La Paz', 'La Paz', -33.4609100, -67.5495600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1719, 'La Para', 'La Para', '', -30.8941600, -63.0010700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1720, 'La Merced', 'La Merced', 'La Merced,Merced', -28.1519500, -65.6602900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1721, 'La Mendieta', 'La Mendieta', 'La Mendieta', -24.3118700, -64.9637700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1722, 'La Maruja', 'La Maruja', 'La Maruja', -35.6736000, -64.9399700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1723, 'Lamarque', 'Lamarque', 'Lamarque', -39.4230400, -65.7020800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1724, 'Laguna Yema', 'Laguna Yema', 'Laguna Yema', -24.2539100, -61.2446600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1725, 'Laguna Paiva', 'Laguna Paiva', 'Laguna Paiva,Reynaldo Cullen', -31.3039100, -60.6589400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1726, 'Laguna Larga', 'Laguna Larga', '', -31.7765200, -63.8010400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1727, 'La Granja', 'La Granja', '', -31.0091900, -64.2686900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1728, 'Lago Puelo', 'Lago Puelo', 'Lago Puelo', -42.0809500, -71.6140500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1729, 'La Francia', 'La Francia', '', -31.4067500, -62.6339600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1730, 'La Falda', 'La Falda', 'La Falda,La-Fal''da,Ла-Фальда,لا فالڈا', -31.0884100, -64.4898700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1731, 'La Cumbre', 'La Cumbre', 'LCM,La Cumbre', -30.9820100, -64.4913900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1732, 'La Consulta', 'La Consulta', 'La Consulata,La Consulta', -33.7357900, -69.1218100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1733, 'La Cocha', 'La Cocha', 'La Cocha', -27.7772900, -65.5703500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1734, 'La Clotilde', 'La Clotilde', 'La Clotilde', -27.1333300, -60.6666700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1735, 'La Cesira', 'La Cesira', '', -33.9511500, -62.9723800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1736, 'La Carlota', 'La Carlota', 'La Carlota,La Karlota,la ka er luo ta,لا کارلوٹا، ارجنٹائن,拉卡爾洛塔', -33.4199300, -63.2976900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1737, 'La Candelaria', 'La Candelaria', 'Candelaria,La Candelaria', -26.1270800, -65.0496000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1738, 'La Cañada', 'La Canada', 'La Canada,La Cañada', -27.7082600, -63.7736600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1739, 'La Calera', 'La Calera', '', -31.3437700, -64.3352900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1740, 'La Caldera', 'La Caldera', 'Caldera,La Caldera', -24.6015900, -65.3809800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1741, 'Laboulaye', 'Laboulaye', 'Laboulaye', -34.1266200, -63.3911900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1742, 'Laborde', 'Laborde', 'Laborde,Las Liebres', -33.1531900, -62.8566100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1743, 'La Banda', 'La Banda', 'La Banda', -27.7334800, -64.2427800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1744, 'Justo Daract', 'Justo Daract', 'Justo Daract,Justo Daraet', -33.8594000, -65.1827700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1745, 'Justiniano Posse', 'Justiniano Posse', 'J. Posse,Justiniano Posse', -32.8841100, -62.6778800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1746, 'Junín de los Andes', 'Junin de los Andes', 'Andu Chuninas,Andų Chuninas,Junin de los Andes,Junín de los Andes,hu ning de luo si an di si,胡寧德洛斯安第斯', -39.9504300, -71.0693600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1747, 'Junín', 'Junin', 'Chuninas,JNI,Junin,Junín,hu ning,khunini,khwnyn,جونين، مقاطعة بوينس آيرس,خونین,ხუნინი,胡寧', -34.5838200, -60.9433200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1748, 'Junín', 'Junin', 'Junin,Junín,Villa Junin,Villa Junín', -33.1476500, -68.4789900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1749, 'José de San Martín', 'Jose de San Martin', 'Colonia San Martin,Colonia San Martín,General J. de San Martin,General J. de San Martín,JSM,Jose de San Martin,José de San Martín,San Martin,San Martín', -44.0503200, -70.4696700, 'AR', '2017-03-25', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1750, 'Joaquín V. González', 'Joaquin V. Gonzalez', 'J.V. Gonzalez,J.V. González,Joaquin V. Gonzalez,Joaquín V. González', -25.0833300, -64.1833300, 'AR', '2016-02-02', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1751, 'Jesús María', 'Jesus Maria', 'Jesus Maria,Jesús María', -30.9815300, -64.0942400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1752, 'James Craik', 'James Craik', '', -32.1612000, -63.4668800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1753, 'Jacinto Arauz', 'Jacinto Arauz', 'J. Arauz,Jacinto Arauz', -38.0860600, -63.4316900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1754, 'Italó', 'Italo', '', -34.7923700, -63.7819900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1755, 'Isla Verde', 'Isla Verde', '', -33.2410400, -62.4029700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1756, 'Iruya', 'Iruya', 'Iruya,yi lu ya,伊魯亞', -22.7666700, -65.2333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1757, 'Intendente Alvear', 'Intendente Alvear', 'Intendente Alvear', -35.2338300, -63.5920500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1758, 'Inriville', 'Inriville', '', -32.9442400, -62.2302800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1759, 'Ingenio La Esperanza', 'Ingenio La Esperanza', 'Ingenio La Esperanza,La Esperanza', -24.2255400, -64.8389600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1760, 'Ingeniero Luis A. Huergo', 'Ingeniero Luis A. Huergo', 'Ingeniero Huergo,Ingeniero L.A. Huergo,Ingeniero Luis A. Huergo', -39.0833300, -67.2333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1761, 'Ingeniero Luiggi', 'Ingeniero Luiggi', 'Ingeniero Luiggi', -35.3858500, -64.4651900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1762, 'Ingeniero Jacobacci', 'Ingeniero Jacobacci', 'Hakobasi,IGB,Inchenjero Chakobacis,Inchenjero Chakobačis,Ingeniero Jacobacci', -41.3292000, -69.5501500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1763, 'Ingeniero Guillermo N. Juárez', 'Ingeniero Guillermo N. Juarez', 'Guillermo N. Juarez,Guillermo N. Juárez,Ingeniero G.N. Juarez,Ingeniero G.N. Juárez,Ingeniero Guillermo N. Juarez,Ingeniero Guillermo N. Juárez,Ingeniero Juarez', -23.9000000, -61.8500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1764, 'Idiazábal', 'Idiazabal', 'Ideazabal,Idiazabal,Idiazábal', -32.8141100, -63.0325200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1765, 'Icaño', 'Icano', 'Icano,Icaño', -28.9193400, -65.3281700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1766, 'Humahuaca', 'Humahuaca', 'Humahuaca', -23.2054400, -65.3504800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1767, 'Huinca Renancó', 'Huinca Renanco', 'Huinca Renanco,Huinca Renancó', -34.8403800, -64.3758000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1768, 'Huillapima', 'Huillapima', 'Huillapima', -28.7253300, -65.9787000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1769, 'Huerta Grande', 'Huerta Grande', '', -31.0752400, -64.4906300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1770, 'Huanchillas', 'Huanchillas', 'Huanchilla,Huanchillas', -33.6665300, -63.6370100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1771, 'Hualfín', 'Hualfin', 'Hualfin,Hualfín', -27.2289600, -66.8313100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1772, 'Hoyo de Epuyén', 'Hoyo de Epuyen', '', -42.0718900, -71.5081100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1773, 'Hersilia', 'Hersilia', '', -30.0044700, -61.8408000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1774, 'Herrera', 'Herrera', '', -28.4809400, -63.0677900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1775, 'Hernando', 'Hernando', 'Hernando', -32.4265700, -63.7333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1776, 'Hernández', 'Hernandez', '', -32.3373000, -60.0216000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1777, 'Hermoso Campo', 'Hermoso Campo', 'Hermoso Campo', -27.6081600, -61.3444100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1778, 'Henderson', 'Henderson', 'Henderson', -36.3000000, -61.7166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1779, 'Helvecia', 'Helvecia', 'Helvecia', -31.0983400, -60.0883000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1780, 'Guatraché', 'Guatrache', 'Guatrache,Guatraché', -37.6677600, -63.5302100, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1781, 'Guatimozín', 'Guatimozin', '', -33.4614900, -62.4384400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1782, 'Guaminí', 'Guamini', 'Guamini,Guaminí', -37.0333300, -62.4166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1783, 'Guachipas', 'Guachipas', 'Guachipas', -25.5203100, -65.5093700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1784, 'Graneros', 'Graneros', 'Graneros', -27.6493400, -65.4383000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1785, 'Granadero Baigorria', 'Granadero Baigorria', 'Granadero Baigorria,Granadero Baigorrio,Paganini', -32.8568300, -60.7175400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1786, 'Godoy Cruz', 'Godoy Cruz', 'Goday Cruz,Godoy Cruz', -32.9286300, -68.8351000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1787, 'Gobernador Gregores', 'Gobernador Gregores', 'Canadon Leon,Cañadón León,GGS,Gobernador Gregores', -48.7505700, -70.2474100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1788, 'Gobernador Gálvez', 'Gobernador Galvez', 'Galvez,Gobernador Galvez,Gobernador Gálvez,Villa Gobernador Galvez,Villa Gobernador Gálvez', -33.0301600, -60.6404500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1789, 'Gobernador Costa', 'Gobernador Costa', 'Gobernador Costa,Gobernor Costa', -44.0499200, -70.5979800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1790, 'General Villegas', 'General Villegas', 'General Villegas,Kheneral Vilegas,VGS,Хенерал Вилегас', -35.0328500, -63.0125200, 'AR', '2016-11-29', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1791, 'General Viamonte', 'General Viamonte', 'General Viamonte,Los Toldos', -35.0001400, -61.0350800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1792, 'General San Martín', 'General San Martin', 'General San Martin,General San Martín,Jose de San Martin,José de San Martín,Villa Alba', -37.9790400, -63.6044900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1793, 'General Roca', 'General Roca', 'Cheneral Roka,Ciudad de General Roca,Fuerte General Roca,GNR,General Roca,Kheneral'',hnrl rwqh,jnral rwka  ryw nyghrw,khnral rwka,luo ka jiang jun shi,Хенераль,חנרל רוקה,جنرال روكا، ريو نيغرو,خنرال روکا,ხენერალ-როკა,羅卡將軍市', -39.0333300, -67.5833300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1794, 'General Roca', 'General Roca', '', -32.7319600, -61.9159900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1795, 'General Ramírez', 'General Ramirez', 'General Ramirez,General Ramírez,Ramirez,Ramírez,Villa Ramirez,Villa Ramírez', -32.1760100, -60.2007900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1796, 'General Pinto', 'General Pinto', 'General Pinto,General Pintos', -34.7645900, -61.8909300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1797, 'General Pinedo', 'General Pinedo', 'General Pinedo,pi nei duo jiang jun zhen,皮內多將軍鎮', -27.3166700, -61.2833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1798, 'General Pico', 'General Pico', 'Cheneral Pikas,GPO,General Pico,Pico,hnrl pyqw,jynral bykw,khnral pykw,pi ke jiang jun zhen,חנרל פיקו,جينرال بيكو,خنرال پیکو,皮科將軍鎮', -35.6566200, -63.7568200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1799, 'General Martín Miguel de Güemes', 'General Martin Miguel de Gueemes', 'General Guemes,General Güemes,General Martin M. de Guemes,General Martin Miguel de Guemes,General Martín M. de Güemes,General Martín Miguel de Güemes,Guemes,Güemes', -24.6703400, -65.0476500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1800, 'General Manuel J. Campos', 'General Manuel J. Campos', 'General M.J. Campos,General Manuel Campos,General Manuel J. Campos', -37.4602500, -63.5853700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1801, 'General Levalle', 'General Levalle', '', -34.0147200, -63.9241300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1802, 'General Lavalle', 'General Lavalle', 'General Lavalle,Lavalle,Tulumaya,Villa Tulumaya', -32.7221800, -68.5913700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1803, 'General La Madrid', 'General La Madrid', '', -37.2475500, -61.2627300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1804, 'General Fernández Oro', 'General Fernandez Oro', 'General Fernandez Oro,General Fernández Oro', -38.9529700, -67.9248900, 'AR', '2015-12-09', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1805, 'General Enrique Mosconi', 'General Enrique Mosconi', '', -23.2166700, -62.3000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1806, 'General Enrique Mosconi', 'General Enrique Mosconi', 'Ciro Echesortu,General Enrique Mosconi,General Mosconi,Vespucio', -22.5958800, -63.8125500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1807, 'General Enrique Godoy', 'General Enrique Godoy', 'General E. Godoy,General Enrique Godoy,Godoy', -39.0833300, -67.1500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1808, 'General Conesa', 'General Conesa', 'Conesa,General Conesa', -40.1000000, -64.4333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1809, 'General Cabrera', 'General Cabrera', 'Cabrera,General Cabrera', -32.8131300, -63.8724300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1810, 'General Baldissera', 'General Baldissera', 'Colonia General Baldissera,General Baldissera', -33.1224600, -62.3063000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1811, 'General Arenales', 'General Arenales', 'Arenales,General Arenales', -34.3026400, -61.3052200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1812, 'General Alvear', 'General Alvear', 'General Alvear', -36.0207800, -60.0145000, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1813, 'General Alvear', 'General Alvear', 'Colonia de General Alvear,General Alvear', -34.9769600, -67.6911600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1814, 'General Acha', 'General Acha', 'General Acha', -37.3769800, -64.6043100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1815, 'Gastre', 'Gastre', 'Gastre,Gastres', -42.2751400, -69.2196700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1816, 'Garza', 'Garza', 'Garsa,Garza', -28.1532100, -63.5393500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1817, 'Gancedo', 'Gancedo', 'Gancedo', -27.4903800, -61.6757100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1818, 'Gálvez', 'Galvez', 'Galvez,Gálvez', -32.0292700, -61.2210300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1819, 'Gaimán', 'Gaiman', 'Gaiman,Gaimán', -43.2897000, -65.4929000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1820, 'Funes', 'Funes', 'Funes', -32.9156800, -60.8099500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1821, 'Frías', 'Frias', 'Frias,Frías', -28.6359300, -65.1310200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1822, 'Fray Luis Beltrán', 'Fray Luis Beltran', 'Fray L. Beltran,Fray L. Beltrán,Fray Luis Beltran,Fray Luis Beltrán,Luis Beltran,Luis Beltrán', -39.3166700, -65.7666700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1823, 'Fray Luis A. Beltrán', 'Fray Luis A. Beltran', 'Borghi,Fray Luis A. Beltran,Fray Luis A. Beltrán,Fray Luis Beltran,Fray Luís Beltrán', -32.7912200, -60.7281900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1824, 'Fraile Pintado', 'Fraile Pintado', 'Fraile Pintado', -23.9407900, -64.7994300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1825, 'Firmat', 'Firmat', 'Firmat', -33.4593700, -61.4832000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1826, 'Fiambalá', 'Fiambala', 'Fiambala,Fiambalá', -27.6870500, -67.6149000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1827, 'Fernández', 'Fernandez', 'Fernandez,Fernández', -27.9203700, -63.8934900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1828, 'Famatina', 'Famatina', 'Famatina', -28.9232200, -67.5225300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1829, 'Famaillá', 'Famailla', 'Famailla,Famaillá', -27.0541300, -65.4032900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1830, 'Etruria', 'Etruria', '', -32.9400800, -63.2466000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1831, 'Estanislao del Campo', 'Estanislao del Campo', 'Estancia del Campo,Estanislao del Campo', -25.0550400, -60.0921800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1832, 'Esquel', 'Esquel', 'EQS,Ehskel'',Eskelis,Esquel,ai si ke er,ayskywl,Эскель,אסקל,آيسكيول,埃斯克爾', -42.9114700, -71.3194700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1833, 'Esperanza', 'Esperanza', 'Esperanza', -31.4488000, -60.9317300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1834, 'Embarcación', 'Embarcacion', 'Embarcacion,Embarcación,ZAI', -23.2100300, -64.0996500, 'AR', '2015-05-23', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1835, 'Embalse', 'Embalse', 'Embalse', -32.1800000, -64.4180900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1836, 'Embajador Martini', 'Embajador Martini', 'Embajador Martini', -35.3863300, -64.2809200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1837, 'El Trébol', 'El Trebol', 'El Trebol,El Trébol', -32.2008000, -61.7014000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1838, 'El Tío', 'El Tio', '', -31.3835700, -62.8293800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1839, 'El Simbolar', 'El Simbolar', 'El Simbolar,Simbolar', -27.9716700, -64.8954400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1840, 'El Rodeo', 'El Rodeo', 'El Rodeo,Rodeo', -28.2151800, -65.8742000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1841, 'El Quebrachal', 'El Quebrachal', 'El Quebrachal', -25.2833300, -64.0666700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1842, 'El Maitén', 'El Maiten', 'EMX,El Maiten,El Maitén,Estancia El Maiten,Estancia El Maitén', -42.0492400, -71.1669300, 'AR', '2017-03-25', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1843, 'El Huecú', 'El Huecu', 'El Huecu,El Huecú', -37.6452200, -70.5800600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1844, 'El Hoyo', 'El Hoyo', 'El Hoyo,Hoyo', -27.0287200, -63.2319700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1845, 'El Galpón', 'El Galpon', 'El Galpon,El Galpón', -25.3806900, -64.6525900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1846, 'Elena', 'Elena', '', -32.5720500, -64.3948100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1847, 'El Cuy', 'El Cuy', 'El Cuy', -39.9268500, -68.3420800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1848, 'El Carril', 'El Carril', 'Carril,El Carril', -25.0741000, -65.4917400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1849, 'El Carmen', 'El Carmen', 'Carmen,El Carmen', -24.3868200, -65.2617700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1850, 'El Calafate', 'El Calafate', 'Calafate,Caserio de Calafates,Caserío de Calafates,Ehl'' Kalafate,El Calafate,El Kalafate,El Kalafatė,El''-Kalafate,FTE,Lago Argentino,Pueblo Calafate,ai er ka la fa te,alkalafat,elkallapate,karafate,Ель-Калафате,Эль Калафате,אל קלפטה,الكالافات,エル・カラファテ,カラファテ,埃尔卡拉法特,엘칼라파테', -50.3407500, -72.2768200, 'AR', '2017-07-20', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1851, 'El Bolsón', 'El Bolson', 'EHL,El Bolson,El Bolsonas,El Bolsón,ai er bo er song,אל בולסון,埃爾博爾松', -41.9605100, -71.5333600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1852, 'El Arañado', 'El Aranado', '', -31.7412000, -62.8932200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1853, 'El Alto', 'El Alto', 'El Alto,Villa El Alto', -28.3112300, -65.3639700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1854, 'El Aguilar', 'El Aguilar', 'Aguilar,El Aguilar', -23.2258200, -65.6921300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1855, 'Eduardo Castex', 'Eduardo Castex', 'Castex,E. Castex,Eduardo Castex', -35.9150100, -64.2944800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1856, 'Dolavón', 'Dolavon', 'Colonia Dolavon,Colonia Dolavón,Dolavon,Dolavón', -43.3000000, -65.7000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1857, 'Doblas', 'Doblas', '', -37.1496700, -64.0118300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1858, 'Diamante', 'Diamante', 'Diamante', -32.0664100, -60.6383700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1859, 'Devoto', 'Devoto', '', -31.4043100, -62.3063400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1860, 'Despeñaderos', 'Despenaderos', '', -31.8162600, -64.2898900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1861, 'Del Campillo', 'Del Campillo', '', -34.3765900, -64.4950400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1862, 'Deán Funes', 'Dean Funes', 'Dean Funes,Deán Funes', -30.4203600, -64.3498400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1863, 'Darwin', 'Darwin', 'Darwin', -39.2000000, -65.7666700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1864, 'Dalmacio Vélez Sársfield', 'Dalmacio Velez Sarsfield', 'D. Velez,D. Velez Sarsfield,D. Vélez,D. Vélez Sársfield,Dalmacio Velez,Dalmacio Velez Sarsfield,Dalmacio Vélez,Dalmacio Vélez Sársfield', -32.6107200, -63.5803800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1865, 'Daireaux', 'Daireaux', 'Caseros,Daireaux', -36.6000000, -61.7500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1866, 'Cutral-Có', 'Cutral-Co', 'CUT,Cutrai-Co,Cutrai-Có,Cutral-Co,Cutral-Có,Eva Peron,Eva Perón', -38.9342400, -69.2305200, 'AR', '2015-12-09', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1867, 'Cuchillo Có', 'Cuchillo Co', '', -38.3334900, -64.6433100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1868, 'Cruz del Eje', 'Cruz del Eje', 'Cruz del Eje', -30.7264400, -64.8038700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1869, 'Cruz Alta', 'Cruz Alta', '', -33.0088700, -61.8074600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1870, 'Crespo', 'Crespo', 'Crespo', -32.0287300, -60.3065800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1871, 'Costa Sacate', 'Costa Sacate', '', -31.6477000, -63.7593500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1872, 'Cosquín', 'Cosquin', 'Cosquin,Cosquín,Koskinas,ke si jin,kwskywn,كوسكيون,科斯金', -31.2450800, -64.4656300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1873, 'Corzuela', 'Corzuela', 'Corzuela', -26.9537400, -60.9692800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1874, 'Corralito', 'Corralito', '', -32.0246200, -64.1921600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1875, 'Corral de Bustos', 'Corral de Bustos', 'Corral de Bustos', -33.2820500, -62.1846300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1876, 'Coronel Suárez', 'Coronel Suarez', 'CSZ,Coronel Suarez,Coronel Suárez,Koronel Suarez,Koronel''-Suarez,Коронел Суарез,Коронель-Суарез', -37.4546700, -61.9334300, 'AR', '2016-03-06', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1877, 'Coronel Pringles', 'Coronel Pringles', 'Coronel Pringles,Pringles', -37.9829500, -61.3561500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1878, 'Coronel Moldes', 'Coronel Moldes', 'Coronel Moldes,Moldes', -33.6227000, -64.5971100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1879, 'Coronel Du Graty', 'Coronel Du Graty', 'Coronel Du Graty', -27.6803800, -60.9146200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1880, 'Coronel Dorrego', 'Coronel Dorrego', 'Coronel Dorrego,Dorrego', -38.7186700, -61.2873300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1881, 'Coronel Belisle', 'Coronel Belisle', 'Coronel Belisle', -39.1833300, -65.9833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1882, 'Coronel Baigorria', 'Coronel Baigorria', '', -32.8477000, -64.3610700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1883, 'Coronda', 'Coronda', 'Cordona,Coronda', -31.9726300, -60.9198300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1884, 'Córdoba', 'Cordoba', 'COR,Ciudad de Cordoba,Ciudad de Córdoba,Cordoba,Cordoba i Argentina,Cordova,Corduba,Còrdoba,Córdoba,Córdoba i Argentina,Córdova,Gorad Kordava,Kordoba,Kordobo,Kordov,Kordova,Kordova khot,Kordovae,Kuorduoba,Vila de Cordoba,Vila de Córdoba,kardwba,ke er duo wa,koleudoba,kordoba,korudoba,kwrdwba,kwrdwba  arzhantyn,kxr do ba,qwrdwbh,Κόρδοβα,Горад Кордава,Кордоба,Кордовæ,Кордова,Кордова хот,Կորդովա,קארדאבע,קורדובה,قرطبہ، ارجنٹائن,كوردوبا,کاردوبا,کوردوبا، آرژانتین,कोर्दोबा,กอร์โดบา,კორდოვა,コルドバ,科尔多瓦,코르도바', -31.4135000, -64.1810500, 'AR', '2016-07-29', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1885, 'Contraalmirante Cordero', 'Contraalmirante Cordero', 'Contraalmirante Cordero,Contralmirante Cordero', -38.7242300, -68.1528400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1886, 'Concepción del Bermejo', 'Concepcion del Bermejo', 'Concepcion del Bermejo,Concepción del Bermejo', -26.5992600, -60.9461700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1887, 'Concepción', 'Concepcion', 'Concepcion,Concepción,Konsepsjonas,kang sai pu xi weng,knspsywn  twkwman,kwnsbsywn  twkwman,qwnspsywn,קונספסיון,كونسبسيون، توكومان,کنسپسیون، توکومان,康塞普西翁', -27.3412700, -65.5963600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1888, 'Concarán', 'Concaran', 'Concaran,Concarán,Concoran,Dolores,Villa Dolores', -32.5600900, -65.2427000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1889, 'Comodoro Rivadavia', 'Comodoro Rivadavia', 'CRD,Comodoro,Comodoro Rivadavia,Komodoro Rivadavija,Komodoro-Rivadavija,Komorodo Rivadavia,komodololibadabia,kwmwdwrw ryfadafya,kwmwdwrw rywadawya,li wa da wei ya hai jun zhun jiang cheng,qwmwdwrw rybdbyh,Комодоро Ривадавия,Комодоро Ривадавија,Комодоро-Ривадавия,Комодоро-Рівадавія,Կոմորոդո Ռիվադավիա,קומודורו ריבדביה,كومودورو ريفادافيا,کومودورو ریواداویا,コモドーロ・リバダビア,里瓦达维亚海军准将城,코모도로리바다비아', -45.8641300, -67.4965600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1890, 'Comandante Luis Piedra Buena', 'Comandante Luis Piedra Buena', 'Casa de Piedra,Comandante L. Piedrabuena,Comandante Luis Piedra Buena,El Paso,Piedra Buena', -49.9851300, -68.9146700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1891, 'Comallo', 'Comallo', 'Comallo', -41.0299300, -70.2678400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1892, 'Colonia San Bartolomé', 'Colonia San Bartolome', 'Colonia San Bartolome,Colonia San Bartolomé,San Bartolome,San Bartolomé', -31.5278000, -62.7243600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1893, 'Colonia La Tordilla', 'Colonia La Tordilla', '', -31.2374600, -63.0613400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1894, 'Colonia Dora', 'Colonia Dora', 'Colonia Dora', -28.6000000, -62.9500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1895, 'Colonia Barón', 'Colonia Baron', 'Colonia Baron,Colonia Barón', -36.1515200, -63.8540400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1896, 'Colón', 'Colon', 'Colon,Colón', -33.8951200, -61.1011000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1897, 'Clodomira', 'Clodomira', 'Clodomira', -27.5744000, -64.1310800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1898, 'Cipolletti', 'Cipolletti', 'CPZ,Chipolletti,Cipoletis,Cipoletti,Cipolleti,Cipolletti,kybwlyty,sypwyty,xi bo lie di,zypwlty,Čipoletis,Чиполлетти,Чіполлетті,Չիպոլետի,ציפולטי,سیپویتی,كيبوليتي,სიპოლიეტი,西波列蒂', -38.9339200, -67.9903200, 'AR', '2015-12-09', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1899, 'Cintra', 'Cintra', '', -32.3067300, -62.6521400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1900, 'Cinco Saltos', 'Cinco Saltos', 'Cinco Saltos', -38.8222500, -68.0629300, 'AR', '2015-12-09', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1901, 'Chumbicha', 'Chumbicha', 'Chumbicha', -28.8543000, -66.2350000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1902, 'Chos Malal', 'Chos Malal', 'Chos Malal,Chos-Malal'',Cos Malalis,HOS,qiao si ma la er,Čos Malalis,Чос-Малаль,Չոս Մալալ,喬斯馬拉爾', -37.3780900, -70.2708500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1903, 'Chorotis', 'Chorotis', 'Chorotis', -27.9157800, -61.3998200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1904, 'Choele Choel', 'Choele Choel', 'C. Choel,Choele Choel', -39.2666700, -65.6833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1905, 'Chivilcoy', 'Chivilcoy', 'Chivilcoy,chywylkwy,qi wei er ke yi,tshyfylkwy,تشيفيلكوي,چیویلکوی,奇維爾科伊', -34.8956600, -60.0166700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1906, 'Chimpay', 'Chimpay', 'Chimpay', -39.1648200, -66.1423600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1907, 'Chimbas', 'Chimbas', 'Chimbas', -31.4833300, -68.5333300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1908, 'Chilecito', 'Chilecito', 'Chilecito,Chilesito,Cilesitas,chylsytw,qi lai xi tuo,zylsytw,Čilesitas,Чилесито,Чілесіто,Չիլեսիտո,צילסיטו,چیلسیتو,奇萊西托', -29.1619500, -67.4974000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1909, 'Chicoana', 'Chicoana', 'Chicoana', -25.1008800, -65.5331000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1910, 'Chichinales', 'Chichinales', 'Chichinales,Chinchinales', -39.1150500, -66.9271400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1911, 'Chepes', 'Chepes', '', -31.3500000, -66.6000000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1912, 'Chazón', 'Chazon', '', -33.0787200, -63.2765700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1913, 'Charras', 'Charras', '', -33.0240000, -64.0471900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1914, 'Charata', 'Charata', 'CNT,Charata,Charatas,cha la ta,sharata,شاراتا,查拉塔', -27.2143800, -61.1879500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1915, 'Chamical', 'Chamical', 'Chamical,Gobernador Gordillo', -30.3600200, -66.3139900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1916, 'Chacabuco', 'Chacabuco', 'Chacabuco,Chakabuko,Чакабуко', -34.6416700, -60.4738900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1917, 'Cervantes', 'Cervantes', 'Cervantes', -39.0500000, -67.3833300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1918, 'Cerrillos', 'Cerrillos', 'Cerrillos', -24.8983300, -65.4870600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1919, 'Ceres', 'Ceres', 'CRR,Ceres', -29.8810000, -61.9450400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1920, 'Centenario', 'Centenario', 'Centenario,Colonia Centenario', -38.8295500, -68.1318000, 'AR', '2015-12-09', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1921, 'Cavanagh', 'Cavanagh', '', -33.4760600, -62.3388800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1922, 'Caucete', 'Caucete', 'Caucete,Kausete,Kausetė,Villa Colon,Villa Colón,kao sai te,考塞特', -31.6517900, -68.2810500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1923, 'Catriló', 'Catrilo', 'Catrilo,Catriló', -36.4059700, -63.4216800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1924, 'Catriel', 'Catriel', 'CCT,Catriel', -37.8790700, -67.7956000, 'AR', '2016-03-06', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1925, 'Castro Barros', 'Castro Barros', 'Castro Barros', -30.5795200, -65.7269600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1926, 'Castelli', 'Castelli', 'Castelli,Colonia Castelli,J.J. Castelli,Juan Jose Castelli,Juan José Castelli', -25.9467900, -60.6194700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1927, 'Casilda', 'Casilda', 'Casilda', -33.0441700, -61.1680600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1928, 'Carrilobo', 'Carrilobo', '', -31.8729600, -63.1171500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1929, 'Carnerillo', 'Carnerillo', '', -32.9137100, -64.0217500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1930, 'Carmen de Patagones', 'Carmen de Patagones', 'CPG,Carmen de Patagones,Karmen de Patagones,Karmen-de-Patagones,Patagones,qrmn dh ptgwns,Кармен де Патагонес,Кармен-де-Патагонес,Կարմեն դե Պատագոնես,קרמן דה פטגונס', -40.7982800, -62.9809700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1931, 'Carlos Tejedor', 'Carlos Tejedor', 'C. Tejedor,Carlos Tejedor,Tejedor', -35.3926500, -62.4214600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1932, 'Carlos Casares', 'Carlos Casares', 'Antonio Maya,C. Casares,Carlos Casares', -35.6217100, -61.3616900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1933, 'Carhué', 'Carhue', 'Adolfo Alsina,Carhue,Carhué', -37.1766800, -62.7579200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1934, 'Carcarañá', 'Carcarana', 'Carcarana,Carcarañá', -32.8567900, -61.1533100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1935, 'Capitán Bermúdez', 'Capitan Bermudez', 'Capitan Bermudez,Capitán Bermúdez,Juan Ortiz,Juan Ortíz,Villa Cassini', -32.8226200, -60.7185200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1936, 'Capilla del Monte', 'Capilla del Monte', 'Capilla del Monte,Kapilja del Monte,Kapilja del Montė,ka pi ya de er meng te,卡皮亞德爾蒙特', -30.8608800, -64.5251500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1937, 'Capayán', 'Capayan', 'Capayan,Capayán', -28.7610500, -66.0502500, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1938, 'Candelaria', 'Candelaria', 'Candelaria', -32.0603600, -65.8247700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1939, 'Canals', 'Canals', '', -33.5654200, -62.8892700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1940, 'Cañada de Luque', 'Canada de Luque', '', -30.7334100, -63.7237500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1941, 'Cañada de Gómez', 'Canada de Gomez', 'Canada de Gomez,Cañada de Gómez,Ciudad Evita,Ciudad de Gomez,Ciudad de Gómez,Kanada-de-Gomes,Канада-де-Гомес', -32.8163600, -61.3949300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1942, 'Campo Quijano', 'Campo Quijano', 'Campo Quijano,Quijana,Quijano', -24.9098200, -65.6365600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1943, 'Campo Largo', 'Campo Largo', 'Campo Largo', -26.8007700, -60.8421500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1944, 'Campo Gallo', 'Campo Gallo', 'Campo Gallo', -26.5833300, -62.8500000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1945, 'Camilo Aldao', 'Camilo Aldao', 'Aldao,C. Aldao,Caldao,Camilo Aldao', -33.1274500, -62.0945300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1946, 'Camarones', 'Camarones', 'Camarones,Kamaronesas,ka ma luo nei si,卡馬羅內斯', -44.7970900, -65.7099400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1947, 'Calingasta', 'Calingasta', 'Calingasta', -31.3308400, -69.4078300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1948, 'Calilegua', 'Calilegua', 'Calilegua', -23.7736800, -64.7700200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1949, 'Caleufú', 'Caleufu', 'Caleufu,Caleufú', -35.5955900, -64.5577800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1950, 'Caleta Olivia', 'Caleta Olivia', 'CVI,Caleta Olivia,Kaleta Olivia,Kaleta Olivija,Kaleta-Olivija,ka lai ta ao li wei ya,kalta awlywya,Калета-Оливия,Կալետա Օլիվիա,קלטה אוליביה,کالتا اولیویا,卡萊塔奧利維亞', -46.4392900, -67.5281400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1951, 'Calchaquí', 'Calchaqui', 'Calchaqui,Calchaquí,Luis d''Abreu,Luis d’Abreu', -29.8876700, -60.2869700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1952, 'Caimancito', 'Caimancito', 'Caimancito', -23.7406900, -64.5937000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1953, 'Cafayate', 'Cafayate', 'Cafayate,Cafayete,Kafajat,Kafajate,Kafajatė,ka fa ya te,kafayath,Кафайат,קפזאטה,کافایاته,卡法亞特', -26.0728600, -65.9776600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1954, 'Cachí', 'Cachi', 'Cachi,Cachí', -25.1203300, -66.1651900, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1955, 'Buta Ranquil', 'Buta Ranquil', 'Buta Ranquil', -37.0522200, -69.8771300, 'AR', '2017-05-28', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1956, 'Burruyacú', 'Burruyacu', 'Burruyaco,Burruyacu,Burruyacú', -26.4991800, -64.7420600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1957, 'Buena Esperanza', 'Buena Esperanza', 'B. Esperanza,Buena Esperanza', -34.7564700, -65.2537900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1958, 'Buchardo', 'Buchardo', '', -34.7226300, -63.5092000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1959, 'Brinkmann', 'Brinkmann', 'Brinkman,Brinkmann', -30.8658900, -62.0374200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1960, 'Brea Pozo', 'Brea Pozo', 'Brea Pozo', -28.2438200, -63.9509100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1961, 'Bragado', 'Bragado', 'Bragado,QRF,bragadw,braghdw,bu la jia duo,براغدو,براگادو,布拉加多', -35.1191200, -60.4896600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1962, 'Berrotarán', 'Berrotaran', '', -32.4510000, -64.3886700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1963, 'Bernasconi', 'Bernasconi', '', -37.9045900, -63.7424000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1964, 'Bernardo Larroudé', 'Bernardo Larroude', 'B. Larroude,B. Larroudé,Benjamin Larroude,Bernardo Larroude,Bernardo Larroudé,Larroude', -35.0244900, -63.5825300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1965, 'Beltrán', 'Beltran', 'Beltran,Beltrán', -27.8291300, -64.0609800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1966, 'Bell Ville', 'Bell Ville', 'Bell Ville,bei er wei er,bl wyl,byl fyl,بل ویل,بيل فيل,貝爾維爾', -32.6259100, -62.6887300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1967, 'Bella Vista', 'Bella Vista', 'Bella Vista', -27.0342400, -65.3019600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1968, 'Belén', 'Belen', 'Belen,Belenas,Belén,bei lun,bln,בלן,貝倫', -27.6510300, -67.0286900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1969, 'Barrancas', 'Barrancas', 'Barrancas', -36.8166700, -69.9166700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1970, 'Bandera', 'Bandera', 'Bandera', -28.8884000, -62.2660000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1971, 'Banda del Río Salí', 'Banda del Rio Sali', 'Banda del Rio Sali,Banda del Río Salí', -26.8333300, -65.1666700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1972, 'Bañado de Ovanta', 'Banado de Ovanta', 'Banado,Banado de Ovanta,Bañado,Bañado de Ovanta', -28.1056400, -65.3188400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1973, 'Balnearia', 'Balnearia', '', -31.0088000, -62.6673300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1974, 'Bahía Blanca', 'Bahia Blanca', 'BHI,Bahia Blanca,Bahija Blanka,Bahía Blanca,Baija Blanka,Baija-Blanka,Baija-Blankae,Bajja-Blanka,bahya blanka,baiabeullangka,baiaburanka,bayya blanka,bu lan ka gang,Баия-Бланкæ,Баия-Бланка,Баија Бланка,Байя-Бланка,Баїя-Бланка,באיה בלנקה,باهيا بلانكا,باییا بلانکا,ბაია-ბლანკა,バイアブランカ,布兰卡港,바이아블랑카', -38.7195900, -62.2724300, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1975, 'Aviá Terai', 'Avia Terai', 'Avia Terai,Aviá Terai', -26.6853200, -60.7292000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1976, 'Arrufó', 'Arrufo', 'Arrufo,Arrufó,Arruto,Arrutó', -30.2328100, -61.7286200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1977, 'Arroyo Seco', 'Arroyo Seco', 'Aguirre,Arroyo Seco,Posta de San Martin,Posta de San Martín', -33.1548900, -60.5086300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1978, 'Arroyo Cabral', 'Arroyo Cabral', '', -32.4911900, -63.4012600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1979, 'Arroyito', 'Arroyito', 'Arroyito', -31.4202200, -63.0500200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1980, 'Arrecifes', 'Arrecifes', 'Arrecifes,Bartolome Mitre,Bartolomé Mitre', -34.0639000, -60.1035700, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1981, 'Arraga', 'Arraga', 'Arraga', -28.0497800, -64.2225400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1982, 'Armstrong', 'Armstrong', 'Armstrong', -32.7821500, -61.6022200, 'AR', '2016-06-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1983, 'Arias', 'Arias', 'Arias', -33.6441100, -62.4027200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1984, 'Arauco', 'Arauco', 'Arauca,Arauco', -28.5805000, -66.7943800, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1985, 'Arata', 'Arata', '', -35.6389500, -64.3562100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1986, 'Aranguren', 'Aranguren', 'Aranguren', -32.2425200, -60.1610700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1987, 'Apolinario Saravia', 'Apolinario Saravia', 'Apolinario Saravia', -24.4327600, -63.9953500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1988, 'Antofagasta de la Sierra', 'Antofagasta de la Sierra', 'Antofagasta de la Sierra', -26.0594000, -67.4063600, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1989, 'Anguil', 'Anguil', 'Anguil', -36.5256700, -64.0102500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1990, 'Añelo', 'Anelo', 'Anelo,Añelo', -38.3544100, -68.7884000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1991, 'Andalgalá', 'Andalgala', 'Andalgala,Andalgalá', -27.6001200, -66.3179400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1992, 'Andacollo', 'Andacollo', 'Andacollo', -37.1794500, -70.6691200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1993, 'Ancasti', 'Ancasti', 'Ancasti', -28.8124700, -65.5014500, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1994, 'Añatuya', 'Anatuya', 'Anatuya,Añatuya,Unatuya,Uñatuya', -28.4606400, -62.8347200, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1995, 'Aminga', 'Aminga', 'Aminga', -28.8426000, -66.9454600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1996, 'Florentino Ameghino', 'Florentino Ameghino', '', -34.8440500, -62.4670100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1997, 'Aluminé', 'Alumine', 'Alumine,Aluminé,Rucachoroi', -39.2368600, -70.9197000, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1998, 'Altos de Chipión', 'Altos de Chipion', '', -30.9559000, -62.3372700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(1999, 'Alto Río Senguer', 'Alto Rio Senguer', 'ARR,Alto Rio Senguer,Alto Rio Senguerr,Alto Río Senguer,Alto Río Senguerr,Brazo Norte', -45.0410500, -70.8198200, 'AR', '2017-03-24', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2000, 'Alta Italia', 'Alta Italia', '', -35.3335000, -64.1149600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2001, 'Alta Gracia', 'Alta Gracia', 'Al''ta-Gracija,Alta Gracia,Alta Grasija,alta ghrasya,alta grasya,shang ge la xi ya,Алта Грасия,Альта-Грация,آلتا گراسیا,ألتا غراسيا,上格拉西亞', -31.6529200, -64.4282600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2002, 'Alpachiri', 'Alpachiri', 'Alpachiri', -37.3770400, -63.7744500, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2003, 'Almafuerte', 'Almafuerte', '', -32.1929600, -64.2555900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2004, 'Allen', 'Allen', 'Allen,LLZ,alyn  ryw ngrw,الین، ریو نگرو', -38.9773600, -67.8271400, 'AR', '2015-12-09', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2005, 'Algarrobo del Águila', 'Algarrobo del Aguila', 'Algarrobo del Aguila,Algarrobo del Aguilla,Algarrobo del Águila,El Aguila,El Aguilla', -36.3996800, -67.1451100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2006, 'Alejo Ledesma', 'Alejo Ledesma', 'A. Ledesma,Alejo Ledesma,Ledesma', -33.6064300, -62.6230400, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2007, 'Alejandro Roca', 'Alejandro Roca', 'Alejandro,Alejandro Roca', -33.3536900, -63.7184900, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2008, 'Alderetes', 'Alderetes', 'Alderetes', -26.8166700, -65.1333300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2009, 'Alberti', 'Alberti', 'Alberti', -35.0269200, -60.2758700, 'AR', '2016-03-10', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2010, 'Albardón', 'Albardon', 'Albardon,Albardón', -31.4372200, -68.5255600, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2011, 'Aimogasta', 'Aimogasta', 'Aimogasta', -28.5609100, -66.8058800, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2012, 'Aguilares', 'Aguilares', 'Aguilares', -27.4338000, -65.6142700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2013, 'Agua de Oro', 'Agua de Oro', '', -31.0666100, -64.3001700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2014, 'Adelia María', 'Adelia Maria', '', -33.6315200, -64.0209700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2015, 'Achiras', 'Achiras', '', -33.1753800, -64.9933100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2016, 'Abra Pampa', 'Abra Pampa', 'Abra Pampa', -22.7204900, -65.6969700, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2017, 'Villa Santa Rita', 'Villa Santa Rita', '', -34.6108200, -58.4810000, 'AR', '2017-05-08', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2018, 'Bella Italia', 'Bella Italia', '', -31.2726800, -61.4239600, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2019, 'Cariló', 'Carilo', 'Karilo,Карило', -37.1652400, -56.8913300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2020, 'Villa Mercedes', 'Villa Mercedes', 'VME,Vila Mersedes,Vilja Mersedesas,biyameleusedeseu,fyla mrsyds  san lwys,mei sai de si zhen,vilia-mersedesi,wyya mrsds,wyzh mrsds,Виља Мерседес,ויזה מרסדס,فيلا مرسيدس، سان لويس,وییا مرسدس,ვილია-მერსედესი,ビジャ・メルセデス,梅塞德斯鎮,비야메르세데스', -33.6757100, -65.4578300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2021, 'La Punta', 'La Punta', '', -33.1836800, -66.3127000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2022, 'Villa Berna', 'Villa Berna', '', -31.9032100, -64.7565100, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2023, 'Cuesta Blanca', 'Cuesta Blanca', '', -31.4865800, -64.5715000, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2024, 'Avellaneda', 'Avellaneda', 'Avel''janeda,Avelaneda,Aveljaneda,a wei ya nei da,abejaneda,abeyaneda,avelianeda,awyanda,Авельянеда,Авелянеда,Авељанеда,אבזאנדה,آویاندا,აველიანედა,アベジャネーダ,阿韦亚内达,아베야네다', -34.6601800, -58.3674400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2025, 'San Carlos de Bariloche', 'San Carlos de Bariloche', 'BRC,Bariloce,Bariloche,Bariloĉe,San Carlos de Bariloche,San Karlos de Bariloce,San Karlos de Bariloche,San Karlos de Bariločė,San-Karlos-de-Bariloche,barylwchh,barylwtshy,bʼrylwzh,sankaleulloseudebalilloche,sheng ka luo si-de ba li luo qie,Сан Карлос де Барилоче,Сан-Карлос-де-Барилоче,Сан-Карлос-де-Барілоче,Սան Կառլոս դե Բարիլոչե,בארילוצה,باريلوتشي,باریلوچه,باریلۆچی,სან-კარლოს-დე-ბარილოჩე,サン・カルロス・デ・バリローチェ,圣卡洛斯-德巴里洛切,산카를로스데바릴로체', -41.1455700, -71.3082200, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2026, 'Santa Catalina - Dique Lujan', 'Santa Catalina - Dique Lujan', '', -34.3837500, -58.7067300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2027, 'Río Turbio', 'Rio Turbio', 'RYO,Rio Turbio,Río Turbio', -51.5358700, -72.3367300, 'AR', '2016-01-30', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2028, 'Adrogué', 'Adrogue', '', -34.8004100, -58.3838400, 'AR', '2015-04-22', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2029, 'Los Laureles', 'Los Laureles', '', -29.3684700, -59.7363400, 'AR', '2016-03-20', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2030, 'Gato Colorado', 'Gato Colorado', '', -28.0221900, -61.1866300, 'AR', '2016-03-20', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2031, 'Tolhuin', 'Tolhuin', '', -54.5108300, -67.1955000, 'AR', '2016-04-19', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2032, 'Villa General Guemes', 'Villa General Guemes', '', -24.7553000, -59.4894000, 'AR', '2016-04-21', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2033, 'Rincón de Los Sauces', 'Rincon de Los Sauces', 'RDS', -37.3984400, -68.9287400, 'AR', '2017-03-24', 11);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2048, 'Neu-Guntramsdorf', 'Neu-Guntramsdorf', '', 48.0642000, 16.3157300, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2049, 'Kleinarl', 'Kleinarl', '', 47.2772500, 13.3195500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2050, 'Edelstauden', 'Edelstauden', 'Edelstauden', 46.9833300, 15.6166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2051, 'Neuhaus am Klausenbach', 'Neuhaus am Klausenbach', 'Dobra,Neuhaus am Klausenbach,Nojkhaus-am-Klauzenbakh,Nojkhaus-na-Klauzenbakhe,Vas-Dobra,Vasdobra,ke lao sen ba he he pan nuo yi hao si,Нойхаус-ам-Клаузенбах,Нойхаус-на-Клаузенбахе,克劳森巴赫河畔诺伊豪斯', 46.8666700, 16.0333300, 'AT', '2013-12-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2052, 'Millstatt', 'Millstatt', 'Mil''shtatt,Millstatt,Millstatt am See,Мильштатт', 46.8041700, 13.5805600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2053, 'Zwölfaxing', 'Zwoelfaxing', '', 48.1099000, 16.4626700, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2054, 'Zwettl Stift', 'Zwettl Stift', 'Stift Zwettl,Zwettl Stift', 48.6166700, 15.2000000, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2055, 'Zwettl an der Rodl', 'Zwettl an der Rodl', 'Zwettl,Zwettl an der Rodl', 48.4655200, 14.2713300, 'AT', '2011-12-20', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2056, 'Zurndorf', 'Zurndorf', 'Curndorf,Zurany,Zurndorf,Zurány,Цурндорф', 47.9831400, 17.0031500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2057, 'Zöblen', 'Zoblen', 'Zoblen,Zöblen', 47.5077200, 10.4797100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2058, 'Zöbern', 'Zobern', '', 47.5145900, 16.1311100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2059, 'Zistersdorf', 'Zistersdorf', 'Cistejov,Cistersdorf,Zistersdorf,qi si te si duo fu,Čistejov,Цистерсдорф,齊斯特斯多夫', 48.5425200, 16.7613600, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2060, 'Zirl', 'Zirl', 'Cirl,Zirl,Цирл', 47.2741000, 11.2396100, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2061, 'Zillingtal', 'Zillingtal', 'Celindrof,Cillingtal'',Voelgyfalva,Völgyfalva,Zillingtal,Циллингталь', 47.8144200, 16.4092800, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2062, 'Zillingdorf', 'Zillingdorf', 'Zillingdorf', 47.8500000, 16.3333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2063, 'Ziersdorf', 'Ziersdorf', 'Cirsdorf,Kiblic,qi si duo fu,Киблиц,Цирсдорф,齐斯多夫', 48.5303000, 15.9269100, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2064, 'Zeutschach', 'Zeutschach', 'Zeutschach', 47.0666700, 14.3666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2065, 'Zettling', 'Zettling', 'Zettling', 46.9522000, 15.4342000, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2066, 'Zerlach', 'Zerlach', 'Zerlach', 46.9459300, 15.6509300, 'AT', '2017-06-21', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2067, 'Zeltweg', 'Zeltweg', 'Cel''tveg,Celtveg,Zeltweg,ce er te wei ge,Целтвег,Цельтвег,策尔特韦格', 47.1833300, 14.7500000, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2068, 'Zellerndorf', 'Zellerndorf', '', 48.6965700, 15.9584100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2069, 'Zellberg', 'Zellberg', 'Zellberg', 47.2333300, 11.8500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2070, 'Zell an der Pram', 'Zell an der Pram', 'Zell,Zell an der Pram', 48.3162500, 13.6292300, 'AT', '2017-06-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2071, 'Zell am Ziller', 'Zell am Ziller', 'Cell''-am-Ciller,Cell''-na-Cillere,Zell,Zell am Ziller,Zell in Zillerthal,qi lei he gu cai er,Целль-ам-Циллер,Целль-ам-Ціллер,Целль-на-Циллере,齐勒河谷采尔', 47.2333300, 11.8833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2072, 'Zell am See', 'Zell am See', 'Cel am Ze,Cel am Zee,Cell''-am-Ze,Cell''-am-Zee,Zaei am See,Zell am See,Zell in the Pinzgau,Zäi am See,bin hu cai er,chel-amje,tsyl am zyh,Цел ам Зе,Цел ам Зее,Целль-ам-Зе,Целль-ам-Зее,تسيل أم زيه,ツェル・アム・ゼー,滨湖采尔,첼암제', 47.3255600, 12.7944400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2073, 'Zell am Pettenfirst', 'Zell am Pettenfirst', 'Zell am Pettenfirst', 48.0800900, 13.5993600, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2074, 'Zell am Moos', 'Zell am Moos', 'Cell''-am-Mos,Cell''-na-Mose,Zell,Zell am Moos,zhao ze fu jin ce er,Целль-ам-Мос,Целль-на-Мосе,沼泽附近策尔', 47.9000000, 13.3166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2075, 'Zeillern', 'Zeillern', '', 48.1302900, 14.8076000, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2076, 'Zederhaus', 'Zederhaus', '', 47.1557000, 13.5057600, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2077, 'Zams', 'Zams', 'Cams,cha mu si,Цамс,察姆斯', 47.1584400, 10.5897000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2078, 'Zagersdorf', 'Zagersdorf', 'Cogrstof,Cogrštof,Zagersdorf,Zarany,Zárány,Загерсдорф', 47.7647100, 16.5138200, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2079, 'Ybbsitz', 'Ybbsitz', 'Ibzic,yi bu xi ci,Ибзиц,یببسٹز,伊布西茨', 47.9474500, 14.8918000, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2080, 'Ybbs an der Donau', 'Ybbs an der Donau', 'Ibbs,Ibosa do Danubio,Ibs-an-der-Donau,Ibs-na-Dunae,Ipozonalco,Ips,Jivice na Dunavu,Ybbs,Ybbs an der Donau,duo nao he pan yi bu si,ybbs an dr dwnw,Íbosa do Danúbio,Îps,Īpozōnalco,İps,Ибс-ан-дер-Донау,Ибс-на-Дунае,یببس ان در دونو,多瑙河畔伊布斯', 48.1666700, 15.0833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2081, 'Würmla', 'Wurmla', '', 48.2549700, 15.8603100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2082, 'Würflach', 'Wurflach', '', 47.7764800, 16.0546300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2083, 'Wundschuh', 'Wundschuh', 'Wundschuh', 46.9263900, 15.4511100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2084, 'Wullersdorf', 'Wullersdorf', '', 48.6279200, 16.1008900, 'AT', '2013-07-30', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2085, 'Wulkaprodersdorf', 'Wulkaprodersdorf', 'Vul''kaprodersdorf,Vulkapordany,Vulkapordány,Vulkaprodrstof,Vulkaprodrštof,Wulkaprodersdorf,Вулькапродерсдорф', 47.7975300, 16.5044700, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2086, 'Wörth an der Lafnitz', 'Woerth an der Lafnitz', 'Worth,Worth an der Lafnitz,Wörth,Wörth an der Lafnitz', 47.2136800, 16.0808100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2087, 'Wörterberg', 'Worterberg', '', 47.2166700, 16.1000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2088, 'Wörschach', 'Worschach', 'Worschach,Wörschach', 47.5500000, 14.1500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2089, 'Wörgl', 'Worgl', 'QXZ,V''orgul,Vergl,Vergl'',Vernkl,Vjorgl'',Woergl,Worgl,Wörgl,vergli,vu~eruguru,wo ge er,Βεργκλ,Вергл,Вергль,Вьоргъл,Вёргль,ვერგლი,ヴェルグル,沃格爾', 47.4890600, 12.0617400, 'AT', '2015-11-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2090, 'Wördern', 'Wordern', '', 48.3340000, 16.2101600, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2091, 'Wolkersdorf im Weinviertel', 'Wolkersdorf im Weinviertel', 'Vol''kersdorf-im-Vajnfirtel'',Wolkersdorf,Wolkersdorf im Weinviertel,wei yin de qu wo er ke er si duo fu,Волькерсдорф-им-Вайнфиртель,ವೊಲ್ಕರ್ಸ್ಡೊರ್ಫ್‌,韦因地区沃尔克尔斯多夫', 48.3833300, 16.5166700, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2092, 'Wolfurt', 'Wolfurt', 'Kirchdorf,Vol''furt,Volfurt,Wolfurt,wlfwrt,wo er fu te,Волфурт,Вольфурт,ولفورت,沃尔富特', 47.4666700, 9.7500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2093, 'Wolfsthal', 'Wolfsthal', 'Vol''fstal'',wo er fu shi ta er,Вольфсталь,וולפסטאל,沃尔夫施塔尔', 48.1333300, 17.0000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2094, 'Wolfsgraben', 'Wolfsgraben', 'Vol''fsgraben,wo er fu si ge la ben,Вольфсграбен,沃尔夫斯格拉本', 48.1587000, 16.1209800, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2095, 'Wolfsegg am Hausruck', 'Wolfsegg am Hausruck', 'Wolfsegg,Wolfsegg am Hausruck', 48.1066900, 13.6727400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2096, 'Wolfsberg im Schwarzautal', 'Wolfsberg im Schwarzautal', 'Wolfsberg,Wolfsberg im Schwarzautal', 46.8438900, 15.6588900, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2097, 'Wolfsberg', 'Wolfsberg', 'Wolfsberg', 46.8405600, 14.8441700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2098, 'Wolfsbach', 'Wolfsbach', '', 48.0666700, 14.6666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2099, 'Wolfpassing', 'Wolfpassing', '', 48.0778500, 15.0645300, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2100, 'Wolfau', 'Wolfau', '', 47.2500000, 16.1000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2101, 'Winklern bei Oberwölz', 'Winklern bei Oberwoelz', 'Winklern,Winklern bei Oberwolz,Winklern bei Oberwölz', 47.2000000, 14.2333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2102, 'Winklern', 'Winklern', 'Vinklern,wen ke lei en,Винклерн,温克勒恩', 46.8736100, 12.8747200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2103, 'Winklarn', 'Winklarn', '', 48.0833300, 14.8333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2104, 'Windigsteig', 'Windigsteig', '', 48.7666700, 15.2833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2105, 'Winden am See', 'Winden am See', 'Binta,Sasony,Sásony,Vinden-am-Zee,Winden,Winden am See,Винден-ам-Зее', 47.9500000, 16.7500000, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2106, 'Wimpassing an der Leitha', 'Wimpassing an der Leitha', 'Vimpac,Vimpas,Vimpassing-na-Lajte,Vimpác,Wimpassing,Wimpassing an der Leitha,Вимпассинг-на-Лайте', 47.9166700, 16.4333300, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2107, 'Wimpassing im Schwarzatale', 'Wimpassing im Schwarzatale', '', 47.7029500, 16.0333400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2108, 'Willendorf am Steinfelde', 'Willendorf am Steinfelde', '', 47.7892900, 16.0568600, 'AT', '2012-01-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2109, 'Wilhelmsburg', 'Wilhelmsburg', '', 48.1057100, 15.6053900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2110, 'Wilfersdorf', 'Wilfersdorf', '', 48.5833300, 16.6333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2111, 'Wildon', 'Wildon', 'Vil''don,Wildon,wei er dong,Вильдон,维尔东', 46.8833300, 15.5166700, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2112, 'Wildermieming', 'Wildermieming', '', 47.3166700, 11.0166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2113, 'Wildalpen', 'Wildalpen', 'Vil''dal''pen,Wildalpen,wei er da er peng,Вильдальпен,维尔达尔彭', 47.6500000, 14.9833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2114, 'Wiesmath', 'Wiesmath', '', 47.6166700, 16.2833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2115, 'Wiesing', 'Wiesing', '', 47.4048600, 11.7970800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2116, 'Wiesfleck', 'Wiesfleck', '', 47.3845800, 16.1455200, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2117, 'Wiesen', 'Wiesen', 'Bizmet,Retfalu,Rétfalu', 47.7377600, 16.3379800, 'AT', '2015-12-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2118, 'Wieselburg', 'Wieselburg', 'Omatoyac,Viselburgo,Vizel''burg,Wieselburg,wei se er bao,Ōmātōyāc,Визельбург,维瑟尔堡', 48.1333300, 15.1333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2119, 'Wies', 'Wies', 'Vis,wei si,Вис,维斯', 46.7202800, 15.2719400, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2120, 'Wiener Neustadt', 'Wiener Neustadt', 'Becko Novo Mjesto,Becsujhely,Becsujvaros,Bečko Novo Mjesto,Bécsújhely,Bécsújváros,Dunajsko Novo mesto,Nemet-Ujhely,Nova civitas Vindobonensis,Német-Újhely,Videnske Nove Mesto,Viedenske Nove Mesto,Viedenské Nové Mesto,Viner Noistat,Viner Nojshhat,Viner Nojshtat,Viner-Nojshtadt,Viner-Nojstadt,Vyner Noistatas,Vyner Noištatas,Vídeňské Nové Město,Weana Neistod,Wiener Neustadt,Wr. Neustadt,bineonoisyutateu,fynr nwyshtat,wei ye na xin cheng,wynr nwyshtat,wynr nwystt,Βίνερ Νόιστατ,Винер Нойщат,Винер Нојштат,Винер-Нойштадт,Вінер-Нойштадт,וינר נוישטט,فينر نويشتات,وینر نویشتات,وینر نیوشٹڈ,ვინერ-ნოიშტადტი,ウィーナー・ノイシュタット,維也納新城,비너노이슈타트', 47.8048500, 16.2319600, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2121, 'Wiener Neudorf', 'Wiener Neudorf', 'Vienos Noidorfas,Viner-Nojdorf,wei ye na xin cun,Винер-Нойдорф,維也納新村', 48.0827800, 16.3138400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2122, 'Vienna', 'Vienna', 'Bec,Bech,Becs,Beç,Beč,Bienne,Bécs,Dunaj,VIE,Vena,Viden,Viden'',Vieden,Viedeň,Viena,Vienna,Vienne,Vieno,Viin,Vin,Vinarborg,Vindobona,Viyana,Vídeň,Vín,Vínarborg,Wenen,Wieden,Wiedeń,Wien,bienna,bin,fyyna,weiynna,Βιέννη,Беч,Вена,Виена,Відень,فيينا,เวียนนา,ቪየና,비엔나,빈', 48.2084900, 16.3720800, 'AT', '2017-06-15', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2123, 'Weyer', 'Weyer', 'Weyer,Weyer Markt,Weyer an der Enns', 47.8571700, 14.6640900, 'AT', '2012-05-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2124, 'Wetzelsdorf', 'Wetzelsdorf', 'Wetzelsdorf', 47.0529300, 15.3992300, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2125, 'Wettmannstätten', 'Wettmannstatten', 'Vettmannshtetten,Vettmannstetten,Wettmannstatten,Wettmannstätten,wei te man si te te en,Веттманнстеттен,Веттманнштеттен,韦特曼斯特特恩', 46.8305600, 15.3872200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2126, 'Westendorf', 'Westendorf', 'Vestendorf,Westendorf,wei shi teng duo fu,Вестендорф,韦施滕多夫', 47.4320800, 12.2140600, 'AT', '2014-07-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2127, 'Wernersdorf', 'Wernersdorf', '', 46.7159200, 15.2071800, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2128, 'Werndorf', 'Werndorf', 'Werndorf', 46.9241700, 15.4908300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2129, 'Wernberg', 'Wernberg', '', 46.6166700, 13.9333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2130, 'Werfenweng', 'Werfenweng', 'Verfenveng,Weng,Werfenweng,Werfnweng,wei er fen weng,Верфенвенг,韦尔芬翁', 47.4620400, 13.2558200, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2131, 'Werfen', 'Werfen', 'Verfen,Werfen,Werfm,wei er fen,Верфен,維爾芬', 47.4758500, 13.1902000, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2132, 'Weppersdorf', 'Weppersdorf', 'Veperd,Veppersdorf,Veprstof,Veprštof,Verpstof,Verpštof,Wepperschduaf,wei po er si duo fu,Вепперсдорф,韦珀尔斯多夫', 47.5795400, 16.4267900, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2133, 'Wenns', 'Wenns', '', 47.1666700, 10.7333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2134, 'Wels', 'Wels', 'Ovilava,Vel''s,Wels,wls,Вельс,ולס', 48.1666700, 14.0333300, 'AT', '2013-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2135, 'Weiz', 'Weiz', 'Vajc,Weiz,fayts,wei ci,Вайц,Вајц,فايتس,魏茨', 47.2166700, 15.6166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2136, 'Weitra', 'Weitra', 'Vajtra,Weitra,wei te la,Вайтра,魏特拉', 48.7000000, 14.8833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2137, 'Weitersfeld', 'Weitersfeld', '', 48.7809700, 15.8134500, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2138, 'Weiten', 'Weiten', '', 48.2956400, 15.2601000, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2139, 'Weistrach', 'Weistrach', '', 48.0500000, 14.5833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2140, 'Weißkirchen in Steiermark', 'Weisskirchen in Steiermark', 'Vajskirkhen,Vajskirkhen-in-Shtajermark,Weisskirchen,Weisskirchen in Steiermark,Weißkirchen,Weißkirchen in Steiermark,shi tai er ma ke de qu wei si ji xing,Вайскирхен,Вайскирхен-ин-Штайермарк,施泰尔马克地区魏斯基兴', 47.1500000, 14.7333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2141, 'Weißenbach bei Liezen', 'Weissenbach bei Liezen', 'Weissenbach,Weissenbach bei Liezen,Weißenbach bei Liezen', 47.5666700, 14.2166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2142, 'Weissenbach an der Triesting', 'Weissenbach an der Triesting', 'Vajsenbakh-an-der-Tristing,Weissenbach,Weissenbach an der Triesting,Weißenbach an der Triesting,te li shi ting he pan wei sen ba he,Вайсенбах-ан-дер-Тристинг,特里施廷河畔魏森巴赫', 47.9821100, 16.0393500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2143, 'Weinzierl bei Krems', 'Weinzierl bei Krems', 'Weinzierl,Weinzierl bei Krems', 48.4000000, 15.6000000, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2144, 'Weinzierl am Walde', 'Weinzierl am Walde', 'Vajncirl''-am-Val''de,Vajncirl''-na-Val''de,Weinzierl,Weinzierl am Walde,lin pan wei yin qi er,Вайнцирль-ам-Вальде,Вайнцирль-на-Вальде,林畔韦因齐尔', 48.4321100, 15.4321000, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2145, 'Weingraben', 'Weingraben', 'Bajngrob,Borosd,Vajngraben,Weingraben,Вайнграбен', 47.5139300, 16.3637500, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2146, 'Weinburg am Saßbach', 'Weinburg am Sassbach', 'Weinburg,Weinburg am Sassbach,Weinburg am Saßbach', 46.7536100, 15.7211100, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2147, 'Weinburg', 'Weinburg', '', 48.1135100, 15.5329500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2148, 'Weiler', 'Weiler', '', 47.2997200, 9.6500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2149, 'Weikersdorf am Steinfelde', 'Weikersdorf am Steinfelde', 'Weikersdorf', 47.8061200, 16.1438900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2150, 'Weikendorf', 'Weikendorf', '', 48.3443800, 16.7665100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2151, 'Weiden bei Rechnitz', 'Weiden bei Rechnitz', 'Bandol,Bandoly,Bándoly,Vajden-Rekhnic,Weiden,Weiden bei Rechnitz,Вайден-Рехниц', 47.3000000, 16.3500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2152, 'Weiden am See', 'Weiden am See', 'Vajden-am-Zee,Vedeny,Védeny,Weiden,Вайден-ам-Зее', 47.9253200, 16.8689900, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2153, 'Weichselbaum', 'Weichselbaum', '', 46.9425000, 16.1875000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2154, 'Weer', 'Weer', 'Weer', 47.3000000, 11.6333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2155, 'Wattens', 'Wattens', 'Vatens,Vattens,Wattens,wa teng si,Ватенс,Ваттенс,瓦滕斯', 47.2941900, 11.5907000, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2156, 'Wattenberg', 'Wattenberg', '', 47.2833300, 11.6000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2157, 'Wartmannstetten', 'Wartmannstetten', '', 47.6935900, 16.0750600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2158, 'Warth', 'Warth', '', 47.6500000, 16.1166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2159, 'Warth', 'Warth', 'Warth', 47.2500000, 10.1833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2160, 'Wartberg', 'Wartberg', 'St. Barbara,Wartberg,Wartberg im Murztal,Wartberg im Mürztal', 47.5271700, 15.4809500, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2161, 'Wängle', 'Wangle', '', 47.4865800, 10.6899500, 'AT', '2012-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2162, 'Wang', 'Wang', '', 48.0453800, 15.0267200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2163, 'Walpersbach', 'Walpersbach', '', 47.7166700, 16.2333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2164, 'Wallern im Burgenland', 'Wallern im Burgenland', 'Valla,Vallern (Burgenland),Wallern,Wallern im Burgenland,Валлерн (Бургенланд)', 47.7284700, 16.9370600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2165, 'Waldzell', 'Waldzell', 'Val''dcell'',wa er de ce er,Вальдцелль,瓦尔德策尔', 48.1356200, 13.4270100, 'AT', '2014-09-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2166, 'Waldneukirchen', 'Waldneukirchen', 'Waldneukirchen', 47.9985400, 14.2587900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2167, 'Waldkirchen an der Thaya', 'Waldkirchen an der Thaya', 'Waldkirchen,Waldkirchen an der Thaya', 48.9333300, 15.3500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2168, 'Walding', 'Walding', 'Val''ding,Walding,Вальдинг', 48.3520900, 14.1576000, 'AT', '2011-12-20', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2169, 'Wald im Pinzgau', 'Wald im Pinzgau', 'Val''d,Val''d-im-Pincgau,Wald,Wald im Pinzgau,ping ci gao gu de wa er de,Вальд,Вальд-им-Пинцгау,Вальд-ім-Пінцгау,平茨高谷地瓦尔德', 47.2500000, 12.2333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2170, 'Waldhausen', 'Waldhausen', '', 48.5218300, 15.2625000, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2171, 'Waldenstein', 'Waldenstein', '', 48.7284500, 15.0141900, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2172, 'Waldegg', 'Waldegg', '', 47.8685200, 16.0515400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2173, 'Wald am Schoberpaß', 'Wald am Schoberpass', 'Wald,Wald am Schoberpass,Wald am Schoberpaß', 47.4493600, 14.6756700, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2174, 'Walchsee', 'Walchsee', 'Val''khze,Val''kse,wa er xi sai,Вальксе,Вальхзе,瓦尔希塞', 47.6516300, 12.3186800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2175, 'Waidring', 'Waidring', '', 47.5833300, 12.5666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2176, 'Waidmannsfeld', 'Waidmannsfeld', '', 47.8704200, 15.9811600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2177, 'Waidhofen an der Ybbs', 'Waidhofen an der Ybbs', 'Stadt Waidhofen an der Ybbs,Vajdkhofen na Ibsu,Vajdkhofen-na- Ibbse,Vajdkhofen-na-Ibse,Waidhofen,Waidhofen-Ybbs,baiteuhopen-andeeoibseu,vaidhopen-an-der-ibsi,waydhwfn an dr ybs,yi bu si he pan wei de huo fen,Вайдхофен-на- Иббсе,Вайдхофен-на-Ибсе,Вајдхофен на Ибсу,ויידהופן אן דר איבס,وایدهوفن آن در یبس,ვაიდჰოფენ-ან-დერ-იბსი,ヴァイトホーフェン・アン・デア・イプス,伊布斯河畔魏德霍芬,바이트호펜안데어입스', 47.9600400, 14.7736100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2178, 'Waidhofen an der Thaya', 'Waidhofen an der Thaya', 'Vajdkhofen an der Taja,Vajdkhofen na Taji,Vajdkhofen-an-der-Tajja,Waidhofen,Waidhofen an der Thaya,ta ya he pan wei de huo fen,Вайдхофен ан дер Тая,Вайдхофен-ан-дер-Тайя,Вајдхофен на Таји,塔亞河畔魏德霍芬', 48.8166700, 15.2833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2179, 'Wagrain', 'Wagrain', 'Vagrajn,Wagrain,Wagrin,Wougroa,wa ge lai en,Ваграйн,瓦格赖恩', 47.3352800, 13.2988900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2180, 'Wagna', 'Wagna', 'Vagna,wa ge na,Вагна,瓦格纳', 46.7500000, 15.5500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2181, 'Vösendorf', 'Vosendorf', 'Fjozendorf,fu sen duo fu,Фёзендорф,弗森多夫', 48.1210700, 16.3403600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2182, 'Murau', 'Murau', 'Murau,Murau Vorstadt,Vorstadt Murau,mu lao,Мурау,穆劳', 47.1105600, 14.1694400, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2183, 'Vordernberg', 'Vordernberg', 'Fordernberg,Vordernberg,Vordernberg-Markt,fu er deng bei ge,Фордернберг,福尔登贝格', 47.4880900, 14.9943600, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2184, 'Vorderhornbach', 'Vorderhornbach', 'Vorderhornbach', 47.3700900, 10.5394700, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2185, 'Vorchdorf', 'Vorchdorf', 'Forkhdorf,Vorchdorf,fu er xi duo fu,Форхдорф,福爾希多夫', 48.0038800, 13.9212200, 'AT', '2011-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2186, 'Vorau', 'Vorau', 'Forau,fu lao,Форау,福劳', 47.4054800, 15.8875400, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2187, 'Vomp', 'Vomp', 'Fomp,Vomp,fu mu pu,Фомп,福姆普', 47.3333300, 11.6833300, 'AT', '2014-05-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2188, 'Völs', 'Vols', '', 47.2500000, 11.3333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2189, 'Völkermarkt', 'Voelkermarkt', 'Felkermarkt,Fjol''kermarkt,Velikovec,Voelkermarkt,fu er ke ma ke te,fwlkrmarkt,Фелкермаркт,Фёлькермаркт,فولکرمارکت,弗爾克馬克特', 46.6622200, 14.6344400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2190, 'Volders', 'Volders', 'Fol''ders,fu er de er si,Фольдерс,福尔德尔斯', 47.2833300, 11.5666700, 'AT', '2016-03-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2191, 'Voitsberg', 'Voitsberg', 'Fojtsberg,Voitsberg,wo ci bo ge,Фойтсберг,Фојтсберг,沃茨伯格', 47.0333300, 15.1500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2192, 'Vöcklamarkt', 'Vocklamarkt', 'Fjoklamarkt,Vocklamarkt,Vocklamarkt-am Haushamerfeld,Vöcklamarkt,Vöcklamarkt-am Haushamerfeld,fu ke la ma ke te,Фёкламаркт,弗克拉马克特', 48.0025000, 13.4838300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2193, 'Vöcklabruck', 'Vocklabruck', 'Feklabruk,Fjoklabruk,Fjoklabrukk,Féklabruk,Vocklabruck,Vöcklabruck,fu ke la bu lu ke,fwklabrwk,Феклабрук,Фёклабрук,Фёклабрукк,فوکلابروک,ფეკლაბრუკი,弗克拉布魯克', 48.0027900, 13.6565200, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2194, 'Vitis', 'Vitis', '', 48.7596400, 15.1825900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2195, 'Virgen', 'Virgen', 'Firgen,Virgen,fei er gen,frjn,Фирген,Фірген,فرجن,菲尔根', 47.0015900, 12.4566100, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2196, 'Vils', 'Vils', 'Vils', 47.5500000, 10.6333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2197, 'Villach', 'Villach', 'Beljak,Filachas,Filakh,Fillach,Fillaha,Fillakh,Gorad Filakh,QVL,Santicum,Vilac,Villach,Villaco,fei la he,fil lakh,firahha,fylakh,pilakhi,pillaheu,pylʼk,wylakh,Φίλλαχ,Горад Філах,Филах,Филлах,Філлах,פילאך,فیلاخ,ویلاخ,ฟิลลาค,ფილახი,フィラッハ,菲拉赫,필라흐', 46.6102800, 13.8558300, 'AT', '2015-06-20', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2198, 'Viktorsberg', 'Viktorsberg', '', 47.3009200, 9.6748400, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2199, 'Viehhofen', 'Viehhofen', '', 47.3666700, 12.7333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2200, 'Velden am Wörthersee', 'Velden am Woerthersee', 'Vel''den,Velden,Velden am Woerthersee,Velden am Wörthersee,Вельден', 46.6130100, 14.0413000, 'AT', '2014-05-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2201, 'Veitsch', 'Veitsch', 'Fajch,fa yi qi,wytsch,Файч,ویتسچ,法伊奇', 47.5781500, 15.4945000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2202, 'Uttendorf', 'Uttendorf', '', 47.2833300, 12.5666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2203, 'Unterwart', 'Unterwart', 'Alsoor,Alsóor,Untervart,Unterwart,Унтерварт', 47.2500000, 16.2333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2204, 'Untertauern', 'Untertauern', '', 47.3000000, 13.5000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2205, 'Unterstinkenbrunn', 'Unterstinkenbrunn', '', 48.6677000, 16.3460700, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2206, 'Untersiebenbrunn', 'Untersiebenbrunn', '', 48.2500000, 16.7333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2207, 'Rohrbach an der Gölsen', 'Rohrbach an der Goelsen', 'Unterrohrbach', 48.0469900, 15.7416900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2208, 'Unterpremstätten', 'Unterpremstaetten', 'Premstatten,Premstätten,Unterpremstatten,Unterpremstetten,Unterpremstätten,Унтерпремстеттен', 46.9647200, 15.4041700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2209, 'Unterperfuss', 'Unterperfuss', '', 47.2666700, 11.2500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2210, 'Unterlamm', 'Unterlamm', '', 46.9769400, 16.0638900, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2211, 'Unterkohlstätten', 'Unterkohlstatten', '', 47.3833300, 16.3166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2212, 'Grünburg', 'Gruenburg', 'Grjunburg,ge lin bao,Грюнбург,格林堡', 47.9723400, 14.2647200, 'AT', '2011-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2213, 'Unterfrauenhaid', 'Unterfrauenhaid', 'Lok,Lók,Svetica', 47.5711600, 16.4988500, 'AT', '2012-11-11', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2214, 'Unterfladnitz', 'Unterfladnitz', 'Unterfladnitz', 47.1833300, 15.6666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2215, 'Unterbergla', 'Unterbergla', '', 46.8074600, 15.3151600, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2216, 'Unterauersbach', 'Unterauersbach', 'Unterauersbach', 46.8655600, 15.7702800, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2217, 'Unken', 'Unken', '', 47.6496600, 12.7294600, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2218, 'Ungerdorf', 'Ungerdorf', '', 47.0833300, 15.6666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2219, 'Ungenach', 'Ungenach', 'Ungenach', 48.0475600, 13.6147200, 'AT', '2017-07-12', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2220, 'Umhausen', 'Umhausen', 'Umgauzen,Umhausen,Umkhauzen,wu mu hao sen,Умгаузен,Умхаузен,امہاؤسن,乌姆豪森', 47.1350300, 10.9282600, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2221, 'Ulrichsberg', 'Ulrichsberg', 'Ul''rikhsberg,Ul''riksberg,wu er li xi si bei ge,Ульриксберг,Ульрихсберг,乌尔里希斯贝格', 48.6749800, 13.9104900, 'AT', '2011-07-14', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2222, 'Uderns', 'Uderns', 'Uderns', 47.3166700, 11.8666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2223, 'Übersbach', 'UEbersbach', 'Ubersbach,Uebersbach,Übersbach', 47.0231800, 16.0551700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2224, 'Übersaxen', 'Ubersaxen', 'Ubersaxen,Uebersaxen,Übersaxen', 47.2528400, 9.6708000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2225, 'Übelbach', 'Ubelbach', 'Ibel''bakh,Markt-UEbelbach,Markt-Übelbach,Ubelbach,Ubelbach Markt,Uebelbach,abylbach,yu bo er ba he,Übelbach,Übelbach Markt,Ибельбах,ابیلباچ,于伯尔巴赫', 47.2253400, 15.2361500, 'AT', '2017-06-23', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2226, 'Tweng', 'Tweng', '', 47.1833300, 13.6000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2227, 'Türnitz', 'Turnitz', 'Ternitz,Tjurnic,di er ni ci,twrnytz,Тюрниц,تورنیتز,蒂尔尼茨', 47.9309500, 15.4929500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2228, 'Turnau', 'Turnau', '', 47.5577600, 15.3373900, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2229, 'Tulln', 'Tulln', '', 48.3282900, 16.0585800, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2230, 'Tulfes', 'Tulfes', '', 47.2580600, 11.5333300, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2231, 'Tulbing', 'Tulbing', '', 48.2933600, 16.1222600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2232, 'Tschanigraben', 'Tschanigraben', '', 47.0166700, 16.3000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2233, 'Tschagguns', 'Tschagguns', 'Chagguns,Tschagguns,cha gong si,Чаггунс,查贡斯', 47.0833300, 9.9000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2234, 'Trumau', 'Trumau', '', 47.9934800, 16.3426800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2235, 'Trössing', 'Troessing', 'Trossing,Trössing', 46.8166700, 15.8166700, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2236, 'Trofaiach', 'Trofaiach', 'Trofaiach,Trofajakh,te luo fa yi ya he,Трофайах,特罗法伊亚赫', 47.4252400, 15.0068100, 'AT', '2014-05-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2237, 'Tristach', 'Tristach', 'Trishtakh,Tristach,Tristakh,te li shi ta he,Тристах,Триштах,特里施塔赫', 46.8161100, 12.7897200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2238, 'Trins', 'Trins', 'Trins,te lin si,Тринс,特林斯', 47.0833300, 11.4166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2239, 'Triebendorf', 'Triebendorf', 'Triebendorf', 47.1166700, 14.2333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2240, 'Trieben', 'Trieben', 'Triben,Trieben,te li ben,Трибен,特里本', 47.4833300, 14.4833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2241, 'Treglwang', 'Treglwang', 'Treglwang', 47.4745800, 14.5908300, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2242, 'Trebesing', 'Trebesing', '', 46.8863900, 13.5102800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2243, 'Trautmannsdorf in Oststeiermark', 'Trautmannsdorf in Oststeiermark', 'Trautmannsdorf,Trautmannsdorf in Oststeiermark', 46.8753000, 15.8845100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2244, 'Trautmannsdorf an der Leitha', 'Trautmannsdorf an der Leitha', 'Trautmannsdorf,Trautmannsdorf an der Leitha,Trautmansdorf-an-der-Lajta,Траутмансдорф-ан-дер-Лайта', 48.0235700, 16.6326600, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2245, 'Trausdorf an der Wulka', 'Trausdorf an der Wulka', 'Darazsfalu,Darázsfalu,Trausdorf,Trausdorf an der Wulka,Trausdorf-an-der-Vul''ka,Траусдорф-ан-дер-Вулька', 47.8135000, 16.5576000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2246, 'Traunstein', 'Traunstein', '', 48.4333300, 15.1000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2247, 'Traun', 'Traun', '', 48.2265600, 14.2345900, 'AT', '2011-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2248, 'Trattenbach', 'Trattenbach', '', 47.6000000, 15.8666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2249, 'Traismauer', 'Traismauer', 'Traismauer,Trajsmauehr,te lai si mao ai er,Трайсмауэр,特赖斯毛埃尔', 48.3500000, 15.7333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2250, 'Traiskirchen', 'Traiskirchen', '', 48.0148500, 16.2932400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2251, 'Traisen', 'Traisen', '', 48.0333300, 15.6000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2252, 'Trahütten', 'Trahuetten', 'Trahutten,Trahütten', 46.8250000, 15.1569400, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2253, 'Traboch', 'Traboch', 'Traboch', 47.3770500, 14.9864700, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2254, 'Tobaj', 'Tobaj', '', 47.0833300, 16.3000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2255, 'Tobadill', 'Tobadill', 'Tobadill', 47.1251300, 10.5140400, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2256, 'Timelkam', 'Timelkam', 'Timel''kam,di mo er ka mu,Тимелькам,蒂默尔卡姆', 48.0039400, 13.6076000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2257, 'Tieschen', 'Tieschen', 'Tieschen', 46.7861100, 15.9422200, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2258, 'Tiefgraben', 'Tiefgraben', 'Mondsee,Tiefgraben,Tifgraben,di fu ge la ben,Тифграбен,蒂夫格拉本', 47.8738500, 13.3059100, 'AT', '2017-07-12', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2259, 'Thüringen', 'Thuringen', '', 47.2000000, 9.7666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2260, 'Thörl', 'Thoerl', 'Thorl,Thörl,Tjorl'',te er,Тёрль,特尔', 47.5195200, 15.2227600, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2261, 'Thomatal', 'Thomatal', 'Thomatal,Thomathal', 47.0666700, 13.7500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2262, 'Thomasberg', 'Thomasberg', '', 47.5666700, 16.1333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2263, 'Theresienfeld', 'Theresienfeld', '', 47.8500000, 16.2333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2264, 'Thaya', 'Thaya', '', 48.8548900, 15.2890200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2265, 'Thaur', 'Thaur', 'Taur,tao er,Таур,陶尔', 47.3000000, 11.4666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2266, 'Thalheim bei Wels', 'Thalheim bei Wels', 'Tal''khajm-Vel''s,Tal''khajm-baj-Vel''s,Thalheim,Thalheim bei Wels,wei er si fu jin ta er hai mu,Тальхайм-Вельс,Тальхайм-бай-Вельс,韦尔斯附近塔尔海姆', 48.1500000, 14.0333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2267, 'Thalgau', 'Thalgau', 'Tal''gau,ta er gao,Тальгау,塔爾高', 47.8414200, 13.2532500, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2268, 'Teufenbach', 'Teufenbach', '', 47.1287000, 14.3591300, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2269, 'Ternitz', 'Ternitz', 'Ternic,tai er ni ci,trntyts,trnyz,Терниц,תרניץ,ترنتیتس,ტერნიცი,泰爾尼茨', 47.7156500, 16.0357500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2270, 'Ternberg', 'Ternberg', 'Ternberg,te en bei ge,Тернберг,特恩贝格', 47.9451800, 14.3587000, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2271, 'Terfens', 'Terfens', 'Terfens', 47.3235500, 11.6438800, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2272, 'Telfs', 'Telfs', 'Tel''fs,Telfs,tai er fu si,tlfs,tlps,Телфс,Тельфс,טלפס,تلفس,ტელფსი,泰爾夫斯', 47.3070700, 11.0681700, 'AT', '2013-12-06', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2273, 'Telfes im Stubai', 'Telfes im Stubai', 'Tel''fes-im-Shtubaj,Telfes,Telfes im Stubai,shi tu bai gu de te er fei si,Тельфес-им-Штубай,Тельфес-ім-Штубай,ٹلفس,施图拜谷地特尔费斯', 47.1666700, 11.3666700, 'AT', '2012-09-10', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2274, 'Teesdorf', 'Teesdorf', '', 47.9500000, 16.2833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2275, 'Taxenbach', 'Taxenbach', 'Daxenbach,Taksenbakh,Taxenbach,Touxenbouch,ta ke sen ba he,Таксенбах,塔克森巴赫', 47.2911600, 12.9621500, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2276, 'Tauplitz', 'Tauplitz', 'Tauplic,tao pu li ci,Тауплиц,陶普利茨', 47.5600500, 14.0129300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2277, 'Tattendorf', 'Tattendorf', '', 47.9500000, 16.3000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2278, 'Tarrenz', 'Tarrenz', 'Tarrenc,ta lun ci,Тарренц,塔伦茨', 47.2666700, 10.7666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2279, 'Tannheim', 'Tannheim', 'Tanngajm,Tannheim,Tannkhajm,tan hai mu,Таннгайм,Таннхайм,ٹینہیم,坦海姆', 47.4993400, 10.5164100, 'AT', '2016-01-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2280, 'Tamsweg', 'Tamsweg', 'Tambsweg,Tamsveg,ta mu si wei ge,Тамсвег,ტამსვეგი,塔姆斯韋格', 47.1280800, 13.8110200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2281, 'Tadten', 'Tadten', 'Mosonteteny,Mosontétény,Tadten,Тадтен', 47.7666700, 16.9833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2282, 'Sulzberg', 'Sulzberg', '', 47.5217800, 9.9135300, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2283, 'Sulz', 'Sulz', '', 47.2872100, 9.6518300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2284, 'Sulztal an der Weinstraße', 'Sulztal an der Weinstrasse', 'Stolzl,Sulztal,Zul''c,Зульц', 46.6833300, 15.5500000, 'AT', '2017-06-21', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2285, 'Stummerberg', 'Stummerberg', 'Stummerberg', 47.2833300, 11.9166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2286, 'Stumm', 'Stumm', 'Stumm', 47.2905200, 11.8875500, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2287, 'Stuhlfelden', 'Stuhlfelden', '', 47.2876100, 12.5275500, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2288, 'Studenzen', 'Studenzen', 'Studenzen', 47.0058300, 15.7541700, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2289, 'Stubenberg', 'Stubenberg', '', 47.2333300, 15.8000000, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2290, 'Stronsdorf', 'Stronsdorf', '', 48.6515700, 16.2989000, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2291, 'Strobl', 'Strobl', 'Shtrobl'',Shtrobl''-am-Vol''fgangze,Strobl,shi te luo bu er,Штробль,Штробль-ам-Вольфгангзе,سٹروبل,施特罗布尔', 47.7166700, 13.4833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2292, 'Strengen', 'Strengen', 'Strengen,Strengen am Arlberg', 47.1258900, 10.4619900, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2293, 'Strengberg', 'Strengberg', '', 48.1468500, 14.6514700, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2294, 'Strem', 'Strem', 'Shtrem,Strem,Stremm,Strém,Штрем', 47.0449800, 16.4142600, 'AT', '2013-04-02', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2295, 'Stratzing', 'Stratzing', '', 48.4500000, 15.6000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2296, 'Strasswalchen', 'Strasswalchen', 'Strasswalchen,Strasz Walchen', 47.9833300, 13.2500000, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2297, 'Straß in Steiermark', 'Strass in Steiermark', 'Shtras,Shtras-in-Shtajermark,Strass,Strass in Steiermark,Straß in Steiermark,shi tai er ma ke de qu shi te la si,Штрас,Штрас-ин-Штайермарк,施泰尔马克地区施特拉斯', 46.7272200, 15.6244400, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2298, 'Strasshof an der Nordbahn', 'Strasshof an der Nordbahn', 'Shtrasskhof-an-der-Nordban,Strasshof,Strasshof an der Nordbahn,Штрассхоф-ан-дер-Нордбан', 48.3166700, 16.6666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2299, 'Strassen', 'Strassen', 'Strassen', 46.7538900, 12.4841700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2300, 'Straßburg', 'Strassburg', 'Strassburg,Strassburg im Karnten,Strassburg in Karnten,Straßburg,Straßburg im Kärnten,Straßburg in Kärnten', 46.8944400, 14.3286100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2301, 'Strass im Zillertal', 'Strass im Zillertal', 'Strass,Strass bei Jenbach,Strass im Zillertal', 47.3955600, 11.8196600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2302, 'Strallegg', 'Strallegg', 'Strallegg', 47.4116500, 15.7253400, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2303, 'Straden', 'Straden', 'Shtraden,Straden,shi te la deng,Штраден,施特拉登', 46.8091700, 15.8680600, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2304, 'Stotzing', 'Stotzing', 'Lajtaszek,Lajtaszék,Stoczing', 47.9068800, 16.5458000, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2305, 'Stössing', 'Stossing', '', 48.1226700, 15.8137900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2306, 'Stoob', 'Stoob', 'Csava,Csáva,Shtub,Stoob,Stuma,Štuma,Штуб', 47.5284500, 16.4776000, 'AT', '2012-11-11', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2307, 'Stockerau', 'Stockerau', 'Gorad Shtokerau,Shhokerau,Shtokerau,Shtokkerau,Stockerau,Stokerau,astwkrayw,shi tuo ke lao,Štokerau,Горад Штокерау,Штокерау,Штоккерау,Щокерау,שטוקראו,استوکرائو,შტოკერაუ,ስቶከራው,施托克勞', 48.3833300, 16.2166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2308, 'Stockenboi', 'Stockenboi', '', 46.7261100, 13.5230600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2309, 'Stiwoll', 'Stiwoll', 'Shtivoll'',Stiwoll,shi di wo er,Штиволль,施蒂沃尔', 47.1000000, 15.2166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2310, 'Steinbrunn', 'Steinbrunn', 'Buedoeskut,Büdöskút,Shtajnbrunn,Steinbrunn,Stikapron,Stinkenbrunn,Štikapron,Штайнбрунн', 47.8333300, 16.4166700, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2311, 'Stinatz', 'Stinatz', 'Shtinac,Stinatz,Stinjaki,Штинац', 47.2026600, 16.1331200, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2312, 'Steyregg', 'Steyregg', 'Shtajreg,Shtajrehgg,shi tai er ai ge,Штайрег,Штайрэгг,施泰尔埃格', 48.2851300, 14.3699500, 'AT', '2011-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2313, 'Steyr', 'Steyr', 'Gorad Shtajr,Shhajr,Shtajr,Stagier,Steiras,Steyer,Steyr,Steyr Stadt,ashtayr,shi tai er,shutaia,styyr,syutaieo,Šteiras,Στάγιερ,Горад Штайр,Штайр,Штајр,Щайр,שטייר,اشتایر,შტაირი,シュタイアー,施泰爾,슈타이어', 48.0427400, 14.4212700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2314, 'Steuerberg', 'Steuerberg', 'Shtojerberg,shi tuo yi bei ge,Штойерберг,施托伊贝格', 46.7880400, 14.1129000, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2315, 'Stetten', 'Stetten', '', 48.3666700, 16.3833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2316, 'Stetteldorf am Wagram', 'Stetteldorf am Wagram', 'Stetteldorf,Stetteldorf am Wagram', 48.4081500, 16.0186200, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2317, 'Stenzengreith', 'Stenzengreith', 'Stenzengreith', 47.2000000, 15.5166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2318, 'Steinhaus', 'Steinhaus', '', 48.1161400, 14.0189000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2319, 'Steinfeld', 'Steinfeld', '', 46.7581200, 13.2493400, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2320, 'Steindorf am Ossiacher See', 'Steindorf am Ossiacher See', 'Shtajndorf-am-Ossiakher-Zee,Steindorf,Steindorf am Ossiacher See,ao xi ya xie er hu pan shi tai yin duo fu,Штайндорф-ам-Оссиахер-Зее,奥西亚歇尔湖畔施泰因多夫', 46.6983300, 14.0091700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2321, 'Steinbach am Attersee', 'Steinbach am Attersee', 'Steinbach,Steinbach am Attersee', 47.8308700, 13.5461300, 'AT', '2013-11-20', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2322, 'Steinakirchen am Forst', 'Steinakirchen am Forst', 'Steinakirchen,Steinakirchen am Forst', 48.0696500, 15.0480100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2323, 'Steinach am Brenner', 'Steinach am Brenner', 'Shtajnakh-am-Brenner,Shtajnakh-na-Brennere,Steinach,Steinach am Brenner,Steinach um Brenner,bu lun na shan kou si tai na he,Штайнах-ам-Бреннер,Штайнах-на-Бреннере,布倫納山口斯泰納赫', 47.0833300, 11.4666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2324, 'Stein', 'Stein', '', 46.9977800, 16.0869400, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2325, 'Stegersbach', 'Stegersbach', 'Santalek,Shtegersbakh,Shtegersbarkh,Stegersbach,Szentelek,shi te ge er si ba he,Штегерсбарх,Штегерсбах,施特格尔斯巴赫', 47.1666700, 16.1666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2326, 'Steeg', 'Steeg', '', 47.2439300, 10.2943600, 'AT', '2011-09-09', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2327, 'Statzendorf', 'Statzendorf', '', 48.3075200, 15.6412700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2328, 'Stattegg', 'Stattegg', 'Shtatteg,Stattegg,Штаттег', 47.1333300, 15.4166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2329, 'Stanz bei Landeck', 'Stanz bei Landeck', 'Stanz,Stanz bei Landeck', 47.1475800, 10.5534000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2330, 'Stanzach', 'Stanzach', 'Stanzach', 47.3833300, 10.5666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2331, 'Stans', 'Stans', 'Stans', 47.3666700, 11.7166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2332, 'Stams', 'Stams', 'Shtams,shi ta mu si,Штамс,施塔姆斯', 47.2760300, 10.9831500, 'AT', '2011-09-09', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2333, 'Stambach', 'Stambach', '', 47.3333300, 15.9333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2334, 'Stallhofen', 'Stallhofen', '', 47.0500000, 15.2166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2335, 'Stallhof', 'Stallhof', '', 46.8833300, 15.2833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2336, 'Stallehr', 'Stallehr', '', 47.1330600, 9.8500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2337, 'Stall', 'Stall', '', 46.8905600, 13.0369400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2338, 'Stainz bei Straden', 'Stainz bei Straden', 'Stainz,Stainz bei Straden', 46.8244400, 15.8922200, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2339, 'Stainz', 'Stainz', 'Shtajnc,Stainz,shi tai yin ci,Штайнц,施泰因茨', 46.8944400, 15.2672200, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2340, 'Stainach', 'Stainach', 'Shtajnakh,Steinach,shi tai na he,Штайнах,施泰纳赫', 47.5334300, 14.1087200, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2341, 'Stadtschlaining', 'Stadtschlaining', 'Schlaining,Stadtschlaining', 47.3166700, 16.2833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2342, 'Stadl-Paura', 'Stadl-Paura', 'Shtadl''-Paura,Stadl-Paura,shi ta de er-bao la,Штадль-Паура,施塔德尔-保拉', 48.0833300, 13.8666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2343, 'Stadl an der Mur', 'Stadl an der Mur', 'Stadl,Stadl an der Mur', 47.0833300, 13.9666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2344, 'Staatz', 'Staatz', 'Shtac,Val''tersdorf,shi ta ci,Вальтерсдорф,Штац,施塔茨', 48.6761700, 16.4872600, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2345, 'Spitz', 'Spitz', 'Spitz an der Donau', 48.3656000, 15.4141600, 'AT', '2014-10-15', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2346, 'Spittal an der Drau', 'Spittal an der Drau', 'Shpital,Shpittal''-an-der-Drau,Spital,Spital ob Dravi,Spittal,Spittal an der Drau,Spittal na Dravi,ashpytal an dr drayw,de lao he pan si pi ta er,Špital ob Dravi,Шпитал,Шпитталь-ан-дер-Драу,Шпітталь-ан-дер-Драу,اشپیتال آن در درائو,შპიტალ-ან-დერ-დრაუ,シュピッタル・アン・デア・ドラウ,德劳河畔斯皮塔尔', 46.8000000, 13.5000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2347, 'Spital am Semmering', 'Spital am Semmering', 'Shpital''-am-Zemmering,Spital,Spital am Semmering,sai mo ling fu jin shi pi ta er,Шпиталь-ам-Земмеринг,塞默灵附近施皮塔尔', 47.6134500, 15.7509600, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2348, 'Spillern', 'Spillern', '', 48.3833300, 16.2500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2349, 'Spielfeld', 'Spielfeld', 'Spielfeld', 46.7055600, 15.6372200, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2350, 'Spielberg bei Knittelfeld', 'Spielberg bei Knittelfeld', 'Shpil''berg (Knittel''fel''d),Spielberg,Spielberg bei Knittelfeld,Шпильберг (Книттельфельд)', 47.2166700, 14.7833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2351, 'Spannberg', 'Spannberg', '', 48.4639300, 16.7364700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2352, 'Sonntagberg', 'Sonntagberg', 'Zontagberg,song ta ge bei ge,Зонтагберг,松塔格贝格', 47.9956100, 14.7606500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2353, 'Sommerein', 'Sommerein', '', 47.9833300, 16.6500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2354, 'Sollenau', 'Sollenau', 'Zollenau,suo lei nao,Золленау,索勒瑙', 47.8833300, 16.2500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2355, 'Söll', 'Soll', 'Zjoll'',Зёлль', 47.5037800, 12.1922100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2356, 'Sölden', 'Soelden', 'Soelden,Soeldeni vald,Solden,Sölden,Söldeni vald,Z''olden,Zel''den,Zelden,Zelnten,Zjol''den,Zyolden,suo er deng,zeruden,zwldn,Ζέλντεν,Зелден,Зельден,Зьолден,Зёльден,Զյոլդեն,זולדן,ゼルデン,索爾登', 46.9666700, 11.0000000, 'AT', '2013-11-10', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2357, 'Hall in Tirol', 'Hall in Tirol', 'Gall''-in-Tirol'',Hall,Hall en Tyrol,Hall in Tirol,Hall în Tirol,Khal in Tirol,Khal u Tirolu,Khall''-in-Tirol'',Salina in Aeni Valle,Solbad Hall,Solbad Hall in Tirol,di luo er zhou huo er,hal ayn tyrwl,hal-intilol,Галль-ін-Тіроль,Хал ин Тирол,Хал у Тиролу,Халль-ин-Тироль,هال این تیرول,ہال ان ٹیرول,ჰალ-ინ-ტიროლი,ハル・イン・チロル,蒂羅爾州霍爾,할인티롤', 47.2833300, 11.5166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2358, 'Södingberg', 'Soedingberg', '', 47.1070300, 15.1716900, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2359, 'Söchau', 'Soechau', 'Sochau,Söchau', 47.0333300, 16.0166700, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2360, 'Soboth', 'Soboth', 'Soboth', 46.6813900, 15.0783300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2361, 'Sitzendorf an der Schmida', 'Sitzendorf an der Schmida', 'Sitzendorf,Sitzendorf an der Schmida,Zitcendorf-an-der-Shmida,shi mi da he pan xi cen duo fu,Зитцендорф-ан-дер-Шмида,施米达河畔锡岑多夫', 48.5984100, 15.9425400, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2362, 'Sittersdorf', 'Sittersdorf', 'Sittersdorf,Zitara vas,Zitaraves,Zittersdorf,xi te er si duo fu,Žitara vas,Žitaraves,Зиттерсдорф,锡特尔斯多夫', 46.5444400, 14.6058300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2363, 'Sistrans', 'Sistrans', '', 47.2333300, 11.4500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2364, 'Sinabelkirchen', 'Sinabelkirchen', 'Sinabelkirchen,Zinabel''kirkhen,xi na bo er ji xing,Зинабелькирхен,锡纳伯尔基兴', 47.1020000, 15.8279500, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2365, 'Silz', 'Silz', 'Silz,Zil''c,Зильц', 47.2666700, 10.9333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2366, 'Sillian', 'Sillian', 'Sillian,Zillian,xi li an,Зиллиан,Зілліан,锡利安', 46.7527800, 12.4211100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2367, 'Silbertal', 'Silbertal', 'Silbertal,Silberthal,Zil''bertal'',xi bei ta er,Зильберталь,Зільберталь,锡贝塔尔', 47.0936800, 9.9831400, 'AT', '2011-09-09', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2368, 'Sigmundsherberg', 'Sigmundsherberg', 'Zigmundskherberg,xi meng de si he er bei ge,Зигмундсхерберг,锡蒙德斯赫尔贝格', 48.6833300, 15.7500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2369, 'Sierning', 'Sierning', 'Zirning,xi er ning,Зирнинг,锡尔宁', 48.0434300, 14.3093500, 'AT', '2011-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2370, 'Sierndorf', 'Sierndorf', 'Khjobersdorf,Zirndorf,xi en duo fu,Зирндорф,Хёберсдорф,锡恩多夫', 48.4302400, 16.1665800, 'AT', '2017-05-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2371, 'Sieghartskirchen', 'Sieghartskirchen', 'Zigkhartskirkhen,xi ge ha ci ji xing,Зигхартскирхен,锡格哈茨基兴', 48.2553100, 16.0122300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2372, 'Sieggraben', 'Sieggraben', 'Sieggraben,Szikra,Ziggraben,Zigraben,xi ge la ben,Зигграбен,Зиграбен,Зіграбен,锡格拉本', 47.6512800, 16.3799300, 'AT', '2012-11-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2373, 'Siegersdorf bei Herberstein', 'Siegersdorf bei Herberstein', 'Siegersdorf,Siegersdorf bei Herberstein', 47.2000000, 15.7833300, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2374, 'Sibratsgfäll', 'Sibratsgfall', 'Dorf,Sibratsgfall,Sibratsgfäll', 47.4266700, 10.0380600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2375, 'Serfaus', 'Serfaus', 'Serfaus,Zerfaus,sai er fu si,zerpausi,Зерфаус,סרפהאוס,ზერფაუსი,塞尔福斯', 47.0401800, 10.6033900, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2376, 'Senftenberg', 'Senftenberg', 'Imbakh,Senftenberg,Zenftenberg,sen fu teng bei ge,Зенфтенберг,Имбах,森夫滕贝格', 48.4333300, 15.5500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2377, 'Semriach', 'Semriach', 'Semriach,Zemriakh,sai mu li ya he,Земриах,塞姆里亚赫', 47.2166700, 15.4000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2378, 'Semmering', 'Semmering', 'Semmering,Zemeringas,Zemmering,sai mo ling,zmryng,Земмеринг,זמרינג,塞默灵', 47.6334700, 15.8299300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2379, 'Selzthal', 'Selzthal', 'Selzthal,Zel''ctal'',sai er ci ta er,Зельцталь,塞尔茨塔尔', 47.5498800, 14.3120100, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2380, 'Seitenstetten Markt', 'Seitenstetten Markt', 'Seitenstetten,Seitenstetten Markt', 48.0333300, 14.6500000, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2381, 'Seiersberg', 'Seiersberg', 'Zajersberg,sai er si bei ge,Зайерсберг,赛尔斯贝格', 47.0000000, 15.4000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2382, 'Seibersdorf', 'Seibersdorf', 'Zajbersdorf,sai bo er si duo fu,Зайберсдорф,赛伯尔斯多夫', 47.9585800, 16.5184200, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2383, 'Seggauberg', 'Seggauberg', 'Seggauberg', 46.7666700, 15.5166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2384, 'Seewalchen', 'Seewalchen', '', 47.9524600, 13.5838200, 'AT', '2014-05-02', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2385, 'Seekirchen am Wallersee', 'Seekirchen am Wallersee', 'Seekirchen,Seekirchen Markt,Seekirer am Wollersee,Zeekirkhen-am-Vallerzee,Zekirkhen-am-Vallerze,sai ji xing,Зеекирхен-ам-Валлерзее,Зекирхен-ам-Валлерзе,Зекірхен-ам-Валлерзе,塞基興', 47.9000000, 13.1333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2386, 'Seeham', 'Seeham', '', 47.9674600, 13.0769900, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2387, 'Seefeld in Tirol', 'Seefeld in Tirol', 'Seefeld,Seefeld in Tirol,Seefeld in Tyroli,Seefeld în Tirol,Zeefel''d,Zeefel''d (Tirol''),Zefel''d-in-Tirol'',di luo er zhou sai fu er de,zeferuto,zyfyld,Зеефельд,Зеефельд (Тироль),Зефельд-ин-Тироль,Зефельд-ін-Тіроль,زيفيلد,سیفیلڈ,ゼーフェルト,蒂罗尔州塞弗尔德', 47.3301600, 11.1878600, 'AT', '2016-06-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2388, 'Seeboden', 'Seeboden', 'Seeboden,Seeboden am Millstaetter See,Seeboden am Millstätter See', 46.8190900, 13.5143000, 'AT', '2016-05-23', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2389, 'Seebenstein', 'Seebenstein', '', 47.6833300, 16.1333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2390, 'See', 'See', 'Messnerhaus,See,See im Paznaun,See im Paznauntal,Zee,Зее', 47.0833300, 10.4666700, 'AT', '2016-12-02', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2391, 'Seckau', 'Seckau', 'Seccovia,Seckau,Zekkau,sai kao,Зеккау,塞考', 47.2666700, 14.7833300, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2392, 'Sebersdorf', 'Sebersdorf', 'Sebersdorf,sai bo si duo fu,塞博斯多夫', 47.1865000, 15.9936000, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2393, 'Schwoich', 'Schwoich', '', 47.5460000, 12.1404900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2394, 'Schwendt', 'Schwendt', '', 47.6318200, 12.3926600, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2395, 'Schwendau', 'Schwendau', 'Schwendau', 47.1975300, 11.8589700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2396, 'Schweiggers', 'Schweiggers', 'Klajnvol''fgers,Shvajggers,shi wei ge si,Клайнвольфгерс,Швайггерс,施韋格斯', 48.6666700, 15.0666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2397, 'Schwechat', 'Schwechat', 'Nova Schwechat,Schwechat,Shvekhat,shi wei xia te,shwkhat,Швехат,شوخات,შვეხატი,施韋夏特', 48.1333300, 16.4666700, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2398, 'Schwaz', 'Schwaz', 'Shvac,shi wa ci,shvatsi,shwats,syuwacheu,Швац,שוואץ,شواتس,შვაცი,施瓦茨,슈와츠', 47.3516900, 11.7101400, 'AT', '2013-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2399, 'Schwarzenbach an der Pielach', 'Schwarzenbach an der Pielach', 'Schwarzenbach,Schwarzenbach an der Pielach', 47.9333300, 15.3833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2400, 'Schwarzenbach', 'Schwarzenbach', 'Ehppenshtajn,Feketevar,Feketevár,Schwarzenbach,Schwarzenbach Markt,Эппенштайн', 47.6354700, 16.3510900, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2401, 'Schwarzenau', 'Schwarzenau', '', 48.7443600, 15.2583800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2402, 'Schwarzau im Schwarzautal', 'Schwarzau im Schwarzautal', 'Schwarzau,Schwarzau im Schwarzautal', 46.8788600, 15.6642100, 'AT', '2017-06-21', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2403, 'Schwarzau im Gebirge', 'Schwarzau im Gebirge', 'Schwarzau,Shvarcau-im-Gebirge,shan qu shi wa er cao,Шварцау-им-Гебирге,山区施瓦尔曹', 47.8122300, 15.7058100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2404, 'Schwarzach im Pongau', 'Schwarzach im Pongau', 'Schwarzach,Schwarzach im Pongau,Schwoschzach im Pongau,Shvarcakh,Shvarcakh (Pongau),Shvarcakh-im-Pongau,peng gao de qu shi wa cha he,Шварцах,Шварцах (Понгау),Шварцах-им-Понгау,Шварцах-ім-Понгау,蓬高地区施瓦察赫', 47.3204800, 13.1517100, 'AT', '2015-03-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2405, 'Schwarzach', 'Schwarzach', '', 47.4490400, 9.7621300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2406, 'Schwanenstadt', 'Schwanenstadt', 'Schwauna,Shvanenshtadt,Svanenstatas,shi wa nen shi ta te,Švanenštatas,Шваненштадт,施瓦嫩施塔特', 48.0553700, 13.7750500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2407, 'Schwanberg', 'Schwanberg', 'Schwanberg', 46.7583300, 15.2083300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2408, 'Schwadorf', 'Schwadorf', '', 48.0693600, 16.5795700, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2409, 'Schützen am Gebirge', 'Schutzen am Gebirge', 'Cesno,Gschiess,Schutzen am Gebirge,Schützen am Gebirge,Serc,Shjutcen-am-Gebirge,Sérc,Česno,Шютцен-ам-Гебирге', 47.8523300, 16.6233400, 'AT', '2012-11-11', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2410, 'Schruns', 'Schruns', 'Schruns,Shruns,shi lun si,Шрунс,施伦斯', 47.0666700, 9.9166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2411, 'Schrems bei Frohnleiten', 'Schrems bei Frohnleiten', 'Schrems,Schrems bei Frohnleiten', 47.2810900, 15.3593200, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2412, 'Schrems', 'Schrems', 'Schrems,Shrems,shi lei mu si,Шремс,施雷姆斯', 48.7833300, 15.0666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2413, 'Schrattenthal', 'Schrattenthal', '', 48.7000000, 15.9000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2414, 'Schrattenberg', 'Schrattenberg', '', 48.7235900, 16.7220100, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2415, 'Schrattenbach', 'Schrattenbach', '', 47.7790200, 15.9906000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2416, 'Schottwien', 'Schottwien', 'Shotvin,shao te wen,Шотвин,绍特温', 47.6568300, 15.8725000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2417, 'Schoppernau', 'Schoppernau', 'Shoppernau,shao po nao,shwprnaw,Шоппернау,شوپرناؤ,绍珀瑙', 47.3120500, 10.0164600, 'AT', '2014-10-09', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2418, 'Schönwies', 'Schonwies', 'Schonwies,Schönwies', 47.1966500, 10.6574200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2419, 'Schönberg im Stubaital', 'Schoenberg im Stubaital', 'Schonberg,Schonberg im Stubaital,Schönberg,Schönberg im Stubaital,Shenberg-im-Shtubajtal'',Shjonberg,Shjonberg-im-Shtubajtal'',she en bo ge,Шенберг-ім-Штубайталь,Шёнберг,Шёнберг-им-Штубайталь,舍恩伯格', 47.1833300, 11.4166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2420, 'Schönbach', 'Schonbach', '', 48.4500000, 15.0333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2421, 'Schönau an der Triesting', 'Schonau an der Triesting', 'Schonau,Schönau', 47.9345200, 16.2537600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2422, 'Schöder', 'Schoder', '', 47.1833300, 14.1000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2423, 'Schnifis', 'Schnifis', '', 47.2166700, 9.7330600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2424, 'Schnepfau', 'Schnepfau', '', 47.3520600, 9.9452000, 'AT', '2014-08-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2425, 'Schmirn', 'Schmirn', '', 47.0833300, 11.5666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2426, 'Schlitters', 'Schlitters', 'Schlitters', 47.3804500, 11.8388800, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2427, 'Schlins', 'Schlins', '', 47.2000000, 9.7000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2428, 'Schleedorf', 'Schleedorf', '', 47.9500000, 13.1500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2429, 'Schlatt', 'Schlatt', '', 48.0717700, 13.7890400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2430, 'Schlägl', 'Schlaegl', 'Schlagl,Schlägl,Shlegl'',Шлегль', 48.6366500, 13.9656000, 'AT', '2013-06-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2431, 'Schladming', 'Schladming', 'Schlaming,Shladming,shi la de ming,Шладминг,Шладмінг,施拉德明', 47.3928900, 13.6869900, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2432, 'Schiefling am See', 'Schiefling am See', 'Schiefling,Schiefling am See,Shifling-am-Zee,Шифлинг-ам-Зее', 46.6044400, 14.0975000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2433, 'Schenkenfelden', 'Schenkenfelden', 'Schenkenfelden', 48.5027300, 14.3618800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2434, 'Scheifling', 'Scheifling', 'Scheifling,Shajfling,sha yi fu ling,Шайфлинг,沙伊夫灵', 47.1504400, 14.4127800, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2435, 'Scheibbs', 'Scheibbs', 'Shajbs,sha yi bu si,Шайбс,Шајбс,沙伊布斯', 48.0047400, 15.1681700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2436, 'Scheffau am Wilden Kaiser', 'Scheffau am Wilden Kaiser', 'Scheffau', 47.5294300, 12.2513900, 'AT', '2016-02-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2437, 'Scheffau am Tennengebirge', 'Scheffau am Tennengebirge', 'Scheffau,Sheffau-am-Tennengebirge,teng nen shan lu she fu,Шеффау-ам-Тенненгебирге,Шеффау-ам-Тенненгебірге,شیفو ایم ٹیننگبریج,滕嫩山麓舍福', 47.5883100, 13.2202000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2438, 'Schattwald', 'Schattwald', 'Schattwald,Shattval''d,sha te wa er de,Шаттвальд,沙特瓦尔德', 47.5142700, 10.4614300, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2439, 'Schattendorf', 'Schattendorf', 'Somfalva,Sundrof,Šundrof', 47.7097300, 16.5097900, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2440, 'Scharnstein', 'Scharnstein', 'Scharnstein,Sharnshhajn,Sharnshtajn,sha en shi tai yin,Шарнштайн,Шарнщайн,沙恩施泰因', 47.9042600, 13.9613500, 'AT', '2011-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2441, 'Scharnitz', 'Scharnitz', 'Sharnic,sha er ni ci,Шарниц,Шарніц,沙尔尼茨', 47.3889900, 11.2645500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2442, 'Scharndorf', 'Scharndorf', '', 48.0939900, 16.7988300, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2443, 'Schärding', 'Scharding', 'Scharding,Scharing,Schärding,Sherding,xie er ding,Шердинг,謝爾丁', 48.4529400, 13.4372200, 'AT', '2011-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2444, 'Schandorf', 'Schandorf', 'Cemba,Csem,Csém,Schandorf,Shandorf,Čemba,Шандорф', 47.2418300, 16.4226700, 'AT', '2012-11-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2445, 'Schäffern', 'Schaeffern', 'Schaffern,Schäffern', 47.4777100, 16.1095600, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2446, 'Schachendorf', 'Schachendorf', 'Cajta,Csajta,Schachendorf,Shakhendorf,Čajta,Шахендорф', 47.2666700, 16.4333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2447, 'Sautens', 'Sautens', '', 47.2000000, 10.8666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2448, 'Bad Sauerbrunn', 'Bad Sauerbrunn', 'Savanyukut,Savanyúkút', 47.7743900, 16.3284100, 'AT', '2017-06-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2449, 'Sattledt', 'Sattledt', 'Sattledt,Zattledt,sa te lei te,Заттледт,萨特勒特', 48.0737200, 14.0547800, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2450, 'Satteins', 'Satteins', '', 47.2166700, 9.6666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2451, 'Sankt Wolfgang im Salzkammergut', 'Sankt Wolfgang im Salzkammergut', 'Sankt Wolfgang,Sankt-Vol''fgang-im-Zal''ckammergut,sa er ci ka mo gu te de qu sheng wo er fu gang,Санкт-Вольфганг-им-Зальцкаммергут,萨尔茨卡默古特地区圣沃尔夫冈', 47.7393200, 13.4466600, 'AT', '2011-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2452, 'Sankt Veit in Defereggen', 'Sankt Veit in Defereggen', 'Sankt Veit,Sankt Veit in Defereggen', 46.9272200, 12.4297200, 'AT', '2017-06-13', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2453, 'Sankt Veit im Pongau', 'Sankt Veit im Pongau', 'Sankt Veit,Sankt Veit Pongau,Sankt Veit im Pongau,Sankt-Vajt (Pongau),St. Veit,St. Veit im Pongau,Санкт-Вайт (Понгау)', 47.3333300, 13.1500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2454, 'Sankt Veit an der Gölsen', 'Sankt Veit an der Golsen', 'Sankt-Fajt-an-der-Tristing,Sankt-Veit,Санкт-Файт-ан-дер-Тристинг', 48.0432000, 15.6694200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2455, 'Sankt Veit an der Glan', 'Sankt Veit an der Glan', 'Sankt Fajt an der Glan,Sankt Fajt na Glanu,Sankt Veit,Sankt Veit an der Glan,Sankt-Fajt-an-der-Glan,Sankt-Vajt-an-der-Glan,Sentvid ob Glini,ge lan he pan sheng fa yi te,znkt fayt an dr glan,Šentvid ob Glini,Санкт Файт ан дер Глан,Санкт Фајт на Глану,Санкт-Вайт-ан-дер-Глан,Санкт-Файт-ан-дер-Глан,Санкт-Файт-ан-дер-Ґлан,زنکت فایت آن در گلان,სანქტ-ფაიტ-ან-დერ-გლანი,格蘭河畔聖法伊特', 46.7680600, 14.3602800, 'AT', '2014-03-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2456, 'Sankt Veit am Vogau', 'Sankt Veit am Vogau', 'Sankt Veit,Sankt Veit am Vogau,Sankt-Fajt-am-Fogau,Санкт-Файт-ам-Фогау', 46.7404800, 15.6421700, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2457, 'Sankt Valentin', 'Sankt Valentin', 'Sankt Valentin', 48.1666700, 14.5166700, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2458, 'Sankt Ulrich bei Steyr', 'Sankt Ulrich bei Steyr', 'Sankt Ulrich,Sankt-Ul''rikh-Shtajr,Санкт-Ульрих-Штайр', 48.0211600, 14.4368500, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2459, 'Sankt Ulrich am Waasen', 'Sankt Ulrich am Waasen', 'Sankt Ulrich,Sankt Ulrich am Waasen', 46.9333300, 15.5333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2460, 'Sankt Stefan ob Stainz', 'Sankt Stefan ob Stainz', 'Sankt Stefan,Sankt Stefan ob Stainz', 46.9286100, 15.2588900, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2461, 'Sankt Stefan ob Leoben', 'Sankt Stefan ob Leoben', 'Sankt Stefan ob Leoben', 47.3167200, 14.9783100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2462, 'Sankt Stefan im Rosental', 'Sankt Stefan im Rosental', 'Sankt Stefan,Sankt Stefan im Rosental,Sankt Stefan im Rosenthal,Sankt Stefan im Rosenthale,Sankt-Shtefan,Sankt-Shtefan-im-Rozental'',luo sen gu de sheng si te fan,Санкт-Штефан,Санкт-Штефан-им-Розенталь,罗森谷地圣斯特凡', 46.9038900, 15.7100000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2463, 'Sankt Ruprecht an der Raab', 'Sankt Ruprecht an der Raab', 'Sankt Ruprecht', 47.1533600, 15.6625600, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2464, 'Sankt Radegund bei Graz', 'Sankt Radegund bei Graz', 'Radegund bei Graz,Sankt Radegund,Sankt Radegund bei Graz,ge la ci fu jin sheng la de gong de,格拉茨附近圣拉德贡德', 47.1817200, 15.4919200, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2465, 'Sankt Pölten', 'Sankt Poelten', 'Cetium,Gorad Sankt-Pjol''tehn,POK,Poelten,Pölten,Sankt P''olten,Sankt Pelten,Sankt Peltenas,Sankt Poelten,Sankt Polten,Sankt Polton,Sankt Pölten,Sankt Pölton,Sankt-Pel''ten,Sankt-Pjol''ten,Sankt-Pyolten,Sanktpeltene,St. Poelten,St. Poetn,St. Pölten,St. Pötn,Sveti Hipolit,Zan''kt Pelten,jangkeuteupoelten,jankta pyoltana,sang th pheil thein,sheng pa er teng,snqt pltn,zankt pwltn,Ζανκτ Πέλτεν,Горад Санкт-Пёльтэн,Санкт Пелтен,Санкт Пьолтен,Санкт-Пельтен,Санкт-Пёльтен,סנקט פלטן,زانکت پولتن,سینکت پولٹن,जांक्ट प्योल्टन,ซังท์เพิลเทิน,სანქტ-პელტენი,ザンクト・ペルテン,聖帕爾滕,장크트푈텐', 48.2000000, 15.6333300, 'AT', '2015-12-06', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2466, 'Sankt Peter ob Judenburg', 'Sankt Peter ob Judenburg', 'Sankt Peter,Sankt Peter ob Judenburg', 47.1841700, 14.5863900, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2467, 'Sankt Peter im Sulmtal', 'Sankt Peter im Sulmtal', 'Sankt Peter,Sankt Peter im Sulmtal,Sankt Peter im Sulmthale', 46.7500000, 15.2500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2468, 'Sankt Peter-Freienstein', 'Sankt Peter-Freienstein', 'Freyenstein,Sankt Peter,Sankt Peter-Freienstein,Sankt-Peter-Frajenshtajn,Санкт-Петер-Фрайенштайн', 47.3833300, 15.0166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2469, 'Sankt Peter am Ottersbach', 'Sankt Peter am Ottersbach', 'Sankt Peter,Sankt Peter am Ottersbach,Sankt-Peter-am-Ottersbakh,ao te er si ba he he pan sheng bi de,Санкт-Петер-ам-Оттерсбах,奥特尔斯巴赫河畔圣彼得', 46.7977800, 15.7591700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2470, 'Sankt Peter am Kammersberg', 'Sankt Peter am Kammersberg', 'Sankt Peter,Sankt Peter am Kammersberg', 47.1870600, 14.1846400, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2471, 'Sankt Paul im Levanttal', 'Sankt Paul im Levanttal', 'Sankt Paul,Sankt Paul im Lavanttal,Sankt Paul im Levanttal', 46.7005600, 14.8755600, 'AT', '2014-05-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2472, 'Sankt Oswald bei Plankenwarth', 'Sankt Oswald bei Plankenwarth', 'Sankt Oswald,Sankt Oswald bei Plankenwarth', 47.0870100, 15.2770300, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2473, 'Sankt Nikolai ob Draßling', 'Sankt Nikolai ob Drassling', 'Sankt Nikolai,Sankt Nikolai ob Drassling,Sankt Nikolai ob Draßling', 46.8088900, 15.6508300, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2474, 'Sankt Nikolai im Sölktal', 'Sankt Nikolai im Soelktal', 'Sankt Nikolai,Sankt Nikolai im Solktal,Sankt Nikolai im Sölktal', 47.3166700, 14.0500000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2475, 'Sankt Nikolai im Sausal', 'Sankt Nikolai im Sausal', 'Sankt Nikolai,Sankt Nikolai im Sausal', 46.8211100, 15.4519400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2476, 'Sankt Michael in Obersteiermark', 'Sankt Michael in Obersteiermark', 'Sankt Michael,Sankt Michael in Obersteiermark,Sankt-Mikhaehl''-in-Obershtajermark,Sankt-Mikhel'',Sankt-Mikhel'' (Verkhnjaja Shtirija),shang shi tai er ma ke de qu sheng mi xia ai er,Санкт-Михаэль-ин-Оберштайермарк,Санкт-Михель,Санкт-Михель (Верхняя Штирия),上施泰尔马克地区圣米夏埃尔', 47.3383900, 15.0178400, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2477, 'Sankt Michael im Lungau', 'Sankt Michael im Lungau', 'Sankt Michael,Sankt Michael Lungau,Sankt Michael im Lungau,Sankt-Mikhaehl'' (Lungau),St Michael im Lungau,Санкт-Михаэль (Лунгау)', 47.1000000, 13.6333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2478, 'Sankt Michael im Burgenland', 'Sankt Michael im Burgenland', 'Michael,Sankt Michael,Sankt Michael an der Strem,Sankt Michael im Burgenland,Sankt Mikhel'' (Burgenland),Санкт Михель (Бургенланд)', 47.1285200, 16.2714800, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2479, 'Sankt Martin im Sulmtal', 'Sankt Martin im Sulmtal', 'Sankt Martin,Sankt Martin im Sulmtal,Sankt-Martin,Sankt-Martin-im-Zul''mtal'',su er mu gu de sheng ma ding,Санкт-Мартин,Санкт-Мартин-им-Зульмталь,苏尔姆谷地圣马丁', 46.7561100, 15.2972200, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2480, 'Sankt Martin bei Lofer', 'Sankt Martin bei Lofer', 'Sankt Martin,Sankt Martin bei Lofer,St. Martin b. Lofer', 47.5666700, 12.7000000, 'AT', '2016-08-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2481, 'Sankt Martin an der Raab', 'Sankt Martin an der Raab', 'Sankt Martin,Sankt Martin an der Raab', 46.9225000, 16.1361100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2482, 'Sankt Martin am Grimming', 'Sankt Martin am Grimming', 'Sankt Martin,Sankt Martin an der Salza', 47.4887300, 13.9810500, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2483, 'Sankt Marienkirchen bei Schärding', 'Sankt Marienkirchen bei Schaerding', 'Sankt Marienkirchen,Sankt Marienkirchen bei Schaerding,Sankt Marienkirchen bei Schärding', 48.3871000, 13.4507800, 'AT', '2013-04-11', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2484, 'Sankt Margarethen im Lungau', 'Sankt Margarethen im Lungau', 'Sankt Margarethen,Sankt Margarethen im Lungau', 47.0792700, 13.6961300, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2485, 'Sankt Margarethen im Burgenland', 'Sankt Margarethen im Burgenland', 'Sankt Margarethen,Sankt-Margareten,Sankt-Margareten (Burgenland),Sankt-Margareten-im-Burgenland,Sveta Margareta,Szentmargitbanya,Szentmargitbánya,bu er gen lan zhou sheng ma er jia lei teng,Санкт-Маргаретен,Санкт-Маргаретен (Бургенланд),Санкт-Маргаретен-им-Бургенланд,布尔根兰州圣马尔加勒滕', 47.8033500, 16.6087500, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2486, 'Sankt Margarethen bei Knittelfeld', 'Sankt Margarethen bei Knittelfeld', 'Sankt Margarethen,Sankt Margarethen bei Knittelfeld', 47.2166700, 14.8666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2487, 'Sankt Margarethen an der Sierning', 'Sankt Margarethen an der Sierning', 'Margarethen,Margarethen an der Sierning', 48.1591000, 15.4905500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2488, 'Sankt Margarethen an der Raab', 'Sankt Margarethen an der Raab', 'Sankt Margarethen,Sankt Margarethen an der Raab,Sankt-Margareten-na-Rabe,Санкт-Маргаретен-на-Рабе', 47.0500000, 15.7500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2489, 'Sankt Marein im Mürztal', 'Sankt Marein im Muerztal', 'Sankt Marein,Sankt Marein im Murztal,Sankt Marein im Murztale,Sankt Marein im Murzthale,Sankt Marein im Mürztal,Sankt Marein im Mürztale,Sankt-Marajn (Mjurctal''),Санкт-Марайн (Мюрцталь)', 47.4666700, 15.3666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2490, 'Sankt Marein bei Neumarkt', 'Sankt Marein bei Neumarkt', 'Sankt Marein,Sankt Marein bei Neumarkt', 47.0659100, 14.4290800, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2491, 'Sankt Marein bei Knittelfeld', 'Sankt Marein bei Knittelfeld', 'Sankt Marein,Sankt Marein bei Knittelfeld', 47.2739600, 14.8608500, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2492, 'Sankt Marein bei Graz', 'Sankt Marein bei Graz', 'Sankt Marein,Sankt Marein am Pickelbach,Sankt Marein bei Graz,Sankt-Marajn-Grac,Sankt-Marajn-baj-Grac,ge la ci fu jin sheng ma lai en,Санкт-Марайн-Грац,Санкт-Марайн-бай-Грац,格拉茨附近圣马赖恩', 47.0158300, 15.6838900, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2493, 'Sankt Lorenzen im Mürztal', 'Sankt Lorenzen im Muerztal', 'Sankt Lorenzen,Sankt Lorenzen im Murztal,Sankt Lorenzen im Mürztal,Sankt-Lorencen (Mjurctal''),Санкт-Лоренцен (Мюрцталь)', 47.4833300, 15.3666700, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2494, 'Sankt Lorenzen bei Scheifling', 'Sankt Lorenzen bei Scheifling', 'Sankt Lorenzen,Sankt Lorenzen bei Scheifling', 47.1455600, 14.4058300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2495, 'Sankt Lorenzen bei Knittelfeld', 'Sankt Lorenzen bei Knittelfeld', 'Sankt Lorenzen,Sankt Lorenzen bei Knittelfeld', 47.2507800, 14.8954900, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2496, 'Sankt Lorenzen am Wechsel', 'Sankt Lorenzen am Wechsel', 'Sankt Lorenzen,Sankt Lorenzen am Wechsel', 47.4415300, 15.9549800, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2497, 'Sankt Lorenz', 'Sankt Lorenz', '', 47.8324000, 13.3483900, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2498, 'Sankt Leonhard am Forst', 'Sankt Leonhard am Forst', 'Sankt Leonhard,Sankt Leonhard am Forst,Sankt-Leonkhard-am-Forst,Санкт-Леонхард-ам-Форст', 48.1333300, 15.2833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2499, 'Sankt Lambrecht', 'Sankt Lambrecht', 'Sankt Lambrecht', 47.0666700, 14.3000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2500, 'Sankt Kathrein am Offenegg', 'Sankt Kathrein am Offenegg', 'Sankt Kathrein,Sankt Kathrein am Offenegg,St. Kathrein', 47.3000000, 15.5833300, 'AT', '2016-01-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2501, 'Sankt Kathrein am Hauenstein', 'Sankt Kathrein am Hauenstein', 'Sankt Kathrein,Sankt Kathrein am Hauenstein', 47.4894300, 15.6941400, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2502, 'Sankt Katharein an der Laming', 'Sankt Katharein an der Laming', 'Katharein,Sankt Katharein,Sankt Katherein,Sankt Kathrein,Sankt Kathrein an der Laming', 47.4706900, 15.1631900, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2503, 'Sankt Josef (Weststeiermark)', 'Sankt Josef (Weststeiermark)', '', 46.9091700, 15.3363900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2504, 'Sankt Johann in Tirol', 'Sankt Johann in Tirol', 'Sankt Johann,Sankt-Jokhann (Tirol''),St. Johann in Tirol,Санкт-Йоханн (Тироль)', 47.5233000, 12.4232000, 'AT', '2016-01-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2505, 'Sankt Johann in der Haide', 'Sankt Johann in der Haide', 'Sankt Johann,Sankt Johann in der Haide', 47.2808000, 16.0257900, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2506, 'Sankt Johann im Saggautal', 'Sankt Johann im Saggautal', 'Sankt Johann,Sankt Johann im Saggautal,Sankt Johann im Saggauthale', 46.7038900, 15.4027800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2507, 'Sankt Johann im Pongau', 'Sankt Johann im Pongau', 'Sankt Johann,Sankt Johann im Pongau,Sankt Jokhan u Pongauu,Sankt-Iogann-im-Pongau,Sankt-Jogann-im-Pongau,Sankt-Jokhan,Sankt-Jokhann (Pongau),St Johann im Pongau,St. John''s im Pougau,St. John’s im Pougau,peng gao de qu sheng yue han,zankt ywhan aym pwngayw,Санкт Јохан у Понгауу,Санкт-Иоганн-им-Понгау,Санкт-Йоганн-ім-Понгау,Санкт-Йохан,Санкт-Йоханн (Понгау),زانکت یوهان ایم پونگائو,蓬高地區聖約翰', 47.3500000, 13.2000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2508, 'Sankt Johann bei Herberstein', 'Sankt Johann bei Herberstein', 'Sankt Johann,Sankt Johann bei Herberstein', 47.2000000, 15.8000000, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2509, 'Sankt Johann am Tauern', 'Sankt Johann am Tauern', 'Sankt Johann,Sankt Johann am Tauern', 47.3500000, 14.4666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2510, 'Sankt Jakob im Walde', 'Sankt Jakob im Walde', 'Sankt Jakob,Sankt Jakob im Walde', 47.4666700, 15.7833300, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2511, 'Sankt Jakob', 'Sankt Jakob', 'Sankt Jakob,Sankt Jakob im Rosental,Sankt Jakob im Rosenthal,Sveti Jakob', 46.5477800, 14.0572200, 'AT', '2014-05-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2512, 'Sankt Ilgen', 'Sankt Ilgen', 'Sankt Ilgen', 47.5500000, 15.1666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2513, 'Sankt Gotthard im Mühlkreis', 'Sankt Gotthard im Muhlkreis', 'Sankt Gotthard,Sankt Gotthard im Muhlkreis,Sankt Gotthard im Mühlkreis', 48.3802000, 14.1318500, 'AT', '2011-12-20', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2514, 'Sankt Gilgen', 'Sankt Gilgen', 'Saint Gilgen,Sankt Gilgen,Sankt-Gil''gen,Sankt-Gilgen,St. AEgidius,St. Gilgen,St. Ægidius,sheng ji er gen,Санкт-Гилген,Санкт-Гильген,Санкт-Гільген,سینٹ گلگن,圣吉尔根', 47.7666700, 13.3666700, 'AT', '2013-03-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2515, 'Sankt Georgen ob Murau', 'Sankt Georgen ob Murau', 'Sankt Georgen ob Murau,St. Georgen ob Murau', 47.1000000, 14.1000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2516, 'Sankt Georgen ob Judenburg', 'Sankt Georgen ob Judenburg', 'Sankt Georgen,Sankt Georgen ob Judenburg,St. Georgen ob Judenburg', 47.2074400, 14.4973600, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2517, 'Sankt Georgen im Attergau', 'Sankt Georgen im Attergau', 'Sankt Georgen,Sankt Georgen im Attergau,Sankt-Georgen-im-Attergau,Санкт-Георген-им-Аттергау', 47.9359500, 13.4830600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2518, 'Sankt Georgen an der Stiefing', 'Sankt Georgen an der Stiefing', 'Sankt Georgen,Sankt Georgen an der Stiefing', 46.8733300, 15.5797200, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2519, 'Sankt Georgen an der Leys', 'Sankt Georgen an der Leys', 'Sankt Georgen', 48.0314900, 15.2272200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2520, 'Sankt Georgen am Ybbsfelde', 'Sankt Georgen am Ybbsfelde', 'Sankt Georgen,Sankt Georgen am Ybbsfelde,Sankt-Georgien-na-Ibsfel''de,Санкт-Георгиен-на-Ибсфельде', 48.1333300, 14.9500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2521, 'Sankt Gallenkirch', 'Sankt Gallenkirch', '', 47.0166700, 9.9666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2522, 'Sankt Gallen', 'Sankt Gallen', 'Sankt Gallen', 47.6863100, 14.6170500, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2523, 'Sankt Florian am Inn', 'Sankt Florian am Inn', 'Sankt Florian,Sankt Florian am Inn,Sankt-Florian-am-Inn,St. Florian am Inn,Санкт-Флориан-ам-Инн', 48.4412200, 13.4426300, 'AT', '2016-02-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2524, 'Sankt Corona am Wechsel', 'Sankt Corona am Wechsel', 'Sankt Corona am Wechsel,Sankt-Corona', 47.5833300, 16.0000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2525, 'Sankt Blasen', 'Sankt Blasen', 'Sankt Blasen', 47.0833300, 14.3000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2526, 'Sankt Bartholomä', 'Sankt Bartholoma', 'Sankt Bartholoma,Sankt Bartholomä', 47.0545700, 15.2588900, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2527, 'Sankt Anton im Montafon', 'Sankt Anton im Montafon', 'Montafon,Sankt Anton,Sankt Anton im Montafon', 47.1166700, 9.8666700, 'AT', '2016-02-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2528, 'Sankt Anton am Arlberg', 'Sankt Anton am Arlberg', 'ANT,Saint Anton,Sankt Anton,Sankt Anton am Arlberg,Sankt Antonas,Sankt-Anton-am-Arl''berg,St Anton,St Anton am Arlberg,St. Anton,St. Anton am Arlberg,a er shan lu sheng an dong,Санкт Антон ам Арлберг,Санкт-Антон-ам-Арльберг,סן אנטון,サンクト・アントン・アム・アールベルク,阿尔山麓圣安东', 47.1275000, 10.2637200, 'AT', '2014-05-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2529, 'Sankt Anna am Aigen', 'Sankt Anna am Aigen', 'Sankt Anna,Sankt Anna am Aigen', 46.8311100, 15.9713900, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2530, 'Sankt Andrä im Lungau', 'Sankt Andra im Lungau', 'Sankt Andra,Sankt Andra im Lungau,Sankt Andrä,Sankt Andrä im Lungau', 47.1500000, 13.7833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2531, 'Sankt Andrä am Zicksee', 'Sankt Andra am Zicksee', 'Mosonszentandras,Mosonszentandrás,Sankt Andra,Sankt Andra bei Frauenkirchen,Sankt Andrä,Sankt Andrä bei Frauenkirchen,Sankt-Andre-am-Cikzee,Санкт-Андре-ам-Цикзее', 47.7841000, 16.9419500, 'AT', '2012-11-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2532, 'Sankt Andrä', 'Sankt Andrae', 'Sankt Andra,Sankt Andra Lavanttal,Sankt Andrae Im Lavanttal,Sankt Andre,Sankt Andrä,Sankt Andrä Lavanttal,Sankt-Andre,Sentandraz v Labotski dolini,sheng an de lie,zankt andrh,Šentandraž v Labotski dolini,Санкт Андре,Санкт-Андре,زانکت آندره,聖安德烈', 46.7682900, 14.8199100, 'AT', '2014-10-11', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2533, 'Salzburg', 'Salzburg', 'Estado de Salzburgo,Gorad Zal''cburg,Ijolati Zaltsburg,Lungsod ng Salzburg,SZG,Saizburg,Salcburg,Salcburk,Salisburgh,Salisburgium,Salisburgo,Salisburgu,Salisburgum,Saltsmpournk,Saltzburg,Salzborg,Salzbourg,Salzburg,Salzburgi liidumaa,Salzburgo,Salzbursko,Sałisburgo,Såizburg,Zal''cburg,Zalcburg,Zalcburga,Zalcburgas,Zaltsburq,chai er ci bei ge,jalcheubuleukeu,jaltsaburga,sa er ci bao,sa er si bao,salajaburga,saljhabarga,sals bur k,salzaborga,salzbrg,salzbwrgh,zaltsburgi,zaltsbwrg,zarutsuburuku,zlzbwrg,Σάλτσμπουργκ,Горад Зальцбург,Залцбург,Зальцбург,Иёлати Залтсбург,Салцбург,Զալցբուրգ,זאלצבורג,זלצבורג,زالتسبورگ,سالزبرگ,سالزبورغ,जाल्त्सबुर्ग,साल्ज़बोर्ग,সলজবুর্গ,સાલ્ઝબર્ગ,ಸಾಲ್ಜ್‌ಬರ್ಗ್‌,ซาลซ์บูร์ก,ზალცბურგი,ザルツブルク,柴尔兹孛格,萨尔斯堡,萨尔茨堡,薩爾斯堡,잘츠부르크', 47.7994100, 13.0439900, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2534, 'Sallingberg', 'Sallingberg', '', 48.4666700, 15.2333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2535, 'Salla', 'Salla', 'Salla', 47.1000000, 14.9666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2536, 'Sachsenburg', 'Sachsenburg', 'Sachsenburg,Sochsenburg,Zaksenburg,sa he sen bao,schsnbrg,Заксенбург,سچسنبرگ,萨赫森堡', 46.8291700, 13.3550000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2537, 'Saalfelden am Steinernen Meer', 'Saalfelden am Steinernen Meer', 'Saafelden,Saalfelden,Saalfelden am Steinernen Meer,Salfelden,Zal''fel''den-am-Shtajnernen-Meer,Зальфельден-ам-Штайнернен-Меер', 47.4268100, 12.8480000, 'AT', '2016-02-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2538, 'Saalbach', 'Saalbach', '', 47.3913800, 12.6364200, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2539, 'Rutzenham', 'Rutzenham', '', 48.0607600, 13.7188300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2540, 'Rüstorf', 'Rustorf', '', 48.0432600, 13.7898200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2541, 'Rust', 'Rust', 'Rust,Ruszt,Stadt Rust,Руст', 47.8012200, 16.6715800, 'AT', '2012-02-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2542, 'Ruprechtshofen', 'Ruprechtshofen', '', 48.1364800, 15.2767500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2543, 'Rum', 'Rum', '', 47.2833300, 11.4500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2544, 'Rudersdorf', 'Rudersdorf', '', 47.0500000, 16.1166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2545, 'Ruden', 'Ruden', '', 46.6583300, 14.7763900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2546, 'Rottenmann', 'Rottenmann', 'Rottenman,Rottenmann,luo teng man,Роттенман,Роттенманн,羅滕曼', 47.5166700, 14.3500000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2547, 'Röthis', 'Rothis', '', 47.2933200, 9.6548400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2548, 'Röthelstein', 'Roethelstein', 'Rothelstein,Röthelstein', 47.3166700, 15.3666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2549, 'Rotenturm an der Pinka', 'Rotenturm an der Pinka', 'Rotenturm,Rotenturm an der Pinka,Rotenturm-na-Pinke,Rothenthurm,Vasvoeroesvar,Vasvörösvár,Ротентурм-на-Пинке', 47.2500000, 16.2500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2550, 'Rosegg', 'Rosegg', 'Rosegg,Rozeg,Rozek,Rožek,luo sai ge,Розег,罗塞格', 46.5883300, 14.0171800, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2551, 'Röschitz', 'Roschitz', '', 48.6431200, 15.8177400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2552, 'Roppen', 'Roppen', '', 47.2166700, 10.8166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2553, 'Röns', 'Rons', '', 47.2166700, 9.7000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2554, 'Rohr im Gebirge', 'Rohr im Gebirge', 'Rohr', 47.8947100, 15.7360300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2555, 'Rohr im Burgenland', 'Rohr im Burgenland', 'Rohr,Rohr im Burgenland,Ror (Burgenland),Рор (Бургенланд)', 47.1166700, 16.1666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2556, 'Röhrenbach', 'Rohrenbach', '', 48.6500000, 15.5000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2557, 'Rohrbach bei Mattersburg', 'Rohrbach bei Mattersburg', 'Fraknonadasd,Fraknónádasd,Orbuh,Rohrbach,Rohrbach bei Mattersburg,Rorbakh-Mattersburg,Рорбах-Маттерсбург', 47.7052000, 16.4300500, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2558, 'Rohrbach an der Lafnitz', 'Rohrbach an der Lafnitz', 'Rohrbach,Rohrbach an der Lafnitz', 47.3833300, 16.0000000, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2559, 'Rohrau', 'Rohrau', 'Khollern,Rorau,luo lao,Рорау,Холлерн,罗劳', 48.0666700, 16.8500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2560, 'Ritzing', 'Ritzing', 'Receny,Ricinja,Récény', 47.6131600, 16.4954600, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2561, 'Rinn', 'Rinn', 'Rinn,lin en,Ринн,Рінн,林恩', 47.2500000, 11.5000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2562, 'Riezlern', 'Riezlern', '', 47.3577800, 10.1875900, 'AT', '2017-05-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2563, 'Rietz', 'Rietz', '', 47.2859300, 11.0307500, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2564, 'Riegersburg', 'Riegersburg', '', 47.0000000, 15.9302800, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2565, 'Riefensberg', 'Riefensberg', '', 47.5013700, 9.9583800, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2566, 'Riedlingsdorf', 'Riedlingsdorf', 'Ridlingsdorf,Roedoeny,Rödöny,li de ling si duo fu,Ридлингсдорф,里德灵斯多夫', 47.3500000, 16.1333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2567, 'Ried im Oberinntal', 'Ried im Oberinntal', 'Ried,Ried im Oberinntal', 47.0500000, 10.6500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2568, 'Ried im Innkreis', 'Ried im Innkreis', 'Reid,Riad im Innkreis,Rid (Inkrajs),Rid u Inkrajsu,Rid-im-Innkrajs,Ried,Ried im Innkreis,Rydas,li de yin ke rui si,ryd aym aynkrays,Рид (Инкрайс),Рид у Инкрајсу,Рид-им-Иннкрайс,Рід-ім-Іннкрайс,رید ایم اینکرایس,რიდ-ინ-იმკრაისი,里德因克瑞斯', 48.2112300, 13.4885500, 'AT', '2011-07-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2569, 'Reutte', 'Reutte', 'Reutte,Reutte in Tirol,Rojte,Rojtte,luo yi te,Ройте,Ройтте,Ројте,ریوٹ,羅伊特', 47.4833300, 10.7166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2570, 'Reuthe', 'Reuthe', '', 47.3711300, 9.8948100, 'AT', '2014-08-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2571, 'Retznei', 'Retznei', 'Retznei', 46.7333300, 15.5666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2572, 'Retz', 'Retz', 'Khofern,Rec,Retc,Retz,Rotz,Rötz,lei ci,Ретц,Рец,Хоферн,雷茨', 48.7500000, 15.9500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2573, 'Rettenschöss', 'Rettenschoss', '', 47.6571800, 12.2687200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2574, 'Rettenegg', 'Rettenegg', 'Frauenwald,Rettenegg', 47.5269400, 15.7810400, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2575, 'Reith bei Seefeld', 'Reith bei Seefeld', 'Reith,Reith bei Seefeld', 47.3000000, 11.2000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2576, 'Reith bei Kitzbühel', 'Reith bei Kitzbuhel', 'Reith,Reith bei Kitzbuhel,Reith bei Kitzbühel', 47.4666700, 12.3500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2577, 'Reith im Alpbachtal', 'Reith im Alpbachtal', 'Rajt,Rajt-im-Al''pbakhtal'',Reith,Reith bei Brixlegg,Reith im Aipbachtai,Reith im Åipbåchtåi,a er pu ba he gu de lai te,ryt am alpbahtl,Райт,Райт-им-Альпбахталь,Райт-ім-Альпбахталь,ریت ام الپباحتل,阿尔普巴赫谷地赖特', 47.4169400, 11.8778500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2578, 'Reisenberg', 'Reisenberg', '', 47.9940600, 16.5201800, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2579, 'Reinsberg', 'Reinsberg', 'Reinsperg', 47.9856700, 15.0706700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2580, 'Reingers', 'Reingers', '', 48.9666700, 15.1333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2581, 'Reifling', 'Reifling', 'Reifling', 47.1333300, 14.6666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2582, 'Reichraming', 'Reichraming', 'Reichraming', 47.8833300, 14.4500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2583, 'Reichenthal', 'Reichenthal', 'Reichenthal', 48.5428600, 14.3847100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2584, 'Reichenfels', 'Reichenfels', 'Rajkhenfel''s,lai xing fu er si,Райхенфельс,赖兴弗尔斯', 47.0071800, 14.7442500, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2585, 'Reichendorf', 'Reichendorf', 'Reichendorf', 47.1892200, 15.7616000, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2586, 'Reichenau im Mühlkreis', 'Reichenau im Muhlkreis', 'Reichenau,Reichenau im Muhlkreis,Reichenau im Muhlkreise,Reichenau im Mühlkreis,Reichenau im Mühlkreise', 48.4570400, 14.3487500, 'AT', '2011-12-20', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2587, 'Reichenau an der Rax', 'Reichenau an der Rax', 'Rajkhenau-an-der-Raks,Reichenau an der Rax,la ke si shan lu lai xie nao,Райхенау-ан-дер-Ракс,拉克斯山麓赖歇瑙', 47.6950900, 15.8457200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2588, 'Redlham', 'Redlham', 'Redlham', 48.0166700, 13.7333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2589, 'Redleiten', 'Redleiten', '', 48.0813800, 13.4689400, 'AT', '2017-05-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2590, 'Rechnitz', 'Rechnitz', 'Rechnitz,Rekhnic,Rohonc,lei xi ni ci,rknyz,Рехниц,רכניץ,雷希尼茨', 47.3046700, 16.4409500, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2591, 'Raxendorf', 'Raxendorf', '', 48.3410800, 15.2766600, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2592, 'Ravelsbach', 'Ravelsbach', 'Ravel''sbakh,la fu er si ba he,Равельсбах,拉弗尔斯巴赫', 48.5500000, 15.8500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2593, 'Rauris', 'Rauris', 'Rauris,lao li si,Раурис,Рауріс,劳里斯', 47.2265600, 12.9945900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2594, 'Rauchenwarth', 'Rauchenwarth', '', 48.0833000, 16.5279400, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2595, 'Rattenberg', 'Rattenberg', 'Rattenberg', 47.4394100, 11.8940700, 'AT', '2013-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2596, 'Ratten', 'Ratten', 'Ratten', 47.4833300, 15.7166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2597, 'Ratschendorf', 'Ratschendorf', 'Ratschendorf', 46.7422200, 15.8158300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2598, 'Ratsch an der Weinstraße', 'Ratsch an der Weinstrasse', 'Ratsch,Ratsch an der Weinstrasse,Ratsch an der Weinstraße', 46.6894400, 15.5711100, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2599, 'Rastenfeld', 'Rastenfeld', 'Cirings,Rastenfel''d,la si teng fei er de,Растенфельд,Цирингс,拉斯滕费尔德', 48.5734800, 15.3317600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2600, 'Rassach', 'Rassach', 'Rassach', 46.8602800, 15.2700000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2601, 'Rappottenstein', 'Rappottenstein', 'Klajnnondorf,Rappottenshtajn,la bo teng shi tai yin,Клайннондорф,Раппоттенштайн,拉波滕施泰因', 48.5216100, 15.0792500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2602, 'Ranten', 'Ranten', 'Ranten', 47.1594900, 14.0834900, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2603, 'Rankweil', 'Rankweil', 'Rankvajl,Rankvajl'',Rankweil,lan ke wei er,Ранквайл,Ранквайль,Ранквајл,رانک‌وایل,რანკვაილი,蘭克韋爾', 47.2710800, 9.6430800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2604, 'Raning', 'Raning', '', 46.8500000, 15.8166700, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2605, 'Ranggen', 'Ranggen', '', 47.2572700, 11.2112000, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2606, 'Rangersdorf', 'Rangersdorf', '', 46.8600100, 12.9492300, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2607, 'Randegg', 'Randegg', '', 48.0119800, 14.9733400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2608, 'Ramsau', 'Ramsau', '', 48.0031300, 15.8033200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2609, 'Ramsau im Zillertal', 'Ramsau im Zillertal', 'Ramsau,Ramsau im Zillertal,Ramzau,Рамзау', 47.2038300, 11.8754500, 'AT', '2012-02-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2610, 'Ramingstein', 'Ramingstein', '', 47.0746200, 13.8364200, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2611, 'Raiding', 'Raiding', 'Doborjan,Doborján,Raiding,Rajding,Rajnof,raidingu,Райдинг,ライディング', 47.5658100, 16.5305600, 'AT', '2012-11-11', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2612, 'Ragnitz', 'Ragnitz', 'Ragnitz', 46.8366700, 15.5927800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2613, 'Raggal', 'Raggal', '', 47.2108200, 9.8368800, 'AT', '2013-04-11', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2614, 'Radstadt', 'Radstadt', 'Radshtadt,Radstadt,Radstatt,Rashtadt,Rodstoud,la de si ta te,Радштадт,Раштадт,拉德斯塔特', 47.3833300, 13.4500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2615, 'Bad Radkersburg', 'Bad Radkersburg', 'Bad Radkersburg,Bad-Radkersburg,Donja Radjona,Obrajna,Radgona,Radkersburg,ba te la de ke si bao,Бад Радкерсбург,Бад-Радкерсбург,巴特拉德克斯堡', 46.6880600, 15.9880600, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2616, 'Radfeld', 'Radfeld', 'Radfeld', 47.4480600, 11.9142400, 'AT', '2013-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2617, 'Radenthein', 'Radenthein', 'Radence,Radentajn,Radenthein,Radenče,la deng tai yin,Радентайн,拉登泰因', 46.8005600, 13.7116700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2618, 'Rachau', 'Rachau', 'Rachau', 47.2166700, 14.9000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2619, 'Rabenwald', 'Rabenwald', 'Rabenwald', 47.4000000, 15.9000000, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2620, 'Rabenstein an der Pielach', 'Rabenstein an der Pielach', '', 48.0653500, 15.4677200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2621, 'Rabensburg', 'Rabensburg', '', 48.6500000, 16.9000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2622, 'Raasdorf', 'Raasdorf', '', 48.2465700, 16.5653200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2623, 'Raach am Hochgebirge', 'Raach am Hochgebirge', 'Raach,Raach am Hochgebirge', 47.6333300, 15.9333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2624, 'Raabs an der Thaya', 'Raabs an der Thaya', 'Raabs,Raabs an der Thaya,Rabs-an-der-Tajja,Рабс-ан-дер-Тайя', 48.8500000, 15.5000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2625, 'Raabau', 'Raabau', 'Raabau', 46.9627800, 15.9116700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2626, 'Raaba', 'Raaba', 'Raaba', 47.0333300, 15.5000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2627, 'Pyhra', 'Pyhra', 'Khojberg,Pira,pi la,Пира,Хойберг,皮拉', 48.1591000, 15.6862400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2628, 'Pusterwald', 'Pusterwald', 'Pusterwald', 47.3061100, 14.3755600, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2629, 'Purkersdorf', 'Purkersdorf', 'Purkersdorf,pu er ke er si duo fu,Пуркерсдорф,普尔克尔斯多夫', 48.2076900, 16.1753900, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2630, 'Purgstall', 'Purgstall', '', 48.0584100, 15.1347800, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2631, 'Pulkau', 'Pulkau', 'Pul''kau,pu er kao,Пулькау,普尔考', 48.7048400, 15.8603100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2632, 'Pühret', 'Puhret', '', 48.0348800, 13.7225200, 'AT', '2017-07-12', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2633, 'Puchenstuben', 'Puchenstuben', 'Pukhenshtuben,pu xing shi tu ben,Пухенштубен,普兴施图本', 47.9281900, 15.2874800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2634, 'Puchberg am Schneeberg', 'Puchberg am Schneeberg', 'Puchberg,Puchberg am Schneeberge,Pukhberg-am-Shneberg,Pukhberg-am-Shneeberg,Пухберг-ам-Шнеберг,Пухберг-ам-Шнееберг', 47.7870900, 15.9135200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2635, 'Puch bei Weiz', 'Puch bei Weiz', 'Puch,Puch bei Weiz', 47.2166700, 15.7166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2636, 'Puch bei Hallein', 'Puch bei Hallein', 'Puch,Pukh-Khallajn,Пух-Халлайн', 47.7153600, 13.0929600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2637, 'Prutz', 'Prutz', 'Prutz', 47.0833300, 10.6666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2638, 'Pruggern', 'Pruggern', 'Pruggern', 47.4237000, 13.8762500, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2639, 'Proleb', 'Proleb', 'Proleb', 47.4000000, 15.1333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2640, 'Prinzersdorf', 'Prinzersdorf', '', 48.2000000, 15.5166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2641, 'Prigglitz', 'Prigglitz', 'Priglic,pu li ge li ci,Приглиц,普里格利茨', 47.7031800, 15.9279400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2642, 'Pressbaum', 'Pressbaum', 'Presbaum,Pressbaum,pu lei si bao mu,Пресбаум,普雷斯鮑姆', 48.1833300, 16.0833300, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2643, 'Prellenkirchen', 'Prellenkirchen', '', 48.0740100, 16.9523300, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2644, 'Preitenegg', 'Preitenegg', 'Prajteneg,pu lai te nei ge,Прайтенег,普赖特内格', 46.9400000, 14.9258300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2645, 'Preding', 'Preding', 'Preding,pu lei ding,Прединг,普雷丁', 46.8586100, 15.4097200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2646, 'Pram', 'Pram', 'Pram', 48.2353600, 13.6057900, 'AT', '2017-07-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2647, 'Prägraten', 'Praegraten', 'Praegraten am Grossvenediger,Prägraten am Großvenediger', 47.0166700, 12.3833300, 'AT', '2017-06-13', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2648, 'Poysdorf', 'Poysdorf', 'Khjobertsgrub,Pojsdorf,Poysdorf,bo yi si duo fu,Пойсдорф,Хёбертсгруб,波伊斯多夫', 48.6666700, 16.6333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2649, 'Potzneusiedl', 'Potzneusiedl', 'Lajtafalu,Potzneusiedl', 48.0450400, 16.9477000, 'AT', '2012-11-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2650, 'Pöttsching', 'Pottsching', 'Pecsenyed,Pecsenyéd', 47.8044500, 16.3710900, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2651, 'Pottenstein', 'Pottenstein', '', 47.9582000, 16.0948000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2652, 'Pottendorf', 'Pottendorf', 'Pottendorf,bo teng duo fu,Поттендорф,波滕多夫', 47.9000000, 16.3833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2653, 'Pöttelsdorf', 'Pottelsdorf', 'Petofalva,Petőfalva', 47.7536900, 16.4386400, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2654, 'Poppendorf', 'Poppendorf', '', 46.8561100, 15.8563900, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2655, 'Pöls', 'Poels', 'Pjol''s,Pols,Pols ob Judenburg,Pöls,Pöls ob Judenburg,po er si,Пёльс,珀尔斯', 47.2166700, 14.5833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2656, 'Polling in Tirol', 'Polling in Tirol', 'Polling,Polling in Tirol', 47.2833300, 11.1500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2657, 'Pöllauberg', 'Poellauberg', 'Pollauberg,Pöllauberg', 47.3166700, 15.8500000, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2658, 'Pöllau', 'Poellau', 'Pollau,Pollau bei Gleisdorf,Pöllau,Pöllau bei Gleisdorf', 47.3000000, 15.8333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2659, 'Pöggstall', 'Poggstall', 'Pjoggshtall'',Vjurnsdorf,po ge shi ta er,Вюрнсдорф,Пёггшталль,珀格施塔尔', 48.3173400, 15.2040500, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2660, 'Poggersdorf', 'Poggersdorf', 'Poggersdorf,Pokrce,Pokrče,bo ge er si duo fu,Поггерсдорф,波格尔斯多夫', 46.6500000, 14.4500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2661, 'Podersdorf am See', 'Podersdorf am See', 'Patfalu,Podersdorf,Podersdorf-am-Ze,Podersdorf-am-Zee,Poudistoaf,Pátfalu,bin hu bo de er si duo fu,Подерсдорф-ам-Зе,Подерсдорф-ам-Зее,滨湖波德尔斯多夫', 47.8541200, 16.8370600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2662, 'Pöchlarn', 'Pochlarn', 'Bechlarn,Gross Pochlarn,Gross Pöchlarn,P''okhlarn,Pekhlarn,Pjokhlarn,Pochlarn,Pöchlarn,po xi la en,Пехларн,Пьохларн,Пёхларн,珀希拉恩', 48.2000000, 15.2000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2663, 'Plainfeld', 'Plainfeld', '', 47.8333300, 13.1833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2664, 'Pitzenberg', 'Pitzenberg', '', 48.0736100, 13.7248400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2665, 'Pitten', 'Pitten', 'Incenkhof,Pitten,pi teng,Инценхоф,Питтен,皮滕', 47.7166700, 16.1833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2666, 'Pitschgau', 'Pitschgau', 'Pitschgau', 46.7000000, 15.2666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2667, 'Pistorf', 'Pistorf', 'Pistorf', 46.7666700, 15.3666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2668, 'Pirka', 'Pirka', '', 47.0000000, 15.3833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2669, 'Piringsdorf', 'Piringsdorf', 'Piringstof,Piringštof,Repcebonya,Répcebónya', 47.4482600, 16.4151600, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2670, 'Pirching am Traubenberg', 'Pirching am Traubenberg', 'Pirching,Pirching am Traubenberg', 46.9500000, 15.6000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2671, 'Pinkafeld', 'Pinkafeld', 'Pinkafel''d,Pinkafeld,Pinkafelj,Pinkafo,Pinkafoed,Pinkaföd,Pinkafő,ping ka fei er te,Пинкафельд,萍卡菲尔特', 47.3666700, 16.1166700, 'AT', '2012-11-14', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2672, 'Pinggau', 'Pinggau', 'Pinggau,ping gao,Пинггау,平高', 47.4333300, 16.0666700, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2673, 'Pillichsdorf', 'Pillichsdorf', 'Pilliksdorf,pi li xi si duo fu,Пилликсдорф,皮利希斯多夫', 48.3500000, 16.5333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2674, 'Pill', 'Pill', 'Pill,Pill unter dem Bache', 47.3235200, 11.6801800, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2675, 'Pilgersdorf', 'Pilgersdorf', 'Pilistrof,Pilištrof,Poergoeleny,Pörgölény', 47.4410600, 16.3492000, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2676, 'Piesendorf', 'Piesendorf', '', 47.2907700, 12.7183900, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2677, 'Piberegg', 'Piberegg', 'Piberegg', 47.0833300, 15.0833300, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2678, 'Pians', 'Pians', 'Pians', 47.1348600, 10.5123700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2679, 'Pfunds', 'Pfunds', 'Fuond,Pfunds,pu feng de si,Пфундс,پفنڈز,普丰德斯', 46.9666700, 10.5500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2680, 'Pfons', 'Pfons', 'Pfons,pu feng si,Пфонс,普豐斯', 47.1420100, 11.4607100, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2681, 'Pflach', 'Pflach', 'Pflach', 47.5166700, 10.7166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2682, 'Pfarrkirchen im Mühlkreis', 'Pfarrkirchen im Muehlkreis', 'Pfarrkirchen,Pfarrkirkhen,Pfarrkirkhen-im-Mjul''krajs,mi er de qu pu fa er ji xing,Пфарркирхен,Пфарркирхен-им-Мюлькрайс,米尔地区普法尔基兴', 48.5037500, 13.8263800, 'AT', '2011-07-14', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2683, 'Pfarrkirchen bei Bad Hall', 'Pfarrkirchen bei Bad Hall', 'Pfarrkirchen,Pfarrkirchen bei Bad Hall', 48.0304600, 14.1991400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2684, 'Pfaffstätten', 'Pfaffstatten', 'Pfafshtetten,pu fa fu shi te teng,Пфафштеттен,普法夫施特滕', 48.0173700, 16.2635400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2685, 'Pfaffing', 'Pfaffing', '', 48.0180000, 13.4750700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2686, 'Pfaffenhofen', 'Pfaffenhofen', '', 47.3000000, 11.0833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2687, 'Peuerbach', 'Peuerbach', 'Beiaboch,Pojerbakh,pai er ba he,Пойербах,派尔巴赫', 48.3453000, 13.7720500, 'AT', '2017-07-12', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2688, 'Petzenkirchen', 'Petzenkirchen', '', 48.1333300, 15.1500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2689, 'Petronell-Carnuntum', 'Petronell-Carnuntum', 'Petronell,Petronell''-Karnuntum,Petronell-Carnuntum,pei te luo nei er-ka nong tu mu,Петронелль-Карнунтум,佩特罗内尔-卡农图姆', 48.1129600, 16.8658200, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2690, 'Pertlstein', 'Pertlstein', 'Pertlstein', 46.9405600, 15.9616700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2691, 'Pernitz', 'Pernitz', 'Pernic,pei ni ci,Перниц,Перніц,佩尼茨', 47.8975900, 15.9602200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2692, 'Pernersdorf', 'Pernersdorf', '', 48.7000000, 16.0166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2693, 'Pernegg an der Mur', 'Pernegg an der Mur', 'Bereneck,Perneg-an-der-Mur,Pernegg,Pernegg-an-der-Mur,mu er he pan pei er nei ge,Пернег-ан-дер-Мур,Пернегг-ан-дер-Мур,穆尔河畔佩尔内格', 47.3597900, 15.3423600, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2694, 'Pernegg', 'Pernegg', '', 48.7333300, 15.6166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2695, 'Perlsdorf', 'Perlsdorf', 'Perlsdorf', 46.9136100, 15.8141700, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2696, 'Perg', 'Perg', 'Perg,pei er ge,Перг,პერგი,佩爾格', 48.2500000, 14.6333300, 'AT', '2014-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2697, 'Perchtoldsdorf', 'Perchtoldsdorf', 'Paedaschduaf,Perkhtol''dsdorf,Perkhtoldzdorf,Pädaschduaf,pei xi tuo er ci duo fu,prshtwlsdwrf,Перхтолдздорф,Перхтольдсдорф,پرشتولسدورف,პერხტოლდსდორფი,佩希托爾茨多夫', 48.1193500, 16.2660700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2698, 'Perchau am Sattel', 'Perchau am Sattel', 'Perchau,Perchau am Sattel', 47.1000000, 14.4500000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2699, 'Pennewang', 'Pennewang', 'Pennewang', 48.1333300, 13.8500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2700, 'Peggau', 'Peggau', 'Peggau,pei gao,Пеггау,佩高', 47.2000000, 15.3500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2701, 'Payerbach', 'Payerbach', 'Pajerbakh,pai er ba he,Пайербах,派尔巴赫', 47.6920900, 15.8634000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2702, 'Paudorf', 'Paudorf', 'Khjorfart,Paudorf,bao duo fu,Паудорф,Хёрфарт,保多夫', 48.3500000, 15.6166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2703, 'Patsch', 'Patsch', '', 47.2052700, 11.4151000, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2704, 'Paternion', 'Paternion', 'Paternion,Spatrjan,pa te ni weng,Špatrjan,Патернион,帕特尼翁', 46.7141700, 13.6361100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2705, 'Passail', 'Passail', 'Passail,Passajl'',pa sai er,Пассайль,帕赛尔', 47.2833300, 15.5166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2706, 'Pasching', 'Pasching', 'Pasching,Pashing,Pasingas,Pašingas,pa xing,Пашинг,帕興', 48.2593100, 14.2036900, 'AT', '2011-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2707, 'Parschlug', 'Parschlug', '', 47.4809000, 15.2864500, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2708, 'Parndorf', 'Parndorf', 'Pandorfalu,Pandrof,Parndorf,Pándorfalu,pa en duo fu,parundorufu,Парндорф,パルンドルフ,帕恩多夫', 47.9996300, 16.8604900, 'AT', '2012-11-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2709, 'Parbasdorf', 'Parbasdorf', '', 48.2833300, 16.6000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2710, 'Pamhagen', 'Pamhagen', 'Pamhagen,Pamkhagen,Pomogy,Памхаген', 47.7009200, 16.9077900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2711, 'Pama', 'Pama', 'Bijelo Selo,Lajtakoertvelyes,Lajtakörtvélyes,Pama,Пама', 48.0500000, 17.0333300, 'AT', '2012-11-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2712, 'Palfau', 'Palfau', 'Pal''fau,Palfau,pa er fu,Пальфау,帕尔福', 47.7000000, 14.8000000, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2713, 'Paldau', 'Paldau', 'Paldau', 46.9422200, 15.7958300, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2714, 'Pack', 'Pack', 'Pack', 46.9791700, 14.9841700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2715, 'Oetz', 'Oetz', 'Ec,Ehc,Ehtc,Oetz,Otz,e ci,Ötz,Ец,Этц,Эц,厄茨', 47.2000000, 10.9000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2716, 'Otterthal', 'Otterthal', 'Ottertal,Otterthal', 47.6166700, 15.9333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2717, 'Ottenthal', 'Ottenthal', '', 48.7610000, 16.5791400, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2718, 'Ottensheim', 'Ottensheim', 'Ottensheim,Ottenskhajm,ao teng si hai mu,Оттенсхайм,奥滕斯海姆', 48.3324600, 14.1742500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2719, 'Ottenschlag im Mühlkreis', 'Ottenschlag im Muhlkreis', 'Ottenschlag,Ottenschlag im Muhlkreis,Ottenschlag im Mühlkreis', 48.4663200, 14.3847100, 'AT', '2011-12-20', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2720, 'Ottenschlag', 'Ottenschlag', '', 48.4239300, 15.2192400, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2721, 'Osterwitz', 'Osterwitz', 'Ostervic,Osterwitz,ao shi te er wei ci,Остервиц,奥施特尔维茨', 46.8594300, 15.0899800, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2722, 'Ossiach', 'Ossiach', 'Osoje,Ossiach,Ossiakh,Ossijakh,ao xi ya he,Оссиах,Оссіях,奥西亚赫', 46.6743500, 13.9835800, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2723, 'Oslip', 'Oslip', 'Oslip,Oszlop,Uzlop,Ослип', 47.8290600, 16.6195700, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2724, 'Orth an der Donau', 'Orth an der Donau', 'Orth', 48.1452400, 16.7008900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2725, 'Opponitz', 'Opponitz', 'Opponic,ao bo ni ci,Оппониц,奥波尼茨', 47.8777600, 14.8228300, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2726, 'Oppenberg', 'Oppenberg', 'Oppenberg', 47.4833300, 14.2666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2727, 'Ollersdorf im Burgenland', 'Ollersdorf im Burgenland', 'Ollersdorf,Ollersdorf (Burgenland),Ollersdorf im Burgenland,Оллерсдорф (Бургенланд)', 47.1833300, 16.1666700, 'AT', '2017-03-15', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2728, 'Olbendorf', 'Olbendorf', '', 47.1833300, 16.2000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2729, 'Offenhausen', 'Offenhausen', 'Offenhausen', 48.1500000, 13.8333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2730, 'Öblarn', 'OEblarn', 'Oblarn,Oeblarn,Öblarn', 47.4593800, 13.9902300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2731, 'Oberzeiring', 'Oberzeiring', 'Obercajring,Oberzeiring,shang cai ling,Оберцайринг,上蔡灵', 47.2500000, 14.4833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2732, 'Oberwölz Stadt', 'Oberwoelz Stadt', 'Oberwolz,Oberwolz Stadt,Oberwölz,Oberwölz Stadt', 47.2011700, 14.2832100, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2733, 'Oberweg', 'Oberweg', 'Oberweg,Oberweg Talkessel', 47.1500000, 14.6333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2734, 'Oberwart', 'Oberwart', 'Felsoor,Felsőőr,Gornja Borta,Obervart,Oberwart,Owawart,Zgornja Borta,shang wa te,Оберварт,אוברוורט,上瓦特', 47.2897100, 16.2059500, 'AT', '2012-11-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2735, 'Oberwang', 'Oberwang', 'Oberwang', 47.8666700, 13.4333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2736, 'Oberwaltersdorf', 'Oberwaltersdorf', '', 47.9756700, 16.3219100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2737, 'Obervogau', 'Obervogau', 'Obervogau', 46.7450000, 15.5847200, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2738, 'Obervellach', 'Obervellach', 'Oberfellakh,Obervellach,shang wei la he,Оберфеллах,上韦拉赫', 46.9366700, 13.2041700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2739, 'Obertrum am See', 'Obertrum am See', 'Obertrum,Obertrum am See,Obertrum-am-Zee,Обертрум-ам-Зее', 47.9372200, 13.0772200, 'AT', '2016-02-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2740, 'Obertilliach', 'Obertilliach', 'Obertiliakh,Obertilliach,Obertilliakh,Obertillijakh,awbrtylyakh,shang di li la he,Обертилиах,Обертиллиах,Обертілліях,اوبرتیلیاخ,上蒂利拉赫', 46.7105600, 12.6144400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2741, 'Oberstorcha', 'Oberstorcha', 'Oberstorcha', 46.9666700, 15.8000000, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2742, 'Obersiebenbrunn', 'Obersiebenbrunn', '', 48.2653700, 16.7107600, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2743, 'Oberschützen', 'Oberschutzen', 'Felsoloevo,Felsőlövő,Obershjutcen,shang xu cen,Обершютцен,上许岑', 47.3513800, 16.2073200, 'AT', '2012-11-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2744, 'Oberrettenbach', 'Oberrettenbach', 'Oberrettenbach', 47.1500000, 15.8000000, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2745, 'Oberpullendorf', 'Oberpullendorf', 'Felsopulya,Felsőpulya,Gornja Pulja,Oberpulendorf,Oberpullendorf,Owapuindorf,shang pu lun duo fu,Оберпулендорф,Оберпуллендорф,上普伦多夫', 47.5035200, 16.5044700, 'AT', '2012-02-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2746, 'Pettnau', 'Pettnau', 'Oberpettnau,Pettnau', 47.2920400, 11.1596200, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2747, 'Oberneukirchen', 'Oberneukirchen', 'Oberneukirchen,Obernojkirkhen,Обернойкирхен', 48.4640400, 14.2227500, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2748, 'Oberndorf in Tirol', 'Oberndorf in Tirol', 'Oberndorf,Oberndorf in Tirol', 47.5000000, 12.3833300, 'AT', '2016-02-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2749, 'Oberndorf bei Schwanenstadt', 'Oberndorf bei Schwanenstadt', '', 48.0555900, 13.7567700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2750, 'Oberndorf bei Salzburg', 'Oberndorf bei Salzburg', 'Oberndorf,Oberndorf baj Zalcburg,Oberndorf bei Salzburg,Oberndorf-Zal''cburg,Oberndorf-baj-Zal''cburg,Owandorf ba Soizburg,ou ben duo fu,Оберндорф бай Залцбург,Оберндорф-Зальцбург,Оберндорф-бай-Зальцбург,歐本多夫', 47.9500000, 12.9333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2751, 'Oberndorf an der Melk', 'Oberndorf an der Melk', 'Oberndorf,Oberndorf-an-der-Melk,Оберндорф-ан-дер-Мелк', 48.0638600, 15.2243000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2752, 'Oberloisdorf', 'Oberloisdorf', 'Felsolaszlo,Felsőlászló,Nadrlostrof,Nadrloštrof', 47.4473600, 16.5076400, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2753, 'Oberlienz', 'Oberlienz', 'Oberlienc,Oberlienz,shang lin ci,Оберлиенц,Оберлієнц,上林茨', 46.8472200, 12.7313900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2754, 'Oberkurzheim', 'Oberkurzheim', 'Oberkurzheim', 47.2333300, 14.5833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2755, 'Oberhofen im Inntal', 'Oberhofen im Inntal', 'Oberhofen,Oberhofen im Inntal,Oberhofen in Tirol,Oberkhofen,Оберхофен', 47.3000000, 11.0833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2756, 'Oberhofen am Irrsee', 'Oberhofen am Irrsee', 'Oberhofen,Oberhofen am Irrsee,Oberkhofen-am-Irrzee,Oberkhofen-am-Irze,yi er hu pan shang huo fen,Оберхофен-ам-Ирзе,Оберхофен-ам-Иррзее,伊尔湖畔上霍芬', 47.9500000, 13.3000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2757, 'Oberhaag', 'Oberhaag', 'Oberkhag,shang ha ge,Оберхаг,上哈格', 46.6869000, 15.3320200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2758, 'Ober-Grafendorf', 'Ober-Grafendorf', '', 48.1504000, 15.5453100, 'AT', '2017-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2759, 'Oberdrauburg', 'Oberdrauburg', 'Ober-Drauberg,Oberdrauburg,shang de lao bao,Обердраубург,上德劳堡', 46.7430600, 12.9702800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2760, 'Oberdorf im Burgenland', 'Oberdorf im Burgenland', 'Oberdorf,Oberdorf (Burgerland),Oberdorf im Burgenland,Обердорф (Бургерланд)', 47.2166700, 16.2166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2761, 'Oberdorf am Hochegg', 'Oberdorf am Hochegg', 'Oberdorf,Oberdorf am Hochegg', 46.9786100, 15.7216700, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2762, 'Oberalm', 'Oberalm', '', 47.7000000, 13.1000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2763, 'Oberaich', 'Oberaich', '', 47.4000000, 15.2166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2764, 'Obdach', 'Obdach', 'Obdach', 47.0666700, 14.6833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2765, 'Nüziders', 'Nuziders', 'Njuciders,nu qi de si,Нюцидерс,努齐德斯', 47.1666700, 9.8000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2766, 'Nußdorf am Haunsberg', 'Nussdorf am Haunsberg', 'Nusdorf-am-Gaunsberg,Nusdorf-am-Khaunsberg,Nussdorf,Nussdorf am Haunsberg,Nußdorf am Haunsberg,hao en si shan lu nu si duo fu,Нусдорф-ам-Гаунсберг,Нусдорф-ам-Хаунсберг,豪恩斯山麓努斯多夫', 47.9594400, 13.0091700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2767, 'Nofels', 'Nofels', 'Nofels', 47.2548300, 9.5780200, 'AT', '2012-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2768, 'Nöchling', 'Nochling', '', 48.2243300, 14.9812300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2769, 'Nitscha', 'Nitscha', 'Nitscha', 47.1166700, 15.7500000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2770, 'Nikolsdorf', 'Nikolsdorf', 'Nikol''sdorf,Nikolsdorf,ni ke er si duo fu,Никольсдорф,Нікольсдорф,尼科尔斯多夫', 46.7858300, 12.9133300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2771, 'Niklasdorf', 'Niklasdorf', 'Niklasdorf,Никласдорф', 47.3833300, 15.1500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2772, 'Nikitsch', 'Nikitsch', 'Filez,Filež,Fueles,Füles,Nikich,Nikitsch,Никич', 47.5361500, 16.6601700, 'AT', '2012-11-11', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2773, 'Niederwölz', 'Niederwolz', 'Niederwolz,Niederwölz', 47.1512600, 14.3747900, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2774, 'Niederthalheim', 'Niederthalheim', 'Niederthalheim', 48.0990100, 13.7687000, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2775, 'Niederöblarn', 'Niederoeblarn', 'Niederoblarn,Niederöblarn', 47.4766700, 14.0193700, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2776, 'Niedernsill', 'Niedernsill', '', 47.2833300, 12.6500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2777, 'Niederndorf', 'Niederndorf', '', 47.6500000, 12.2166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2778, 'Niederleis', 'Niederleis', 'Niderlajs,xia lai si,Нидерлайс,下莱斯', 48.5500000, 16.4000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2779, 'Niederhollabrunn', 'Niederhollabrunn', 'Niderkhollabrun,Niderkhollabrunn,Niederhollabrunn,xia huo la bu lun,Нидерхоллабрун,Нидерхоллабрунн,下霍拉布伦', 48.4333300, 16.3000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2780, 'Nickelsdorf', 'Nickelsdorf', 'Mikloshalma,Miklóshalma,Nickelsdorf,Nikel''sdorf,Nikkel''sdorf,ni ke er si duo fu,Никкельсдорф,Нікельсдорф,尼克尔斯多夫', 47.9405600, 17.0694400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2781, 'Neutal', 'Neutal', 'Najtolj,Nyujtal,Nyujtál,Sopronujlak,Sopronújlak', 47.5454800, 16.4461900, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2782, 'Neustift im Stubaital', 'Neustift im Stubaital', 'Neustift,Neustift im Stubaital,Nojshtift,Nojshtift-im-Shtubajtal'',shi tu bai gu de xin shi di fu te,Нойштифт,Нойштіфт-ім-Штубайталь,نیوسٹفٹ ام سٹوبائٹل,施图拜谷地新施蒂夫特', 47.1166700, 11.3166700, 'AT', '2014-05-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2783, 'Neustift bei Güssing', 'Neustift bei Gussing', 'Neustift,Neustift bei Gussing,Neustift bei Güssing', 47.0247400, 16.2604100, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2784, 'Neustift an der Lafnitz', 'Neustift an der Lafnitz', 'Neustift,Neustift an der Lafnitz,Nojstift-na-Lafnice,Нойстифт-на-Лафнице', 47.3666700, 16.0333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2785, 'Neusiedl an der Zaya', 'Neusiedl an der Zaya', 'Neusiedl,Neusiedl an der Zaya,Neusiedl-Zaya,Nojzidl''-an-der-Cajja,Нойзидль-ан-дер-Цайя', 48.5992000, 16.7799000, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2786, 'Neusiedl am See', 'Neusiedl am See', 'Neisiedl am See,Neusiedl,Neusiedl am See,Nezsider,Nojzidl am Zee,Nojzidl na Jezeru,Nojzidl''-am-Ze,Nojzidl''-am-Zee,Nojzidul am Zee,bin hu xin xi de er,Нойзидль-ам-Зе,Нойзидль-ам-Зее,Нойзидъл ам Зее,Нойзідль-ам-Зеє,Нојзидл ам Зее,Нојзидл на Језеру,נויזידל אם זי,濱湖新錫德爾', 47.9490100, 16.8417000, 'AT', '2012-02-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2787, 'Neunkirchen', 'Neunkirchen', '', 47.7209600, 16.0810700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2788, 'Neumarkt in Steiermark', 'Neumarkt in Steiermark', 'Neumarkt,Neumarkt in Steiermark,Nojmarkt,Nojmarkt-in-Shtajermark,Sankt-Marajn-Nojmarkt,shi tai er ma ke de qu nuo yi ma ke te,Ноймаркт,Ноймаркт-ин-Штайермарк,Санкт-Марайн-Ноймаркт,施泰尔马克地区诺伊马克特', 47.0739800, 14.4272800, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2789, 'Neumarkt an der Ybbs', 'Neumarkt an der Ybbs', 'Neumarkt,Neumarkt an der Ybbs', 48.1410300, 15.0575800, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2790, 'Neumarkt am Wallersee', 'Neumarkt am Wallersee', 'Neimorkt am Woiersee,Neumark,Neumarkt,Neumarkt am Wallersee,Nojmarkt-am-Vallerze,Nojmarkt-am-Vallerzee,wa lei hu pan nuo yi ma ke te,Ноймаркт-ам-Валлерзе,Ноймаркт-ам-Валлерзее,瓦勒湖畔诺伊马克特', 47.9500000, 13.2333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2791, 'Neulengbach', 'Neulengbach', 'Nojlengbakh,xin lun ba he,Нойленгбах,新伦巴赫', 48.1974500, 15.9021900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2792, 'Neukirchen bei Lambach', 'Neukirchen bei Lambach', 'Neukirchen,Neukirchen bei Lambach', 48.1000000, 13.8166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2793, 'Neukirchen an der Vöckla', 'Neukirchen an der Vockla', 'Neukirchen,Neukirchen an der Vockla,Neukirchen an der Vöckla,Nojkirkhen-an-der-Fjokla,Нойкирхен-ан-дер-Фёкла', 48.0333300, 13.5333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2794, 'Neukirchen am Großvenediger', 'Neukirchen am Grossvenediger', 'Neukirchen,Neukirchen am Grossvenediger,Neukirchen am Großvenediger,Nojkirkhen-am-Grosfenediger,Нойкирхен-ам-Гросфенедигер', 47.2504600, 12.2758500, 'AT', '2016-07-05', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2795, 'Neuhofen an der Ybbs', 'Neuhofen an der Ybbs', 'Neuhofen,Nojkhofen-na-Ibbse,Нойхофен-на-Иббсе', 48.0579500, 14.8548900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2796, 'Neuhaus', 'Neuhaus', '', 46.6333300, 14.8833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2797, 'Neufeld an der Leitha', 'Neufeld an der Leitha', 'Lajtaujfalu,Lajtaújfalu,Neifoed an da Leitha,Neiföd an da Leitha,Neufeld,Neufeld an der Leitha,Nojfel''d-an-der-Lajta,Nojfel''d-an-der-Lajte,Nojfel''d-na-Lajte,Nojfel''d-na-Lajti,Novo Selo,lai ta he pan nuo yi fu er de,Нойфельд-ан-дер-Лайта,Нойфельд-ан-дер-Лайте,Нойфельд-на-Лайте,Нойфельд-на-Лайті,莱塔河畔诺伊弗尔德', 47.8655800, 16.3785600, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2798, 'Neudörfl', 'Neudorfl', 'Lajtaszentmiklos,Lajtaszentmiklós,Nojderfl'',Nojdjorfl'',xin de er fu,Нойдерфль,Нойдёрфль,新德尔夫', 47.7965500, 16.2977000, 'AT', '2012-11-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2799, 'Neudorf bei Staatz', 'Neudorf bei Staatz', 'Neudorf,Neudorf bei Staatz', 48.7208300, 16.4913900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2800, 'Neudau', 'Neudau', 'Neudau', 47.1755400, 16.1018400, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2801, 'Neuberg an der Mürz', 'Neuberg an der Muerz', 'Neuberg,Nojberg an der Mjurc,Nojberg-an-der-Mjurc,mi er ci he pan nuo yi bei ge,Нойберг ан дер Мюрц,Нойберг-ан-дер-Мюрц,米尔茨河畔诺伊贝格', 47.6642300, 15.5722600, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2802, 'Nestelbach im Ilztal', 'Nestelbach im Ilztal', 'Nestelbach im Ilztal,Nestolbach', 47.0833300, 15.8666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2803, 'Nestelbach bei Graz', 'Nestelbach bei Graz', 'Nestelbach,Nestelbach bei Graz', 47.0605300, 15.6114000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2804, 'Nesselwängle', 'Nesselwangle', 'Nessel''vengle,Nesselwangle,Nesselwängle,na se er wen lei,Нессельвенгле,纳瑟尔文勒', 47.4833300, 10.6166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2805, 'Nenzing', 'Nenzing', 'Nencing,nen qing,Ненцинг,Ненцінг,嫩青', 47.1843600, 9.7053900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2806, 'Neidling', 'Neidling', 'Neidling,Neudling', 48.2400500, 15.5559100, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2807, 'Neckenmarkt', 'Neckenmarkt', 'Lekindrof,Neckenmarkt,Nekenmarkt,Nekkenmarkt,Sopronnyek,Sopronnyék,nei ken ma ke te,Некенмаркт,Неккенмаркт,内肯马克特', 47.5996400, 16.5467000, 'AT', '2012-11-05', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2808, 'Nauders', 'Nauders', 'Nauders,nuo de li ao,Наудерс,诺德里奥', 46.8885900, 10.5012600, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2809, 'Natters', 'Natters', 'Natters,na te si,Наттерс,نیٹرز,納特斯', 47.2341400, 11.3734200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2810, 'Nassereith', 'Nassereith', 'Nasserajt,Nassereith,na se lai te,nasryt,Нассерайт,ناسریت,纳瑟莱特', 47.3166700, 10.8333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2811, 'Namlos', 'Namlos', 'Namlos', 47.3500000, 10.6666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2812, 'Naas', 'Naas', 'Naas', 47.2508600, 15.5944900, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2813, 'Mutters', 'Mutters', 'Mutters,mu te si,Муттерс,穆特斯', 47.2333300, 11.3833300, 'AT', '2012-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2814, 'Musau', 'Musau', 'Agno,Musau,Агно', 47.5319500, 10.6733900, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2815, 'Mürzzuschlag', 'Muerzzuschlag', 'Mircushlag,Mjurccushlag,Murssuschalg,Murzzuschlag,Mürzzuschlag,mi er ci chu shi la ge,Мирцушлаг,Мюрццушлаг,מירצצושלאג,مۇرززۇسچلاگ,米爾茨楚施拉格', 47.6000000, 15.6833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2816, 'Mürzsteg', 'Muerzsteg', 'Mircshteg,Mjurcshteg,Murzsteg,Myrtsstenk,Mürzsteg,mi er ci shi tai ge,Μύρτσστεγκ,Мирцштег,Мюрцштег,米尔茨施泰格', 47.6755600, 15.4914500, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2817, 'Mürzhofen', 'Muerzhofen', 'Murtzhofen,Murzhofen,Mürtzhofen,Mürzhofen', 47.4833300, 15.3833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2818, 'Mureck', 'Mureck', 'Cmurek,Mureck,Murehkk,mu lei ke,Мурэкк,穆勒克', 46.7080600, 15.7747200, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2819, 'Münster', 'Munster', 'Mjunster,Мюнстер', 47.4216400, 11.8335600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2820, 'Münchendorf', 'Munchendorf', 'Mjunkhendorf,Muenchendorf,Munchendorf,Münchendorf,Мюнхендорф', 48.0333300, 16.3833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2821, 'Müllendorf', 'Mullendorf', 'Melindoff,Szarazvam,Szárazvám', 47.8394300, 16.4625800, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2822, 'Muhr', 'Muhr', 'Muhr,Mur', 47.0989300, 13.4975600, 'AT', '2014-10-15', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2823, 'Mühlgraben', 'Muhlgraben', '', 46.8897200, 16.0408300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2824, 'Mühlen', 'Muhlen', '', 47.0307100, 14.5084800, 'AT', '2011-09-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2825, 'Mühldorf bei Feldbach', 'Muehldorf bei Feldbach', 'Mjul''dorf (Fel''dbakh),Muhldorf,Muhldorf bei Feldbach,Mühldorf,Mühldorf bei Feldbach,Мюльдорф (Фельдбах)', 46.9386100, 15.9075000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2826, 'Mühldorf', 'Muhldorf', '', 48.3666700, 15.3500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2827, 'Mühldorf', 'Muhldorf', '', 46.8602800, 13.3536100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2828, 'Mühlbach am Hochkönig', 'Muhlbach am Hochkonig', 'Mijbouch am Houchkinig,Mjul''bakh-am-Gokhkenig,Mjul''bakh-am-Khokhkjonig,Muhlbach,Muhlbach am Hochkonig,Mühlbach,Mühlbach am Hochkönig,shang ke ni xi shan lu mi er ba he,Мюльбах-ам-Гохкеніг,Мюльбах-ам-Хохкёниг,上柯尼希山麓米尔巴赫', 47.3774600, 13.1292600, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2829, 'Muggendorf', 'Muggendorf', '', 47.9105900, 15.9353300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2830, 'Mötz', 'Motz', '', 47.2833300, 10.9500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2831, 'Moschendorf', 'Moschendorf', 'Moschendorf,Moshendorf,Nagysaroslak,Nagysároslak,Мошендорф', 47.0584300, 16.4772800, 'AT', '2013-04-02', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2832, 'Mörtschach', 'Mortschach', '', 46.9238900, 12.9177800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2833, 'Mortantsch', 'Mortantsch', 'Mortantsch', 47.2000000, 15.5666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2834, 'Mörbisch am See', 'Morbisch am See', 'Fertomeggyes,Fertőmeggyes,Mjorbish-am-Zee,Moerbisch am See,Morbisch,Morbisch am See,Mörbisch,Mörbisch am See,Мёрбиш-ам-Зее', 47.7500000, 16.6666700, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2835, 'Mooskirchen', 'Mooskirchen', 'Mooskirchen', 46.9816700, 15.2788900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2836, 'Moosburg', 'Moosburg', 'Moosburg,Moosburg in Karnten,Moosburg in Kärnten,Mosburg,Мосбург', 46.6575000, 14.1747200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2837, 'Moosbrunn', 'Moosbrunn', '', 48.0166700, 16.4500000, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2838, 'Mönichwald', 'Moenichwald', 'Monichwald,Mönichwald,mo ni xi wa er de,莫尼希瓦尔德', 47.4465500, 15.8827500, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2839, 'Mönichkirchen', 'Monichkirchen', 'Mjonikhkirkhen,mo ni xi ji xing,Мёнихкирхен,默尼希基兴', 47.5106200, 16.0342500, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2840, 'Mondsee', 'Mondsee', 'Mondzee,Мондзее', 47.8564800, 13.3490800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2841, 'Mönchhof', 'Monchhof', 'Baratudvar,Barátudvar', 47.8802000, 16.9412600, 'AT', '2012-11-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2842, 'Mölbling', 'Molbling', '', 46.8500000, 14.4333300, 'AT', '2013-12-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2843, 'Möggers', 'Moggers', '', 47.5666700, 9.8166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2844, 'Mogersdorf', 'Mogersdorf', 'Mogersdorf,Nagyfalva,mo ge er si duo fu,Могерсдорф,莫格尔斯多夫', 46.9491700, 16.2322200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2845, 'Modriach', 'Modriach', 'Modriach', 46.9500000, 15.0500000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2846, 'Mödling', 'Modling', 'Medling,Medlingas,Mjodling,Moedling,Mödling,Mėdlingas,mdlyng,medlingi,mo de lin,mwdlyng,Медлинг,Мёдлинг,מדלינג,مودلینگ,მედლინგი,默德林', 48.0860500, 16.2892100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2847, 'Mittersill', 'Mittersill', 'Mittasue,Mittasü,Mittersil,Mittersill,Mitterzil'',Mitterzill'',mi te xi er,Миттерзилль,Миттерзиль,Міттерзілль,მიტერზილი,米特西爾', 47.2833300, 12.4833300, 'AT', '2014-09-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2848, 'Mitterndorf an der Fischa', 'Mitterndorf an der Fischa', 'Mitterndorf,Mitterndorf an der Fischa,Mitterndorf-an-der-Fisha,fei sha he pan mi te en duo fu,Миттерндорф-ан-дер-Фиша,菲沙河畔米特恩多夫', 47.9973900, 16.4735700, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2849, 'Mitterlabill', 'Mitterlabill', 'Mitterlabill', 46.8891700, 15.6355600, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2850, 'Mitterdorf im Mürztal', 'Mitterdorf im Muerztal', 'Mitterdorf,Mitterdorf (Mjurcal''),Mitterdorf im Murztal,Mitterdorf im Mürztal,Миттердорф (Мюрцаль)', 47.5333300, 15.5166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2851, 'Mitterdorf an der Raab', 'Mitterdorf an der Raab', 'Mitterdorf,Mitterdorf an der Raab', 47.1666700, 15.6000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2852, 'Mitterbach am Erlaufsee', 'Mitterbach am Erlaufsee', 'Mitterbakh-am-Ehrlaufzee,ai lao fu hu pan mi te er ba he,Миттербах-ам-Эрлауфзее,埃劳夫湖畔米特尔巴赫', 47.8139600, 15.2953700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2853, 'Mittelberg', 'Mittelberg', '', 47.3512700, 10.1719700, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2854, 'Mistelbach', 'Mistelbach', 'Mistel''-Bakh,Mistelbach,Mistelbach an der Zaya,Мистель-Бах', 48.5700000, 16.5766700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2855, 'Mischendorf', 'Mischendorf', 'Mishendorf,Pinkamiske,mi shen duo fu,Мишендорф,Мішендорф,米申多夫', 47.1927700, 16.3144400, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2856, 'Mils bei Imst', 'Mils bei Imst', 'Mils,Mils bei Imst', 47.2061600, 10.6748500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2857, 'Miesenbach', 'Miesenbach', '', 47.8403500, 15.9823600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2858, 'Miesenbach bei Birkfeld', 'Miesenbach bei Birkfeld', 'Miesenbach', 47.3666700, 15.7666700, 'AT', '2017-06-15', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2859, 'Mieming', 'Mieming', 'Miming,maymng,mi ming,Миминг,Мімінг,مائمنگ,米明', 47.3000000, 10.9833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2860, 'Mieders', 'Mieders', 'Miders,mi de er si,Мидерс,Мідерс,米德尔斯', 47.1666700, 11.3833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2861, 'Michelhausen', 'Michelhausen', '', 48.2908500, 15.9389300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2862, 'Micheldorf in Oberösterreich', 'Micheldorf in Oberoesterreich', 'Micheldorf,Mikhel''dorf,Mikhel''dorf (Verkhnjaja Avstrija),shang ao de li zhou mi xie er duo fu,Михельдорф,Михельдорф (Верхняя Австрия),上奧地利州米歇爾多夫', 47.8776400, 14.1335700, 'AT', '2011-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2863, 'Micheldorf', 'Micheldorf', '', 46.9166700, 14.4166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2864, 'Michaelerberg', 'Michaelerberg', '', 47.4108300, 13.8933300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2865, 'Mettersdorf am Saßbach', 'Mettersdorf am Sassbach', 'Mettersdorf,Mettersdorf am Sassbach,Mettersdorf am Saßbach', 46.8058300, 15.7111100, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2866, 'Metnitz', 'Metnitz', 'Metnic,mei te ni ci,Метниц,梅特尼茨', 46.9805600, 14.2166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2867, 'Merkendorf', 'Merkendorf', '', 46.8572200, 15.9038900, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2868, 'Mellach', 'Mellach', '', 46.9333300, 15.5166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2869, 'Melk', 'Melk', 'Mel''k,Melk,Mellicum,Moek,Mök,mei er ke,melkeu,meruku,mlq,Мелк,Мельк,מלק,メルク,梅爾克,멜크', 48.2273700, 15.3318600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2870, 'Meiningen', 'Meiningen', '', 47.2989100, 9.5786200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2871, 'Mayrhofen', 'Mayrhofen', 'Mairhofen,Majerkhofen,Majrgofen,Majrkhofen,Mayrhofen,Zillertal,mai er huo fen,Майерхофен,Майргофен,Майрхофен,מאיירהופן,迈尔霍芬', 47.1666700, 11.8666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2872, 'Mautern in Steiermark', 'Mautern in Steiermark', 'Mautern,Mautern Markt,Mautern Steiermark,Mautern in Steiermark', 47.4000000, 14.8333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2873, 'Mauterndorf', 'Mauterndorf', 'Mautterndorf', 47.1345100, 13.6788400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2874, 'Mauerbach', 'Mauerbach', 'Mauehrbakh,mao er ba he,Мауэрбах,毛尔巴赫', 48.2451400, 16.1679300, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2875, 'Mattsee', 'Mattsee', 'Mattze,Matze,Matzee,ma te sai,Матзе,Матзее,Маттзе,马特塞', 47.9666700, 13.1000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2876, 'Mattersburg', 'Mattersburg', 'Matersburg,Matersburgas,Mattasburg,Mattersburg,Mattersdorf,Nagymarton,Walbersdorf,ma te si bao,mateleuseubuleukeu,matterusuburuku,mtrsbwrg,Матерсбург,Маттерсбург,מאטערסדארף,מטרסבורג,マッテルスブルク,馬特斯堡,마테르스부르크', 47.7333300, 16.4000000, 'AT', '2012-02-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2877, 'Matrei in Osttirol', 'Matrei in Osttirol', 'Matraj,Matraj (Osttirol''),Matraj-in-Osttirol'',Matrei,Matrei in Osttirol,Motre,dong di luo er de qu ma te lai,Матрай,Матрай (Осттироль),Матрай-ин-Осттироль,Матрай-ін-Осттіроль,东蒂罗尔地区马特赖', 47.0000000, 12.5333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2878, 'Matrei am Brenner', 'Matrei am Brenner', 'Matrei,Matrei am Brenner', 47.1333300, 11.4500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2879, 'Marz', 'Marz', 'Marca,Marczfalva,Márczfalva', 47.7166700, 16.4166700, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2880, 'Martinsberg', 'Martinsberg', '', 48.3754900, 15.1499700, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2881, 'Markt Sankt Martin', 'Markt Sankt Martin', 'Markt Sankt Martin,Markt-Sankt-Martin,Sankt Martin,Sopronszentmarton,Sopronszentmárton,Sveti Martin,Маркт-Санкт-Мартин', 47.5620500, 16.4250800, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2882, 'Sankt Florian', 'Sankt Florian', 'Markt Sankt Florian,Markt-Sankt-Florian,Sankt Florian,Маркт-Санкт-Флориан', 48.2056800, 14.3783600, 'AT', '2011-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2883, 'Bad Pirawarth', 'Bad Pirawarth', 'Bad Pirawarth,Markt Pirawarth,Pyrawarth', 48.4519400, 16.5983300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2884, 'Markt Piesting', 'Markt Piesting', 'Markt-Pisting,Piesting,Unterpiesting,ma ke te pi shi ting,Маркт-Пистинг,马克特皮施廷', 47.8735800, 16.1251000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2885, 'Markt Neuhodis', 'Markt Neuhodis', 'Markt Hodis,Markt Neuhodis,Markt-Nojkhodis,Novi Hodas,Varoshodasz,Városhodász,Маркт-Нойходис', 47.2956500, 16.3956400, 'AT', '2012-11-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2886, 'Markt Allhau', 'Markt Allhau', 'Alhau,Allhau,Markt Al''khau,Markt Allhau,Маркт Альхау', 47.2833300, 16.0833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2887, 'Markgrafneusiedl', 'Markgrafneusiedl', '', 48.2666700, 16.6333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2888, 'Mariazell', 'Mariazell', 'Mariacell'',Mariazell,Mariazoe,Mariazö,ma li ya cai er,mariatsu~eru,Мариацелль,Маріацелль,マリアツェル,瑪麗亞采爾', 47.7730600, 15.3163900, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2889, 'Maria Wörth', 'Maria Worth', 'Maria Worth,Maria Wörth,Maria-Vjort,Marija-Vjort,Otok,ma li ya wei er te,Мариа-Вёрт,Мария-Вёрт,玛丽亚韦尔特', 46.6163900, 14.1630600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2890, 'Mariatrost', 'Mariatrost', 'Mariatrost', 47.1000000, 15.5000000, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2891, 'Maria Taferl', 'Maria Taferl', 'Marija-Taferl'',Vim,ma li ya ta fei er,Вим,Мария-Таферль,玛丽亚塔费尔', 48.2270200, 15.1595400, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2892, 'Mariastein', 'Mariastein', 'Mariastein', 47.5277200, 12.0547900, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2893, 'Mariasdorf', 'Mariasdorf', 'Mariafalva,Mariasdorf,Máriafalva,ma li ya duo fu,Мариасдорф,玛丽亚多夫', 47.3658000, 16.2313600, 'AT', '2012-11-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2894, 'Maria Saal', 'Maria Saal', 'Gospa Sveta,Maria Saal,Maria-Zal'',Marija-Zal'',ma li ya sa er,Мариа-Заль,Мария-Заль,ማሪያ ዛል,玛丽亚萨尔', 46.6808300, 14.3486100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2895, 'Maria Rain', 'Maria Rain', '', 46.5538900, 14.2955600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2896, 'Mariapfarr', 'Mariapfarr', 'Mariapfar,Pforch,ma li ya pu fa er,Мариапфар,Маріапфар,玛丽亚普法尔', 47.1500000, 13.7500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2897, 'Maria Neustift', 'Maria Neustift', 'Maria Neustift', 47.9333300, 14.6000000, 'AT', '2015-08-10', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2898, 'Maria Lankowitz', 'Maria Lankowitz', 'Lankowitz,Maria Lankowitz,Maria- Lankovic,Marija-Lankovic,ma li ya lan ke wei ci,Мариа- Ланковиц,Мария-Ланковиц,玛丽亚兰科维茨', 47.0500000, 15.0666700, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2899, 'Maria Laach am Jauerling', 'Maria Laach am Jauerling', 'Maria Laach,Maria Laach am Jauerling', 48.3041200, 15.3447200, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2900, 'Mariahof', 'Mariahof', 'Mariahof', 47.1000000, 14.4000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2901, 'Maria Enzersdorf', 'Maria Enzersdorf', 'Maria Enzersdorf,Marija-Ehncersdorf,ma li ya en ce si duo fu,Мария-Энцерсдорф,玛丽亚恩策斯多夫', 48.1000000, 16.2833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2902, 'Maria-Anzbach', 'Maria-Anzbach', '', 48.1901200, 15.9315500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2903, 'Maria Alm am Steinernen Meer', 'Maria Alm am Steinernen Meer', 'Alm', 47.4057900, 12.9012100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2904, 'Marchtrenk', 'Marchtrenk', 'Markhtrenk,ma xi te lun ke,marshtrnk,Мархтренк,مارشترنک,მარხტრენკი,馬希特倫克', 48.1833300, 14.1166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2905, 'Marchegg', 'Marchegg', 'Markheg,ma er xie ge,Мархег,马尔歇格', 48.2621700, 16.9104500, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2906, 'Marbach an der Donau', 'Marbach an der Donau', 'Marbach,Marbach an der Donau,Marbakh-na-Dunae,Марбах-на-Дунае', 48.2166700, 15.1500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2907, 'Mannsdorf an der Donau', 'Mannsdorf an der Donau', 'Mannsdorf', 48.1520000, 16.6650600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2908, 'Manning', 'Manning', 'Manning', 48.0885100, 13.6668200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2909, 'Mannersdorf an der Rabnitz', 'Mannersdorf an der Rabnitz', 'Malistrof,Malištrof,Mannersdorf,Mannersdorf an der Rabnitz,Mannersdorf-na-Rabenic,Repcekethely,Répcekethely,Маннерсдорф-на-Рабениц', 47.4281500, 16.5267800, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2910, 'Mannersdorf am Leithagebirge', 'Mannersdorf am Leithagebirge', 'Mannersdorf,Mannersdorf am Leithagebirge,Mannersdorf-am-Lajtagebirge,lai ta shan lu ma nei er si duo fu,Маннерсдорф-ам-Лайтагебирге,莱塔山麓马内尔斯多夫', 47.9666700, 16.6000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2911, 'Mank', 'Mank', '', 48.1102400, 15.3391500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2912, 'Maissau', 'Maissau', 'Majsau,Vil''khel''msdorf,mai shao,Вильхельмсдорф,Майсау,迈绍', 48.5730000, 15.8300500, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2913, 'Maishofen', 'Maishofen', '', 47.3666700, 12.8000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2914, 'Mailberg', 'Mailberg', '', 48.6737900, 16.1813200, 'AT', '2011-09-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2915, 'Maierdorf', 'Maierdorf', 'Maierdorf', 46.8925000, 15.8497200, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2916, 'Mäder', 'Mader', '', 47.3500000, 9.6166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2917, 'Lutzmannsburg', 'Lutzmannsburg', 'Locsmand,Locsmánd,Lucman,Lucmannsburg,Lucmansburg,Lutzmannsburg,lu ci man si bao,Луцманнсбург,Луцмансбург,卢茨曼斯堡', 47.4637300, 16.6366500, 'AT', '2012-11-05', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2918, 'Lustenau', 'Lustenau', 'Lustenau,lu si te nao,luseutenau,rusutenau,Лустенау,לוסטנאו,لوستن‌آئو,ლუსტენაუ,ルステナウ,盧斯特瑙,루스테나우', 47.4264200, 9.6585100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2919, 'Lunz am See', 'Lunz am See', 'Lunc-am-Ze,Lunz,bin hu lun ci,Лунц-ам-Зе,滨湖伦茨', 47.8612000, 15.0299800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2920, 'Ludmannsdorf', 'Ludmannsdorf', 'Bilcovs,Bilčovs,Ludmannsdorf,lu de man si duo fu,Лудманнсдорф,卢德曼斯多夫', 46.5413900, 14.1342500, 'AT', '2011-09-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2921, 'Ludesch', 'Ludesch', '', 47.2000000, 9.7830600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2922, 'Losenstein', 'Losenstein', 'Losenstein', 47.9242800, 14.4367200, 'AT', '2011-09-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2923, 'Lorüns', 'Loruns', '', 47.1330600, 9.8500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2924, 'Loretto', 'Loretto', 'Lorettom,Lovreta', 47.9155900, 16.5179000, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2925, 'Loosdorf', 'Loosdorf', 'Loosdorf,Losdorf,lu si duo fu,Лоосдорф,Лосдорф,卢斯多夫', 48.2000000, 15.4000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2926, 'Loipersdorf bei Fürstenfeld', 'Loipersdorf bei Fuerstenfeld', 'Loipersdorf,Loipersdorf bei Furstenfeld,Loipersdorf bei Fürstenfeld', 47.0000000, 16.1000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2927, 'Loipersbach im Burgenland', 'Loipersbach im Burgenland', 'Lepesfalva,Loipersbach,Loipersbach im Burgenland,Lojpersbakh (Burgenland),Lépesfalva,Лойперсбах (Бургенланд)', 47.6965600, 16.4791900, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2928, 'Loich', 'Loich', 'Loichgegend', 47.9957800, 15.4016300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2929, 'Lofer', 'Lofer', 'Lofer,Lófer,luo fu,Лофер,洛弗', 47.5847500, 12.6933300, 'AT', '2014-10-15', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2930, 'Lödersdorf', 'Loedersdorf', 'Lodersdorf,Lödersdorf', 46.9586100, 15.9433300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2931, 'Lochau', 'Lochau', 'Lochau am Bodensee,Lokhau,luo hao,Лохау,洛豪', 47.5333300, 9.7500000, 'AT', '2013-11-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2932, 'Litzelsdorf', 'Litzelsdorf', '', 47.2082600, 16.1717000, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2933, 'Litschau', 'Litschau', 'Khjormanns,Lichau,Litschau,li qiao,Личау,Хёрманнс,利乔', 48.9440900, 15.0448300, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2934, 'Linz', 'Linz', 'Gorad Linc,LNZ,Lentia,Linc,Linca,Lincas,Linec,Lints,Linz,lin ci,lincheu,lins,lintsa,lintsi,lnz,lynts,lyntz,lynz,rintsu,Λιντς,Горад Лінц,Линц,Лінц,Լինց,לינץ,لنز,لينتز,لینتس,लिंत्स,ลินซ์,ლინცი,リンツ,林茨,린츠', 48.3063900, 14.2861100, 'AT', '2014-05-02', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2935, 'Lilienfeld', 'Lilienfeld', 'Khintereben,Lilienfel''d,Lilienfeld,Lilienfoeid,Lilienföid,Lilijenfeld,li lin fei er de,Лилиенфелд,Лилиенфельд,Лилијенфелд,Хинтеребен,利林费尔德', 48.0131200, 15.5966400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2936, 'Ligist', 'Ligist', 'Ligist,li ji si te,Лигист,利吉斯特', 46.9938900, 15.2108300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2937, 'Liezen', 'Liezen', 'Licen,Liezen,Lizen,li cen,Лизен,Лицен,利岑', 47.5666700, 14.2333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2938, 'Lienz', 'Lienz', 'Lianz,Lienc,Lienz,Lijenc,Linc,li en ci,liencheu,lientsi,lyynts,lyynz,rientsu,Лиенц,Линц,Лијенц,Лієнц,ליינץ,ليينز,لیینتس,ლიენცი,リエンツ,利恩茨,리엔츠', 46.8289000, 12.7690300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2939, 'Lieboch', 'Lieboch', 'Libokh,Lieboch,li bo he,Либох,利博赫', 46.9741700, 15.3375000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2940, 'Lichtenwörth', 'Lichtenworth', '', 47.8275600, 16.2987300, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2941, 'Lichtenegg', 'Lichtenegg', 'Lichteneg,Lichtenegg', 47.6000000, 16.2000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2942, 'Leutschach', 'Leutschach', 'Lojchakh,Lucane,Lučane,luo yi cha he,Лойчах,洛伊查赫', 46.6672200, 15.4688900, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2943, 'Lermoos', 'Lermoos', 'Leermoos,Lermoos,Lermos,Лермос', 47.4035800, 10.8807000, 'AT', '2013-11-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2944, 'Leopoldsdorf im Marchfelde', 'Leopoldsdorf im Marchfelde', 'Leopol''dsdorf-im-Markhfel''de,Leopoldsdorf,Леопольдсдорф-им-Мархфельде', 48.2226100, 16.6885800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2945, 'Leopoldsdorf', 'Leopoldsdorf', '', 48.1155700, 16.3912600, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2946, 'Leonding', 'Leonding', 'Leonding,lai weng ding,leondingi,li an ding,lywdyng,reondinku,Леондинг,לאונדינג,لئودینگ,لیونڈنگ,ლეონდინგი,レオンディンク,利安定,萊翁丁', 48.2796500, 14.2533000, 'AT', '2014-05-02', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2947, 'Leogang', 'Leogang', 'Leogang,Loigom,lai ao gang,Леоганг,萊奧岡', 47.4390600, 12.7610900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2948, 'Leobersdorf', 'Leobersdorf', 'Leobersdorf,lai ao bo er si duo fu,Леоберсдорф,莱奥伯尔斯多夫', 47.9279600, 16.2165100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2949, 'Leobendorf', 'Leobendorf', '', 48.3833300, 16.3166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2950, 'Leoben', 'Leoben', 'Leoben,Leobenas,Leobene,Leompen,Liupina,lai ao ben,le-oben,leobeni,lywbn,reoben,Λεόμπεν,Леобен,לאובן,لئوبن,ლეობენი,レオーベン,萊奧本,레오벤', 47.3765000, 15.0914400, 'AT', '2012-09-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2951, 'Lenzing', 'Lenzing', '', 47.9732600, 13.6084600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2952, 'Lengenfeld', 'Lengenfeld', '', 48.4718700, 15.5987000, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2953, 'Lendorf', 'Lendorf', '', 46.8352800, 13.4302800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2954, 'Lend', 'Lend', '', 47.2985600, 13.0517600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2955, 'Leitzersdorf', 'Leitzersdorf', '', 48.4191800, 16.2451300, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2956, 'Leithaprodersdorf', 'Leithaprodersdorf', 'Lajtapordany,Lajtapordány', 47.9334800, 16.4791500, 'AT', '2012-11-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2957, 'Leitersdorf im Raabtal', 'Leitersdorf im Raabtal', 'Leitersdorf,Leitersdorf im Raabtal', 46.9418200, 15.9336500, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2958, 'Leisach', 'Leisach', 'Lajzakh,Leisach,lai sa he,Лайзах,莱萨赫', 46.8125000, 12.7486100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2959, 'Leibnitz', 'Leibnitz', 'Lajbnic,Leibnitz  Stiria,Leibnitz  Styria,Lipnica,lai bu ni ci,laipeunicheu,laybnytz,raipunittsu,Лайбниц,Лајбниц,لايبنيتز,ライプニッツ,萊布尼茨,라이프니츠', 46.7816100, 15.5383600, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2960, 'Leiben', 'Leiben', '', 48.2462800, 15.2746000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2961, 'Lechaschau', 'Lechaschau', 'Lechaschau', 47.4880400, 10.7065200, 'AT', '2012-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2962, 'Lech', 'Lech', 'Lekh,Лех', 47.2079700, 10.1418400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2963, 'Laxenburg', 'Laxenburg', 'Laksenburg,Laxemburgo,Laxenbourg,la ke sen bao,Лаксенбург,拉克森堡', 48.0683300, 16.3560700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2964, 'Lavant', 'Lavant', 'Lavant', 46.7988900, 12.8380600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2965, 'Lavamünd', 'Lavamund', 'Labot,Lafamjund,la fa ming de,Лафамюнд,拉法明德', 46.6401900, 14.9473300, 'AT', '2011-09-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2966, 'Lauterach', 'Lauterach', 'QLX', 47.4830600, 9.7330600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2967, 'Laussa', 'Laussa', 'Lausa,Laussa', 47.9500000, 14.4500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2968, 'Lassing', 'Lassing', 'Lassing', 47.5337400, 14.2580800, 'AT', '2017-06-21', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2969, 'Lassee', 'Lassee', '', 48.2247900, 16.8223000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2970, 'Lanzenkirchen', 'Lanzenkirchen', 'Kajnvol''kersdorf,Lancenkirkhen,lan cen ji xing,Кайнволькерсдорф,Ланценкирхен,蘭岑基興', 47.7362100, 16.2198500, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2971, 'Lans', 'Lans', '', 47.2383300, 11.4313900, 'AT', '2016-04-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2972, 'Lannach', 'Lannach', 'Lannach,Lannakh,Ланнах', 46.9461100, 15.3372200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2973, 'Langschlag', 'Langschlag', '', 48.5744800, 14.8845900, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2974, 'Langenzersdorf', 'Langenzersdorf', 'Langencersdorf,Langenzersdorf,lang gen ce si duo fu,Лангенцерсдорф,朗根策斯多夫', 48.3000000, 16.3500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2975, 'Langenwang', 'Langenwang', 'Langenvang,Langenwang,Лангенванг', 47.5666700, 15.6166700, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2976, 'Langenrohr', 'Langenrohr', '', 48.3048900, 16.0103400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2977, 'Langenlois', 'Langenlois', 'Langenlois,Langenlojs,lang gen luo yi si,Лангенлойс,朗根洛伊斯', 48.4666700, 15.6666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2978, 'Langegg bei Graz', 'Langegg bei Graz', 'Langegg,Langegg bei Graz', 47.0500000, 15.6333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2979, 'Langau', 'Langau', 'Khessendorf,Langau,lan gao,Лангау,Хессендорф,兰高', 48.8320700, 15.7156000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2980, 'Lang', 'Lang', 'Lang,Langerberg', 46.8376500, 15.5047100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2981, 'Landl', 'Landl', 'Landl'',lan de er,Ландль,兰德尔', 47.6566600, 14.7318900, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2982, 'Landeck', 'Landeck', '', 47.1398800, 10.5659300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2983, 'Lamprechtshausen', 'Lamprechtshausen', 'Lampehausen,Lamprechtshausen,Lamprekhtsgauzen,Lamprekhtskhauzen,lan pu lei xi ci hao sen,Лампрехтсгаузен,Лампрехтсхаузен,兰普雷希茨豪森', 47.9909800, 12.9548100, 'AT', '2017-07-12', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2984, 'Lambach', 'Lambach', 'Lambakh,Ламбах', 48.0927600, 13.8745300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2985, 'Lafnitz', 'Lafnitz', 'Lafnitz', 47.3666700, 16.0166700, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2986, 'Ladis', 'Ladis', 'Ladis,la di si,Ладис,Ладіс,拉迪斯', 47.0745900, 10.6494900, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2987, 'Ladendorf', 'Ladendorf', 'Ladendorf,la deng duo fu,Ладендорф,拉登多夫', 48.5333300, 16.4833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2988, 'Lackendorf', 'Lackendorf', 'Lakfalva,Lakindrof', 47.5899600, 16.5040400, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2989, 'Lackenbach', 'Lackenbach', 'Lakimpuh,Lakompak', 47.5904200, 16.4653300, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2990, 'Labuch', 'Labuch', 'Labuch,Unter Labuch', 47.0666700, 15.6666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2991, 'Laakirchen', 'Laakirchen', 'Laakircha,Lakirkhen,la ji xing,Лакирхен,拉基兴', 47.9818800, 13.8216600, 'AT', '2011-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2992, 'Laab im Walde', 'Laab im Walde', 'Laab,Lab-im-Val''de,lin qu la bu,Лаб-им-Вальде,林区拉布', 48.1548600, 16.1735900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2993, 'Laa an der Thaya', 'Laa an der Thaya', 'La-an-der-Tajja,Laa,Laa an der Thaya,Laa-an-der-Tajja,ta ya he pan la zhen,Ла-ан-дер-Тайя,Лаа-ан-дер-Тайя,塔亞河畔拉鎮', 48.7166700, 16.3833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2994, 'Kundl', 'Kundl', 'Kundl,Kundl'',kun de er,Кундль,昆德尔', 47.4666700, 11.9833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2995, 'Kumberg', 'Kumberg', 'Kumberg,Кумберг', 47.1642200, 15.5326100, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2996, 'Kulm am Zirbitz', 'Kulm am Zirbitz', 'Kulm,Kulm am Zirbitz', 47.0581400, 14.4870200, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2997, 'Kukmirn', 'Kukmirn', '', 47.0754400, 16.2103300, 'AT', '2011-09-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2998, 'Kufstein', 'Kufstein', 'Kuffstein,Kufshhajn,Kufshtajn,Kufsstein,Kufstein,Kufsteinas,Kufstoa,Kufšteinas,ku fu shi tai yin,kufushutain,kupeusyutain,qwpstyyn,Куфштайн,Куфштајн,Куфщайн,קופשטיין,کوف‌اشتاین,კუფშტაინი,クーフシュタイン,库夫施泰因,쿠프슈타인', 47.5833300, 12.1666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(2999, 'Kuchl', 'Kuchl', 'Kuche,Kuchl,Kukhl'',ku he er,Кухль,庫赫爾', 47.6264700, 13.1448000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3000, 'Krusdorf', 'Krusdorf', 'Krusdorf', 46.8394400, 15.8608300, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3001, 'Krumegg', 'Krumegg', '', 47.0211100, 15.6313900, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3002, 'Krumbach', 'Krumbach', '', 47.4830600, 9.9358300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3003, 'Krumau am Kamp', 'Krumau am Kamp', 'Krumau,Krumau am Kamp', 48.5887900, 15.4491400, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3004, 'Krottendorf', 'Krottendorf', '', 47.2000000, 15.6333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3005, 'Krispl', 'Krispl', '', 47.7166700, 13.1833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3006, 'Krieglach', 'Krieglach', 'Alpl,Kriaglach,Kriaglåch,Krieglach,Kriglakh,ke li ge la he,Криглах,克里格拉赫', 47.5472800, 15.5624800, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3007, 'Bad Kreuzen', 'Bad Kreuzen', 'Bad-Krojcen,ba te ke luo yi cen,Бад-Кройцен,巴特克罗伊岑', 48.2673700, 14.8064800, 'AT', '2011-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3008, 'Krensdorf', 'Krensdorf', 'Krenistof,Kreništof,Krensdorf,Tormafalu,Кренсдорф', 47.7855200, 16.4149500, 'AT', '2012-11-05', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3009, 'Kremsmünster', 'Kremsmunster', 'Cremifanum,Kremsmjunster,Kremsmunster,Kremsmünster,ke lei mu si ming si te,Кремсмюнстер,克雷姆斯明斯特', 48.0529000, 14.1291900, 'AT', '2011-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3010, 'Krems an der Donau', 'Krems an der Donau', 'Krems,Krems an der Donau,Krems-na-Dunae,qrms,Кремс-на-Дунае,קרמס', 48.4092100, 15.6141500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3011, 'Kraubath an der Mur', 'Kraubath an der Mur', 'Kraubath,Kraubath an der Mur', 47.3000000, 14.9333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3012, 'Kramsach', 'Kramsach', 'Kramsach,Kramzakh,ke la mu sa he,Крамзах,克拉姆萨赫', 47.4431200, 11.8754500, 'AT', '2013-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3013, 'Krakauschatten', 'Krakauschatten', 'Krakauschatten', 47.1833300, 13.9666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3014, 'Krakauhintermühlen', 'Krakauhintermuehlen', 'Krakauhintermuhlen,Krakauhintermühlen', 47.1833300, 13.9833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3015, 'Krakaudorf', 'Krakaudorf', 'Krakaudorf', 47.1813100, 14.0206100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3016, 'Köttmannsdorf', 'Kottmannsdorf', 'Kjottmannsdorf,Koettmannsdorf,Kotmara vas,Kottmannsdorf,Köttmannsdorf,ke te man si duo fu,Кёттманнсдорф,科特曼斯多夫', 46.5613900, 14.2338900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3017, 'Kottingbrunn', 'Kottingbrunn', 'Kottingbrunn,ke ting bu lun,kwtnjbrn,Коттингбрунн,كوتنجبرن,科廷布伦', 47.9509600, 16.2271500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3018, 'Köstendorf', 'Kostendorf', 'Gross Kostendorf,Gross Köstendorf,Kestendorf,Kjostendorf,Kostendorf,Köstendorf,ke shi teng duo fu,Кестендорф,Кёстендорф,克施滕多夫', 47.9500000, 13.2000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3019, 'Kössen', 'Kossen', 'Kessen,Kessn,Kjossen,ke sen,kwsn,Кессен,Кёссен,کوسن,克森', 47.6699000, 12.4054500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3020, 'Korneuburg', 'Korneuburg', 'Korneubourg,Korneuburg,Kornojburg,ke er xin bao,krnwybwrg,Корнойбург,Корнојбург,کرنویبورگ,კორნოიბურგი,科爾新堡', 48.3500000, 16.3333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3021, 'Koppl', 'Koppl', 'Kopl'',Koppl'',ke pu er,Копль,Коппль,科普尔', 47.8080800, 13.1556100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3022, 'Königstetten', 'Konigstetten', '', 48.3019800, 16.1449200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3023, 'Königsdorf', 'Konigsdorf', '', 47.0000000, 16.1666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3024, 'Kolsassberg', 'Kolsassberg', '', 47.2815000, 11.6528900, 'AT', '2017-03-14', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3025, 'Kohlschwarz', 'Kohlschwarz', 'Kohlschwarz', 47.1166700, 15.1166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3026, 'Kohlberg', 'Kohlberg', 'Kohlberg', 46.9000000, 15.7833300, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3027, 'Kohfidisch', 'Kohfidisch', 'Gyepufuezes,Gyepufüzes,Kofidish,Kohfedish,Kohfidisch,Кофидиш', 47.1747200, 16.3570100, 'AT', '2012-11-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3028, 'Köflach', 'Koeflach', 'Gorad Kjoflakh,Keflakh,Kjoflakh,Koflach,Köflach,ke fu la he,kwflakh,Горад Кёфлах,Кефлах,Кёфлах,کوفلاخ,克夫拉赫', 47.0666700, 15.0833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3029, 'Koblach', 'Koblach', '', 47.3330600, 9.6000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3030, 'Kobersdorf', 'Kobersdorf', 'Kabold,Kobersdorf,Коберсдорф', 47.5957200, 16.3917300, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3031, 'Kobenz', 'Kobenz', 'Kobenz', 47.2500000, 14.8500000, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3032, 'Knittelfeld', 'Knittelfeld', 'Knitelfeld,Knitelfelnt,Knittel''fel''d,Knittelfeld,ke ni te er fei er de,keunitelpelteu,kunitteruferuto,Κνίτελφελντ,Кнителфелд,Книттельфельд,کنیتل‌فلد,კნიტელფელდი,クニッテルフェルト,克尼特爾費爾德,크니텔펠트', 47.2166700, 14.8166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3033, 'Klosterneuburg', 'Klosterneuburg', 'Gorad Klostehrnojburg,Klosterneuberg,Klosterneuburg,Klosternoiburgas,Klosternojburg,Vajdlingbakh-und-Shajblinshtajn,ke luo si te xin bao,klwstrnwybwrg,kurosutanoiburuku,Вайдлингбах-унд-Шайблинштайн,Горад Клостэрнойбург,Клостернойбург,Клостернојбург,کلوسترنویبورگ,کوسٹرنیوبرگ,კლოსტერნოიბურგი,クロスターノイブルク,克洛斯特新堡', 48.3052100, 16.3252200, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3034, 'Klösterle', 'Klosterle', '', 47.1333300, 10.0833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3035, 'Kloster', 'Kloster', 'Kloster,Klosterwinkel', 46.8833300, 15.0833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3036, 'Klöch', 'Kloech', 'Kloch,Klöch', 46.7647200, 15.9655600, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3037, 'Klingenbach', 'Klingenbach', 'Kelenpatak,Kelénpatak,Klingenbach,Klingenbakh,Klinpuh,Клингенбах', 47.7520200, 16.5406900, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3038, 'Kleinzell im Mühlkreis', 'Kleinzell im Muehlkreis', 'Klajncell'',Klajncell''-im-Mjul''krajs,Kleinzel,Kleinzell,Kleinzell im Muhlkreis,Kleinzell im Mühlkreis,mi er de qu xiao ce er,Клайнцелль,Клайнцелль-им-Мюлькрайс,米尔地区小策尔', 48.4558500, 13.9919500, 'AT', '2011-07-11', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3039, 'Kleinzell', 'Kleinzell', 'Klajncell'',Klazoe,Klazö,xiao ce er,Клайнцелль,小策尔', 47.9799300, 15.7362000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3040, 'Kleinsölk', 'Kleinsoelk', 'Kleinsolk,Kleinsölk,Vorderwald', 47.3944400, 13.9394400, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3041, 'Klein-Pöchlarn', 'Klein-Poechlarn', '', 48.2166700, 15.2166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3042, 'Kleinmürbisch', 'Kleinmurbisch', 'Felsomedves,Felsőmedves', 47.0329900, 16.3244800, 'AT', '2013-04-02', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3043, 'Kleinlobming', 'Kleinlobming', 'Kleinlobming', 47.1495400, 14.8487500, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3044, 'Kleinkirchheim', 'Kleinkirchheim', 'Bad Klajnkirkhgajm,Bad Kleinkirchheim,Kleinkirchheim,Бад Клайнкирхгайм', 46.8227800, 13.7922200, 'AT', '2014-05-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3045, 'Klausen-Leopoldsdorf', 'Klausen-Leopoldsdorf', 'Klausenleopoldsdorf,Klauzen-Leopol''dsdorf,ke lao sen-lai ao bo er de si duo fu,Клаузен-Леопольдсдорф,克劳森-莱奥波尔德斯多夫', 48.0877100, 16.0168600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3046, 'Klaus', 'Klaus', '', 47.3091300, 9.6467800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3047, 'Klagenfurt am Wörthersee', 'Klagenfurt am Woerthersee', 'Celovec,Clagenfurtum,KLU,Klagenfurt,Klagenfurte,Klāgenfurte,ke la gen fu,kuragenfuruto,qlgnpwrt,Клагенфурт,קלגנפורט,クラーゲンフルト,克拉根福', 46.6247200, 14.3052800, 'AT', '2012-02-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3048, 'Kitzeck im Sausal', 'Kitzeck im Sausal', 'Kitzeck,Kitzeck im Sausal', 46.7807200, 15.4538400, 'AT', '2017-06-21', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3049, 'Kitzbühel', 'Kitzbuhel', 'Kicbil,Kicbiuhelis,Kicbjuehl'',Kicbjuel,Kicbjuel'',Kitzbichl,Kitzbuehel,Kitzbühel,ji ci bi e er,kicheubwil,kittsubyuru,ktsbwyl,qyzbyl,Кицбил,Кицбюел,Кицбюэль,Кіцбюель,קיצביל,كتسبويل,キッツビュール,基茨比厄爾,키츠뷜', 47.4463700, 12.3921500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3050, 'Kittsee', 'Kittsee', 'Gijeca,Kittsee,Kitzee,Koepcseny,Köpcsény,kittoze,Китзее,キットゼー', 48.0925000, 17.0638900, 'AT', '2012-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3051, 'Kirnberg an der Mank', 'Kirnberg an der Mank', 'Kirnberg', 48.0724600, 15.3223200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3052, 'Kirchstetten', 'Kirchstetten', '', 48.1833300, 15.8166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3053, 'Kirchschlag in der Buckligen Welt', 'Kirchschlag in der Buckligen Welt', 'Kirchschlag in da Buckling Woeid,Kirchschlag in der Buckligen Welt,Kirchschlåg in da Buckling Wöid,Kirkhshlag,Kirkhshlag-in-der-Bukligen-Vel''t,Kirschlag,bu ke li gen wei er te de qu ji xi shi la ge,Кирхшлаг,Кирхшлаг-ин-дер-Буклиген-Вельт,布克利根韦尔特地区基希施拉格', 47.5000000, 16.2833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3054, 'Kirchschlag bei Linz', 'Kirchschlag bei Linz', 'Kirchschlag,Kirchschlag bei Linz', 48.4114900, 14.2765600, 'AT', '2011-12-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3055, 'Kirchschlag', 'Kirchschlag', '', 48.3934500, 15.2228500, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3056, 'Kirchdorf in Tirol', 'Kirchdorf in Tirol', 'Kirchdorf,Kirchdorf en Tyrol,Kirchdorf in Tirol,Kirkhdorf,Kirkhdorf (Tirol''),Kirkhdorf-in-Tirol'',di luo er zhou ji xi duo fu,Кирхдорф,Кирхдорф (Тироль),Кірхдорф-ін-Тіроль,کرخڈورف ان ٹیرول,蒂罗尔州基希多夫', 47.5562600, 12.4451100, 'AT', '2016-02-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3057, 'Kirchberg in Tirol', 'Kirchberg in Tirol', 'Kirchberg,Kirkhberg (Tirol''),Кирхберг (Тироль)', 47.4453900, 12.3160200, 'AT', '2016-02-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3058, 'Kirchberg an der Raab', 'Kirchberg an der Raab', 'Kirchberg,Kirchberg an der Raab,Kirkhberg-an-der-Rab,la bu he pan ji xi bei ge,Кирхберг-ан-дер-Раб,拉布河畔基希贝格', 46.9858300, 15.7669400, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3059, 'Kirchberg an der Pielach', 'Kirchberg an der Pielach', 'Kirchberg,Kirkhberg-an-der-Pilakh,Kirkhberg-na-Pilakhe,Pilakhtagy Kirkhberg,pi la he he pan ji xi bei ge,Кирхберг-ан-дер-Пилах,Кирхберг-на-Пилахе,Пилахтағы Кирхберг,皮拉赫河畔基希贝格', 48.0269000, 15.4287500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3060, 'Kirchberg am Wechsel', 'Kirchberg am Wechsel', 'Kirchberg,Kirchberg am Wechsel,Kirkhberg-am-Vekzel'',Kirkhberg-na-Veksele,wei xi se er shan lu ji xi bei ge,Кирхберг-ам-Векзель,Кирхберг-на-Векселе,韦希瑟尔山麓基希贝格', 47.6073800, 15.9910300, 'AT', '2011-09-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3061, 'Kirchberg am Walde', 'Kirchberg am Walde', 'Kirchberg,Kirchberg am Walde,Kirkhberg-am-Val''de,Kirkhberg-na-Val''de,lin qu ji xi bei ge,Кирхберг-ам-Вальде,Кирхберг-на-Вальде,林区基希贝格', 48.7247700, 15.0882600, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3062, 'Kirchberg am Wagram', 'Kirchberg am Wagram', 'Kirchberg,Kirchberg am Wagram,Kirkhberg-am-Vagram,Kirkhberg-na-Vagrame,Vagramdagy Kirkhberg,wa ge la mu shan lu ji xi bei ge,Ваграмдағы Кирхберг,Кирхберг-ам-Ваграм,Кирхберг-на-Ваграме,瓦格拉姆山麓基希贝格', 48.4318200, 15.8969200, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3063, 'Kirchbach in Steiermark', 'Kirchbach in Steiermark', 'Kirchbach,Kirchbach in Steiermark', 46.9316700, 15.6619400, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3064, 'Kirchbach', 'Kirchbach', 'Kirchbach,Kirchbach im Gailtal,Kirkhbakh,Кирхбах', 46.6416000, 13.1845400, 'AT', '2012-12-13', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3065, 'Kindberg', 'Kindberg', 'Kindberg,jin de bei ge,Киндберг,金德贝格', 47.5000000, 15.4500000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3066, 'Kilb', 'Kilb', '', 48.1010100, 15.4085000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3067, 'Keutschach am See', 'Keutschach am See', 'Hodise,Hodiše,Keutschach,Keutschach am See,Kojchakh-am-Ze,Kojtchakh-am-Zee,bin hu ke yi cha he,Койтчах-ам-Зее,Койчах-ам-Зе,滨湖科伊查赫', 46.5930600, 14.1888900, 'AT', '2016-02-19', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3068, 'Kennelbach', 'Kennelbach', '', 47.4830600, 9.7666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3069, 'Kemeten', 'Kemeten', '', 47.2485900, 16.1521300, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3070, 'Kematen in Tirol', 'Kematen in Tirol', 'Kematen,Kematen en Tyrol,Kematen in Tirol,Kematen-in-Tirol'',di luo er zhou ke ma teng,Кематен,Кематен-ин-Тироль,Кематен-ін-Тіроль,کیماتن ان ٹیرول,蒂罗尔州克马滕', 47.2500000, 11.2666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3071, 'Kematen an der Ybbs', 'Kematen an der Ybbs', '', 48.0254100, 14.7646800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3072, 'Kautzen', 'Kautzen', '', 48.9300000, 15.2393200, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3073, 'Kauns', 'Kauns', 'Kauns', 47.0782200, 10.6921900, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3074, 'Kaumberg', 'Kaumberg', '', 48.0241500, 15.8984200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3075, 'Katzelsdorf', 'Katzelsdorf', 'Katcel''sdorf,Katzelsdorf an der Leitha,Macskasd,Macskásd,ka ce er si duo fu,Катцельсдорф,卡策尔斯多夫', 47.7805500, 16.2698500, 'AT', '2012-11-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3076, 'Kasten bei Böheimkirchen', 'Kasten bei Boheimkirchen', '', 48.1532000, 15.7794600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3077, 'Kartitsch', 'Kartitsch', 'Boden,Kartich,Kartitsch,ka er di qi,Картич,Картіч,کارٹیٹش,卡尔蒂奇', 46.7288900, 12.5008300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3078, 'Karrösten', 'Karrosten', 'Karresten,Karrjosten,ka lei shi teng,Каррестен,Каррёстен,卡勒施滕', 47.2254000, 10.7656100, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3079, 'Karres', 'Karres', '', 47.2166700, 10.7833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3080, 'Karlstetten', 'Karlstetten', '', 48.2592000, 15.5654400, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3081, 'Kaprun', 'Kaprun', 'Kaprun,ka pu lun,Капрун,卡普伦', 47.2723900, 12.7598500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3082, 'Kappl', 'Kappl', 'Kappl', 47.0666700, 10.3833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3083, 'Kappel am Krappfeld', 'Kappel am Krappfeld', 'Kappel,Kappel am Krappfeld', 46.8386100, 14.4863900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3084, 'Kapfenstein', 'Kapfenstein', 'Kapfenstein', 46.8861100, 15.9716700, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3085, 'Kapfenberg', 'Kapfenberg', 'Kapfenberg,Kapfenbergas,ka pu fen bei ge,kapfnbrg,qpnbrg,Капфенберг,קפנברג,کاپفنبرگ,კაპფენბერგი,卡普芬貝格', 47.4445800, 15.2933100, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3086, 'Kapelln', 'Kapelln', '', 48.2581700, 15.7573100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3087, 'Kapellen', 'Kapellen', '', 47.6478400, 15.6286300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3088, 'Kammern im Liesingtal', 'Kammern im Liesingtal', 'Kammern im Liesingtal,Kammern-im-Lizingtal'',li xin gu de ka mo en,Каммерн-им-Лизингталь,利辛谷地卡默恩', 47.3924500, 14.9040700, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3089, 'Kalwang', 'Kalwang', 'Kallwang,Kalwang', 47.4267800, 14.7544200, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3090, 'Kaltenleutgeben', 'Kaltenleutgeben', 'Kal''tenlojtgeben,ka er teng luo yi te ge ben,Кальтенлойтгебен,卡尔滕洛伊特格本', 48.1164600, 16.1995600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3091, 'Kaltenbach', 'Kaltenbach', '', 47.2833300, 11.8666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3092, 'Kalsdorf bei Graz', 'Kalsdorf bei Graz', 'Kal''sdorf (Grac),Kal''sdorf-baj-Grac,Kalsdorf,Kalsdorf bei Graz,ge la ci fu jin ka er si duo fu,Кальсдорф (Грац),Кальсдорф-бай-Грац,格拉茨附近卡尔斯多夫', 46.9652800, 15.4802800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3093, 'Kaisersdorf', 'Kaisersdorf', 'Csaszarfalu,Császárfalu,Kaisersdorf,Kajzersdorf,Kalistrof,Kalištrof,Кайзерсдорф', 47.5374100, 16.3919800, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3094, 'Kaindorf an der Sulm', 'Kaindorf an der Sulm', 'Kaindorf,Kajndorf-an-der-Zul''m,Кайндорф-ан-дер-Зульм', 46.7924800, 15.5387900, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3095, 'Kaindorf', 'Kaindorf', 'Kaindorf,Kaindorf bei Hartberg', 47.2253700, 15.9112500, 'AT', '2017-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3096, 'Kainach bei Voitsberg', 'Kainach bei Voitsberg', 'Kainach,Kainach bei Voitsberg', 47.1363700, 15.0953000, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3097, 'Kaibing', 'Kaibing', 'Kaibing', 47.2000000, 15.8333300, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3098, 'Jungholz', 'Jungholz', 'Gioun''nkcholts,Junggol''c,Jungholzi vald,Jungkhol''c,rong huo er ci,Γιούνγκχολτς,Юнггольц,Юнгхольц,容霍尔茨', 47.5740900, 10.4472300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3099, 'Judenburg', 'Judenburg', 'Judenburg,you deng bao,yudenbuleukeu,yudenburuku,ywdnbwrg,ywdnbwrgh,Јуденбург,Юденбург,יודנבורג,يودنبورغ,ユーデンブルク,尤登堡,유덴부르크', 47.1666700, 14.6666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3100, 'Jois', 'Jois', 'Nyulas', 47.9616500, 16.7960400, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3101, 'Johnsbach', 'Johnsbach', 'Johnsbach', 47.5333300, 14.5833300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3102, 'Jochberg', 'Jochberg', 'Jochberg,Khollersbakh,Холлерсбах', 47.3792000, 12.4180700, 'AT', '2012-04-21', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3103, 'Jerzens', 'Jerzens', '', 47.1512000, 10.7468600, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3104, 'Jennersdorf', 'Jennersdorf', 'Enersdorf,Ennersdorf,Gyanafalva,Jenersdorf,Jennersdorf,ye nei er si duo fu,Єннерсдорф,Јенерсдорф,Енерсдорф,Еннерсдорф,Йеннерсдорф,耶内尔斯多夫', 46.9384800, 16.1415800, 'AT', '2012-02-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3105, 'Jenbach', 'Jenbach', 'Enbakh,Jenbakh,yan ba he,Єнбах,Енбах,Йенбах,延巴赫', 47.3917300, 11.7724500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3106, 'Jedenspeigen', 'Jedenspeigen', '', 48.4980700, 16.8722500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3107, 'Japons', 'Japons', '', 48.7925000, 15.5683100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3108, 'Jaidhof', 'Jaidhof', '', 48.5333300, 15.4833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3109, 'Jagerberg', 'Jagerberg', '', 46.8536100, 15.7380600, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3110, 'Jabing', 'Jabing', '', 47.2388000, 16.2765900, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3111, 'Ischgl', 'Ischgl', 'Isglis,Ishgl'',Ishgul,Išglis,XOI,aschgl,yi shi ge er,Ішгль,Ишгль,Ишгъл,אישגל,اسچگل,伊施格尔', 47.0125700, 10.2917900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3112, 'Irschen', 'Irschen', 'Irschen,Irshen,yi er shen,Иршен,伊尔申', 46.7569400, 13.0252800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3113, 'Irdning', 'Irdning', 'Irdning,yi er de ning,Ирднинг,伊尔德宁', 47.5052900, 14.1015500, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3114, 'Inzing', 'Inzing', '', 47.2737000, 11.1975100, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3115, 'Inzenhof', 'Inzenhof', '', 47.0166700, 16.3166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3116, 'Innsbruck', 'Innsbruck', 'Gorad Insbruk,INN,Innsbruck,Innschbruck,Insbruc,Insbruk,Insbruka,Insbrukas,Insmprouk,Inzbruk,Pons Aeni,ansbrwk,anzbrk,aynsbrwk,insabruka,inseubeulukeu,insuburukku,xin s brukh,yin si bei lu ke,yin si bu lu ke,İnnsbruck,İnsbruk,Ίνσμπρουκ,Інсбрук,Горад Інсбрук,Инзбрук,Инсбрук,Ինսբրուք,אינסברוק,إنسبروك,انزبرک,اینسبروک,इन्सब्रुक,ইন্সব্রুক,อินส์บรุค,ინსბრუკი,インスブルック,因斯孛鲁克,因斯布鲁克,인스브루크', 47.2626600, 11.3945400, 'AT', '2014-05-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3117, 'Innervillgraten', 'Innervillgraten', 'Innerfil''graten,Innerfill''graten,Innervillgraten,nei wei er ge la teng,Іннерфілльгратен,Иннерфильгратен,انرولگراٹن,内维尔格拉滕', 46.8119400, 12.3747200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3118, 'Innerschwand', 'Innerschwand', 'Innerschwand', 47.8333300, 13.4000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3119, 'Innerbraz', 'Innerbraz', '', 47.1500000, 9.9166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3120, 'Imsterberg', 'Imsterberg', '', 47.2051700, 10.6960500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3121, 'Imst', 'Imst', 'Imscht,Imst,imusuto,yi mu si te,Імст,Имст,イムスト,伊姆斯特', 47.2450400, 10.7397400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3122, 'Ilz', 'Ilz', 'Il''c,Ilz,Ильц', 47.0864900, 15.9267600, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3123, 'Illmitz', 'Illmitz', 'Il''mic,Ill''mic,Illmic,UEmitz,yi er mi ci,Ümitz,Ілльміц,Ильмиц,伊尔米茨', 47.7614800, 16.8002400, 'AT', '2012-10-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3124, 'Hüttschlag', 'Huttschlag', '', 47.1763500, 13.2323900, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3125, 'Hüttenberg', 'Huttenberg', 'Huttenberg,Hüttenberg', 46.9413900, 14.5500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3126, 'Hüttau', 'Huttau', 'Gjuttau,Hittau,Khjuttau,xu tao,Гюттау,Хюттау,许陶', 47.4161000, 13.3077500, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3127, 'Hürm', 'Hurm', '', 48.1560100, 15.4126200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3128, 'Hundsheim', 'Hundsheim', '', 48.1174900, 16.9358100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3129, 'Hörsching', 'Horsching', 'Hoersching,Khjorshing,he er xing,Хёршинг,赫爾興', 48.2262700, 14.1778600, 'AT', '2011-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3130, 'Hornstein', 'Hornstein', 'Hornstein,Khornshtajn,Szarvko,Szarvkő,Voristan,Vorištan,Хорнштайн', 47.8804900, 16.4444700, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3131, 'Horn', 'Horn', 'Horn', 48.6627400, 15.6566300, 'AT', '2016-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3132, 'Horitschon', 'Horitschon', 'Haracsony,Haracun,Haračun', 47.5872900, 16.5469600, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3133, 'Hörbranz', 'Horbranz', 'Gerbranc,Horbranz,Hörbranz,Kh''orbranc,Khjorbranc,Khjornbranc,Kirchdorf,he er bu lan ci,Гербранц,Хьорбранц,Хёрбранц,Хёрнбранц,ہوربرانز,赫爾布蘭茨', 47.5500000, 9.7500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3134, 'Hopfgarten im Brixental', 'Hopfgarten im Brixental', 'Gopfgarten-im-Briksental'',Hopfgarten,Hopfgarten Markt,Hopfgarten im Brixental,Hopfgarten in Nordtirol,Khopfgarten-im-Briksental'',bu li ke sen gu de huo pu fu jia er teng,Гопфгартен-ім-Бріксенталь,Хопфгартен-им-Бриксенталь,布里克森谷地霍普夫加尔滕', 47.4500000, 12.1666700, 'AT', '2014-05-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3135, 'Hopfgarten in Defereggen', 'Hopfgarten in Defereggen', 'Gopfgarten-in-Defereggen,Hopfgarten,Hopfgarten in Defereggen,Khopfgarten-in-Defereggen,de fu lei gen shan lu huo pu fu jia er teng,Гопфгартен-ін-Деферегген,Хопфгартен-ин-Деферегген,德弗雷根山麓霍普夫加尔滕', 46.9191700, 12.5363900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3136, 'Holzhausen', 'Holzhausen', '', 48.2229600, 14.0968300, 'AT', '2013-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3137, 'Hollersbach im Pinzgau', 'Hollersbach im Pinzgau', 'Hollersbach,Hollersbach im Pinzgau', 47.2765800, 12.4232600, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3138, 'Hollenthon', 'Hollenthon', '', 47.5893800, 16.2613100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3139, 'Hollenstein an der Ybbs', 'Hollenstein an der Ybbs', 'Grosshollenstein,Hollenstein,Hollenstein an der Ybbs,Khollenshtajn-an-der-Ibs,Khollenshtajndagy Ibse,yi bu si he pan huo lun shi tai yin,Холленштайн-ан-дер-Ибс,Холленштайндағы Ибсе,伊布斯河畔霍伦施泰因', 47.8000000, 14.7666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3140, 'Hollenegg', 'Hollenegg', '', 46.7914700, 15.2134500, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3141, 'Hollabrunn', 'Hollabrunn', 'Hollabrunn,Kholabrun,Khollabrun,Khollabrunn,Oberhollabrunn,Vizel''sfel''d,holabruni,huo la bu lun,hwlabrwn,Визельсфельд,Холабрун,Холлабрун,Холлабрунн,هولابرون,ჰოლაბრუნი,霍拉布倫', 48.5500000, 16.0833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3142, 'Hohenweiler', 'Hohenweiler', '', 47.5833300, 9.7833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3143, 'Hohenthurn', 'Hohenthurn', 'Khoehnturn,Straja vas,huo heng tu en,Хоэнтурн,霍亨图恩', 46.5583300, 13.6677800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3144, 'Hohentauern', 'Hohentauern', 'Hohentauern,Khoehntauehrn,huo heng tao en,hwhntawrn,Хоэнтауэрн,هوهنتاورن,霍亨陶恩', 47.4333300, 14.4833300, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3145, 'Hohenruppersdorf', 'Hohenruppersdorf', '', 48.4643900, 16.6524400, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3146, 'Hohenems', 'Hohenems', 'Gogenems,HOH,Hohenems,Khoehnems,Khoenems,ho-enemseu,hoenemsi,hoenemusu,huo en ai mu si,hwhnms,Гогенемс,Хоенемс,Хоэнемс,هوهنمس,ჰოენემსი,ホーエネムス,霍恩埃姆斯,호에넴스', 47.3666700, 9.6830600, 'AT', '2013-05-09', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3147, 'Hoheneich', 'Hoheneich', '', 48.7719500, 15.0285700, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3148, 'Hohenberg', 'Hohenberg', '', 47.9067900, 15.6199800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3149, 'Hohenau an der Raab', 'Hohenau an der Raab', 'Hohenau,Hohenau an der Raab', 47.3000000, 15.5500000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3150, 'Hofstätten an der Raab', 'Hofstatten an der Raab', 'Hofstatten,Hofstatten an der Raab,Hofstätten,Hofstätten an der Raab', 47.0666700, 15.7333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3151, 'Höfen', 'Hofen', '', 47.4666700, 10.6833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3152, 'Hof bei Straden', 'Hof bei Straden', 'Hof,Hof bei Straden', 46.8000000, 15.9333300, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3153, 'Hof bei Salzburg', 'Hof bei Salzburg', 'Hof,Khof (Zal''cburg),Хоф (Зальцбург)', 47.8192900, 13.2148800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3154, 'Hof am Leithaberge', 'Hof am Leithaberge', 'Hof,Hof am Leithaberge,Hof am Leithagebirge', 47.9500000, 16.5833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3155, 'Hochwolkersdorf', 'Hochwolkersdorf', '', 47.6612700, 16.2807200, 'AT', '2017-06-05', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3156, 'Höchst', 'Hochst', '', 47.4593400, 9.6405000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3157, 'Hochfilzen', 'Hochfilzen', 'Gokhfil''cen,Hochfilzen,Hohfilcene,Khokhfil''cen,Khokhfilcen,huo he fei er cen,Гохфільцен,Хохфилцен,Хохфильцен,霍赫菲尔岑', 47.4666700, 12.6166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3158, 'Hitzendorf', 'Hitzendorf', '', 47.0333300, 15.3000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3159, 'Hirtenberg', 'Hirtenberg', '', 47.9309500, 16.1790800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3160, 'Hirschbach', 'Hirschbach', '', 48.7432900, 15.1252100, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3161, 'Hirnsdorf', 'Hirnsdorf', 'Hirnsdorf', 47.1916700, 15.8286800, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3162, 'Hirm', 'Hirm', 'Felszerfalva,Félszerfalva,Hirma', 47.7865200, 16.4546000, 'AT', '2012-10-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3163, 'Hippach', 'Hippach', 'Hippach,Khippakh,Хиппах', 47.2043500, 11.8652300, 'AT', '2012-02-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3164, 'Hintersee', 'Hintersee', 'Feichten,Hintersee', 47.7000000, 13.2833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3165, 'Hinterbrühl', 'Hinterbruehl', 'Khinterbrjul'',hou bu lu er,Хинтербрюль,后布吕尔', 48.0861100, 16.2480900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3166, 'Himmelberg', 'Himmelberg', 'Himmelberg,Khimmel''berg,xi mo er bei ge,Химмельберг,锡默尔贝格', 46.7566700, 14.0305600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3167, 'Himberg', 'Himberg', '', 48.0833300, 16.4333300, 'AT', '2017-06-16', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3168, 'Hieflau', 'Hieflau', 'Hieflau,Khiflau,xi fu lao,Хифлау,希夫劳', 47.6063900, 14.7450300, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3169, 'Heugraben', 'Heugraben', 'Heugraben,Khojgraben,Zarnovica,Žarnovica,Хойграбен', 47.1178300, 16.1904100, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3170, 'Herzogsdorf', 'Herzogsdorf', 'Herzogsdorf,Khercogsdorf,Херцогсдорф', 48.4301100, 14.1128000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3171, 'Herzogenburg', 'Herzogenburg', 'Khercogenburg,Vilandstal'',hei cuo gen bao,Виландсталь,Херцогенбург,黑措根堡', 48.2813700, 15.6943100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3172, 'Herrnbaumgarten', 'Herrnbaumgarten', '', 48.6960600, 16.6828300, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3173, 'Hernstein', 'Hernstein', 'Khernshtajn,hei en si tai yin,Хернштайн,黑恩斯泰因', 47.8946500, 16.1056100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3174, 'Hermagor', 'Hermagor', '', 46.6272200, 13.3672200, 'AT', '2014-05-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3175, 'Hennersdorf', 'Hennersdorf', '', 48.1117300, 16.3631100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3176, 'Henndorf am Wallersee', 'Henndorf am Wallersee', 'Genndorf-am-Vallerze,Heedorf am Wallersee,Henndorf,Henndorf am Wallersee,Khenndorf-am-Vallerze,Khenndorf-am-Vallerzee,Генндорф-ам-Валлерзе,Хенндорф-ам-Валлерзе,Хенндорф-ам-Валлерзее', 47.9000000, 13.1833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3177, 'Hengsberg', 'Hengsberg', 'Hengsberg,Khengsberg,heng si bei ge,Хенгсберг,亨斯贝格', 46.8666700, 15.4333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3178, 'Hellmonsödt', 'Hellmonsodt', 'Hellmonsodt,Hellmonsödt,Khel''monzjodt,hei er meng se te,Хельмонзёдт,黑尔蒙瑟特', 48.4333300, 14.3000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3179, 'Heiterwang', 'Heiterwang', 'Heiterwang', 47.4500000, 10.7500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3180, 'Heiligenkreuz im Lafnitztal', 'Heiligenkreuz im Lafnitztal', 'Hagensdorf im Burgenland,Heiligenkreuz,Heiligenkreuz im Lafnitztal,Khajligenkrojc,Khajligenkrojc-im-Lafnictal'',Rabakeresztur,Rábakeresztúr,la fu ni ci gu de hai li gen ke luo yi ci,Хайлигенкройц,Хайлигенкройц-им-Лафницталь,拉夫尼茨谷地海利根克罗伊茨', 46.9891700, 16.2608300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3181, 'Heiligenkreuz am Waasen', 'Heiligenkreuz am Waasen', 'Heiligenkreuz,Heiligenkreuz am Waasen', 46.9558300, 15.5880600, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3182, 'Heiligenkreuz', 'Heiligenkreuz', 'Khajligenkrojc,Хайлигенкройц', 48.0555900, 16.1249300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3183, 'Heiligenbrunn', 'Heiligenbrunn', 'Khajligenbrun,Khajligenbrunn,Szentkut,Szentkút,hai li gen bu lun,Хайлигенбрун,Хайлигенбрунн,海利根布伦', 47.0270500, 16.4168800, 'AT', '2013-04-02', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3184, 'Heiligenblut', 'Heiligenblut', 'Heiligenblut,Heiligenblut am Grossglockner,Heiligenblut am Großglockner,Khajligenbljut,Khajligenblut,Sveta Kri,hai li gen bu lu te,Хайлигенблут,Хайлигенблют,Хайліґенблют,ہیلیگنبلٹ,海利根布卢特', 47.0397900, 12.8434500, 'AT', '2013-09-14', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3185, 'Heidenreichstein', 'Heidenreichstein', 'Heidenreichstein,Khajdenrajkhshtajn,hai deng lai xi shi tai yin,Хайденрайхштайн,海登赖希施泰因', 48.8666700, 15.1166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3186, 'Hausmannstätten', 'Hausmannstatten', 'Hausmannstatten,Hausmannstätten,Khausmannshtetten,Хаусманнштеттен', 46.9911100, 15.5113900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3187, 'Hausleiten', 'Hausleiten', 'Cajna,Khauslajten,hao si lai teng,Хауслайтен,Цайна,豪斯莱滕', 48.3833300, 16.1000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3188, 'Hauskirchen', 'Hauskirchen', '', 48.6000000, 16.7666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3189, 'Hausbrunn', 'Hausbrunn', '', 48.6260200, 16.8284400, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3190, 'Haus', 'Haus', '', 47.4099700, 13.7672400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3191, 'Haunoldstein', 'Haunoldstein', '', 48.2000000, 15.4500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3192, 'Haugsdorf', 'Haugsdorf', '', 48.7076200, 16.0765600, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3193, 'Haugschlag', 'Haugschlag', '', 48.9833300, 15.0500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3194, 'Hatzendorf', 'Hatzendorf', 'Hatzendorf', 46.9768600, 16.0010700, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3195, 'Hatting', 'Hatting', '', 47.2787000, 11.1683800, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3196, 'Häselgehr', 'Haselgehr', 'Haselgehr,Häselgehr', 47.3166700, 10.5000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3197, 'Hartl', 'Hartl', '', 47.1833300, 15.9166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3198, 'Hart im Zillertal', 'Hart im Zillertal', 'Hart,Hart im Zillertal', 47.3510600, 11.8647600, 'AT', '2013-12-06', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3199, 'Hartberg', 'Hartberg', 'Hartberg,Hartbergas,Khartberg,ha te bei ge,Хартберг,哈特貝格', 47.2833300, 15.9666700, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3200, 'Harmannsdorf', 'Harmannsdorf', 'Harmannsdorf', 48.3972400, 16.3722000, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3201, 'Haringsee', 'Haringsee', '', 48.1927000, 16.7874100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3202, 'Bad Häring', 'Bad Haering', '', 47.5107100, 12.1191200, 'AT', '2013-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3203, 'Hardegg', 'Hardegg', 'Hardegg', 48.8500000, 15.8500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3204, 'Hard', 'Hard', '', 47.4830600, 9.6830600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3743, 'York', 'York', 'Jork,Jorko,York,Йорк,یارک، مغربی آسٹریلیا', -31.8880900, 116.7678000, 'AU', '2014-12-06', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3744, 'Yanchep', 'Yanchep', 'Yanchep,Yancher', -31.5467800, 115.6317100, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3745, 'Yallingup', 'Yallingup', 'Yallingup,Yallingup Caves', -33.6459200, 115.0351400, 'AU', '2014-07-08', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3746, 'Wundowie', 'Wundowie', 'Wundowie', -31.7616300, 116.3799000, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3747, 'Wooroloo', 'Wooroloo', 'Wooroloo', -31.8038000, 116.3131100, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3748, 'Woodville', 'Woodville', 'Woodville', -34.8833300, 138.5500000, 'AU', '2015-02-17', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3749, 'Woodside', 'Woodside', 'Woodside', -34.9543300, 138.8790100, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3750, 'Wongan Hills', 'Wongan Hills', 'Wongan Hills', -30.8929400, 116.7192500, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3751, 'Williamstown', 'Williamstown', 'Uill''jamstaun,Williamstown,Уилльямстаун', -34.6721000, 138.8910800, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3752, 'Willaston', 'Willaston', 'Willaston', -34.5833300, 138.7500000, 'AU', '2012-02-02', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3753, 'Whyalla', 'Whyalla', 'Gorad Uajala,Gouaialla,Uajalla,Vajala,Vajalla,WYA,Whyalla,huai a la,hwaiaella,uaiala,wayala,wyala,Γουαϊάλλα,Вайалла,Вајала,Горад Уаяла,Уайалла,ויאלה,وایالا,واۓلا,ویالا,ہوائالا، جنوبی آسٹریلیا,უაიალა,怀阿拉,화이앨라', -33.0326800, 137.5648300, 'AU', '2013-08-23', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3754, 'Wembley', 'Wembley', 'Wembley', -31.9333300, 115.8000000, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3755, 'Wellard', 'Wellard', 'Wellard', -32.2666700, 115.8333300, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3756, 'Wayville', 'Wayville', 'Wayville', -34.9500000, 138.5833300, 'AU', '2015-02-06', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3757, 'Waroona', 'Waroona', 'Waroona', -32.8432300, 115.9220100, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3758, 'Wanneroo', 'Wanneroo', 'Wanneroo,Wanneru', -31.7500000, 115.8000000, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3759, 'Wallaroo', 'Wallaroo', 'Uollaru,Wallaroo,Уоллару', -33.9388100, 137.6336500, 'AU', '2013-08-03', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3760, 'Waikerie', 'Waikerie', 'Uehjkeri,Waikerie,Уэйкери', -34.1817800, 139.9855200, 'AU', '2013-08-03', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3761, 'Wagin', 'Wagin', 'Wagin', -33.3089400, 117.3432800, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3762, 'Waggrakine', 'Waggrakine', 'Waggrakine', -28.7188300, 114.6392400, 'AU', '2015-02-23', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3763, 'Virginia', 'Virginia', 'Virginia', -34.6663000, 138.5602700, 'AU', '2015-02-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3764, 'Victor Harbor', 'Victor Harbor', 'Victor Harbor,Victor Harbour,Viktor-Garbor,Viktor-Kharbor,bigteohabeo,wei ke duo gang,wyktwr harbr  gwnyy awstwralya,Виктор-Харбор,Віктор-Гарбор,ויקטור הארבור,وکٹر ہاربر,وکٹر ہاربر، جنوبی آسٹریلیا,ویکتور هاربر، گونئی اوستورالیا,ڤیکتۆر ھاربۆر,ვიქტორ-ჰარბორი,維克多港,维克多港,빅터하버', -35.5504200, 138.6215400, 'AU', '2014-06-16', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3765, 'Vasse', 'Vasse', 'Vasse', -33.6666700, 115.2500000, 'AU', '2016-03-10', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3766, 'Upper Sturt', 'Upper Sturt', 'Upper Sturt', -35.0166700, 138.6833300, 'AU', '2015-02-03', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3767, 'Unley', 'Unley', 'Unley', -34.9500000, 138.6000000, 'AU', '2015-02-06', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3768, 'Two Wells', 'Two Wells', 'Tu Vells,Two Wells,Ту Веллс', -34.5932700, 138.5136700, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3769, 'Tumby Bay', 'Tumby Bay', 'Tambi-Bej,Tumby,Tumby Bay,Тамби-Бей', -34.3773000, 136.1006500, 'AU', '2016-11-03', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3770, 'Trigg', 'Trigg', '', -31.8693900, 115.7571000, 'AU', '2015-07-10', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3771, 'Toodyay', 'Toodyay', 'Toodyay', -31.5497700, 116.4674300, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3772, 'Thebarton', 'Thebarton', 'Thebarton', -34.9166700, 138.5666700, 'AU', '2011-06-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3773, 'Tennant Creek', 'Tennant Creek', 'TCA,Tennant Creek,Tennant-Krik,tnnt kryk,tnnt qryq,Теннант-Крик,Теннант-Крік,טננט קריק,تننت کریک,ტენანტ-კრიკი', -19.6497000, 134.1914700, 'AU', '2012-08-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3774, 'Tanunda', 'Tanunda', 'Tanunda', -34.5233600, 138.9598200, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3775, 'Tailem Bend', 'Tailem Bend', 'Tailem Bend,Tailen Bend,Tejlem-Bend,Тейлем-Бенд', -35.2522600, 139.4554600, 'AU', '2015-02-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3776, 'Swan View', 'Swan View', '', -31.8833300, 116.0500000, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3777, 'Swanbourne', 'Swanbourne', 'Swanbourne', -31.9687800, 115.7673000, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3778, 'Subiaco', 'Subiaco', 'Subiaco', -31.9485000, 115.8268000, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3779, 'Sturt', 'Sturt', 'Sturt', -35.0166700, 138.5500000, 'AU', '2015-02-03', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3780, 'Streaky Bay', 'Streaky Bay', 'Flinders,KBY,Streaky Bay,Striki-Bej,Стрики-Бей', -32.7955400, 134.2092800, 'AU', '2014-10-25', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3781, 'Strathalbyn', 'Strathalbyn', 'Strathalbyn', -35.2597900, 138.8924700, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3782, 'Stoneville', 'Stoneville', 'Stoneville', -30.8666700, 121.7666700, 'AU', '2016-03-10', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3783, 'Stirling', 'Stirling', 'Stirling,Stirling East,Stirling West', -35.0151800, 138.7363700, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3784, 'Spearwood', 'Spearwood', 'Spearwood', -32.1053400, 115.7779700, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3785, 'South Perth', 'South Perth', 'Perth South,South Perth', -31.9833300, 115.8666700, 'AU', '2015-02-11', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3786, 'Solomontown', 'Solomontown', 'Solomontown', -33.2000000, 138.0333300, 'AU', '2016-03-10', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3787, 'Smithfield', 'Smithfield', 'Smithfield', -34.6833300, 138.6833300, 'AU', '2015-02-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3788, 'Serpentine', 'Serpentine', 'Serpentine', -32.3605100, 115.9772300, 'AU', '2015-02-10', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3789, 'Seaton', 'Seaton', 'Seaton', -34.9000000, 138.5166700, 'AU', '2015-02-03', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3790, 'Seaford', 'Seaford', 'Seaford', -35.1898000, 138.4758900, 'AU', '2015-02-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3791, 'Scarborough', 'Scarborough', 'Scarborough,Scarborough Beach', -31.8957800, 115.7643100, 'AU', '2015-02-10', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3792, 'Salisbury', 'Salisbury', 'Salisbury', -34.7666700, 138.6333300, 'AU', '2012-02-02', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3793, 'Safety Bay', 'Safety Bay', 'Safety Bay', -32.3046300, 115.7421300, 'AU', '2015-02-10', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3794, 'Roxby Downs', 'Roxby Downs', '', -30.5630500, 136.8954600, 'AU', '2011-06-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3795, 'Roseworthy', 'Roseworthy', 'Roseworthy', -34.5339700, 138.7502300, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3796, 'Roebourne', 'Roebourne', 'RBU,Roebourne', -20.7722900, 117.1464800, 'AU', '2013-06-25', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3797, 'Rockingham', 'Rockingham', 'Rockingham,Rokingam,Rokingem,Рокингам,Рокінгем,راکنگھم، مغربی آسٹریلیا', -32.2768200, 115.7297800, 'AU', '2017-04-20', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3798, 'Maida Vale', 'Maida Vale', '', -31.9518700, 116.0276400, 'AU', '2015-02-10', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3799, 'Reynella', 'Reynella', '', -35.0937200, 138.5308200, 'AU', '2011-06-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3800, 'Ravensthorpe', 'Ravensthorpe', 'RVT,Ravensthorpe', -33.5830300, 120.0468800, 'AU', '2012-02-28', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3801, 'Quorn', 'Quorn', 'Kuorn,Quorn,Куорн', -32.3467600, 138.0417600, 'AU', '2013-08-17', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3802, 'Quindalup', 'Quindalup', 'Quindalup', -33.6356000, 115.1489900, 'AU', '2014-08-16', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3803, 'Prospect', 'Prospect', '', -34.8824100, 138.5933000, 'AU', '2013-06-25', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3804, 'Port Willunga', 'Port Willunga', 'Port Willunga', -35.2779200, 138.4523000, 'AU', '2015-02-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3805, 'Port Victoria', 'Port Victoria', 'Port Victoria,Port-Viktorija,Wauraltee,Порт-Виктория', -34.4960200, 137.4827000, 'AU', '2016-03-26', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3806, 'Port Pirie', 'Port Pirie', 'PPI,Port Pirie,Port-Piri,poteupili,potopiri,pwrt pyry,Порт-Пири,Порт-Пірі,פורט פירי,پورت پیری,پورٹ پیری,پۆرت پیێری,პორტ-პირი,ポートピリー,포트피리', -33.1917600, 138.0174600, 'AU', '2013-08-03', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3807, 'Port Noarlunga', 'Port Noarlunga', 'Port Noarlunga', -35.1480200, 138.4709900, 'AU', '2015-02-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3808, 'Port Lincoln', 'Port Lincoln', 'PLO,Port Lincoln,Port-Linkol''n,Pt Lincoln,lin ken gang,poteulingkeon,potorinkan,Порт-Линкольн,Порт-Лінкольн,پورٹ لنکولن,პორტ-ლინკოლნი,ポートリンカーン,林肯港,포트링컨', -34.7262500, 135.8744200, 'AU', '2017-05-10', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3809, 'Port Hedland', 'Port Hedland', 'PHE,Port Hedland,Port Khedland,Port-Gedlend,Port-Khedlend,poteuhedeullaendeu,potoheddorando,pwrt hdlnd,Порт Хедланд,Порт-Гедленд,Порт-Хедленд,פורט הדלנד,პორტ-ჰედლანდი,ポートヘッドランド,포트헤들랜드', -20.3121500, 118.6105900, 'AU', '2013-06-25', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3810, 'Port Elliot', 'Port Elliot', 'Port Elliot', -35.5301700, 138.6792200, 'AU', '2015-12-07', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3811, 'Port Augusta West', 'Port Augusta West', '', -32.4861100, 137.7583300, 'AU', '2014-04-08', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3812, 'Port Augusta', 'Port Augusta', 'Kurdnatta,PUG,Port Augusta,Port Avgusta,Port-Ogasta,Puerto Augusta,ao gu si ta gang,poteuogeoseuta,potoogasuta,pwrt agwsta,Порт Августа,Порт-Огаста,פורט אוגוסטה,پورت آگوستا,پورٹ آگستا,پورٹ آگسٹا، جنوبی آسٹریلیا,پۆرت ئۆگەستا,პორტ-ოგასტა,ポートオーガスタ,奧古斯塔港,포트오거스타', -32.4959700, 137.7728100, 'AU', '2013-08-24', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3813, 'Port Adelaide', 'Port Adelaide', 'Port Adelaide,پورٹ ایڈیلیڈ، جنوبی آسٹریلیا', -34.8500000, 138.4666700, 'AU', '2015-02-04', 14);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3205, 'Hannersdorf', 'Hannersdorf', 'Samfalva,Sampovar,Sámfalva,Šampovar', 47.2289500, 16.3825000, 'AT', '2012-11-01', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3206, 'Hallwang', 'Hallwang', '', 47.8500000, 13.0833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3207, 'Hallein', 'Hallein', 'Gallajn,Hallein,Khalajn,Khallajn,Salinae,ha lai yin,halaini,halayn,hallain,harain,Галлайн,Халајн,Халлайн,האליין,هالاین,ჰალაინი,ハライン,哈萊因,할라인', 47.6833300, 13.1000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3208, 'Halbturn', 'Halbturn', 'Feltorony,Féltorony,Gal''bturn,Khal''bturn,ha bu tu en,Гальбтурн,Хальбтурн,哈布图恩', 47.8701900, 16.9754200, 'AT', '2012-11-04', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3209, 'Halbenrain', 'Halbenrain', 'Halbenrain,Khal''benrajn,ha er ben lai yin,Хальбенрайн,哈尔本赖因', 46.7219400, 15.9466700, 'AT', '2014-04-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3210, 'Hainzenberg', 'Hainzenberg', 'Hainzenberg', 47.2178800, 11.9003400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3211, 'Hainsdorf im Schwarzautal', 'Hainsdorf im Schwarzautal', 'Hainsdorf,Hainsdorf im Schwarzautal', 46.8358300, 15.6413900, 'AT', '2017-06-18', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3212, 'Hainfeld', 'Hainfeld', '', 48.0339000, 15.7741400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3213, 'Hainersdorf', 'Hainersdorf', 'Hainersdorf', 47.1150600, 15.9437400, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3214, 'Hainburg an der Donau', 'Hainburg an der Donau', 'Gajnburg-na-Dunai,Hainburg,Hainburgo ce Danubo,Hainburgo ĉe Danubo,Khajnburg,Khajnburg-an-der-Donau,duo nao he pan hai en bao,Гайнбург-на-Дунаї,Хайнбург,Хайнбург-ан-дер-Донау,多瑙河畔海恩堡', 48.1462700, 16.9450400, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3215, 'Haiming', 'Haiming', '', 47.2500000, 10.8833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3216, 'Haidershofen', 'Haidershofen', '', 48.0757900, 14.4613100, 'AT', '2016-03-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3217, 'Haibach im Mühlkreis', 'Haibach im Muhlkreis', 'Haibach,Haibach im Muhlkreis,Haibach im Mühlkreis', 48.4442900, 14.3441100, 'AT', '2011-12-20', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3218, 'Hagenbrunn', 'Hagenbrunn', '', 48.3333300, 16.4000000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3219, 'Hafnerbach', 'Hafnerbach', '', 48.2166700, 15.4833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3220, 'Hadres', 'Hadres', '', 48.7096500, 16.1303800, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3221, 'Hackerberg', 'Hackerberg', 'Hackerberg,Hakerberg,Khakkerberg,Хаккерберг', 47.2000000, 16.1166700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3222, 'Haag', 'Haag', '', 48.1136200, 14.5675300, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3223, 'Güttenbach', 'Guttenbach', 'Gjuttenbakh,Guttenbach,Güttenbach,Pinkovac,Гюттенбах', 47.1571000, 16.2923000, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3224, 'Guttaring', 'Guttaring', '', 46.8853600, 14.5107100, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3225, 'Gutenstein', 'Gutenstein', '', 47.8760000, 15.8888100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3226, 'Gutenbrunn', 'Gutenbrunn', '', 48.3652000, 15.1189900, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3227, 'Güssing', 'Guessing', 'Gising,Gjussing,Guessing,Güssing,Nemetujvar,Novi Grad,Németújvár,ju xing,Гисинг,Гюссинг,Гюссінг,居兴', 47.0593600, 16.3243100, 'AT', '2012-02-03', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3228, 'Gurk', 'Gurk', 'Gurk,Krka  Avstrija,Гурк', 46.8738900, 14.2916700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3229, 'Guntramsdorf', 'Guntramsdorf', 'Guntramsdorf,gong te la mu si duo fu,Гунтрамсдорф,貢特拉姆斯多夫', 48.0468700, 16.3138400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3230, 'Guntersdorf', 'Guntersdorf', '', 48.6500000, 16.0500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3231, 'Gunskirchen', 'Gunskirchen', 'Gunskirkhen,gong si ji xing,Гунскирхен,貢斯基興', 48.1333300, 13.9500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3232, 'Günselsdorf', 'Gunselsdorf', '', 47.9439500, 16.2606200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3233, 'Gundersdorf', 'Gundersdorf', '', 46.9500000, 15.2333300, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3234, 'Gumpoldskirchen', 'Gumpoldskirchen', 'Gumpol''dskirkhen,gong bo er de si ji xing,Гумпольдскирхен,贡波尔德斯基兴', 48.0453800, 16.2771000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3235, 'Grünbach am Schneeberg', 'Grunbach am Schneeberg', 'Grunbach,Grunbach am Schneeberge,Grünbach,Grünbach am Schneeberge', 47.7974700, 15.9878500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3236, 'Grünau im Almtal', 'Gruenau im Almtal', 'Gmunden,Grjunau,Grjunau-im-Al''mtal'',Grunau,Grünau,ge lu nao,Грюнау,Грюнау-им-Альмталь,格呂瑙', 47.8549300, 13.9557300, 'AT', '2011-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3237, 'Großweikersdorf', 'Grossweikersdorf', 'Grosvajkersdorf,Klajnvizendorf,da wei ke er si duo fu,Гросвайкерсдорф,Клайнвизендорф,大魏克尔斯多夫', 48.4712300, 15.9825100, 'AT', '2017-06-24', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3238, 'Großsölk', 'Grosssoelk', 'Grosssolk,Grosssölk,Großsölk', 47.4166700, 13.9666700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3239, 'Groß-Siegharts', 'Gross-Siegharts', '', 48.7918000, 15.4042900, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3240, 'Groß-Schweinbarth', 'Gross-Schweinbarth', 'Gross-Schweinbarth,Grossschweinbarth,Groß-Schweinbarth,Großschweinbarth', 48.4147200, 16.6319400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3241, 'Groß Sankt Florian', 'Gross Sankt Florian', 'Gros-Sankt-Florian,Gross Sankt Florian,Groß Sankt Florian,da sheng fu luo li an,Грос-Санкт-Флориан,大圣弗洛里安', 46.8244400, 15.3186100, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3242, 'Großrußbach', 'Grossrussbach', '', 48.4741200, 16.4164900, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3243, 'Großriedenthal', 'Grossriedenthal', '', 48.4833300, 15.8666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3244, 'Grosspetersdorf', 'Grosspetersdorf', 'Grosspetersdorf,Großpetersdorf,Nagyszentmihaly,Nagyszentmihály', 47.2389500, 16.3178300, 'AT', '2017-02-08', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3245, 'Großmugl', 'Grossmugl', 'Grosmugl'',da mu ge er,Гросмугль,大穆格尔', 48.4991700, 16.2305600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3246, 'Großlobming', 'Grosslobming', 'Grosslobming,Großlobming', 47.1833300, 14.8000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3247, 'Großkrut', 'Grosskrut', '', 48.6438900, 16.7236100, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3248, 'Großklein', 'Grossklein', 'Grossklein,Großklein,Klein', 46.7361100, 15.4444400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3249, 'Großhofen', 'Grosshofen', '', 48.2583400, 16.6194000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3250, 'Heimschuh', 'Heimschuh', 'Grossheimschuh,Heimschuh', 46.7600000, 15.4930600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3251, 'Großharras', 'Grossharras', '', 48.6638900, 16.2455600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3252, 'Groß-Gerungs', 'Gross-Gerungs', '', 48.5742200, 14.9578900, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3253, 'Groß-Enzersdorf', 'Gross-Enzersdorf', 'Genzersdorf,Gros-Encersdorf,Grosehncersdorf,Gross-Enzersdorf,Groß-Enzersdorf,da en ce si duo fu,Грос-Енцерсдорф,Гросэнцерсдорф,大恩策斯多夫', 48.2027800, 16.5508300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3254, 'Groß-Engersdorf', 'Gross-Engersdorf', 'Grossengersdorf,Großengersdorf', 48.3587300, 16.5661000, 'AT', '2017-06-30', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3255, 'Großebersdorf', 'Grossebersdorf', 'Grosehbersdorf,Grossebersdorf,da ai bo er si duo fu,Гроссеберсдорф,Гросэберсдорф,大埃伯尔斯多夫', 48.3640500, 16.4707600, 'AT', '2013-03-14', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3256, 'Grödig', 'Grodig', 'Graedig,Gredig,Grjodig,Grodig,Grädig,Grödig,ge lei di xi,Гредіг,Грёдиг,格勒迪希', 47.7383300, 13.0373000, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3257, 'Gröbming', 'Grobming', 'Grjobming,Grobming,Gröbming,ge lei bu ming,Грёбминг,格勒布明', 47.4427200, 13.9012200, 'AT', '2011-09-09', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3258, 'Grins', 'Grins', 'Grins,Innerdorf,ge lin si,Гринс,Грінс,格林斯', 47.1403400, 10.5140900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3259, 'Grimmenstein', 'Grimmenstein', 'Grimmenshtajn,Grimmenstein,ge li men shi tai yin,Гримменштайн,格里门施泰因', 47.6163500, 16.1272400, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3260, 'Griffen', 'Griffen', 'Grebinj,Griffen,ge li fen,Гриффен,Ґріффен,格里芬', 46.7044400, 14.7327800, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3261, 'Grieskirchen', 'Grieskirchen', 'Griaskircha,Grieskirchen,Griskirkhen,ge li si ji xing,Грискирхен,格里斯基兴', 48.2333300, 13.8333300, 'AT', '2014-02-07', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3262, 'Gries im Sellrain', 'Gries im Sellrain', 'Gries,Gries in Sellrain', 47.1955400, 11.1561900, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3263, 'Gries am Brenner', 'Gries am Brenner', 'Gries,Gries am Brenner', 47.0384900, 11.4813100, 'AT', '2017-06-26', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3264, 'Gresten', 'Gresten', 'Gresten,ge lei si teng,Грестен,格雷斯滕', 47.9852100, 15.0255200, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3265, 'Gressenberg', 'Gressenberg', '', 46.8000000, 15.1166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3266, 'Greisdorf', 'Greisdorf', 'Greisdorf', 46.9166700, 15.2166700, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3267, 'Greifenburg', 'Greifenburg', 'Grajfenburg,ge lai fen bao,Грайфенбург,格赖芬堡', 46.7502700, 13.1798200, 'AT', '2017-06-29', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3268, 'Graz', 'Graz', 'GRZ,Gorad Grac,Grac,Graca,Gracas,Gradec,Graecia,Gratz,Graz,Grác,Gráz,Grāca,Nkrats,Qras,Styrsky Hradec,ge la ci,geulacheu,ghrats,grats,gratsa,gratsi,guratsu,kras,Štýrský Hradec,Γκρατς,Горад Грац,Грац,Գրաց,גראץ,غراتس,گراتس,ग्रात्स,กราซ,გრაცი,グラーツ,格拉茨,그라츠', 47.0666700, 15.4500000, 'AT', '2015-04-14', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3269, 'Gratwein', 'Gratwein', 'Gratvajn,Gratwein,ge la te wei yin,Гратвайн,格拉特韦因', 47.1166700, 15.3166700, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3270, 'Gratkorn', 'Gratkorn', 'Gratkorn,ge la te ke en,Граткорн,格拉特科恩', 47.1333300, 15.3500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3271, 'Grän', 'Graen', 'Gren,Грен', 47.5000000, 10.5500000, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3272, 'Grambach', 'Grambach', 'Grambach', 47.0166700, 15.5000000, 'AT', '2017-06-17', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3273, 'Gramatneusiedl', 'Gramatneusiedl', 'Gramatnojzidl'',ge la ma te nuo yi xi de er,Граматнойзидль,格拉馬特諾伊錫德爾', 48.0304000, 16.4893600, 'AT', '2017-06-27', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3274, 'Gramastetten', 'Gramastetten', 'Gramashtetten,ge la ma shi te teng,Грамаштеттен,格拉马施特滕', 48.3802800, 14.1918500, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3275, 'Gramais', 'Gramais', 'Gramais', 47.2666700, 10.5333300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3276, 'Grafenwörth', 'Grafenworth', '', 48.4079000, 15.7782600, 'AT', '2017-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3277, 'Grafenstein', 'Grafenstein', '', 46.6139300, 14.4671900, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3278, 'Grafenschlag', 'Grafenschlag', '', 48.5000000, 15.1666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3279, 'Grafenschachen', 'Grafenschachen', '', 47.3666700, 16.0666700, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3280, 'Grafenegg', 'Grafenegg', 'Grafeneg,Grafenegg,ge la fei nei ge,Графенег,Графенегг,格拉费内格', 48.4304000, 15.7490700, 'AT', '2017-06-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3281, 'Grafendorf bei Hartberg', 'Grafendorf bei Hartberg', 'Grafendorf,Grafendorf (Khartberg),Grafendorf bei Hartberg,Grafendorf-Khartberg,Grafendorf-baj-Khartberg,ha te bei ge fu jin ge la fen duo fu,Графендорф (Хартберг),Графендорф-Хартберг,Графендорф-бай-Хартберг,哈特贝格附近格拉芬多夫', 47.3402800, 15.9906000, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3282, 'Grabersdorf', 'Grabersdorf', 'Grabersdorf', 46.8430600, 15.8247200, 'AT', '2017-06-22', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3283, 'Götzis', 'Gotzis', 'G''ocis,Gecis,Getcis,Gjotcis,Gotzis,Götzis,ge qi si,getsu~isu,gwtsyz,Гетціс,Гецис,Гьоцис,Гётцис,گوتسیز,ゲツィス,格齊斯', 47.3330600, 9.6330600, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3284, 'Götzens', 'Gotzens', 'Getcens,Gjotcens,ge cen si,Гетценс,Гётценс,گوٹزنز,格岑斯', 47.2360600, 11.3115400, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3285, 'Götzendorf an der Leitha', 'Gotzendorf an der Leitha', 'Goetzendorf,Gotzendorf,Gotzendorf an der Leitha,Götzendorf,Götzendorf an der Leitha', 48.0166700, 16.5833300, 'AT', '2011-07-31', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3286, 'Göstling an der Ybbs', 'Gostling an der Ybbs', 'Gjostling-an-der-Ibs,Gostling,Gostling an der Ybbs,Göstling,Göstling an der Ybbs,Ibstajnbakh,yi bu si he pan ge shi te ling,Гёстлинг-ан-дер-Ибс,Ибстайнбах,伊布斯河畔格施特灵', 47.8066400, 14.9379700, 'AT', '2017-06-25', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3287, 'Gösting', 'Goesting', 'Gosting,Gösting', 47.0978800, 15.3977700, 'AT', '2013-07-28', 15);
INSERT INTO `cities` (`id`, `name`, `asciiname`, `alternatenames`, `latitude`, `longitude`, `country_code`, `modification_date`, `country_id`) VALUES(3288, 'Gössendorf', 'Gossendorf', 'Gjossendorf