<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * GeoIp2 Class
 *
 * @package       CodeIgniter
 * @subpackage  Libraries
 * @category      GeoIp2
 */
require_once( APPPATH . 'third_party/GeoIp2/vendor/autoload.php' );
use GeoIp2\Database\Reader;

class Mygeoip2 { 

    protected $record;
    protected $database_path = 'third_party/GeoIp2/GeoLite2-City.mmdb';

    public function __construct() {

        $ci =& get_instance();
        $reader = new Reader(APPPATH.$this->database_path);

        if ( ! strcmp($ci->input->ip_address(), '127.0.0.1') || ! strcmp($ci->input->ip_address(), '::1') )
			$ip = '1.2.3.4';
		else
			$ip = $ci->input->ip_address();

		if ($ci->input->valid_ip($ip))
            $this->record = $reader->city($ip);

        log_message('debug', 'Mygeoip2 Class Initialized');
    }


    /**
     * getState()
     * @return state
     */
    public function getState() {
        return $this->record->country->name;
    }

		

    /**
     * getState()
     * @return country code "US/CA etc"
     */
    public function getCountryCode() {
        return $this->record->country->isoCode;
    }


    /**
     * getCity()
     * @return city name
     */
    public function getCity() {
        return $this->record->city->name;
    }


    /**
     * getZipCode()
     * @return Zip Code (#)
     */
    public function getZipCode() {
        return $this->record->postal->code;
    }

    /**
     * getRawRecord()
     * (if you want to manually extract objects)
     *
     * @return object of all items
     */
    public function getRawRecord() {
        return $this->record;
    }

	/**
	 * getTimezone()
	 * @return time zone
	 */
	public function getTimezone() {
		return $this->record->location->timeZone;
	}
}
