<?php

/* Copyright (C) 2015, 2017 David MAURER david-maurer@netdefi.com */

/*
This file is part of "Online dating web site".

    "Online dating web site" is free software:
    you can redistribute it and/or modify it
    under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    "Online dating web site" is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with "Online dating web site", see the file COPYING.LESSER.
    If not, see <http://www.gnu.org/licenses/>.
*/



/**
 * objectif : sélectionner une langue.
 *
 * utilisation : $language = select_a_language(array("en", "fr"), "en");
 *
 * @param array $languages_available langues disponibles pour ce site web
 * exemple: array("en", "fr")
 * 2 caractères par langue
 *
 * @param string $default_language langue à choisir par défaut
 *
 * @return string la langue sélectionnée par l'utilisateur ou la langue du navigateur ou la langue par défaut
 */

function select_a_language($languages_available, $default_language = "en") {

	if ( isset($_COOKIE["language"]) ):

		return $_COOKIE["language"];

	elseif ( ! empty($_SERVER["HTTP_ACCEPT_LANGUAGE"]) ):

		$web_browser_languages = explode(",", $_SERVER["HTTP_ACCEPT_LANGUAGE"]);

		foreach ( $web_browser_languages as $value ):

			$web_browser_language = explode(";", $value);

			foreach ( $web_browser_language as $value ):

				if ( in_array($value, $languages_available) ):

					return $value;

				endif;

			endforeach;

		endforeach;

	endif;

	return $default_language;

}
?>
