<?php

/* Copyright (C) 2015, 2017 David MAURER david-maurer@netdefi.com */

/*
This file is part of "Online dating web site".

    "Online dating web site" is free software:
    you can redistribute it and/or modify it
    under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    "Online dating web site" is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with "Online dating web site", see the file COPYING.LESSER.
    If not, see <http://www.gnu.org/licenses/>.
*/



/******************************************************************************/
/* purpose : to verify that the PHP script was queried                        */
/*           through the HTTPS protocol.                                      */
/*                                                                            */
/* objectif : vérifier que le script PHP a été demandé                        */
/*            par le protocole HTTPS.                                         */
/******************************************************************************/

// empty()  Determine whether a variable is empty
if ( empty($_SERVER["HTTPS"]) ):

	// header()  Send a raw HTTP header
	header("location: https://" . $_SERVER["HTTP_HOST"] . $_SERVER["PHP_SELF"]);

endif;



/******************************************************************************/
/* purpose : to create a session, to store the values of the profile of a     */
/*           visitor, the time of his visit.                                  */
/*                                                                            */
/* objectif : créer une session, pour stocker les valeurs du profil d'un      */
/*            visiteur, le temps de sa visite.                                */
/******************************************************************************/

// session_start()  Start new or resume existing session
session_start();



/******************************************************************************/
/* purpose : to include the configuration files "settings.php"                */
/*           and the function library "functions.php                          */
/*                                                                            */
/* objectif : inclure le fichiers de configuration "settings.php"             */
/*            et la bibliothèque de fonctions "functions.php                  */
/******************************************************************************/

// require_once()  Includes and evaluates the specified file, check if the file has already been included
require_once("../includes/settings.php");

// require_once()  Includes and evaluates the specified file, check if the file has already been included
require_once("../includes/functions.php");



/******************************************************************************/
/* purpose : to create a cookie to retain the manual choice of the language   */
/*           of the website, choice made via the form "language"              */
/*                                                                            */
/* objectif : créer un cookie pour retenir le choix manuel de la langue       */
/*            du site web, choix fait via le formulaire "langage"             */
/******************************************************************************/

// filter_has_var()  Checks if variable of specified type exists
if ( filter_has_var(INPUT_POST, "choice_of_language") && filter_has_var(INPUT_POST, "language") ):

	// filter_input()  Gets a specific external variable by name and optionally filters it
	$filter_result = filter_input(INPUT_POST, "language", FILTER_SANITIZE_STRING);

	if ( ! $filter_result ):

		$error[] = _("Error, the value of the chosen language is invalid.");

	elseif ( $filter_result == "fr_FR" || $filter_result == "en" ):

		// setcookie()  Send a cookie
		setcookie("language", $filter_result, time() + 3600 * 24 * 365, "/", $_SERVER["HTTP_HOST"], true, true);

		$_COOKIE["language"] = $filter_result;

	else:

		$error[] = _("Error, the language chosen is not supported.");

	endif;

endif;



/******************************************************************************/
/* purpose : to select the language of the website                            */
/*                                                                            */
/* objectif : sélectionner la langue du site web                              */
/******************************************************************************/

// select_a_language()  Select a language
$language = select_a_language(array("fr", "fr-FR"), "en");

if ( $language != "en" ):

	$language = ($language == "fr" || $language == "fr-FR") ? "fr_FR" : $language;
	$language = $language . ".utf-8";
	$encoding = "utf-8";
	$domain = "messages";

	// setlocale()  Set locale information
	setlocale(LC_MESSAGES, $language);

	// bindtextdomain()  Sets the path for a domain
	bindtextdomain($domain, LOCALE_DIRECTORY);

	// bind_textdomain_codeset()  Specify the character encoding in which the messages from the DOMAIN message catalog will be returned
	bind_textdomain_codeset($domain, $encoding);

	// textdomain()  Sets the default domain
	textdomain($domain);

endif;
?>
<!DOCTYPE html>
<html>
	<head>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta http-equiv="content-type" content="text/html;charset=utf-8">
		<link rel="icon" type="image/png" href="../images/logo.png">
		<title><?php print $_SERVER["HTTP_HOST"]; ?> <?php print _("serious dating website"); ?></title>
		<meta name="keywords" content="<?php print _("dating site,dating,love,bachelor,find love,ad,chat"); ?>">
		<meta name="description" content="<?php print _("In search of love? Bachelors are waiting for you to meet you."); ?>"> 
		<link rel="stylesheet" type="text/css" href="../css/mystyle.css">
	</head>
	<body>
		<?php
		// isset()  Determine if a variable is set and is not NULL
		if ( isset($error) ):

			print "<div class=\"error\">";

			foreach( $error as $value ):

				print "<p>" . $value . "</p>";

			endforeach;

			print "</div>";

		endif;
		?>
		<div class="layout">
			<div id="heading">
				<div id="logo">
					<img src="../images/logo.png">
				</div><!-- logo -->
				<h1><?php print _("I welcome you to"); ?> <a href="https://<?php print $_SERVER["HTTP_HOST"]; ?>"><?php print $_SERVER["HTTP_HOST"]; ?></a>,</h1>
				<h2><?php print _("this dating website was created for people wishing to build a serious long-term relationship or even a wedding."); ?></h2>
			</div><!-- heading -->
			<div id="navigation">
				<form method="post">
					<?php print _("Language"); ?>&nbsp;:
					<select name="language">
						<option value="en"<?php if ( $language == "en" ): print " selected"; endif; ?>>English</option>
						<option value="fr_FR"<?php if ( $language == "fr_FR.utf-8" ): print " selected"; endif; ?>>Français</option>
					</select>
					<input type="submit" name="choice_of_language" value="<?php print _("Validate"); ?>">
				</form>
				<br>
				<a href="sign_in.php" class="not_underlined"><input type="submit" value="&nbsp;&nbsp;&nbsp;&nbsp;<?php print _("Sign in"); ?>&nbsp;&nbsp;&nbsp;&nbsp;"></a> |
				<a href="sign_up.php" class="not_underlined"><input type="submit" value="&nbsp;&nbsp;&nbsp;&nbsp;<?php print _("Sign up"); ?>&nbsp;&nbsp;&nbsp;&nbsp;"></a> |
				<a href="../index.php"><?php print _("Home"); ?></a>
			</div><!-- navigation -->
			<div class="contents">
				<h1><?php print _("Terms of Sales :"); ?></h1>
				<p><?php print _("Price (in euros and taxes included) :"); ?><br>
				<?php print _("10 euros / month. For more freedom the service provision is not renewed automatically."); ?></p>
				<p><?php print _("Fees :"); ?><br>
				<?php print _("none."); ?></p>
				<p><?php print _("Delivery date :"); ?><br>
				<?php print _("within minutes of receipt of payment for the order."); ?></p>
				<p><?php print _("Modality of payment :"); ?><br>
				<?php print _("by check, by Paypal and by credit card."); ?></p>
				<p><?php print _("After sales service :"); ?><br>
				<?php print _("by e-mail to"); ?> <img title="<?php print _("Anti spam activated, please manually copy the e-mail address."); ?>" src="../images/e-mail.png" alt="<?php print _("Display the images in your browser to see the e-mail address."); ?>" height="25" width="180"><br>
				<?php print _("or by this form :"); ?></p>
				<form method="post" class="after_sales_service_contact_form">
				<?php
				$ok = false;
				$msg = _("Please enter the text in the image in the field below !");

				// filter_has_var()  Checks if variable of specified type exists
				// is_string()       Find whether the type of a variable is string
				// isset()           Determine if a variable is set and is not NULL
				// strlen()          Get string length
				if ( filter_has_var(INPUT_POST, "after_sales_service") && filter_has_var(INPUT_POST, "e-mail") && filter_has_var(INPUT_POST, "message") && filter_has_var(INPUT_POST, "phrase") && is_string($_POST["phrase"]) && isset($_SESSION["phrase"]) && strlen($_SESSION["phrase"]) > 0 ):

					// strlen()  Get string length
					if ( strlen($_POST['phrase']) > 0 && $_POST['phrase'] == $_SESSION['phrase'] ):

						$filters = array(
							"e-mail" => FILTER_VALIDATE_EMAIL,
							"message" => FILTER_SANITIZE_STRING
						);

						// filter_input_array()  Gets external variables and optionally filters them
						$filter_result = filter_input_array(INPUT_POST, $filters);

						$_SESSION["e-mail"] = $filter_result["e-mail"];
						$_SESSION["message"] = $filter_result["message"];

						if ( $filter_result["e-mail"] && $filter_result["message"] ):

							// require_once  Includes and evaluates the specified file, check if the file has already been included
							require_once("Mail.php");

							// require_once  Includes and evaluates the specified file, check if the file has already been included
							require_once("Mail/mime.php");

							$text = $filter_result["message"];
							$crlf = "\n";
							$headers = array(
              	"From"    => $filter_result["e-mail"],
              	"Subject" => _("After sales service ") . $_SERVER["HTTP_HOST"]
              );

							$mime = new Mail_mime(array("eol" => $crlf));

							$mime->setTXTBody($text);

							$body = $mime->get();
							$headers = $mime->headers($headers);

							$mail =& Mail::factory("mail");
							if ( $mail->send("david-maurer@netdefi.com", $headers, $body) ):

								$msg = _("Your message has been sent !");

								// unset()  Unset a given variable
								unset($_SESSION["e-mail"]);

								// unset()  Unset a given variable
								unset($_SESSION["message"]);

							else:

								$msg = _("The sending of the message failed !");

							endif;

						elseif ( ! $filter_result["e-mail"] ):

							$msg = _("Votre adresse e-mail n'est pas valide !");

						else:

							$msg = _("Votre message est vide !");

						endif;

						$ok = true;

						// unset()  Unset a given variable
						unset($_SESSION["phrase"]);

					else:

						$msg = _("Please try again !");

					endif;

					// unlink() Deletes a file
					unlink("../captcha/" . md5(session_id()) . '.png');

				endif;

				if ( ! $ok ):

					print _("Your e-mail :") . "<br>" .
					"<input type=\"text\" name=\"e-mail\"";

					// isset()  Determine if a variable is set and is not NULL
					if ( isset($_SESSION["e-mail"]) ):

						print "value=\"" . $_SESSION["e-mail"] . "\"";

					endif;

					print "><br>" .
					_("Your message :") . "<br>" .
					"<textarea cols=\"26\" rows=\"12\" name=\"message\">";

					// isset()  Determine if a variable is set and is not NULL
					if ( isset($_SESSION["message"]) ):

						print $_SESSION["message"];

					endif;

					print "</textarea><br>" .
					"<p>$msg</p>";

					// require_once()  Includes and evaluates the specified file, check if the file has already been included
					require_once("Text/CAPTCHA.php");

					// Set CAPTCHA options (font must exist!)
					$imageOptions = array(
						"font_size"        => 24,
						"font_path"        => "../fonts",
						"font_file"        => "OpenSans-Regular.ttf",
						"text_color"       => "#DDFF99",
						"lines_color"      => "#CCEEDD",
						"background_color" => "#555555"
					);

					// Set CAPTCHA options
					$options = array(
						"width"        => 200,
						"height"       => 100,
						"output"       => "png",
						"imageOptions" => $imageOptions
					);

					// Generate a new Text_CAPTCHA object, Image driver
					$c = Text_CAPTCHA::factory('Image');

					$retval = $c->init($options);

					if ( PEAR::isError($retval) ):

					    printf(_("Error initializing CAPTCHA : %s !"), $retval->getMessage());

					endif;

					// Get CAPTCHA secret passphrase
					$_SESSION['phrase'] = $c->getPhrase();

					// Get CAPTCHA image (as PNG)
					$png = $c->getCAPTCHAAsPNG();

					if ( PEAR::isError($png) ):

					    printf(_("Error generating CAPTCHA ! %s"), $png->getMessage());

					endif;

					$filename = "../captcha/" . md5(session_id()) . '.png';

					// file_put_contents  Write a string to a file
					file_put_contents($filename, $png);

					print "<img src=\"" . $filename . "\">" .
					"<input type=\"text\" name=\"phrase\">" .
					"<input type=\"submit\" name=\"after_sales_service\" value=\"" . _("Send") . "\">";

				else:

					print "<p>$msg</p>" .
					"<input type=\"submit\" value=\"" . _("New message") . "\">";

				endif;
				?>
				</form>
				<p><?php print _("Right to retract :"); ?><br>
				<?php print _("the online buyer, like any consumer of mail-order, has a right of withdrawal of 14 days from the day after he enters possession of the property or accepts the offer for a service without justification or payment of penalties on his part."); ?></p>
				<p><?php print _("Duration of the offer :"); ?><br>
				<?php print _("monthly."); ?></p>
				<p><?php print _("Cost of remote communication technology :"); ?><br>
				<?php print _("it is the responsibility of the user. The activity of the company David MAURER does not include the provision of access to the Internet."); ?></p>
			</div><!-- contents -->
			<div id="footer">
				<a href="cookies.php"><?php print _("Cookies"); ?></a> |
				<a href="legal_informations.php"><?php print _("Legal informations"); ?></a> |
				<a href="#"><?php print _("Terms of sale"); ?></a>
			</div><!-- footer -->
		</div><!-- layout -->
	</body>
</html>
