/*
 * Decompiled with CFR 0.152.
 */
package opale.module2d.noyau2d;

import java.io.IOException;
import opale.module2d.noyau2d.MVPass;
import opale.module2d.noyau2d.MalformedFileException;
import opale.module2d.noyau2d.OIJException;
import opale.module2d.noyau2d.Pack2D;
import opale.tools.RFile;
import opale.tools.WFile;

public final class OIJ {
    private String name;
    private OIJ rep;
    protected double oriX;
    protected double oriY;
    protected double[] I;
    protected double[] J;

    public OIJ() {
        this.name = new String("Sans nom");
        this.rep = null;
        this.oriY = 0.0;
        this.oriX = 0.0;
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = 1.0;
        this.I[1] = 0.0;
        this.J[0] = 0.0;
        this.J[1] = 1.0;
    }

    public OIJ(double d, double d2, double d3, double d4, double d5, double d6) throws OIJException {
        this.name = new String("Sans nom");
        this.rep = null;
        this.oriX = d;
        this.oriY = d2;
        if (!(Math.abs(d3 * d6 - d4 * d5) > 1.0E-15)) {
            throw new OIJException("Erreur \u00e0 la construction d'un rep\u00e8re !");
        }
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = d3;
        this.I[1] = d4;
        this.J[0] = d5;
        this.J[1] = d6;
    }

    public OIJ(OIJ oIJ) {
        this.rep = oIJ.rep;
        this.oriX = oIJ.oriX;
        this.oriY = oIJ.oriY;
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = oIJ.I[0];
        this.I[1] = oIJ.I[1];
        this.J[0] = oIJ.J[0];
        this.J[1] = oIJ.J[1];
    }

    public OIJ(OIJ oIJ, double d, double d2, double d3, double d4, double d5, double d6) throws OIJException {
        this.name = new String("Sans nom");
        this.rep = oIJ;
        this.oriX = d;
        this.oriY = d2;
        if (!(Math.abs(d3 * d6 - d4 * d5) > 1.0E-15)) {
            throw new OIJException("Erreur \u00e0 la construction d'un rep\u00e8re !");
        }
        this.I = new double[2];
        this.J = new double[2];
        this.I[0] = d3;
        this.I[1] = d4;
        this.J[0] = d5;
        this.J[1] = d6;
    }

    public final double dist(double d, double d2, double d3, double d4) {
        return this.norm(d3 - d, d4 - d2);
    }

    public final double distSq(double d, double d2, double d3, double d4) {
        return this.normSq(d3 - d, d4 - d2);
    }

    public boolean equals(Object object) {
        if (object instanceof OIJ) {
            OIJ oIJ = (OIJ)object;
            MVPass mVPass = new MVPass();
            MVPass mVPass2 = new MVPass();
            OIJ.matPassageAbs(oIJ, mVPass);
            OIJ.matPassageAbs(this, mVPass2);
            return mVPass.getM(0, 0) == mVPass2.getM(0, 0) && mVPass.getM(1, 0) == mVPass2.getM(1, 0) && mVPass.getM(0, 1) == mVPass2.getM(0, 1) && mVPass.getM(1, 1) == mVPass2.getM(1, 1) && mVPass.getV(0) == mVPass2.getV(0) && mVPass.getV(1) == mVPass2.getV(1);
        }
        return false;
    }

    public double getIx() {
        return this.I[0];
    }

    public double getIy() {
        return this.I[1];
    }

    public double getJx() {
        return this.J[0];
    }

    public double getJy() {
        return this.J[1];
    }

    public final String getName() {
        return this.name;
    }

    public OIJ getOIJ() {
        return this.rep;
    }

    public double getOriginX() {
        return this.oriX;
    }

    public double getOriginY() {
        return this.oriY;
    }

    public void matPassage(MVPass mVPass) {
        mVPass.setM(0, 0, this.I[0]);
        mVPass.setM(1, 0, this.I[1]);
        mVPass.setM(0, 1, this.J[0]);
        mVPass.setM(1, 1, this.J[1]);
        mVPass.setV(0, this.oriX);
        mVPass.setV(1, this.oriY);
    }

    public void matPassage(OIJ oIJ, MVPass mVPass) {
        MVPass mVPass2 = new MVPass();
        MVPass mVPass3 = new MVPass();
        double[][] dArray = new double[2][2];
        OIJ.matPassageAbs(oIJ, mVPass2);
        OIJ.matPassageAbs(this, mVPass3);
        double d = mVPass2.getM(1, 1) * mVPass2.getM(0, 0) - mVPass2.getM(0, 1) * mVPass2.getM(1, 0);
        dArray[0][0] = mVPass2.getM(1, 1) / d;
        dArray[0][1] = -mVPass2.getM(0, 1) / d;
        dArray[1][0] = -mVPass2.getM(1, 0) / d;
        dArray[1][1] = mVPass2.getM(0, 0) / d;
        mVPass.setV(0, dArray[0][0] * (mVPass3.getV(0) - mVPass2.getV(0)) + dArray[0][1] * (mVPass3.getV(1) - mVPass2.getV(1)));
        mVPass.setV(1, dArray[1][0] * (mVPass3.getV(0) - mVPass2.getV(0)) + dArray[1][1] * (mVPass3.getV(1) - mVPass2.getV(1)));
        mVPass.setM(0, 0, dArray[0][0] * mVPass3.getM(0, 0) + dArray[0][1] * mVPass3.getM(1, 0));
        mVPass.setM(0, 1, dArray[0][0] * mVPass3.getM(0, 1) + dArray[0][1] * mVPass3.getM(1, 1));
        mVPass.setM(1, 0, dArray[1][0] * mVPass3.getM(0, 0) + dArray[1][1] * mVPass3.getM(1, 0));
        mVPass.setM(1, 1, dArray[1][0] * mVPass3.getM(0, 1) + dArray[1][1] * mVPass3.getM(1, 1));
    }

    private static void matPassageAbs(OIJ oIJ, MVPass mVPass) {
        if (oIJ != null) {
            mVPass.setM(0, 0, oIJ.I[0]);
            mVPass.setM(1, 0, oIJ.I[1]);
            mVPass.setM(0, 1, oIJ.J[0]);
            mVPass.setM(1, 1, oIJ.J[1]);
            mVPass.setV(0, oIJ.oriX);
            mVPass.setV(1, oIJ.oriY);
            if (oIJ.rep != null) {
                MVPass mVPass2 = new MVPass();
                double[][] dArray = new double[2][2];
                dArray[0][0] = mVPass.getM(0, 0);
                dArray[0][1] = mVPass.getM(0, 1);
                dArray[1][0] = mVPass.getM(1, 0);
                dArray[1][1] = mVPass.getM(1, 1);
                OIJ.matPassageAbs(oIJ.rep, mVPass2);
                mVPass.setM(0, 0, mVPass2.getM(0, 0) * dArray[0][0] + mVPass2.getM(0, 1) * dArray[1][0]);
                mVPass.setM(0, 1, mVPass2.getM(0, 0) * dArray[0][1] + mVPass2.getM(0, 1) * dArray[1][1]);
                mVPass.setM(1, 0, mVPass2.getM(1, 0) * dArray[0][0] + mVPass2.getM(1, 1) * dArray[1][0]);
                mVPass.setM(1, 1, mVPass2.getM(1, 0) * dArray[0][1] + mVPass2.getM(1, 1) * dArray[1][1]);
                dArray[0][0] = mVPass.getV(0);
                mVPass.setV(0, mVPass2.getM(0, 0) * mVPass.getV(0) + mVPass2.getM(0, 1) * mVPass.getV(1) + mVPass2.getV(0));
                mVPass.setV(1, mVPass2.getM(1, 0) * dArray[0][0] + mVPass2.getM(1, 1) * mVPass.getV(1) + mVPass2.getV(1));
            }
        } else {
            mVPass.setM(0, 0, 1.0);
            mVPass.setM(1, 0, 0.0);
            mVPass.setM(0, 1, 0.0);
            mVPass.setM(1, 1, 1.0);
            mVPass.setV(0, 0.0);
            mVPass.setV(1, 0.0);
        }
    }

    public final double norm(double d, double d2) {
        return Math.sqrt(this.normSq(d, d2));
    }

    public final double normSq(double d, double d2) {
        return d * d * (this.I[0] * this.I[0] + this.I[1] * this.I[1]) + 2.0 * d * d2 * (this.I[0] * this.J[0] + this.I[1] * this.J[1]) + d2 * d2 * (this.J[0] * this.J[0] + this.J[1] * this.J[1]);
    }

    public void readFile(RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        double d = 1.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0;
        int n = rFile.next();
        if (n != RFile.RF_STRING || !rFile.sval.equals("{")) {
            throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
        }
        n = rFile.next();
        do {
            if (rFile.sval.equals("O")) {
                n = rFile.next();
                if (n != RFile.RF_DOUBLE) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
                }
                this.oriX = rFile.dval;
                n = rFile.next();
                if (n != RFile.RF_DOUBLE) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
                }
                this.oriY = rFile.dval;
                continue;
            }
            if (rFile.sval.equals("I")) {
                n = rFile.next();
                if (n != RFile.RF_DOUBLE) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
                }
                d = rFile.dval;
                n = rFile.next();
                if (n != RFile.RF_DOUBLE) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
                }
                d2 = rFile.dval;
                continue;
            }
            if (!rFile.sval.equals("J")) continue;
            n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
            }
            d3 = rFile.dval;
            n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
            }
            d4 = rFile.dval;
        } while ((n = rFile.next()) != RFile.RF_STRING || !rFile.sval.equals("}"));
        try {
            this.setI(d, d2);
            this.setJ(d3, d4);
        }
        catch (OIJException oIJException) {
            throw new MalformedFileException("Impossible de construire un tel rep\u00e8re.");
        }
    }

    public void setI(double d, double d2) throws OIJException {
        if (!(Math.abs(d * this.J[1] - d2 * this.J[0]) > 1.0E-15)) {
            throw new OIJException("erreur");
        }
        this.I[0] = d;
        this.I[1] = d2;
    }

    public void setJ(double d, double d2) throws OIJException {
        if (!(Math.abs(d * this.I[1] - d2 * this.I[0]) > 1.0E-15)) {
            throw new OIJException("erreur");
        }
        this.J[0] = d;
        this.J[1] = d2;
    }

    public final void setName(String string) {
        this.name = new String(string);
    }

    public void setOIJ(OIJ oIJ) {
        this.rep = oIJ;
    }

    public void setOrigin(double d, double d2) {
        this.oriX = d;
        this.oriY = d2;
    }

    public String toString() {
        return this.name;
    }

    public void writeFile(WFile wFile, Pack2D pack2D) {
        wFile.writeln("{");
        wFile.writeln("O " + this.oriX + " " + this.oriY);
        wFile.writeln("I " + this.I[0] + " " + this.I[1]);
        wFile.writeln("J " + this.J[0] + " " + this.J[1]);
        wFile.writeln("}");
    }
}

