/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.noyau2d;

/**
* Cette classe represente les axes 2D X et Y associ  un <code>Pen2D</code> par
l'intermediaire d'un <code>CoordSystem</code>. Elle implemente <code>GObject2D</code>.
* @author OC
* @version 0.1
*/
public class GAxis2D implements GObject2D,Cloneable
{
//membres privs
private InfoAxis info; //Info sur l'axe
private CoordSystem cs;

/**
* Constructeur par defaut
* @param CoordSystem cs, le systeme de coordonnes.
* @since Opale 0.1
*/
public GAxis2D(CoordSystem cs)
	{
	this.cs = cs;
	info = new InfoAxis();
	}

//definition des methodes de l'interface ObjetGraphique2D

public void draw(Pen2D crayon)
	{
	double tmp=cs.getXmin();
	double tick;
	
	crayon.drawLine(cs.getXmin(),0,cs.getXmax(),0);
	crayon.drawLine(0,cs.getYmin(),0,cs.getYmax());
	
	tick = info.getXtickMax();
	if ( (tick = info.getXtickMax()) > 0)
		while (tmp <= cs.getXmax())
		{
		crayon.drawYtick(tmp,0,5);
		//crayon.drawString(Double.toString(tmp),tmp,-cs.yfromXY(0,2));
		//crayon.drawString(Double.toString(tmp),tmp,0,0,-10);
		tmp+=tick;
		}

	tmp = cs.getXmin();
	if ( (tick = info.getXtickMin()) > 0)
		while (tmp <= cs.getXmax())
		{
		crayon.drawYtick(tmp,0,3);
		tmp+=tick;
		}

	tmp =  cs.getYmin();
	if ( (tick = info.getYtickMax()) > 0)
		while (tmp <= cs.getYmax())
			{
			crayon.drawXtick(0,tmp,5);
			tmp+=tick;
			}
	tmp =  cs.getYmin();
	tick = info.getYtickMin();
	if ( (tick = info.getYtickMin()) > 0)
		while (tmp <= cs.getYmax())
		{
		crayon.drawXtick(0,tmp,3);
		tmp+=tick;
		}

	
	}
	


public InfoObject getInfo()
	{
	return info;
	}

public String toString()
	{
	String s="Axes 2D";
	return s;
	}
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	try
		{
		GAxis2D ax = (GAxis2D) super.clone();
		ax.info = (InfoAxis) info.clone();
		return ax;
		}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
	    throw new InternalError();
		}
    }

}