/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.noyau2d;
import opale.tools.*;

/**
* Cette classe permet de satisfaire la convention applique dans OPALE, selon laquelle les classes de base des objets gomtriques
* s'appelent Nom et les classes graphiques GNom. Elles hritent de
<code>Object2D</code> et implmentent l'interface
* <code>Transformable</code>.
* @author O.C.
* @version 0.1
*/
public class Point2D extends Object2D implements Transformable, Cloneable
{
protected double x,y;

/**
* Constructeur par dfaut.
* @since Opale 0.1
*/
public Point2D()
	{
	super();
	System.out.println("Dans Point2D()");
	}
	

/**
* Initialise le point avec les coordonnes (0; 0) et un repre OIJ donn.
* @param OIJ rep, le repre.
* @since Opale 0.1
*/
public Point2D(OIJ rep)
        {
        super(rep);
        }

/**
* Construit et initialise le point avec les coordonnes x et y, et un repre donn.
* @param OIJ rep, le repre.
* @param double x, y les coordonnes.
* @since Opale 0.1
*/
public Point2D(OIJ rep,double x, double y)
        {
        super(rep);
        this.x = x;
        this.y = y;
        }

/**
* Le constructeur de copie.
* @param Point2D le point  copier.
* @since Opale 0.1
*/
public Point2D(Point2D p)
        {
        super(p.getOIJ());
        this.x = p.x;
        this.y = p.y;
        }

/**
* Renvoie la coordonne x du point.
* @return double, l'abscisse du point.
* @since Opale 0.1
*/
public final double getX()
	{
	return x;
	}
/**
* Renvoie la coordonne y du point.
* @return double, l'ordonn du point.
* @since Opale 0.1
*/
public final double getY()
	{
	return y;
	}
	
/**
* Fixe les coordonnes du point.
* @param double x, double y, les nouvelles coordonnes du point.
* @since Opale 0.1
*/
public final void setLocation(double x, double y)
	{
	this.x = x;
	this.y = y;
	}

/**
* Fixe les coordonnes du point.
* @param Point2D p, les nouvelles coordonnes du point.
* @since Opale 0.1
*/
public final void setLocation(Point2D p)
	{
	Point2D q =(Point2D) p.clone();
	q.changeOIJ(getOIJ());
	
	this.x = q.x;
	this.y = q.y;
	}
	

// les mthodes de l'interface Transformable.

public void translate(double dx,double dy)
	{
	this.x+=dx;
	this.y+=dy;
	}
	

public void rotate(double theta)
	{
	double costh=Math.cos(theta);
	double sinth=Math.sin(theta);

	double x=this.x;

	this.x=x*costh-y*sinth ;
	this.y=x*sinth+this.y*costh ;
	}

public void rotate(double oriX, double oriY,double theta)
	{
	this.translate(-oriX,-oriY);
	this.rotate(theta);
	this.translate(oriX,oriY);
	}



   /*Cette mthode effectue une homothtie de centre A et de rapport k
   *@param A, le centre de l'homothetie
   *@param k, le rapport
   */
   public void homothetie(Point2D A, double k){
          //a verifier
          this.x=k*(this.x-A.x)+A.x ;
          this.y=k*(this.y-A.x)+A.y ;
   }

/**
* Effectue un changement de repere du point.
* @param OIJ rep, le nouveau repere.
* @since Opale 0.1
*/
public void changeOIJ(OIJ rep)
	{
	MVPass mv = new MVPass();
	getOIJ().matPassage(rep,mv);
	
	Point2D p = mv.compute(x,y);
	x = p.x;
	y = p.y;
	setOIJ(rep);
	}
	
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	Point2D p = (Point2D) super.clone();
	p.x = x;
	p.y = y;
	return p;
   	}

/**
* Cette mthode teste si le point est gal  un objet pass en argument.
* @param Object obj un objet  comparer avec le point.
* @return <code>true</code> si l'objet  comparer est une instance de Point2D et
est gal au point courant; <code>false</code> sinon.
* @since Opale 0.1
*/
public boolean equals(Object obj)
	{
	if (obj instanceof Point2D)
		{
        	Point2D p = (Point2D) obj;
		return (x == p.x) && (y == p.y) && (getOIJ().equals(p.getOIJ()));
        	}
    	return false;
    }


public String toString()
	{
	String s="("+this.x+"; "+this.y+")";
	return s;
	}
	
public void writeFileMore(WFile f, Pack2D p)
	{
	f.writeln("X " +x);
	f.writeln("Y " +y);
	}	
	
public int readKeyWord(String word, RFile f, Pack2D p) throws java.io.IOException, MalformedFileException
	{
	int type;
	if ( word.equals("X"))
		{
		type = f.next();
		if (type != RFile.RF_DOUBLE) return -1;
		x = f.dval;
		return 0;
		}
	else if ( word.equals("Y"))
		{
		type = f.next();
		if (type != RFile.RF_DOUBLE) return -1;
		y = f.dval;
		return 0;
		}
	return -1;
		
	}
		
}
