/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

public final class SpecialFunction {
    private static final double MACHEP = (double)1.110223E-16f;
    private static final double MAXLOG = 709.782712893384;
    private static final double MINLOG = -745.1332191019412;
    private static final double MAXGAM = 171.6243769563027;
    private static final double SQTPI = 2.5066282746310007;
    private static final double SQRTH = 0.7071067811865476;
    private static final double LOGPI = 1.1447298858494002;
    public static final double BOLTZMAN = 1.3807E-16;
    public static final double ECHARGE = 4.8032E-10;
    public static final double EMASS = 9.1095E-28;
    public static final double PMASS = 1.6726E-24;
    public static final double GRAV = 6.672E-8;
    public static final double PLANCK = 6.6262E-27;
    public static final double LIGHTSPEED = 2.9979E10;
    public static final double STEFANBOLTZ = 5.6703E-5;
    public static final double AVOGADRO = 6.022E23;
    public static final double GASCONSTANT = 8.3144E7;
    public static final double GRAVACC = 980.67;
    public static final double SOLARMASS = 1.99E33;
    public static final double SOLARRADIUS = 6.96E10;
    public static final double SOLARLUM = 3.9E33;
    public static final double SOLARFLUX = 6.41E10;
    public static final double AU = 1.5E13;

    private SpecialFunction() {
    }

    public static double acosh(double d) throws ArithmeticException {
        if (d < 1.0) {
            throw new ArithmeticException("range exception");
        }
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    public static double asinh(double d) throws ArithmeticException {
        double d2;
        int n;
        if (d == 0.0) {
            return d;
        }
        if (d < 0.0) {
            n = -1;
            d2 = -d;
        } else {
            n = 1;
            d2 = d;
        }
        return (double)n * Math.log(d2 + Math.sqrt(d2 * d2 + 1.0));
    }

    public static double atanh(double d) throws ArithmeticException {
        if (d > 1.0 || d < -1.0) {
            throw new ArithmeticException("range exception");
        }
        return 0.5 * Math.log((1.0 + d) / (1.0 - d));
    }

    public static double chisq(double d, double d2) throws ArithmeticException {
        if (d2 < 0.0 || d < 1.0) {
            return 0.0;
        }
        return SpecialFunction.igam(d / 2.0, d2 / 2.0);
    }

    public static double chisqc(double d, double d2) throws ArithmeticException {
        if (d2 < 0.0 || d < 1.0) {
            return 0.0;
        }
        return SpecialFunction.igamc(d / 2.0, d2 / 2.0);
    }

    public static double cosh(double d) throws ArithmeticException {
        double d2 = d;
        if (d2 < 0.0) {
            d2 = Math.abs(d);
        }
        d2 = Math.exp(d2);
        return 0.5 * (d2 + 1.0 / d2);
    }

    public static double erf(double d) throws ArithmeticException {
        double[] dArray = new double[]{9.604973739870516, 90.02601972038427, 2232.005345946843, 7003.325141128051, 55592.30130103949};
        double[] dArray2 = new double[]{33.56171416475031, 521.3579497801527, 4594.323829709801, 22629.000061389095, 49267.39426086359};
        if (Math.abs(d) > 1.0) {
            return 1.0 - SpecialFunction.erfc(d);
        }
        double d2 = d * d;
        double d3 = d * SpecialFunction.polevl(d2, dArray, 4) / SpecialFunction.p1evl(d2, dArray2, 5);
        return d3;
    }

    public static double erfc(double d) throws ArithmeticException {
        double d2;
        double d3;
        double[] dArray = new double[]{2.461969814735305E-10, 0.5641895648310689, 7.463210564422699, 48.63719709856814, 196.5208329560771, 526.4451949954773, 934.5285271719576, 1027.5518868951572, 557.5353353693994};
        double[] dArray2 = new double[]{13.228195115474499, 86.70721408859897, 354.9377788878199, 975.7085017432055, 1823.9091668790973, 2246.3376081871097, 1656.6630919416134, 557.5353408177277};
        double[] dArray3 = new double[]{0.5641895835477551, 1.275366707599781, 5.019050422511805, 6.160210979930536, 7.4097426995044895, 2.9788666537210022};
        double[] dArray4 = new double[]{2.2605286322011726, 9.396035249380015, 12.048953980809666, 17.08144507475659, 9.608968090632859, 3.369076451000815};
        double d4 = d < 0.0 ? -d : d;
        if (d4 < 1.0) {
            return 1.0 - SpecialFunction.erf(d);
        }
        double d5 = -d * d;
        if (d5 < -709.782712893384) {
            if (d < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        d5 = Math.exp(d5);
        if (d4 < 8.0) {
            d3 = SpecialFunction.polevl(d4, dArray, 8);
            d2 = SpecialFunction.p1evl(d4, dArray2, 8);
        } else {
            d3 = SpecialFunction.polevl(d4, dArray3, 5);
            d2 = SpecialFunction.p1evl(d4, dArray4, 6);
        }
        double d6 = d5 * d3 / d2;
        if (d < 0.0) {
            d6 = 2.0 - d6;
        }
        if (d6 == 0.0) {
            if (d < 0.0) {
                return 2.0;
            }
            return 0.0;
        }
        return d6;
    }

    public static double fac(double d) throws ArithmeticException {
        double d2 = Math.abs(d);
        if (Math.floor(d2) == d2) {
            return SpecialFunction.fac((int)d);
        }
        return SpecialFunction.gamma(d + 1.0);
    }

    public static int fac(int n) throws ArithmeticException {
        int n2 = n;
        int n3 = 1;
        if (n < 0) {
            n2 = Math.abs(n);
        }
        while (n2 > 1) {
            n3 *= n2--;
        }
        if (n < 0) {
            return -n3;
        }
        return n3;
    }

    public static double gamma(double d) throws ArithmeticException {
        double[] dArray = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] dArray2 = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double d2 = 171.6243769563027;
        double d3 = 1.1447298858494002;
        double d4 = Math.abs(d);
        if (d4 > 33.0) {
            if (d < 0.0) {
                double d5 = Math.floor(d4);
                if (d5 == d4) {
                    throw new ArithmeticException("gamma: overflow");
                }
                int n = (int)d5;
                double d6 = d4 - d5;
                if (d6 > 0.5) {
                    d6 = d4 - (d5 += 1.0);
                }
                if ((d6 = d4 * Math.sin(Math.PI * d6)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                d6 = Math.abs(d6);
                d6 = Math.PI / (d6 * SpecialFunction.stirf(d4));
                return -d6;
            }
            return SpecialFunction.stirf(d);
        }
        double d7 = 1.0;
        while (d >= 3.0) {
            d7 *= (d -= 1.0);
        }
        while (d < 0.0) {
            if (d == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (d > -1.0E-9) {
                return d7 / ((1.0 + 0.5772156649015329 * d) * d);
            }
            d7 /= d;
            d += 1.0;
        }
        while (d < 2.0) {
            if (d == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (d < 1.0E-9) {
                return d7 / ((1.0 + 0.5772156649015329 * d) * d);
            }
            d7 /= d;
            d += 1.0;
        }
        if (d == 2.0 || d == 3.0) {
            return d7;
        }
        double d8 = SpecialFunction.polevl(d -= 2.0, dArray, 6);
        d4 = SpecialFunction.polevl(d, dArray2, 7);
        return d7 * d8 / d4;
    }

    public static double ibeta(double d, double d2, double d3) throws ArithmeticException {
        double d4;
        double d5;
        double d6;
        double d7;
        if (d <= 0.0 || d2 <= 0.0) {
            throw new ArithmeticException("ibeta: Domain error!");
        }
        if (d3 <= 0.0 || d3 >= 1.0) {
            if (d3 == 0.0) {
                return 0.0;
            }
            if (d3 == 1.0) {
                return 1.0;
            }
            throw new ArithmeticException("ibeta: Domain error!");
        }
        boolean bl = false;
        if (d2 * d3 <= 1.0 && d3 <= 0.95) {
            double d8 = SpecialFunction.pseries(d, d2, d3);
            return d8;
        }
        double d9 = 1.0 - d3;
        if (d3 > d / (d + d2)) {
            bl = true;
            d7 = d2;
            d6 = d;
            d5 = d3;
            d4 = d9;
        } else {
            d7 = d;
            d6 = d2;
            d5 = d9;
            d4 = d3;
        }
        if (bl && d6 * d4 <= 1.0 && d4 <= 0.95) {
            double d10 = SpecialFunction.pseries(d7, d6, d4);
            d10 = d10 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d10;
            return d10;
        }
        double d11 = d4 * (d7 + d6 - 2.0) - (d7 - 1.0);
        d9 = d11 < 0.0 ? SpecialFunction.incbcf(d7, d6, d4) : SpecialFunction.incbd(d7, d6, d4) / d5;
        d11 = d7 * Math.log(d4);
        double d12 = d6 * Math.log(d5);
        if (d7 + d6 < 171.6243769563027 && Math.abs(d11) < 709.782712893384 && Math.abs(d12) < 709.782712893384) {
            d12 = Math.pow(d5, d6);
            d12 *= Math.pow(d4, d7);
            d12 /= d7;
            d12 *= d9;
            d12 *= SpecialFunction.gamma(d7 + d6) / (SpecialFunction.gamma(d7) * SpecialFunction.gamma(d6));
            if (bl) {
                d12 = d12 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d12;
            }
            return d12;
        }
        d11 += d12 + SpecialFunction.lgamma(d7 + d6) - SpecialFunction.lgamma(d7) - SpecialFunction.lgamma(d6);
        d12 = (d11 += Math.log(d9 / d7)) < -745.1332191019412 ? 0.0 : Math.exp(d11);
        if (bl) {
            d12 = d12 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d12;
        }
        return d12;
    }

    public static double igam(double d, double d2) throws ArithmeticException {
        if (d2 <= 0.0 || d <= 0.0) {
            return 0.0;
        }
        if (d2 > 1.0 && d2 > d) {
            return 1.0 - SpecialFunction.igamc(d, d2);
        }
        double d3 = d * Math.log(d2) - d2 - SpecialFunction.lgamma(d);
        if (d3 < -709.782712893384) {
            return 0.0;
        }
        d3 = Math.exp(d3);
        double d4 = d;
        double d5 = 1.0;
        double d6 = 1.0;
        while ((d5 *= d2 / (d4 += 1.0)) / (d6 += d5) > (double)1.110223E-16f) {
        }
        return d6 * d3 / d;
    }

    public static double igamc(double d, double d2) throws ArithmeticException {
        double d3;
        double d4 = 4.503599627370496E15;
        double d5 = 2.220446049250313E-16;
        if (d2 <= 0.0 || d <= 0.0) {
            return 1.0;
        }
        if (d2 < 1.0 || d2 < d) {
            return 1.0 - SpecialFunction.igam(d, d2);
        }
        double d6 = d * Math.log(d2) - d2 - SpecialFunction.lgamma(d);
        if (d6 < -709.782712893384) {
            return 0.0;
        }
        d6 = Math.exp(d6);
        double d7 = 1.0 - d;
        double d8 = d2 + d7 + 1.0;
        double d9 = 0.0;
        double d10 = 1.0;
        double d11 = d2;
        double d12 = d2 + 1.0;
        double d13 = d8 * d2;
        double d14 = d12 / d13;
        do {
            double d15 = (d7 += 1.0) * (d9 += 1.0);
            double d16 = d12 * (d8 += 2.0) - d10 * d15;
            double d17 = d13 * d8 - d11 * d15;
            if (d17 != 0.0) {
                double d18 = d16 / d17;
                d3 = Math.abs((d14 - d18) / d18);
                d14 = d18;
            } else {
                d3 = 1.0;
            }
            d10 = d12;
            d12 = d16;
            d11 = d13;
            d13 = d17;
            if (!(Math.abs(d16) > d4)) continue;
            d10 *= d5;
            d12 *= d5;
            d11 *= d5;
            d13 *= d5;
        } while (d3 > (double)1.110223E-16f);
        return d14 * d6;
    }

    private static double incbcf(double d, double d2, double d3) throws ArithmeticException {
        double d4 = 4.503599627370496E15;
        double d5 = 2.220446049250313E-16;
        double d6 = d;
        double d7 = d + d2;
        double d8 = d;
        double d9 = d + 1.0;
        double d10 = 1.0;
        double d11 = d2 - 1.0;
        double d12 = d9;
        double d13 = d + 2.0;
        double d14 = 0.0;
        double d15 = 1.0;
        double d16 = 1.0;
        double d17 = 1.0;
        double d18 = 1.0;
        double d19 = 1.0;
        int n = 0;
        double d20 = 3.330669E-16f;
        do {
            double d21;
            double d22 = -(d3 * d6 * d7) / (d8 * d9);
            double d23 = d16 + d14 * d22;
            double d24 = d17 + d15 * d22;
            d14 = d16;
            d16 = d23;
            d15 = d17;
            d17 = d24;
            d22 = d3 * d10 * d11 / (d12 * d13);
            d23 = d16 + d14 * d22;
            d24 = d17 + d15 * d22;
            d14 = d16;
            d16 = d23;
            d15 = d17;
            d17 = d24;
            if (d24 != 0.0) {
                d19 = d23 / d24;
            }
            if (d19 != 0.0) {
                d21 = Math.abs((d18 - d19) / d19);
                d18 = d19;
            } else {
                d21 = 1.0;
            }
            if (d21 < d20) {
                return d18;
            }
            d6 += 1.0;
            d7 += 1.0;
            d8 += 2.0;
            d9 += 2.0;
            d10 += 1.0;
            d11 -= 1.0;
            d12 += 2.0;
            d13 += 2.0;
            if (Math.abs(d24) + Math.abs(d23) > d4) {
                d14 *= d5;
                d16 *= d5;
                d15 *= d5;
                d17 *= d5;
            }
            if (!(Math.abs(d24) < d5) && !(Math.abs(d23) < d5)) continue;
            d14 *= d4;
            d16 *= d4;
            d15 *= d4;
            d17 *= d4;
        } while (++n < 300);
        return d18;
    }

    private static double incbd(double d, double d2, double d3) throws ArithmeticException {
        double d4 = 4.503599627370496E15;
        double d5 = 2.220446049250313E-16;
        double d6 = d;
        double d7 = d2 - 1.0;
        double d8 = d;
        double d9 = d + 1.0;
        double d10 = 1.0;
        double d11 = d + d2;
        double d12 = d + 1.0;
        double d13 = d + 2.0;
        double d14 = 0.0;
        double d15 = 1.0;
        double d16 = 1.0;
        double d17 = 1.0;
        double d18 = d3 / (1.0 - d3);
        double d19 = 1.0;
        double d20 = 1.0;
        int n = 0;
        double d21 = 3.330669E-16f;
        do {
            double d22;
            double d23 = -(d18 * d6 * d7) / (d8 * d9);
            double d24 = d16 + d14 * d23;
            double d25 = d17 + d15 * d23;
            d14 = d16;
            d16 = d24;
            d15 = d17;
            d17 = d25;
            d23 = d18 * d10 * d11 / (d12 * d13);
            d24 = d16 + d14 * d23;
            d25 = d17 + d15 * d23;
            d14 = d16;
            d16 = d24;
            d15 = d17;
            d17 = d25;
            if (d25 != 0.0) {
                d20 = d24 / d25;
            }
            if (d20 != 0.0) {
                d22 = Math.abs((d19 - d20) / d20);
                d19 = d20;
            } else {
                d22 = 1.0;
            }
            if (d22 < d21) {
                return d19;
            }
            d6 += 1.0;
            d7 -= 1.0;
            d8 += 2.0;
            d9 += 2.0;
            d10 += 1.0;
            d11 += 1.0;
            d12 += 2.0;
            d13 += 2.0;
            if (Math.abs(d25) + Math.abs(d24) > d4) {
                d14 *= d5;
                d16 *= d5;
                d15 *= d5;
                d17 *= d5;
            }
            if (!(Math.abs(d25) < d5) && !(Math.abs(d24) < d5)) continue;
            d14 *= d4;
            d16 *= d4;
            d15 *= d4;
            d17 *= d4;
        } while (++n < 300);
        return d19;
    }

    public static double j0(double d) throws ArithmeticException {
        double d2;
        double d3 = Math.abs(d);
        if (d2 < 8.0) {
            double d4 = d * d;
            double d5 = 5.7568490574E10 + d4 * (-1.3362590354E10 + d4 * (6.516196407E8 + d4 * (-1.121442418E7 + d4 * (77392.33017 + d4 * -184.9052456))));
            double d6 = 5.7568490411E10 + d4 * (1.029532985E9 + d4 * (9494680.718 + d4 * (59272.64853 + d4 * (267.8532712 + d4))));
            return d5 / d6;
        }
        double d7 = 8.0 / d3;
        double d8 = d7 * d7;
        double d9 = d3 - 0.785398164;
        double d10 = 1.0 + d8 * (-0.001098628627 + d8 * (2.734510407E-5 + d8 * (-2.073370639E-6 + d8 * 2.093887211E-7)));
        double d11 = -0.01562499995 + d8 * (1.430488765E-4 + d8 * (-6.911147651E-6 + d8 * (7.621095161E-7 - d8 * 9.34935152E-8)));
        return Math.sqrt(0.636619772 / d3) * (Math.cos(d9) * d10 - d7 * Math.sin(d9) * d11);
    }

    public static double j1(double d) throws ArithmeticException {
        double d2;
        double d3 = Math.abs(d);
        if (d2 < 8.0) {
            double d4 = d * d;
            double d5 = d * (7.2362614232E10 + d4 * (-7.895059235E9 + d4 * (2.423968531E8 + d4 * (-2972611.439 + d4 * (15704.4826 + d4 * -30.16036606)))));
            double d6 = 1.44725228442E11 + d4 * (2.300535178E9 + d4 * (1.858330474E7 + d4 * (99447.43394 + d4 * (376.9991397 + d4))));
            return d5 / d6;
        }
        double d7 = 8.0 / d3;
        double d8 = d3 - 2.356194491;
        double d9 = d7 * d7;
        double d10 = 1.0 + d9 * (0.00183105 + d9 * (-3.516396496E-5 + d9 * (2.457520174E-6 + d9 * -2.40337019E-7)));
        double d11 = 0.04687499995 + d9 * (-2.002690873E-4 + d9 * (8.449199096E-6 + d9 * (-8.8228987E-7 + d9 * 1.05787412E-7)));
        double d12 = Math.sqrt(0.636619772 / d3) * (Math.cos(d8) * d10 - d7 * Math.sin(d8) * d11);
        if (d < 0.0) {
            d12 = -d12;
        }
        return d12;
    }

    public static double jn(int n, double d) throws ArithmeticException {
        double d2;
        double d3 = 40.0;
        double d4 = 1.0E10;
        double d5 = 1.0E-10;
        if (n == 0) {
            return SpecialFunction.j0(d);
        }
        if (n == 1) {
            return SpecialFunction.j1(d);
        }
        double d6 = Math.abs(d);
        if (d6 == 0.0) {
            return 0.0;
        }
        if (d6 > (double)n) {
            double d7 = 2.0 / d6;
            double d8 = SpecialFunction.j0(d6);
            double d9 = SpecialFunction.j1(d6);
            int n2 = 1;
            while (n2 < n) {
                double d10 = (double)n2 * d7 * d9 - d8;
                d8 = d9;
                d9 = d10;
                ++n2;
            }
            d2 = d9;
        } else {
            double d11 = 2.0 / d6;
            int n3 = 2 * ((n + (int)Math.sqrt(d3 * (double)n)) / 2);
            boolean bl = false;
            double d12 = 0.0;
            d2 = 0.0;
            double d13 = 0.0;
            double d14 = 1.0;
            int n4 = n3;
            while (n4 > 0) {
                double d15 = (double)n4 * d11 * d14 - d13;
                d13 = d14;
                d14 = d15;
                if (Math.abs(d14) > d4) {
                    d14 *= d5;
                    d13 *= d5;
                    d2 *= d5;
                    d12 *= d5;
                }
                if (bl) {
                    d12 += d14;
                }
                bl ^= true;
                if (n4 == n) {
                    d2 = d13;
                }
                --n4;
            }
            d12 = 2.0 * d12 - d14;
            d2 /= d12;
        }
        return d < 0.0 && n % 2 == 1 ? -d2 : d2;
    }

    private static double lgamma(double d) throws ArithmeticException {
        double[] dArray = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] dArray2 = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] dArray3 = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (d < -34.0) {
            double d2 = -d;
            double d3 = SpecialFunction.lgamma(d2);
            double d4 = Math.floor(d2);
            if (d4 == d2) {
                throw new ArithmeticException("lgam: Overflow");
            }
            double d5 = d2 - d4;
            if (d5 > 0.5) {
                d5 = (d4 += 1.0) - d2;
            }
            if ((d5 = d2 * Math.sin(Math.PI * d5)) == 0.0) {
                throw new ArithmeticException("lgamma: Overflow");
            }
            d5 = 1.1447298858494002 - Math.log(d5) - d3;
            return d5;
        }
        if (d < 13.0) {
            double d6 = 1.0;
            while (d >= 3.0) {
                d6 *= (d -= 1.0);
            }
            while (d < 2.0) {
                if (d == 0.0) {
                    throw new ArithmeticException("lgamma: Overflow");
                }
                d6 /= d;
                d += 1.0;
            }
            if (d6 < 0.0) {
                d6 = -d6;
            }
            if (d == 2.0) {
                return Math.log(d6);
            }
            double d7 = (d -= 2.0) * SpecialFunction.polevl(d, dArray2, 5) / SpecialFunction.p1evl(d, dArray3, 6);
            return Math.log(d6) + d7;
        }
        if (d > 2.556348E305) {
            throw new ArithmeticException("lgamma: Overflow");
        }
        double d8 = (d - 0.5) * Math.log(d) - d + 0.9189385332046728;
        if (d > 1.0E8) {
            return d8;
        }
        double d9 = 1.0 / (d * d);
        d8 = d >= 1000.0 ? (d8 += ((7.936507936507937E-4 * d9 - 0.002777777777777778) * d9 + 0.08333333333333333) / d) : (d8 += SpecialFunction.polevl(d9, dArray, 4) / d);
        return d8;
    }

    public static double log10(double d) throws ArithmeticException {
        if (d <= 0.0) {
            throw new ArithmeticException("range exception");
        }
        return Math.log(d) / 2.302585092994046;
    }

    public static double normal(double d) throws ArithmeticException {
        double d2;
        double d3 = d * 0.7071067811865476;
        double d4 = Math.abs(d3);
        if (d4 < 0.7071067811865476) {
            d2 = 0.5 + 0.5 * SpecialFunction.erf(d3);
        } else {
            d2 = 0.5 * SpecialFunction.erfc(d4);
            if (d3 > 0.0) {
                d2 = 1.0 - d2;
            }
        }
        return d2;
    }

    private static double p1evl(double d, double[] dArray, int n) throws ArithmeticException {
        double d2 = d + dArray[0];
        int n2 = 1;
        while (n2 < n) {
            d2 = d2 * d + dArray[n2];
            ++n2;
        }
        return d2;
    }

    public static double poisson(int n, double d) throws ArithmeticException {
        if (n < 0 || d < 0.0) {
            return 0.0;
        }
        return SpecialFunction.igamc(n + 1, d);
    }

    public static double poissonc(int n, double d) throws ArithmeticException {
        if (n < 0 || d < 0.0) {
            return 0.0;
        }
        return SpecialFunction.igam(n + 1, d);
    }

    private static double polevl(double d, double[] dArray, int n) throws ArithmeticException {
        double d2 = dArray[0];
        int n2 = 1;
        while (n2 <= n) {
            d2 = d2 * d + dArray[n2];
            ++n2;
        }
        return d2;
    }

    private static double pseries(double d, double d2, double d3) throws ArithmeticException {
        double d4;
        double d5 = 1.0 / d;
        double d6 = (1.0 - d2) * d3;
        double d7 = d4 = d6 / (d + 1.0);
        double d8 = d6;
        double d9 = 2.0;
        double d10 = 0.0;
        double d11 = (double)1.110223E-16f * d5;
        while (Math.abs(d4) > d11) {
            d6 = (d9 - d2) * d3 / d9;
            d4 = (d8 *= d6) / (d + d9);
            d10 += d4;
            d9 += 1.0;
        }
        d10 += d7;
        d10 += d5;
        d6 = d * Math.log(d3);
        if (d + d2 < 171.6243769563027 && Math.abs(d6) < 709.782712893384) {
            d8 = SpecialFunction.gamma(d + d2) / (SpecialFunction.gamma(d) * SpecialFunction.gamma(d2));
            d10 = d10 * d8 * Math.pow(d3, d);
        } else {
            d8 = SpecialFunction.lgamma(d + d2) - SpecialFunction.lgamma(d) - SpecialFunction.lgamma(d2) + d6 + Math.log(d10);
            d10 = d8 < -745.1332191019412 ? 0.0 : Math.exp(d8);
        }
        return d10;
    }

    public static double sinh(double d) throws ArithmeticException {
        if (d == 0.0) {
            return d;
        }
        double d2 = d;
        if (d2 < 0.0) {
            d2 = Math.abs(d);
        }
        d2 = Math.exp(d2);
        if (d < 0.0) {
            return -0.5 * (d2 - 1.0 / d2);
        }
        return 0.5 * (d2 - 1.0 / d2);
    }

    private static double stirf(double d) throws ArithmeticException {
        double[] dArray = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double d2 = 143.01608;
        double d3 = 1.0 / d;
        double d4 = Math.exp(d);
        d3 = 1.0 + d3 * SpecialFunction.polevl(d3, dArray, 4);
        if (d > d2) {
            double d5 = Math.pow(d, 0.5 * d - 0.25);
            d4 = d5 * (d5 / d4);
        } else {
            d4 = Math.pow(d, d - 0.5) / d4;
        }
        d4 = 2.5066282746310007 * d4 * d3;
        return d4;
    }

    public static double tanh(double d) throws ArithmeticException {
        if (d == 0.0) {
            return d;
        }
        double d2 = d;
        if (d2 < 0.0) {
            d2 = Math.abs(d);
        }
        d2 = Math.exp(2.0 * d2);
        if (d < 0.0) {
            return -(1.0 - 2.0 / (d2 + 1.0));
        }
        return 1.0 - 2.0 / (d2 + 1.0);
    }

    public static double y0(double d) throws ArithmeticException {
        if (d < 8.0) {
            double d2 = d * d;
            double d3 = -2.957821389E9 + d2 * (7.062834065E9 + d2 * (-5.123598036E8 + d2 * (1.087988129E7 + d2 * (-86327.92757 + d2 * 228.4622733))));
            double d4 = 4.0076544269E10 + d2 * (7.452499648E8 + d2 * (7189466.438 + d2 * (47447.2647 + d2 * (226.1030244 + d2))));
            return d3 / d4 + 0.636619772 * SpecialFunction.j0(d) * Math.log(d);
        }
        double d5 = 8.0 / d;
        double d6 = d5 * d5;
        double d7 = d - 0.785398164;
        double d8 = 1.0 + d6 * (-0.001098628627 + d6 * (2.734510407E-5 + d6 * (-2.073370639E-6 + d6 * 2.093887211E-7)));
        double d9 = -0.01562499995 + d6 * (1.430488765E-4 + d6 * (-6.911147651E-6 + d6 * (7.621095161E-7 + d6 * -9.34945152E-8)));
        return Math.sqrt(0.636619772 / d) * (Math.sin(d7) * d8 + d5 * Math.cos(d7) * d9);
    }

    public static double y1(double d) throws ArithmeticException {
        if (d < 8.0) {
            double d2 = d * d;
            double d3 = d * (-4.900604943E12 + d2 * (1.27527439E12 + d2 * (-5.153438139E10 + d2 * (7.349264551E8 + d2 * (-4237922.726 + d2 * 8511.937935)))));
            double d4 = 2.49958057E13 + d2 * (4.244419664E11 + d2 * (3.733650367E9 + d2 * (2.245904002E7 + d2 * (102042.605 + d2 * (354.9632885 + d2)))));
            return d3 / d4 + 0.636619772 * (SpecialFunction.j1(d) * Math.log(d) - 1.0 / d);
        }
        double d5 = 8.0 / d;
        double d6 = d5 * d5;
        double d7 = d - 2.356194491;
        double d8 = 1.0 + d6 * (0.00183105 + d6 * (-3.516396496E-5 + d6 * (2.457520174E-6 + d6 * -2.40337019E-7)));
        double d9 = 0.04687499995 + d6 * (-2.002690873E-4 + d6 * (8.449199096E-6 + d6 * (-8.8228987E-7 + d6 * 1.05787412E-7)));
        return Math.sqrt(0.636619772 / d) * (Math.sin(d7) * d8 + d5 * Math.cos(d7) * d9);
    }

    public static double yn(int n, double d) throws ArithmeticException {
        if (n == 0) {
            return SpecialFunction.y0(d);
        }
        if (n == 1) {
            return SpecialFunction.y1(d);
        }
        double d2 = 2.0 / d;
        double d3 = SpecialFunction.y1(d);
        double d4 = SpecialFunction.y0(d);
        int n2 = 1;
        while (n2 < n) {
            double d5 = (double)n2 * d2 * d3 - d4;
            d4 = d3;
            d3 = d5;
            ++n2;
        }
        return d3;
    }
}

