/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.noyau2d;
import java.awt.*;

/**
* Cette classe modelise un systme de coordonnes utilisateur 2D cartsien. Elle tend la classe de base de tous les systmes de coordonnes <code> CoordSystem</code>.
* @author OC
* @version 0.1
*/

public class LinLinCS extends CoordSystem
{
private double stepX,stepY; //pas sur les axes
private double originX, originY;	// les coordonnes du centre

/**
* Constructeur du systme de coordonnes  partir des dimensions de la future fenetre d'affichage.
* @param int x, y les coordonnes du coin suprieur gauche.
* @param int w,h la largeur et la hauteur.
* @since Opale 0.1
*/
public LinLinCS(int x, int y, int w, int h)
	{
	setSize(x,y,w,h);
	try
	{
	oij = new OIJ(null,0,0,1,0,0,1);
	autoadjust();
	}
	catch(OIJException e)
	{}
	}

/**
* Constructeur du systme de coordonnes  partir des dimensions de la future fenetre d'affichage, et d'un repre OIJ.
* @param OIJ oij, le repre  attacher au systme de coordonnes.
* @param int x, y les coordonnes du coin suprieur gauche.
* @param int w,h la largeur et la hauteur.
* @since Opale 0.1
*/
public LinLinCS(OIJ oij,int x, int y, int w, int h)
	{
	setSize(x,y,w,h);
	setOIJ(oij);
	autoadjust();
	}


public void autoadjust()
	{
	double normI = Math.sqrt(oij.I[0]*oij.I[0]+oij.I[1]*oij.I[1]);
	double normJ = Math.sqrt(oij.J[0]*oij.J[0]+oij.J[1]*oij.J[1]);
	stepX=width/(xmax-xmin)/normI;
	stepY=height/(ymax-ymin)/normJ;

	originX=(int) (borderX-xmin*stepX*normI);
	originY=(int) (borderY+ymax*stepY*normJ);
	}

public void normadjust()
	{
	double normI = Math.sqrt(oij.I[0]*oij.I[0]+oij.I[1]*oij.I[1]);
	double normJ = Math.sqrt(oij.J[0]*oij.J[0]+oij.J[1]*oij.J[1]);
	stepX=stepY = Math.min(width/(xmax-xmin)/normI,height/(ymax-ymin)/normJ);

	width = (int) ((xmax-xmin)*stepX*normI);
	height = (int) ((ymax-ymin)*stepX*normJ);
	
	originX=(int) (borderX-xmin*stepX*normI);
	originY=(int) (borderY+ymax*stepY*normJ);
	}
	
public final int X(double x, double y)
	{
	return (int) (originX+x*stepX*oij.I[0]+y*stepY*oij.J[0]);
	}

public final int Y(double x, double y)
	{
	return (int) (originY-x*stepX*oij.I[1]-y*stepY*oij.J[1]);
	}

public final double xfromXY(int X, int Y)
	{
	return (double) oij.oriX + ((X-originX)*oij.J[1]-(Y-originY)*oij.J[0])/(stepX*(oij.I[0]*oij.J[1]-oij.I[1]*oij.J[0]));
	}

public final double yfromXY(int X, int Y)
	{
	return (double) oij.oriY + ((Y-originY)*oij.I[0]-(X-originX)*oij.I[1])/(stepY*(-oij.I[0]*oij.J[1]+oij.I[1]*oij.J[0]));
	}

public final double normSq(double x, double y)
	{
	return oij.normSq(x,y);
	}


	
}