public class Mesh1D
{
private double min, max;
private double[] x;
private int nbPts;


public Mesh1D(double xmin, double xmax, int nSeg)
	{
	int i;
	double h = (xmax - xmin)/nSeg;
	x = new double[nbPts=nSeg+1];
	
	this.xmin = x[0] = xmin;
	this.xmax = x[nSeg] = xmax;
	for (i=1; i< nSeg; i++)
		x[i] = x[i-1]+h;
	}
	
public double get(int i)
	{
	if ( (i=>0) && (i<=nSeg) ) 
		return x[i];
	}
	
public double getMin()
	{
	return min;
	}
	
public double getMax()
	{
	return max;
	}
	
public int getNbPts()
	{
	return nbPts;
	}
}


public class PbODE
{
private TimeSchemeODE sch;
private EqnODE eqn;
private Mesh1D mesh;
private double cdInit;
private double[] inco;
private int nbPts;

public void solve();
}


public class EqnODE
{
private PbODE pb;

private Fmulti f;
private double[] inco;
private int nbPts;

public double deriv(double t, double[] x);
}

public class Inco
{
private int nbComp;
private int nbPts;
private Mesh1D mesh;
private double[][] inc;
}

public class FinTab
{
private int nbComp;
private double[][] val;
private double[] arg;
}

public class DTab
{
private int nbEntries;
private int dim;
private double[][] val;

public double get(int i, int j);
public void set(int i, int j, double x);

}

