/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.ker;

import java.io.IOException;
import opale.m2d.ker.InfoObject;
import opale.m2d.ker.MalformedFileException;
import opale.m2d.ker.Pack2D;
import opale.tools.RFile;
import opale.tools.WFile;

public class InfoPoint
extends InfoObject
implements Cloneable {
    protected int symbol;
    protected int size;
    protected int fill;

    public InfoPoint() {
        this.symbol = 0;
        this.size = 1;
        this.fill = 0;
    }

    public InfoPoint(InfoPoint infoPoint) {
        super(infoPoint);
        this.symbol = infoPoint.getSymbol();
        this.size = infoPoint.getSize();
        this.fill = infoPoint.getFill();
    }

    public int getSymbol() {
        return this.symbol;
    }

    public void setSymbol(int n) {
        this.symbol = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getFill() {
        return this.fill;
    }

    public void setFill(int n) {
        this.fill = n;
    }

    public Object clone() {
        return (InfoPoint)super.clone();
    }

    public void writeFileMore(WFile wFile, Pack2D pack2D) {
        wFile.writeln("\tSYMBOL " + this.symbol);
        wFile.writeln("\tSIZE " + this.size);
    }

    public int readKeyWord(String string, RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        if (string.equals("SYMBOL")) {
            int n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                return -1;
            }
            this.symbol = (int)rFile.dval;
            return 0;
        }
        if (string.equals("SIZE")) {
            int n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                return -1;
            }
            this.size = (int)rFile.dval;
            return 0;
        }
        return -1;
    }
}

