/*
 * Decompiled with CFR 0.152.
 */
package opale.ode.ker;

import java.io.IOException;
import java.util.Date;
import opale.mathtools.DVect;
import opale.ode.ker.Equation;
import opale.ode.ker.MalformedFileException;
import opale.ode.ker.ODE;
import opale.ode.ker.ObjectODE;
import opale.ode.ker.SEquation;
import opale.ode.ker.TimeScheme;
import opale.tools.RFile;
import opale.tools.WFile;

public final class Problem
extends ObjectODE {
    private TimeScheme sch;
    private Equation eqn;
    private DVect cdinit;
    private DVect[] inco;
    private double[] times;
    private int dim;
    private boolean issolve = false;

    public Problem() {
        this.dim = 1;
        this.cdinit = new DVect(this.dim);
    }

    public Problem(int n) {
        this.dim = Math.max(n, 1);
        this.cdinit = new DVect(this.dim);
    }

    public void solve() {
        this.issolve = false;
        System.err.println("\n**************************************************");
        System.err.println("************ R\u00e9solution d'un probl\u00e8me ************");
        System.err.println("**************************************************");
        System.err.println("*** V\u00e9rification des composants du probl\u00e8me ***");
        if (this.eqn == null) {
            System.err.println("Vous n'avez pas associ\u00e9 d'\u00e9quation au probl\u00e8me.\nArret anormal du calcul.");
            System.exit(-1);
        }
        if (this.dim != this.eqn.dim()) {
            System.err.println("L'\u00e9quation et le probl\u00e8me n'ont pas la m\u00eame dimension.\nArret anormal.");
            System.exit(-1);
        }
        System.err.println(" --> Equation OK");
        if (this.sch == null) {
            System.err.println("Vous n'avez pas associ\u00e9 de sch\u00e9ma en temps au probl\u00e8me.\nArret anormal du calcul.");
            System.exit(-1);
        }
        System.err.println(" --> Sch\u00e9ma utilis\u00e9 : " + this.sch);
        System.err.println(" --> Conditions initiales : ");
        int n = 0;
        while (n < this.dim) {
            System.err.println("\t" + this.cdinit.get(n));
            ++n;
        }
        System.err.println("*** Probl\u00e8me OK ***\n");
        System.err.println("*** R\u00e9servation m\u00e9moire pour l'inconnu ***\n");
        this.inco = new DVect[this.sch.getNstep()];
        n = 0;
        while (n < this.sch.getNstep()) {
            this.inco[n] = new DVect(this.dim);
            ++n;
        }
        this.times = new double[this.sch.getNstep()];
        System.err.println("*** Initialisation du sch\u00e9ma en temps ***\n");
        this.sch.init();
        this.inco[0].set(this.sch.present());
        this.times[0] = this.sch.tmin();
        System.err.println("*** D\u00e9but du calcul ***");
        Date date = new Date();
        n = 1;
        while (n < this.sch.getNstep()) {
            this.sch.forward(this.eqn);
            this.sch.update();
            this.inco[n].set(this.sch.present());
            this.times[n] = this.sch.time();
            ++n;
        }
        Date date2 = new Date();
        System.err.println("*** Fin du calcul ***");
        System.err.println("*** Temps pass\u00e9 pour ce calcul : " + (date2.getTime() - date.getTime()) + " ms\n");
        System.err.println("**********************************************");
        System.err.println("************ Fin de la r\u00e9solution ************");
        System.err.println("**********************************************\n");
        this.issolve = true;
    }

    public String printSol() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.issolve) {
            int n = 0;
            while (n < this.sch.getNstep()) {
                stringBuffer.append(this.times[n] + " ");
                int n2 = 0;
                while (n2 < this.dim) {
                    stringBuffer.append(this.inco[n].get(n2) + " ");
                    ++n2;
                }
                stringBuffer.append("\n");
                ++n;
            }
        } else {
            stringBuffer.append("Probl\u00e8me pas encore r\u00e9solu\n");
        }
        return stringBuffer.toString();
    }

    public double[][] toTab() {
        if (this.issolve) {
            double[][] dArray = new double[this.dim + 1][this.sch.getNstep()];
            int n = 0;
            while (n < this.sch.getNstep()) {
                dArray[0][n] = this.times[n];
                int n2 = 1;
                while (n2 <= this.dim) {
                    dArray[n2][n] = this.inco[n].get(n2 - 1);
                    ++n2;
                }
                ++n;
            }
            return dArray;
        }
        return null;
    }

    public void writeSol(WFile wFile) {
        wFile.write(this.printSol());
    }

    public int dim() {
        return this.dim;
    }

    public void setInit(DVect dVect) {
        this.cdinit.set(dVect);
    }

    public DVect getInit() {
        return this.cdinit;
    }

    public void setEqn(Equation equation) {
        if (this.dim != equation.dim()) {
            System.err.println("L'\u00e9quation et le probl\u00e8me n'ont pas la m\u00eame dimension.\nArret anormal.");
            System.exit(-1);
        }
        this.eqn = equation;
    }

    public Equation getEqn() {
        return this.eqn;
    }

    public void setTS(TimeScheme timeScheme) {
        this.sch = timeScheme;
        timeScheme.setPb(this);
    }

    public TimeScheme getTS() {
        return this.sch;
    }

    public int readKeyWord(String string, RFile rFile, ODE oDE) throws IOException, MalformedFileException {
        if (string.equals("dim")) {
            int n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                return -1;
            }
            this.dim = (int)rFile.dval;
            this.cdinit = new DVect(this.dim);
            return 0;
        }
        if (string.equals("y0")) {
            int n = 0;
            while (n < this.dim) {
                int n2 = rFile.next();
                if (n2 != RFile.RF_DOUBLE) {
                    return -1;
                }
                this.cdinit.set(n, rFile.dval);
                ++n;
            }
            return 0;
        }
        if (string.equals("sch")) {
            int n = rFile.next();
            if (n != RFile.RF_STRING) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : erreur \u00e0 la lecture d'un sch\u00e9ma en temps attach\u00e9 \u00e0 un probl\u00e8me");
            }
            if (!oDE.contains(rFile.sval) || oDE.fromId(rFile.sval) == null) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : l'identificateur " + rFile.sval + " n'existe pas !!");
            }
            if (!(oDE.fromId(rFile.sval) instanceof TimeScheme)) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : l'identificateur " + rFile.sval + " ne correspond pas \u00e0 un sch\u00e9ma en temps !!");
            }
            this.setTS((TimeScheme)oDE.fromId(rFile.sval));
            return 0;
        }
        if (string.equals("eqn")) {
            int n = rFile.next();
            if (n != RFile.RF_STRING) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : erreur \u00e0 la lecture d'une \u00e9quation attach\u00e9e \u00e0 un probl\u00e8me");
            }
            if (!oDE.contains(rFile.sval) || oDE.fromId(rFile.sval) == null) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : l'identificateur " + rFile.sval + " n'existe pas !!");
            }
            if (!(oDE.fromId(rFile.sval) instanceof Equation)) {
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : l'identificateur " + rFile.sval + " ne correspond pas \u00e0 une \u00e9quation !!");
            }
            this.setEqn((Equation)((Object)oDE.fromId(rFile.sval)));
            return 0;
        }
        return -1;
    }

    public void writeFile(WFile wFile, ODE oDE) throws MalformedFileException {
        wFile.writeln("{");
        if (!oDE.contains(this.sch)) {
            throw new MalformedFileException("Erreur \u00e0 l'\u00e9criture du fichier : le sch\u00e9ma en temps " + this.sch + " n'existe pas !!");
        }
        if (!(this.eqn instanceof ObjectODE)) {
            throw new MalformedFileException("Erreur \u00e0 l'\u00e9criture du fichier : l'equation " + this.eqn + " de type " + this.eqn.getClass() + " n'est pas inscriptible dans un fichier !!");
        }
        if (!oDE.contains((ObjectODE)((Object)this.eqn))) {
            throw new MalformedFileException("Erreur \u00e0 l'\u00e9criture du fichier : l'equation " + this.eqn + " n'existe pas !!");
        }
        wFile.writeln("dim " + this.dim);
        wFile.write("y0");
        int n = 0;
        while (n < this.dim) {
            wFile.write(" " + this.cdinit.get(n));
            ++n;
        }
        wFile.writeln("");
        wFile.writeln("sch " + oDE.getId(this.sch));
        wFile.writeln("eqn " + oDE.getId((SEquation)this.eqn));
        wFile.writeln("}");
    }

    public String toString() {
        return "Problem of ODE";
    }
}

