import opale.tools.*;
import opale.mathtools.*;
import opale.ode.ker.*;
import opale.ode.scheme.*;


public class ee2d
	{
	
	public static void main(String[] arg)
	{
	
	Problem pb = new Problem(2);
	ExplicitEuler ts = new ExplicitEuler();
	pb.setEqn(
		new Equation()
			{
			double[] y = new double[2];
			public int dim() { return 2; }
			public double[] deriv(double t, double[] x)
				{
				y[0]=-x[0]*x[0]+x[0]*x[1];
				y[1]=-x[1]*x[1]-x[0]*x[1];
				return y;
				}
			}
		);
	DVect cd = new DVect(2);
	cd.set(0,1);
	cd.set(1,1);
	pb.setInit(cd);
	ts.set(0,100);
	ts.setNstep(500);
	pb.setTS(ts);
	pb.solve();
	
	try
	{
	WFile wf = new WFile("resu1.txt");
	pb.writeSol(wf);
	wf.writeln("");
	wf.close();
	}
	catch(java.io.IOException e)
	{}	


	}

}
