/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;
import opale.tools.*;

/**
* Cette classe reprsente un point du plan
* Elle contient plusieurs mthodes utiles
* pour la gomtrie euclidienne
* @author O.C.
* @version 0.1
*/

public class GPoint2D extends Point2D implements GObject2D, Cloneable
{
//membres privs
private InfoPoint info; //Info sur le point

/**
* Constructeur par dfaut.
* @since Opale 0.1
*/
public GPoint2D()
	{
	super();
	System.out.println("Dans GPoint2D()");
	info = new InfoPoint();
	}

/**
* Construit et initialise le point avec les coordonnes (0; 0) et avec les informations par dfaut.  
* @param OIJ rep, le repre.
* @since Opale 0.1
*/
public GPoint2D(OIJ rep)
	{
	super(rep);
	info = new InfoPoint();
	}

/**
* Construit et initialise le point avec les coordonnes (x; y) et avec les informations par dfaut.  
* @param OIJ rep, le repre.
* @param double x,y les coordonnes du point.
* @since Opale 0.1
*/
public GPoint2D(OIJ rep,double x, double y)
	{
	super(rep,x,y);
	info = new InfoPoint();
	}

/**
* Construit et initialise le point  partir d'un Point2D et avec les informations par dfaut.  
* @param Point2D p le point
* @since Opale 0.1
*/
public GPoint2D(Point2D p)
	{
	super(p);
	info = new InfoPoint();
	}


/**
* Le constructeur de copie
* @param Point2D p, le point  copier
*/
public GPoint2D(GPoint2D p)
	{
	super(p);
	info = new InfoPoint((InfoPoint) p.getInfo());
	}


//definition des methodes de l'interface GObject2D

public void draw(Pen2D c)
	{
	if ( info.isVisible())
		{
		int symb = info.symbol;
		int taille = info.size;
		c.setColor(info.getColor());
		if ( symb == 0 )	//on dessine un pixel
		  c.drawPoint(x,y);
		else if ( symb == 1)	//on dessine une croix +
		  c.drawPlus(x,y,taille);
		else if ( symb == 2)	//on dessine un X      
		  c.drawX(x,y,taille);
		else if ( symb == 3)	//on dessine un cercle      
		  c.drawCircle(x,y,taille);
		else if ( symb == 4)	//on dessine un carr       
		  c.drawSquare(x,y,taille);
		else if ( symb == 5)	//on dessine un diamant       
		  c.drawDiamond(x,y,taille);
		else if ( symb == 6)	//on dessine un triangle haut
		  c.drawTriangleUp(x,y,taille);
		else if ( symb == 7)	//on dessine un triangle bas
		  c.drawTriangleDown(x,y,taille);
		else if ( symb == 8)	//on dessine un triangle gauche
		  c.drawTriangleLeft(x,y,taille);
		else if ( symb == 9)	//on dessine un triangle droit
		  c.drawTriangleRight(x,y,taille);
		}	
	}
	


public InfoObject getInfo()
	{
	return info;
	}



/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	try
		{
		GPoint2D p = (GPoint2D) super.clone();
		p.info = (InfoPoint) info.clone();
		return p;
		}
	catch (InternalError e) // ne devrait jamais arriver
		{
		throw e;
		}
    }

public int readKeyWord(String word, RFile f, Pack2D p) throws java.io.IOException, MalformedFileException
	{
	if ( word.equals("INFO"))
		{
		info.readFile(f,p);
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeFileMore(WFile f, Pack2D p)
	{
	info.writeFile(f,p);
	super.writeFileMore(f,p);
	}	

}


