/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;

/**
* 
* @version Opale 0.11
* @author O.C.
*/

public class Matrix2D
{
private double[][] mat;

public Matrix2D()
	{
	mat = new double[3][3];
	mat[2][2] = 1;
	mat[2][0] = 0;
	mat[2][1] = 0;
	}

public void set(double[][] m)
	{
	mat[0][0] = m[0][0];
	mat[1][0] = m[1][0];
	mat[1][1] = m[1][1];
	mat[0][1] = m[0][1];
	mat[2][2] = 1;
	mat[2][0] = 0;
	mat[2][1] = 0;
	}
	
public void set(int i, int j, double x)
	{
	if ( (i>=0) && ( i<2) && (j>=0) && ( j<3) )
		mat[i][j] = x;
	}
	
public double get(int i, int j)
	{
	if ( (i>=0) && ( i<2) && (j>=0) && ( j<3) )
		return mat[i][j];
	else return -1;
	}
	
public void setV(int i, double x)
	{
	if ( (i>=0) && ( i<2))
	 mat[i][2] = x;
	}

	
public double getV(int i)
	{
	if ( (i>=0) && ( i<2))
	 return mat[i][2];
	else return -1;
	}


/**
* Calcule les coordonnes du point aprs multiplication par la matrice.
* @param double xf, yf, le point.
* @return double[], le rsultat.
* @since Opale 0.11
*/
public double[] compute(double xf, double yf)
	{
	double[] x = new double[2];
	
	x[0] = mat[0][0]*xf + mat[0][1]*yf + mat[0][2];
	x[1] = mat[1][0]*xf + mat[1][1]*yf +  mat[1][2];
	return x;
	}
	
public String toString()
	{
	return "Matrice 2D \n"+ mat[0][0] +"\t" +mat[0][1] +"\t" +mat[0][2]+ "\n"+mat[1][0] +"\t"
	+mat[1][1] +"\t"+mat[1][2]+"\n" +mat[2][0] +"\t"
	+mat[2][1] +"\t"+mat[2][2] +"\n";
	}

/**
* Cette mthode teste si le point est gal  un objet pass en argument.
* @param Object obj un objet  comparer avec le point.
* @return <code>true</code> si l'objet  comparer est une instance de Point2D et
est gal au point courant; <code>false</code> sinon.
* @since Opale 0.1
*/
public boolean equals(Object obj)
	{
	if (obj instanceof Matrix2D)
		{
        	Matrix2D p = (Matrix2D) obj;
		return (mat[0][0]  == p.mat[0][0]) && (mat[0][1]  == p.mat[0][1]) && (mat[0][2]  == p.mat[0][2]) && (mat[1][0]  == p.mat[1][0]) && (mat[1][1]  == p.mat[1][1]) && (mat[1][2]  == p.mat[1][2]) && (mat[2][0]  == p.mat[2][0]) && (mat[2][1]  == p.mat[2][1]) && (mat[2][2]  == p.mat[2][2]);
        	}
    	return false;
    } 
}
	
	
