/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;

/**
* Cette interface assure qu'une classe possde des mthodes de transformation gomtrique.
* @author O.C.
* version 0.1
*/

public interface Transformable
{

/**
* Translate l'objet graphique du vecteur(dx, dy).
* @param double dx,dy, coordones du vecteur de translation.
* @since Opale 0.1
*/
public void translate(double dx,double dy);


/**
* Rotate l'objet graphique de l'angle theta autour de l'origine
* @param double theta, l'angle de rotation en radian
* @since Opale 0.1
*/
public void rotate(double theta);

/**
* Rotate l'objet graphique de l'angle theta autour d'un point
* @param double oriX, double oriY, le centre de la rotation
* @param double theta, l'angle de rotation en radian
* @since Opale 0.1
*/
public void rotate(double oriX, double oriY,double theta);

}