/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import opale.m2d.ker.*;
import opale.tools.*;
import opale.mathtools.*;

/**
* Cette classe tend <code>yFx</code> et reprsente graphiquemnet une fonction y =f(x).
* @version 0.1
* @author O.C.
*/

public class GyFx extends yFx implements Cloneable, GObject2D
{
private InfoData info; 
private boolean maxdraw=false;


/**
* Constructeur par dfaut.
* @since Opale 0.1
*/
public GyFx()
	{
	super();
	System.out.println("Dans GyFx()");
	info = new InfoData();
	}

/**
* Construit et initialise la fonction avec les informations par dfaut.  
* @param OIJ rep, le repre.
* @since Opale 0.1
*/
public GyFx(OIJ rep)
	{
	super(rep);
	info = new InfoData();
	}


/**
* Le constructeur de copie
* @param GyFx d, l'objet  copier.
* @since Opale 0.1
*/
public GyFx(GyFx f)
	{
	super(f);	
	info = f.info;
	maxdraw = f.maxdraw;
	}

public void draw(Pen2D c)
	{

	double[] x = new double[N];
	double[] y = new double[N];
	int i;
	double sup, inf;
	
	if (maxdraw)
		{
		sup = c.getCoordSyst().getXmax();
		inf = c.getCoordSyst().getXmin();
		}
	else 
		{
		sup = xsup;
		inf = xinf;
		}
	double pas = Math.abs(sup-inf)/(N-1);
	
	for (i=0;i<N;i++)
		{
		x[i] = inf + i*pas;
		y[i] = val(x[i]);
		}
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
		if ( info.getTypeGraph() == 0)
			for (i=0;i<N-1;i++)
				c.drawLine(x[i],y[i],x[i+1],y[i+1]);
		else if  ( info.getTypeGraph() == 1)
			{}
		else  if  (info.getTypeGraph() == 2)		
			for (i=0;i<N;i++)
				c.drawLine(x[i],0,x[i],y[i]);
		else  if  (info.getTypeGraph() == 3)		
			for (i=0;i<N;i++)
				c.drawLine(0,y[i],x[i],y[i]);
		else if  ( info.getTypeGraph() == 4) 
			for (i=0;i<N;i++)
				{
				c.drawLine(x[i],0,x[i],y[i]);
				c.drawLine(0,y[i],x[i],y[i]);
				}
		int symb = info.getStylePoint();
		int taille = info.getSizePoint();
		if (symb == 1)
			for (i=0;i<N;i++)
				c.drawPoint(x[i],y[i]);
		else if (symb == 2)			
			for (i=0;i<N;i++)
				c.drawPlus(x[i],y[i],taille);
		else if ( symb == 3)	//on dessine un X      
			for (i=0;i<N;i++)
				c.drawX(x[i],y[i],taille);
		else if ( symb == 4)	//on dessine un cercle      
			for (i=0;i<N;i++)
				c.drawCircle(x[i],y[i],taille);
		else if ( symb == 5)	//on dessine un carr       
			for (i=0;i<N;i++)
				c.drawSquare(x[i],y[i],taille);
		else if ( symb == 6)	//on dessine un diamant       
			for (i=0;i<N;i++)
				c.drawDiamond(x[i],y[i],taille);
		else if ( symb == 7)	//on dessine un triangle haut
			for (i=0;i<N;i++)
				c.drawTriangleUp(x[i],y[i],taille);
		else if ( symb == 8)	//on dessine un triangle bas
			for (i=0;i<N;i++)
				c.drawTriangleDown(x[i],y[i],taille);
		else if ( symb == 9)	//on dessine un triangle gauche
			for (i=0;i<N;i++)
				c.drawTriangleLeft(x[i],y[i],taille);
		else if ( symb == 10)	//on dessine un triangle droit
			for (i=0;i<N;i++)
				c.drawTriangleRight(x[i],y[i],taille);
		}



	}
	
	
/**
* Indique si on dsire tracer la fonction dans toute la fenetre d'affichage ou juste dans le domaine xinf, xsup choisi.
* @param boolean, true si on trace dans toute la fenetre.
* @since Opale 0.11
*/
public void maxdraw(boolean b)
	{
	maxdraw = b;
	}
	
public InfoObject getInfo()
	{
	return info;
	}
	
public int readKeyWord(String word, RFile f, Pack2D p) throws java.io.IOException, MalformedFileException
	{
	if ( word.equals("INFO"))
		{
		info.readFile(f,p);
		return 0;
		}
	else if ( word.equals("maxdraw"))
		{
		maxdraw = true;
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeFileMore(WFile f, Pack2D p)
	{
	info.writeFile(f,p);
	if (maxdraw)
		f.writeln("maxdraw");
	super.writeFileMore(f,p);
	}	

	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	GyFx gy = (GyFx) super.clone();
	return gy;
	}

}
