/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import opale.m2d.ker.InfoObject;

/**
* Classe contenant des informations sur les objets de type <code>GLine2D</code>. Elle tend la classe <code>InfoObjet</code> et renseigne donc sur les champs contenus dans cette dernire.
* @author O.C.
* @version 0.1
*/
public class InfoLine extends InfoObject implements Cloneable
{
//membres privs
private short style;	//le style de trac
private short size;	//l'paisseur de la ligne

//les constructeurs publiques
/**
* Constructeur par dfaut: style = 0; size = 1;
*/
public InfoLine()
	{
	super();
	style = 0;
	size = 1;
	}

/**
* Le constructeur de copie
* @param InfoLine inf, l'information  copier
*/
public InfoLine(InfoLine inf)
	{
	super(inf);
	style = inf.getStyle();
	size = inf.getSize();
	}


//methodes d'accs, publiques

/**
* Renvoie l'entier dfinissant le style de trac.
* @return short le style de trac 
* 0 = ligne pleine
* 1 = pointill
*/
public short getStyle()
	{
	return style;
	}

/**
* change le style de la ligne.
* @param short le nouveau style
*/
public void setStyle(short s)
	{
	style = s;
	}

/**
* Renvoie l'paisseur en pixel de la ligne
* @return short, la taille 
*/
public short getSize()
	{
	return size;
	}

/**
* change l'paisseur de la ligne.
* @param short size, la nouvelle paisseur en pixel
*/
public void setSize(short size)
	{
	this.size = size;
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	try
	{
	return (InfoLine) super.clone();
    }
	catch(InternalError e)
	{
	throw e;
	}
	}

}
