package opale.soya;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.awt.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import opale.soya.editor.*;
import opale.soya.soya3d.Vector;
import java.util.*;
import java.beans.*;

/**
 * Creates the shapes for the GUI editor's handles.
 * 
 * @author Artiste ont he Web
 */

class HandlesBuilder extends Object {
  public static void main (String args[]) {
    System.out.println("Debut");
    Soya.init();
    
    Material.path = "/home/aonw/materials/";
    Shape.path = "/home/aonw/shapes/";
    
    Shape s;
    
    s = buildCube("redcube"   , 1f, 0f, 0f, 1f);
    s = buildCube("greencube" , 0f, 1f, 0f, 1f);
    s = buildCube("bluecube"  , 0f, 0f, 1f, 1f);
    s = buildCube("yellowcube", 1f, 1f, 0f, 1f);
    s = buildCube("greenalphacube", 0f, 1f, 0f, .4f);
    s = buildCubeWireframed("grayalphacube", .3f, .3f, .3f, 1f);
    
    try { Thread.currentThread().sleep(1000); }
    catch (InterruptedException e) {  }

    System.out.println("Fin");
  }

  private static FragmentedShape buildCube(String name, float r, float g, float b, float a) {
    FragmentedShape s = new FragmentedShape();
    float[] color = { r, g, b, a };
    float[] whiteColor = { 1f, 1f, 1f, 1f };
    Material m            = new Material((Texture) null, 1f, color, color);
    Material m_wireframed = new Material((Texture) null, 1f, color, color);
    m_wireframed.setWireframed(true);
    m_wireframed.setOverlayed (true);
    
    System.out.println("Before lock");
    s.lock();
    System.out.println("After lock");
    addCubeInto(s, false, m);
    System.out.println("Cube added");
    addCubeInto(s, true , m_wireframed);
    s.unlock();
    System.out.println("After unlock");
    
    try { s.save(Shape.path + name + ".shape"); } // No name.
    catch(Exception e) { e.printStackTrace(); }
    
    return s;
  }
  private static FragmentedShape buildCubeWireframed(String name, float r, float g, float b, float a) {
    FragmentedShape s = new FragmentedShape();
    float[] color = { r, g, b, a };
    float[] whiteColor = { 1f, 1f, 1f, 1f };
    Material m = new Material((Texture) null, 1f, color, color);
    m.setWireframed(true);
    m.setOverlayed (true);
    
    s.lock();
    addCubeInto(s, true , m);
    s.unlock();
    
    try { s.save(Shape.path + name + ".shape"); } // No name.
    catch(Exception e) { e.printStackTrace(); }
    
    return s;
  }
  private static void addCubeInto(FragmentedShape s, boolean spc, Material m) {
    Quad q;

    q = new Quad(new Point(-.5f, -.5f, -.5f),
                 new Point(-.5f,  .5f, -.5f),
                 new Point( .5f,  .5f, -.5f),
                 new Point( .5f, -.5f, -.5f),
                 m);
    if(spc) q.setVisibility(FaceVisibility.VISIBILITY_ALL);
    else    q.setVisibility(FaceVisibility.VISIBILITY_EXTERIOR);
    s.add(q);
    q = new Quad(new Point(-.5f, -.5f,  .5f),
                 new Point(-.5f,  .5f,  .5f),
                 new Point( .5f,  .5f,  .5f),
                 new Point( .5f, -.5f,  .5f),
                 m);
    if(spc) q.setVisibility(FaceVisibility.VISIBILITY_ALL);
    else    q.setVisibility(FaceVisibility.VISIBILITY_EXTERIOR);
    s.add(q);
    
    q = new Quad(new Point(-.5f, -.5f, -.5f),
                 new Point(-.5f,  .5f, -.5f),
                 new Point(-.5f,  .5f,  .5f),
                 new Point(-.5f, -.5f,  .5f),
                 m);
    if(spc) q.setVisibility(FaceVisibility.VISIBILITY_ALL);
    else    q.setVisibility(FaceVisibility.VISIBILITY_EXTERIOR);
    s.add(q);
    q = new Quad(new Point( .5f, -.5f, -.5f),
                 new Point( .5f,  .5f, -.5f),
                 new Point( .5f,  .5f,  .5f),
                 new Point( .5f, -.5f,  .5f),
                 m);
    if(spc) q.setVisibility(FaceVisibility.VISIBILITY_ALL);
    else    q.setVisibility(FaceVisibility.VISIBILITY_EXTERIOR);
    s.add(q);
    
    q = new Quad(new Point(-.5f, -.5f, -.5f),
                 new Point( .5f, -.5f, -.5f),
                 new Point( .5f, -.5f,  .5f),
                 new Point(-.5f, -.5f,  .5f),
                 m);
    if(spc) q.setVisibility(FaceVisibility.VISIBILITY_ALL);
    else    q.setVisibility(FaceVisibility.VISIBILITY_EXTERIOR);
    s.add(q);
    q = new Quad(new Point(-.5f,  .5f, -.5f),
                 new Point( .5f,  .5f, -.5f),
                 new Point( .5f,  .5f,  .5f),
                 new Point(-.5f,  .5f,  .5f),
                 m);
    if(spc) q.setVisibility(FaceVisibility.VISIBILITY_ALL);
    else    q.setVisibility(FaceVisibility.VISIBILITY_EXTERIOR);
    s.add(q);
  }
  private static FragmentedShape buildCube_Old(String name, float r, float g, float b) {
    FragmentedShape s = new FragmentedShape();
    float[] color = { r, g, b, 1f };
    float[] whiteColor = { 1f, 1f, 1f, 1f };
    Material m = new Material((Texture) null, 1f, color, color);

    s.lock();

    s.add(new Quad(new Point(-.5f, -.5f, -.5f),
                   new Point(-.5f,  .5f, -.5f),
                   new Point( .5f,  .5f, -.5f),
                   new Point( .5f, -.5f, -.5f),
                   m));
    s.add(new Quad(new Point(-.5f, -.5f,  .5f),
                   new Point(-.5f,  .5f,  .5f),
                   new Point( .5f,  .5f,  .5f),
                   new Point( .5f, -.5f,  .5f),
                   m));

    s.add(new Quad(new Point(-.5f, -.5f, -.5f),
                   new Point(-.5f,  .5f, -.5f),
                   new Point(-.5f,  .5f,  .5f),
                   new Point(-.5f, -.5f,  .5f),
                   m));
    s.add(new Quad(new Point( .5f, -.5f, -.5f),
                   new Point( .5f,  .5f, -.5f),
                   new Point( .5f,  .5f,  .5f),
                   new Point( .5f, -.5f,  .5f),
                   m));

    s.add(new Quad(new Point(-.5f, -.5f, -.5f),
                   new Point( .5f, -.5f, -.5f),
                   new Point( .5f, -.5f,  .5f),
                   new Point(-.5f, -.5f,  .5f),
                   m));
    s.add(new Quad(new Point(-.5f,  .5f, -.5f),
                   new Point( .5f,  .5f, -.5f),
                   new Point( .5f,  .5f,  .5f),
                   new Point(-.5f,  .5f,  .5f),
                   m));
    
    s.setVisibility(FaceVisibility.VISIBILITY_EXTERIOR);
    s.unlock();
    
    s.setName(name);
    
    try { s.save(); }
    catch(Exception e) { e.printStackTrace(); }
    
    return s;
  }

  public static Shape loadCube() {
    Shape s = null;
    try { s = Shape.get("redcube"); }
    catch(Exception e) { e.printStackTrace(); }
    return s;
  }
}

