package opale.soya;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.awt.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import opale.soya.editor.*;
import opale.soya.soya3d.Vector;
import java.util.*;
import java.beans.*;
import java.io.*;

/**
 * Rebuilds all the shapes.
 * 
 * @author Artiste ont he Web
 */

class RebuildAllShape extends Object {
  public static void main (String args[]) {
    Soya.init();
    
    Shape   .path = "/home/aonw/shapes/"   ;
    Material.path = "/home/aonw/materials/";
    
    File[] f = (new File(Shape.path)).listFiles();
    for(int i = 0; i < f.length; i++) {
      String filename = f[i].getName();
      filename = filename.substring(0, filename.length() - ".shape".length());
      
      System.out.println();
      System.out.println("Loading " + filename + "...");
      
      Shape s = null;
      try { s = Shape.get(filename); }
      catch(Exception e) { e.printStackTrace(); }
      if(s != null) {
        System.out.println("Rebuilding " + s.getName() + "...");
        if(s instanceof FragmentedShape) ((FragmentedShape) s).size();
        s.lock();
        s.unlock();
        s.optimize();
        try { s.save(); }
        catch(Exception e) { e.printStackTrace(); }
        System.out.println("done.");
      }
    }
    
    System.out.println("End.");
  }
}

