/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya;

import opale.soya.awt.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.Vector;
import opale.soya.soya3d.animation.*;
import opale.soya.util.Matrix;
import gl4java.*;
import gl4java.utils.glut.*;
import gl4java.utils.glut.fonts.*;
import java.util.*;
import java.io.*;

/**
 * Contains static definition for many internal (and often dirty hackish :-,) methods.
 * 
 * @author Artiste on the Web
 */

public class Soya extends Object {
  private Soya() {  }

  /**
   * Loads an object from a serialized file. File extension should be .ser .
   * @param fileName the fileName
   * @return the object
   */
  public static Object load(String fileName) throws java.io.IOException, java.lang.ClassNotFoundException {
    Object o;
    ObjectInputStream i = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));
    o = i.readObject();
    i.close();
    return o;
  }


  /**
   * This method can determine if a String matches a pattern of wildcards
   * @param pattern The pattern used for comparison
   * @param string The String to be checked
   * @return true if <code>string</code> matches <code>pattern</code>
   */
  public static boolean match(String pattern, String string) {
    for (int p = 0; ; p++) {
      for (int s = 0; ; p++, s++) {
        boolean sEnd = (s >= string.length());
        boolean pEnd = (p >= pattern.length() || pattern.charAt(p) == '|');
        if (sEnd && pEnd) return true;
        if (sEnd || pEnd) break;

        if (pattern.charAt(p) == '?') continue;
        if (pattern.charAt(p) == '*') {
          int i;
          p++;
          for (i = string.length(); i >= s; --i) {
            if (match(pattern.substring(p), string.substring(i))) return true;
          }
          break;
        }
        if (pattern.charAt(p) != string.charAt(s)) break;
      }
      p = pattern.indexOf('|', p);
      if (p == -1) return false;
    }
  }
  
  /**
   * The root gl of the GL context (the one where soya stocks all its textures and display
   * lists). It is defined when calling init.
   * @see opale.soya.Soya#init
   */
	public static GLFunc  gl ;
  /**
   * The root glu of the GL context (the one where soya stocks all its textures and display
   * lists). It is defined when calling init.
   * @see opale.soya.Soya#init
   */
	public static GLUFunc glu;

  private static final Map glToGlut = new HashMap();
  /**
   * Gets a glut for the given gl and glu.
   * @return a glut (GLUTFunc)
   */
  public static GLUTFunc getGLUT(GLFunc gl, GLUFunc glu) {
    GLUTFunc glut = (GLUTFunc) glToGlut.get(gl);
    if(glut == null) {
      glut = new GLUTFuncLightImplWithFonts(gl, glu);
      glToGlut.put(gl, glut);
    }
    return glut;
  }
  /**
   * Gets a glut for the root gl and glu.
   * @return a glut (GLUTFunc)
   */
  public static GLUTFunc getGLUT() { return getGLUT(gl, glu); }
  /*
  public static GLUTFunc getGLUT() {
    GLContext c = mustShareWith();
    return getGLUT(c.getGLFunc(), c.getGLUFunc());
  }
  */
  
  /**
   * Makes the root GL context current.
   */
	public static void makeRootGLContextCurrent() {
		if(rootGLContext.gljMakeCurrent() == false) System.out.println("Can't make root GL context current!");
	}
  
  private static int[] textureIDsToRelease = new int[100];
  private static int textureIDsToReleaseIndex;
  /**
   * Deletes a openGL texture ID as soon as possible.
   * @param id the texture ID to delete
   */
  public static synchronized void releaseTextureID(int id) {
    if(textureIDsToReleaseIndex >= textureIDsToRelease.length - 1) {
      int[] t = new int[textureIDsToRelease.length + 100];
      System.arraycopy(textureIDsToRelease, 0, t, 0, textureIDsToRelease.length);
      textureIDsToRelease = t;
    }
    textureIDsToRelease[textureIDsToReleaseIndex++] = id;
  }
  
  private static int[] callListIDsToRelease = new int[100];
  private static int callListIDsToReleaseIndex;
  /**
   * Deletes an openGL call list as soon as possible.
   * @param id the openGL call list ID
   */
  public static synchronized void releaseCallListID(int id) {
    if(callListIDsToReleaseIndex >= callListIDsToRelease.length - 1) {
      int[] t = new int[callListIDsToRelease.length + 100];
      System.arraycopy(callListIDsToRelease, 0, t, 0, callListIDsToRelease.length);
      callListIDsToRelease = t;
    }
    callListIDsToRelease[callListIDsToReleaseIndex++] = id;
  }
  
  /**
   * Releases the ID registered for releasment (by release*ID). Called when rendering; DO
   * NOT call by yourself !!!
   */
  public static synchronized void releaseIDs() {
    if(textureIDsToReleaseIndex > 0) {
      gl.glDeleteTextures(textureIDsToReleaseIndex, textureIDsToRelease);
      textureIDsToReleaseIndex = 0;
    }
    if(callListIDsToReleaseIndex > 0) {
      for(int i = 0; i < callListIDsToReleaseIndex; i++) {
        gl.glDeleteLists(callListIDsToRelease[i], 1);
      }
      callListIDsToReleaseIndex = 0;
    }
  }
  
  
	private static GLContext rootGLContext;
  /**
   * Gets the root GL context. It is always defined (as soon as soya is initialized), and
   * soya uses it to create all its display lists and textures.
   * @return the root GL context
   */
	public static GLContext getRootGLContext() { return rootGLContext; }
	private static boolean initialized;
  /**
   * Checks if soya is initialized.
   * @return true if initialized
   */
	public static boolean isInitialized() { return initialized; }
  /**
   * Inits soya. A new GL context is created and become the root GL context.
   */
	public static synchronized void init() {
		if(!initialized) {
			RenderingFrame rf = new RenderingFrame("soya : root GL context", 100, 100);
			rf.createGLContext();
			init(rf.getGLContext());
		}
	}
  /*
	public static synchronized void init(java.awt.Component c) {
		if(!initialized) {
      GLContext.gljClassDebug  = true;
      GLContext.gljNativeDebug = true;
      GLContext offScreen = GLContext.createOffScreenCtx(c, GLContext.createGLFunc(GLContext.defGLFuncClass), GLContext.createGLUFunc(GLContext.defGLUFuncClass), false, true, 0, null, new java.awt.Dimension(1, 1));
      if(offScreen == null) System.out.println("offscreen == null !!!");
      init(offScreen);
		}
	}
  */
  /**
   * Inits soya with the given root GL context. If you already have a GL context (for
   * example in a RenderingCanvas) and you know that this context will be alive all the
   * application life, use rather this method than init(), and use this GL context as
   * argument.
   * @param newRootGLContext the future root GL context
   */
	public static synchronized void init(GLContext newRootGLContext) {
		if(!initialized) {
			rootGLContext = newRootGLContext;
			gl  = rootGLContext.getGLFunc ();
			glu = rootGLContext.getGLUFunc();
			initialized = true;
		}
	}
  /**
   * Inits soya with the GL context from a rendering surface. If you already have a
   * RenderingSurface and you know that this surface will be alive all the application life,
   * use rather this method than init().
   * @param rs the rendering surface
   */
	public static synchronized void init(RenderingSurface rs) {
		synchronized(rs) {
			rs.createGLContext();
			init(rs.getGLContext());
		}
	}
  /**
   * Uninitializes soya.
   * If you want to use again soya after this, you must re-init soya.
   * Notice that it is not an obligation to terminate soya at this end of your application.
   */
	public static synchronized void terminate() {
		rootGLContext = null;
		gl  = null;
		glu = null;
		initialized = false;
	}
  
  public static void checkError(GLFunc gl, GLUFunc glu) {
    int error = gl.glGetError();
    if(error != 0) {
      try { throw (RuntimeException) (new GLErrorException("Error : " + Integer.toString(error) + " : " + glu.gluErrorString(error))); }
      catch(Exception e) { e.printStackTrace(); }
    }
  }
  public static void checkError(GLFunc gl, GLUFunc glu, String message) {
    int error = gl.glGetError();
    if(error != 0) {
      System.out.println(message);
      try { throw (RuntimeException) (new GLErrorException("Error : " + Integer.toString(error) + " : " + glu.gluErrorString(error))); }
      catch(Exception e) { e.printStackTrace(); }
    }
  }
  
  /*
  private static java.util.Collection registeredContexts = new java.util.Vector();
  public static void registerContext(GLContext c) {
    invalidateCallListAndTexture();
    registeredContexts.add(c);
  }
  public static void unregisterContext(GLContext c) {
    System.out.println("UNREGISTERING...");
    registeredContexts.remove(c);
    invalidateCallListAndTexture();
  }
  public static GLContext mustShareWith() {
    if(registeredContexts.isEmpty()) return null;
    return (GLContext) registeredContexts.iterator().next();
  }
  
  public static interface ContextReinitListener extends java.util.EventListener {
    public void reinitGL();
  }
  
  private static java.util.Collection contextReinitListeners = new java.util.Vector();
  public static void addContextReinitListener(ContextReinitListener l) { contextReinitListeners.add(l); }
  public static void removeContextReinitListener(ContextReinitListener l) { contextReinitListeners.remove(l); }
  private static void invalidateCallListAndTexture() {
    int size;
    Object[] ls;
    synchronized (contextReinitListeners) {
      size = contextReinitListeners.size();
      ls = contextReinitListeners.toArray();
    }
    for (int i = 0; i < size; i++) ((ContextReinitListener) ls[i]).reinitGL();
  }
  */
}
