package opale.soya.aq;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya3d.*;
import java.lang.Math;

/**
 * Tests math method. OK if prints (quite) only "true". A few false (3-4) can be normal.
 * 
 * @author Artiste on the Web
 */

public class Hack {
  public static void main(String[] args) {
    World3D w = new World3D();
    Volume3D vol = new Volume3D();
    float[] m;
    float[] q;
    float[] n;
    
    w.add(vol);
    vol.lookAt(new Point(-.6625f, -.2243f, .69591f, w));
    vol.rotateIncline(152.22f);
    
    m = vol.getMatrix();
    System.out.println(Matrix.matrixToString(m));
    
    q = Quaternion.quaternionFromMatrix(m);
    System.out.println(Quaternion.quaternionToString(q));
    n = Quaternion.matrixFromQuaternion(q);
    System.out.println(Matrix.matrixToString(n));
    
    
    float[] m4 = { 0.5840519f, 0.43883955f, 0.6689605f, 0f,
                   0.457667f, -0.8239062f, 0.17118518f, 0f,
                   0.6562235f, 0.21490304f, -0.6691525f, 0f,
                   0f, 0f, 0f, 1f,
                  };
    System.out.println(Matrix.matrixToString(m4));
    
    q = Quaternion.quaternionFromMatrix(m4);
    System.out.println(Quaternion.quaternionToString(q));
    n = Quaternion.matrixFromQuaternion(q);
    System.out.println(Matrix.matrixToString(n));
    
    System.out.println();
    System.out.println();
    System.out.println();
    
    
    float[] q2 = { -0.87708473f, -0.2555359f, -0.37772405f, 0.012461126f };
    System.out.println(Quaternion.quaternionToString(q2));
    
    /*
    float l = (float) Math.sqrt((double) (q2[0] * q2[0] + q2[1] * q2[1] + q2[2] * q2[2] + q2[3] * q2[3]));
    System.out.println(l);
    q2[0] = q2[0] / l;
    q2[1] = q2[1] / l;
    q2[2] = q2[2] / l;
    q2[3] = q2[3] / l;
    */
    //Quaternion.quaternionNormalize(q2);
    
    System.out.println(Quaternion.quaternionToString(q2));
    
    float[] m2 = Quaternion.matrixFromQuaternion(q2);
    System.out.println(Matrix.matrixToString(m2));
    
    q2 = Quaternion.quaternionFromMatrix(m2);
    System.out.println(Quaternion.quaternionToString(q2));
    
    /*
      Quaternion {-0.87708473, -0.2555359, -0.37772405, 0.012461126}
      
      devient :
      
      Quaternion {0.8987305, 0.2061292, 0.3654972, 0.12730291}
      
      
      In editor = Quaternion {-0.42248407, -0.12308916, -0.18194607, 0.8793474}
      
      matrix 4_4 {
      0.5840519 0.457667 0.6562235
      0.43883955 -0.8239062 0.21490304
      0.6689605 0.17118518 -0.6691525
      0.0 0.0 0.0
      X: -0.80125386 Y: 1.600009 Z: 0.11995262 W: 1.0
      }
      
      
      matrix 4_4 {
      0.90348935 0.423994 -0.06273763
      -0.21598119 0.5768057 0.7878117
      0.37021488 -0.6982294 0.61271256
      0.0 0.0 0.0
      X: -0.80125386 Y: 1.600009 Z: 0.11995262 W: 1.0
    */
  }
}
