package opale.soya.aq;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya3d.*;
import java.lang.Math;

/**
 * Tests frame coordinate conversion system. OK if prints only "true".
 * 
 * @author Artiste on the Web
 */

public class TestFrameConvertion {
  public static void main(String[] args) {
    System.out.println("Testing From conversion...");
    for(int i = 0; i < 100; i++) testFrom();
    System.out.println("Testing To conversion...");
    for(int i = 0; i < 100; i++) testTo();
  }
  public static void testFrom() {
    World3D[] w = new World3D[5];
    w[0] = new World3D();
    for(int i = 1; i < 5; i++) {
      w[i] = new World3D();
      w[i - 1].add(w[i]);
      w[i].move(rnd(), rnd(), rnd());
      w[i].rotateLateral (rnd() * 180f);
      w[i].rotateVertical(rnd() * 180f);
      w[i].rotateIncline (rnd() * 180f);
      w[i].scale(rnd(), rnd(), rnd());
    }
    Position p  = new Point(rnd(), rnd(), rnd(), w[4]);
    Position p2 = p.clone(w[0]);
    
    float[] p2xyz = { p2.getX(), p2.getY(), p2.getZ() };
    float[] xyz = { p.getX(), p.getY(), p.getZ() };
    
    for(int i = 4; i > 0; i--) {
      float[] m = w[i].getMatrix();
      xyz = Matrix.pointMultiplyByMatrix(m, xyz);
    }
    
    float l = ((xyz[0] - p2xyz[0]) * (xyz[0] - p2xyz[0]) + 
               (xyz[1] - p2xyz[1]) * (xyz[1] - p2xyz[1]) + 
               (xyz[2] - p2xyz[2]) * (xyz[2] - p2xyz[2]));
    System.out.println(l < .0000000001f);
  }
  public static void testTo() {
    World3D[] w = new World3D[5];
    w[0] = new World3D();
    for(int i = 1; i < 5; i++) {
      w[i] = new World3D();
      w[i - 1].add(w[i]);
      w[i].move(rnd(), rnd(), rnd());
      w[i].rotateLateral (rnd() * 180f);
      w[i].rotateVertical(rnd() * 180f);
      w[i].rotateIncline (rnd() * 180f);
    }
    Position p  = new Point(rnd(), rnd(), rnd(), w[0]);
    Position p2 = p.clone(w[4]);
    
    float[] p2xyz = { p2.getX(), p2.getY(), p2.getZ() };
    float[] xyz = { p.getX(), p.getY(), p.getZ() };
    
    for(int i = 1; i < 5; i++) {
      float[] m = Matrix.matrixInvert(w[i].getMatrix());
      xyz = Matrix.pointMultiplyByMatrix(m, xyz);
    }
    
    float l = ((xyz[0] - p2xyz[0]) * (xyz[0] - p2xyz[0]) + 
               (xyz[1] - p2xyz[1]) * (xyz[1] - p2xyz[1]) + 
               (xyz[2] - p2xyz[2]) * (xyz[2] - p2xyz[2]));
    System.out.println(l < .00001f);
  }
	public static float rnd() { return ((float) Math.random()) - 0.5f; }
}
