package opale.soya.aq;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya3d.*;
import java.lang.Math;

/**
 * Tests looakAt method. OK if prints (quite) only "true". A few false (3-4) can be normal.
 * 
 * @author Artiste on the Web
 */

public class TestLookAt {
  public static void main(String[] args) {
    System.out.println("Testing lookAt lateral part...");
    testLookAtLat();
    System.out.println("Testing lookAt...");
    testLookAt();
  }
  public static void testLookAtLat() {
    World3D  w = new World3D ();
    Volume3D v = new Volume3D();
    w.add(v);
    
    for(int i = 0; i < 100; i++) {
      v.resetOrientation();
      Position p = new Point(rnd(), 0f, rnd(), w);
      v.lookAt(p);
      
      Position p2 = p.clone(v);
      
      float lx = p2.getX();
      if(lx < 0f) lx = -lx;
      float ly = p2.getY();
      if(ly < 0f) ly = -ly;
      float lz = p2.getZ();
      System.out.println((lx < .0001f) && (ly < .0001f) && (lz < 0f));
    }
  }
  public static void testLookAt() {
    World3D  w = new World3D ();
    Volume3D v = new Volume3D();
    w.add(v);
    
    for(int i = 0; i < 100; i++) {
      v.resetOrientation();
      Position p = new Point(rnd(), rnd(), rnd(), w);
      v.lookAt(p);
      
      Position p2 = p.clone(v);
      
      float lx = p2.getX();
      if(lx < 0f) lx = -lx;
      float ly = p2.getY();
      if(ly < 0f) ly = -ly;
      float lz = p2.getZ();
      System.out.println((lx < .0001f) && (ly < .0001f) && (lz < 0f));
    }
  }
	public static float rnd() { return (((float) Math.random()) - .5f) * 100f; }
}
