package opale.soya.aq;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya3d.*;
import java.lang.Math;

/**
 * Tests rotation method. OK if prints only "true".
 * 
 * @author Artiste on the Web
 */

public class TestRotation {
  public static void main(String[] args) {
    System.out.println("Testing rotation...");
    for(int i = 0; i < 100; i++) testRotation();
  }
  public static void testRotation() {
    World3D root = new World3D();
    World3D w = new World3D();
    Volume3D v = new Volume3D();
    root.add(w);
    w.add(v);
    
    Vector translation = new Vector(rnd(), rnd(), rnd(), root);
    v.addVector(translation);
    
    Position p1 = v.clone(root);
    Position p2 = v.clone(v);
    
    Vector axe = new Vector(rnd(), rnd(), rnd(), root);
    float angle = rnd() * 180f;
    
    w.rotate(axe, angle);
    
    float[] xyz   = { p1.getX(), p1.getY(), p1.getZ() };
    Position o    = root.origin();
    float[]  os   = { o.getX(), o.getY(), o.getZ() };
    float[]  axes = { axe.getX(), axe.getY(), axe.getZ() };
    xyz = Matrix.pointMultiplyByMatrix(Matrix.matrixRotate(angle, os, axes), xyz);
    p1 = new Point(xyz[0], xyz[1], xyz[2]);
    p2 = p2.clone(root);
    
    System.out.println(p1.distanceTo(p2) < 0.0001f);
  }
	public static float rnd() { return ((float) Math.random()) - .5f; }
}
