/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.awt;

import opale.soya.*;
import opale.soya.soya2d.*;
import gl4java.*;

/**
 * An overlay that shows an image. The image can be tranparent or alpha blended.
 * 
 * @author Artiste on the Web
 */

public abstract class ImageOverlay extends Overlay {
  public ImageOverlay(RenderingSurface rs) { super(rs); }

  /**
   * Creates and returns a new image overlay.
   * @param rs the rendering surface over whicth you want to draw an image
   * @return an image overlay
   */
  public static ImageOverlay newImageOverlay(RenderingSurface rs) { // No support for hardware overlay at this time.
    // TODO : try hardware overlay here.
    return new SoftwareImageOverlay(rs);
  }
  /**
   * Creates and returns a new image overlay.
   * @param rs the rendering surface over whicth you want to draw an image
   * @param image the overlayed image
   * @return an image overlay
   */
  public static ImageOverlay newImageOverlay(RenderingSurface rs, Image image) {
    ImageOverlay io = newImageOverlay(rs);
    io.setImage(image);
    return io;
  }

  private Image image;
  /**
   * Gets the image.
   * @return the overlayed image
   */
  public Image getImage() { return image; }
  /**
   * Sets the image.
   * @param newImage the new overlayed image
   */
  public void setImage(Image newImage) { image = newImage; }
}
